/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.mongodb.runtime;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import org.anyline.dao.init.springjdbc.FixDao;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.mongodb.runtime.MongoRuntime;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.proxy.RuntimeHolderProxy;
import org.anyline.service.init.FixService;
import org.anyline.util.ConfigTable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.stereotype.Component;

@Component(value="anyline.data.runtime.holder.mongo")
public class MongoRuntimeHolder
extends RuntimeHolder {
    public MongoRuntimeHolder() {
        RuntimeHolderProxy.reg(MongoClient.class, (RuntimeHolder)this);
    }

    public DataRuntime temporary(String key, Object datasource, String database, DriverAdapter adapter) throws Exception {
        MongoRuntime runtime = new MongoRuntime();
        if (!(datasource instanceof MongoClient)) {
            throw new Exception("\u8bf7\u63d0\u4f9b:com.mongodb.client.MongoClient");
        }
        runtime.setKey(key);
        runtime.setAdapter(adapter);
        MongoClient client = (MongoClient)datasource;
        runtime.setClient(client);
        MongoDatabase db = client.getDatabase(database);
        runtime.setDatabase(db);
        log.warn("[\u6ce8\u518c\u6570\u636e\u6e90][key:{}][type:{}]", (Object)key, (Object)datasource.getClass().getSimpleName());
        return runtime;
    }

    public DataRuntime regTemporary(String key, Object datasource, String database, DriverAdapter adapter) throws Exception {
        return this.temporary(key, datasource, database, adapter);
    }

    public static void reg(String key) {
        String datasource_key = "anyline.datasource." + key;
        String database_key = "anyline.database." + key;
        MongoClient client = (MongoClient)factory.getBean(datasource_key, MongoClient.class);
        MongoDatabase database = (MongoDatabase)factory.getBean(database_key, MongoDatabase.class);
        MongoRuntimeHolder.reg(key, client, database, null);
    }

    public static void reg(String key, DataRuntime runtime) {
        runtimes.put(key, runtime);
    }

    public static void reg(String datasource, MongoClient client, MongoDatabase database, DriverAdapter adapter) {
        log.info("[create mongo runtime][key:{}]", (Object)datasource);
        MongoRuntime runtime = new MongoRuntime(datasource, client, database, adapter);
        if (runtimes.containsKey(datasource)) {
            MongoRuntimeHolder.destroy(datasource);
        }
        runtimes.put(datasource, runtime);
        if (!ConfigTable.IS_MULTIPLE_SERVICE) {
            return;
        }
        String dao_key = "anyline.dao." + datasource;
        String service_key = "anyline.service." + datasource;
        log.info("[instance service][data source:{}][instance id:{}]", (Object)datasource, (Object)service_key);
        BeanDefinitionBuilder daoBuilder = BeanDefinitionBuilder.genericBeanDefinition(FixDao.class);
        daoBuilder.addPropertyValue("runtime", (Object)runtime);
        daoBuilder.addPropertyValue("datasource", (Object)datasource);
        daoBuilder.setLazyInit(true);
        AbstractBeanDefinition daoDefinition = daoBuilder.getBeanDefinition();
        factory.registerBeanDefinition(dao_key, (BeanDefinition)daoDefinition);
        BeanDefinitionBuilder serviceBuilder = BeanDefinitionBuilder.genericBeanDefinition(FixService.class);
        serviceBuilder.addPropertyValue("datasource", (Object)datasource);
        serviceBuilder.addPropertyReference("dao", dao_key);
        serviceBuilder.setLazyInit(true);
        AbstractBeanDefinition serviceDefinition = serviceBuilder.getBeanDefinition();
        factory.registerBeanDefinition(service_key, (BeanDefinition)serviceDefinition);
    }

    public static void destroyRuntime(String key) {
        MongoRuntimeHolder.destroy(key);
    }

    public static void destroy(String key) {
        try {
            runtimes.remove(key);
            if (factory.containsBeanDefinition("anyline.service." + key)) {
                factory.destroySingleton("anyline.service." + key);
                factory.removeBeanDefinition("anyline.service." + key);
            }
            if (factory.containsBeanDefinition("anyline.dao." + key)) {
                factory.destroySingleton("anyline.dao." + key);
                factory.removeBeanDefinition("anyline.dao." + key);
            }
            if (factory.containsBeanDefinition("anyline.datasource." + key)) {
                factory.destroySingleton("anyline.datasource." + key);
                factory.removeBeanDefinition("anyline.datasource." + key);
            }
            if (factory.containsBeanDefinition("anyline.database." + key)) {
                factory.destroySingleton("anyline.database." + key);
                factory.removeBeanDefinition("anyline.database." + key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exeDestroy(String key) {
        MongoRuntimeHolder.destroy(key);
    }

    public static MongoDatabase getDatabase(String key) {
        DataRuntime runtime = MongoRuntimeHolder.getRuntime((String)key);
        if (null != runtime) {
            return (MongoDatabase)runtime.getProcessor();
        }
        return null;
    }
}

