/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.mongodb.runtime;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import java.util.HashMap;
import java.util.Map;
import org.anyline.data.mongodb.runtime.MongoRuntimeHolder;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.ClientHolder;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.SpringContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.env.Environment;

public class MongoClientHolder
extends ClientHolder {
    private static Logger log = LoggerFactory.getLogger(MongoClientHolder.class);

    private static String addDataSource(String key, String ds, boolean over) throws Exception {
        if (dataSources.contains(key)) {
            if (!over) {
                throw new Exception("[\u91cd\u590d\u6ce8\u518c][thread:" + Thread.currentThread().getId() + "][key:" + key + "]");
            }
            MongoRuntimeHolder.destroy(key);
        }
        if (ConfigTable.IS_DEBUG && log.isInfoEnabled()) {
            log.info("[\u521b\u5efa\u6570\u636e\u6e90][thread:{}][key:{}]", (Object)Thread.currentThread().getId(), (Object)key);
        }
        MongoClientHolder.reg((String)key);
        MongoRuntimeHolder.reg(key);
        return ds;
    }

    private static MongoDatabase addDataSource(String key, MongoDatabase ds, boolean over) throws Exception {
        if (dataSources.contains(key)) {
            if (!over) {
                throw new Exception("[\u91cd\u590d\u6ce8\u518c][thread:" + Thread.currentThread().getId() + "][key:" + key + "]");
            }
            MongoRuntimeHolder.destroy(key);
        }
        if (ConfigTable.IS_DEBUG && log.isInfoEnabled()) {
            log.info("[\u521b\u5efa\u6570\u636e\u6e90][thread:{}][key:{}]", (Object)Thread.currentThread().getId(), (Object)key);
        }
        MongoClientHolder.reg((String)key);
        MongoRuntimeHolder.reg(key);
        return ds;
    }

    public static String reg(String key, String uri, String database, String user, String password) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("uri", uri);
        param.put("database", database);
        param.put("user", user);
        param.put("password", password);
        return MongoClientHolder.reg(key, param);
    }

    public static String reg(String key, Map param, boolean over) throws Exception {
        return MongoClientHolder.addDataSource(key, MongoClientHolder.reg(key, param), over);
    }

    public static String reg(String key, Map param) throws Exception {
        String ds = MongoClientHolder.build(key, param);
        if (null == ds) {
            return null;
        }
        return MongoClientHolder.addDataSource(key, ds, true);
    }

    public static MongoDatabase reg(String key, MongoDatabase ds, boolean over) throws Exception {
        return MongoClientHolder.addDataSource(key, ds, over);
    }

    public static MongoDatabase reg(String key, MongoDatabase ds) throws Exception {
        return MongoClientHolder.addDataSource(key, ds, true);
    }

    public static String parseDatabase(String uri) {
        String database = null;
        if (null != uri && uri.contains(":")) {
            String[] tmps = uri.split(":");
            if ((tmps = tmps[tmps.length - 1].split("/")).length > 1) {
                database = tmps[tmps.length - 1];
            }
        }
        return database;
    }

    public static String reg(String key, String prefix, Environment env) {
        try {
            String uri;
            if (BasicUtil.isNotEmpty((Object)prefix) && !prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            if (BasicUtil.isEmpty((Object)(uri = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"url", "uri"})))) {
                return null;
            }
            if (!uri.startsWith("mongodb:")) {
                return null;
            }
            String database = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"database"});
            if (BasicUtil.isEmpty((Object)database)) {
                database = MongoClientHolder.parseDatabase(uri);
            }
            if (BasicUtil.isEmpty((Object)database)) {
                log.warn("\u7f3a\u5c11Mongo\u6570\u636e\u5e93\u540d");
                return null;
            }
            String username = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"user", "username", "user-name"});
            String password = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"password"});
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("uri", uri);
            map.put("database", database);
            map.put("user", username);
            map.put("username", username);
            map.put("password", password);
            String client = MongoClientHolder.build(key, map);
            if (null == client) {
                return null;
            }
            MongoClientHolder.addDataSource(key, client, false);
            return client;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String build(String key, Map params) throws Exception {
        MongoClient client = null;
        MongoDatabase db = null;
        String datasource_id = "anyline.datasource." + key;
        String database_id = "anyline.database." + key;
        try {
            String uri = (String)BeanUtil.propertyNvl((Map)params, (String[])new String[]{"url", "uri"});
            if (BasicUtil.isEmpty((Object)uri)) {
                return null;
            }
            if (!uri.startsWith("mongodb:")) {
                return null;
            }
            String database = (String)BeanUtil.propertyNvl((Map)params, (String[])new String[]{"database"});
            if (BasicUtil.isEmpty((Object)database)) {
                database = MongoClientHolder.parseDatabase(uri);
            }
            if (BasicUtil.isEmpty((Object)database)) {
                log.warn("\u7f3a\u5c11Mongo\u6570\u636e\u5e93\u540d");
                return null;
            }
            Object user = BeanUtil.propertyNvl((Map)params, (String[])new String[]{"user", "username"});
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.putAll(params);
            map.put("uri", uri);
            map.put("database", database);
            map.put("user", user);
            map.put("username", user);
            DefaultListableBeanFactory factory = (DefaultListableBeanFactory)SpringContextUtil.getApplicationContext().getAutowireCapableBeanFactory();
            client = MongoClients.create((String)uri);
            db = client.getDatabase(database);
            factory.registerSingleton(datasource_id, (Object)client);
            factory.registerSingleton(database_id, (Object)db);
        }
        catch (Exception e) {
            log.error("[\u6ce8\u518c\u6570\u636e\u6e90\u5931\u8d25][\u6570\u636e\u6e90:{}][msg:{}]", (Object)key, (Object)e.toString());
            return null;
        }
        return datasource_id;
    }

    public static boolean validate(String ds) {
        return MongoClientHolder.validate(MongoRuntimeHolder.getRuntime((String)ds));
    }

    public static boolean validate() {
        return MongoClientHolder.validate(MongoRuntimeHolder.getRuntime());
    }

    public static boolean validate(DataRuntime runtime) {
        MongoDatabase database = (MongoDatabase)runtime.getProcessor();
        return MongoClientHolder.validate(database);
    }

    public static boolean validate(MongoDatabase database) {
        try {
            database.getName();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

