/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.mongodb.listener;

import com.mongodb.client.MongoDatabase;
import org.anyline.data.mongodb.runtime.MongoClientHolder;
import org.anyline.data.mongodb.runtime.MongoRuntimeHolder;
import org.anyline.listener.EnvironmentListener;
import org.anyline.util.SpringContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component(value="anyline.listener.mongo.EnvironmentListener")
public class MongoEnvironmentListener
implements ApplicationContextAware {
    public static Logger log = LoggerFactory.getLogger(EnvironmentListener.class);
    private static ApplicationContext context;
    private static DefaultListableBeanFactory factory;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
        factory = (DefaultListableBeanFactory)context.getAutowireCapableBeanFactory();
        SpringContextUtil.init((ApplicationContext)context);
        MongoRuntimeHolder.init((DefaultListableBeanFactory)factory);
        int qty = this.load("spring.datasource");
        this.load((qty += this.load("anyline.datasource")) > 0);
    }

    private void load(boolean multiple) {
        MongoDatabase database = (MongoDatabase)SpringContextUtil.getBean(MongoDatabase.class);
        if (null == database || multiple) {
            // empty if block
        }
    }

    private int load(String head) {
        int qty = 0;
        Environment env = context.getEnvironment();
        String prefixs = env.getProperty(head + ".list");
        if (null == prefixs) {
            prefixs = env.getProperty(head + "-list");
        }
        if (null != prefixs) {
            for (String prefix : prefixs.split(",")) {
                try {
                    String client = MongoClientHolder.reg(prefix, head + "." + prefix, env);
                    if (null == client) continue;
                    ++qty;
                    log.info("[\u521b\u5efa\u6570\u636e\u6e90][prefix:{}][client:{}]", (Object)prefix, (Object)client);
                }
                catch (Exception e) {
                    log.error("[\u521b\u5efa\u6570\u636e\u6e90\u5931\u8d25][prefix:{}][msg:{}]", (Object)prefix, (Object)e.toString());
                }
            }
        }
        return qty;
    }
}

