/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.mongodb.adapter;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.adapter.EntityAdapter;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.init.DefaultDriverAdapter;
import org.anyline.data.mongodb.entity.MongoDataRow;
import org.anyline.data.mongodb.runtime.MongoRuntime;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.AutoCondition;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.TableRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.exception.SQLQueryException;
import org.anyline.exception.SQLUpdateException;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Column;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.proxy.InterceptorProxy;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.bson.conversions.Bson;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.adapter.mongo")
public class MongoAdapter
extends DefaultDriverAdapter
implements DriverAdapter {
    public DatabaseType type() {
        return DatabaseType.MongoDB;
    }

    public boolean exists(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return false;
    }

    public long insert(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        return super.insert(runtime, random, batch, dest, data, configs, checkPrimary, columns);
    }

    protected Run createInsertRun(DataRuntime runtime, String dest, Object obj, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        Object pv;
        TableRun run = new TableRun(runtime, dest);
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""));
        if (null != generator && null == (pv = BeanUtil.getFieldValue((Object)obj, (String)"_id"))) {
            ArrayList<String> pk = new ArrayList<String>();
            pk.add("_id");
            generator.create(obj, DatabaseType.MongoDB, dest, pk, null);
        }
        run.setValue(obj);
        return run;
    }

    protected Run createInsertRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore confis, boolean checkPrimary, List<String> columns) {
        TableRun run = new TableRun(runtime, dest);
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""));
        if (null != generator) {
            Object item;
            Object pv;
            ArrayList<String> pk = new ArrayList<String>();
            pk.add("_id");
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && null == (pv = BeanUtil.getFieldValue(item = iterator.next(), (String)"_id"))) {
                generator.create(item, DatabaseType.MongoDB, dest, pk, null);
            }
        }
        run.setValue((Object)list);
        return run;
    }

    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks) {
        long cnt;
        block18: {
            cnt = 0L;
            Object value = run.getValue();
            String collection = run.getTable();
            if (null == value) {
                if (ConfigTable.IS_LOG_SQL && log.isWarnEnabled()) {
                    log.warn("[valid:false][action:insert][collection:{}][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]", (Object)run.getTable());
                }
                return -1L;
            }
            MongoRuntime rt = (MongoRuntime)runtime;
            MongoDatabase database = rt.getDatabase();
            long fr = System.currentTimeMillis();
            try {
                MongoCollection cons = null;
                if (value instanceof List) {
                    List list = (List)value;
                    cons = database.getCollection(run.getTable(), list.get(0).getClass());
                    cnt = list.size();
                    cons.insertMany(list);
                } else if (value instanceof DataSet) {
                    DataSet set = (DataSet)value;
                    cons = database.getCollection(run.getTable(), ConfigTable.DEFAULT_MONGO_ENTITY_CLASS);
                    cons.insertMany(set.getRows());
                    cnt = set.size();
                } else if (value instanceof EntitySet) {
                    List datas = ((EntitySet)value).getDatas();
                    cons = database.getCollection(run.getTable(), datas.get(0).getClass());
                    cons.insertMany(datas);
                    cnt = datas.size();
                } else if (value instanceof Collection) {
                    Collection items = (Collection)value;
                    ArrayList list = new ArrayList();
                    for (Object item : items) {
                        list.add(item);
                        ++cnt;
                    }
                    cons = database.getCollection(run.getTable(), list.get(0).getClass());
                    cons.insertMany(list);
                } else {
                    cons = database.getCollection(run.getTable(), value.getClass());
                    cons.insertOne(value);
                    cnt = 1L;
                }
                long millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = this.SLOW_SQL_MILLIS(configs);
                if (SLOW_SQL_MILLIS > 0L && this.IS_LOG_SLOW_SQL(configs) && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:insert][collection:{}][\u6267\u884c\u8017\u65f6:{}ms][collection:{}]", new Object[]{random, run.getTable(), millis, collection});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.INSERT, run, null, null, null, true, (Object)cnt, millis);
                    }
                }
                if (!slow && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[action:insert][collection:{}][\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, run.getTable(), millis, LogUtil.format((long)cnt, (int)34)});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    SQLUpdateException ex = new SQLUpdateException("insert\u5f02\u5e38:" + e, e);
                    throw ex;
                }
                if (!ConfigTable.IS_LOG_SQL_WHEN_ERROR) break block18;
                log.error("{}[{}][collection:{}][param:{}]", new Object[]{random, LogUtil.format((String)"\u63d2\u5165\u5f02\u5e38:", (int)33) + e, run.getTable(), BeanUtil.object2json((Object)data)});
            }
        }
        return cnt;
    }

    public long save(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        return 0L;
    }

    public Run buildQueryRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        TableRun run = null;
        if (!(prepare instanceof TablePrepare)) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u67e5\u8be2\u7684\u7c7b\u578b");
        }
        run = new TableRun(runtime, prepare.getTable());
        if (null != run) {
            run.setRuntime(runtime);
            run.setPrepare(prepare);
            run.setConfigStore(configs);
            run.addCondition(conditions);
            if (run.checkValid()) {
                run.init();
                this.fillQueryContent(runtime, (Run)run);
            }
        }
        return run;
    }

    protected void fillQueryContent(DataRuntime runtime, TableRun run) {
        ConfigStore configs;
        List queryColumns;
        ConfigStore configs2;
        Bson bson = null;
        ConditionChain chain = run.getConditionChain();
        bson = this.parseCondition(bson, chain);
        run.setFilter((Object)bson);
        List excludeColumns = run.getPrepare().getExcludeColumns();
        if ((null == excludeColumns || excludeColumns.isEmpty()) && null != (configs2 = run.getConfigStore())) {
            excludeColumns = configs2.columns();
        }
        if (null != excludeColumns && excludeColumns.size() > 0) {
            run.setExcludeColumns(excludeColumns);
        }
        if ((null == (queryColumns = run.getPrepare().getQueryColumns()) || queryColumns.isEmpty()) && null != (configs = run.getConfigStore())) {
            queryColumns = configs.columns();
        }
        if (null != queryColumns && queryColumns.size() > 0) {
            run.setQueryColumns(queryColumns);
        }
    }

    private Bson parseCondition(Bson bson, Condition condition) {
        if (condition instanceof ConditionChain) {
            ConditionChain chain = (ConditionChain)condition;
            bson = this.parseCondition(bson, chain);
        } else if (condition instanceof AutoCondition) {
            AutoCondition auto = (AutoCondition)condition;
            List values = auto.getValues();
            String column = condition.getId();
            String join = condition.getJoin();
            Bson create = this.bson(auto.getCompare(), column, values);
            if (null != create) {
                bson = "or".equalsIgnoreCase(join) ? Filters.or((Bson[])new Bson[]{create}) : Filters.and((Bson[])new Bson[]{create});
            }
        }
        return bson;
    }

    private Bson parseCondition(Bson bson, ConditionChain chain) {
        String join = chain.getJoin();
        Bson child = null;
        List conditions = chain.getConditions();
        for (Condition con : conditions) {
            child = this.parseCondition(child, con);
        }
        bson = null == bson ? child : ("or".equalsIgnoreCase(join) ? Filters.or((Bson[])new Bson[]{bson, child}) : Filters.and((Bson[])new Bson[]{bson, child}));
        return bson;
    }

    private Bson bson(Compare compare, String column, List<Object> values) {
        Bson bson = null;
        if (null != values && !values.isEmpty()) {
            ArrayList<Object> value = null;
            boolean multiple = compare.isMultipleValue();
            if (multiple) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.addAll(values);
                value = list;
            } else {
                value = values.get(0);
            }
            int cc = compare.getCode();
            if (cc == 10) {
                bson = Filters.eq((String)column, value);
            } else if (cc == 50 || cc == 999) {
                bson = Filters.regex((String)column, (String)((Object)value).toString());
            } else if (cc == 51) {
                bson = Filters.regex((String)column, (String)("^" + value));
            } else if (cc == 52) {
                bson = Filters.regex((String)column, (String)(value + "$"));
            } else if (cc == 20) {
                bson = Filters.gt((String)column, value);
            } else if (cc == 21) {
                bson = Filters.gte((String)column, value);
            } else if (cc == 30) {
                bson = Filters.lt((String)column, value);
            } else if (cc == 31) {
                bson = Filters.lte((String)column, value);
            } else if (cc == 40) {
                bson = Filters.in((String)column, (Object[])BeanUtil.list2array(values));
            } else if (cc == 80) {
                if (values.size() > 1) {
                    bson = Filters.and((Bson[])new Bson[]{Filters.gte((String)column, (Object)values.get(0)), Filters.lte((String)column, (Object)values.get(1))});
                }
            } else if (cc == 110) {
                bson = Filters.ne((String)column, value);
            } else if (cc == 140) {
                bson = Filters.nin((String)column, (Object[])BeanUtil.list2array(values));
            } else if (cc == 150 || cc == 151 || cc == 152) {
                // empty if block
            }
        }
        return bson;
    }

    public DataSet select(DataRuntime runtime, String random, boolean system, String table, ConfigStore configs, Run run) {
        DataSet set;
        block13: {
            long fr = System.currentTimeMillis();
            if (null == random) {
                random = this.random(runtime);
            }
            set = new DataSet();
            try {
                PageNavi navi;
                List excludeColumn;
                MongoRuntime rt = (MongoRuntime)runtime;
                MongoDatabase database = rt.getDatabase();
                Bson bson = (Bson)run.getFilter();
                if (null == bson) {
                    bson = Filters.empty();
                }
                if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                    log.info("{}[cmd:select][collection:{}][filter:{}]", new Object[]{random, run.getTable(), bson});
                }
                FindIterable rows = database.getCollection(run.getTable(), ConfigTable.DEFAULT_MONGO_ENTITY_CLASS).find(bson);
                ArrayList<Bson> fields = new ArrayList<Bson>();
                List queryColumns = run.getQueryColumns();
                if (null != queryColumns && queryColumns.size() > 0) {
                    fields.add(Projections.include((List)queryColumns));
                }
                if (null != (excludeColumn = run.getExcludeColumns()) && excludeColumn.size() > 0) {
                    fields.add(Projections.exclude((List)excludeColumn));
                }
                if (fields.size() > 0) {
                    rows.projection(Projections.fields(fields));
                }
                if (null != (navi = run.getPageNavi())) {
                    rows.skip((int)navi.getFirstRow()).limit(navi.getPageRows());
                }
                for (MongoDataRow row : rows) {
                    set.add((DataRow)row);
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, System.currentTimeMillis() - fr, set.size()});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38:" + e, e);
                    throw ex;
                }
                if (!ConfigTable.IS_LOG_SQL_WHEN_ERROR) break block13;
                log.error("{}[{}][cmd:select][collection:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), run.getTable()});
            }
        }
        return set;
    }

    public long count(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        Run run = this.buildQueryRun(runtime, prepare, configs, conditions);
        return this.count(runtime, random, run);
    }

    public long count(DataRuntime runtime, String random, Run run) {
        MongoRuntime rt = (MongoRuntime)runtime;
        MongoDatabase database = rt.getDatabase();
        Bson bson = (Bson)run.getFilter();
        if (null == bson) {
            bson = Filters.empty();
        }
        if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[cmd:select][collection:{}][filter:{}]", new Object[]{random, run.getTable(), bson});
        }
        return database.getCollection(run.getTable()).countDocuments(bson);
    }

    public List<Map<String, Object>> maps(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return null;
    }

    public List<Map<String, Object>> maps(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return null;
    }

    public Map<String, Object> map(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return null;
    }

    public DataRow sequence(DataRuntime runtime, String random, boolean next, String ... names) {
        return null;
    }

    public long execute(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return 0L;
    }

    public long execute(DataRuntime runtime, String random, int batch, ConfigStore configs, String sql, List<Object> values) {
        return 0L;
    }

    public long update(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, Run run) {
        long result = -1L;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        long fr = System.currentTimeMillis();
        log.info("{}[action:update][collection:{}][update:{}][filter:{}]", new Object[]{random, run.getTable(), run.getUpdate(), run.getFilter()});
        MongoRuntime rt = (MongoRuntime)runtime;
        MongoDatabase database = rt.getDatabase();
        MongoCollection cons = database.getCollection(run.getTable());
        UpdateResult dr = cons.updateMany((Bson)run.getFilter(), (Bson)run.getUpdate());
        result = dr.getMatchedCount();
        long millis = System.currentTimeMillis() - fr;
        boolean slow = false;
        long SLOW_SQL_MILLIS = this.SLOW_SQL_MILLIS(configs);
        if (SLOW_SQL_MILLIS > 0L && this.IS_LOG_SLOW_SQL(configs) && millis > SLOW_SQL_MILLIS) {
            slow = true;
            log.warn("{}[slow cmd][action:update][collection:{}][\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, run.getTable(), millis, LogUtil.format((long)result, (int)34)});
            if (null != this.dmListener) {
                this.dmListener.slow(runtime, random, ACTION.DML.UPDATE, run, null, null, null, true, (Object)result, millis);
            }
        }
        if (!slow && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
            log.info("{}[action:update][collection:{}][\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, run.getTable(), millis, LogUtil.format((long)result, (int)34)});
        }
        return result;
    }

    public long execute(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return 0L;
    }

    public boolean execute(DataRuntime runtime, String random, Procedure procedure) {
        return false;
    }

    public <T> long deletes(DataRuntime runtime, String random, int batch, String table, String key, Collection<T> values) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.and(key, values);
        return this.delete(runtime, random, table, (ConfigStore)configs, new String[0]);
    }

    public long delete(DataRuntime runtime, String random, String dest, ConfigStore configs, Object obj, String ... columns) {
        return super.delete(runtime, random, dest, configs, obj, columns);
    }

    public long delete(DataRuntime runtime, String random, String table, ConfigStore configs, String ... conditions) {
        return super.delete(runtime, random, table, configs, conditions);
    }

    public long truncate(DataRuntime runtime, String random, String table) {
        long result = -1L;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        long fr = System.currentTimeMillis();
        MongoRuntime rt = (MongoRuntime)runtime;
        MongoDatabase database = rt.getDatabase();
        MongoCollection cons = database.getCollection(table);
        DeleteResult dr = cons.deleteMany(Filters.empty());
        result = dr.getDeletedCount();
        long millis = System.currentTimeMillis() - fr;
        if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
            log.info("{}[action:truncate][collection:][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table, millis});
        }
        return result;
    }

    public DataSet querys(DataRuntime runtime, String random, Procedure procedure, PageNavi navi) {
        return null;
    }

    public DataSet querys(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.querys(runtime, random, prepare, configs, conditions);
    }

    public <T> EntitySet<T> selects(DataRuntime runtime, String random, RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return null;
    }

    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks, boolean simple) {
        return 0L;
    }

    public long update(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return super.update(runtime, random, batch, dest, data, configs, columns);
    }

    public Run buildUpdateRunFromEntity(DataRuntime runtime, String dest, Object obj, ConfigStore configs, boolean checkPrimary, LinkedHashMap<String, Column> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setFrom(2);
        LinkedHashMap<Object, Object> cols = new LinkedHashMap();
        ArrayList<Object> primaryKeys = new ArrayList<Object>();
        if (null != columns && columns.size() > 0) {
            cols = columns;
        } else {
            cols.putAll(EntityAdapterProxy.columns(obj.getClass(), (EntityAdapter.MODE)EntityAdapter.MODE.UPDATE));
        }
        if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
            primaryKeys.addAll(EntityAdapterProxy.primaryKeys(obj.getClass()).keySet());
        } else {
            primaryKeys = new ArrayList();
            primaryKeys.add("_id");
        }
        for (String string : primaryKeys) {
            if (columns.containsKey(string.toUpperCase())) continue;
            cols.remove(string.toUpperCase());
        }
        if (!columns.containsKey("_ID")) {
            cols.remove("_ID");
        }
        boolean isReplaceEmptyNull = ConfigTable.IS_REPLACE_EMPTY_NULL;
        cols = this.checkMetadata(runtime, dest, configs, cols);
        ArrayList<Bson> arrayList = new ArrayList<Bson>();
        if (!cols.isEmpty()) {
            for (Column column : cols.values()) {
                String key = column.getName();
                Object value = null;
                if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                    Field field = EntityAdapterProxy.field(obj.getClass(), (String)key);
                    value = BeanUtil.getFieldValue((Object)obj, (Field)field);
                } else {
                    value = BeanUtil.getFieldValue((Object)obj, (String)key);
                }
                if (null != value && value.toString().startsWith("${") && value.toString().endsWith("}")) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                    continue;
                }
                if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && isReplaceEmptyNull) {
                    value = null;
                }
                boolean chk = true;
                if (null == value) {
                    if (!ConfigTable.IS_UPDATE_NULL_FIELD) {
                        chk = false;
                    }
                } else if ("".equals(value) && !ConfigTable.IS_UPDATE_EMPTY_FIELD) {
                    chk = false;
                }
                if (!chk) continue;
                arrayList.add(Updates.set((String)key, (Object)value));
            }
            run.setUpdate((Object)Updates.combine(arrayList));
            if (null == configs) {
                configs = new DefaultConfigStore(new String[0]);
                for (String string : primaryKeys) {
                    if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                        Field field = EntityAdapterProxy.field(obj.getClass(), (String)string);
                        configs.and(string, BeanUtil.getFieldValue((Object)obj, (Field)field));
                        continue;
                    }
                    configs.and(string, BeanUtil.getFieldValue((Object)obj, (String)string));
                }
            }
            run.setConfigStore(configs);
            run.init();
            run.appendCondition();
        }
        run.setFilter((Object)this.parseCondition(null, run.getConditionChain()));
        return run;
    }

    public Run buildUpdateRunFromDataRow(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, boolean checkPrimary, LinkedHashMap<String, Column> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setFrom(1);
        LinkedHashMap cols = this.confirmUpdateColumns(runtime, dest, row, configs, BeanUtil.getMapKeys(columns));
        List primaryKeys = row.getPrimaryKeys();
        if (primaryKeys.size() == 0) {
            throw new SQLUpdateException("[\u66f4\u65b0\u66f4\u65b0\u5f02\u5e38][\u66f4\u65b0\u6761\u4ef6\u4e3a\u7a7a,update\u65b9\u6cd5\u4e0d\u652f\u6301\u66f4\u65b0\u6574\u8868\u64cd\u4f5c]");
        }
        for (String pk : primaryKeys) {
            if (columns.containsKey(pk.toUpperCase())) continue;
            cols.remove(pk.toUpperCase());
        }
        if (!columns.containsKey("_ID")) {
            cols.remove("_ID");
        }
        boolean replaceEmptyNull = row.isReplaceEmptyNull();
        ArrayList<Bson> updates = new ArrayList<Bson>();
        if (!cols.isEmpty()) {
            for (Column col : cols.values()) {
                String key = col.getName();
                Object value = row.get(key);
                if (null != value && value.toString().startsWith("${") && value.toString().endsWith("}")) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                } else if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && replaceEmptyNull) {
                    value = null;
                }
                updates.add(Updates.set((String)key, (Object)value));
            }
            run.setUpdate((Object)Updates.combine(updates));
            if (null == configs) {
                configs = new DefaultConfigStore(new String[0]);
                for (String pk : primaryKeys) {
                    configs.and(pk, row.get(pk));
                }
            }
            run.setConfigStore(configs);
            run.init();
            run.appendCondition();
            run.setFilter((Object)this.parseCondition(null, run.getConditionChain()));
        }
        return run;
    }

    public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, boolean checkPrimary, LinkedHashMap<String, Column> columns) {
        return null;
    }

    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        return null;
    }

    public RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value) {
        return null;
    }

    public Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value) {
        return null;
    }

    public StringBuilder createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value) {
        return null;
    }

    public Run buildDeleteRunFromTable(DataRuntime runtime, int batch, String table, String key, Object values) {
        if (null == key || null == values) {
            return null;
        }
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        if (values instanceof Collection) {
            Collection collection = (Collection)values;
            if (collection.isEmpty()) {
                return null;
            }
            configs.in(key, (Object)collection);
        } else {
            configs.and(key, values);
        }
        return this.buildDeleteRun(runtime, table, configs, new String[0]);
    }

    public Run buildDeleteRunFromEntity(DataRuntime runtime, String dest, Object obj, String ... columns) {
        if (null == obj) {
            return null;
        }
        if (null == columns || columns.length == 0) {
            columns = new String[]{"_id"};
        }
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        for (String column : columns) {
            configs.and(column, BeanUtil.getFieldValue((Object)obj, (String)column));
        }
        return this.buildDeleteRun(runtime, dest, configs, new String[0]);
    }

    public Run buildDeleteRun(DataRuntime runtime, int batch, String table, String key, Object values) {
        return this.buildDeleteRunFromTable(runtime, batch, table, key, values);
    }

    public Run buildDeleteRun(DataRuntime runtime, String dest, Object obj, String ... columns) {
        if (null == obj) {
            return null;
        }
        TableRun run = null;
        if (null == dest) {
            dest = DataSourceUtil.parseDataSource((String)dest, (Object)obj);
        }
        if (null == dest) {
            Table table;
            Object entity = obj;
            if (obj instanceof Collection) {
                entity = ((Collection)obj).iterator().next();
            }
            if (null != (table = EntityAdapterProxy.table(entity.getClass()))) {
                dest = table.getName();
            }
        }
        if (obj instanceof ConfigStore) {
            run = new TableRun(runtime, dest);
            DefaultTablePrepare prepare = new DefaultTablePrepare();
            prepare.setDataSource(dest);
            run.setPrepare((RunPrepare)prepare);
            run.setConfigStore((ConfigStore)obj);
            run.addCondition(columns);
            run.init();
            this.fillDeleteRunContent(runtime, (Run)run);
        } else {
            run = this.buildDeleteRunFromEntity(runtime, dest, obj, columns);
        }
        return run;
    }

    public List<Run> buildTruncateRun(DataRuntime runtime, String table) {
        ArrayList<Run> runs = new ArrayList<Run>();
        return runs;
    }

    public void fillDeleteRunContent(DataRuntime runtime, Run run) {
        if (null != run && run instanceof TableRun) {
            TableRun r = (TableRun)run;
            this.fillDeleteRunContent(runtime, r);
        }
    }

    protected void fillDeleteRunContent(DataRuntime runtime, TableRun run) {
        Bson bson = null;
        ConditionChain chain = run.getConditionChain();
        bson = this.parseCondition(bson, chain);
        run.setFilter((Object)bson);
    }

    public long delete(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        long result = -1L;
        boolean cmd_success = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        long fr = System.currentTimeMillis();
        swt = InterceptorProxy.beforeDelete((DataRuntime)runtime, (String)random, (Run)run);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeDelete(runtime, random, run);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        log.info("{}[action:delete][collection:{}][filter:{}]", new Object[]{random, run.getTable(), run.getFilter()});
        MongoRuntime rt = (MongoRuntime)runtime;
        MongoDatabase database = rt.getDatabase();
        MongoCollection cons = database.getCollection(run.getTable());
        DeleteResult dr = cons.deleteMany((Bson)run.getFilter());
        result = dr.getDeletedCount();
        cmd_success = true;
        long millis = System.currentTimeMillis() - fr;
        if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
            log.info("{}[action:delete][collection:{}][\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, run.getTable(), millis, LogUtil.format((long)result, (int)34)});
        }
        if (null != this.dmListener) {
            this.dmListener.afterDelete(runtime, random, run, cmd_success, result, millis);
        }
        InterceptorProxy.afterDelete((DataRuntime)runtime, (String)random, (Run)run, (boolean)cmd_success, (long)result, (long)millis);
        return result;
    }

    public void checkSchema(DataRuntime runtime, DataSource dataSource, Table table) {
    }

    public void checkSchema(DataRuntime runtime, Connection con, Table table) {
    }

    public void checkSchema(DataRuntime runtime, Table table) {
    }

    public LinkedHashMap<String, Database> databases(DataRuntime runtime, String random) {
        return null;
    }

    public Database database(DataRuntime runtime, String random, String name) {
        return null;
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, String catalog, String schema, String pattern, String types, boolean strut) {
        return null;
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, String catalog, String schema, String pattern, String types) {
        return null;
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, String catalog, String schema, String pattern, String types, boolean strut) {
        return null;
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, String catalog, String schema, String pattern, String types) {
        return null;
    }

    public List<String> ddl(DataRuntime runtime, String random, Table table, boolean init) {
        return null;
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, boolean greedy, String catalog, String schema, String pattern, String types) {
        return null;
    }

    public List<String> ddl(DataRuntime runtime, String random, View view) {
        return null;
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, String random, boolean greedy, String catalog, String schema, String pattern, String types) {
        return null;
    }

    public List<String> ddl(DataRuntime runtime, String random, MasterTable table) {
        return null;
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, String random, boolean greedy, MasterTable master, Map<String, Object> tags, String name) {
        return null;
    }

    public List<String> ddl(DataRuntime runtime, String random, PartitionTable table) {
        return null;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean greedy, Table table, boolean primary) {
        return null;
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, String catalog, String schema, String table) {
        return null;
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, String catalog, String schema) {
        return null;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        return null;
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, Table table, List<T> columns, DataSet set) throws Exception {
        return null;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String pattern) throws Exception {
        return null;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean create, Table table, LinkedHashMap<String, T> columns, List<Run> runs) {
        return null;
    }

    public Column column(DataRuntime runtime, Column column, ResultSetMetaData rsm, int index) {
        return null;
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, String random, boolean greedy, Table table) {
        return null;
    }

    public PrimaryKey primary(DataRuntime runtime, String random, boolean greedy, Table table) {
        return null;
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, String random, boolean greedy, Table table) {
        return null;
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, String random, boolean greedy, Table table, String name) {
        return null;
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, String random, boolean greedy, Table table, List<Trigger.EVENT> events) {
        return null;
    }

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, String random, boolean greedy, String catalog, String schema, String name) {
        return null;
    }

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, String random, boolean recover, String catalog, String schema, String name) {
        return null;
    }

    public String concat(DataRuntime runtime, String ... args) {
        return null;
    }
}

