/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.runtime;

import java.lang.reflect.Method;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.annotation.Component;
import org.anyline.bean.BeanDefine;
import org.anyline.bean.init.DefaultBeanDefine;
import org.anyline.bean.init.DefaultValueReference;
import org.anyline.dao.init.DefaultDao;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.runtime.JDBCRuntime;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.data.runtime.init.AbstractRuntimeHolder;
import org.anyline.service.init.DefaultService;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;

@Component(value="anyline.environment.data.runtime.holder.jdbc")
public class JDBCRuntimeHolder
extends AbstractRuntimeHolder
implements RuntimeHolder {
    private static final JDBCRuntimeHolder instance = new JDBCRuntimeHolder();

    public static JDBCRuntimeHolder instance() {
        return instance;
    }

    public DataRuntime temporary(Object datasource, String database, DriverAdapter adapter) throws Exception {
        JDBCRuntime runtime = new JDBCRuntime();
        if (!(datasource instanceof DataSource)) {
            throw new Exception("\u8bf7\u63d0\u4f9bjavax.sql.DataSource\u517c\u5bb9\u7c7b\u578b");
        }
        String key = "temporary_jdbc";
        JDBCRuntimeHolder.close(key);
        temporary.remove(key);
        runtimes.remove(key);
        runtime.setKey(key);
        runtime.setAdapter(adapter);
        runtime.setProcessor(datasource);
        temporary.put(key, datasource);
        log.warn("[\u521b\u5efa\u4e34\u65f6\u6570\u636e\u6e90][key:{}][type:{}]", (Object)key, (Object)datasource.getClass().getSimpleName());
        runtimes.put(key, runtime);
        return runtime;
    }

    public DataRuntime reg(String key, String datasource) {
        DataSource ds = (DataSource)ConfigTable.environment().getBean(datasource, DataSource.class);
        return this.reg(key, ds, null);
    }

    public DataRuntime reg(String key, DataSource datasource) {
        String datasource_key = "anyline.datasource." + key;
        ConfigTable.environment().regBean(datasource_key, (Object)datasource);
        return this.reg(key, datasource, null);
    }

    public JDBCRuntime reg(String datasource, DataSource ds, JDBCAdapter adapter) {
        log.debug("[create jdbc runtime][key:{}]", (Object)datasource);
        JDBCRuntime runtime = new JDBCRuntime(datasource, ds, adapter);
        if (runtimes.containsKey(datasource)) {
            this.destroy(datasource);
        }
        runtimes.put(datasource, runtime);
        String dao_key = "anyline.dao." + datasource;
        String service_key = "anyline.service." + datasource;
        log.debug("[instance service][data source:{}][instance id:{}]", (Object)datasource, (Object)service_key);
        DefaultBeanDefine daoDefine = new DefaultBeanDefine(DefaultDao.class);
        daoDefine.addValue("runtime", (Object)runtime);
        daoDefine.setLazy(true);
        ConfigTable.environment().regBean(dao_key, (BeanDefine)daoDefine);
        DefaultBeanDefine serviceDefine = new DefaultBeanDefine(DefaultService.class);
        serviceDefine.addValue("dao", (Object)new DefaultValueReference(dao_key));
        serviceDefine.setLazy(true);
        ConfigTable.environment().regBean(service_key, (BeanDefine)serviceDefine);
        return runtime;
    }

    public boolean destroy(String key) {
        try {
            runtimes.remove(key);
            ConfigTable.environment().destroyBean("anyline.service." + key);
            ConfigTable.environment().destroyBean("anyline.dao." + key);
            ConfigTable.environment().destroyBean("anyline.transaction." + key);
            ConfigTable.environment().destroyBean("anyline.jdbc.template." + key);
            JDBCRuntimeHolder.close("anyline.datasource." + key);
            ConfigTable.environment().destroyBean("anyline.datasource." + key);
            log.warn("[\u6ce8\u9500\u6570\u636e\u6e90\u53ca\u76f8\u5173\u8d44\u6e90][key:{}]", (Object)key);
            Map runtimes = RuntimeHolder.runtimes((String)key);
            for (String item : runtimes.keySet()) {
                this.destroy(item);
            }
        }
        catch (Exception e) {
            log.error("\u6ce8\u9500\u6570\u636e\u6e90 \u5f02\u5e38:", (Throwable)e);
            return false;
        }
        return true;
    }

    public static void close(String key) {
        Object datasource = null;
        if (ConfigTable.environment().containsBean(key)) {
            datasource = ConfigTable.environment().getBean(key);
            try {
                JDBCRuntimeHolder.closeConnection(datasource);
            }
            catch (Exception e) {
                log.error("close connection exception:", (Throwable)e);
            }
        }
        if (temporary.containsKey(key)) {
            try {
                JDBCRuntimeHolder.closeConnection(temporary.get(key));
            }
            catch (Exception e) {
                log.error("close connection exception:", (Throwable)e);
            }
        }
    }

    public static void closeConnection(Object datasource) throws Exception {
        Method method = ClassUtil.getMethod(datasource.getClass(), (String)"close", (Class[])new Class[0]);
        if (null != method) {
            method.invoke(datasource, new Object[0]);
        }
    }
}

