/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.adapter.init.reader;

import org.anyline.adapter.DataReader;
import org.anyline.data.jdbc.adapter.init.geometry.MySQLGeometryAdapter;
import org.anyline.metadata.type.init.StandardTypeMetadata;

public enum MySQLGenusReader {
    GeometryReader(new Object[]{StandardTypeMetadata.GEOMETRY}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MySQLGeometryAdapter.parse(bytes);
        }
    }),
    PointReader(new Object[]{StandardTypeMetadata.POINT}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MySQLGeometryAdapter.parsePoint(bytes);
        }
    }),
    LineReader(new Object[]{StandardTypeMetadata.LINESTRING}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MySQLGeometryAdapter.parseLine(bytes);
        }
    }),
    PolygonReader(new Object[]{StandardTypeMetadata.POLYGON}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MySQLGeometryAdapter.parsePolygon(bytes);
        }
    }),
    MultiPointReader(new Object[]{StandardTypeMetadata.MULTIPOINT}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MySQLGeometryAdapter.parseMultiPoint(bytes);
        }
    }),
    MultiLineReader(new Object[]{StandardTypeMetadata.MULTILINESTRING}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MySQLGeometryAdapter.parseMultiLine(bytes);
        }
    }),
    MultiPolygonReader(new Object[]{StandardTypeMetadata.MULTIPOLYGON}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MySQLGeometryAdapter.parseMultiPolygon(bytes);
        }
    }),
    GeometryCollectionReader(new Object[]{StandardTypeMetadata.GEOMETRYCOLLECTION}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MySQLGeometryAdapter.parseGeometryCollection(bytes);
        }
    });

    private final Object[] supports;
    private final DataReader reader;

    public Object[] supports() {
        return this.supports;
    }

    public DataReader reader() {
        return this.reader;
    }

    private MySQLGenusReader(Object[] supports, DataReader reader) {
        this.supports = supports;
        this.reader = reader;
    }
}

