/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.adapter.init.writer;

import org.anyline.adapter.DataWriter;
import org.anyline.data.jdbc.adapter.init.geometry.MySQLGeometryAdapter;
import org.anyline.entity.geometry.Geometry;
import org.anyline.entity.geometry.GeometryCollection;
import org.anyline.entity.geometry.LineString;
import org.anyline.entity.geometry.MultiLine;
import org.anyline.entity.geometry.MultiPoint;
import org.anyline.entity.geometry.MultiPolygon;
import org.anyline.entity.geometry.Point;
import org.anyline.entity.geometry.Polygon;
import org.anyline.metadata.type.init.StandardTypeMetadata;

public enum MySQLGenusWriter {
    PointWriter(new Object[]{Point.class, StandardTypeMetadata.POINT}, new DataWriter(){

        public Object write(Object value, boolean placeholder) {
            Integer[] xy;
            Point point = null;
            if (value instanceof Point) {
                point = (Point)value;
            } else if (value instanceof double[]) {
                double[] xy2 = (double[])value;
                if (xy2.length >= 2) {
                    point = new Point(Double.valueOf(xy2[0]), Double.valueOf(xy2[1]));
                }
            } else if (value instanceof Double[]) {
                Double[] xy3 = (Double[])value;
                if (xy3.length >= 2) {
                    point = new Point(xy3[0], xy3[1]);
                }
            } else if (value instanceof int[]) {
                int[] xy4 = (int[])value;
                if (xy4.length >= 2) {
                    point = new Point(xy4[0], xy4[1]);
                }
            } else if (value instanceof Integer[] && (xy = (Integer[])value).length >= 2) {
                point = new Point(xy[0], xy[1]);
            }
            if (null != point) {
                if (placeholder) {
                    return MySQLGeometryAdapter.wkb(point);
                }
                return MySQLGeometryAdapter.sql(point);
            }
            return value;
        }
    }),
    LineWriter(new Object[]{LineString.class, StandardTypeMetadata.LINESTRING}, new DataWriter(){

        public Object write(Object value, boolean placeholder) {
            if (value instanceof LineString) {
                LineString line = (LineString)value;
                if (placeholder) {
                    return MySQLGeometryAdapter.wkb(line);
                }
                return MySQLGeometryAdapter.sql((Geometry)line);
            }
            return value;
        }
    }),
    PolygonWriter(new Object[]{Polygon.class, StandardTypeMetadata.POLYGON}, new DataWriter(){

        public Object write(Object value, boolean placeholder) {
            if (value instanceof Polygon) {
                Polygon polygon = (Polygon)value;
                if (placeholder) {
                    return MySQLGeometryAdapter.wkb(polygon);
                }
                return MySQLGeometryAdapter.sql((Geometry)polygon);
            }
            return value;
        }
    }),
    MultiPointWriter(new Object[]{MultiPoint.class, StandardTypeMetadata.MULTIPOINT}, new DataWriter(){

        public Object write(Object value, boolean placeholder) {
            if (value instanceof MultiPoint) {
                MultiPoint multiPoint = (MultiPoint)value;
                if (placeholder) {
                    return MySQLGeometryAdapter.wkb(multiPoint);
                }
                return MySQLGeometryAdapter.sql((Geometry)multiPoint);
            }
            return value;
        }
    }),
    MultiLineWriter(new Object[]{MultiLine.class, StandardTypeMetadata.MULTILINESTRING}, new DataWriter(){

        public Object write(Object value, boolean placeholder) {
            if (value instanceof MultiLine) {
                MultiLine multiLine = (MultiLine)value;
                if (placeholder) {
                    return MySQLGeometryAdapter.wkb(multiLine);
                }
                return MySQLGeometryAdapter.sql((Geometry)multiLine);
            }
            return value;
        }
    }),
    MultiPolygonWriter(new Object[]{MultiPolygon.class, StandardTypeMetadata.MULTIPOLYGON}, new DataWriter(){

        public Object write(Object value, boolean placeholder) {
            if (value instanceof MultiPolygon) {
                MultiPolygon multiPolygon = (MultiPolygon)value;
                if (placeholder) {
                    return MySQLGeometryAdapter.wkb(multiPolygon);
                }
                return MySQLGeometryAdapter.sql((Geometry)multiPolygon);
            }
            return value;
        }
    }),
    GeometryCollectionWriter(new Object[]{GeometryCollection.class, StandardTypeMetadata.GEOMETRYCOLLECTION}, new DataWriter(){

        public Object write(Object value, boolean placeholder) {
            if (value instanceof GeometryCollection) {
                GeometryCollection collection = (GeometryCollection)value;
                if (placeholder) {
                    return MySQLGeometryAdapter.wkb(collection);
                }
                return MySQLGeometryAdapter.sql((Geometry)collection);
            }
            return value;
        }
    });

    private final Object[] supports;
    private final DataWriter writer;

    public Object[] supports() {
        return this.supports;
    }

    public DataWriter writer() {
        return this.writer;
    }

    private MySQLGenusWriter(Object[] supports, DataWriter writer) {
        this.supports = supports;
        this.writer = writer;
    }
}

