/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.datasource;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.adapter.init.ConvertAdapter;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.datasource.DataSourceKeyMap;
import org.anyline.data.datasource.DatasourceHolder;
import org.anyline.data.jdbc.runtime.JDBCRuntimeHolder;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.metadata.type.Convert;
import org.anyline.metadata.type.ConvertException;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.proxy.DatasourceHolderProxy;
import org.anyline.proxy.ServiceProxy;
import org.anyline.service.AnylineService;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.SpringContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Component(value="anyline.data.datasource.holder.jdbc")
public class JDBCDatasourceHolder
extends DatasourceHolder {
    private static Logger log = LoggerFactory.getLogger(JDBCDatasourceHolder.class);
    protected static Map<String, DataSource> caches = new HashMap<String, DataSource>();
    private static Map<TransactionStatus, String> transactionStatus = new Hashtable<TransactionStatus, String>();
    public static final String DATASOURCE_TYPE_DEFAULT = "com.zaxxer.hikari.HikariDataSource";

    public JDBCDatasourceHolder() {
        DatasourceHolderProxy.reg(DataSource.class, (DatasourceHolder)this);
        DatasourceHolderProxy.reg(JdbcTemplate.class, (DatasourceHolder)this);
        ConvertAdapter.reg((Convert)new Convert(){

            public Class getOrigin() {
                return String.class;
            }

            public Class getTarget() {
                return Driver.class;
            }

            public Object exe(Object value, Object def) throws ConvertException {
                if (null != value) {
                    try {
                        return Class.forName(value.toString()).newInstance();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        });
    }

    public static String reg(String key, String pool, String driver, String url, String user, String password) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("type", pool);
        param.put("driver", driver);
        param.put("url", url);
        param.put("user", user);
        param.put("password", password);
        return JDBCDatasourceHolder.reg(key, param);
    }

    public static String reg(String key, DatabaseType type, String url, String user, String password) throws Exception {
        return JDBCDatasourceHolder.reg(key, DATASOURCE_TYPE_DEFAULT, type.driver(), url, user, password);
    }

    public static String reg(String key, Map<String, Object> param, boolean override) throws Exception {
        String ds_id = JDBCDatasourceHolder.inject(key, param, override);
        return JDBCDatasourceHolder.init(key, ds_id, override);
    }

    public static String reg(String key, Map<String, Object> param) throws Exception {
        return JDBCDatasourceHolder.reg(key, param, true);
    }

    public static DataRuntime reg(String key, DataSource ds, boolean override) throws Exception {
        return JDBCDatasourceHolder.init(key, ds, override);
    }

    public static DataRuntime reg(String key, DataSource ds) throws Exception {
        return JDBCDatasourceHolder.init(key, ds, false);
    }

    public static DataRuntime reg(String key, DataSource ds, DatabaseType type, boolean override) throws Exception {
        DataRuntime runtime = JDBCDatasourceHolder.init(key, ds, override);
        if (null != runtime && null != type) {
            runtime.setAdapterKey(type.name());
        }
        return runtime;
    }

    public static DataRuntime reg(String key, DataSource ds, DatabaseType type) throws Exception {
        DataRuntime runtime = JDBCDatasourceHolder.init(key, ds, false);
        if (null != runtime && null != type) {
            runtime.setAdapterKey(type.name());
        }
        return runtime;
    }

    public static DataSource reg(String key, Connection connection, boolean override) {
        return null;
    }

    public static DataSource reg(String key, Connection connection) {
        return JDBCDatasourceHolder.reg(key, connection, false);
    }

    public static String reg(String key, String prefix, Environment env) {
        try {
            String url;
            String type;
            if (BasicUtil.isNotEmpty((Object)prefix) && !prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            if (null == (type = (String)JDBCDatasourceHolder.value((Environment)env, (String)prefix, (String)"type", String.class, null))) {
                type = (String)JDBCDatasourceHolder.value((Environment)env, (String)prefix.substring(0, prefix.length() - key.length() - 1), (String)"type", String.class, null);
            }
            if (type == null) {
                type = DATASOURCE_TYPE_DEFAULT;
            }
            if (BasicUtil.isEmpty((Object)(url = (String)JDBCDatasourceHolder.value((Environment)env, (String)prefix, (String)"url", String.class, null)))) {
                return null;
            }
            if (!url.startsWith("jdbc:")) {
                return null;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("type", type);
            String ds = JDBCDatasourceHolder.inject(key, prefix, map, env, true);
            if (null == ds) {
                return null;
            }
            JDBCDatasourceHolder.init(key, ds, false);
            return ds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String inject(String key, Map params, boolean over) throws Exception {
        return JDBCDatasourceHolder.inject(key, null, params, null, over);
    }

    private static String inject(String key, String prefix, Map params, Environment env, boolean override) throws Exception {
        HashMap<String, Object> cache = (HashMap<String, Object>)DatasourceHolder.params.get(key);
        if (null == cache) {
            cache = new HashMap<String, Object>();
            DatasourceHolder.params.put(key, cache);
        }
        JDBCDatasourceHolder.check((String)key, (boolean)override);
        String ds_id = "anyline.datasource." + key;
        try {
            String url = (String)JDBCDatasourceHolder.value((Map)params, (String)"url", String.class, null);
            if (BasicUtil.isEmpty((Object)url)) {
                url = (String)JDBCDatasourceHolder.value((Environment)env, (String)prefix, (String)"url", String.class, null);
            }
            if (BasicUtil.isEmpty((Object)url)) {
                return null;
            }
            if (!url.toLowerCase().startsWith("jdbc:")) {
                return null;
            }
            String type = (String)JDBCDatasourceHolder.value((Map)params, (String)"type", String.class, null);
            if (BasicUtil.isEmpty((Object)type)) {
                type = (String)JDBCDatasourceHolder.value((Environment)env, (String)prefix, (String)"type", String.class, null);
            }
            if (type == null) {
                type = DATASOURCE_TYPE_DEFAULT;
            }
            Class<?> poolClass = Class.forName(type);
            Object driver = JDBCDatasourceHolder.value((Map)params, (String)"driverClass");
            if (null == driver) {
                driver = JDBCDatasourceHolder.value((Environment)env, (String)prefix, (String)"driverClass");
            }
            if (driver instanceof String) {
                Class<?> calzz = Class.forName((String)driver);
                driver = calzz.newInstance();
            }
            if (null != driver) {
                params.put("driver", driver);
            }
            cache.put("driver", driver);
            cache.put("url", url);
            BeanDefinitionBuilder ds_builder = BeanDefinitionBuilder.genericBeanDefinition(poolClass);
            List methods = ClassUtil.getMethods(poolClass, (boolean)true);
            for (Method method : methods) {
                Class<?> tp;
                String name;
                if (method.getParameterCount() != 1 || !Modifier.isPublic(method.getModifiers()) || !(name = method.getName()).startsWith("set")) continue;
                Object value = JDBCDatasourceHolder.value((Map)params, (String)(name = name.substring(3, 4).toLowerCase() + name.substring(4)));
                if (null == value) {
                    value = JDBCDatasourceHolder.value((Environment)env, (String)prefix, (String)name);
                }
                if (null == value || null == (value = ConvertAdapter.convert((Object)value, tp = method.getParameters()[0].getType(), (boolean)false))) continue;
                cache.put(name, value);
                ds_builder.addPropertyValue(name, value);
            }
            AbstractBeanDefinition ds_definition = ds_builder.getBeanDefinition();
            factory.registerBeanDefinition(ds_id, (BeanDefinition)ds_definition);
            log.info("[\u6ce8\u5165\u6570\u636e\u6e90][type:JDBC][key:{}][bean:{}]", (Object)key, (Object)ds_id);
        }
        catch (Exception e) {
            log.error("[\u6ce8\u5165\u6570\u636e\u6e90\u5931\u8d25][type:JDBC][key:{}][msg:{}]", (Object)key, (Object)e.toString());
            e.printStackTrace();
            return null;
        }
        return ds_id;
    }

    private static String init(String key, String datasource, boolean override) throws Exception {
        if (null != datasource) {
            Map param;
            JDBCDatasourceHolder.check((String)key, (boolean)override);
            JDBCDatasourceHolder.regTransactionManager(key, datasource);
            DataRuntime runtime = JDBCRuntimeHolder.reg(key, datasource);
            if (null != runtime && null != (param = (Map)params.get(key))) {
                runtime.setDriver(param.get("driver") + "");
                String url = param.get("url") + "";
                runtime.setUrl(url);
                String adapter = param.get("adapter") + "";
                if (BasicUtil.isEmpty((Object)adapter)) {
                    adapter = RuntimeHolder.parseAdapterKey((String)url);
                }
                runtime.setAdapterKey(adapter);
                String catalog = param.get("catalog") + "";
                if (BasicUtil.isEmpty((Object)catalog)) {
                    catalog = RuntimeHolder.parseCatalog((String)url);
                }
                runtime.setCatalog(catalog);
                String schema = param.get("schema") + "";
                if (BasicUtil.isEmpty((Object)schema)) {
                    schema = RuntimeHolder.parseSchema((String)url);
                }
                runtime.setSchema(schema);
            }
        }
        return datasource;
    }

    private static DataRuntime init(String key, DataSource datasource, boolean override) throws Exception {
        DataRuntime runtime = null;
        if (null != datasource) {
            if (null != factory) {
                JDBCDatasourceHolder.check((String)key, (boolean)override);
                JDBCDatasourceHolder.regTransactionManager(key, datasource);
                runtime = JDBCRuntimeHolder.reg(key, datasource);
            } else if (!caches.containsKey(key) || override) {
                caches.put(key, datasource);
            }
        }
        return runtime;
    }

    public static void loadCache() {
        for (String key : caches.keySet()) {
            DataSource ds = caches.get(key);
            try {
                JDBCDatasourceHolder.reg(key, ds);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public DataRuntime callTemporary(Object datasource, String database, DriverAdapter adapter) throws Exception {
        return JDBCDatasourceHolder.exeTemporary(datasource, database, adapter);
    }

    private static DataRuntime exeTemporary(Object datasource, String database, DriverAdapter adapter) throws Exception {
        return JDBCRuntimeHolder.temporary(datasource, database, adapter);
    }

    public static boolean validate(String ds) {
        return JDBCDatasourceHolder.validate(JDBCRuntimeHolder.runtime((String)ds));
    }

    public static boolean validate() {
        return JDBCDatasourceHolder.validate(JDBCRuntimeHolder.runtime());
    }

    public static boolean validate(DataRuntime runtime) {
        try {
            return JDBCDatasourceHolder.exeValidate(runtime);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean validate(JdbcTemplate jdbc) throws Exception {
        return JDBCDatasourceHolder.validate(jdbc.getDataSource());
    }

    public static boolean validate(DataSource ds) throws Exception {
        Connection con = null;
        try {
            con = DataSourceUtils.getConnection((DataSource)ds);
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return true;
    }

    public static boolean exeValidate(DataRuntime runtime) throws Exception {
        JdbcTemplate jdbc = (JdbcTemplate)runtime.getProcessor();
        return JDBCDatasourceHolder.validate(jdbc);
    }

    public boolean callValidate(DataRuntime runtime) {
        return JDBCDatasourceHolder.validate(runtime);
    }

    public boolean callHit(DataRuntime runtime) throws Exception {
        return JDBCDatasourceHolder.exeValidate(runtime);
    }

    public static void destroy(String datasource) {
        JDBCDatasourceHolder.exeDestroy(datasource);
    }

    public void callDestroy(String datasource) {
        JDBCDatasourceHolder.exeDestroy(datasource);
    }

    private static void exeDestroy(String datasource) {
        JDBCRuntimeHolder.destroy(datasource);
    }

    public static List<String> copy() {
        return JDBCDatasourceHolder.copy("default");
    }

    public static List<String> copy(String datasource) {
        DataRuntime runtime = RuntimeHolder.runtime((String)datasource);
        return JDBCDatasourceHolder.copy(runtime);
    }

    public static List<String> copy(DataRuntime runtime) {
        return JDBCDatasourceHolder.exeCopy(runtime);
    }

    public List<String> callCopy(DataRuntime runtime) {
        return JDBCDatasourceHolder.exeCopy(runtime);
    }

    private static List<String> exeCopy(DataRuntime runtime) {
        ArrayList<String> list = new ArrayList<String>();
        AnylineService service = ServiceProxy.service((String)runtime.datasource());
        LinkedHashMap databases = service.metadata().databases();
        Map map = (Map)params.get(runtime.datasource());
        if (null == map) {
            log.warn("\u4e0d\u662f\u4eceanyline\u521b\u5efa\u7684\u6570\u636e\u6e90\u83b7\u53d6\u4e0d\u5230\u6570\u636e\u6e90\u53c2\u6570");
            return list;
        }
        for (String database : databases.keySet()) {
            HashMap<String, Object> copy_params = new HashMap<String, Object>();
            BeanUtil.copy(copy_params, (Map)map);
            String key = runtime.datasource() + "_" + database.toLowerCase();
            if (RuntimeHolder.contains((String)key)) {
                list.add(key);
                continue;
            }
            HashSet fields = DataSourceKeyMap.alias((String)"url");
            for (String field : fields) {
                String head;
                String db;
                String value = (String)copy_params.get(field);
                if (null == value || (db = (head = value.split("\\?")[0]).substring(head.lastIndexOf("/") + 1)) == null || db.equalsIgnoreCase(database)) continue;
                value = value.replace("/" + db, "/" + database);
                copy_params.put(field, value);
            }
            try {
                String id = JDBCDatasourceHolder.reg(key, copy_params);
                if (null == id) continue;
                RuntimeHolder.runtime((String)key).origin(runtime.getKey());
                list.add(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static DataSource datasource(String key) {
        JdbcTemplate jdbc;
        DataSource ds = null;
        DataRuntime runtime = RuntimeHolder.runtime((String)key);
        if (null != runtime && null != (jdbc = (JdbcTemplate)runtime.getProcessor())) {
            ds = jdbc.getDataSource();
        }
        return ds;
    }

    public static DataSource datasource() {
        return JDBCDatasourceHolder.datasource("default");
    }

    public static String regTransactionManager(String key, DataSource ds) {
        return JDBCDatasourceHolder.regTransactionManager(key, ds, false);
    }

    public static String regTransactionManager(String key, DataSource ds, boolean primary) {
        String tm_id = "anyline.transaction." + key;
        if (ConfigTable.IS_OPEN_TRANSACTION_MANAGER) {
            BeanDefinitionBuilder tm_builder = BeanDefinitionBuilder.genericBeanDefinition(DataSourceTransactionManager.class);
            tm_builder.addPropertyValue("dataSource", (Object)ds);
            tm_builder.setPrimary(primary);
            AbstractBeanDefinition tm_definition = tm_builder.getBeanDefinition();
            factory.registerBeanDefinition(tm_id, (BeanDefinition)tm_definition);
            log.info("[\u521b\u5efa\u4e8b\u52a1\u63a7\u5236\u5668][\u6570\u636e\u6e90:{}][bean:{}]", (Object)key, (Object)tm_id);
        }
        return tm_id;
    }

    public static String regTransactionManager(String key, String ds) {
        return JDBCDatasourceHolder.regTransactionManager(key, ds, false);
    }

    public static String regTransactionManager(String key, String ds, boolean primary) {
        String tm_id = "anyline.transaction." + key;
        if (ConfigTable.IS_OPEN_TRANSACTION_MANAGER) {
            BeanDefinitionBuilder tm_builder = BeanDefinitionBuilder.genericBeanDefinition(DataSourceTransactionManager.class);
            tm_builder.addPropertyReference("dataSource", ds);
            tm_builder.setPrimary(primary);
            AbstractBeanDefinition tm_definition = tm_builder.getBeanDefinition();
            factory.registerBeanDefinition(tm_id, (BeanDefinition)tm_definition);
            log.info("[\u521b\u5efa\u4e8b\u52a1\u63a7\u5236\u5668][\u6570\u636e\u6e90:{}][bean:{}]", (Object)key, (Object)tm_id);
        }
        return tm_id;
    }

    public static TransactionStatus start(String datasource, DefaultTransactionDefinition definition) {
        DataSourceTransactionManager dtm = null;
        if (BasicUtil.isEmpty((Object)datasource) || "default".equals(datasource) || !ConfigTable.IS_OPEN_TRANSACTION_MANAGER) {
            dtm = (DataSourceTransactionManager)SpringContextUtil.getBean((String)"transactionManager");
            datasource = "default";
        } else {
            dtm = (DataSourceTransactionManager)SpringContextUtil.getBean((String)("anyline.transaction." + datasource));
        }
        TransactionStatus status = dtm.getTransaction((TransactionDefinition)definition);
        transactionStatus.put(status, datasource);
        return status;
    }

    public static TransactionStatus start(String datasource, int behavior) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setPropagationBehavior(behavior);
        return JDBCDatasourceHolder.start(datasource, definition);
    }

    public static TransactionStatus start(String datasource) {
        return JDBCDatasourceHolder.start(datasource, 0);
    }

    public static TransactionStatus start(DefaultTransactionDefinition definition) {
        return JDBCDatasourceHolder.start(RuntimeHolder.runtime().getKey(), definition);
    }

    public static TransactionStatus start(int behavior) {
        return JDBCDatasourceHolder.start(RuntimeHolder.runtime().getKey(), behavior);
    }

    public static TransactionStatus start() {
        return JDBCDatasourceHolder.start(RuntimeHolder.runtime().getKey());
    }

    public static void commit(TransactionStatus status) {
        String datasource = transactionStatus.get(status);
        DataSourceTransactionManager dtm = null;
        dtm = BasicUtil.isEmpty((Object)datasource) || !ConfigTable.IS_OPEN_TRANSACTION_MANAGER ? (DataSourceTransactionManager)SpringContextUtil.getBean((String)"transactionManager") : (DataSourceTransactionManager)SpringContextUtil.getBean((String)("anyline.transaction." + datasource));
        if (null != dtm) {
            dtm.commit(status);
        } else {
            log.error("[\u63d0\u4ea4\u4e8b\u52a1][datasource:{}][result:false][message:\u7ba1\u7406\u7ba1\u7406\u5668\u4e0d\u5b58\u5728]", (Object)datasource);
        }
        transactionStatus.remove(status);
    }

    public static void rollback(TransactionStatus status) {
        String datasource = transactionStatus.get(status);
        DataSourceTransactionManager dtm = null;
        dtm = BasicUtil.isEmpty((Object)datasource) || !ConfigTable.IS_OPEN_TRANSACTION_MANAGER ? (DataSourceTransactionManager)SpringContextUtil.getBean((String)"transactionManager") : (DataSourceTransactionManager)SpringContextUtil.getBean((String)("anyline.transaction." + datasource));
        if (null != dtm) {
            dtm.rollback(status);
        } else {
            log.error("[\u56de\u6eda\u4e8b\u52a1][datasource:{}][result:false][message:\u7ba1\u7406\u7ba1\u7406\u5668\u4e0d\u5b58\u5728]", (Object)datasource);
        }
        transactionStatus.remove(status);
    }

    public static String url(DatabaseType type, Map<String, String> params) {
        String url = type.url();
        return url;
    }
}

