/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.adapter.init;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.MetadataAdapterHolder;
import org.anyline.data.jdbc.adapter.init.AbstractJDBCAdapter;
import org.anyline.data.jdbc.adapter.init.alias.PostgresGenusTypeMetadataAlias;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.run.TableRun;
import org.anyline.data.run.TextRun;
import org.anyline.data.run.XMLRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.BaseMetadata;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Sequence;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.adapter.PrimaryMetadataAdapter;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.regular.RegularUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;

public abstract class PostgresGenusAdapter
extends AbstractJDBCAdapter
implements InitializingBean {
    public PostgresGenusAdapter() {
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.CHAR, (TypeMetadata.Config)new TypeMetadata.Config("CHARACTER_MAXIMUM_LENGTH", null, null, 0, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.TEXT, (TypeMetadata.Config)new TypeMetadata.Config("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.BOOLEAN, (TypeMetadata.Config)new TypeMetadata.Config("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.BYTES, (TypeMetadata.Config)new TypeMetadata.Config("CHARACTER_MAXIMUM_LENGTH", null, null, 0, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.BLOB, (TypeMetadata.Config)new TypeMetadata.Config("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.INT, (TypeMetadata.Config)new TypeMetadata.Config("CHARACTER_MAXIMUM_LENGTH", "NUMERIC_PRECISION", null, 1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.FLOAT, (TypeMetadata.Config)new TypeMetadata.Config("CHARACTER_MAXIMUM_LENGTH", "NUMERIC_PRECISION", "NUMERIC_SCALE", 1, 0, 0));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.DATE, (TypeMetadata.Config)new TypeMetadata.Config("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.TIME, (TypeMetadata.Config)new TypeMetadata.Config("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.DATETIME, (TypeMetadata.Config)new TypeMetadata.Config("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.TIMESTAMP, (TypeMetadata.Config)new TypeMetadata.Config("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.COLLECTION, (TypeMetadata.Config)new TypeMetadata.Config("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.GEOMETRY, (TypeMetadata.Config)new TypeMetadata.Config("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.OTHER, (TypeMetadata.Config)new TypeMetadata.Config("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        for (PostgresGenusTypeMetadataAlias alias : PostgresGenusTypeMetadataAlias.values()) {
            this.reg(alias);
        }
    }

    @Override
    public boolean supportCatalog() {
        return super.supportSchema();
    }

    @Override
    public boolean supportSchema() {
        return super.supportSchema();
    }

    @Override
    public long insert(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.insert(runtime, random, batch, dest, data, configs, columns);
    }

    @Override
    public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        return super.buildInsertRun(runtime, batch, dest, obj, configs, columns);
    }

    @Override
    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        super.fillInsertContent(runtime, run, dest, set, configs, columns);
    }

    @Override
    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        super.fillInsertContent(runtime, run, dest, list, configs, columns);
    }

    public LinkedHashMap<String, Column> confirmInsertColumns(DataRuntime runtime, String dest, Object obj, ConfigStore configs, List<String> columns, boolean batch) {
        return super.confirmInsertColumns(runtime, dest, obj, configs, columns, batch);
    }

    @Override
    public String batchInsertSeparator() {
        return ",";
    }

    @Override
    public boolean supportInsertPlaceholder() {
        return true;
    }

    @Override
    protected void setPrimaryValue(Object obj, Object value) {
        super.setPrimaryValue(obj, value);
    }

    @Override
    protected Run createInsertRun(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        return super.createInsertRun(runtime, dest, obj, configs, columns);
    }

    @Override
    protected Run createInsertRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore configs, List<String> columns) {
        return super.createInsertRunFromCollection(runtime, batch, dest, list, configs, columns);
    }

    @Override
    public String generatedKey() {
        return super.generatedKey();
    }

    @Override
    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks) {
        return super.insert(runtime, random, data, configs, run, pks);
    }

    public long update(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return super.update(runtime, random, batch, dest, data, configs, columns);
    }

    public Run buildUpdateRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore configs, List<String> columns) {
        return super.buildUpdateRun(runtime, batch, dest, obj, configs, columns);
    }

    @Override
    public Run buildUpdateRunFromEntity(DataRuntime runtime, String dest, Object obj, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromEntity(runtime, dest, obj, configs, columns);
    }

    @Override
    public Run buildUpdateRunFromDataRow(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromDataRow(runtime, dest, row, configs, columns);
    }

    @Override
    public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromCollection(runtime, batch, dest, list, configs, columns);
    }

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, List<String> columns) {
        return super.confirmUpdateColumns(runtime, dest, row, configs, columns);
    }

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, String dest, Object obj, ConfigStore configs, List<String> columns) {
        return super.confirmUpdateColumns(runtime, dest, obj, configs, columns);
    }

    public long update(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, Run run) {
        return super.update(runtime, random, dest, data, configs, run);
    }

    public long save(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, List<String> columns) {
        return super.save(runtime, random, dest, data, configs, columns);
    }

    @Override
    protected long saveCollection(DataRuntime runtime, String random, Table dest, Collection<?> data, ConfigStore configs, List<String> columns) {
        return super.saveCollection(runtime, random, dest, data, configs, columns);
    }

    @Override
    protected long saveObject(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.saveObject(runtime, random, dest, data, configs, columns);
    }

    @Override
    protected Boolean checkOverride(Object obj) {
        return super.checkOverride(obj);
    }

    @Override
    protected Map<String, Object> checkPv(Object obj) {
        return super.checkPv(obj);
    }

    @Override
    protected boolean isMultipleValue(DataRuntime runtime, TableRun run, String key) {
        return super.isMultipleValue(runtime, run, key);
    }

    @Override
    protected boolean isMultipleValue(Column column) {
        return super.isMultipleValue(column);
    }

    @Override
    public LinkedHashMap<String, Column> checkMetadata(DataRuntime runtime, Table table, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.checkMetadata(runtime, table, configs, columns);
    }

    @Override
    public DataSet querys(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.querys(runtime, random, prepare, configs, conditions);
    }

    @Override
    public DataSet querys(DataRuntime runtime, String random, Procedure procedure, PageNavi navi) {
        return super.querys(runtime, random, procedure, navi);
    }

    @Override
    public <T> EntitySet<T> selects(DataRuntime runtime, String random, RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return super.selects(runtime, random, prepare, clazz, configs, conditions);
    }

    @Override
    protected <T> EntitySet<T> select(DataRuntime runtime, String random, Class<T> clazz, Table table, ConfigStore configs, Run run) {
        return super.select(runtime, random, clazz, table, configs, run);
    }

    @Override
    public List<Map<String, Object>> maps(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.maps(runtime, random, prepare, configs, conditions);
    }

    @Override
    public Run buildQueryRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.buildQueryRun(runtime, prepare, configs, conditions);
    }

    @Override
    public List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names) {
        ArrayList<Run> runs = new ArrayList<Run>();
        String key = "CURRVAL";
        if (next) {
            key = "NEXTVAL";
        }
        if (null != names && names.length > 0) {
            SimpleRun run = new SimpleRun(runtime);
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("SELECT ");
            boolean first = true;
            for (String name : names) {
                if (!first) {
                    builder.append(",");
                }
                first = false;
                builder.append(key).append("('").append(name).append("') AS ").append(name);
            }
        }
        return runs;
    }

    @Override
    public void fillQueryContent(DataRuntime runtime, Run run) {
        super.fillQueryContent(runtime, run);
    }

    @Override
    protected void fillQueryContent(DataRuntime runtime, XMLRun run) {
        super.fillQueryContent(runtime, run);
    }

    @Override
    protected void fillQueryContent(DataRuntime runtime, TextRun run) {
        super.fillQueryContent(runtime, run);
    }

    @Override
    protected void fillQueryContent(DataRuntime runtime, TableRun run) {
        super.fillQueryContent(runtime, run);
    }

    @Override
    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        return super.pageLimitOffset(runtime, run);
    }

    @Override
    public RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value) {
        return super.createConditionLike(runtime, builder, compare, value);
    }

    @Override
    public Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value) {
        return super.createConditionFindInSet(runtime, builder, column, compare, value);
    }

    @Override
    public StringBuilder createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value) {
        return super.createConditionIn(runtime, builder, compare, value);
    }

    @Override
    public DataSet select(DataRuntime runtime, String random, boolean system, Table table, ConfigStore configs, Run run) {
        return super.select(runtime, random, system, table, configs, run);
    }

    @Override
    public List<Map<String, Object>> maps(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.maps(runtime, random, configs, run);
    }

    @Override
    public Map<String, Object> map(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.map(runtime, random, configs, run);
    }

    @Override
    public DataRow sequence(DataRuntime runtime, String random, boolean next, String ... names) {
        return super.sequence(runtime, random, next, names);
    }

    @Override
    public List<Map<String, Object>> process(DataRuntime runtime, List<Map<String, Object>> list) {
        return super.process(runtime, list);
    }

    @Override
    public long count(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.count(runtime, random, prepare, configs, conditions);
    }

    @Override
    public String mergeFinalTotal(DataRuntime runtime, Run run) {
        return super.mergeFinalTotal(runtime, run);
    }

    @Override
    public long count(DataRuntime runtime, String random, Run run) {
        return super.count(runtime, random, run);
    }

    @Override
    public boolean exists(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.exists(runtime, random, prepare, configs, conditions);
    }

    @Override
    public String mergeFinalExists(DataRuntime runtime, Run run) {
        return super.mergeFinalExists(runtime, run);
    }

    @Override
    public long execute(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.execute(runtime, random, prepare, configs, conditions);
    }

    @Override
    public long execute(DataRuntime runtime, String random, int batch, ConfigStore configs, RunPrepare prepare, Collection<Object> values) {
        return super.execute(runtime, random, batch, configs, prepare, values);
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, Procedure procedure) {
        return super.execute(runtime, random, procedure);
    }

    @Override
    public Run buildExecuteRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.buildExecuteRun(runtime, prepare, configs, conditions);
    }

    @Override
    protected void fillExecuteContent(DataRuntime runtime, XMLRun run) {
        super.fillExecuteContent(runtime, run);
    }

    @Override
    protected void fillExecuteContent(DataRuntime runtime, TextRun run) {
        super.fillExecuteContent(runtime, run);
    }

    @Override
    protected void fillExecuteContent(DataRuntime runtime, TableRun run) {
        super.fillExecuteContent(runtime, run);
    }

    @Override
    public void fillExecuteContent(DataRuntime runtime, Run run) {
        super.fillExecuteContent(runtime, run);
    }

    @Override
    public long execute(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.execute(runtime, random, configs, run);
    }

    public <T> long deletes(DataRuntime runtime, String random, int batch, String table, ConfigStore configs, String key, Collection<T> values) {
        return super.deletes(runtime, random, batch, table, configs, key, values);
    }

    public long delete(DataRuntime runtime, String random, String dest, ConfigStore configs, Object obj, String ... columns) {
        return super.delete(runtime, random, dest, configs, obj, columns);
    }

    public long delete(DataRuntime runtime, String random, String table, ConfigStore configs, String ... conditions) {
        return super.delete(runtime, random, table, configs, conditions);
    }

    @Override
    public long truncate(DataRuntime runtime, String random, Table table) {
        return super.truncate(runtime, random, table);
    }

    @Override
    public Run buildDeleteRun(DataRuntime runtime, Table dest, Object obj, String ... columns) {
        return super.buildDeleteRun(runtime, dest, obj, columns);
    }

    public Run buildDeleteRun(DataRuntime runtime, int batch, String table, String key, Object values) {
        return super.buildDeleteRun(runtime, batch, table, key, values);
    }

    public List<Run> buildTruncateRun(DataRuntime runtime, String table) {
        return super.buildTruncateRun(runtime, table);
    }

    @Override
    public Run buildDeleteRunFromTable(DataRuntime runtime, int batch, Table table, String column, Object values) {
        return super.buildDeleteRunFromTable(runtime, batch, table, column, values);
    }

    @Override
    public Run buildDeleteRunFromEntity(DataRuntime runtime, Table table, Object obj, String ... columns) {
        return super.buildDeleteRunFromEntity(runtime, table, obj, columns);
    }

    @Override
    public void fillDeleteRunContent(DataRuntime runtime, Run run) {
        super.fillDeleteRunContent(runtime, run);
    }

    @Override
    public long delete(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.delete(runtime, random, configs, run);
    }

    @Override
    public Database database(DataRuntime runtime, String random) {
        Catalog catalog = this.catalog(runtime, random);
        if (null != catalog) {
            return new Database(catalog.getName());
        }
        return super.database(runtime, random);
    }

    @Override
    public String product(DataRuntime runtime, String random) {
        return super.product(runtime, random);
    }

    @Override
    public String version(DataRuntime runtime, String random) {
        return super.version(runtime, random);
    }

    @Override
    public List<Database> databases(DataRuntime runtime, String random, boolean greedy, String name) {
        return super.databases(runtime, random, greedy, name);
    }

    @Override
    public LinkedHashMap<String, Database> databases(DataRuntime runtime, String random, String name) {
        return super.databases(runtime, random, name);
    }

    @Override
    public List<Run> buildQueryDatabasesRun(DataRuntime runtime, boolean greedy, String name) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM PG_DATABASE WHERE DATISTEMPLATE=FALSE");
        if (BasicUtil.isNotEmpty((Object)name)) {
            builder.append(" AND datname = '").append(name).append("'");
        }
        return runs;
    }

    @Override
    public LinkedHashMap<String, Database> databases(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Database> databases, DataSet set) throws Exception {
        if (null == databases) {
            databases = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Database database = new Database();
            database.setName(row.getString("DATNAME"));
            databases.put(database.getName().toUpperCase(), database);
        }
        return databases;
    }

    @Override
    public List<Database> databases(DataRuntime runtime, int index, boolean create, List<Database> databases, DataSet set) throws Exception {
        return super.databases(runtime, index, create, databases, set);
    }

    @Override
    public Database database(DataRuntime runtime, int index, boolean create, Database database, DataSet set) throws Exception {
        return super.database(runtime, index, create, database, set);
    }

    @Override
    public Database database(DataRuntime runtime, boolean create, Database database) throws Exception {
        return super.database(runtime, create, database);
    }

    @Override
    public String product(DataRuntime runtime, int index, boolean create, String product, DataSet set) {
        return super.product(runtime, index, create, product, set);
    }

    @Override
    public String product(DataRuntime runtime, boolean create, String product) {
        return super.product(runtime, create, product);
    }

    @Override
    public String version(DataRuntime runtime, int index, boolean create, String version, DataSet set) {
        return super.version(runtime, index, create, version, set);
    }

    @Override
    public String version(DataRuntime runtime, boolean create, String version) {
        return super.version(runtime, create, version);
    }

    @Override
    public LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, String random, String name) {
        return super.catalogs(runtime, random, name);
    }

    @Override
    public List<Catalog> catalogs(DataRuntime runtime, String random, boolean greedy, String name) {
        return super.catalogs(runtime, random, greedy, name);
    }

    @Override
    public List<Run> buildQueryCatalogsRun(DataRuntime runtime, boolean greedy, String name) throws Exception {
        return super.buildQueryCatalogsRun(runtime, greedy, name);
    }

    @Override
    public LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Catalog> catalogs, DataSet set) throws Exception {
        return super.catalogs(runtime, index, create, catalogs, set);
    }

    @Override
    public List<Catalog> catalogs(DataRuntime runtime, int index, boolean create, List<Catalog> catalogs, DataSet set) throws Exception {
        return super.catalogs(runtime, index, create, catalogs, set);
    }

    @Override
    public LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, boolean create, LinkedHashMap<String, Catalog> catalogs) throws Exception {
        return super.catalogs(runtime, create, catalogs);
    }

    @Override
    public List<Catalog> catalogs(DataRuntime runtime, boolean create, List<Catalog> catalogs) throws Exception {
        return super.catalogs(runtime, create, catalogs);
    }

    @Override
    public Catalog catalog(DataRuntime runtime, int index, boolean create, Catalog catalog, DataSet set) throws Exception {
        return super.catalog(runtime, index, create, catalog, set);
    }

    @Override
    public Catalog catalog(DataRuntime runtime, boolean create, Catalog catalog) throws Exception {
        return super.catalog(runtime, create, catalog);
    }

    @Override
    public LinkedHashMap<String, Schema> schemas(DataRuntime runtime, String random, Catalog catalog, String name) {
        return super.schemas(runtime, random, catalog, name);
    }

    @Override
    public List<Schema> schemas(DataRuntime runtime, String random, boolean greedy, Catalog catalog, String name) {
        return super.schemas(runtime, random, greedy, catalog, name);
    }

    @Override
    public List<Run> buildQuerySchemasRun(DataRuntime runtime, boolean greedy, Catalog catalog, String name) throws Exception {
        return super.buildQuerySchemasRun(runtime, greedy, catalog, name);
    }

    @Override
    public LinkedHashMap<String, Schema> schemas(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Schema> schemas, DataSet set) throws Exception {
        return super.schemas(runtime, index, create, schemas, set);
    }

    @Override
    public List<Schema> schemas(DataRuntime runtime, int index, boolean create, List<Schema> schemas, DataSet set) throws Exception {
        return super.schemas(runtime, index, create, schemas, set);
    }

    @Override
    public Schema schema(DataRuntime runtime, int index, boolean create, Schema schema, DataSet set) throws Exception {
        return super.schema(runtime, index, create, schema, set);
    }

    @Override
    public Schema schema(DataRuntime runtime, boolean create, Schema schema) throws Exception {
        return super.schema(runtime, create, schema);
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, String types, boolean strut) {
        return super.tables(runtime, random, greedy, catalog, schema, pattern, types, strut);
    }

    @Override
    protected void tableMap(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema) {
        super.tableMap(runtime, random, greedy, catalog, schema);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, String types, boolean strut) {
        return super.tables(runtime, random, catalog, schema, pattern, types, strut);
    }

    @Override
    public List<Run> buildQueryTablesRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT M.*, obj_description(f.relfilenode,'pg_class')  AS TABLE_COMMENT  FROM  INFORMATION_SCHEMA.TABLES AS M \n");
        builder.append("LEFT JOIN pg_class AS F ON M.TABLE_NAME = F.relname\n");
        builder.append("WHERE 1=1 ");
        if (BasicUtil.isNotEmpty((Object)schema)) {
            builder.append(" AND M.table_schema = '").append(schema.getName()).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND M.table_name LIKE '").append(pattern).append("'");
        }
        return runs;
    }

    @Override
    public List<Run> buildQueryTablesCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        return super.buildQueryTablesCommentRun(runtime, catalog, schema, pattern, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.tables(runtime, index, create, catalog, schema, tables, set);
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, List<T> tables, DataSet set) throws Exception {
        return super.tables(runtime, index, create, catalog, schema, tables, set);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, String pattern, String ... types) throws Exception {
        return super.tables(runtime, create, tables, catalog, schema, pattern, types);
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> tables, Catalog catalog, Schema schema, String pattern, String ... types) throws Exception {
        return super.tables(runtime, create, tables, catalog, schema, pattern, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> comments(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.comments(runtime, index, create, catalog, schema, tables, set);
    }

    @Override
    public <T extends Table> List<T> comments(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, List<T> tables, DataSet set) throws Exception {
        return super.comments(runtime, index, create, catalog, schema, tables, set);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Table table, boolean init) {
        return super.ddl(runtime, random, table, init);
    }

    @Override
    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryDdlsRun(runtime, table);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Table table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, String types) {
        return super.views(runtime, random, greedy, catalog, schema, pattern, types);
    }

    @Override
    public List<Run> buildQueryViewsRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        return super.buildQueryViewsRun(runtime, greedy, catalog, schema, pattern, types);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> views, DataSet set) throws Exception {
        return super.views(runtime, index, create, catalog, schema, views, set);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> views, Catalog catalog, Schema schema, String pattern, String ... types) throws Exception {
        return super.views(runtime, create, views, catalog, schema, pattern, types);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, View view) {
        return super.ddl(runtime, random, view);
    }

    @Override
    public List<Run> buildQueryDdlsRun(DataRuntime runtime, View view) throws Exception {
        return super.buildQueryDdlsRun(runtime, view);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, View view, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, view, ddls, set);
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, String types) {
        return super.mtables(runtime, random, greedy, catalog, schema, pattern, types);
    }

    @Override
    public List<Run> buildQueryMasterTablesRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        return super.buildQueryMasterTablesRun(runtime, catalog, schema, pattern, types);
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.mtables(runtime, index, create, catalog, schema, tables, set);
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, String pattern, String ... types) throws Exception {
        return super.mtables(runtime, create, tables, catalog, schema, pattern, types);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, MasterTable table) {
        return super.ddl(runtime, random, table);
    }

    @Override
    public List<Run> buildQueryDdlsRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildQueryDdlsRun(runtime, table);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, MasterTable table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, String random, boolean greedy, MasterTable master, Map<String, Object> tags, String pattern) {
        return super.ptables(runtime, random, greedy, master, tags, pattern);
    }

    @Override
    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTablesRun(runtime, catalog, schema, pattern, types);
    }

    @Override
    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags, String name) throws Exception {
        return super.buildQueryPartitionTablesRun(runtime, master, tags, name);
    }

    @Override
    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTablesRun(runtime, master, tags);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, int total, int index, boolean create, MasterTable master, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.ptables(runtime, total, index, create, master, catalog, schema, tables, set);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, MasterTable master) throws Exception {
        return super.ptables(runtime, create, tables, catalog, schema, master);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, PartitionTable table) {
        return super.ddl(runtime, random, table);
    }

    @Override
    public List<Run> buildQueryDdlsRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildQueryDdlsRun(runtime, table);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, PartitionTable table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean greedy, Table table, boolean primary) {
        return super.columns(runtime, random, greedy, table, primary);
    }

    @Override
    public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, Table table) {
        return super.columns(runtime, random, greedy, catalog, schema, table);
    }

    @Override
    public List<Run> buildQueryColumnsRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String catalog = null;
        String schema = null;
        String name = null;
        this.checkName(runtime, null, table);
        if (null != table) {
            name = table.getName();
            catalog = table.getCatalogName();
            schema = table.getSchemaName();
        }
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(runtime, builder, (BaseMetadata)table);
            builder.append(" WHERE 1=0");
        } else {
            builder.append("SELECT M.*,pg_catalog.format_type ( FA.ATTTYPID, FA.ATTTYPMOD ) AS FULL_TYPE,FD.DESCRIPTION AS COLUMN_COMMENT \n");
            builder.append("FROM INFORMATION_SCHEMA.COLUMNS M\n");
            builder.append("LEFT JOIN PG_CLASS FC ON FC.RELNAME = M.TABLE_NAME\n");
            builder.append("LEFT JOIN PG_ATTRIBUTE AS FA ON FA.ATTNAME = M.COLUMN_NAME AND FA.ATTRELID = FC.OID\n");
            builder.append("LEFT JOIN PG_DESCRIPTION FD ON FD.OBJOID = FC.OID AND FD.OBJSUBID = M.ORDINAL_POSITION\n");
            builder.append("WHERE 1 = 1\n");
            if (BasicUtil.isNotEmpty((Object)catalog)) {
                builder.append(" AND M.TABLE_CATALOG = '").append(catalog).append("'");
            }
            if (BasicUtil.isNotEmpty((Object)schema)) {
                builder.append(" AND M.TABLE_SCHEMA = '").append(schema).append("'");
            }
            if (BasicUtil.isNotEmpty((Object)name)) {
                builder.append(" AND M.TABLE_NAME = '").append(name).append("'");
            }
            builder.append(" ORDER BY M.TABLE_NAME");
        }
        return runs;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        set.changeKey("UDT_NAME", "DATA_TYPE");
        return super.columns(runtime, index, create, table, columns, set);
    }

    @Override
    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, Table table, List<T> columns, DataSet set) throws Exception {
        return super.columns(runtime, index, create, table, columns, set);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String pattern) throws Exception {
        return super.columns(runtime, create, columns, table, pattern);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, String random, boolean greedy, Table table) {
        return super.tags(runtime, random, greedy, table);
    }

    @Override
    public List<Run> buildQueryTagsRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        return super.buildQueryTagsRun(runtime, table, metadata);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        return super.tags(runtime, index, create, table, tags, set);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Table table, String pattern) throws Exception {
        return super.tags(runtime, create, tags, table, pattern);
    }

    @Override
    public PrimaryKey primary(DataRuntime runtime, String random, boolean greedy, Table table) {
        return super.primary(runtime, random, greedy, table);
    }

    @Override
    public List<Run> buildQueryPrimaryRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        this.checkName(runtime, null, table);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT  m.conname, pg_get_constraintdef(m.oid, true) AS define\n");
        builder.append("FROM pg_constraint m \n");
        builder.append("LEFT JOIN pg_namespace ns ON m.connamespace = ns.oid \n");
        builder.append("LEFT JOIN pg_class ft ON m.conrelid = ft.oid \n");
        builder.append("WHERE ft.relname = '").append(table.getName()).append("'");
        Schema schema = table.getSchema();
        if (BasicUtil.isNotEmpty((Object)schema)) {
            builder.append(" AND ns.nspname = '").append(schema.getName()).append("'");
        }
        return runs;
    }

    @Override
    public <T extends PrimaryKey> T init(DataRuntime runtime, int index, T primary, Table table, DataSet set) throws Exception {
        if (set.size() > 0) {
            String[] cols;
            DataRow row = set.getRow(0);
            primary = new PrimaryKey();
            primary.setName(row.getString("CONNAME"));
            String define = row.getString("DEFINE");
            for (String col : cols = RegularUtil.cut((String)define, (String[])new String[]{"(", ")"}).split(",")) {
                Column column = new Column(col.trim().replace("\"", ""));
                column.setTable(table);
                primary.addColumn(column);
            }
        }
        return primary;
    }

    @Override
    public <T extends PrimaryKey> T detail(DataRuntime runtime, int index, T primary, Table table, DataSet set) throws Exception {
        return super.detail(runtime, index, primary, table, set);
    }

    @Override
    public PrimaryMetadataAdapter primaryMetadataAdapter(DataRuntime runtime) {
        return super.primaryMetadataAdapter(runtime);
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, String random, boolean greedy, Table table) {
        return super.foreigns(runtime, random, greedy, table);
    }

    @Override
    public List<Run> buildQueryForeignsRun(DataRuntime runtime, Table table) throws Exception {
        String name;
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        this.checkName(runtime, null, table);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT TC.CONSTRAINT_NAME,TC.TABLE_NAME AS TABLE_NAME, KCU.COLUMN_NAME AS COLUMN_NAME, KCU.ORDINAL_POSITION,CCU.TABLE_NAME AS REFERENCED_TABLE_NAME, CCU.COLUMN_NAME AS REFERENCED_COLUMN_NAME\n");
        builder.append("FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS TC\n");
        builder.append("JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE AS KCU ON TC.CONSTRAINT_NAME = KCU.CONSTRAINT_NAME\n");
        builder.append("JOIN INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE AS CCU ON CCU.CONSTRAINT_NAME = TC.CONSTRAINT_NAME\n");
        builder.append("WHERE TC.CONSTRAINT_TYPE = 'FOREIGN KEY'\n");
        if (null != table && BasicUtil.isNotEmpty((Object)(name = table.getName()))) {
            builder.append(" AND TC.TABLE_NAME = '").append(name).append("'\n");
        }
        builder.append("ORDER BY KCU.ORDINAL_POSITION");
        return runs;
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set) throws Exception {
        if (null == foreigns) {
            foreigns = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("CONSTRAINT_NAME");
            ForeignKey foreign = (ForeignKey)foreigns.get(name.toUpperCase());
            if (null == foreign) {
                foreign = new ForeignKey();
                foreign.setName(name);
                foreign.setTable(row.getString("TABLE_NAME"));
                foreign.setReference(row.getString("REFERENCED_TABLE_NAME"));
                foreigns.put(name.toUpperCase(), foreign);
            }
            Table refTable = new Table(row.getString("REFERENCED_CATALOG_NAME"), row.getString("REFERENCED_SCHEMA_NAME"), row.getString("REFERENCED_TABLE_NAME"));
            Column reference = new Column(row.getString("REFERENCED_COLUMN_NAME"));
            reference.setTable(refTable);
            foreign.addColumn(new Column(row.getString("COLUMN_NAME")).setReference(reference).setPosition(row.getInt("ORDINAL_POSITION", Integer.valueOf(0))));
        }
        return foreigns;
    }

    @Override
    public <T extends Index> List<T> indexs(DataRuntime runtime, String random, boolean greedy, Table table, String pattern) {
        return super.indexs(runtime, random, greedy, table, pattern);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, String random, Table table, String pattern) {
        return super.indexs(runtime, random, table, pattern);
    }

    @Override
    public List<Run> buildQueryIndexsRun(DataRuntime runtime, Table table, String name) {
        return super.buildQueryIndexsRun(runtime, table, name);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        return super.indexs(runtime, index, create, table, indexs, set);
    }

    @Override
    public <T extends Index> List<T> indexs(DataRuntime runtime, int index, boolean create, Table table, List<T> indexs, DataSet set) throws Exception {
        return super.indexs(runtime, index, create, table, indexs, set);
    }

    @Override
    public <T extends Index> List<T> indexs(DataRuntime runtime, boolean create, List<T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(runtime, create, indexs, table, unique, approximate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        JdbcTemplate jdbc;
        DataSource ds = null;
        Connection con = null;
        if (null == indexs) {
            indexs = new LinkedHashMap();
        }
        if (null == (jdbc = this.jdbc(runtime))) {
            return new LinkedHashMap();
        }
        try {
            this.checkName(runtime, null, table);
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            DatabaseMetaData dbmd = con.getMetaData();
            String[] tmp = this.correctSchemaFromJDBC(table.getCatalogName(), table.getSchemaName());
            ResultSet set = dbmd.getIndexInfo(tmp[0], tmp[1], table.getName(), unique, approximate);
            Map<String, Integer> keys = this.keys(set);
            LinkedHashMap<String, Column> columns = null;
            while (set.next()) {
                String name = this.string(keys, "INDEX_NAME", set);
                if (null == name) continue;
                Index index = (Index)indexs.get(name.toUpperCase());
                if (null == index) {
                    if (!create) continue;
                    index = new Index();
                    indexs.put(name.toUpperCase(), index);
                    index.setName(this.string(keys, "INDEX_NAME", set));
                    index.setUnique(this.bool(keys, "NON_UNIQUE", set, false) == false);
                    String catalog = table.getCatalogName();
                    String schema = (String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_SCHEMA", set), this.string(keys, "TABLE_SCHEM", set)});
                    this.correctSchemaFromJDBC(index, catalog, schema);
                    if (!BasicUtil.equals((Object)table.getSchemaName(), (Object)index.getSchemaName())) continue;
                    index.setTable(this.string(keys, "TABLE_NAME", set));
                    indexs.put(name.toUpperCase(), index);
                    columns = new LinkedHashMap<String, Column>();
                    index.setColumns(columns);
                    if (name.equalsIgnoreCase("PRIMARY")) {
                        index.setCluster(true);
                        index.setPrimary(true);
                    } else if (name.equalsIgnoreCase("PK_" + table.getName())) {
                        index.setCluster(true);
                        index.setPrimary(true);
                    }
                } else {
                    columns = index.getColumns();
                }
                String columnName = this.string(keys, "COLUMN_NAME", set);
                Column col = table.getColumn(columnName.toUpperCase());
                Column column = null;
                if (null != col) {
                    column = (Column)col.clone();
                } else {
                    column = new Column();
                    column.setName(columnName);
                }
                String order = this.string(keys, "ASC_OR_DESC", set);
                order = null != order && order.startsWith("D") ? "DESC" : "ASC";
                column.setOrder(order);
                column.setPosition(this.integer(keys, "ORDINAL_POSITION", set, null));
                columns.put(column.getName().toUpperCase(), column);
            }
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return indexs;
    }

    @Override
    public <T extends Constraint> List<T> constraints(DataRuntime runtime, String random, boolean greedy, Table table, String pattern) {
        return super.constraints(runtime, random, greedy, table, pattern);
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, String random, Table table, Column column, String pattern) {
        return super.constraints(runtime, random, table, column, pattern);
    }

    @Override
    public List<Run> buildQueryConstraintsRun(DataRuntime runtime, Table table, Column column, String pattern) {
        return super.buildQueryConstraintsRun(runtime, table, column, pattern);
    }

    @Override
    public <T extends Constraint> List<T> constraints(DataRuntime runtime, int index, boolean create, Table table, List<T> constraints, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, table, constraints, set);
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, Table table, Column column, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, table, column, constraints, set);
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, String random, boolean greedy, Table table, List<Trigger.EVENT> events) {
        return super.triggers(runtime, random, greedy, table, events);
    }

    @Override
    public List<Run> buildQueryTriggersRun(DataRuntime runtime, Table table, List<Trigger.EVENT> events) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.TRIGGERS WHERE 1=1");
        if (null != table) {
            this.checkName(runtime, null, table);
            Schema schemae = table.getSchema();
            String name = table.getName();
            if (BasicUtil.isNotEmpty((Object)schemae)) {
                builder.append(" AND TRIGGER_SCHEMA = '").append(schemae).append("'");
            }
            if (BasicUtil.isNotEmpty((Object)name)) {
                builder.append(" AND EVENT_OBJECT_TABLE = '").append(name).append("'");
            }
        }
        if (null != events && events.size() > 0) {
            builder.append(" AND(");
            boolean first = true;
            for (Trigger.EVENT event : events) {
                if (!first) {
                    builder.append(" OR ");
                }
                builder.append("EVENT_MANIPULATION ='").append(event);
            }
            builder.append(")");
        }
        return runs;
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        if (null == triggers) {
            triggers = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("TRIGGER_NAME");
            Trigger trigger = (Trigger)triggers.get(name.toUpperCase());
            if (null == trigger) {
                trigger = new Trigger();
            }
            trigger.setName(name);
            Table tab = new Table(row.getString("EVENT_OBJECT_TABLE"));
            tab.setSchema(row.getString("TRIGGER_SCHEMA"));
            tab.setCatalog(row.getString("TRIGGER_CATALOG("));
            trigger.setTable(tab);
            boolean each = false;
            if ("ROW".equalsIgnoreCase(row.getString("ACTION_ORIENTATION"))) {
                each = true;
            }
            trigger.setEach(each);
            try {
                String[] events = row.getStringNvl("EVENT_MANIPULATION", new String[0]).split(",");
                String time = row.getString("ACTION_TIMING");
                trigger.setTime(Trigger.TIME.valueOf((String)time));
                for (String event : events) {
                    trigger.addEvent(new Trigger.EVENT[]{Trigger.EVENT.valueOf((String)event)});
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            trigger.setDefinition(row.getString("ACTION_STATEMENT"));
            triggers.put(name.toUpperCase(), trigger);
        }
        return triggers;
    }

    @Override
    public <T extends Procedure> List<T> procedures(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        return super.procedures(runtime, random, greedy, catalog, schema, pattern);
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        return super.procedures(runtime, random, catalog, schema, pattern);
    }

    @Override
    public List<Run> buildQueryProceduresRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern) {
        return super.buildQueryProceduresRun(runtime, catalog, schema, pattern);
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> procedures, DataSet set) throws Exception {
        return super.procedures(runtime, index, create, procedures, set);
    }

    @Override
    public <T extends Procedure> List<T> procedures(DataRuntime runtime, boolean create, List<T> procedures) throws Exception {
        return super.procedures(runtime, create, procedures);
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, boolean create, LinkedHashMap<String, T> procedures) throws Exception {
        return super.procedures(runtime, create, procedures);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Procedure procedure) {
        return super.ddl(runtime, random, procedure);
    }

    @Override
    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildQueryDdlsRun(runtime, procedure);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, procedure, ddls, set);
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        return super.functions(runtime, random, greedy, catalog, schema, pattern);
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        return super.functions(runtime, random, catalog, schema, pattern);
    }

    @Override
    public List<Run> buildQueryFunctionsRun(DataRuntime runtime, Catalog catalog, Schema schema, String name) {
        return super.buildQueryFunctionsRun(runtime, catalog, schema, name);
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, int index, boolean create, List<T> functions, DataSet set) throws Exception {
        return super.functions(runtime, index, create, functions, set);
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> functions, DataSet set) throws Exception {
        return super.functions(runtime, index, create, functions, set);
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, boolean create, List<T> functions) throws Exception {
        return super.functions(runtime, create, functions);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Function meta) {
        return super.ddl(runtime, random, meta);
    }

    @Override
    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildQueryDdlsRun(runtime, meta);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Function function, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, function, ddls, set);
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        return super.sequences(runtime, random, greedy, catalog, schema, pattern);
    }

    @Override
    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        return super.sequences(runtime, random, catalog, schema, pattern);
    }

    @Override
    public List<Run> buildQuerySequencesRun(DataRuntime runtime, Catalog catalog, Schema schema, String name) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String catalogName = null;
        String schemaName = null;
        if (null != catalog) {
            catalogName = catalog.getName();
        }
        if (null != schema) {
            schemaName = schema.getName();
        }
        builder.append("SELECT * FROM pg_sequences WHERE 1=1\n");
        if (BasicUtil.isNotEmpty((Object)catalogName)) {
            builder.append(" AND SEQUENCEOWNER = '").append(catalogName).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)schemaName)) {
            builder.append(" AND SCHEMANAME = '").append(schemaName).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)name)) {
            builder.append(" AND SEQUENCENAME = '").append(name).append("'");
        }
        return runs;
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, int index, boolean create, List<T> sequences, DataSet set) throws Exception {
        if (null == sequences) {
            sequences = new ArrayList<T>();
        }
        for (DataRow row : set) {
            String name = row.getString("SEQUENCENAME");
            Sequence sequence = new Sequence(name);
            sequences.add(this.init(sequence, row));
        }
        return sequences;
    }

    @Override
    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> sequences, DataSet set) throws Exception {
        if (null == sequences) {
            sequences = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("SEQUENCENAME");
            Sequence sequence = (Sequence)sequences.get(name.toUpperCase());
            sequences.put(name.toUpperCase(), this.init(sequence, row));
        }
        return sequences;
    }

    protected Sequence init(Sequence sequence, DataRow row) {
        if (null == sequence) {
            sequence = new Sequence();
        }
        sequence.setName(row.getString("SEQUENCENAME"));
        sequence.setCatalog(row.getString("SEQUENCEOWNER"));
        sequence.setSchema(row.getString("SCHEMANAME"));
        sequence.setLast(row.getLong("LAST_NUMBER", (Long)null));
        sequence.setMin(row.getLong("MIN_VALUE", (Long)null));
        sequence.setStart(row.getLong("START_VALUE", (Long)null));
        sequence.setMax(row.getLong("MAX_VALUE", (Long)null));
        sequence.setIncrement(row.getInt("INCREMENT_BY", Integer.valueOf(1)).intValue());
        sequence.setCache(row.getInt("CACHE_SIZE", null).intValue());
        sequence.setCycle(row.getBoolean("CYCLE", null));
        return sequence;
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, boolean create, List<T> sequences) throws Exception {
        return super.sequences(runtime, create, sequences);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Sequence meta) {
        return super.ddl(runtime, random, meta);
    }

    @Override
    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildQueryDdlsRun(runtime, meta);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Sequence sequence, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, sequence, ddls, set);
    }

    @Override
    public <T extends Table> T table(List<T> tables, Catalog catalog, Schema schema, String name) {
        return super.table(tables, catalog, schema, name);
    }

    @Override
    public <T extends Schema> T schema(List<T> schemas, Catalog catalog, String name) {
        return super.schema(schemas, catalog, name);
    }

    @Override
    public <T extends Catalog> T catalog(List<T> catalogs, String name) {
        return super.catalog(catalogs, name);
    }

    @Override
    public <T extends Database> T database(List<T> databases, String name) {
        return super.database(databases, name);
    }

    public boolean slice() {
        return true;
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, BaseMetadata meta, ACTION.DDL action, Run run) {
        return super.execute(runtime, random, meta, action, run);
    }

    @Override
    public boolean create(DataRuntime runtime, Table meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Table meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Table origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public String keyword(Table meta) {
        return "TABLE";
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Table table, Collection<Column> columns) throws Exception {
        return super.buildAlterRun(runtime, table, columns);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Table meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, (BaseMetadata)meta);
        builder.append(" RENAME TO ");
        Table update = new Table(meta.getUpdate().getName());
        this.name(runtime, builder, (BaseMetadata)update);
        return runs;
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Table meta) throws Exception {
        LinkedHashMap columns;
        ArrayList<Run> runs = new ArrayList<Run>();
        if (null != meta && null != (columns = meta.getColumns())) {
            for (Column column : columns.values()) {
                runs.addAll(this.buildChangeCommentRun(runtime, column));
            }
        }
        return runs;
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table meta) throws Exception {
        return this.buildChangeCommentRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String comment = meta.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            SimpleRun run = new SimpleRun(runtime);
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("COMMENT ON TABLE ");
            this.name(runtime, builder, (BaseMetadata)meta);
            builder.append(" IS '").append(comment).append("'");
        }
        return runs;
    }

    @Override
    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTableExists(runtime, builder, exists);
    }

    @Override
    public void checkPrimary(DataRuntime runtime, Table table) {
        super.checkPrimary(runtime, table);
    }

    @Override
    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table meta) {
        PrimaryKey primary = meta.getPrimaryKey();
        LinkedHashMap pks = null;
        String name = null;
        if (null != primary) {
            pks = primary.getColumns();
            name = primary.getName();
        } else {
            pks = meta.primarys();
            name = "pk_" + meta.getName();
        }
        if (!pks.isEmpty()) {
            this.checkName(runtime, null, meta);
            builder.append(",CONSTRAINT ");
            this.delimiter(builder, name);
            builder.append(" PRIMARY KEY (");
            Column.sort((LinkedHashMap)primary.getPositions(), (LinkedHashMap)pks);
            this.delimiter(builder, Column.names((LinkedHashMap)pks));
            builder.append(")");
        }
        return builder;
    }

    @Override
    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.charset(runtime, builder, meta);
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table meta) {
        return builder;
    }

    @Override
    public StringBuilder partitionBy(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        return super.partitionBy(runtime, builder, meta);
    }

    @Override
    public StringBuilder partitionOf(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        return super.partitionOf(runtime, builder, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, View meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, View meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, View meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, View origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public StringBuilder buildCreateRunHead(DataRuntime runtime, StringBuilder builder, View meta) throws Exception {
        if (null == builder) {
            builder = new StringBuilder();
        }
        builder.append("CREATE");
        if (meta.isMaterialize()) {
            builder.append(" MATERIALIZED");
        }
        builder.append(" VIEW ");
        this.name(runtime, builder, (BaseMetadata)meta);
        return builder;
    }

    @Override
    public StringBuilder buildCreateRunOption(DataRuntime runtime, StringBuilder builder, View meta) throws Exception {
        return super.buildCreateRunOption(runtime, builder, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    @Override
    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkViewExists(runtime, builder, exists);
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, View meta) {
        return super.comment(runtime, builder, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, MasterTable origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, MasterTable meta) throws Exception {
        meta.setKeyword("TABLE");
        MasterTable tab = meta;
        return super.buildCreateRun(runtime, (Table)tab);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, PartitionTable origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        meta.setKeyword("TABLE");
        PartitionTable tab = meta;
        return this.buildCreateRun(runtime, (Table)tab);
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, Column meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Column meta, boolean trigger) throws Exception {
        return super.alter(runtime, table, meta, trigger);
    }

    @Override
    public boolean alter(DataRuntime runtime, Column meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Column meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Column origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildAddRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Column meta) throws Exception {
        return this.buildAddRun(runtime, meta, false);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildAlterRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Column meta) throws Exception {
        return this.buildAlterRun(runtime, meta, false);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildDropRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Column meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        this.checkName(runtime, null, meta);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, (BaseMetadata)meta.getTable(true));
        builder.append(" RENAME ");
        this.delimiter(builder, meta.getName());
        builder.append(" TO ");
        this.delimiter(builder, ((Column)meta.getUpdate()).getName());
        meta.setName(((Column)meta.getUpdate()).getName());
        return runs;
    }

    @Override
    public List<Run> buildChangeTypeRun(DataRuntime runtime, Column meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Column update = (Column)meta.getUpdate();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, (BaseMetadata)meta.getTable(true));
        builder.append(" ALTER COLUMN ");
        this.delimiter(builder, meta.getName());
        builder.append(" TYPE ");
        this.type(runtime, builder, update);
        String type = update.getTypeName();
        if (type.contains("(")) {
            type = type.substring(0, type.indexOf("("));
        }
        builder.append(" USING ");
        this.delimiter(builder, meta.getName());
        builder.append("::").append(type);
        return runs;
    }

    @Override
    public String alterColumnKeyword(DataRuntime runtime) {
        return super.alterColumnKeyword(runtime);
    }

    @Override
    public StringBuilder addColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.addColumnGuide(runtime, builder, meta);
    }

    @Override
    public StringBuilder dropColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.dropColumnGuide(runtime, builder, meta);
    }

    @Override
    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Column meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Object def = null;
        def = null != meta.getUpdate() ? ((Column)meta.getUpdate()).getDefaultValue() : meta.getDefaultValue();
        if (null != def) {
            String str = def.toString();
            if (str.contains("::")) {
                str = str.split("::")[0];
            }
            str = str.replace("'", "");
            def = str;
        }
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, (BaseMetadata)meta.getTable(true)).append(" ALTER COLUMN ");
        this.delimiter(builder, meta.getName());
        if (null != def) {
            builder.append(" SET DEFAULT '").append(def).append("'");
        } else {
            builder.append(" DROP DEFAULT");
        }
        return runs;
    }

    @Override
    public List<Run> buildChangeNullableRun(DataRuntime runtime, Column meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        int nullable = meta.isNullable();
        int uNullable = ((Column)meta.getUpdate()).isNullable();
        if (nullable != -1 && uNullable != -1 && nullable != uNullable) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, (BaseMetadata)meta.getTable(true)).append(" ALTER ");
            this.delimiter(builder, meta.getName());
            if (uNullable == 0) {
                builder.append(" SET ");
            } else {
                builder.append(" DROP ");
            }
            builder.append(" NOT NULL");
            meta.setNullable(uNullable);
        }
        return runs;
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String comment = null;
        Column update = (Column)meta.getUpdate();
        if (null != update) {
            comment = update.getComment();
        }
        if (BasicUtil.isEmpty(comment)) {
            comment = meta.getComment();
        }
        if (BasicUtil.isNotEmpty((Object)comment)) {
            SimpleRun run = new SimpleRun(runtime);
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("COMMENT ON COLUMN ");
            this.name(runtime, builder, (BaseMetadata)meta.getTable(true)).append(".");
            this.delimiter(builder, meta.getName());
            builder.append(" IS '").append(comment).append("'");
        }
        return runs;
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Column meta) throws Exception {
        return this.buildChangeCommentRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropAutoIncrement(DataRuntime runtime, Column meta) throws Exception {
        return super.buildDropAutoIncrement(runtime, meta);
    }

    @Override
    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.define(runtime, builder, meta);
    }

    @Override
    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkColumnExists(runtime, builder, exists);
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta) {
        String type = meta.getTypeName();
        if (null == type) {
            type = "";
        }
        type = type.toLowerCase();
        boolean serial = false;
        if (ACTION.DDL.COLUMN_ADD == meta.getAction() && meta.isAutoIncrement() == 1) {
            serial = true;
        } else {
            Column update = (Column)meta.getUpdate();
            if (null != update && update.isAutoIncrement() != 1 && meta.isAutoIncrement() == 1) {
                serial = true;
            }
        }
        if (serial) {
            if ("int4".equals(type) || "int".equals(type) || "integer".equals(type)) {
                meta.setType("SERIAL4");
            } else if ("int8".equals(type) || "long".equals(type) || "bigint".equals(type)) {
                meta.setType("SERIAL8");
            } else if ("int2".equals(type) || "smallint".equals(type) || "short".equals(type)) {
                meta.setType("SERIAL2");
            } else {
                meta.setType("SERIAL8");
            }
        } else if (type.contains("int") || type.contains("long") || type.contains("serial") || type.contains("short")) {
            if ("serial4".equals(type) || "int".equals(type) || "integer".equals(type)) {
                meta.setType("int4");
            } else if ("serial8".equals(type) || "long".equals(type) || "bigint".equals(type)) {
                meta.setType("int8");
            } else if ("serial2".equals(type) || "smallint".equals(type) || "short".equals(type)) {
                meta.setType("int2");
            } else {
                meta.setType("int8");
            }
        }
        return super.type(runtime, builder, meta);
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta, String type, int ignoreLength, int ignorePrecision, int ignoreScale) {
        return super.type(runtime, builder, meta, type, ignoreLength, ignorePrecision, ignoreScale);
    }

    @Override
    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.nullable(runtime, builder, meta);
    }

    @Override
    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.charset(runtime, builder, meta);
    }

    @Override
    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.defaultValue(runtime, builder, meta);
    }

    @Override
    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.primary(runtime, builder, meta);
    }

    @Override
    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column meta) {
        return builder;
    }

    @Override
    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.onupdate(runtime, builder, meta);
    }

    @Override
    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.position(runtime, builder, meta);
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column meta) {
        return builder;
    }

    @Override
    public boolean add(DataRuntime runtime, Tag meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Tag meta, boolean trigger) throws Exception {
        return super.alter(runtime, table, meta, trigger);
    }

    @Override
    public boolean alter(DataRuntime runtime, Tag meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Tag meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Tag origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildAddRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildChangeDefaultRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeNullableRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildChangeNullableRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeTypeRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildChangeTypeRun(runtime, meta);
    }

    @Override
    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTagExists(runtime, builder, exists);
    }

    @Override
    public boolean add(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, PrimaryKey meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, PrimaryKey origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap columns = meta.getColumns();
        if (null != columns && !columns.isEmpty()) {
            if (!this.slice(slice)) {
                builder.append("ALTER TABLE ");
                this.name(runtime, builder, (BaseMetadata)meta.getTable(true));
            }
            builder.append(" ADD PRIMARY KEY (");
            Column.sort((LinkedHashMap)meta.getPositions(), (LinkedHashMap)columns);
            this.delimiter(builder, Column.names((LinkedHashMap)columns));
            builder.append(")");
        }
        return runs;
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey origin, PrimaryKey meta) throws Exception {
        return super.buildAlterRun(runtime, origin, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (!this.slice(slice)) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, (BaseMetadata)meta.getTable(true));
        }
        builder.append(" DROP CONSTRAINT ");
        this.delimiter(builder, meta.getName());
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, ForeignKey meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, ForeignKey origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildAddRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, Index meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Index meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Index meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Index meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Index origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAppendIndexRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAppendIndexRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Index meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Index meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (meta.isPrimary()) {
            log.info("[\u4e3b\u952e\u7d22\u5f15,\u5ffd\u7565\u5220\u9664][index:{}]", (Object)meta.getName());
        } else {
            builder.append("DROP INDEX ");
            this.delimiter(builder, meta.getName());
        }
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Index meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Index meta) {
        return super.type(runtime, builder, meta);
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Index meta) {
        return super.comment(runtime, builder, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, Constraint meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Constraint meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Constraint meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Constraint meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Constraint origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildAddRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, Trigger meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Trigger meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Trigger meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Trigger origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public StringBuilder each(DataRuntime runtime, StringBuilder builder, Trigger meta) {
        return super.each(runtime, builder, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, Procedure meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Procedure meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Procedure meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Procedure origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public StringBuilder parameter(DataRuntime runtime, StringBuilder builder, Parameter parameter) {
        return super.parameter(runtime, builder, parameter);
    }

    @Override
    public boolean create(DataRuntime runtime, Function meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Function meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Function meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Function origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, Sequence meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Sequence meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Sequence meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Sequence origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public <T extends BaseMetadata> void checkSchema(DataRuntime runtime, DataSource dataSource, T meta) {
        super.checkSchema(runtime, dataSource, meta);
    }

    @Override
    public <T extends BaseMetadata> void checkSchema(DataRuntime runtime, Connection con, T meta) {
        super.checkSchema(runtime, con, meta);
    }

    @Override
    public <T extends BaseMetadata> void checkSchema(DataRuntime runtime, T meta) {
        super.checkSchema(runtime, meta);
    }

    public <T extends BaseMetadata> void correctSchemaFromJDBC(T meta, String catalog, String schema, boolean override) {
        super.correctSchemaFromJDBC(meta, catalog, schema, override);
    }

    public <T extends BaseMetadata> void correctSchemaFromJDBC(T meta, String catalog, String schema) {
        super.correctSchemaFromJDBC(meta, catalog, schema);
    }

    public String[] correctSchemaFromJDBC(String catalog, String schema) {
        return super.correctSchemaFromJDBC(catalog, schema);
    }

    @Override
    public boolean identity(DataRuntime runtime, String random, Object data, ConfigStore configs, KeyHolder keyholder) {
        return super.identity(runtime, random, data, configs, keyholder);
    }

    public String columnMetadataLengthRefer(DataRuntime runtime, TypeMetadata meta) {
        return super.columnMetadataLengthRefer(runtime, meta);
    }

    public String columnMetadataPrecisionRefer(DataRuntime runtime, TypeMetadata meta) {
        return super.columnMetadataPrecisionRefer(runtime, meta);
    }

    public String columnMetadataScaleRefer(DataRuntime runtime, TypeMetadata meta) {
        return super.columnMetadataScaleRefer(runtime, meta);
    }

    @Override
    public String insertHead(ConfigStore configs) {
        return super.insertHead(configs);
    }

    @Override
    public String insertFoot(ConfigStore configs, LinkedHashMap<String, Column> columns) {
        StringBuilder builder = new StringBuilder();
        Boolean override = null;
        if (null != configs) {
            override = configs.override();
        }
        if (null != override) {
            builder.append(" ON CONFLICT");
            Constraint constraint = configs.overrideByConstraint();
            if (null != constraint) {
                builder.append(" ON CONSTRAINT ");
                this.delimiter(builder, constraint.getName());
            } else {
                ArrayList<String> bys = configs.overrideByColumns();
                if (null == bys) {
                    bys = configs.getPrimaryKeys();
                }
                if (null == bys) {
                    bys = new ArrayList<String>();
                }
                if (bys.isEmpty()) {
                    bys.add(ConfigTable.DEFAULT_PRIMARY_KEY);
                }
                builder.append("(").append(BeanUtil.concat(bys)).append(")");
            }
            if (override.booleanValue()) {
                builder.append(" DO UPDATE SET ");
                boolean first = true;
                for (Column column : columns.values()) {
                    if (!first) {
                        builder.append(",");
                    }
                    first = false;
                    builder.append(column.getName()).append(" = EXCLUDED.");
                    this.delimiter(builder, column.getName());
                }
            } else {
                builder.append(" DO NOTHING");
            }
        }
        return builder.toString();
    }

    @Override
    public Column column(DataRuntime runtime, Column column, ResultSetMetaData rsm, int index) {
        return super.column(runtime, column, rsm, index);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.columns(runtime, create, columns, dbmd, table, pattern);
    }

    @Override
    public Column column(DataRuntime runtime, Column column, ResultSet rs) {
        return super.column(runtime, column, rs);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(runtime, create, columns, table, set);
    }

    @Override
    public Column column(DataRuntime runtime, Column column, SqlRowSetMetaData rsm, int index) {
        return super.column(runtime, column, rsm, index);
    }

    @Override
    public DataRow row(boolean system, DataRuntime runtime, LinkedHashMap<String, Column> metadatas, ConfigStore configs, ResultSet rs) {
        return super.row(system, runtime, metadatas, configs, rs);
    }

    public String value(DataRuntime runtime, Column column, DriverAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_DATETIME) {
            return "now()";
        }
        return null;
    }

    @Override
    public String concat(DataRuntime runtime, String ... args) {
        return this.concatOr(runtime, args);
    }

    @Override
    protected String dummy() {
        return super.dummy();
    }
}

