/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.runtime;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.init.DefaultRuntime;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class JDBCRuntime
extends DefaultRuntime
implements DataRuntime {
    protected JdbcTemplate processor;
    protected String url;
    protected String driver;

    public JDBCRuntime(String key, JdbcTemplate jdbc, DriverAdapter adapter) {
        this.setKey(key);
        this.setProcessor(jdbc);
        this.setAdapter(adapter);
    }

    public JDBCRuntime() {
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public JdbcTemplate jdbc() {
        return this.processor;
    }

    public Object getProcessor() {
        return this.processor;
    }

    public void setProcessor(Object processor) {
        this.processor = (JdbcTemplate)processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getFeature(boolean connection) {
        if (null != this.feature) return this.feature;
        if (!connection && null != this.driver && null != this.url) return this.driver + "_" + this.url;
        JdbcTemplate jdbc = this.jdbc();
        if (null == jdbc) return this.feature;
        DataSource ds = null;
        Connection con = null;
        try {
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            DatabaseMetaData meta = con.getMetaData();
            this.feature = this.driver + "_" + meta.getDatabaseProductName().toLowerCase().replace(" ", "") + "_" + meta.getURL();
            if (null != this.version) return this.feature;
            this.version = meta.getDatabaseProductVersion();
            return this.feature;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.feature;
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        JdbcTemplate jdbc;
        if (null == this.version && null != (jdbc = this.jdbc())) {
            DataSource ds = null;
            Connection con = null;
            try {
                ds = jdbc.getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                DatabaseMetaData meta = con.getMetaData();
                this.version = meta.getDatabaseProductVersion();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                    DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
                }
            }
        }
        return this.version;
    }
}

