/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.adapter.init;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.adapter.KeyAdapter;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.init.DefaultDriverAdapter;
import org.anyline.data.handler.DataRowHandler;
import org.anyline.data.handler.EntityHandler;
import org.anyline.data.handler.MapHandler;
import org.anyline.data.handler.ResultSetHandler;
import org.anyline.data.handler.StreamHandler;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.runtime.JDBCRuntime;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.auto.AutoPrepare;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.prepare.auto.init.DefaultTextPrepare;
import org.anyline.data.run.ProcedureRun;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.run.TableRun;
import org.anyline.data.run.TextRun;
import org.anyline.data.run.XMLRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.Join;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.exception.SQLException;
import org.anyline.exception.SQLQueryException;
import org.anyline.exception.SQLUpdateException;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.BaseMetadata;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.Partition;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.type.ColumnType;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.proxy.CacheProxy;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.proxy.InterceptorProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.anyline.util.encrypt.MD5Util;
import org.anyline.util.regular.RegularUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;

public class DefaultJDBCAdapter
extends DefaultDriverAdapter
implements JDBCAdapter {
    protected static final Logger log = LoggerFactory.getLogger(DefaultJDBCAdapter.class);

    public DatabaseType type() {
        return DatabaseType.COMMON;
    }

    protected JdbcTemplate jdbc(DataRuntime runtime) {
        Object processor = runtime.getProcessor();
        return (JdbcTemplate)processor;
    }

    public boolean match(DataRuntime runtime, boolean compensate) {
        return super.match(runtime, compensate);
    }

    public boolean match(String feature, List<String> keywords, boolean compensate) {
        return super.match(feature, keywords, compensate);
    }

    public long insert(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.insert(runtime, random, batch, dest, data, configs, columns);
    }

    public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        Run run = null;
        if (null == obj) {
            return null;
        }
        if (null == dest) {
            dest = DataSourceUtil.parseDest(null, (Object)obj, (ConfigStore)configs);
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            if (list.size() > 0) {
                run = this.createInsertRunFromCollection(runtime, batch, dest, list, configs, columns);
            }
        } else {
            run = this.createInsertRun(runtime, dest, obj, configs, columns);
        }
        this.convert(runtime, configs, run);
        return run;
    }

    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        StringBuilder builder = run.getBuilder();
        int batch = run.getBatch();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        LinkedHashMap pks = null;
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.getName());
        if (null != generator) {
            pks = set.getRow(0).getPrimaryColumns();
            columns.putAll(pks);
        }
        String head = this.insertHead(configs);
        builder.append(head);
        this.name(runtime, builder, (BaseMetadata)dest);
        builder.append("(");
        boolean first = true;
        for (Column column : columns.values()) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            String key = column.getName();
            this.delimiter(builder, key);
        }
        builder.append(") VALUES ");
        if (batch > 1) {
            builder.append("(");
            int size = columns.size();
            run.setVol(size);
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append("?");
            }
            builder.append(")");
        }
        int dataSize = set.size();
        for (int i = 0; i < dataSize; ++i) {
            DataRow row = set.getRow(i);
            if (null == row) continue;
            if (row.hasPrimaryKeys() && BasicUtil.isEmpty((Object)row.getPrimaryValue()) && null != generator) {
                generator.create((Object)row, this.type(), dest.getName().replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), BeanUtil.getMapKeys((Map)pks), null);
            }
            builder.append(this.insertValue(runtime, run, row, true, true, false, true, columns));
            if (batch > 1 || i >= dataSize - 1) continue;
            builder.append(this.batchInsertSeparator());
        }
        builder.append(this.insertFoot(configs, columns));
    }

    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        StringBuilder builder = run.getBuilder();
        int batch = run.getBatch();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            this.fillInsertContent(runtime, run, dest, set, configs, columns);
            return;
        }
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.getName());
        Object entity = list.iterator().next();
        List pks = null;
        if (null != generator) {
            columns.putAll(EntityAdapterProxy.primaryKeys(entity.getClass()));
        }
        String head = this.insertHead(configs);
        builder.append(head);
        this.name(runtime, builder, (BaseMetadata)dest);
        builder.append("(");
        boolean first = true;
        for (Column column : columns.values()) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            this.delimiter(builder, column.getName());
        }
        builder.append(") VALUES ");
        int dataSize = list.size();
        int idx = 0;
        if (batch > 1) {
            builder.append("(");
            int size = columns.size();
            run.setVol(size);
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append("?");
            }
            builder.append(")");
        }
        for (Object obj : list) {
            boolean create = EntityAdapterProxy.createPrimaryValue(obj, (List)Column.names(columns));
            if (!create && null != generator) {
                generator.create(obj, this.type(), dest.getName().replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pks, null);
            }
            builder.append(this.insertValue(runtime, run, obj, true, true, false, true, columns));
            if (idx < dataSize - 1 && batch <= 1) {
                builder.append(this.batchInsertSeparator());
            }
            ++idx;
        }
        builder.append(this.insertFoot(configs, columns));
    }

    public LinkedHashMap<String, Column> confirmInsertColumns(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns, boolean batch) {
        return super.confirmInsertColumns(runtime, dest, obj, configs, columns, batch);
    }

    public String batchInsertSeparator() {
        return ",";
    }

    public boolean supportInsertPlaceholder() {
        return true;
    }

    protected void setPrimaryValue(Object obj, Object value) {
        super.setPrimaryValue(obj, value);
    }

    protected Run createInsertRun(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        TableRun run = new TableRun(runtime, dest);
        StringBuilder builder = new StringBuilder();
        if (BasicUtil.isEmpty((Object)dest)) {
            throw new SQLException("\u672a\u6307\u5b9a\u8868");
        }
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.getName());
        int from = 1;
        StringBuilder valuesBuilder = new StringBuilder();
        DataRow row = null;
        if (obj instanceof Map && !(obj instanceof DataRow)) {
            obj = new DataRow((Map)obj);
        }
        if (obj instanceof DataRow) {
            row = (DataRow)obj;
            if (row.hasPrimaryKeys() && null != generator) {
                generator.create((Object)row, this.type(), dest.getName().replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), row.getPrimaryKeys(), null);
            }
        } else {
            from = 2;
            boolean create = EntityAdapterProxy.createPrimaryValue((Object)obj, columns);
            LinkedHashMap pks = EntityAdapterProxy.primaryKeys(obj.getClass());
            if (!create && null != generator) {
                generator.create(obj, this.type(), dest.getName().replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pks, null);
            }
        }
        run.setFrom(from);
        LinkedHashMap<String, Column> cols = this.confirmInsertColumns(runtime, dest, obj, configs, columns, false);
        if (null == cols || cols.size() == 0) {
            throw new SQLException("\u672a\u6307\u5b9a\u5217(DataRow\u6216Entity\u4e2d\u6ca1\u6709\u9700\u8981\u63d2\u5165\u7684\u5c5e\u6027\u503c)[" + obj.getClass().getName() + ":" + BeanUtil.object2json((Object)obj) + "]");
        }
        boolean replaceEmptyNull = false;
        if (obj instanceof DataRow) {
            row = (DataRow)obj;
            replaceEmptyNull = row.isReplaceEmptyNull();
        } else {
            replaceEmptyNull = this.IS_REPLACE_EMPTY_NULL(configs);
        }
        String head = this.insertHead(configs);
        builder.append(head);
        this.name(runtime, builder, (BaseMetadata)dest);
        builder.append("(");
        valuesBuilder.append(") VALUES (");
        ArrayList<String> insertColumns = new ArrayList<String>();
        boolean first = true;
        for (Column column : cols.values()) {
            if (!first) {
                builder.append(",");
                valuesBuilder.append(",");
            }
            first = false;
            String key = column.getName();
            Object value = null;
            value = !(obj instanceof Map) && EntityAdapterProxy.hasAdapter(obj.getClass()) ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key);
            String str = null;
            if (value instanceof String) {
                str = (String)value;
            }
            this.delimiter(builder, key);
            if (BasicUtil.checkEl((String)str)) {
                value = str.substring(2, str.length() - 1);
                valuesBuilder.append(value);
                continue;
            }
            if (null != value && value instanceof DriverAdapter.SQL_BUILD_IN_VALUE) {
                value = this.value(runtime, null, (DriverAdapter.SQL_BUILD_IN_VALUE)value);
                valuesBuilder.append(value);
                continue;
            }
            insertColumns.add(key);
            if (this.supportInsertPlaceholder()) {
                valuesBuilder.append("?");
                if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && replaceEmptyNull) {
                    value = null;
                }
                this.addRunValue(runtime, (Run)run, Compare.EQUAL, column, value);
                continue;
            }
            valuesBuilder.append(this.write(runtime, null, value, false));
        }
        valuesBuilder.append(")");
        builder.append((CharSequence)valuesBuilder);
        builder.append(this.insertFoot(configs, cols));
        run.setBuilder(builder);
        run.setInsertColumns(insertColumns);
        return run;
    }

    protected Run createInsertRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore configs, List<String> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setBatch(batch);
        if (null == list || list.isEmpty()) {
            throw new SQLException("\u7a7a\u6570\u636e");
        }
        Object first = list.iterator().next();
        if (BasicUtil.isEmpty((Object)dest)) {
            throw new SQLException("\u672a\u6307\u5b9a\u8868");
        }
        LinkedHashMap<String, Column> cols = this.confirmInsertColumns(runtime, dest, first, configs, columns, true);
        if (null == cols || cols.size() == 0) {
            throw new SQLException("\u672a\u6307\u5b9a\u5217(DataRow\u6216Entity\u4e2d\u6ca1\u6709\u9700\u8981\u63d2\u5165\u7684\u5c5e\u6027\u503c)[" + first.getClass().getName() + ":" + BeanUtil.object2json(first) + "]");
        }
        run.setInsertColumns(cols);
        run.setVol(cols.size());
        this.fillInsertContent(runtime, (Run)run, dest, list, configs, cols);
        return run;
    }

    public String generatedKey() {
        return super.generatedKey();
    }

    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, final String[] pks) {
        long cnt;
        block23: {
            cnt = 0L;
            int batch = run.getBatch();
            String action = "insert";
            if (batch > 1) {
                action = "batch insert";
            }
            if (!run.isValid()) {
                if (log.isWarnEnabled() && this.IS_LOG_SQL(configs)) {
                    log.warn("[valid:false][action:{}][table:{}][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]", (Object)action, (Object)run.getTable());
                }
                return -1L;
            }
            final String sql = run.getFinalInsert();
            if (BasicUtil.isEmpty((Object)sql)) {
                log.warn("[\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][action:{}][table:{}]", (Object)action, (Object)run.getTable());
                return -1L;
            }
            if (null != configs) {
                configs.add(run);
            }
            final List values = run.getValues();
            long fr = System.currentTimeMillis();
            if (log.isInfoEnabled() && this.IS_LOG_SQL(configs)) {
                if (batch > 1 && !this.IS_LOG_BATCH_SQL_PARAM(configs)) {
                    log.info("{}[action:{}][table:{}][sql:\n{}\n]\n[param size:{}]", new Object[]{random, action, run.getTable(), sql, values.size()});
                } else {
                    log.info("{}[action:{}]{}", new Object[]{random, action, run.log(ACTION.DML.INSERT, this.IS_SQL_LOG_PLACEHOLDER(configs))});
                }
            }
            long millis = -1L;
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return -1L;
            }
            GeneratedKeyHolder keyholder = null;
            JdbcTemplate jdbc = this.jdbc(runtime);
            if (null == jdbc) {
                return -1L;
            }
            try {
                if (batch > 1) {
                    cnt = this.batch(jdbc, sql, batch, run.getVol(), values);
                } else if (this.IS_KEYHOLDER_IDENTITY(configs)) {
                    keyholder = new GeneratedKeyHolder();
                    cnt = jdbc.update(new PreparedStatementCreator(){

                        public PreparedStatement createPreparedStatement(Connection con) throws java.sql.SQLException {
                            PreparedStatement ps = null;
                            ps = null != pks && pks.length > 0 ? con.prepareStatement(sql, pks) : con.prepareStatement(sql, 1);
                            int idx = 0;
                            if (null != values) {
                                for (Object obj : values) {
                                    ps.setObject(++idx, obj);
                                }
                            }
                            return ps;
                        }
                    }, (KeyHolder)keyholder);
                } else {
                    cnt = null != values && !values.isEmpty() ? (long)jdbc.update(sql, values.toArray()) : (long)jdbc.update(sql);
                }
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = this.SLOW_SQL_MILLIS(configs);
                if (SLOW_SQL_MILLIS > 0L && this.IS_LOG_SLOW_SQL(configs) && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:{}][table:{}][\u6267\u884c\u8017\u65f6:{}ms]{}", new Object[]{random, action, run.getTable(), millis, run.log(ACTION.DML.INSERT, this.IS_SQL_LOG_PLACEHOLDER(configs))});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.INSERT, run, sql, values, null, true, (Object)cnt, millis);
                    }
                }
                if (!slow && log.isInfoEnabled() && this.IS_LOG_SQL_TIME(configs)) {
                    String qty = LogUtil.format((long)cnt, (int)34);
                    if (batch > 1) {
                        qty = LogUtil.format((String)("\u7ea6" + cnt), (int)34);
                    }
                    log.info("{}[action:{}][table:{}][\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, action, run.getTable(), millis, qty});
                }
                this.identity(runtime, random, data, configs, (KeyHolder)keyholder);
            }
            catch (Exception e) {
                if (this.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                    e.printStackTrace();
                }
                if (this.IS_LOG_SQL_WHEN_ERROR(configs)) {
                    log.error("{}[{}][action:{}][table:{}]{}", new Object[]{random, LogUtil.format((String)"\u63d2\u5165\u5f02\u5e38:", (int)33) + e, action, run.getTable(), run.log(ACTION.DML.INSERT, this.IS_SQL_LOG_PLACEHOLDER(configs))});
                }
                if (!this.IS_THROW_SQL_UPDATE_EXCEPTION(configs)) break block23;
                SQLUpdateException ex = new SQLUpdateException("insert\u5f02\u5e38:" + e.toString(), e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
        }
        return cnt;
    }

    public long update(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.update(runtime, random, batch, dest, data, configs, columns);
    }

    public Run buildUpdateRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        return super.buildUpdateRun(runtime, batch, dest, obj, configs, columns);
    }

    public Run buildUpdateRunFromEntity(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromEntity(runtime, dest, obj, configs, columns);
    }

    public Run buildUpdateRunFromDataRow(DataRuntime runtime, Table dest, DataRow row, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromDataRow(runtime, dest, row, configs, columns);
    }

    public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromCollection(runtime, batch, dest, list, configs, columns);
    }

    public Run buildUpdateRunFromEntity(DataRuntime runtime, String dest, Object obj, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return null;
    }

    public Run buildUpdateRunFromDataRow(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return null;
    }

    public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return null;
    }

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, Table dest, DataRow row, ConfigStore configs, List<String> columns) {
        return super.confirmUpdateColumns(runtime, dest, row, configs, columns);
    }

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        return super.confirmUpdateColumns(runtime, dest, obj, configs, columns);
    }

    public long update(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, Run run) {
        long result;
        block19: {
            result = 0L;
            if (!run.isValid()) {
                if (log.isWarnEnabled() && this.IS_LOG_SQL(configs)) {
                    log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + dest + "]");
                }
                return -1L;
            }
            String sql = null;
            sql = run.getFinalUpdate();
            if (BasicUtil.isEmpty((Object)sql)) {
                log.warn("[\u4e0d\u5177\u5907\u66f4\u65b0\u6761\u4ef6][dest:{}]", (Object)dest);
                return -1L;
            }
            if (null != configs) {
                configs.add(run);
            }
            List values = run.getValues();
            int batch = run.getBatch();
            String action = "update";
            if (batch > 1) {
                action = "batch update";
            }
            long fr = System.currentTimeMillis();
            if (log.isInfoEnabled() && this.IS_LOG_SQL(configs)) {
                if (batch > 1 && !this.IS_LOG_BATCH_SQL_PARAM(configs)) {
                    log.info("{}[action:{}][table:{}]{}", new Object[]{random, action, run.getTable(), run.log(ACTION.DML.UPDATE, this.IS_SQL_LOG_PLACEHOLDER(configs))});
                } else {
                    log.info("{}[action:update][table:{}]{}", new Object[]{random, run.getTable(), run.log(ACTION.DML.UPDATE, this.IS_SQL_LOG_PLACEHOLDER(configs))});
                }
            }
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return -1L;
            }
            long millis = -1L;
            try {
                JdbcTemplate jdbc = this.jdbc(runtime);
                if (null == jdbc) {
                    return -1L;
                }
                result = batch > 1 ? this.batch(jdbc, sql, batch, run.getVol(), values) : (long)jdbc.update(sql, values.toArray());
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = this.SLOW_SQL_MILLIS(configs);
                if (SLOW_SQL_MILLIS > 0L && this.IS_LOG_SLOW_SQL(configs) && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:{}][table:{}][\u6267\u884c\u8017\u65f6:{}ms]{}", new Object[]{random, action, run.getTable(), millis, run.log(ACTION.DML.UPDATE, this.IS_SQL_LOG_PLACEHOLDER(configs))});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.UPDATE, run, sql, values, null, true, (Object)result, millis);
                    }
                }
                if (!slow && log.isInfoEnabled() && this.IS_LOG_SQL_TIME(configs)) {
                    String qty = result + "";
                    if (batch > 1) {
                        qty = "\u7ea6" + result;
                    }
                    log.info("{}[action:{}][table:{}][\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, action, run.getTable(), millis, LogUtil.format((String)qty, (int)34)});
                }
            }
            catch (Exception e) {
                if (this.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                    e.printStackTrace();
                }
                if (this.IS_THROW_SQL_UPDATE_EXCEPTION(configs)) {
                    SQLUpdateException ex = new SQLUpdateException("update\u5f02\u5e38:" + e.toString(), e);
                    ex.setSql(sql);
                    ex.setValues(values);
                    throw ex;
                }
                if (!this.IS_LOG_SQL_WHEN_ERROR(configs)) break block19;
                log.error("{}[{}][action:update][table:{}]{}", new Object[]{random, run.getTable(), LogUtil.format((String)"\u66f4\u65b0\u5f02\u5e38:", (int)33) + e.toString(), run.log(ACTION.DML.UPDATE, this.IS_SQL_LOG_PLACEHOLDER(configs))});
            }
        }
        return result;
    }

    public long save(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.save(runtime, random, dest, data, configs, columns);
    }

    protected long saveCollection(DataRuntime runtime, String random, Table dest, Collection<?> data, ConfigStore configs, List<String> columns) {
        return super.saveCollection(runtime, random, dest, data, configs, columns);
    }

    protected long saveObject(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.saveObject(runtime, random, dest, data, configs, columns);
    }

    protected Boolean checkOverride(Object obj) {
        return super.checkOverride(obj);
    }

    protected Map<String, Object> checkPv(Object obj) {
        return super.checkPv(obj);
    }

    protected boolean isMultipleValue(DataRuntime runtime, TableRun run, String key) {
        return super.isMultipleValue(runtime, run, key);
    }

    protected boolean isMultipleValue(Column column) {
        return super.isMultipleValue(column);
    }

    public LinkedHashMap<String, Column> checkMetadata(DataRuntime runtime, Table table, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.checkMetadata(runtime, table, configs, columns);
    }

    public DataSet querys(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.querys(runtime, random, prepare, configs, conditions);
    }

    public DataSet querys(DataRuntime runtime, String random, final Procedure procedure, final PageNavi navi) {
        DataSet set;
        block12: {
            set = null;
            final List inputs = procedure.getInputs();
            final List outputs = procedure.getOutputs();
            if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:procedure][sql:\n{}\n][input param:{}]\n[output param:{}]", new Object[]{random, procedure.getName(), LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
            }
            final String rdm = random;
            long millis = -1L;
            try {
                ACTION.SWITCH swt = InterceptorProxy.prepareQuery((DataRuntime)runtime, (String)random, (Procedure)procedure, (PageNavi)navi);
                if (swt == ACTION.SWITCH.BREAK) {
                    return new DataSet();
                }
                swt = InterceptorProxy.beforeQuery((DataRuntime)runtime, (String)random, (Procedure)procedure, (PageNavi)navi);
                if (swt == ACTION.SWITCH.BREAK) {
                    return new DataSet();
                }
                if (null != this.dmListener) {
                    this.dmListener.beforeQuery(runtime, random, procedure);
                }
                final DataRuntime rt = runtime;
                JdbcTemplate jdbc = this.jdbc(runtime);
                if (null == jdbc) {
                    return new DataSet();
                }
                long fr = System.currentTimeMillis();
                set = (DataSet)jdbc.execute(new CallableStatementCreator(){

                    public CallableStatement createCallableStatement(Connection conn) throws java.sql.SQLException {
                        Parameter param;
                        int i;
                        String sql = "{call " + procedure.getName() + "(";
                        int sizeIn = inputs.size();
                        int sizeOut = outputs.size();
                        int size = sizeIn + sizeOut;
                        for (int i2 = 0; i2 < size; ++i2) {
                            sql = sql + "?";
                            if (i2 >= size - 1) continue;
                            sql = sql + ",";
                        }
                        sql = sql + ")}";
                        CallableStatement cs = conn.prepareCall(sql);
                        for (i = 1; i <= sizeIn; ++i) {
                            param = (Parameter)inputs.get(i - 1);
                            Object value = param.getValue();
                            if (null == value || "NULL".equalsIgnoreCase(value.toString())) {
                                value = null;
                            }
                            cs.setObject(i, value, (int)param.getType());
                        }
                        for (i = 1; i <= sizeOut; ++i) {
                            param = (Parameter)outputs.get(i - 1);
                            if (null == param.getValue()) {
                                cs.registerOutParameter(i + sizeIn, (int)param.getType());
                                continue;
                            }
                            cs.setObject(i, param.getValue(), (int)param.getType());
                        }
                        return cs;
                    }
                }, (CallableStatementCallback)new CallableStatementCallback<Object>(){

                    public Object doInCallableStatement(CallableStatement cs) throws java.sql.SQLException, DataAccessException {
                        ResultSet rs = cs.executeQuery();
                        DataSet set = new DataSet();
                        ResultSetMetaData rsmd = rs.getMetaData();
                        int cols = rsmd.getColumnCount();
                        for (int i = 1; i <= cols; ++i) {
                            String name = rsmd.getColumnLabel(i);
                            if (null == name) {
                                name = rsmd.getColumnName(i);
                            }
                            set.addHead(name);
                        }
                        long mid = System.currentTimeMillis();
                        int index = 0;
                        long first = -1L;
                        long last = -1L;
                        if (null != navi) {
                            first = navi.getFirstRow();
                            last = navi.getLastRow();
                        }
                        while (rs.next()) {
                            if (first == -1L || (long)index >= first && (long)index <= last) {
                                DataRow row = new DataRow();
                                for (int i = 1; i <= cols; ++i) {
                                    row.put(false, rsmd.getColumnLabel(i), rs.getObject(i));
                                }
                                set.addRow(row);
                            }
                            if (first == -1L || (long)(++index) <= last && (first != 0L || last != 0L)) continue;
                        }
                        if (null != navi) {
                            navi.setTotalRow((long)index);
                            set.setNavi(navi);
                        }
                        set.setDatalink(rt.datasource());
                        if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                            log.info("{}[\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{rdm, System.currentTimeMillis() - mid, set.size()});
                        }
                        return set;
                    }
                });
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ConfigTable.SLOW_SQL_MILLIS;
                if (SLOW_SQL_MILLIS > 0L && ConfigTable.IS_LOG_SLOW_SQL && millis > SLOW_SQL_MILLIS) {
                    log.warn("{}[slow cmd][action:procedure][\u6267\u884c\u8017\u65f6:{}ms][sql:\n{}\n][input param:{}]\n[output param:{}]", new Object[]{random, millis, procedure.getName(), LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.PROCEDURE, null, procedure.getName(), inputs, outputs, true, (Object)set, millis);
                    }
                }
                if (!slow && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[action:procedure][\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)millis);
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38:" + e.toString(), e);
                    throw ex;
                }
                if (!ConfigTable.IS_LOG_SQL_WHEN_ERROR) break block12;
                log.error("{}[{}][action:procedure][sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, LogUtil.format((String)"\u5b58\u50a8\u8fc7\u7a0b\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), procedure.getName(), LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
            }
        }
        return set;
    }

    public <T> EntitySet<T> selects(DataRuntime runtime, String random, RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return super.selects(runtime, random, prepare, clazz, configs, conditions);
    }

    protected <T> EntitySet<T> select(DataRuntime runtime, String random, Class<T> clazz, Table table, ConfigStore configs, Run run) {
        return super.select(runtime, random, clazz, table, configs, run);
    }

    public List<Map<String, Object>> maps(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.maps(runtime, random, prepare, configs, conditions);
    }

    public Run buildQueryRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.buildQueryRun(runtime, prepare, configs, conditions);
    }

    public List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names) {
        return super.buildQuerySequence(runtime, next, names);
    }

    public void fillQueryContent(DataRuntime runtime, Run run) {
        super.fillQueryContent(runtime, run);
    }

    protected void fillQueryContent(DataRuntime runtime, XMLRun run) {
        super.fillQueryContent(runtime, run);
    }

    protected void fillQueryContent(DataRuntime runtime, TextRun run) {
        this.replaceVariable(runtime, run);
        run.appendCondition();
        run.appendGroup();
        run.checkValid();
    }

    protected void fillQueryContent(DataRuntime runtime, TableRun run) {
        List joins;
        ConfigStore configs;
        StringBuilder builder = run.getBuilder();
        TablePrepare sql = (TablePrepare)run.getPrepare();
        builder.append("SELECT ");
        if (null != sql.getDistinct()) {
            builder.append(sql.getDistinct());
        }
        builder.append("\n\t");
        List columns = sql.getQueryColumns();
        if ((null == columns || columns.isEmpty()) && null != (configs = run.getConfigStore())) {
            columns = configs.columns();
        }
        if (null != columns && columns.size() > 0) {
            int size = columns.size();
            for (int i = 0; i < size; ++i) {
                String column = (String)columns.get(i);
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (BasicUtil.checkEl((String)column)) {
                    column = column.substring(2, column.length() - 1);
                    builder.append(column);
                } else if (column.toUpperCase().contains(" AS ") || column.contains("(") || column.contains(",")) {
                    builder.append(column);
                } else if ("*".equals(column)) {
                    builder.append("*");
                } else {
                    this.delimiter(builder, column);
                }
                if (i >= size - 1) continue;
                builder.append(",");
            }
            builder.append("\n");
        } else {
            builder.append("*");
            builder.append("\n");
        }
        Table table = run.getTable();
        builder.append("FROM").append("\n\t");
        this.name(runtime, builder, (BaseMetadata)table);
        String alias = table.getAlias();
        if (BasicUtil.isNotEmpty((Object)alias)) {
            builder.append(" ").append(alias);
        }
        builder.append("\n");
        if (BasicUtil.isNotEmpty((Object)sql.getAlias())) {
            builder.append("  ").append(sql.getAlias());
        }
        if (null != (joins = sql.getJoins())) {
            for (Join join : joins) {
                builder.append("\n\t").append(join.getType().getCode()).append(" ");
                Table joinTable = join.getTable();
                String joinTableAlias = joinTable.getAlias();
                this.name(runtime, builder, (BaseMetadata)joinTable);
                if (BasicUtil.isNotEmpty((Object)joinTableAlias)) {
                    builder.append("  ").append(joinTableAlias);
                }
                builder.append(" ON ").append(join.getCondition());
            }
        }
        builder.append("\nWHERE 1=1\n\t");
        run.appendCondition();
        run.appendGroup();
        run.appendOrderStore();
        run.checkValid();
    }

    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        return super.mergeFinalQuery(runtime, run);
    }

    public RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value) {
        int code = compare.getCode();
        if (code > 100) {
            builder.append(" NOT");
            code -= 100;
        }
        if (code == 50) {
            builder.append(" LIKE ").append(this.concat(runtime, "'%'", "?", "'%'"));
        } else if (code == 51) {
            builder.append(" LIKE ").append(this.concat(runtime, "?", "'%'"));
        } else if (code == 52) {
            builder.append(" LIKE ").append(this.concat(runtime, "'%'", "?"));
        }
        RunValue run = new RunValue();
        run.setValue(value);
        return run;
    }

    public Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value) {
        return super.createConditionFindInSet(runtime, builder, column, compare, value);
    }

    public StringBuilder createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value) {
        if (compare == Compare.NOT_IN) {
            builder.append(" NOT");
        }
        builder.append(" IN (");
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                builder.append("?");
                if (i >= size - 1) continue;
                builder.append(",");
            }
            builder.append(")");
        } else {
            builder.append("= ?");
        }
        return builder;
    }

    public DataSet select(DataRuntime runtime, String random, boolean system, Table table, ConfigStore configs, Run run) {
        if (run instanceof ProcedureRun) {
            ProcedureRun pr = (ProcedureRun)run;
            return this.querys(runtime, random, pr.getProcedure(), configs.getPageNavi());
        }
        String sql = run.getFinalQuery();
        if (BasicUtil.isEmpty((Object)sql)) {
            return new DataSet();
        }
        List values = run.getValues();
        return this.select(runtime, random, system, ACTION.DML.SELECT, table, configs, run, sql, values);
    }

    public List<Map<String, Object>> maps(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        List<Map<String, Object>> maps;
        block19: {
            maps = null;
            if (null == random) {
                random = this.random(runtime);
            }
            if (null != configs) {
                configs.add(run);
            }
            String sql = run.getFinalQuery();
            List values = run.getValues();
            if (BasicUtil.isEmpty((Object)sql)) {
                if (this.IS_THROW_SQL_QUERY_EXCEPTION(configs)) {
                    throw new SQLQueryException("\u672a\u6307\u5b9aSQL");
                }
                log.error("\u672a\u6307\u5b9aSQL");
                return new ArrayList<Map<String, Object>>();
            }
            long fr = System.currentTimeMillis();
            if (log.isInfoEnabled() && this.IS_LOG_SQL(configs)) {
                log.info("{}[action:select][sql:\n{}\n]", (Object)random, (Object)run.log(ACTION.DML.SELECT, this.IS_SQL_LOG_PLACEHOLDER(configs)));
            }
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return new ArrayList<Map<String, Object>>();
            }
            try {
                JdbcTemplate jdbc = this.jdbc(runtime);
                if (null == jdbc) {
                    return new ArrayList<Map<String, Object>>();
                }
                StreamHandler _handler = null;
                if (null != configs) {
                    _handler = configs.stream();
                }
                long[] count = new long[]{0L};
                boolean[] process = new boolean[]{false};
                StreamHandler handler = _handler;
                long[] mid = new long[]{System.currentTimeMillis()};
                if (null != handler) {
                    jdbc.query(con -> {
                        PreparedStatement ps = con.prepareStatement(sql, 1003, 1007);
                        ps.setFetchSize(handler.size());
                        ps.setFetchDirection(1000);
                        if (null != values && values.size() > 0) {
                            int idx = 0;
                            for (Object value : values) {
                                ps.setObject(++idx, value);
                            }
                        }
                        return ps;
                    }, rs -> {
                        if (!process[0]) {
                            lArray[0] = System.currentTimeMillis();
                            blArray[0] = true;
                        }
                        this.stream(handler, rs, configs, true, runtime, null);
                        lArray2[0] = count[0] + 1L;
                    });
                    maps = new ArrayList<Map<String, Object>>();
                } else {
                    maps = null != values && values.size() > 0 ? jdbc.queryForList(sql, values.toArray()) : jdbc.queryForList(sql);
                    mid[0] = System.currentTimeMillis();
                    count[0] = maps.size();
                }
                boolean slow = false;
                if (this.SLOW_SQL_MILLIS(configs) > 0L && mid[0] - fr > this.SLOW_SQL_MILLIS(configs)) {
                    slow = true;
                    log.warn("{}[slow cmd][action:select][\u6267\u884c\u8017\u65f6:{}ms]{}", new Object[]{random, mid[0] - fr, run.log(ACTION.DML.SELECT, this.IS_SQL_LOG_PLACEHOLDER(configs))});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.SELECT, null, sql, values, null, true, maps, mid[0] - fr);
                    }
                }
                if (!slow && log.isInfoEnabled() && this.IS_LOG_SQL_TIME(configs)) {
                    log.info("{}[action:select][\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)(mid[0] - fr));
                }
                maps = this.process(runtime, maps);
                if (!slow && log.isInfoEnabled() && this.IS_LOG_SQL_TIME(configs)) {
                    log.info("{}[action:select][\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, System.currentTimeMillis() - mid[0], count[0]});
                }
            }
            catch (Exception e) {
                if (this.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                    e.printStackTrace();
                }
                if (this.IS_LOG_SQL_WHEN_ERROR(configs)) {
                    log.error("{}[{}][action:select]{}", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), run.log(ACTION.DML.SELECT, this.IS_SQL_LOG_PLACEHOLDER(configs))});
                }
                if (!this.IS_THROW_SQL_QUERY_EXCEPTION(configs)) break block19;
                SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38:" + e.toString(), e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
        }
        return maps;
    }

    public Map<String, Object> map(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        long fr;
        List values;
        String sql;
        Map map;
        block12: {
            map = null;
            sql = run.getFinalExists();
            values = run.getValues();
            if (null != configs) {
                configs.add(run);
            }
            fr = System.currentTimeMillis();
            if (log.isInfoEnabled() && this.IS_LOG_SQL(configs)) {
                log.info("{}[action:select]{}", (Object)random, (Object)run.log(ACTION.DML.SELECT, this.IS_SQL_LOG_PLACEHOLDER(configs)));
            }
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return new HashMap<String, Object>();
            }
            try {
                JdbcTemplate jdbc = this.jdbc(runtime);
                if (null == jdbc) {
                    return new HashMap<String, Object>();
                }
                map = null != values && values.size() > 0 ? jdbc.queryForMap(sql, values.toArray()) : jdbc.queryForMap(sql);
            }
            catch (Exception e) {
                if (this.IS_THROW_SQL_QUERY_EXCEPTION(configs)) {
                    throw e;
                }
                if (!this.IS_LOG_SQL_WHEN_ERROR(configs)) break block12;
                if (this.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                    e.printStackTrace();
                }
                log.error("{}[{}][action:select][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e, sql, LogUtil.param((List)values)});
            }
        }
        Long millis = System.currentTimeMillis() - fr;
        boolean slow = false;
        long SLOW_SQL_MILLIS = this.SLOW_SQL_MILLIS(configs);
        if (SLOW_SQL_MILLIS > 0L && this.IS_LOG_SLOW_SQL(configs) && millis > SLOW_SQL_MILLIS) {
            slow = true;
            log.warn("{}[slow cmd][action:exists][\u6267\u884c\u8017\u65f6:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, sql, LogUtil.param((List)values)});
            if (null != this.dmListener) {
                this.dmListener.slow(runtime, random, ACTION.DML.EXISTS, run, sql, values, null, true, (Object)map, millis.longValue());
            }
        }
        if (!slow && log.isInfoEnabled() && this.IS_LOG_SQL_TIME(configs)) {
            log.info("{}[action:select][\u6267\u884c\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((int)(map == null ? 0 : 1), (int)34)});
        }
        return map;
    }

    public DataRow sequence(DataRuntime runtime, String random, boolean next, String ... names) {
        List<Run> runs = this.buildQuerySequence(runtime, next, names);
        if (null != runs && runs.size() > 0) {
            Run run = runs.get(0);
            if (!run.isValid()) {
                if (ConfigTable.IS_LOG_SQL && log.isWarnEnabled()) {
                    log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][sequence:" + names);
                }
                return new DataRow();
            }
            DataSet set = this.select(runtime, random, true, (Table)null, null, run);
            if (set.size() > 0) {
                return set.getRow(0);
            }
        }
        return new DataRow();
    }

    public List<Map<String, Object>> process(DataRuntime runtime, List<Map<String, Object>> list) {
        return super.process(runtime, list);
    }

    public long count(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.count(runtime, random, prepare, configs, conditions);
    }

    public String mergeFinalTotal(DataRuntime runtime, Run run) {
        String base = run.getBuilder().toString();
        StringBuilder builder = new StringBuilder();
        boolean simple = false;
        String upper = base.toUpperCase();
        if (upper.split("FROM").length == 2 && !upper.contains("DISTINCT") && !upper.contains("GROUP")) {
            simple = true;
        }
        if (simple) {
            int idx = base.toUpperCase().indexOf("FROM");
            builder.append("SELECT COUNT(*) AS CNT FROM ").append(base.substring(idx + 5));
        } else {
            builder.append("SELECT COUNT(*) AS CNT FROM (\n").append(base).append("\n) F");
        }
        String sql = builder.toString();
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE ");
        return sql;
    }

    public long count(DataRuntime runtime, String random, Run run) {
        long total = 0L;
        DataSet set = this.select(runtime, random, false, ACTION.DML.COUNT, null, null, run, run.getTotalQuery(), run.getValues());
        total = set.toUpperKey().getInt(0, "CNT", 0);
        return total;
    }

    public boolean exists(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        boolean result = false;
        if (null == random) {
            random = this.random(runtime);
        }
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        Run run = this.buildQueryRun(runtime, prepare, configs, conditions);
        if (!run.isValid()) {
            if (log.isWarnEnabled() && this.IS_LOG_SQL(configs)) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][RunPrepare:" + ConfigParser.createSQLSign((boolean)false, (boolean)false, (String)prepare.getTableName(), (ConfigStore)configs, (String[])conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
            }
            return false;
        }
        if (null != this.dmListener) {
            this.dmListener.beforeExists(runtime, random, run);
        }
        long fr = System.currentTimeMillis();
        Map<String, Object> map = this.map(runtime, random, configs, run);
        result = null == map ? false : BasicUtil.parseBoolean((Object)map.get("IS_EXISTS"), (Boolean)false);
        Long millis = System.currentTimeMillis() - fr;
        if (null != this.dmListener) {
            this.dmListener.afterExists(runtime, random, run, true, result, millis.longValue());
        }
        return result;
    }

    public String mergeFinalExists(DataRuntime runtime, Run run) {
        String sql = "SELECT EXISTS(\n" + run.getBuilder().toString() + "\n)  IS_EXISTS";
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE ");
        return sql;
    }

    public long execute(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.execute(runtime, random, prepare, configs, conditions);
    }

    public long execute(DataRuntime runtime, String random, int batch, ConfigStore configs, String cmd, List<Object> values) {
        return super.execute(runtime, random, batch, configs, cmd, values);
    }

    public boolean execute(DataRuntime runtime, String random, final Procedure procedure) {
        boolean result;
        block12: {
            result = false;
            ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
            boolean cmd_success = false;
            List list = new ArrayList();
            final List inputs = procedure.getInputs();
            final List outputs = procedure.getOutputs();
            long fr = System.currentTimeMillis();
            String sql = " {";
            boolean returnIndex = false;
            if (procedure.hasReturn()) {
                sql = sql + "? = ";
                returnIndex = true;
            }
            sql = sql + "call " + procedure.getName() + "(";
            final int sizeIn = inputs.size();
            final int sizeOut = outputs.size();
            int size = sizeIn + sizeOut;
            for (int i = 0; i < size; ++i) {
                sql = sql + "?";
                if (i >= size - 1) continue;
                sql = sql + ",";
            }
            sql = sql + ")}";
            if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:procedure][sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, sql, LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
            }
            long millis = -1L;
            try {
                JdbcTemplate jdbc = this.jdbc(runtime);
                if (null == jdbc) {
                    return false;
                }
                list = (List)jdbc.execute(sql, (CallableStatementCallback)new CallableStatementCallback<Object>(){

                    public Object doInCallableStatement(CallableStatement cs) throws java.sql.SQLException, DataAccessException {
                        Parameter param;
                        int i;
                        ArrayList<Object> result = new ArrayList<Object>();
                        int returnIndex = 0;
                        if (procedure.hasReturn()) {
                            returnIndex = 1;
                            cs.registerOutParameter(1, 12);
                        }
                        for (i = 1; i <= sizeIn; ++i) {
                            param = (Parameter)inputs.get(i - 1);
                            Object value = param.getValue();
                            if (null == value || "NULL".equalsIgnoreCase(value.toString())) {
                                value = null;
                            }
                            cs.setObject(i + returnIndex, value, (int)param.getType());
                        }
                        for (i = 1; i <= sizeOut; ++i) {
                            param = (Parameter)outputs.get(i - 1);
                            if (null == param.getValue()) {
                                cs.registerOutParameter(i + sizeIn + returnIndex, (int)param.getType());
                                continue;
                            }
                            cs.setObject(i + sizeIn + returnIndex, param.getValue(), (int)param.getType());
                        }
                        cs.execute();
                        if (procedure.hasReturn()) {
                            result.add(cs.getObject(1));
                        }
                        if (sizeOut > 0) {
                            for (i = 1; i <= sizeOut; ++i) {
                                Object output = cs.getObject(sizeIn + returnIndex + i);
                                result.add(output);
                            }
                        }
                        return result;
                    }
                });
                cmd_success = true;
                procedure.setResult(list);
                result = true;
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ConfigTable.SLOW_SQL_MILLIS;
                if (SLOW_SQL_MILLIS > 0L && ConfigTable.IS_LOG_SLOW_SQL && millis > SLOW_SQL_MILLIS) {
                    log.warn("{}[slow cmd][action:procedure][\u6267\u884c\u8017\u65f6:{}ms][sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, millis, sql, LogUtil.param((List)inputs), LogUtil.param(list)});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.PROCEDURE, null, sql, inputs, list, true, (Object)result, millis);
                    }
                }
                if (null != this.dmListener) {
                    this.dmListener.afterExecute(runtime, random, procedure, result, millis);
                }
                if (!slow && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[action:procedure][\u6267\u884c\u8017\u65f6:{}ms]\n[output param:{}]", new Object[]{random, millis, list});
                }
            }
            catch (Exception e) {
                result = false;
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    SQLUpdateException ex = new SQLUpdateException("execute\u5f02\u5e38:" + e.toString(), e);
                    ex.setSql(sql);
                    throw ex;
                }
                if (!ConfigTable.IS_LOG_SQL_WHEN_ERROR) break block12;
                log.error("{}[{}][action:procedure][sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, LogUtil.format((String)"\u5b58\u50a8\u8fc7\u7a0b\u6267\u884c\u5f02\u5e38:", (int)33) + e.toString(), sql, LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
            }
        }
        return result;
    }

    public Run buildExecuteRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.buildExecuteRun(runtime, prepare, configs, conditions);
    }

    protected void fillExecuteContent(DataRuntime runtime, XMLRun run) {
        super.fillExecuteContent(runtime, run);
    }

    protected void fillExecuteContent(DataRuntime runtime, TextRun run) {
        this.replaceVariable(runtime, run);
        run.appendCondition();
        run.appendGroup();
        run.checkValid();
    }

    protected void fillExecuteContent(DataRuntime runtime, TableRun run) {
        super.fillExecuteContent(runtime, run);
    }

    public void fillExecuteContent(DataRuntime runtime, Run run) {
        super.fillExecuteContent(runtime, run);
    }

    public long execute(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        long result;
        block17: {
            result = -1L;
            if (null == random) {
                random = this.random(runtime);
            }
            String sql = run.getFinalExecute();
            List values = run.getValues();
            long fr = System.currentTimeMillis();
            int batch = run.getBatch();
            String action = "execute";
            if (batch > 1) {
                action = "batch execute";
            }
            if (log.isInfoEnabled() && this.IS_LOG_SQL(configs)) {
                if (batch > 1 && !this.IS_LOG_BATCH_SQL_PARAM(configs)) {
                    log.info("{}[action:{}][sql:\n{}\n]\n[param size:{}]", new Object[]{random, action, sql, values.size()});
                } else {
                    log.info("{}[action:{}][sql:\n{}\n]", new Object[]{random, action, run.log(ACTION.DML.EXECUTE, this.IS_SQL_LOG_PLACEHOLDER(configs))});
                }
            }
            if (null != configs) {
                configs.add(run);
            }
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return -1L;
            }
            long millis = -1L;
            try {
                JdbcTemplate jdbc = this.jdbc(runtime);
                if (null == jdbc) {
                    return -1L;
                }
                result = batch > 1 ? this.batch(jdbc, sql, batch, run.getVol(), values) : (null != values && values.size() > 0 ? (long)jdbc.update(sql, values.toArray()) : (long)jdbc.update(sql));
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = this.SLOW_SQL_MILLIS(configs);
                if (SLOW_SQL_MILLIS > 0L && this.IS_LOG_SLOW_SQL(configs) && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:{}][\u6267\u884c\u8017\u65f6:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, action, millis, sql, LogUtil.param((List)values)});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.EXECUTE, run, sql, values, null, true, (Object)result, millis);
                    }
                }
                if (!slow && log.isInfoEnabled() && this.IS_LOG_SQL_TIME(configs)) {
                    String qty = "" + result;
                    if (batch > 1) {
                        qty = "\u7ea6" + result;
                    }
                    log.info("{}[action:{}][\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, action, millis, LogUtil.format((String)qty, (int)34)});
                }
            }
            catch (Exception e) {
                if (this.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                    e.printStackTrace();
                }
                if (this.IS_LOG_SQL_WHEN_ERROR(configs)) {
                    log.error("{}[{}][action:{}]{}", new Object[]{random, LogUtil.format((String)"SQL\u6267\u884c\u5f02\u5e38:", (int)33) + e, action, run.log(ACTION.DML.EXECUTE, this.IS_SQL_LOG_PLACEHOLDER(configs))});
                }
                if (!this.IS_THROW_SQL_UPDATE_EXCEPTION(configs)) break block17;
                throw e;
            }
        }
        return result;
    }

    public <T> long deletes(DataRuntime runtime, String random, int batch, Table table, ConfigStore configs, String key, Collection<T> values) {
        return super.deletes(runtime, random, batch, table, configs, key, values);
    }

    public long delete(DataRuntime runtime, String random, Table dest, ConfigStore configs, Object obj, String ... columns) {
        return super.delete(runtime, random, dest, configs, obj, columns);
    }

    public long delete(DataRuntime runtime, String random, Table table, ConfigStore configs, String ... conditions) {
        return super.delete(runtime, random, table, configs, conditions);
    }

    public long truncate(DataRuntime runtime, String random, Table table) {
        return super.truncate(runtime, random, table);
    }

    public Run buildDeleteRun(DataRuntime runtime, Table dest, Object obj, String ... columns) {
        return super.buildDeleteRun(runtime, dest, obj, columns);
    }

    public Run buildDeleteRun(DataRuntime runtime, int batch, Table table, String key, Object values) {
        return super.buildDeleteRun(runtime, batch, table, key, values);
    }

    public List<Run> buildTruncateRun(DataRuntime runtime, Table table) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("TRUNCATE TABLE ");
        this.delimiter(builder, (BaseMetadata)table);
        return runs;
    }

    public Run buildDeleteRunFromTable(DataRuntime runtime, int batch, Table table, String key, Object values) {
        if (null == table || null == key || null == values) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        TableRun run = new TableRun(runtime, table);
        builder.append("DELETE FROM ");
        this.delimiter(builder, (BaseMetadata)table);
        builder.append(" WHERE ");
        if (values instanceof Collection) {
            Collection cons = (Collection)values;
            this.delimiter(builder, key);
            if (batch > 1) {
                builder.append(" = ?");
                ArrayList list = null;
                if (values instanceof List) {
                    list = (ArrayList)values;
                } else {
                    list = new ArrayList();
                    for (Object item : cons) {
                        list.add(item);
                    }
                }
                run.setValues(key, list);
                run.setVol(1);
                run.setBatch(batch);
            } else {
                if (cons.size() > 1) {
                    builder.append(" IN(");
                    int idx = 0;
                    for (Object obj : cons) {
                        if (idx > 0) {
                            builder.append(",");
                        }
                        builder.append("?");
                        ++idx;
                    }
                    builder.append(")");
                } else if (cons.size() == 1) {
                    for (Object obj : cons) {
                        builder.append("=?");
                    }
                } else {
                    throw new SQLUpdateException("\u5220\u9664\u5f02\u5e38:\u5220\u9664\u6761\u4ef6\u4e3a\u7a7a,delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u6574\u8868\u64cd\u4f5c.");
                }
                this.addRunValue(runtime, (Run)run, Compare.IN, new Column(key), values);
            }
        } else {
            this.delimiter(builder, key);
            builder.append("=?");
            this.addRunValue(runtime, (Run)run, Compare.EQUAL, new Column(key), values);
        }
        run.setBuilder(builder);
        return run;
    }

    public Run buildDeleteRunFromEntity(DataRuntime runtime, Table table, Object obj, String ... columns) {
        TableRun run = new TableRun(runtime, table);
        run.setFrom(2);
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM ");
        this.delimiter(builder, (BaseMetadata)table);
        builder.append(" WHERE ");
        List<String> keys = new ArrayList();
        if (null != columns && columns.length > 0) {
            for (String col : columns) {
                keys.add(col);
            }
        } else if (obj instanceof DataRow) {
            keys = ((DataRow)obj).getPrimaryKeys();
        } else {
            keys.addAll(EntityAdapterProxy.primaryKeys(obj.getClass()).keySet());
        }
        int size = keys.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    builder.append("\nAND ");
                }
                String key = (String)keys.get(i);
                this.delimiter(builder, key).append(" = ? ");
                Object value = null;
                value = obj instanceof DataRow ? ((DataRow)obj).get(key) : (EntityAdapterProxy.hasAdapter(obj.getClass()) ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key));
                this.addRunValue(runtime, (Run)run, Compare.EQUAL, new Column(key), value);
            }
        } else {
            throw new SQLUpdateException("\u5220\u9664\u5f02\u5e38:\u5220\u9664\u6761\u4ef6\u4e3a\u7a7a,delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u6574\u8868\u64cd\u4f5c.");
        }
        run.setBuilder(builder);
        return run;
    }

    public void fillDeleteRunContent(DataRuntime runtime, Run run) {
        if (null != run && run instanceof TableRun) {
            TableRun r = (TableRun)run;
            this.fillDeleteRunContent(runtime, r);
        }
    }

    protected void fillDeleteRunContent(DataRuntime runtime, TableRun run) {
        List joins;
        AutoPrepare prepare = (AutoPrepare)run.getPrepare();
        StringBuilder builder = run.getBuilder();
        builder.append("DELETE FROM ");
        this.name(runtime, builder, (BaseMetadata)run.getTable());
        builder.append("\n");
        if (BasicUtil.isNotEmpty((Object)prepare.getAlias())) {
            builder.append("  ").append(prepare.getAlias());
        }
        if (null != (joins = prepare.getJoins())) {
            for (Join join : joins) {
                builder.append("\n\t").append(join.getType().getCode()).append(" ");
                Table joinTable = join.getTable();
                String jionTableAlias = joinTable.getAlias();
                this.name(runtime, builder, (BaseMetadata)joinTable);
                if (BasicUtil.isNotEmpty((Object)jionTableAlias)) {
                    builder.append("  ").append(jionTableAlias);
                }
                builder.append(" ON ").append(join.getCondition());
            }
        }
        builder.append("\nWHERE 1=1\n\t");
        run.appendCondition();
        run.appendGroup();
        run.appendOrderStore();
        run.checkValid();
    }

    public long delete(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.delete(runtime, random, configs, run);
    }

    public LinkedHashMap<String, Column> metadata(DataRuntime runtime, RunPrepare prepare, boolean comment) {
        LinkedHashMap<Object, Object> columns = null;
        JdbcTemplate jdbc = this.jdbc(runtime);
        String random = this.random(runtime);
        Run run = this.buildQueryRun(runtime, prepare, null, null);
        String sql = run.getFinalQuery(false);
        long fr = System.currentTimeMillis();
        if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:metadata][sql:\n{}\n]", (Object)random, (Object)sql);
        }
        if (null == jdbc) {
            return new LinkedHashMap<String, Column>();
        }
        SqlRowSet rs = jdbc.queryForRowSet(sql);
        if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:metadata][\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)(System.currentTimeMillis() - fr));
        }
        fr = System.currentTimeMillis();
        try {
            columns = this.columns(runtime, true, null, null, rs);
            if (comment) {
                HashMap<String, Object> tables = new HashMap<String, Object>();
                for (Column column : columns.values()) {
                    Table table = column.getTable(false);
                    if (null == table || !BasicUtil.isNotEmpty((Object)table.getName()) || tables.containsKey(table.getIdentity())) continue;
                    tables.put(table.getIdentity(), table);
                }
                String col_sql = sql.toUpperCase().split("FROM")[0];
                List list = RegularUtil.fetch((String)col_sql, (String)"\\S+\\s+AS\\s+\\S+");
                for (Object col : list) {
                    String[] tmps = ((String)col).split("AS");
                    String original = tmps[0];
                    String label = tmps[1];
                    if (original.contains(".")) {
                        String[] names = original.split("\\.");
                        String table = names[1];
                        original = names[1];
                    }
                    original = original.trim();
                    Column column = (Column)columns.get(label = label.trim());
                    if (null == column) continue;
                    column.setOriginalName(original);
                }
                if (tables.isEmpty()) {
                    List tmps = RegularUtil.fetch((String)sql, (String)"(\\s+FROM\\s+\\S+)|(\\s+JOIN\\s+\\S+)");
                    for (String tmp : tmps) {
                        String name = tmp.trim().split("\\s+")[1].trim();
                        tables.put(name.toUpperCase(), new Table(name));
                    }
                }
                for (Table table : tables.values()) {
                    LinkedHashMap ccols = this.columns(runtime, random, false, table, false);
                    for (Column ccol : ccols.values()) {
                        String name = ccol.getName();
                        for (Column column : columns.values()) {
                            if (!column.getTableName(false).equals(ccol.getTableName(false))) continue;
                            String label = column.getName();
                            String original = column.getOriginalName();
                            if (!name.equalsIgnoreCase(label) && !name.equalsIgnoreCase(original)) continue;
                            column.setComment(ccol.getComment());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            columns = new LinkedHashMap();
            e.printStackTrace();
        }
        log.info("{}[action:metadata][\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, System.currentTimeMillis() - fr, LogUtil.format((int)columns.size(), (int)34)});
        return columns;
    }

    public Database database(DataRuntime runtime, String random) {
        Catalog catalog = this.catalog(runtime, random);
        if (null != catalog) {
            return new Database(catalog.getName());
        }
        return super.database(runtime, random);
    }

    public String product(DataRuntime runtime, String random) {
        return super.product(runtime, random);
    }

    public String version(DataRuntime runtime, String random) {
        return super.version(runtime, random);
    }

    public List<Database> databases(DataRuntime runtime, String random, boolean greedy, String name) {
        return super.databases(runtime, random, greedy, name);
    }

    public LinkedHashMap<String, Database> databases(DataRuntime runtime, String random, String name) {
        return super.databases(runtime, random, name);
    }

    public List<Run> buildQueryProductRun(DataRuntime runtime) throws Exception {
        return super.buildQueryProductRun(runtime);
    }

    public List<Run> buildQueryVersionRun(DataRuntime runtime) throws Exception {
        return super.buildQueryVersionRun(runtime);
    }

    public List<Run> buildQueryDatabasesRun(DataRuntime runtime, boolean greedy, String name) throws Exception {
        return super.buildQueryDatabasesRun(runtime, greedy, name);
    }

    public LinkedHashMap<String, Database> databases(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Database> databases, DataSet set) throws Exception {
        return super.databases(runtime, index, create, databases, set);
    }

    public List<Database> databases(DataRuntime runtime, int index, boolean create, List<Database> databases, DataSet set) throws Exception {
        return super.databases(runtime, index, create, databases, set);
    }

    public Database database(DataRuntime runtime, int index, boolean create, Database database, DataSet set) throws Exception {
        return super.database(runtime, index, create, database, set);
    }

    public Database database(DataRuntime runtime, boolean create, Database database) throws Exception {
        return super.database(runtime, create, database);
    }

    public String product(DataRuntime runtime, int index, boolean create, String product, DataSet set) {
        return super.product(runtime, index, create, product, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String product(DataRuntime runtime, boolean create, String product) {
        JdbcTemplate jdbc;
        DataSource ds;
        Connection con;
        block5: {
            con = null;
            ds = null;
            jdbc = this.jdbc(runtime);
            if (null != jdbc) break block5;
            String string = null;
            if (null == con || DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) return string;
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            return string;
        }
        try {
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            product = con.getMetaData().getDatabaseProductName();
        }
        catch (Exception e) {
            try {
                log.warn("[check product][fail:{}]", (Object)e.toString());
            }
            catch (Throwable throwable) {
                if (null == con || DataSourceUtils.isConnectionTransactional(con, ds)) throw throwable;
                DataSourceUtils.releaseConnection(con, (DataSource)ds);
                throw throwable;
            }
            if (null == con || DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) return product;
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            return product;
        }
        if (null == con || DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) return product;
        DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
        return product;
    }

    public String version(DataRuntime runtime, int index, boolean create, String version, DataSet set) {
        return super.version(runtime, index, create, version, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String version(DataRuntime runtime, boolean create, String version) {
        JdbcTemplate jdbc;
        DataSource ds;
        Connection con;
        block5: {
            con = null;
            ds = null;
            jdbc = this.jdbc(runtime);
            if (null != jdbc) break block5;
            String string = null;
            if (null == con || DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) return string;
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            return string;
        }
        try {
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            version = con.getMetaData().getDatabaseProductVersion();
        }
        catch (Exception e) {
            try {
                log.warn("[check version][fail:{}]", (Object)e.toString());
            }
            catch (Throwable throwable) {
                if (null == con || DataSourceUtils.isConnectionTransactional(con, ds)) throw throwable;
                DataSourceUtils.releaseConnection(con, (DataSource)ds);
                throw throwable;
            }
            if (null == con || DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) return version;
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            return version;
        }
        if (null == con || DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) return version;
        DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
        return version;
    }

    public LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, String random, String name) {
        return super.catalogs(runtime, random, name);
    }

    public List<Catalog> catalogs(DataRuntime runtime, String random, boolean greedy, String name) {
        return super.catalogs(runtime, random, greedy, name);
    }

    public List<Run> buildQueryCatalogsRun(DataRuntime runtime, boolean greedy, String name) throws Exception {
        return super.buildQueryCatalogsRun(runtime, greedy, name);
    }

    public LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Catalog> catalogs, DataSet set) throws Exception {
        return super.catalogs(runtime, index, create, catalogs, set);
    }

    public List<Catalog> catalogs(DataRuntime runtime, int index, boolean create, List<Catalog> catalogs, DataSet set) throws Exception {
        return super.catalogs(runtime, index, create, catalogs, set);
    }

    public LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, boolean create, LinkedHashMap<String, Catalog> catalogs) throws Exception {
        return super.catalogs(runtime, create, catalogs);
    }

    public List<Catalog> catalogs(DataRuntime runtime, boolean create, List<Catalog> catalogs) throws Exception {
        return super.catalogs(runtime, create, catalogs);
    }

    public Catalog catalog(DataRuntime runtime, int index, boolean create, Catalog catalog, DataSet set) throws Exception {
        return super.catalog(runtime, index, create, catalog, set);
    }

    public Catalog catalog(DataRuntime runtime, boolean create, Catalog catalog) throws Exception {
        if (null == catalog) {
            Table table = new Table();
            this.checkSchema(runtime, table);
            catalog = table.getCatalog();
        }
        return catalog;
    }

    public LinkedHashMap<String, Schema> schemas(DataRuntime runtime, String random, Catalog catalog, String name) {
        return super.schemas(runtime, random, catalog, name);
    }

    public List<Schema> schemas(DataRuntime runtime, String random, boolean greedy, Catalog catalog, String name) {
        return super.schemas(runtime, random, greedy, catalog, name);
    }

    public List<Run> buildQuerySchemasRun(DataRuntime runtime, boolean greedy, Catalog catalog, String name) throws Exception {
        return super.buildQuerySchemasRun(runtime, greedy, catalog, name);
    }

    public LinkedHashMap<String, Schema> schemas(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Schema> schemas, DataSet set) throws Exception {
        return super.schemas(runtime, index, create, schemas, set);
    }

    public List<Schema> schemas(DataRuntime runtime, int index, boolean create, List<Schema> schemas, DataSet set) throws Exception {
        return super.schemas(runtime, index, create, schemas, set);
    }

    public Schema schema(DataRuntime runtime, int index, boolean create, Schema schema, DataSet set) throws Exception {
        return super.schema(runtime, index, create, schema, set);
    }

    public Schema schema(DataRuntime runtime, boolean create, Schema schema) throws Exception {
        if (null == schema) {
            Table table = new Table();
            this.checkSchema(runtime, table);
            schema = table.getSchema();
        }
        return schema;
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, String types, boolean strut) {
        return super.tables(runtime, random, greedy, catalog, schema, pattern, types, strut);
    }

    protected void tableMap(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema) {
        super.tableMap(runtime, random, greedy, catalog, schema);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, String types, boolean strut) {
        return super.tables(runtime, random, catalog, schema, pattern, types, strut);
    }

    public List<Run> buildQueryTablesRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        return super.buildQueryTablesRun(runtime, greedy, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryTablesCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        return super.buildQueryTablesCommentRun(runtime, catalog, schema, pattern, types);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name;
            String _catalog = row.getString("TABLE_CATALOG");
            String _schema = row.getString(new String[]{"TABLE_SCHEMA", "TABSCHEMA", "SCHEMA_NAME"});
            if (null == _catalog && null != catalog) {
                _catalog = catalog.getName();
            }
            if (null == _schema && null != schema) {
                _schema = schema.getName();
            }
            if (null == (name = row.getString(new String[]{"TABLE_NAME", "NAME", "TABNAME"}))) continue;
            Object table = (Table)tables.get(name.toUpperCase());
            if (null == table) {
                table = "VIEW".equals(row.getString("TABLE_TYPE")) ? new View() : new Table();
            }
            if (null != _catalog) {
                _catalog = _catalog.trim();
            }
            if (null != _schema) {
                _schema = _schema.trim();
            }
            table.setCatalog(_catalog);
            table.setSchema(_schema);
            table.setName(name);
            this.init((Table)table, row);
            tables.put(name.toUpperCase(), table);
        }
        return tables;
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, List<T> tables, DataSet set) throws Exception {
        if (null == tables) {
            tables = new ArrayList<T>();
        }
        for (DataRow row : set) {
            String _catalog = row.getString("TABLE_CATALOG");
            String _schema = row.getString(new String[]{"TABLE_SCHEMA", "TABSCHEMA", "SCHEMA_NAME"});
            if (null == _catalog && null != catalog) {
                _catalog = catalog.getName();
            }
            if (null == _schema && null != schema) {
                _schema = schema.getName();
            }
            String name = row.getString(new String[]{"TABLE_NAME", "NAME", "TABNAME"});
            Object table = this.table(tables, new Catalog(_catalog), new Schema(_schema), name);
            boolean conains = true;
            if (null == table) {
                conains = false;
                table = "VIEW".equals(row.getString("TABLE_TYPE")) ? new View() : new Table();
            }
            if (null != _catalog) {
                _catalog = _catalog.trim();
            }
            if (null != _schema) {
                _schema = _schema.trim();
            }
            table.setCatalog(_catalog);
            table.setSchema(_schema);
            table.setName(name);
            this.init((Table)table, row);
            if (conains) continue;
            tables.add(table);
        }
        return tables;
    }

    private void init(Table table, DataRow row) {
        table.setObjectId(row.getLong("OBJECT_ID", (Long)null));
        table.setEngine(row.getString("ENGINE"));
        table.setComment(row.getString(new String[]{"TABLE_COMMENT", "COMMENTS", "COMMENT"}));
        table.setDataRows(row.getLong("TABLE_ROWS", (Long)null));
        table.setCollate(row.getString("TABLE_COLLATION"));
        table.setDataLength(row.getLong("DATA_LENGTH", (Long)null));
        table.setDataFree(row.getLong("DATA_FREE", (Long)null));
        table.setIncrement(row.getLong("AUTO_INCREMENT", (Long)null));
        table.setIndexLength(row.getLong("INDEX_LENGTH", (Long)null));
        table.setCreateTime(row.getDate("CREATE_TIME", (Date)null));
        table.setUpdateTime(row.getDate("UPDATE_TIME", (Date)null));
        table.setType(row.getString("TABLE_TYPE"));
        table.setEngine(row.getString("ENGINE"));
    }

    protected void init(Table table, ResultSet set, Map<String, Integer> keys) {
        try {
            table.setType((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_TYPE", set), table.getType()}));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            table.setComment((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REMARKS", set), table.getComment()}));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            table.setTypeCat((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_CAT", set), table.getTypeCat()}));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            table.setTypeName((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_NAME", set), table.getTypeName()}));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            table.setSelfReferencingColumn((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "SELF_REFERENCING_COL_NAME", set), table.getSelfReferencingColumn()}));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            table.setRefGeneration((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REF_GENERATION", set), table.getRefGeneration()}));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, String pattern, String ... types) throws Exception {
        JdbcTemplate jdbc;
        Connection con;
        DataSource ds;
        block12: {
            ds = null;
            con = null;
            jdbc = this.jdbc(runtime);
            if (null != jdbc) break block12;
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
            return linkedHashMap;
        }
        try {
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            DatabaseMetaData dbmd = con.getMetaData();
            String catalogName = null;
            String schemaName = null;
            if (null != catalog) {
                catalogName = catalog.getName();
            }
            if (null != schema) {
                schemaName = schema.getName();
            }
            String[] tmp = this.correctSchemaFromJDBC(catalogName, schemaName);
            ResultSet set = dbmd.getTables(tmp[0], tmp[1], pattern, types);
            if (null == tables) {
                tables = new LinkedHashMap();
            }
            Map<String, Integer> keys = this.keys(set);
            while (set.next()) {
                String tableName = this.string(keys, "TABLE_NAME", set);
                if (BasicUtil.isEmpty((Object)tableName)) {
                    tableName = this.string(keys, "NAME", set);
                }
                if (BasicUtil.isEmpty((Object)tableName)) continue;
                Table table = (Table)tables.get(tableName.toUpperCase());
                if (null == table) {
                    if (!create) continue;
                    table = new Table();
                    tables.put(tableName.toUpperCase(), table);
                }
                catalogName = this.string(keys, "TABLE_CAT", set);
                schemaName = this.string(keys, "TABLE_SCHEM", set);
                this.correctSchemaFromJDBC((BaseMetadata)table, catalogName, schemaName);
                table.setName(tableName);
                this.init(table, set, keys);
                tables.put(tableName.toUpperCase(), table);
            }
        }
        catch (Throwable throwable) {
            if (null != con && !DataSourceUtils.isConnectionTransactional(con, ds)) {
                DataSourceUtils.releaseConnection(con, (DataSource)ds);
            }
            throw throwable;
        }
        if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> tables, Catalog catalog, Schema schema, String pattern, String ... types) throws Exception {
        JdbcTemplate jdbc;
        Connection con;
        DataSource ds;
        block12: {
            ds = null;
            con = null;
            jdbc = this.jdbc(runtime);
            if (null != jdbc) break block12;
            ArrayList arrayList = new ArrayList();
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
            return arrayList;
        }
        try {
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            DatabaseMetaData dbmd = con.getMetaData();
            String catalogName = null;
            String schemaName = null;
            if (null != catalog) {
                catalogName = catalog.getName();
            }
            if (null != schema) {
                schemaName = schema.getName();
            }
            String[] tmp = this.correctSchemaFromJDBC(catalogName, schemaName);
            ResultSet set = dbmd.getTables(tmp[0], tmp[1], pattern, types);
            if (null == tables) {
                tables = new ArrayList<T>();
            }
            Map<String, Integer> keys = this.keys(set);
            while (set.next()) {
                String tableName = this.string(keys, "TABLE_NAME", set);
                if (BasicUtil.isEmpty((Object)tableName)) {
                    tableName = this.string(keys, "NAME", set);
                }
                if (BasicUtil.isEmpty((Object)tableName)) continue;
                catalogName = (String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CATALOG", set), this.string(keys, "TABLE_CAT", set)});
                schemaName = (String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_SCHEMA", set), this.string(keys, "TABLE_SCHEM", set)});
                Table chk = new Table();
                this.correctSchemaFromJDBC((BaseMetadata)chk, catalogName, schemaName);
                Object table = this.table(tables, chk.getCatalog(), chk.getSchema(), tableName);
                boolean contains = true;
                if (null == table) {
                    if (!create) continue;
                    table = new Table();
                    contains = false;
                }
                this.correctSchemaFromJDBC((BaseMetadata)table, catalogName, schemaName);
                table.setSchema(schema);
                table.setName(tableName);
                this.init((Table)table, set, keys);
                if (contains) continue;
                tables.add(table);
            }
        }
        catch (Throwable throwable) {
            if (null != con && !DataSourceUtils.isConnectionTransactional(con, ds)) {
                DataSourceUtils.releaseConnection(con, (DataSource)ds);
            }
            throw throwable;
        }
        if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
        }
        return tables;
    }

    public <T extends Table> LinkedHashMap<String, T> comments(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Table table;
            String name = row.getString("TABLE_NAME");
            String comment = row.getString("TABLE_COMMENT");
            if (null == name || null == comment || null == (table = (Table)tables.get(name.toUpperCase()))) continue;
            table.setComment(comment);
        }
        return tables;
    }

    public <T extends Table> List<T> comments(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, List<T> tables, DataSet set) throws Exception {
        if (null == tables) {
            tables = new ArrayList<T>();
        }
        for (DataRow row : set) {
            String name = row.getString("TABLE_NAME");
            String comment = row.getString("TABLE_COMMENT");
            if (null == catalog) {
                catalog = new Catalog(row.getString("TABLE_CATALOG"));
            }
            if (null == schema) {
                schema = new Schema(row.getString("TABLE_SCHEMA"));
            }
            boolean contains = true;
            Object table = this.table(tables, catalog, schema, name);
            if (null == table) {
                if (!create) continue;
                table = new Table(catalog, schema, name);
                contains = false;
            }
            table.setComment(comment);
            if (contains) continue;
            tables.add(table);
        }
        return tables;
    }

    public List<String> ddl(DataRuntime runtime, String random, Table table, boolean init) {
        return super.ddl(runtime, random, table, init);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryDdlsRun(runtime, table);
    }

    public List<String> ddl(DataRuntime runtime, int index, Table table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, String types) {
        return super.views(runtime, random, greedy, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryViewsRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        return super.buildQueryViewsRun(runtime, greedy, catalog, schema, pattern, types);
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> views, DataSet set) throws Exception {
        return super.views(runtime, index, create, catalog, schema, views, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> views, Catalog catalog, Schema schema, String pattern, String ... types) throws Exception {
        JdbcTemplate jdbc;
        Connection con;
        DataSource ds;
        block13: {
            ds = null;
            con = null;
            jdbc = this.jdbc(runtime);
            if (null != jdbc) break block13;
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
            return linkedHashMap;
        }
        try {
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            DatabaseMetaData dbmd = con.getMetaData();
            String catalogName = null;
            String schemaName = null;
            if (null != catalog) {
                catalogName = catalog.getName();
            }
            if (null != schema) {
                schemaName = schema.getName();
            }
            String[] tmp = this.correctSchemaFromJDBC(catalogName, schemaName);
            ResultSet set = dbmd.getTables(tmp[0], tmp[1], pattern, new String[]{"VIEW"});
            if (null == views) {
                views = new LinkedHashMap();
            }
            Map<String, Integer> keys = this.keys(set);
            while (set.next()) {
                String viewName = this.string(keys, "VIEW_NAME", set);
                if (BasicUtil.isEmpty((Object)viewName)) {
                    viewName = this.string(keys, "NAME", set);
                }
                if (BasicUtil.isEmpty((Object)viewName)) {
                    viewName = this.string(keys, "TABLE_NAME", set);
                }
                if (BasicUtil.isEmpty((Object)viewName)) continue;
                View view = (View)views.get(viewName.toUpperCase());
                if (null == view) {
                    if (!create) continue;
                    view = new View();
                    views.put(viewName.toUpperCase(), view);
                }
                catalogName = (String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CATALOG", set), this.string(keys, "TABLE_CAT", set)});
                schemaName = (String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_SCHEMA", set), this.string(keys, "TABLE_SCHEM", set)});
                this.correctSchemaFromJDBC((BaseMetadata)view, catalogName, schemaName);
                view.setName(viewName);
                this.init(view, set, keys);
                views.put(viewName.toUpperCase(), view);
            }
        }
        catch (Throwable throwable) {
            if (null != con && !DataSourceUtils.isConnectionTransactional(con, ds)) {
                DataSourceUtils.releaseConnection(con, (DataSource)ds);
            }
            throw throwable;
        }
        if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
        }
        return views;
    }

    protected void init(View view, ResultSet set, Map<String, Integer> keys) {
        try {
            view.setType((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_TYPE", set), view.getType()}));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            view.setComment((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REMARKS", set), view.getComment()}));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            view.setTypeCat((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_CAT", set), view.getTypeCat()}));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            view.setTypeName((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_NAME", set), view.getTypeName()}));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            view.setSelfReferencingColumn((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "SELF_REFERENCING_COL_NAME", set), view.getSelfReferencingColumn()}));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            view.setRefGeneration((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REF_GENERATION", set), view.getRefGeneration()}));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public List<String> ddl(DataRuntime runtime, String random, View view) {
        return super.ddl(runtime, random, view);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, View view) throws Exception {
        return super.buildQueryDdlsRun(runtime, view);
    }

    public List<String> ddl(DataRuntime runtime, int index, View view, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, view, ddls, set);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, String types) {
        return super.mtables(runtime, random, greedy, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryMasterTablesRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        return super.buildQueryMasterTablesRun(runtime, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.mtables(runtime, index, create, catalog, schema, tables, set);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, String pattern, String ... types) throws Exception {
        return super.mtables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public List<String> ddl(DataRuntime runtime, String random, MasterTable table) {
        return super.ddl(runtime, random, table);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildQueryDdlsRun(runtime, table);
    }

    public List<String> ddl(DataRuntime runtime, int index, MasterTable table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, String random, boolean greedy, MasterTable master, Map<String, Object> tags, String pattern) {
        return super.ptables(runtime, random, greedy, master, tags, pattern);
    }

    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTablesRun(runtime, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags, String name) throws Exception {
        return super.buildQueryPartitionTablesRun(runtime, master, tags, name);
    }

    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTablesRun(runtime, master, tags);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, int total, int index, boolean create, MasterTable master, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.ptables(runtime, total, index, create, master, catalog, schema, tables, set);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, MasterTable master) throws Exception {
        return super.ptables(runtime, create, tables, catalog, schema, master);
    }

    public List<String> ddl(DataRuntime runtime, String random, PartitionTable table) {
        return super.ddl(runtime, random, table);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildQueryDdlsRun(runtime, table);
    }

    public List<String> ddl(DataRuntime runtime, int index, PartitionTable table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean greedy, Table table, boolean primary) {
        if (!greedy) {
            this.checkSchema(runtime, table);
        }
        Catalog catalog = table.getCatalog();
        Schema schema = table.getSchema();
        LinkedHashMap columns = CacheProxy.columns((String)runtime.getKey(), (Table)table);
        if (null != columns && !columns.isEmpty()) {
            return columns;
        }
        long fr = System.currentTimeMillis();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            DataSet set;
            List<Run> runs;
            int qty_jdbc;
            int qty_metadata;
            int qty_dialect;
            int qty_total;
            block38: {
                qty_total = 0;
                qty_dialect = 0;
                qty_metadata = 0;
                qty_jdbc = 0;
                try {
                    runs = this.buildQueryColumnsRun(runtime, table, false);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run);
                            columns = this.columns(runtime, idx, true, table, columns, set);
                            ++idx;
                        }
                    }
                    if (null != columns) {
                        qty_dialect = columns.size();
                        qty_total = columns.size();
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (primary) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block38;
                    log.warn("{}[columns][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                }
            }
            if (null == columns || columns.size() == 0) {
                block39: {
                    try {
                        runs = this.buildQueryColumnsRun(runtime, table, true);
                        if (null != runs) {
                            for (Run run : runs) {
                                String sql = run.getFinalQuery();
                                if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                                set = ((JDBCRuntime)runtime).jdbc().queryForRowSet(sql);
                                columns = this.columns(runtime, true, columns, table, (SqlRowSet)set);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block39;
                        log.warn("{}[columns][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636emetadata\u89e3\u6790\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                    }
                }
                if (null != columns) {
                    qty_metadata = columns.size() - qty_dialect;
                    qty_total = columns.size();
                }
            }
            if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[columns][catalog:{}][schema:{}][table:{}][total:{}][\u6839\u636emetadata\u89e3\u6790:{}][\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2:{}][\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, table, qty_total, qty_metadata, qty_dialect, qty_jdbc, System.currentTimeMillis() - fr});
            }
            if (null == columns || columns.size() == 0) {
                DataSource ds = null;
                Connection con = null;
                DatabaseMetaData metadata = null;
                try {
                    ds = ((JDBCRuntime)runtime).jdbc().getDataSource();
                    con = DataSourceUtils.getConnection((DataSource)ds);
                    metadata = con.getMetaData();
                    columns = this.columns(runtime, true, columns, metadata, table, null);
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                }
                finally {
                    if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                        DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
                    }
                }
                if (null != columns) {
                    qty_total = columns.size();
                    qty_jdbc = columns.size() - qty_metadata - qty_dialect;
                }
            }
            if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[columns][catalog:{}][schema:{}][table:{}][total:{}][\u6839\u636emetadata\u89e3\u6790:{}][\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2:{}][\u6839\u636e\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, table, qty_total, qty_metadata, qty_dialect, qty_jdbc, System.currentTimeMillis() - fr});
            }
            if (ConfigTable.IS_METADATA_AUTO_CHECK_COLUMN_PRIMARY && (null != columns || columns.size() > 0)) {
                LinkedHashMap pks;
                PrimaryKey pk;
                boolean exists = false;
                for (Column column : columns.values()) {
                    if (column.isPrimaryKey() == -1) continue;
                    exists = true;
                    break;
                }
                if (!exists && null != (pk = this.primary(runtime, random, false, table)) && null != (pks = pk.getColumns())) {
                    for (String k : pks.keySet()) {
                        Column column = (Column)columns.get(k);
                        if (null == column) continue;
                        column.primary(Boolean.valueOf(true));
                    }
                }
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[columns][result:fail][table:{}][msg:{}]", new Object[]{random, table, e.toString()});
        }
        if (null != columns) {
            CacheProxy.columns((String)runtime.getKey(), (Table)table, columns);
        } else {
            columns = new LinkedHashMap();
        }
        int index = 0;
        for (Column column : columns.values()) {
            if (null != column.getPrecision()) continue;
            column.setPosition(Integer.valueOf(index++));
        }
        return columns;
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, Table table) {
        return super.columns(runtime, random, greedy, catalog, schema, table);
    }

    public List<Run> buildQueryColumnsRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        Catalog catalog = null;
        Schema schema = null;
        String name = null;
        if (null != table) {
            name = table.getName();
            catalog = table.getCatalog();
            schema = table.getSchema();
        }
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(runtime, builder, (BaseMetadata)table);
            builder.append(" WHERE 1=0");
        }
        return runs;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString(new String[]{"COLUMN_NAME", "COLNAME"});
            Column column = (Column)columns.get(name.toUpperCase());
            if (null == column) {
                column = new Column();
            }
            column.setName(name);
            this.init(column, table, row);
            columns.put(name.toUpperCase(), column);
        }
        return columns;
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, Table table, List<T> columns, DataSet set) throws Exception {
        if (null == columns) {
            columns = new ArrayList<T>();
        }
        for (DataRow row : set) {
            String name = row.getString(new String[]{"COLUMN_NAME", "COLNAME"});
            Column tmp = new Column();
            tmp.setName(name);
            this.init(tmp, table, row);
            Column column = this.column(tmp, columns);
            if (null != column) continue;
            column = new Column();
            column.setName(name);
            this.init(column, table, row);
            columns.add(column);
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String pattern) throws Exception {
        block18: {
            JdbcTemplate jdbc;
            Connection con;
            DataSource ds;
            block17: {
                if (null == columns) {
                    columns = new LinkedHashMap();
                }
                ds = null;
                con = null;
                jdbc = this.jdbc(runtime);
                if (null != jdbc) break block17;
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                    DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
                }
                return linkedHashMap;
            }
            try {
                ds = jdbc.getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                String catalog = table.getCatalogName();
                String schema = table.getSchemaName();
                DatabaseMetaData dbmd = con.getMetaData();
                ResultSet set = dbmd.getColumns(catalog, schema, table.getName(), pattern);
                Map<String, Integer> keys = this.keys(set);
                while (set.next()) {
                    String remark;
                    String columnSchema;
                    String name = set.getString("COLUMN_NAME");
                    if (null == name) continue;
                    String columnCatalog = this.string(keys, "TABLE_CAT", set, null);
                    if (null != columnCatalog) {
                        columnCatalog = columnCatalog.trim();
                    }
                    if (null != (columnSchema = this.string(keys, "TABLE_SCHEM", set, null))) {
                        columnSchema = columnSchema.trim();
                    }
                    String[] tmp_column = this.correctSchemaFromJDBC(columnCatalog, columnSchema);
                    columnCatalog = tmp_column[0];
                    columnSchema = tmp_column[1];
                    if (!BasicUtil.equalsIgnoreCase((Object)catalog, (Object)columnCatalog) || !BasicUtil.equalsIgnoreCase((Object)schema, (Object)columnSchema)) continue;
                    Column column = (Column)columns.get(name.toUpperCase());
                    if (null == column) {
                        if (!create) continue;
                        column = new Column(name);
                        columns.put(name.toUpperCase(), column);
                    }
                    if ("TAG".equals(remark = this.string(keys, "REMARKS", set, column.getComment()))) {
                        column = new Tag();
                    }
                    column.setCatalog(catalog);
                    column.setSchema(schema);
                    column.setComment(remark);
                    column.setTable((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_NAME", set, table.getName()), column.getTableName(true)}));
                    column.setType(this.integer(keys, "DATA_TYPE", set, column.getType()));
                    column.setType(this.integer(keys, "SQL_DATA_TYPE", set, column.getType()));
                    String jdbcType = this.string(keys, "TYPE_NAME", set, column.getTypeName());
                    if (BasicUtil.isEmpty((Object)column.getTypeName())) {
                        column.setTypeName(jdbcType);
                    }
                    column.setJdbcType(jdbcType);
                    column.setPrecision(this.integer(keys, "COLUMN_SIZE", set, column.getPrecision()));
                    column.setScale(this.integer(keys, "DECIMAL_DIGITS", set, column.getScale()));
                    column.nullable(this.bool(keys, "NULLABLE", set, column.isNullable()));
                    column.setDefaultValue(this.value(keys, "COLUMN_DEF", set, column.getDefaultValue()));
                    column.setPosition(this.integer(keys, "ORDINAL_POSITION", set, column.getPosition()));
                    column.autoIncrement(this.bool(keys, "IS_AUTOINCREMENT", set, column.isAutoIncrement()));
                    ColumnType columnType = this.type(column.getTypeName());
                    column.setColumnType(columnType);
                    this.column(runtime, column, set);
                    column.setName(name);
                }
                ResultSet rs = dbmd.getPrimaryKeys(catalog, schema, table.getName());
                while (rs.next()) {
                    String name = rs.getString(4);
                    Column column = (Column)columns.get(name.toUpperCase());
                    if (null == column) continue;
                    column.primary(Boolean.valueOf(true));
                }
            }
            catch (Exception e) {
                if (null != con && !DataSourceUtils.isConnectionTransactional(con, ds)) {
                    DataSourceUtils.releaseConnection(con, (DataSource)ds);
                }
                break block18;
                catch (Throwable throwable) {
                    if (null != con && !DataSourceUtils.isConnectionTransactional(con, ds)) {
                        DataSourceUtils.releaseConnection(con, (DataSource)ds);
                    }
                    throw throwable;
                }
            }
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return columns;
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, String random, boolean greedy, Table table) {
        LinkedHashMap<String, T> tags;
        block17: {
            if (null == table || BasicUtil.isEmpty((Object)table.getName())) {
                return new LinkedHashMap();
            }
            tags = CacheProxy.tags((String)runtime.getKey(), (Table)table);
            if (null != tags && !tags.isEmpty()) {
                return tags;
            }
            long fr = System.currentTimeMillis();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                Schema schema;
                Catalog catalog;
                block16: {
                    block15: {
                        if (!greedy) {
                            this.checkSchema(runtime, table);
                        }
                        catalog = table.getCatalog();
                        schema = table.getSchema();
                        try {
                            List<Run> runs = this.buildQueryTagsRun(runtime, table, false);
                            if (null != runs) {
                                int idx = 0;
                                for (Run run : runs) {
                                    DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                                    tags = this.tags(runtime, idx, true, table, tags, set);
                                    ++idx;
                                }
                            }
                        }
                        catch (Exception e) {
                            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                e.printStackTrace();
                            }
                            if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block15;
                            log.warn("{}[tags][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                        }
                    }
                    if (null == tags || tags.size() == 0) {
                        try {
                            tags = this.tags(runtime, false, tags, table, null);
                        }
                        catch (Exception e) {
                            if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block16;
                            e.printStackTrace();
                        }
                    }
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[tags][catalog:{}][schema:{}][table:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, table, System.currentTimeMillis() - fr});
                }
            }
            catch (Exception e) {
                if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block17;
                e.printStackTrace();
            }
        }
        CacheProxy.tags((String)runtime.getKey(), (Table)table, (LinkedHashMap)tags);
        return tags;
    }

    public List<Run> buildQueryTagsRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        return super.buildQueryTagsRun(runtime, table, metadata);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        return super.tags(runtime, index, create, table, tags, set);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Table table, String pattern) throws Exception {
        return super.tags(runtime, create, tags, table, pattern);
    }

    public PrimaryKey primary(DataRuntime runtime, String random, boolean greedy, Table table) {
        return super.primary(runtime, random, greedy, table);
    }

    public List<Run> buildQueryPrimaryRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryPrimaryRun(runtime, table);
    }

    public PrimaryKey primary(DataRuntime runtime, int index, Table table, DataSet set) throws Exception {
        return super.primary(runtime, index, table, set);
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, String random, boolean greedy, Table table) {
        return super.foreigns(runtime, random, greedy, table);
    }

    public List<Run> buildQueryForeignsRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryForeignsRun(runtime, table);
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set) throws Exception {
        return super.foreigns(runtime, index, table, foreigns, set);
    }

    public <T extends Index> List<T> indexs(DataRuntime runtime, String random, boolean greedy, Table table, String pattern) {
        return super.indexs(runtime, random, greedy, table, pattern);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, String random, Table table, String pattern) {
        return super.indexs(runtime, random, table, pattern);
    }

    public List<Run> buildQueryIndexsRun(DataRuntime runtime, Table table, String name) {
        return super.buildQueryIndexsRun(runtime, table, name);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        return super.indexs(runtime, index, create, table, indexs, set);
    }

    public <T extends Index> List<T> indexs(DataRuntime runtime, int index, boolean create, Table table, List<T> indexs, DataSet set) throws Exception {
        return super.indexs(runtime, index, create, table, indexs, set);
    }

    public <T extends Index> List<T> indexs(DataRuntime runtime, boolean create, List<T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(runtime, create, indexs, table, unique, approximate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        JdbcTemplate jdbc;
        DataSource ds = null;
        Connection con = null;
        if (null == indexs) {
            indexs = new LinkedHashMap();
        }
        if (null == (jdbc = this.jdbc(runtime))) {
            return new LinkedHashMap();
        }
        try {
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            DatabaseMetaData dbmd = con.getMetaData();
            String[] tmp = this.correctSchemaFromJDBC(table.getCatalogName(), table.getSchemaName());
            ResultSet set = dbmd.getIndexInfo(tmp[0], tmp[1], table.getName(), unique, approximate);
            Map<String, Integer> keys = this.keys(set);
            LinkedHashMap<String, Column> columns = null;
            while (set.next()) {
                String name = this.string(keys, "INDEX_NAME", set);
                if (null == name) continue;
                Index index = (Index)indexs.get(name.toUpperCase());
                if (null == index) {
                    if (!create) continue;
                    index = new Index();
                    indexs.put(name.toUpperCase(), index);
                    index.setName(this.string(keys, "INDEX_NAME", set));
                    index.setUnique(this.bool(keys, "NON_UNIQUE", set, false) == false);
                    String catalog = (String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CATALOG", set), this.string(keys, "TABLE_CAT", set)});
                    String schema = (String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_SCHEMA", set), this.string(keys, "TABLE_SCHEM", set)});
                    this.correctSchemaFromJDBC((BaseMetadata)index, catalog, schema);
                    if (!BasicUtil.equals((Object)table.getCatalogName(), (Object)index.getCatalogName()) || !BasicUtil.equals((Object)table.getSchemaName(), (Object)index.getSchemaName())) continue;
                    index.setTable(this.string(keys, "TABLE_NAME", set));
                    indexs.put(name.toUpperCase(), index);
                    columns = new LinkedHashMap<String, Column>();
                    index.setColumns(columns);
                    if (name.equalsIgnoreCase("PRIMARY")) {
                        index.setCluster(true);
                        index.setPrimary(true);
                    } else if (name.equalsIgnoreCase("PK_" + table.getName())) {
                        index.setCluster(true);
                        index.setPrimary(true);
                    }
                } else {
                    columns = index.getColumns();
                }
                String columnName = this.string(keys, "COLUMN_NAME", set);
                Column col = table.getColumn(columnName.toUpperCase());
                Column column = null;
                if (null != col) {
                    column = (Column)col.clone();
                } else {
                    column = new Column();
                    column.setName(columnName);
                }
                String order = this.string(keys, "ASC_OR_DESC", set);
                order = null != order && order.startsWith("D") ? "DESC" : "ASC";
                column.setOrder(order);
                column.setPosition(this.integer(keys, "ORDINAL_POSITION", set, null));
                columns.put(column.getName().toUpperCase(), column);
            }
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return indexs;
    }

    public <T extends Constraint> List<T> constraints(DataRuntime runtime, String random, boolean greedy, Table table, String pattern) {
        List<Run> runs;
        List<T> constraints = null;
        if (null == table) {
            table = new Table();
        }
        if (null == random) {
            random = this.random(runtime);
        }
        if (!greedy) {
            this.checkSchema(runtime, table);
        }
        if (null != (runs = this.buildQueryConstraintsRun(runtime, table, null, pattern))) {
            int idx = 0;
            for (Run run : runs) {
                block7: {
                    DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                    try {
                        constraints = this.constraints(runtime, idx, true, table, constraints, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block7;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return constraints;
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, String random, Table table, Column column, String pattern) {
        return super.constraints(runtime, random, table, column, pattern);
    }

    public List<Run> buildQueryConstraintsRun(DataRuntime runtime, Table table, Column column, String pattern) {
        return super.buildQueryConstraintsRun(runtime, table, column, pattern);
    }

    public <T extends Constraint> List<T> constraints(DataRuntime runtime, int index, boolean create, Table table, List<T> constraints, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, Table table, Column column, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, table, column, constraints, set);
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, String random, boolean greedy, Table table, List<Trigger.EVENT> events) {
        return super.triggers(runtime, random, greedy, table, events);
    }

    public List<Run> buildQueryTriggersRun(DataRuntime runtime, Table table, List<Trigger.EVENT> events) {
        return super.buildQueryTriggersRun(runtime, table, events);
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        return super.triggers(runtime, index, create, table, triggers, set);
    }

    public <T extends Procedure> List<T> procedures(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        List<Run> runs;
        List procedures = new ArrayList();
        if (null == random) {
            random = this.random(runtime);
        }
        if (null == catalog || null == schema) {
            Table tmp = new Table();
            this.checkSchema(runtime, tmp);
            if (null == catalog) {
                catalog = tmp.getCatalog();
            }
            if (null == schema) {
                schema = tmp.getSchema();
            }
        }
        if (null != (runs = this.buildQueryProceduresRun(runtime, catalog, schema, pattern))) {
            int idx = 0;
            for (Run run : runs) {
                block8: {
                    DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                    try {
                        procedures = this.procedures(runtime, idx, true, procedures, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block8;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return procedures;
    }

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        List<Run> runs;
        LinkedHashMap procedures = new LinkedHashMap();
        if (null == random) {
            random = this.random(runtime);
        }
        if (null == catalog || null == schema) {
            Table tmp = new Table();
            this.checkSchema(runtime, tmp);
            if (null == catalog) {
                catalog = tmp.getCatalog();
            }
            if (null == schema) {
                schema = tmp.getSchema();
            }
        }
        if (null != (runs = this.buildQueryProceduresRun(runtime, catalog, schema, pattern))) {
            int idx = 0;
            for (Run run : runs) {
                block8: {
                    DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                    try {
                        procedures = this.procedures(runtime, idx, true, procedures, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block8;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return procedures;
    }

    public List<Run> buildQueryProceduresRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern) {
        return super.buildQueryProceduresRun(runtime, catalog, schema, pattern);
    }

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> procedures, DataSet set) throws Exception {
        return super.procedures(runtime, index, create, procedures, set);
    }

    public <T extends Procedure> List<T> procedures(DataRuntime runtime, boolean create, List<T> procedures) throws Exception {
        return super.procedures(runtime, create, procedures);
    }

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, boolean create, LinkedHashMap<String, T> procedures) throws Exception {
        return super.procedures(runtime, create, procedures);
    }

    public List<String> ddl(DataRuntime runtime, String random, Procedure procedure) {
        return super.ddl(runtime, random, procedure);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildQueryDdlsRun(runtime, procedure);
    }

    public List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, procedure, ddls, set);
    }

    public <T extends Function> List<T> functions(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        List<Run> runs;
        List functions = new ArrayList();
        if (null == random) {
            random = this.random(runtime);
        }
        if (null == catalog || null == schema) {
            Table tmp = new Table();
            this.checkSchema(runtime, tmp);
            if (null == catalog) {
                catalog = tmp.getCatalog();
            }
            if (null == schema) {
                schema = tmp.getSchema();
            }
        }
        if (null != (runs = this.buildQueryFunctionsRun(runtime, catalog, schema, pattern))) {
            int idx = 0;
            for (Run run : runs) {
                block8: {
                    DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                    try {
                        functions = this.functions(runtime, idx, true, functions, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block8;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return functions;
    }

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        List<Run> runs;
        LinkedHashMap functions = new LinkedHashMap();
        if (null == random) {
            random = this.random(runtime);
        }
        if (null == catalog || null == schema) {
            Table tmp = new Table();
            this.checkSchema(runtime, tmp);
            if (null == catalog) {
                catalog = tmp.getCatalog();
            }
            if (null == schema) {
                schema = tmp.getSchema();
            }
        }
        if (null != (runs = this.buildQueryFunctionsRun(runtime, catalog, schema, pattern))) {
            int idx = 0;
            for (Run run : runs) {
                block8: {
                    DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                    try {
                        functions = this.functions(runtime, idx, true, functions, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block8;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return functions;
    }

    public List<Run> buildQueryFunctionsRun(DataRuntime runtime, Catalog catalog, Schema schema, String name) {
        return super.buildQueryFunctionsRun(runtime, catalog, schema, name);
    }

    public <T extends Function> List<T> functions(DataRuntime runtime, int index, boolean create, List<T> functions, DataSet set) throws Exception {
        return super.functions(runtime, index, create, functions, set);
    }

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> functions, DataSet set) throws Exception {
        return super.functions(runtime, index, create, functions, set);
    }

    public <T extends Function> List<T> functions(DataRuntime runtime, boolean create, List<T> functions) throws Exception {
        return super.functions(runtime, create, functions);
    }

    public List<String> ddl(DataRuntime runtime, String random, Function meta) {
        return super.ddl(runtime, random, meta);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildQueryDdlsRun(runtime, meta);
    }

    public List<String> ddl(DataRuntime runtime, int index, Function function, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, function, ddls, set);
    }

    public <T extends Table> T table(List<T> tables, Catalog catalog, Schema schema, String name) {
        return (T)super.table(tables, catalog, schema, name);
    }

    public <T extends Schema> T schema(List<T> schemas, Catalog catalog, String name) {
        return (T)super.schema(schemas, catalog, name);
    }

    public <T extends Catalog> T catalog(List<T> catalogs, String name) {
        return (T)super.catalog(catalogs, name);
    }

    public <T extends Database> T database(List<T> databases, String name) {
        return (T)super.database(databases, name);
    }

    public boolean execute(DataRuntime runtime, String random, BaseMetadata meta, ACTION.DDL action, Run run) {
        if (null == run) {
            return false;
        }
        boolean result = false;
        String sql = run.getFinalUpdate();
        meta.addDdl(sql);
        if (BasicUtil.isNotEmpty((Object)sql)) {
            if (meta.execute()) {
                this.update(runtime, random, null, null, null, run);
                CacheProxy.clear();
            }
            result = true;
        }
        return result;
    }

    public boolean create(DataRuntime runtime, Table meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Table meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Table origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public String keyword(Table meta) {
        return meta.getKeyword();
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Table meta) throws Exception {
        LinkedHashMap indexs;
        List pksql;
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE TABLE ");
        this.checkTableExists(runtime, builder, false);
        this.name(runtime, builder, (BaseMetadata)meta);
        Table master = meta.getMaster();
        if (null != master) {
            this.partitionOf(runtime, builder, meta);
        }
        LinkedHashMap columMap = meta.getColumns();
        Collection columns = null;
        PrimaryKey primary = meta.getPrimaryKey();
        LinkedHashMap pks = null;
        if (null != primary) {
            pks = primary.getColumns();
        } else {
            pks = meta.primarys();
            primary = new PrimaryKey();
            primary.setTable(meta);
            for (Object col : pks.values()) {
                primary.addColumn((Column)col);
            }
        }
        if (null != columMap && null != (columns = columMap.values()) && !columns.isEmpty()) {
            builder.append("(\n");
            int idx = 0;
            for (Column column : columns) {
                builder.append("\t");
                if (idx > 0) {
                    builder.append(",");
                }
                column.setAction(ACTION.DDL.COLUMN_ADD);
                this.delimiter(builder, column.getName()).append(" ");
                this.define(runtime, builder, column).append("\n");
                ++idx;
            }
            builder.append("\t");
            if (!pks.isEmpty()) {
                this.primary(runtime, builder, meta);
            }
            builder.append(")");
        }
        this.partitionBy(runtime, builder, meta);
        if (BasicUtil.isNotEmpty((Object)meta.getInherits())) {
            if (null == columns || columns.isEmpty()) {
                builder.append("()");
            }
            builder.append(" INHERITS(");
            this.name(runtime, builder, (BaseMetadata)meta.getInherits());
            builder.append(")");
        }
        this.charset(runtime, builder, meta);
        this.comment(runtime, builder, meta);
        List<Run> tableComment = this.buildAppendCommentRun(runtime, meta);
        if (null != tableComment) {
            runs.addAll(tableComment);
        }
        if (null != columns) {
            for (Column column : columns) {
                List<Run> columnComment = this.buildAppendCommentRun(runtime, column);
                if (null == columnComment) continue;
                runs.addAll(columnComment);
            }
        }
        if (null != primary && null != (pksql = this.buildAddRunAfterTable(runtime, primary))) {
            runs.addAll(pksql);
        }
        if (null != (indexs = meta.getIndexs())) {
            for (Index index : indexs.values()) {
                if (index.isPrimary()) continue;
                runs.addAll(this.buildAddRun(runtime, index));
            }
        }
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table table, Collection<Column> columns) throws Exception {
        return super.buildAlterRun(runtime, table, columns);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Table meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP ").append(this.keyword(meta)).append(" ");
        this.checkTableExists(runtime, builder, true);
        this.name(runtime, builder, (BaseMetadata)meta);
        return runs;
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        builder.append(" IF ");
        if (!exists) {
            builder.append("NOT ");
        }
        builder.append("EXISTS ");
        return builder;
    }

    public void checkPrimary(DataRuntime runtime, Table table) {
        super.checkPrimary(runtime, table);
    }

    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table meta) {
        PrimaryKey primary = meta.getPrimaryKey();
        LinkedHashMap pks = null;
        pks = null != primary ? primary.getColumns() : meta.primarys();
        if (!pks.isEmpty()) {
            builder.append(",PRIMARY KEY (");
            boolean first = true;
            for (Column pk : pks.values()) {
                if (!first) {
                    builder.append(",");
                }
                this.delimiter(builder, pk.getName());
                String order = pk.getOrder();
                if (BasicUtil.isNotEmpty((Object)order)) {
                    builder.append(" ").append(order);
                }
                first = false;
            }
            builder.append(")");
        }
        return builder;
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.charset(runtime, builder, meta);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.comment(runtime, builder, meta);
    }

    public StringBuilder partitionBy(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        Partition partition = meta.getPartitionBy();
        if (null != partition) {
            builder.append(" PARTITION BY ").append(partition.getType()).append("(");
            LinkedHashMap columns = partition.getColumns();
            int idx = 0;
            for (Column column : columns.values()) {
                if (idx > 0) {
                    builder.append(",");
                }
                this.delimiter(builder, column.getName());
                ++idx;
            }
            builder.append(")");
        }
        return builder;
    }

    public StringBuilder partitionOf(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        builder.append(" PARTITION OF ");
        Table master = meta.getMaster();
        if (null == master) {
            throw new java.sql.SQLException("\u672a\u63d0\u4f9b Master Table");
        }
        this.name(runtime, builder, (BaseMetadata)master);
        builder.append(" FOR VALUES");
        Partition partition = meta.getPartitionFor();
        Partition.TYPE type = null;
        if (null != partition) {
            type = partition.getType();
        }
        if (null == type && null != master.getPartitionBy()) {
            type = master.getPartitionBy().getType();
        }
        if (type == Partition.TYPE.LIST) {
            List list = partition.getList();
            if (null == list) {
                throw new java.sql.SQLException("\u672a\u63d0\u4f9b\u5206\u533a\u8868\u679a\u4e3e\u503c(Partition.list)");
            }
            builder.append(" IN(");
            boolean first = true;
            for (Object item : list) {
                if (!first) {
                    builder.append(",");
                }
                first = false;
                if (item instanceof Number) {
                    builder.append(item);
                    continue;
                }
                builder.append("'").append(item).append("'");
            }
            builder.append(")");
        } else if (type == Partition.TYPE.RANGE) {
            Object from = partition.getFrom();
            Object to = partition.getTo();
            if (BasicUtil.isEmpty((Object)from) || BasicUtil.isEmpty((Object)to)) {
                throw new java.sql.SQLException("\u672a\u63d0\u4f9b\u5206\u533a\u8868\u8303\u56f4\u503c(Partition.from/to)");
            }
            builder.append(" FROM (");
            if (from instanceof Number) {
                builder.append(from);
            } else {
                builder.append("'").append(from).append("'");
            }
            builder.append(")");
            builder.append(" TO (");
            if (to instanceof Number) {
                builder.append(to);
            } else {
                builder.append("'").append(to).append("'");
            }
            builder.append(")");
        } else if (type == Partition.TYPE.HASH) {
            int modulus = partition.getModulus();
            if (modulus == 0) {
                throw new java.sql.SQLException("\u672a\u63d0\u4f9b\u5206\u533a\u8868MODULUS");
            }
            builder.append(" WITH(MODULUS ").append(modulus).append(",REMAINDER ").append(partition.getRemainder()).append(")");
        }
        return builder;
    }

    public boolean create(DataRuntime runtime, View meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, View meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, View meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, View origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, View meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE VIEW ");
        this.name(runtime, builder, (BaseMetadata)meta);
        builder.append(" AS \n").append(meta.getDefinition());
        runs.addAll(this.buildAppendCommentRun(runtime, meta));
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, View meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER VIEW ");
        this.name(runtime, builder, (BaseMetadata)meta);
        builder.append(" AS \n").append(meta.getDefinition());
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, View meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP ").append(meta.getKeyword()).append(" ");
        this.checkViewExists(runtime, builder, true);
        this.name(runtime, builder, (BaseMetadata)meta);
        return runs;
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        builder.append(" IF ");
        if (!exists) {
            builder.append("NOT ");
        }
        builder.append("EXISTS ");
        return builder;
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, View meta) {
        return super.comment(runtime, builder, meta);
    }

    public boolean create(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, MasterTable origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public boolean create(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, PartitionTable origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public boolean add(DataRuntime runtime, Column meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, Column meta, boolean trigger) throws Exception {
        return super.alter(runtime, table, meta, trigger);
    }

    public boolean alter(DataRuntime runtime, Column meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Column meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Column origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (!slice) {
            Table table = meta.getTable(true);
            builder.append("ALTER ").append(this.keyword(table)).append(" ");
            this.name(runtime, builder, (BaseMetadata)table);
        }
        this.addColumnGuide(runtime, builder, meta);
        this.delimiter(builder, meta.getName()).append(" ");
        this.define(runtime, builder, meta);
        runs.addAll(this.buildAppendCommentRun(runtime, meta));
        return runs;
    }

    public List<Run> buildAddRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildAddRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        Column update = (Column)meta.getUpdate();
        if (null != update) {
            List<Run> cmts;
            String ucomment;
            String comment;
            List<Run> nulls;
            int unullable;
            int nullable;
            List<Run> defs;
            List<Run> list;
            String uname;
            String name;
            if (null == update.getTable(false)) {
                update.setTable(meta.getTable(false));
            }
            if (!BasicUtil.equalsIgnoreCase((Object)(name = meta.getName()), (Object)(uname = update.getName())) && !uname.endsWith("_TMP_UPDATE_TYPE")) {
                runs.addAll(this.buildRenameRun(runtime, meta));
            }
            String type = this.type(runtime, null, meta).toString();
            String utype = this.type(runtime, null, update).toString();
            boolean exe = false;
            if (!BasicUtil.equalsIgnoreCase((Object)type, (Object)utype)) {
                list = this.buildChangeTypeRun(runtime, meta);
                if (null != list) {
                    runs.addAll(list);
                    exe = true;
                }
            } else if ((meta.getPrecision() != update.getPrecision() || meta.getScale() != update.getScale()) && null != (list = this.buildChangeTypeRun(runtime, meta))) {
                runs.addAll(list);
                exe = true;
            }
            Object def = meta.getDefaultValue();
            Object udef = update.getDefaultValue();
            if (!BasicUtil.equalsIgnoreCase((Object)def, (Object)udef) && null != (defs = this.buildChangeDefaultRun(runtime, meta))) {
                runs.addAll(defs);
            }
            if ((nullable = meta.isNullable()) != (unullable = update.isNullable()) && null != (nulls = this.buildChangeNullableRun(runtime, meta))) {
                runs.addAll(nulls);
            }
            if (!BasicUtil.equalsIgnoreCase((Object)(comment = meta.getComment()), (Object)(ucomment = update.getComment())) && null != (cmts = this.buildChangeCommentRun(runtime, meta))) {
                runs.addAll(cmts);
            }
        }
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (meta instanceof Tag) {
            Tag tag = (Tag)meta;
            return this.buildDropRun(runtime, tag);
        }
        if (!slice) {
            Table table = meta.getTable(true);
            builder.append("ALTER ").append(this.keyword(table)).append(" ");
            this.name(runtime, builder, (BaseMetadata)table);
        }
        this.dropColumnGuide(runtime, builder, meta);
        this.delimiter(builder, meta.getName());
        return runs;
    }

    public List<Run> buildDropRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Column meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        builder.append("ALTER ").append(this.keyword(table)).append(" ");
        this.name(runtime, builder, (BaseMetadata)table);
        builder.append(" RENAME ").append(meta.getKeyword()).append(" ");
        this.delimiter(builder, meta.getName());
        builder.append(" ");
        this.delimiter(builder, meta.getUpdate());
        meta.setName(((Column)meta.getUpdate()).getName());
        return runs;
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildChangeTypeRun(runtime, meta);
    }

    public String alterColumnKeyword(DataRuntime runtime) {
        return super.alterColumnKeyword(runtime);
    }

    public StringBuilder addColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        builder.append(" ADD ").append(meta.getKeyword()).append(" ");
        return builder;
    }

    public StringBuilder dropColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        builder.append(" DROP ").append(meta.getKeyword()).append(" ");
        return builder;
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildChangeDefaultRun(runtime, meta);
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildChangeNullableRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildDropAutoIncrement(DataRuntime runtime, Column meta) throws Exception {
        return super.buildDropAutoIncrement(runtime, meta);
    }

    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column meta) {
        this.type(runtime, builder, meta);
        this.charset(runtime, builder, meta);
        this.defaultValue(runtime, builder, meta);
        this.nullable(runtime, builder, meta);
        this.primary(runtime, builder, meta);
        this.increment(runtime, builder, meta);
        this.onupdate(runtime, builder, meta);
        this.comment(runtime, builder, meta);
        this.position(runtime, builder, meta);
        return builder;
    }

    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkColumnExists(runtime, builder, exists);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (null == builder) {
            builder = new StringBuilder();
        }
        boolean isIgnorePrecision = false;
        boolean isIgnoreScale = false;
        String typeName = meta.getTypeName();
        ColumnType type = this.type(typeName);
        if (null != type) {
            if (!type.support()) {
                throw new RuntimeException("\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301:" + typeName);
            }
            isIgnorePrecision = type.ignorePrecision();
            isIgnoreScale = type.ignoreScale();
            typeName = type.getName();
        } else {
            isIgnorePrecision = this.isIgnorePrecision(runtime, meta);
            isIgnoreScale = this.isIgnoreScale(runtime, meta);
        }
        return this.type(runtime, builder, meta, typeName, isIgnorePrecision, isIgnoreScale);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta, String type, boolean isIgnorePrecision, boolean isIgnoreScale) {
        Integer precision;
        if (null == builder) {
            builder = new StringBuilder();
        }
        builder.append(type);
        if (!isIgnorePrecision && null != (precision = meta.getPrecision())) {
            if (precision > 0) {
                builder.append("(").append(precision);
                Integer scale = meta.getScale();
                if (null != scale && scale > 0 && !isIgnoreScale) {
                    builder.append(",").append(scale);
                }
                builder.append(")");
            } else if (precision == -1) {
                builder.append("(max)");
            }
        }
        String child = meta.getChildTypeName();
        Integer srid = meta.getSrid();
        if (null != child) {
            builder.append("(");
            builder.append(child);
            if (null != srid) {
                builder.append(",").append(srid);
            }
            builder.append(")");
        }
        if (meta.isArray()) {
            builder.append("[]");
        }
        return builder;
    }

    public boolean isIgnorePrecision(DataRuntime runtime, Column meta) {
        String chk;
        Boolean chkResult;
        ColumnType type = meta.getColumnType();
        if (null != type) {
            return type.ignorePrecision();
        }
        String typeName = meta.getTypeName();
        if (null != typeName && null != (chkResult = this.checkIgnorePrecision(runtime, chk = typeName.toUpperCase()))) {
            return chkResult;
        }
        return false;
    }

    public boolean isIgnoreScale(DataRuntime runtime, Column meta) {
        String chk;
        Boolean chkResult;
        ColumnType type = meta.getColumnType();
        if (null != type) {
            return type.ignoreScale();
        }
        String name = meta.getTypeName();
        if (null != name && null != (chkResult = this.checkIgnoreScale(runtime, chk = name.toUpperCase()))) {
            return chkResult;
        }
        return false;
    }

    public Boolean checkIgnorePrecision(DataRuntime runtime, String type) {
        return super.checkIgnorePrecision(runtime, type);
    }

    public Boolean checkIgnoreScale(DataRuntime runtime, String type) {
        return super.checkIgnoreScale(runtime, type);
    }

    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column meta) {
        int nullable = meta.isNullable();
        if (nullable != -1) {
            if (nullable == 0) {
                builder.append(" NOT");
            }
            builder.append(" NULL");
        }
        return builder;
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.charset(runtime, builder, meta);
    }

    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column meta) {
        Object def = null;
        boolean defaultCurrentDateTime = false;
        if (null != meta.getUpdate()) {
            def = ((Column)meta.getUpdate()).getDefaultValue();
            defaultCurrentDateTime = ((Column)meta.getUpdate()).isDefaultCurrentDateTime();
        } else {
            def = meta.getDefaultValue();
            defaultCurrentDateTime = meta.isDefaultCurrentDateTime();
        }
        if (null == def && defaultCurrentDateTime) {
            String type = meta.getFullType().toLowerCase();
            def = type.contains("timestamp") ? DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIMESTAMP : DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_DATETIME;
        }
        if (null != def) {
            builder.append(" DEFAULT ");
            DriverAdapter.SQL_BUILD_IN_VALUE val = this.checkDefaultBuildInValue(runtime, def);
            if (null != val) {
                def = val;
            }
            if (def instanceof DriverAdapter.SQL_BUILD_IN_VALUE) {
                String value = this.value(runtime, meta, (DriverAdapter.SQL_BUILD_IN_VALUE)def);
                if (null != value) {
                    builder.append(value);
                }
            } else {
                if (null == (def = this.write(runtime, meta, def, false))) {
                    def = meta.getDefaultValue();
                }
                builder.append(def);
            }
        }
        return builder;
    }

    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.primary(runtime, builder, meta);
    }

    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.increment(runtime, builder, meta);
    }

    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.onupdate(runtime, builder, meta);
    }

    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.position(runtime, builder, meta);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.comment(runtime, builder, meta);
    }

    public boolean add(DataRuntime runtime, Tag meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, Tag meta, boolean trigger) throws Exception {
        return super.alter(runtime, table, meta, trigger);
    }

    public boolean alter(DataRuntime runtime, Tag meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Tag meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Tag origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Tag meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        builder.append("ALTER ").append(this.keyword(table)).append(" ");
        this.name(runtime, builder, (BaseMetadata)table);
        builder.append(" ADD TAG ");
        this.delimiter(builder, meta.getName()).append(" ");
        this.define(runtime, builder, (Column)meta);
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Tag meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        Tag update = meta.getUpdate();
        if (null != update) {
            String ucomment;
            String comment;
            int unullable;
            int nullable;
            List<Run> list;
            String uname;
            String name = meta.getName();
            if (!BasicUtil.equalsIgnoreCase((Object)name, (Object)(uname = update.getName())) && !uname.endsWith("_TMP_UPDATE_TYPE")) {
                runs.addAll(this.buildRenameRun(runtime, meta));
            }
            meta.setName(uname);
            String type = this.type(runtime, null, (Column)meta).toString();
            String utype = this.type(runtime, null, (Column)update).toString();
            if (!BasicUtil.equalsIgnoreCase((Object)type, (Object)utype)) {
                list = this.buildChangeTypeRun(runtime, meta);
                if (null != list) {
                    runs.addAll(list);
                }
            } else if ((meta.getPrecision() != update.getPrecision() || meta.getScale() != update.getScale()) && null != (list = this.buildChangeTypeRun(runtime, meta))) {
                runs.addAll(list);
            }
            Object def = meta.getDefaultValue();
            Object udef = update.getDefaultValue();
            if (!BasicUtil.equalsIgnoreCase((Object)def, (Object)udef)) {
                runs.addAll(this.buildChangeDefaultRun(runtime, meta));
            }
            if ((nullable = meta.isNullable()) != (unullable = update.isNullable())) {
                runs.addAll(this.buildChangeNullableRun(runtime, meta));
            }
            if (!BasicUtil.equalsIgnoreCase((Object)(comment = meta.getComment()), (Object)(ucomment = update.getComment()))) {
                runs.addAll(this.buildChangeCommentRun(runtime, meta));
            }
        }
        return runs;
    }

    public List<Run> buildDropRun(DataRuntime runtime, Tag meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        builder.append("ALTER ").append(this.keyword(table)).append(" ");
        this.name(runtime, builder, (BaseMetadata)table);
        builder.append(" DROP ").append(meta.getKeyword()).append(" ");
        this.delimiter(builder, meta.getName());
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Tag meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        builder.append("ALTER ").append(this.keyword(table)).append(" ");
        this.name(runtime, builder, (BaseMetadata)table);
        builder.append(" RENAME ").append(meta.getKeyword()).append(" ");
        this.delimiter(builder, meta.getName());
        builder.append(" ");
        this.delimiter(builder, (BaseMetadata)meta.getUpdate());
        return runs;
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildChangeDefaultRun(runtime, meta);
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildChangeNullableRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildChangeTypeRun(runtime, meta);
    }

    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTagExists(runtime, builder, exists);
    }

    public boolean add(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, PrimaryKey origin, PrimaryKey meta) throws Exception {
        return super.alter(runtime, table, origin, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, PrimaryKey meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    public boolean drop(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, PrimaryKey origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildAddRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        return super.buildAddRun(runtime, meta, slice);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey origin, PrimaryKey meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (null != meta) {
            Table table = null;
            table = null != meta ? meta.getTable() : origin.getTable();
            ArrayList<Run> slices = new ArrayList<Run>();
            if (null != origin) {
                slices.addAll(this.buildDropRun(runtime, origin, true));
            }
            if (null != meta) {
                slices.addAll(this.buildAddRun(runtime, meta, true));
            }
            if (!slices.isEmpty()) {
                SimpleRun run = new SimpleRun(runtime);
                runs.add((Run)run);
                StringBuilder builder = run.getBuilder();
                builder.append("ALTER TABLE ");
                this.name(runtime, builder, (BaseMetadata)table);
                boolean first = true;
                for (Run item : slices) {
                    if (!first) {
                        builder.append(",");
                    }
                    builder.append((CharSequence)item.getBuilder());
                    first = false;
                }
            }
        }
        return runs;
    }

    public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, (BaseMetadata)meta.getTable(true));
        builder.append(" DROP CONSTRAINT ");
        this.delimiter(builder, meta.getName());
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public boolean add(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, ForeignKey meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    public boolean drop(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, ForeignKey origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildAddRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap columns = meta.getColumns();
        if (columns.size() > 0) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, (BaseMetadata)meta.getTable(true));
            builder.append(" ADD");
            if (BasicUtil.isNotEmpty((Object)meta.getName())) {
                builder.append(" CONSTRAINT ").append(meta.getName());
            }
            builder.append(" FOREIGN KEY (");
            boolean first = true;
            for (Column column : columns.values()) {
                if (!first) {
                    builder.append(",");
                }
                this.delimiter(builder, column.getName());
                first = false;
            }
            builder.append(")");
            builder.append(" REFERENCES ").append(meta.getReference().getName()).append("(");
            first = true;
            for (Column column : columns.values()) {
                if (!first) {
                    builder.append(",");
                }
                this.delimiter(builder, (BaseMetadata)column.getReference());
                first = false;
            }
            builder.append(")");
        }
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, (BaseMetadata)meta.getTable(true));
        builder.append(" DROP FOREIGN KEY ").append(meta.getName());
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public boolean add(DataRuntime runtime, Index meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Index meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, Index meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    public boolean drop(DataRuntime runtime, Index meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Index origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Index meta) throws Exception {
        String name = meta.getName();
        if (BasicUtil.isEmpty((Object)name)) {
            name = "index_" + BasicUtil.getRandomString((int)10);
        }
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE");
        if (meta.isUnique()) {
            builder.append(" UNIQUE");
        } else if (meta.isFulltext()) {
            builder.append(" FULLTEXT");
        } else if (meta.isSpatial()) {
            builder.append(" SPATIAL");
        }
        builder.append(" INDEX ").append(name).append(" ON ");
        Table table = meta.getTable(true);
        this.name(runtime, builder, (BaseMetadata)table);
        builder.append("(");
        int qty = 0;
        Collection cols = meta.getColumns().values();
        for (Column column : cols) {
            if (qty > 0) {
                builder.append(",");
            }
            this.delimiter(builder, column.getName());
            String order = column.getOrder();
            if (BasicUtil.isNotEmpty((Object)order)) {
                builder.append(" ").append(order);
            }
            ++qty;
        }
        builder.append(")");
        this.type(runtime, builder, meta);
        this.comment(runtime, builder, meta);
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Index meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Index meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        if (meta.isPrimary()) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, (BaseMetadata)table);
            builder.append(" DROP CONSTRAINT ").append(meta.getName());
        } else {
            builder.append("DROP INDEX ").append(meta.getName());
            if (BasicUtil.isNotEmpty((Object)table)) {
                builder.append(" ON ");
                this.name(runtime, builder, (BaseMetadata)table);
            }
        }
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Index meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Index meta) {
        return super.type(runtime, builder, meta);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Index meta) {
        return super.comment(runtime, builder, meta);
    }

    public boolean add(DataRuntime runtime, Constraint meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Constraint meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, Constraint meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    public boolean drop(DataRuntime runtime, Constraint meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Constraint origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Constraint meta) throws Exception {
        String name = meta.getName();
        if (BasicUtil.isEmpty((Object)name)) {
            name = "constraint_" + BasicUtil.getRandomString((int)10);
        }
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        Table table = meta.getTable(true);
        this.name(runtime, builder, (BaseMetadata)table);
        builder.append(" ADD CONSTRAINT ").append(name);
        if (meta.isUnique()) {
            builder.append(" UNIQUE");
        }
        builder.append("(");
        boolean first = true;
        Collection cols = meta.getColumns().values();
        for (Column column : cols) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            this.delimiter(builder, column.getName());
            String order = column.getOrder();
            if (!BasicUtil.isNotEmpty((Object)order)) continue;
            builder.append(" ").append(order);
        }
        builder.append(")");
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Constraint meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        Table table = meta.getTable(true);
        this.name(runtime, builder, (BaseMetadata)table);
        builder.append(" DROP CONSTRAINT ").append(meta.getName());
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Constraint meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER CONSTRAINT ");
        this.name(runtime, builder, (BaseMetadata)meta);
        builder.append(" RENAME TO ");
        this.delimiter(builder, meta.getUpdate().getName());
        return runs;
    }

    public boolean add(DataRuntime runtime, Trigger meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Trigger meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Trigger meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Trigger origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Trigger meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE TRIGGER ").append(meta.getName());
        builder.append(" ").append(meta.getTime().sql()).append(" ");
        List events = meta.getEvents();
        boolean first = true;
        for (Trigger.EVENT event : events) {
            if (!first) {
                builder.append(" OR ");
            }
            builder.append(event);
            first = false;
        }
        builder.append(" ON ");
        this.name(runtime, builder, (BaseMetadata)meta.getTable(true));
        this.each(runtime, builder, meta);
        builder.append("\n").append(meta.getDefinition());
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Trigger meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP TRIGGER ");
        Table table = meta.getTable(true);
        if (null != table) {
            Catalog catalog = table.getCatalog();
            Schema schema = table.getSchema();
            if (BasicUtil.isNotEmpty((Object)catalog)) {
                this.delimiter(builder, (BaseMetadata)catalog).append(".");
            }
            if (BasicUtil.isNotEmpty((Object)schema)) {
                this.delimiter(builder, (BaseMetadata)schema).append(".");
            }
        }
        this.delimiter(builder, meta.getName());
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Trigger meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        Catalog catalog = table.getCatalog();
        Schema schema = table.getSchema();
        builder.append("ALTER TRIGGER ");
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            this.delimiter(builder, (BaseMetadata)catalog).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            this.delimiter(builder, (BaseMetadata)schema).append(".");
        }
        this.delimiter(builder, meta.getName());
        builder.append(" RENAME TO ");
        this.delimiter(builder, meta.getUpdate());
        return runs;
    }

    public StringBuilder each(DataRuntime runtime, StringBuilder builder, Trigger meta) {
        if (meta.isEach()) {
            builder.append(" FOR EACH ROW ");
        } else {
            builder.append(" FOR EACH STATEMENT ");
        }
        return builder;
    }

    public boolean create(DataRuntime runtime, Procedure meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Procedure meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Procedure meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Procedure origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Procedure meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE PROCEDURE ");
        this.name(runtime, builder, (BaseMetadata)meta);
        builder.append("(\n");
        List ins = meta.getInputs();
        List outs = meta.getOutputs();
        boolean first = true;
        for (Parameter parameter : ins) {
            if (parameter.isOutput()) continue;
            if (!first) {
                builder.append(",");
            }
            this.parameter(runtime, builder, parameter);
        }
        for (Parameter parameter : outs) {
            if (!first) {
                builder.append(",");
            }
            this.parameter(runtime, builder, parameter);
        }
        builder.append("\n)");
        String returnType = meta.getReturnType();
        if (BasicUtil.isNotEmpty((Object)returnType)) {
            builder.append(" RETURNS ").append(returnType);
        }
        builder.append("\n");
        builder.append(meta.getDefinition());
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Procedure meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP PROCEDURE ");
        this.name(runtime, builder, (BaseMetadata)meta);
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Procedure meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER PROCEDURE ");
        this.name(runtime, builder, (BaseMetadata)meta);
        builder.append(" RENAME TO ");
        this.delimiter(builder, meta.getUpdate());
        return runs;
    }

    public StringBuilder parameter(DataRuntime runtime, StringBuilder builder, Parameter parameter) {
        boolean in = parameter.isInput();
        boolean out = parameter.isOutput();
        if (in) {
            builder.append("IN");
        }
        if (out) {
            builder.append("OUT");
        }
        builder.append(" ").append(parameter.getName());
        ColumnType type = parameter.getColumnType();
        boolean isIgnorePrecision = type.ignorePrecision();
        boolean isIgnoreScale = type.ignoreScale();
        builder.append(type);
        if (!isIgnorePrecision) {
            Integer precision = parameter.getPrecision();
            Integer scale = parameter.getScale();
            if (null != precision) {
                if (precision > 0) {
                    builder.append("(").append(precision);
                    if (null != scale && scale > 0 && !isIgnoreScale) {
                        builder.append(",").append(scale);
                    }
                    builder.append(")");
                } else if (precision == -1) {
                    builder.append("(max)");
                }
            }
        }
        return builder;
    }

    public boolean create(DataRuntime runtime, Function meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Function meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Function meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Function origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Function meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP FUNCTION ");
        this.name(runtime, builder, (BaseMetadata)meta);
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Function meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER FUNCTION ");
        this.name(runtime, builder, (BaseMetadata)meta);
        builder.append(" RENAME TO ");
        this.delimiter(builder, ((Function)meta.getUpdate()).getName());
        return runs;
    }

    @Override
    public boolean identity(DataRuntime runtime, String random, Object data, ConfigStore configs, KeyHolder keyholder) {
        block18: {
            try {
                if (null == keyholder) {
                    return false;
                }
                if (!this.IS_KEYHOLDER_IDENTITY(configs)) {
                    return false;
                }
                List keys = keyholder.getKeyList();
                String id_key = this.generatedKey();
                if (null == id_key && keys.size() > 0) {
                    Map key = (Map)keys.get(0);
                    id_key = (String)key.keySet().iterator().next();
                }
                if (data instanceof Collection) {
                    Long num;
                    Object last;
                    Object item;
                    ArrayList ids = new ArrayList();
                    Collection list = (Collection)data;
                    Iterator iterator = list.iterator();
                    if (iterator.hasNext() && BasicUtil.isNotEmpty((boolean)true, (Object)this.getPrimaryValue(runtime, item = iterator.next()))) {
                        return true;
                    }
                    if (BasicUtil.isEmpty((Object)id_key)) {
                        return false;
                    }
                    int i = 0;
                    int data_size = list.size();
                    if (list.size() == keys.size()) {
                        for (Object item2 : list) {
                            Map key = (Map)keys.get(i);
                            Object id = key.get(id_key);
                            ids.add(id);
                            this.setPrimaryValue(item2, id);
                            ++i;
                        }
                    } else if (null != keys && keys.size() > 0 && (last = ((Map)keys.get(0)).get(id_key)) instanceof Number && null != (num = BasicUtil.parseLong((Object)last.toString(), null))) {
                        num = num - (long)data_size + 1L;
                        for (Object item3 : list) {
                            Long l = num;
                            Long l2 = num = Long.valueOf(num + 1L);
                            this.setPrimaryValue(item3, l);
                        }
                    }
                    if (this.IS_LOG_SQL(configs) && log.isWarnEnabled()) {
                        log.warn("{}[exe insert][\u751f\u6210\u4e3b\u952e:{}]", (Object)random, ids);
                    }
                    break block18;
                }
                if (null != keys && keys.size() > 0 && BasicUtil.isEmpty((boolean)true, (Object)this.getPrimaryValue(runtime, data))) {
                    Object id = ((Map)keys.get(0)).get(id_key);
                    this.setPrimaryValue(data, id);
                    if (this.IS_LOG_SQL(configs) && log.isWarnEnabled()) {
                        log.warn("{}[exe insert][\u751f\u6210\u4e3b\u952e:{}]", (Object)random, id);
                    }
                }
            }
            catch (Exception e) {
                if (this.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                    e.printStackTrace();
                }
                if (this.IS_LOG_SQL_WHEN_ERROR(configs)) {
                    log.warn("{}[exe insert][\u8fd4\u56de\u4e3b\u952e\u5931\u8d25]", (Object)random);
                }
                return false;
            }
        }
        return true;
    }

    protected void init(Column column, Table table, DataRow row) {
        String defaultValue;
        String schema;
        String catalog = (String)BasicUtil.evl((Object[])new String[]{row.getString("TABLE_CATALOG"), column.getCatalogName(), table.getCatalogName()});
        if (null != catalog) {
            catalog = catalog.trim();
        }
        if (null != (schema = (String)BasicUtil.evl((Object[])new String[]{row.getString(new String[]{"TABLE_SCHEMA", "TABSCHEMA", "SCHEMA_NAME", "OWNER"}), column.getSchemaName(), table.getSchemaName()}))) {
            schema = schema.trim();
        }
        column.setCatalog(catalog);
        column.setSchema(schema);
        if (null != table.getName()) {
            column.setTable(table);
        }
        column.setTable((String)BasicUtil.evl((Object[])new String[]{row.getString(new String[]{"TABLE_NAME", "TABNAME"}), table.getName(), column.getTableName(true)}));
        if (null == column.getPosition()) {
            try {
                column.setPosition(row.getInt(new String[]{"ORDINAL_POSITION", "COLNO", "POSITION"}));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        column.setComment((String)BasicUtil.evl((Object[])new String[]{row.getString(new String[]{"COLUMN_COMMENT", "COMMENTS", "REMARKS"}), column.getComment()}));
        String type = row.getString(new String[]{"FULL_TYPE", "DATA_TYPE", "TYPE_NAME", "TYPENAME", "DATA_TYPE_NAME"});
        if (null != type && type.contains(" ")) {
            type = row.getString(new String[]{"UDT_NAME", "DATA_TYPE", "TYPENAME", "DATA_TYPE_NAME"});
        }
        column.setTypeName((String)BasicUtil.evl((Object[])new String[]{type, column.getTypeName()}));
        String def = BasicUtil.evl((Object[])new Object[]{row.get(new String[]{"COLUMN_DEFAULT", "DATA_DEFAULT", "DEFAULT", "DEFAULT_VALUE", "DEFAULT_DEFINITION"}), column.getDefaultValue()}) + "";
        if (BasicUtil.isNotEmpty((Object)def)) {
            while (def.startsWith("(") && def.endsWith(")")) {
                def = def.substring(1, def.length() - 1);
            }
            while (def.startsWith("'") && def.endsWith("'")) {
                def = def.substring(1, def.length() - 1);
            }
            column.setDefaultValue((Object)def);
        }
        column.setDefaultConstraint(row.getString("DEFAULT_CONSTRAINT"));
        if (-1 == column.isAutoIncrement()) {
            column.autoIncrement(row.getBoolean("IS_IDENTITY", null));
        }
        if (-1 == column.isAutoIncrement()) {
            column.autoIncrement(row.getBoolean("IS_AUTOINCREMENT", null));
        }
        if (-1 == column.isAutoIncrement()) {
            column.autoIncrement(row.getBoolean("IDENTITY", null));
        }
        if (-1 == column.isAutoIncrement() && row.getStringNvl("EXTRA", new String[0]).toLowerCase().contains("auto_increment")) {
            column.autoIncrement(Boolean.valueOf(true));
        }
        if ((defaultValue = column.getDefaultValue() + "").toLowerCase().contains("nextval")) {
            column.autoIncrement(Boolean.valueOf(true));
        }
        column.setObjectId(row.getLong("OBJECT_ID", (Long)null));
        String column_key = row.getString("COLUMN_KEY");
        if ("PRI".equals(column_key)) {
            column.primary(1);
        }
        if (row.getBoolean("PK", Boolean.FALSE).booleanValue()) {
            column.primary(1);
        }
        if (-1 == column.isNullable()) {
            try {
                column.nullable(row.getBoolean(new String[]{"IS_NULLABLE", "NULLABLE", "NULLS"}));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            Integer len = row.getInt(new String[]{"NUMERIC_PRECISION", "PRECISION", "DATA_PRECISION", ""});
            if (null == len || len == 0) {
                len = row.getInt(new String[]{"CHARACTER_MAXIMUM_LENGTH", "MAX_LENGTH", "DATA_LENGTH", "LENGTH"});
            }
            column.setPrecision(len);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (null == column.getScale()) {
                column.setScale(row.getInt(new String[]{"NUMERIC_SCALE", "SCALE", "DATA_SCALE"}));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (null == column.getCharset()) {
            column.setCharset(row.getString("CHARACTER_SET_NAME"));
        }
        if (null == column.getCollate()) {
            column.setCollate(row.getString("COLLATION_NAME"));
        }
        if (null == column.getColumnType()) {
            ColumnType columnType = this.type(column.getTypeName());
            column.setColumnType(columnType);
        }
    }

    @Override
    public Column column(DataRuntime runtime, Column column, ResultSetMetaData rsm, int index) {
        if (null == column) {
            column = new Column();
        }
        String catalog = null;
        String schema = null;
        try {
            catalog = (String)BasicUtil.evl((Object[])new String[]{rsm.getCatalogName(index)});
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getCatalogName]");
        }
        try {
            schema = (String)BasicUtil.evl((Object[])new String[]{rsm.getSchemaName(index)});
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getSchemaName]");
        }
        this.correctSchemaFromJDBC((BaseMetadata)column, catalog, schema);
        try {
            column.setClassName(rsm.getColumnClassName(index));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnClassName]");
        }
        try {
            column.caseSensitive(Boolean.valueOf(rsm.isCaseSensitive(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isCaseSensitive]");
        }
        try {
            column.currency(Boolean.valueOf(rsm.isCurrency(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isCurrency]");
        }
        try {
            column.setOriginalName(rsm.getColumnName(index));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnName]");
        }
        try {
            column.setName(rsm.getColumnLabel(index));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnLabel]");
        }
        try {
            column.setPrecision(Integer.valueOf(rsm.getPrecision(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getPrecision]");
        }
        try {
            column.setScale(Integer.valueOf(rsm.getScale(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getScale]");
        }
        try {
            column.setDisplaySize(Integer.valueOf(rsm.getColumnDisplaySize(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnDisplaySize]");
        }
        try {
            column.setSigned(Boolean.valueOf(rsm.isSigned(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isSigned]");
        }
        try {
            column.setTable(rsm.getTableName(index));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getTableName]");
        }
        try {
            column.setType(Integer.valueOf(rsm.getColumnType(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnType]");
        }
        try {
            String jdbcType = rsm.getColumnTypeName(index);
            column.setJdbcType(jdbcType);
            if (BasicUtil.isEmpty((Object)column.getTypeName())) {
                column.setTypeName(jdbcType);
            }
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnTypeName]");
        }
        ColumnType columnType = this.type(column.getTypeName());
        column.setColumnType(columnType);
        return column;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        Catalog catalog = table.getCatalog();
        Schema schema = table.getSchema();
        if (BasicUtil.isEmpty((Object)table.getName())) {
            return columns;
        }
        String catalogName = null;
        String schemaName = null;
        if (null != catalog) {
            catalogName = catalog.getName();
        }
        if (null != schema) {
            schemaName = schema.getName();
        }
        ResultSet set = dbmd.getColumns(catalogName, schemaName, table.getName(), pattern);
        Map<String, Integer> keys = this.keys(set);
        while (set.next()) {
            Column column;
            String columnSchema;
            String name = set.getString("COLUMN_NAME");
            if (null == name) continue;
            String columnCatalog = this.string(keys, "TABLE_CAT", set, null);
            if (null != columnCatalog) {
                columnCatalog = columnCatalog.trim();
            }
            if (null != (columnSchema = this.string(keys, "TABLE_SCHEM", set, null))) {
                columnSchema = columnSchema.trim();
            }
            if (null == (column = (Column)columns.get(name.toUpperCase()))) {
                if (!create) continue;
                column = new Column(name);
                columns.put(name.toUpperCase(), column);
            }
            this.correctSchemaFromJDBC((BaseMetadata)column, columnCatalog, columnSchema);
            if (!BasicUtil.equalsIgnoreCase((Object)catalog, (Object)column.getCatalogName()) || !BasicUtil.equalsIgnoreCase((Object)schema, (Object)column.getSchemaName())) continue;
            String remark = this.string(keys, "REMARKS", set, column.getComment());
            if ("TAG".equals(remark)) {
                column = new Tag();
            }
            column.setComment(remark);
            column.setTable((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_NAME", set, table.getName()), column.getTableName(true)}));
            column.setType(this.integer(keys, "DATA_TYPE", set, column.getType()));
            column.setType(this.integer(keys, "SQL_DATA_TYPE", set, column.getType()));
            String jdbcType = this.string(keys, "TYPE_NAME", set, column.getTypeName());
            if (BasicUtil.isEmpty((Object)column.getTypeName())) {
                column.setTypeName(jdbcType);
            }
            column.setJdbcType(jdbcType);
            column.setPrecision(this.integer(keys, "COLUMN_SIZE", set, column.getPrecision()));
            column.setScale(this.integer(keys, "DECIMAL_DIGITS", set, column.getScale()));
            column.nullable(this.bool(keys, "NULLABLE", set, column.isNullable()));
            column.setDefaultValue(this.value(keys, "COLUMN_DEF", set, column.getDefaultValue()));
            column.setPosition(this.integer(keys, "ORDINAL_POSITION", set, column.getPosition()));
            column.autoIncrement(this.bool(keys, "IS_AUTOINCREMENT", set, column.isAutoIncrement()));
            ColumnType columnType = this.type(column.getTypeName());
            column.setColumnType(columnType);
            this.column(runtime, column, set);
            column.setName(name);
        }
        ResultSet rs = dbmd.getPrimaryKeys(catalogName, schemaName, table.getName());
        while (rs.next()) {
            String name = rs.getString(4);
            Column column = (Column)columns.get(name.toUpperCase());
            if (null == column) continue;
            column.primary(Boolean.valueOf(true));
        }
        return columns;
    }

    @Override
    public Column column(DataRuntime runtime, Column column, ResultSet rs) {
        if (null == column) {
            column = new Column();
        }
        try {
            Map<String, Integer> keys = this.keys(rs);
            if (null == column.getName()) {
                column.setName(this.string(keys, "COLUMN_NAME", rs));
            }
            if (null == column.getType()) {
                column.setType(BasicUtil.parseInt((Object)this.string(keys, "DATA_TYPE", rs), null));
            }
            if (null == column.getType()) {
                column.setType(BasicUtil.parseInt((Object)this.string(keys, "SQL_DATA_TYPE", rs), null));
            }
            if (null == column.getTypeName()) {
                String jdbcType = this.string(keys, "TYPE_NAME", rs);
                column.setJdbcType(jdbcType);
                if (BasicUtil.isEmpty((Object)column.getTypeName())) {
                    column.setTypeName(jdbcType);
                }
            }
            if (null == column.getPrecision()) {
                column.setPrecision(this.integer(keys, "COLUMN_SIZE", rs, null));
            }
            if (null == column.getScale()) {
                column.setScale(BasicUtil.parseInt((Object)this.string(keys, "DECIMAL_DIGITS", rs), null));
            }
            if (null == column.getPosition()) {
                column.setPosition(BasicUtil.parseInt((Object)this.string(keys, "ORDINAL_POSITION", rs), (Integer)0));
            }
            if (-1 == column.isAutoIncrement()) {
                column.autoIncrement(BasicUtil.parseBoolean((Object)this.string(keys, "IS_AUTOINCREMENT", rs), (Boolean)false));
            }
            if (-1 == column.isGenerated()) {
                column.generated(BasicUtil.parseBoolean((Object)this.string(keys, "IS_GENERATEDCOLUMN", rs), (Boolean)false));
            }
            if (null == column.getComment()) {
                column.setComment(this.string(keys, "REMARKS", rs));
            }
            if (null == column.getPosition()) {
                column.setPosition(BasicUtil.parseInt((Object)this.string(keys, "ORDINAL_POSITION", rs), (Integer)0));
            }
            if (BasicUtil.isEmpty((Object)column.getDefaultValue())) {
                column.setDefaultValue((Object)this.string(keys, "COLUMN_DEF", rs));
            }
            ColumnType columnType = this.type(column.getTypeName());
            column.setColumnType(columnType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return column;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, SqlRowSet set) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        SqlRowSetMetaData rsm = set.getMetaData();
        for (int i = 1; i <= rsm.getColumnCount(); ++i) {
            Column column;
            String name = rsm.getColumnName(i);
            if (BasicUtil.isEmpty((Object)name) || null != (column = (Column)columns.get(name.toUpperCase())) || !create) continue;
            if (BasicUtil.isEmpty((Object)(column = this.column(runtime, column, rsm, i)).getName())) {
                column.setName(name);
            }
            columns.put(column.getName().toUpperCase(), column);
        }
        return columns;
    }

    @Override
    public Column column(DataRuntime runtime, Column column, SqlRowSetMetaData rsm, int index) {
        if (null == column) {
            column = new Column();
            String catalog = null;
            String schema = null;
            try {
                catalog = (String)BasicUtil.evl((Object[])new String[]{rsm.getCatalogName(index)});
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getCatalogName]");
            }
            try {
                schema = (String)BasicUtil.evl((Object[])new String[]{rsm.getSchemaName(index)});
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getSchemaName]");
            }
            this.correctSchemaFromJDBC((BaseMetadata)column, catalog, schema);
            try {
                column.setClassName(rsm.getColumnClassName(index));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnClassName]");
            }
            try {
                column.currency(Boolean.valueOf(rsm.isCurrency(index)));
            }
            catch (Exception e) {
                column.caseSensitive(Boolean.valueOf(rsm.isCaseSensitive(index)));
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isCurrency]");
            }
            try {
                column.setOriginalName(rsm.getColumnName(index));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnName]");
            }
            try {
                column.setName(rsm.getColumnLabel(index));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnLabel]");
            }
            try {
                column.setPrecision(Integer.valueOf(rsm.getPrecision(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getPrecision]");
            }
            try {
                column.setScale(Integer.valueOf(rsm.getScale(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getScale]");
            }
            try {
                column.setDisplaySize(Integer.valueOf(rsm.getColumnDisplaySize(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnDisplaySize]");
            }
            try {
                column.setSigned(Boolean.valueOf(rsm.isSigned(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isSigned]");
            }
            try {
                column.setTable(rsm.getTableName(index));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getTableName]");
            }
            try {
                column.setType(Integer.valueOf(rsm.getColumnType(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnType]");
            }
            try {
                String jdbcType = rsm.getColumnTypeName(index);
                column.setJdbcType(jdbcType);
                if (BasicUtil.isEmpty((Object)column.getTypeName())) {
                    column.setTypeName(jdbcType);
                }
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnTypeName]");
            }
            ColumnType columnType = this.type(column.getTypeName());
            column.setColumnType(columnType);
        }
        return column;
    }

    @Override
    public DataRow row(boolean system, DataRuntime runtime, LinkedHashMap<String, Column> metadatas, ConfigStore configs, ResultSet rs) {
        DataRow row = null;
        KeyAdapter.KEY_CASE kc = null;
        if (null != configs) {
            kc = configs.keyCase();
        }
        boolean upper = false;
        if (KeyAdapter.KEY_CASE.PUT_UPPER == kc) {
            upper = true;
            row = new DataRow(KeyAdapter.KEY_CASE.SRC);
        } else {
            row = null != kc ? new DataRow(kc) : new DataRow();
        }
        try {
            Column column;
            String name;
            int i;
            ResultSetMetaData rsmd = rs.getMetaData();
            int qty = rsmd.getColumnCount();
            if (!system && (null == metadatas || metadatas.isEmpty())) {
                for (i = 1; i <= qty; ++i) {
                    name = rsmd.getColumnLabel(i);
                    if (null == name) {
                        name = rsmd.getColumnName(i);
                    }
                    if (null == name || name.toUpperCase().equals("PAGE_ROW_NUMBER_")) continue;
                    column = metadatas.get(name);
                    column = this.column(runtime, column, rsmd, i);
                    metadatas.put(name.toUpperCase(), column);
                }
            }
            for (i = 1; i <= qty; ++i) {
                name = rsmd.getColumnLabel(i);
                if (null == name || name.toUpperCase().equals("PAGE_ROW_NUMBER_")) continue;
                try {
                    column = metadatas.get(name.toUpperCase());
                    Object value = this.read(runtime, column, rs.getObject(name), null);
                    if (upper) {
                        name = name.toUpperCase();
                    }
                    row.put(false, name, value);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            row.setMetadata(metadatas);
        }
        catch (Exception e) {
            if (this.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                e.printStackTrace();
            }
            log.error("[\u7ed3\u679c\u96c6\u5c01\u88c5]<br/> [result:fail][msg:{}]", (Object)e.toString());
        }
        return row;
    }

    protected boolean stream(StreamHandler handler, ResultSet rs, ConfigStore configs, boolean system, DataRuntime runtime, LinkedHashMap<String, Column> metadatas) {
        try {
            if (handler instanceof ResultSetHandler) {
                return ((ResultSetHandler)handler).read(rs);
            }
            if (handler instanceof DataRowHandler) {
                DataRowHandler dataRowHandler = (DataRowHandler)handler;
                DataRow row = this.row(system, runtime, metadatas, configs, rs);
                if (!dataRowHandler.read(row)) {
                    return false;
                }
            } else if (handler instanceof EntityHandler) {
                DataRow row;
                EntityHandler entityHandler;
                Class clazz = configs.entityClass();
                if (null != clazz && !(entityHandler = (EntityHandler)handler).read((row = this.row(system, runtime, metadatas, configs, rs)).entity(clazz, new String[0]))) {
                    return false;
                }
            } else if (handler instanceof MapHandler) {
                MapHandler mh = (MapHandler)handler;
                ResultSetMetaData rsmd = rs.getMetaData();
                int cols = rsmd.getColumnCount();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 1; i <= cols; ++i) {
                    String name = rsmd.getColumnLabel(i);
                    if (null == name) {
                        name = rsmd.getColumnName(i);
                    }
                    map.put(name, rs.getObject(i));
                }
                if (!mh.read(map)) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected DataSet select(DataRuntime runtime, String random, final boolean system, ACTION.DML action, Table table, final ConfigStore configs, Run run, String sql, List<Object> values) {
        DataSet set;
        block24: {
            if (BasicUtil.isEmpty((Object)sql)) {
                if (this.IS_THROW_SQL_QUERY_EXCEPTION(configs)) {
                    throw new SQLQueryException("\u672a\u6307\u5b9aSQL");
                }
                log.error("\u672a\u6307\u5b9aSQL");
                return new DataSet();
            }
            if (null != configs) {
                configs.add(run);
            }
            long fr = System.currentTimeMillis();
            if (null == random) {
                random = this.random(runtime);
            }
            if (log.isInfoEnabled() && this.IS_LOG_SQL(configs)) {
                log.info("{}[action:select]{}", (Object)random, (Object)run.log(action, this.IS_SQL_LOG_PLACEHOLDER(configs)));
            }
            set = new DataSet();
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return set;
            }
            LinkedHashMap<Object, Object> columns = new LinkedHashMap();
            if (!system && this.IS_AUTO_CHECK_METADATA(configs) && null != table) {
                columns = this.columns(runtime, random, false, table, false);
            }
            try {
                final DataRuntime rt = runtime;
                final long[] mid = new long[]{System.currentTimeMillis()};
                final boolean[] process = new boolean[]{false};
                final LinkedHashMap metadatas = new LinkedHashMap();
                metadatas.putAll(columns);
                set.setMetadata(metadatas);
                JdbcTemplate jdbc = this.jdbc(runtime);
                if (null == jdbc) {
                    return set;
                }
                StreamHandler _handler = null;
                if (null != configs) {
                    _handler = configs.stream();
                }
                long[] count = new long[]{0L};
                StreamHandler handler = _handler;
                if (null != handler) {
                    jdbc.query(con -> {
                        PreparedStatement ps = con.prepareStatement(sql, 1003, 1007);
                        ps.setFetchSize(handler.size());
                        ps.setFetchDirection(1000);
                        if (null != values && values.size() > 0) {
                            int idx = 0;
                            for (Object value : values) {
                                ps.setObject(++idx, value);
                            }
                        }
                        return ps;
                    }, rs -> {
                        if (!process[0]) {
                            lArray[0] = System.currentTimeMillis();
                            blArray[0] = true;
                        }
                        this.stream(handler, rs, configs, system, runtime, metadatas);
                        lArray2[0] = count[0] + 1L;
                    });
                } else {
                    if (null != values && values.size() > 0) {
                        jdbc.query(sql, values.toArray(), new RowCallbackHandler(){

                            public void processRow(ResultSet rs) throws java.sql.SQLException {
                                if (!process[0]) {
                                    mid[0] = System.currentTimeMillis();
                                    process[0] = true;
                                }
                                DataRow row = DefaultJDBCAdapter.this.row(system, rt, metadatas, configs, rs);
                                set.add(row);
                            }
                        });
                    } else {
                        jdbc.query(sql, new RowCallbackHandler(){

                            public void processRow(ResultSet rs) throws java.sql.SQLException {
                                if (!process[0]) {
                                    mid[0] = System.currentTimeMillis();
                                    process[0] = true;
                                }
                                DataRow row = DefaultJDBCAdapter.this.row(system, rt, metadatas, configs, rs);
                                set.add(row);
                            }
                        });
                    }
                    count[0] = set.size();
                }
                if (!process[0]) {
                    mid[0] = System.currentTimeMillis();
                }
                if (metadatas.isEmpty() && this.IS_CHECK_EMPTY_SET_METADATA(configs)) {
                    metadatas.putAll(this.metadata(runtime, (RunPrepare)new DefaultTextPrepare(sql), false));
                }
                boolean slow = false;
                long SLOW_SQL_MILLIS = this.SLOW_SQL_MILLIS(configs);
                if (SLOW_SQL_MILLIS > 0L && this.IS_LOG_SLOW_SQL(configs)) {
                    slow = true;
                    if (mid[0] - fr > SLOW_SQL_MILLIS) {
                        log.warn("{}[slow cmd][action:select][\u6267\u884c\u8017\u65f6:{}ms]{}", new Object[]{random, mid[0] - fr, run.log(ACTION.DML.SELECT, this.IS_SQL_LOG_PLACEHOLDER(configs))});
                        if (null != this.dmListener) {
                            this.dmListener.slow(runtime, random, ACTION.DML.SELECT, null, sql, values, null, true, (Object)set, mid[0] - fr);
                        }
                    }
                }
                if (!slow && log.isInfoEnabled() && this.IS_LOG_SQL_TIME(configs)) {
                    log.info("{}[action:select][\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)(mid[0] - fr));
                    log.info("{}[action:select][\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, System.currentTimeMillis() - mid[0], count[0]});
                }
                set.setDatalink(runtime.datasource());
            }
            catch (Exception e) {
                if (this.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                    e.printStackTrace();
                }
                if (this.IS_LOG_SQL_WHEN_ERROR(configs)) {
                    log.error("{}[{}][action:select]{}", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), run.log(ACTION.DML.SELECT, this.IS_SQL_LOG_PLACEHOLDER(configs))});
                }
                if (!this.IS_THROW_SQL_QUERY_EXCEPTION(configs)) break block24;
                SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38:" + e.toString(), e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
        }
        return set;
    }

    protected long batch(JdbcTemplate jdbc, String sql, int batch, final int vol, final List<Object> values) {
        int size = values.size();
        final int line = size / vol;
        if (null == jdbc) {
            return line;
        }
        jdbc.batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws java.sql.SQLException {
                for (int p = 1; p <= vol; ++p) {
                    ps.setObject(p, values.get(vol * i + p - 1));
                }
            }

            public int getBatchSize() {
                return line;
            }
        });
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends BaseMetadata> void checkSchema(DataRuntime runtime, DataSource ds, T meta) {
        if (null == meta || null != meta.getCheckSchemaTime()) {
            return;
        }
        Connection con = null;
        try {
            if (null == meta.getCatalog() || null == meta.getSchema()) {
                con = DataSourceUtils.getConnection((DataSource)ds);
                this.checkSchema(runtime, con, meta);
            }
        }
        catch (Exception e) {
            log.warn("[check schema][fail:{}]", (Object)e.toString());
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
    }

    @Override
    public <T extends BaseMetadata> void checkSchema(DataRuntime runtime, Connection con, T meta) {
        if (null == meta) {
            return;
        }
        try {
            String catalog = null;
            String schema = null;
            if (null == meta.getCatalog()) {
                catalog = con.getCatalog();
            }
            if (null == meta.getSchema()) {
                schema = con.getSchema();
            }
            this.correctSchemaFromJDBC(meta, catalog, schema);
        }
        catch (Exception e) {
            // empty catch block
        }
        meta.setCheckSchemaTime(new Date());
    }

    public <T extends BaseMetadata> void checkSchema(DataRuntime runtime, T meta) {
        if (null != meta) {
            JdbcTemplate jdbc = this.jdbc(runtime);
            if (null == jdbc) {
                return;
            }
            this.checkSchema(runtime, jdbc.getDataSource(), meta);
        }
    }

    public <T extends Column> T column(Catalog catalog, Schema schema, Table table, String name, List<T> columns) {
        for (Column column : columns) {
            if (null == table || null == name) continue;
            String identity = BasicUtil.nvl((Object[])new Serializable[]{catalog, ""}) + "_" + BasicUtil.nvl((Object[])new Serializable[]{schema, ""}) + "_" + BasicUtil.nvl((Object[])new Serializable[]{table, ""}) + "_" + name;
            if (!(identity = MD5Util.crypto((String)identity.toUpperCase())).equals(column.getIdentity())) continue;
            return (T)column;
        }
        return null;
    }

    public <T extends Column> T column(T column, List<T> columns) {
        for (Column item : columns) {
            if (!item.getIdentity().equals(column.getIdentity())) continue;
            return (T)item;
        }
        return null;
    }

    protected Map<String, Integer> keys(ResultSet set) throws Exception {
        ResultSetMetaData rsmd = set.getMetaData();
        HashMap<String, Integer> keys = new HashMap<String, Integer>();
        if (null != rsmd) {
            for (int i = 1; i < rsmd.getColumnCount(); ++i) {
                String name = rsmd.getColumnLabel(i);
                if (null == name) {
                    name = rsmd.getColumnName(i);
                }
                keys.put(name.toUpperCase(), i);
            }
        }
        return keys;
    }

    public String insertHead(ConfigStore configs) {
        return "INSERT INTO ";
    }

    public String insertFoot(ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return "";
    }

    protected String insertValue(DataRuntime runtime, Run run, Object obj, boolean child, boolean placeholder, boolean alias, boolean scope, LinkedHashMap<String, Column> columns) {
        int batch = run.getBatch();
        StringBuilder builder = new StringBuilder();
        if (scope && batch <= 1) {
            builder.append("(");
        }
        int from = 1;
        if (obj instanceof DataRow) {
            from = 1;
        }
        run.setFrom(from);
        boolean first = true;
        for (Column column : columns.values()) {
            boolean place = placeholder;
            boolean src = false;
            String key = column.getName();
            if (!first && batch <= 1) {
                builder.append(",");
            }
            first = false;
            Object value = null;
            value = obj instanceof DataRow ? BeanUtil.getFieldValue((Object)obj, (String)key) : (obj instanceof Map ? ((Map)obj).get(key) : BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)));
            if (value != null) {
                if (value instanceof DriverAdapter.SQL_BUILD_IN_VALUE) {
                    place = false;
                } else if (value instanceof String) {
                    String str = (String)value;
                    if (BasicUtil.checkEl((String)str)) {
                        src = true;
                        place = false;
                        value = str.substring(2, str.length() - 1);
                        if (child && str.toUpperCase().contains(".NEXTVAL")) {
                            value = null;
                        }
                    } else if ("NULL".equals(str)) {
                        value = null;
                    }
                }
            }
            if (src) {
                builder.append(value);
            } else if (batch <= 1) {
                if (place) {
                    builder.append("?");
                    this.addRunValue(runtime, run, Compare.EQUAL, column, value);
                } else {
                    builder.append(this.write(runtime, null, value, false));
                }
            } else {
                this.addRunValue(runtime, run, Compare.EQUAL, column, value);
            }
            if (!alias || batch > 1) continue;
            builder.append(" AS ").append(key);
        }
        if (scope && batch <= 1) {
            builder.append(")");
        }
        return builder.toString();
    }

    public String getPrimayKey(Object obj) {
        String key = null;
        if (obj instanceof Collection) {
            obj = ((Collection)obj).iterator().next();
        }
        key = obj instanceof DataRow ? ((DataRow)obj).getPrimaryKey() : EntityAdapterProxy.primaryKey(obj.getClass(), (boolean)true);
        return key;
    }

    protected void replaceVariable(DataRuntime runtime, TextRun run) {
        StringBuilder builder = run.getBuilder();
        RunPrepare prepare = run.getPrepare();
        List variables = run.getVariables();
        String result = prepare.getText();
        if (null != variables) {
            List varValues;
            String value;
            List values;
            for (Variable var : variables) {
                if (null == var || var.getType() != 3) continue;
                values = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, (Object)values)) {
                    value = var.getCompare() == Compare.IN ? BeanUtil.concat((Collection)BeanUtil.wrap((Collection)values, (String)"'")) : values.get(0).toString();
                }
                if (null != value) {
                    result = result.replace(var.getFullKey(), value);
                    continue;
                }
                result = result.replace(var.getFullKey(), "NULL");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 2) continue;
                values = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, (Object)values)) {
                    value = var.getCompare() == Compare.IN ? BeanUtil.concat((Collection)BeanUtil.wrap((Collection)values, (String)"'")) : values.get(0).toString();
                }
                if (null != value) {
                    result = result.replace(var.getFullKey(), value);
                    continue;
                }
                result = result.replace(var.getFullKey(), "");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 1) continue;
                varValues = var.getValues();
                if (BasicUtil.isNotEmpty((boolean)true, (Object)varValues)) {
                    if (var.getCompare() == Compare.IN) {
                        String replaceDst = "";
                        for (Object tmp : varValues) {
                            replaceDst = replaceDst + " ?";
                        }
                        this.addRunValue(runtime, (Run)run, Compare.IN, new Column(var.getKey()), varValues);
                        replaceDst = replaceDst.trim().replace(" ", ",");
                        result = result.replace(var.getFullKey(), replaceDst);
                        continue;
                    }
                    result = result.replace(var.getFullKey(), "?");
                    this.addRunValue(runtime, (Run)run, Compare.EQUAL, new Column(var.getKey()), varValues.get(0));
                    continue;
                }
                result = result.replace(var.getFullKey(), "NULL");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 0) continue;
                varValues = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, (Object)varValues)) {
                    value = (String)varValues.get(0);
                }
                this.addRunValue(runtime, (Run)run, Compare.EQUAL, new Column(var.getKey()), value);
            }
        }
        builder.append(result);
    }

    public String concat(DataRuntime runtime, String ... args) {
        return null;
    }

    protected String dummy() {
        return "dual";
    }

    protected String pageLimit(DataRuntime runtime, Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumn();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            long limit = navi.getLastRow() - navi.getFirstRow() + 1L;
            if (limit < 0L) {
                limit = 0L;
            }
            sql = sql + " LIMIT " + navi.getFirstRow() + "," + limit;
        }
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    protected String pageLimitOffset(DataRuntime runtime, Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumn();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            long limit = navi.getLastRow() - navi.getFirstRow() + 1L;
            if (limit < 0L) {
                limit = 0L;
            }
            sql = sql + " LIMIT " + limit + " OFFSET " + navi.getFirstRow();
        }
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    protected String pageRowNum(DataRuntime runtime, Run run) {
        StringBuilder builder = new StringBuilder();
        String cols = run.getQueryColumn();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrderStore();
        long first = 0L;
        long last = 0L;
        String order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
            last = navi.getLastRow();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append(order);
        } else {
            builder.append("SELECT " + cols + " FROM( \n");
            builder.append("SELECT TAB_I.*,ROWNUM AS PAGE_ROW_NUMBER_ \n");
            builder.append("FROM( \n");
            builder.append(sql);
            builder.append("\n").append(order);
            builder.append(")  TAB_I \n");
            builder.append(")  TAB_O WHERE PAGE_ROW_NUMBER_ >= " + (first + 1L) + " AND PAGE_ROW_NUMBER_ <= " + (last + 1L));
        }
        return builder.toString();
    }

    protected String pageOffsetNext(DataRuntime runtime, Run run) {
        StringBuilder builder = new StringBuilder();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrderStore();
        long first = 0L;
        String order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append(order);
        } else {
            builder.append(sql).append("\n").append(order);
            builder.append(" OFFSET ").append(first).append(" ROWS FETCH NEXT ").append(navi.getPageRows()).append(" ROWS ONLY");
        }
        return builder.toString();
    }

    protected String pageSkip(DataRuntime runtime, Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumn();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            long limit = navi.getLastRow() - navi.getFirstRow() + 1L;
            if (limit < 0L) {
                limit = 0L;
            }
            String sub = sql.substring(sql.toUpperCase().indexOf("SELECT") + 6);
            sql = "SELECT SKIP " + navi.getFirstRow() + " FIRST " + limit + sub;
        }
        return sql;
    }

    protected String pageTop(DataRuntime runtime, Run run) {
        StringBuilder builder = new StringBuilder();
        String cols = run.getQueryColumn();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrderStore();
        long first = 0L;
        long last = 0L;
        String order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
            last = navi.getLastRow();
        }
        if (first == 0L && null != navi) {
            builder.append("SELECT TOP ").append(last + 1L).append(" " + cols + " FROM(\n");
            builder.append(sql).append("\n) AS _TAB_O \n");
            builder.append(order);
            return builder.toString();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append(order);
        } else {
            long rows = navi.getPageRows();
            if (rows * navi.getCurPage() > navi.getTotalRow()) {
                rows = navi.getTotalRow() % (long)navi.getPageRows();
            }
            String asc = order;
            String desc = order.replace("ASC", "<A_ORDER>");
            desc = desc.replace("DESC", "ASC");
            desc = desc.replace("<A_ORDER>", "DESC");
            builder.append("SELECT " + cols + " FROM (\n ");
            builder.append("SELECT TOP ").append(rows).append(" * FROM (\n");
            builder.append("SELECT TOP ").append((long)navi.getPageRows() * navi.getCurPage()).append(" * ");
            builder.append(" FROM (" + sql + ") AS T0 ").append(asc).append("\n");
            builder.append(") AS T1 ").append(desc).append("\n");
            builder.append(") AS T2").append(asc);
        }
        return builder.toString();
    }

    protected String pageRowNumber(DataRuntime runtime, Run run) {
        StringBuilder builder = new StringBuilder();
        String cols = run.getQueryColumn();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrderStore();
        long first = 0L;
        long last = 0L;
        String order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
            last = navi.getLastRow();
        }
        if (first == 0L && null != navi) {
            builder.append("SELECT TOP ").append(last + 1L).append(" " + cols + " FROM(\n");
            builder.append(sql).append("\n) AS _TAB_O \n");
            builder.append(order);
            return builder.toString();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append(order);
        } else {
            if (BasicUtil.isEmpty((Object)order)) {
                order = "ORDER BY " + ConfigTable.DEFAULT_PRIMARY_KEY;
            }
            builder.append("SELECT " + cols + " FROM( \n");
            builder.append("SELECT _TAB_I.*,ROW_NUMBER() OVER(").append(order).append(") AS PAGE_ROW_NUMBER_ \n");
            builder.append("FROM( \n");
            builder.append(sql);
            builder.append(") AS _TAB_I \n");
            builder.append(") AS _TAB_O WHERE PAGE_ROW_NUMBER_ BETWEEN " + (first + 1L) + " AND " + (last + 1L));
        }
        return builder.toString();
    }

    protected String concatFun(DataRuntime runtime, String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            result = "concat(";
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + ",";
                }
                result = result + arg;
            }
            result = result + ")";
        }
        return result;
    }

    protected String concatOr(DataRuntime runtime, String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + " || ";
                }
                result = result + arg;
            }
        }
        return result;
    }

    protected String concatAdd(DataRuntime runtime, String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + " + ";
                }
                result = result + arg;
            }
        }
        return result;
    }

    protected String concatAnd(DataRuntime runtime, String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + " & ";
                }
                result = result + arg;
            }
        }
        return result;
    }
}

