/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.runtime;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.dao.init.springjdbc.FixDao;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.runtime.JDBCRuntime;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.data.util.DriverAdapterHolder;
import org.anyline.proxy.RuntimeHolderProxy;
import org.anyline.service.init.FixService;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component(value="anyline.data.runtime.holder.jdbc")
public class JDBCRuntimeHolder
extends RuntimeHolder {
    private static Map<String, DataSource> temporary = new HashMap<String, DataSource>();

    public JDBCRuntimeHolder() {
        RuntimeHolderProxy.reg(DataSource.class, (RuntimeHolder)this);
        RuntimeHolderProxy.reg(JdbcTemplate.class, (RuntimeHolder)this);
    }

    public DataRuntime temporary(String key, Object datasource, String database, DriverAdapter adapter) throws Exception {
        JDBCRuntime runtime = new JDBCRuntime();
        if (!(datasource instanceof DataSource)) {
            throw new Exception("\u8bf7\u63d0\u4f9bjavax.sql.DataSource\u517c\u5bb9\u7c7b\u578b");
        }
        JDBCRuntimeHolder.close(key);
        temporary.remove(key);
        DriverAdapterHolder.remove((String)key);
        runtime.setKey(key);
        runtime.setAdapter(adapter);
        DataSource ds = (DataSource)datasource;
        JdbcTemplate template = new JdbcTemplate(ds);
        runtime.setProcessor(template);
        temporary.put(key, ds);
        log.warn("[\u521b\u5efa\u4e34\u65f6\u6570\u636e\u6e90][key:{}][type:{}]", (Object)key, (Object)datasource.getClass().getSimpleName());
        runtime.setHolder(this);
        return runtime;
    }

    public DataRuntime regTemporary(String key, Object datasource, String database, DriverAdapter adapter) throws Exception {
        return this.temporary(key, datasource, database, adapter);
    }

    public static void reg(String key, String ds) {
        String template_key = "anyline.jdbc.template." + key;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(JdbcTemplate.class);
        builder.addPropertyReference("dataSource", ds);
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        factory.registerBeanDefinition(template_key, (BeanDefinition)definition);
        JdbcTemplate template = (JdbcTemplate)factory.getBean(template_key, JdbcTemplate.class);
        JDBCRuntimeHolder.reg(key, template, null);
    }

    public static void reg(String key, DataRuntime runtime) {
        runtimes.put(key, runtime);
    }

    public static void reg(String key, DataSource ds) {
        String datasource_key = "anyline.datasource." + key;
        factory.registerSingleton(datasource_key, (Object)ds);
        String template_key = "anyline.jdbc.template." + key;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(JdbcTemplate.class);
        builder.addPropertyValue("dataSource", (Object)ds);
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        factory.registerBeanDefinition(template_key, (BeanDefinition)definition);
        JdbcTemplate template = (JdbcTemplate)factory.getBean(template_key, JdbcTemplate.class);
        JDBCRuntimeHolder.reg(key, template, null);
    }

    public static void reg(String datasource, JdbcTemplate template, JDBCAdapter adapter) {
        log.info("[create jdbc runtime][key:{}]", (Object)datasource);
        JDBCRuntime runtime = new JDBCRuntime(datasource, template, adapter);
        if (runtimes.containsKey(datasource)) {
            JDBCRuntimeHolder.destroy(datasource);
        }
        runtimes.put(datasource, runtime);
        if (!ConfigTable.IS_MULTIPLE_SERVICE) {
            return;
        }
        String dao_key = "anyline.dao." + datasource;
        String service_key = "anyline.service." + datasource;
        log.info("[instance service][data source:{}][instance id:{}]", (Object)datasource, (Object)service_key);
        BeanDefinitionBuilder daoBuilder = BeanDefinitionBuilder.genericBeanDefinition(FixDao.class);
        daoBuilder.addPropertyValue("runtime", (Object)runtime);
        daoBuilder.addPropertyValue("datasource", (Object)datasource);
        daoBuilder.setLazyInit(true);
        AbstractBeanDefinition daoDefinition = daoBuilder.getBeanDefinition();
        factory.registerBeanDefinition(dao_key, (BeanDefinition)daoDefinition);
        BeanDefinitionBuilder serviceBuilder = BeanDefinitionBuilder.genericBeanDefinition(FixService.class);
        serviceBuilder.addPropertyValue("datasource", (Object)datasource);
        serviceBuilder.addPropertyReference("dao", dao_key);
        serviceBuilder.setLazyInit(true);
        AbstractBeanDefinition serviceDefinition = serviceBuilder.getBeanDefinition();
        factory.registerBeanDefinition(service_key, (BeanDefinition)serviceDefinition);
    }

    public static void destroyRuntime(String key) {
        JDBCRuntimeHolder.destroy(key);
    }

    public static void destroy(String key) {
        try {
            runtimes.remove(key);
            JDBCRuntimeHolder.destroyBean((String)("anyline.service." + key));
            JDBCRuntimeHolder.destroyBean((String)("anyline.dao." + key));
            JDBCRuntimeHolder.destroyBean((String)("anyline.template." + key));
            JDBCRuntimeHolder.destroyBean((String)("anyline.transaction." + key));
            JDBCRuntimeHolder.close("anyline.datasource." + key);
            JDBCRuntimeHolder.destroyBean((String)("anyline.datasource." + key));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exeDestroy(String key) {
        JDBCRuntimeHolder.destroy(key);
    }

    public static void close(String ds) {
        Object datasource = null;
        if (factory.containsSingleton(ds)) {
            datasource = factory.getSingleton(ds);
            try {
                JDBCRuntimeHolder.closeConnection(datasource);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (temporary.containsKey(ds)) {
            try {
                JDBCRuntimeHolder.closeConnection(temporary.get(ds));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeConnection(Object ds) throws Exception {
        Method method = ClassUtil.getMethod(ds.getClass(), (String)"close", (Class[])new Class[0]);
        if (null != method) {
            method.invoke(ds, new Object[0]);
        }
    }

    public static JdbcTemplate getJdbcTemplate() {
        DataRuntime runtime = JDBCRuntimeHolder.getRuntime();
        if (null != runtime) {
            return (JdbcTemplate)runtime.getProcessor();
        }
        return null;
    }

    public static DataSource getDataSource() {
        DataRuntime runtime = JDBCRuntimeHolder.getRuntime();
        if (null != runtime) {
            JdbcTemplate jdbc = (JdbcTemplate)runtime.getProcessor();
            return jdbc.getDataSource();
        }
        return null;
    }

    public static JdbcTemplate getJdbcTemplate(String key) {
        DataRuntime runtime = JDBCRuntimeHolder.getRuntime((String)key);
        if (null != runtime) {
            return (JdbcTemplate)runtime.getProcessor();
        }
        return null;
    }

    public static DataSource getDataSource(String key) {
        DataRuntime runtime = JDBCRuntimeHolder.getRuntime((String)key);
        if (null != runtime) {
            JdbcTemplate jdbc = (JdbcTemplate)runtime.getProcessor();
            return jdbc.getDataSource();
        }
        return null;
    }
}

