/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.runtime;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.data.util.ClientHolder;
import org.anyline.data.util.DriverAdapterHolder;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class JDBCRuntime
implements DataRuntime {
    private String key;
    protected String feature;
    protected String version;
    protected DriverAdapter adapter;
    protected JdbcTemplate processor;
    protected RuntimeHolder holder;

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Object getProcessor() {
        return this.processor;
    }

    public void setProcessor(Object processor) {
        this.processor = (JdbcTemplate)processor;
    }

    public DriverAdapter getAdapter() {
        if (null == this.adapter) {
            String ds = this.key;
            if ("common".equals(ds)) {
                ds = ClientHolder.curDataSource();
            }
            this.adapter = DriverAdapterHolder.getAdapter((String)ds, (DataRuntime)this);
        }
        return this.adapter;
    }

    public String datasource() {
        String ds = this.key;
        if ("common".equals(ds)) {
            ds = ClientHolder.curDataSource();
        }
        return ds;
    }

    public void setAdapter(DriverAdapter adapter) {
        this.adapter = adapter;
    }

    public void setHolder(RuntimeHolder holder) {
        this.holder = holder;
    }

    public RuntimeHolder getHolder() {
        return this.holder;
    }

    public JDBCRuntime(String key, JdbcTemplate jdbc, DriverAdapter adapter) {
        this.setKey(key);
        this.setProcessor(jdbc);
        this.setAdapter(adapter);
    }

    public JDBCRuntime() {
    }

    public JdbcTemplate jdbc() {
        return this.processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFeature() {
        JdbcTemplate jdbc;
        if (null == this.feature && null != (jdbc = this.jdbc())) {
            DataSource ds = null;
            Connection con = null;
            try {
                ds = jdbc.getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                DatabaseMetaData meta = con.getMetaData();
                this.feature = meta.getDatabaseProductName().toLowerCase().replace(" ", "") + "_" + meta.getURL();
                if (null == this.version) {
                    this.version = meta.getDatabaseProductVersion();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                    DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
                }
            }
        }
        return this.feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        JdbcTemplate jdbc;
        if (null == this.version && null != (jdbc = this.jdbc())) {
            DataSource ds = null;
            Connection con = null;
            try {
                ds = jdbc.getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                DatabaseMetaData meta = con.getMetaData();
                this.version = meta.getDatabaseProductVersion();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                    DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
                }
            }
        }
        return this.version;
    }
}

