/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.ds;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.adapter.init.ConvertAdapter;
import org.anyline.data.jdbc.runtime.JDBCRuntimeHolder;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.ClientHolder;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.SpringContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class DataSourceHolder
extends ClientHolder {
    private static Logger log = LoggerFactory.getLogger(DataSourceHolder.class);
    private static Map<TransactionStatus, String> transactionStatus = new Hashtable<TransactionStatus, String>();
    public static final String DATASOURCE_TYPE_DEFAULT = "com.zaxxer.hikari.HikariDataSource";

    public static TransactionStatus startTransaction(String datasource, DefaultTransactionDefinition definition) {
        DataSourceTransactionManager dtm = null;
        if (BasicUtil.isEmpty((Object)datasource) || !ConfigTable.IS_OPEN_TRANSACTION_MANAGER) {
            dtm = (DataSourceTransactionManager)SpringContextUtil.getBean((String)"transactionManager");
            datasource = "";
        } else {
            dtm = (DataSourceTransactionManager)SpringContextUtil.getBean((String)("anyline.transaction." + datasource));
        }
        TransactionStatus status = dtm.getTransaction((TransactionDefinition)definition);
        transactionStatus.put(status, datasource);
        return status;
    }

    public static TransactionStatus startTransaction(String datasource, int behavior) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setPropagationBehavior(behavior);
        return DataSourceHolder.startTransaction(datasource, definition);
    }

    public static TransactionStatus startTransaction(String datasource) {
        return DataSourceHolder.startTransaction(datasource, 0);
    }

    public static TransactionStatus startTransaction(DefaultTransactionDefinition definition) {
        return DataSourceHolder.startTransaction(DataSourceHolder.curDataSource(), definition);
    }

    public static TransactionStatus startTransaction(int behavior) {
        return DataSourceHolder.startTransaction(DataSourceHolder.curDataSource(), behavior);
    }

    public static TransactionStatus startTransaction() {
        return DataSourceHolder.startTransaction(DataSourceHolder.curDataSource());
    }

    public static void commit(TransactionStatus status) {
        String datasource = transactionStatus.get(status);
        DataSourceTransactionManager dtm = null;
        dtm = BasicUtil.isEmpty((Object)datasource) || !ConfigTable.IS_OPEN_TRANSACTION_MANAGER ? (DataSourceTransactionManager)SpringContextUtil.getBean((String)"transactionManager") : (DataSourceTransactionManager)SpringContextUtil.getBean((String)("anyline.transaction." + datasource));
        dtm.commit(status);
        transactionStatus.remove(status);
    }

    public static void rollback(TransactionStatus status) {
        String datasource = transactionStatus.get(status);
        DataSourceTransactionManager dtm = null;
        dtm = BasicUtil.isEmpty((Object)datasource) || !ConfigTable.IS_OPEN_TRANSACTION_MANAGER ? (DataSourceTransactionManager)SpringContextUtil.getBean((String)"transactionManager") : (DataSourceTransactionManager)SpringContextUtil.getBean((String)("anyline.transaction." + datasource));
        dtm.rollback(status);
        transactionStatus.remove(status);
    }

    public static String regTransactionManager(String key, DataSource ds) {
        return DataSourceHolder.regTransactionManager(key, ds, false);
    }

    public static String regTransactionManager(String key, DataSource ds, boolean primary) {
        String tm_id = "anyline.transaction." + key;
        if (ConfigTable.IS_OPEN_TRANSACTION_MANAGER) {
            DefaultListableBeanFactory factory = (DefaultListableBeanFactory)SpringContextUtil.getApplicationContext().getAutowireCapableBeanFactory();
            BeanDefinitionBuilder tm_builder = BeanDefinitionBuilder.genericBeanDefinition(DataSourceTransactionManager.class);
            tm_builder.addPropertyValue("dataSource", (Object)ds);
            tm_builder.setPrimary(primary);
            AbstractBeanDefinition tm_definition = tm_builder.getBeanDefinition();
            factory.registerBeanDefinition(tm_id, (BeanDefinition)tm_definition);
            log.info("[\u521b\u5efa\u4e8b\u52a1\u63a7\u5236\u5668][\u6570\u636e\u6e90:{}][bean:{}]", (Object)key, (Object)tm_id);
        }
        return tm_id;
    }

    public static String regTransactionManager(String key, String ds) {
        return DataSourceHolder.regTransactionManager(key, ds, false);
    }

    public static String regTransactionManager(String key, String ds, boolean primary) {
        String tm_id = "anyline.transaction." + key;
        if (ConfigTable.IS_OPEN_TRANSACTION_MANAGER) {
            DefaultListableBeanFactory factory = (DefaultListableBeanFactory)SpringContextUtil.getApplicationContext().getAutowireCapableBeanFactory();
            BeanDefinitionBuilder tm_builder = BeanDefinitionBuilder.genericBeanDefinition(DataSourceTransactionManager.class);
            tm_builder.addPropertyReference("dataSource", ds);
            tm_builder.setPrimary(primary);
            AbstractBeanDefinition tm_definition = tm_builder.getBeanDefinition();
            factory.registerBeanDefinition(tm_id, (BeanDefinition)tm_definition);
            log.info("[\u521b\u5efa\u4e8b\u52a1\u63a7\u5236\u5668][\u6570\u636e\u6e90:{}][bean:{}]", (Object)key, (Object)tm_id);
        }
        return tm_id;
    }

    private static String addDataSource(String key, String ds) throws Exception {
        if (ConfigTable.IS_DEBUG && log.isInfoEnabled()) {
            log.info("[\u521b\u5efa\u6570\u636e\u6e90][thread:{}][key:{}]", (Object)Thread.currentThread().getId(), (Object)key);
        }
        DataSourceHolder.regTransactionManager(key, ds);
        DataSourceHolder.reg((String)key);
        JDBCRuntimeHolder.reg(key, ds);
        return ds;
    }

    public static void destroy(String key) {
        JDBCRuntimeHolder.destroy(key);
    }

    private static DataSource addDataSource(String key, DataSource ds, boolean over) throws Exception {
        if (dataSources.contains(key)) {
            if (!over) {
                throw new Exception("[\u91cd\u590d\u6ce8\u518c][thread:" + Thread.currentThread().getId() + "][key:" + key + "]");
            }
            JDBCRuntimeHolder.destroy(key);
        }
        if (ConfigTable.IS_DEBUG && log.isInfoEnabled()) {
            log.info("[\u521b\u5efa\u6570\u636e\u6e90][thread:{}][key:{}]", (Object)Thread.currentThread().getId(), (Object)key);
        }
        DataSourceHolder.regTransactionManager(key, ds);
        DataSourceHolder.reg((String)key);
        JDBCRuntimeHolder.reg(key, ds);
        return ds;
    }

    public static String reg(String key, String pool, String driver, String url, String user, String password) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("type", pool);
        param.put("driver", driver);
        param.put("url", url);
        param.put("user", user);
        param.put("password", password);
        return DataSourceHolder.reg(key, param);
    }

    public static String reg(String key, DatabaseType type, String url, String user, String password) throws Exception {
        return DataSourceHolder.reg(key, "om.zaxxer.hikari.HikariDataSource", type.driver(), url, user, password);
    }

    public static String reg(String key, Map param, boolean over) throws Exception {
        return DataSourceHolder.addDataSource(key, DataSourceHolder.reg(key, param, over));
    }

    public static String reg(String key, Map param) throws Exception {
        String ds = DataSourceHolder.build(key, param, true);
        if (null == ds) {
            return null;
        }
        return DataSourceHolder.addDataSource(key, ds);
    }

    public static DataSource reg(String key, DataSource ds, boolean over) throws Exception {
        return DataSourceHolder.addDataSource(key, ds, over);
    }

    public static DataSource reg(String key, DataSource ds) throws Exception {
        return DataSourceHolder.addDataSource(key, ds, true);
    }

    public static DataSource getDataSource() {
        return JDBCRuntimeHolder.getDataSource();
    }

    public static DataSource getDataSource(String key) {
        return JDBCRuntimeHolder.getDataSource(key);
    }

    public static String reg(String key, String prefix, Environment env) {
        try {
            String url;
            String type;
            if (BasicUtil.isNotEmpty((Object)prefix) && !prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            if (null == (type = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"type"}))) {
                type = BeanUtil.value((String)"spring.datasource.", (Environment)env, (String[])new String[]{"type"});
            }
            if (type == null) {
                type = DATASOURCE_TYPE_DEFAULT;
            }
            if (BasicUtil.isEmpty((Object)(url = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"url", "jdbc-url"})))) {
                return null;
            }
            if (!url.startsWith("jdbc:")) {
                return null;
            }
            if (BasicUtil.isEmpty((Object)url)) {
                return null;
            }
            String driverClassName = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"driver", "driver-class", "driver-class-name"});
            String username = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"user", "username", "user-name"});
            String password = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"password"});
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("url", url);
            map.put("jdbcUrl", url);
            map.put("driver", driverClassName);
            map.put("driverClass", driverClassName);
            map.put("driverClassName", driverClassName);
            map.put("user", username);
            map.put("username", username);
            map.put("password", password);
            String ds = DataSourceHolder.build(key, map, true);
            if (null == ds) {
                return null;
            }
            DataSourceHolder.addDataSource(key, ds);
            return ds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String build(String key, Map params, boolean over) throws Exception {
        if (dataSources.contains(key)) {
            if (!over) {
                throw new Exception("[\u91cd\u590d\u6ce8\u518c][thread:" + Thread.currentThread().getId() + "][key:" + key + "]");
            }
            JDBCRuntimeHolder.destroy(key);
        }
        String ds_id = "anyline.datasource." + key;
        try {
            String url = (String)BeanUtil.propertyNvl((Map)params, (String[])new String[]{"url", "jdbc-url"});
            if (BasicUtil.isEmpty((Object)url)) {
                return null;
            }
            if (!url.toLowerCase().startsWith("jdbc:")) {
                return null;
            }
            String type = (String)params.get("pool");
            if (BasicUtil.isEmpty((Object)type)) {
                type = (String)params.get("type");
            }
            if (type == null) {
                type = DATASOURCE_TYPE_DEFAULT;
            }
            Class<?> poolClass = Class.forName(type);
            Object driver = BeanUtil.propertyNvl((Map)params, (String[])new String[]{"driver", "driver-class", "driver-class-name"});
            if (driver instanceof String) {
                Class<?> calzz = Class.forName(driver.toString());
                if (type.contains("druid")) {
                    driver = calzz.newInstance();
                }
            }
            Object user = BeanUtil.propertyNvl((Map)params, (String[])new String[]{"user", "username"});
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.putAll(params);
            map.put("url", url);
            if (!type.contains("druid")) {
                map.put("jdbcUrl", url);
            }
            map.put("driver", driver);
            if (driver instanceof String) {
                map.put("driverClass", driver);
                map.put("driverClassName", driver);
            }
            map.put("user", user);
            map.put("username", user);
            DefaultListableBeanFactory factory = (DefaultListableBeanFactory)SpringContextUtil.getApplicationContext().getAutowireCapableBeanFactory();
            BeanDefinitionBuilder ds_builder = BeanDefinitionBuilder.genericBeanDefinition(poolClass);
            List fields = ClassUtil.getFields(poolClass, (boolean)false, (boolean)false);
            for (Field field : fields) {
                String name = field.getName();
                Object value = map.get(name);
                if (null == (value = ConvertAdapter.convert(value, field.getType(), (boolean)false))) continue;
                ds_builder.addPropertyValue(name, value);
            }
            if (type.contains("druid")) {
                ds_builder.addPropertyValue("url", (Object)url);
            }
            AbstractBeanDefinition ds_definition = ds_builder.getBeanDefinition();
            factory.registerBeanDefinition(ds_id, (BeanDefinition)ds_definition);
        }
        catch (Exception e) {
            log.error("[\u6ce8\u518c\u6570\u636e\u6e90\u5931\u8d25][\u6570\u636e\u6e90:{}][msg:{}]", (Object)key, (Object)e.toString());
            return null;
        }
        return ds_id;
    }

    public static boolean validate(String ds) {
        return DataSourceHolder.validate(JDBCRuntimeHolder.getRuntime((String)ds));
    }

    public static boolean validate() {
        return DataSourceHolder.validate(JDBCRuntimeHolder.getRuntime());
    }

    public static boolean validate(DataRuntime runtime) {
        JdbcTemplate jdbc = (JdbcTemplate)runtime.getProcessor();
        return DataSourceHolder.validate(jdbc);
    }

    public static boolean validate(JdbcTemplate jdbc) {
        try {
            DataSource ds = jdbc.getDataSource();
            Connection con = ds.getConnection();
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

