/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.adapter.init;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.adapter.init.DefaultJDBCAdapter;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.TableRun;
import org.anyline.data.run.TextRun;
import org.anyline.data.run.XMLRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.Join;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.exception.SQLException;
import org.anyline.exception.SQLUpdateException;
import org.anyline.metadata.Column;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.proxy.ServiceProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.LogUtil;
import org.anyline.util.SQLUtil;
import org.springframework.jdbc.support.KeyHolder;

public abstract class SQLAdapter
extends DefaultJDBCAdapter
implements JDBCAdapter {
    public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        return super.buildInsertRun(runtime, batch, dest, obj, configs, checkPrimary, columns);
    }

    public String insertHead(Boolean override) {
        return "INSERT INTO ";
    }

    public void fillInsertContent(DataRuntime runtime, Run run, String dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        StringBuilder builder = run.getBuilder();
        int batch = run.getBatch();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        LinkedHashMap pks = null;
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""));
        if (null != generator) {
            pks = set.getRow(0).getPrimaryColumns();
            columns.putAll(pks);
        }
        Boolean override = null;
        if (null != configs) {
            override = configs.override();
        }
        String head = this.insertHead(override);
        builder.append(head).append(this.parseTable(dest));
        builder.append("(");
        boolean first = true;
        for (Column column : columns.values()) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            String key = column.getName();
            SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        }
        builder.append(") VALUES ");
        if (batch > 1) {
            builder.append("(");
            int size = columns.size();
            run.setVol(size);
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append("?");
            }
            builder.append(")");
        }
        int dataSize = set.size();
        for (int i = 0; i < dataSize; ++i) {
            DataRow row = set.getRow(i);
            if (null == row) continue;
            if (row.hasPrimaryKeys() && BasicUtil.isEmpty((Object)row.getPrimaryValue()) && null != generator) {
                generator.create((Object)row, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), BeanUtil.getMapKeys((Map)pks), null);
            }
            this.insertValue(runtime, run, row, true, false, true, columns);
            if (batch > 1 || i >= dataSize - 1) continue;
            builder.append(this.batchInsertSeparator());
        }
    }

    public void fillInsertContent(DataRuntime runtime, Run run, String dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        StringBuilder builder = run.getBuilder();
        int batch = run.getBatch();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            this.fillInsertContent(runtime, run, dest, set, columns);
            return;
        }
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""));
        Object entity = list.iterator().next();
        List pks = null;
        if (null != generator) {
            columns.putAll(EntityAdapterProxy.primaryKeys(entity.getClass()));
        }
        Boolean override = null;
        if (null != configs) {
            override = configs.override();
        }
        String head = this.insertHead(override);
        builder.append(head).append(this.parseTable(dest));
        builder.append("(");
        boolean first = true;
        for (Column column : columns.values()) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        }
        builder.append(") VALUES ");
        int dataSize = list.size();
        int idx = 0;
        if (batch > 1) {
            builder.append("(");
            int size = columns.size();
            run.setVol(size);
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append("?");
            }
            builder.append(")");
        }
        for (Object obj : list) {
            boolean create = EntityAdapterProxy.createPrimaryValue(obj, (List)BeanUtil.getMapKeys(columns));
            if (!create && null != generator) {
                generator.create(obj, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pks, null);
            }
            this.insertValue(runtime, run, obj, true, false, true, columns);
            if (idx < dataSize - 1 && batch <= 1) {
                builder.append(this.batchInsertSeparator());
            }
            ++idx;
        }
    }

    protected Run createInsertRun(DataRuntime runtime, String dest, Object obj, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        TableRun run = new TableRun(runtime, dest);
        StringBuilder builder = new StringBuilder();
        if (BasicUtil.isEmpty((Object)dest)) {
            throw new SQLException("\u672a\u6307\u5b9a\u8868");
        }
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""));
        int from = 1;
        StringBuilder valuesBuilder = new StringBuilder();
        DataRow row = null;
        if (obj instanceof Map && !(obj instanceof DataRow)) {
            obj = new DataRow((Map)obj);
        }
        if (obj instanceof DataRow) {
            row = (DataRow)obj;
            if (row.hasPrimaryKeys() && null != generator) {
                generator.create((Object)row, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), row.getPrimaryKeys(), null);
            }
        } else {
            from = 2;
            boolean create = EntityAdapterProxy.createPrimaryValue((Object)obj, columns);
            LinkedHashMap pks = EntityAdapterProxy.primaryKeys(obj.getClass());
            if (!create && null != generator) {
                generator.create(obj, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pks, null);
            }
        }
        run.setFrom(from);
        LinkedHashMap cols = this.confirmInsertColumns(runtime, dest, obj, configs, columns, false);
        if (null == cols || cols.size() == 0) {
            throw new SQLException("\u672a\u6307\u5b9a\u5217(DataRow\u6216Entity\u4e2d\u6ca1\u6709\u9700\u8981\u63d2\u5165\u7684\u5c5e\u6027\u503c)[" + obj.getClass().getName() + ":" + BeanUtil.object2json((Object)obj) + "]");
        }
        boolean replaceEmptyNull = false;
        if (obj instanceof DataRow) {
            row = (DataRow)obj;
            replaceEmptyNull = row.isReplaceEmptyNull();
        } else {
            replaceEmptyNull = this.IS_REPLACE_EMPTY_NULL(configs);
        }
        Boolean override = null;
        if (null != configs) {
            override = configs.override();
        }
        String head = this.insertHead(override);
        builder.append(head).append(this.parseTable(dest));
        builder.append("(");
        valuesBuilder.append(") VALUES (");
        ArrayList<String> insertColumns = new ArrayList<String>();
        boolean first = true;
        for (Column column : cols.values()) {
            if (!first) {
                builder.append(",");
                valuesBuilder.append(",");
            }
            first = false;
            String key = column.getName();
            Object value = null;
            value = !(obj instanceof Map) && EntityAdapterProxy.hasAdapter(obj.getClass()) ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key);
            String str = null;
            if (value instanceof String) {
                str = (String)value;
            }
            SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            if (null != str && str.startsWith("${") && str.endsWith("}")) {
                value = str.substring(2, str.length() - 1);
                valuesBuilder.append(value);
                continue;
            }
            if (null != value && value instanceof DriverAdapter.SQL_BUILD_IN_VALUE) {
                value = this.value(runtime, null, (DriverAdapter.SQL_BUILD_IN_VALUE)value);
                valuesBuilder.append(value);
                continue;
            }
            insertColumns.add(key);
            if (this.supportInsertPlaceholder()) {
                valuesBuilder.append("?");
                if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && replaceEmptyNull) {
                    value = null;
                }
                this.addRunValue(runtime, (Run)run, Compare.EQUAL, column, value);
                continue;
            }
            valuesBuilder.append(this.write(runtime, null, value, false));
        }
        valuesBuilder.append(")");
        builder.append((CharSequence)valuesBuilder);
        run.setBuilder(builder);
        run.setInsertColumns(insertColumns);
        return run;
    }

    protected Run createInsertRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setBatch(batch);
        if (null == list || list.isEmpty()) {
            throw new SQLException("\u7a7a\u6570\u636e");
        }
        DataRow first = null;
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            first = set.getRow(0);
            if (BasicUtil.isEmpty((Object)dest)) {
                dest = DataSourceUtil.parseDataSource((String)dest, (Object)set);
            }
            if (BasicUtil.isEmpty((Object)dest)) {
                dest = DataSourceUtil.parseDataSource((String)dest, (Object)first);
            }
        } else {
            first = (DataRow)list.iterator().next();
            if (BasicUtil.isEmpty((Object)dest)) {
                dest = EntityAdapterProxy.table(first.getClass(), (boolean)true);
            }
        }
        if (BasicUtil.isEmpty((Object)dest)) {
            throw new SQLException("\u672a\u6307\u5b9a\u8868");
        }
        LinkedHashMap cols = this.confirmInsertColumns(runtime, dest, first, configs, columns, true);
        if (null == cols || cols.size() == 0) {
            throw new SQLException("\u672a\u6307\u5b9a\u5217(DataRow\u6216Entity\u4e2d\u6ca1\u6709\u9700\u8981\u63d2\u5165\u7684\u5c5e\u6027\u503c)[" + first.getClass().getName() + ":" + BeanUtil.object2json((Object)first) + "]");
        }
        run.setInsertColumns(cols);
        run.setVol(cols.size());
        this.fillInsertContent(runtime, (Run)run, dest, list, configs, (LinkedHashMap<String, Column>)cols);
        return run;
    }

    protected void insertValue(DataRuntime runtime, Run run, Object obj, boolean placeholder, boolean alias, boolean scope, LinkedHashMap<String, Column> columns) {
        int batch = run.getBatch();
        StringBuilder builder = run.getBuilder();
        if (scope && batch <= 1) {
            builder.append("(");
        }
        int from = 1;
        if (obj instanceof DataRow) {
            from = 1;
        }
        run.setFrom(from);
        boolean first = true;
        for (Column column : columns.values()) {
            boolean place = placeholder;
            String key = column.getName();
            if (!first && batch <= 1) {
                builder.append(",");
            }
            first = false;
            Object value = null;
            value = obj instanceof DataRow ? BeanUtil.getFieldValue((Object)obj, (String)key) : (obj instanceof Map ? ((Map)obj).get(key) : BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)));
            if (value != null) {
                if (value instanceof DriverAdapter.SQL_BUILD_IN_VALUE) {
                    place = false;
                } else if (value instanceof String) {
                    String str = (String)value;
                    if (str.startsWith("${") && str.endsWith("}")) {
                        place = false;
                    } else if ("NULL".equals(str)) {
                        value = null;
                    }
                }
            }
            if (batch <= 1) {
                if (place) {
                    builder.append("?");
                    this.addRunValue(runtime, run, Compare.EQUAL, column, value);
                } else {
                    builder.append(this.write(runtime, null, obj, false));
                }
            } else {
                this.addRunValue(runtime, run, Compare.EQUAL, column, value);
            }
            if (!alias || batch > 1) continue;
            builder.append(" AS ").append(key);
        }
        if (scope && batch <= 1) {
            builder.append(")");
        }
    }

    public String getPrimayKey(Object obj) {
        String key = null;
        if (obj instanceof Collection) {
            obj = ((Collection)obj).iterator().next();
        }
        key = obj instanceof DataRow ? ((DataRow)obj).getPrimaryKey() : EntityAdapterProxy.primaryKey(obj.getClass(), (boolean)true);
        return key;
    }

    @Override
    public boolean identity(DataRuntime runtime, String random, Object data, ConfigStore configs, KeyHolder keyholder) {
        block18: {
            try {
                if (null == keyholder) {
                    return false;
                }
                if (!this.IS_KEYHOLDER_IDENTITY(configs)) {
                    return false;
                }
                List keys = keyholder.getKeyList();
                String id_key = this.generatedKey();
                if (null == id_key && keys.size() > 0) {
                    Map key = (Map)keys.get(0);
                    id_key = (String)key.keySet().iterator().next();
                }
                if (data instanceof Collection) {
                    Long num;
                    Object last;
                    Object item;
                    ArrayList ids = new ArrayList();
                    Collection list = (Collection)data;
                    Iterator iterator = list.iterator();
                    if (iterator.hasNext() && BasicUtil.isNotEmpty((boolean)true, (Object)this.getPrimaryValue(runtime, item = iterator.next()))) {
                        return true;
                    }
                    if (BasicUtil.isEmpty((Object)id_key)) {
                        return false;
                    }
                    int i = 0;
                    int data_size = list.size();
                    if (list.size() == keys.size()) {
                        for (Object item2 : list) {
                            Map key = (Map)keys.get(i);
                            Object id = key.get(id_key);
                            ids.add(id);
                            this.setPrimaryValue(item2, id);
                            ++i;
                        }
                    } else if (null != keys && keys.size() > 0 && (last = ((Map)keys.get(0)).get(id_key)) instanceof Number && null != (num = BasicUtil.parseLong((Object)last.toString(), null))) {
                        num = num - (long)data_size + 1L;
                        for (Object item3 : list) {
                            Long l = num;
                            Long l2 = num = Long.valueOf(num + 1L);
                            this.setPrimaryValue(item3, l);
                        }
                    }
                    if (this.IS_LOG_SQL(configs) && log.isWarnEnabled()) {
                        log.warn("{}[exe insert][\u751f\u6210\u4e3b\u952e:{}]", (Object)random, ids);
                    }
                    break block18;
                }
                if (null != keys && keys.size() > 0 && BasicUtil.isEmpty((boolean)true, (Object)this.getPrimaryValue(runtime, data))) {
                    Object id = ((Map)keys.get(0)).get(id_key);
                    this.setPrimaryValue(data, id);
                    if (this.IS_LOG_SQL(configs) && log.isWarnEnabled()) {
                        log.warn("{}[exe insert][\u751f\u6210\u4e3b\u952e:{}]", (Object)random, id);
                    }
                }
            }
            catch (Exception e) {
                if (this.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                    e.printStackTrace();
                }
                if (this.IS_LOG_SQL_WHEN_ERROR(configs)) {
                    log.warn("{}[exe insert][\u8fd4\u56de\u4e3b\u952e\u5931\u8d25]", (Object)random);
                }
                return false;
            }
        }
        return true;
    }

    protected boolean isMultipleValue(TableRun run, String key) {
        LinkedHashMap columns;
        String table = run.getTable();
        if (null != table && null != (columns = ServiceProxy.metadata().columns(table))) {
            Column column = (Column)columns.get(key.toUpperCase());
            return this.isMultipleValue(column);
        }
        return false;
    }

    protected boolean isMultipleValue(Column column) {
        String type;
        return null != column && ((type = column.getTypeName().toUpperCase()).contains("POINT") || type.contains("GEOMETRY") || type.contains("POLYGON"));
    }

    public Run buildUpdateRunFromEntity(DataRuntime runtime, String dest, Object obj, ConfigStore configs, boolean checkPrimary, LinkedHashMap<String, Column> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setFrom(2);
        StringBuilder builder = run.getBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (Column column : columns.values()) {
            list.add(column.getName());
        }
        LinkedHashMap cols = this.confirmUpdateColumns(runtime, dest, obj, configs, list);
        ArrayList<Object> primaryKeys = new ArrayList<Object>();
        if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
            primaryKeys.addAll(EntityAdapterProxy.primaryKeys(obj.getClass()).keySet());
        } else {
            primaryKeys = new ArrayList();
            primaryKeys.add(DataRow.DEFAULT_PRIMARY_KEY);
        }
        for (String string : primaryKeys) {
            if (columns.containsKey(string.toUpperCase())) continue;
            cols.remove(string.toUpperCase());
        }
        if (!columns.containsKey(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase())) {
            cols.remove(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase());
        }
        boolean isReplaceEmptyNull = this.IS_REPLACE_EMPTY_NULL(configs);
        cols = this.checkMetadata(runtime, dest, configs, cols);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!cols.isEmpty()) {
            builder.append("UPDATE ").append(this.parseTable(dest));
            builder.append(" SET").append("\n\t");
            boolean first = true;
            for (Column column : cols.values()) {
                String key = column.getName();
                Object value = null;
                if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                    Field field = EntityAdapterProxy.field(obj.getClass(), (String)key);
                    value = BeanUtil.getFieldValue((Object)obj, (Field)field);
                } else {
                    value = BeanUtil.getFieldValue((Object)obj, (String)key);
                }
                if (null != value && value.toString().startsWith("${") && value.toString().endsWith("}")) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                    if (!first) {
                        builder.append(",");
                    }
                    SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ").append(value).append("\n\t");
                    first = false;
                    continue;
                }
                if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && isReplaceEmptyNull) {
                    value = null;
                }
                boolean chk = true;
                if ("".equals(value) && !this.IS_UPDATE_EMPTY_FIELD(configs)) {
                    chk = false;
                }
                if (!chk) continue;
                if (!first) {
                    builder.append(",");
                }
                first = false;
                SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ?").append("\n\t");
                arrayList.add(key);
                Compare compare = Compare.EQUAL;
                if (this.isMultipleValue(run, key)) {
                    compare = Compare.IN;
                }
                this.addRunValue(runtime, (Run)run, compare, column, value);
            }
            builder.append("\n");
            builder.append("\nWHERE 1=1").append("\n\t");
            if (null == configs) {
                configs = new DefaultConfigStore(new String[0]);
            }
            for (String string : primaryKeys) {
                if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                    Field field = EntityAdapterProxy.field(obj.getClass(), (String)string);
                    configs.and(string, BeanUtil.getFieldValue((Object)obj, (Field)field));
                    continue;
                }
                configs.and(string, BeanUtil.getFieldValue((Object)obj, (String)string));
            }
            run.setConfigStore(configs);
            run.init();
            run.appendCondition();
        }
        run.setUpdateColumns(arrayList);
        return run;
    }

    public Run buildUpdateRunFromDataRow(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, boolean checkPrimary, LinkedHashMap<String, Column> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setFrom(1);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap cols = this.confirmUpdateColumns(runtime, dest, row, configs, BeanUtil.getMapKeys(columns));
        List primaryKeys = row.getPrimaryKeys();
        if (primaryKeys.size() == 0) {
            throw new SQLUpdateException("[\u66f4\u65b0\u66f4\u65b0\u5f02\u5e38][\u66f4\u65b0\u6761\u4ef6\u4e3a\u7a7a,update\u65b9\u6cd5\u4e0d\u652f\u6301\u66f4\u65b0\u6574\u8868\u64cd\u4f5c]");
        }
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        for (String pk : primaryKeys) {
            Object pv = row.get(pk);
            pv = this.convert(runtime, (Column)cols.get(pk.toUpperCase()), pv);
            configs.and(pk, pv);
        }
        for (String pk : primaryKeys) {
            if (columns.containsKey(pk.toUpperCase())) continue;
            cols.remove(pk.toUpperCase());
        }
        if (!columns.containsKey(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase())) {
            cols.remove(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase());
        }
        boolean replaceEmptyNull = row.isReplaceEmptyNull();
        ArrayList<String> updateColumns = new ArrayList<String>();
        if (!cols.isEmpty()) {
            builder.append("UPDATE ").append(this.parseTable(dest));
            builder.append(" SET").append("\n\t");
            boolean first = true;
            for (Column col : cols.values()) {
                String key = col.getName();
                Object value = row.get(key);
                if (!first) {
                    builder.append(",");
                }
                first = false;
                if (null != value && value.toString().startsWith("${") && value.toString().endsWith("}")) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                    SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ").append(value).append("\n\t");
                    continue;
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ?").append("\n\t");
                if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && replaceEmptyNull) {
                    value = null;
                }
                updateColumns.add(key);
                Compare compare = Compare.EQUAL;
                this.addRunValue(runtime, (Run)run, compare, col, value);
            }
            builder.append("\n");
            builder.append("\nWHERE 1=1").append("\n\t");
            run.setConfigStore(configs);
            run.init();
            run.appendCondition();
        }
        run.setUpdateColumns(updateColumns);
        return run;
    }

    public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, boolean checkPrimary, LinkedHashMap<String, Column> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setFrom(1);
        Object first = list.iterator().next();
        if (null == first) {
            return run;
        }
        if (first instanceof Map && !(first instanceof DataRow)) {
            first = new DataRow((Map)first);
        }
        LinkedHashMap cols = new LinkedHashMap();
        List<Object> primaryKeys = new ArrayList();
        boolean replaceEmptyNull = false;
        if (first instanceof DataRow) {
            DataRow row = (DataRow)first;
            primaryKeys = row.getPrimaryKeys();
            cols = this.confirmUpdateColumns(runtime, dest, row, configs, BeanUtil.getMapKeys(columns));
            replaceEmptyNull = row.isReplaceEmptyNull();
        } else {
            ArrayList<String> ll = new ArrayList<String>();
            for (Column column : columns.values()) {
                ll.add(column.getName());
            }
            cols = this.confirmUpdateColumns(runtime, dest, first, configs, ll);
            if (EntityAdapterProxy.hasAdapter(first.getClass())) {
                primaryKeys.addAll(EntityAdapterProxy.primaryKeys(first.getClass()).keySet());
            } else {
                primaryKeys = new ArrayList();
                primaryKeys.add(DataRow.DEFAULT_PRIMARY_KEY);
            }
            replaceEmptyNull = this.IS_REPLACE_EMPTY_NULL(configs);
        }
        cols = this.checkMetadata(runtime, dest, configs, cols);
        StringBuilder builder = run.getBuilder();
        if (primaryKeys.size() == 0) {
            throw new SQLUpdateException("[\u66f4\u65b0\u66f4\u65b0\u5f02\u5e38][\u66f4\u65b0\u6761\u4ef6\u4e3a\u7a7a,update\u65b9\u6cd5\u4e0d\u652f\u6301\u66f4\u65b0\u6574\u8868\u64cd\u4f5c]");
        }
        for (String string : primaryKeys) {
            if (columns.containsKey(string.toUpperCase())) continue;
            cols.remove(string.toUpperCase());
        }
        if (!columns.containsKey(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase())) {
            cols.remove(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase());
        }
        ArrayList updateColumns = new ArrayList();
        if (!cols.isEmpty()) {
            builder.append("UPDATE ").append(this.parseTable(dest));
            builder.append(" SET ");
            boolean bl = true;
            for (Column column : cols.values()) {
                boolean bl2;
                String key = column.getName();
                if (!bl2) {
                    builder.append(", ");
                }
                bl2 = false;
                builder.append(key);
                builder.append(" = ?");
            }
            if (null == configs) {
                configs = new DefaultConfigStore(new String[0]);
            }
            boolean bl3 = true;
            for (String string : primaryKeys) {
                boolean bl4;
                if (bl4) {
                    builder.append(" WHERE ");
                } else {
                    builder.append(" AND ");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)string, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ?");
                bl4 = false;
            }
        }
        run.setUpdateColumns(updateColumns);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object e : list) {
            for (Column col : cols.values()) {
                String key = col.getName();
                Object value = BeanUtil.getFieldValue(e, (String)key);
                if (null != value && value.toString().startsWith("${") && value.toString().endsWith("}")) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                } else if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && replaceEmptyNull) {
                    value = null;
                }
                arrayList.add(value);
                for (String string : primaryKeys) {
                    arrayList.add(BeanUtil.getFieldValue(e, (String)string));
                }
            }
        }
        run.setBatch(batch);
        run.setVol(cols.size() + primaryKeys.size());
        run.setValues(arrayList);
        return run;
    }

    public Object createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value) {
        int code = compare.getCode();
        if (code > 100) {
            builder.append(" NOT");
            code -= 100;
        }
        if (code == 50) {
            builder.append(" LIKE ").append(this.concat(runtime, new String[]{"'%'", "?", "'%'"}));
        } else if (code == 51) {
            builder.append(" LIKE ").append(this.concat(runtime, new String[]{"?", "'%'"}));
        } else if (code == 52) {
            builder.append(" LIKE ").append(this.concat(runtime, new String[]{"'%'", "?"}));
        }
        return value;
    }

    public Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value) {
        log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value)"), (int)37));
        return null;
    }

    public StringBuilder createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value) {
        if (compare == Compare.NOT_IN) {
            builder.append(" NOT");
        }
        builder.append(" IN (");
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                builder.append("?");
                if (i >= size - 1) continue;
                builder.append(",");
            }
            builder.append(")");
        } else {
            builder.append("= ?");
        }
        return builder;
    }

    protected void fillQueryContent(DataRuntime runtime, XMLRun run) {
    }

    protected void fillQueryContent(DataRuntime runtime, TextRun run) {
        this.replaceVariable(runtime, run);
        run.appendCondition();
        run.appendGroup();
        run.checkValid();
    }

    protected void replaceVariable(DataRuntime runtime, TextRun run) {
        StringBuilder builder = run.getBuilder();
        RunPrepare prepare = run.getPrepare();
        List variables = run.getVariables();
        String result = prepare.getText();
        if (null != variables) {
            List varValues;
            String value;
            List values;
            for (Variable var : variables) {
                if (null == var || var.getType() != 3) continue;
                values = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, (Object)values)) {
                    value = var.getCompare() == Compare.IN ? BeanUtil.concat((Collection)BeanUtil.wrap((Collection)values, (String)"'")) : values.get(0).toString();
                }
                if (null != value) {
                    result = result.replace(var.getFullKey(), value);
                    continue;
                }
                result = result.replace(var.getFullKey(), "NULL");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 2) continue;
                values = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, (Object)values)) {
                    value = var.getCompare() == Compare.IN ? BeanUtil.concat((Collection)BeanUtil.wrap((Collection)values, (String)"'")) : values.get(0).toString();
                }
                if (null != value) {
                    result = result.replace(var.getFullKey(), value);
                    continue;
                }
                result = result.replace(var.getFullKey(), "");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 1) continue;
                varValues = var.getValues();
                if (BasicUtil.isNotEmpty((boolean)true, (Object)varValues)) {
                    if (var.getCompare() == Compare.IN) {
                        String replaceDst = "";
                        for (Object tmp : varValues) {
                            replaceDst = replaceDst + " ?";
                        }
                        this.addRunValue(runtime, (Run)run, Compare.IN, new Column(var.getKey()), varValues);
                        replaceDst = replaceDst.trim().replace(" ", ",");
                        result = result.replace(var.getFullKey(), replaceDst);
                        continue;
                    }
                    result = result.replace(var.getFullKey(), "?");
                    this.addRunValue(runtime, (Run)run, Compare.EQUAL, new Column(var.getKey()), varValues.get(0));
                    continue;
                }
                result = result.replace(var.getFullKey(), "NULL");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 0) continue;
                varValues = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, (Object)varValues)) {
                    value = (String)varValues.get(0);
                }
                this.addRunValue(runtime, (Run)run, Compare.EQUAL, new Column(var.getKey()), value);
            }
        }
        builder.append(result);
    }

    protected void fillQueryContent(DataRuntime runtime, TableRun run) {
        List joins;
        ConfigStore configs;
        StringBuilder builder = run.getBuilder();
        TablePrepare sql = (TablePrepare)run.getPrepare();
        builder.append("SELECT ");
        if (null != sql.getDistinct()) {
            builder.append(sql.getDistinct());
        }
        builder.append("\n\t");
        List columns = sql.getQueryColumns();
        if ((null == columns || columns.isEmpty()) && null != (configs = run.getConfigStore())) {
            columns = configs.columns();
        }
        if (null != columns && columns.size() > 0) {
            int size = columns.size();
            for (int i = 0; i < size; ++i) {
                String column = (String)columns.get(i);
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("${") && column.endsWith("}")) {
                    column = column.substring(2, column.length() - 1);
                    builder.append(column);
                } else if (column.toUpperCase().contains(" AS ") || column.contains("(") || column.contains(",")) {
                    builder.append(column);
                } else if ("*".equals(column)) {
                    builder.append("*");
                } else {
                    SQLUtil.delimiter((StringBuilder)builder, (String)column, (String)this.delimiterFr, (String)this.delimiterTo);
                }
                if (i >= size - 1) continue;
                builder.append(",");
            }
            builder.append("\n");
        } else {
            builder.append("*");
            builder.append("\n");
        }
        builder.append("FROM").append("\n\t");
        if (null != run.getSchema()) {
            SQLUtil.delimiter((StringBuilder)builder, (String)run.getSchema(), (String)this.delimiterFr, (String)this.delimiterTo).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)run.getTable(), (String)this.delimiterFr, (String)this.delimiterTo);
        builder.append("\n");
        if (BasicUtil.isNotEmpty((Object)sql.getAlias())) {
            builder.append("  ").append(sql.getAlias());
        }
        if (null != (joins = sql.getJoins())) {
            for (Join join : joins) {
                builder.append("\n\t").append(join.getType().getCode()).append(" ");
                if (null != join.getSchema()) {
                    SQLUtil.delimiter((StringBuilder)builder, (String)join.getSchema(), (String)this.delimiterFr, (String)this.delimiterTo).append(".");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)join.getName(), (String)this.delimiterFr, (String)this.delimiterTo);
                if (BasicUtil.isNotEmpty((Object)join.getAlias())) {
                    builder.append("  ").append(join.getAlias());
                }
                builder.append(" ON ").append(join.getCondition());
            }
        }
        builder.append("\nWHERE 1=1\n\t");
        run.appendCondition();
        run.appendGroup();
        run.appendOrderStore();
        run.checkValid();
    }

    public String mergeFinalExists(DataRuntime runtime, Run run) {
        String sql = "SELECT EXISTS(\n" + run.getBuilder().toString() + "\n)  IS_EXISTS";
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE ");
        return sql;
    }

    protected void fillExecuteContent(DataRuntime runtime, TextRun run) {
        this.replaceVariable(runtime, run);
        run.appendCondition();
        run.appendGroup();
        run.checkValid();
    }

    public String mergeFinalTotal(DataRuntime runtime, Run run) {
        String base = run.getBuilder().toString();
        StringBuilder builder = new StringBuilder();
        boolean simple = false;
        String upper = base.toUpperCase();
        if (upper.split("FROM").length == 2 && !upper.contains("DISTINCT") && !upper.contains("GROUP")) {
            simple = true;
        }
        if (simple) {
            int idx = base.toUpperCase().indexOf("FROM");
            builder.append("SELECT COUNT(*) AS CNT FROM ").append(base.substring(idx + 5));
        } else {
            builder.append("SELECT COUNT(*) AS CNT FROM (\n").append(base).append("\n) F");
        }
        String sql = builder.toString();
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE ");
        return sql;
    }

    public Run buildDeleteRunFromTable(DataRuntime runtime, int batch, String table, String key, Object values) {
        if (null == table || null == key || null == values) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        TableRun run = new TableRun(runtime, table);
        builder.append("DELETE FROM ");
        SQLUtil.delimiter((StringBuilder)builder, (String)table, (String)this.delimiterFr, (String)this.delimiterTo);
        builder.append(" WHERE ");
        if (values instanceof Collection) {
            Collection cons = (Collection)values;
            SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            if (batch > 1) {
                builder.append(" = ?");
                ArrayList list = null;
                if (values instanceof List) {
                    list = (ArrayList)values;
                } else {
                    list = new ArrayList();
                    for (Object item : cons) {
                        list.add(item);
                    }
                }
                run.setValues(list);
                run.setVol(1);
                run.setBatch(batch);
            } else {
                if (cons.size() > 1) {
                    builder.append(" IN(");
                    int idx = 0;
                    for (Object obj : cons) {
                        if (idx > 0) {
                            builder.append(",");
                        }
                        builder.append("?");
                        ++idx;
                    }
                    builder.append(")");
                } else if (cons.size() == 1) {
                    for (Object obj : cons) {
                        builder.append("=?");
                    }
                } else {
                    throw new SQLUpdateException("\u5220\u9664\u5f02\u5e38:\u5220\u9664\u6761\u4ef6\u4e3a\u7a7a,delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u6574\u8868\u64cd\u4f5c.");
                }
                this.addRunValue(runtime, (Run)run, Compare.IN, new Column(key), values);
            }
        } else {
            SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            builder.append("=?");
            this.addRunValue(runtime, (Run)run, Compare.EQUAL, new Column(key), values);
        }
        run.setBuilder(builder);
        return run;
    }

    public Run buildDeleteRunFromEntity(DataRuntime runtime, String dest, Object obj, String ... columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setFrom(2);
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM ");
        SQLUtil.delimiter((StringBuilder)builder, (String)this.parseTable(dest), (String)this.delimiterFr, (String)this.delimiterTo);
        builder.append(" WHERE ");
        List<String> keys = new ArrayList();
        if (null != columns && columns.length > 0) {
            for (String col : columns) {
                keys.add(col);
            }
        } else if (obj instanceof DataRow) {
            keys = ((DataRow)obj).getPrimaryKeys();
        } else {
            keys.addAll(EntityAdapterProxy.primaryKeys(obj.getClass()).keySet());
        }
        int size = keys.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    builder.append("\nAND ");
                }
                String key = (String)keys.get(i);
                SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ? ");
                Object value = null;
                value = obj instanceof DataRow ? ((DataRow)obj).get(key) : (EntityAdapterProxy.hasAdapter(obj.getClass()) ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key));
                this.addRunValue(runtime, (Run)run, Compare.EQUAL, new Column(key), value);
            }
        } else {
            throw new SQLUpdateException("\u5220\u9664\u5f02\u5e38:\u5220\u9664\u6761\u4ef6\u4e3a\u7a7a,delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u6574\u8868\u64cd\u4f5c.");
        }
        run.setBuilder(builder);
        return run;
    }

    protected String concatFun(String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            result = "concat(";
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + ",";
                }
                result = result + arg;
            }
            result = result + ")";
        }
        return result;
    }

    protected String concatOr(String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + " || ";
                }
                result = result + arg;
            }
        }
        return result;
    }

    protected String concatAdd(String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + " + ";
                }
                result = result + arg;
            }
        }
        return result;
    }
}

