/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.proxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.interceptor.CountInterceptor;
import org.anyline.data.interceptor.DDInterceptor;
import org.anyline.data.interceptor.DeleteInterceptor;
import org.anyline.data.interceptor.ExecuteInterceptor;
import org.anyline.data.interceptor.InsertInterceptor;
import org.anyline.data.interceptor.JDBCInterceptor;
import org.anyline.data.interceptor.QueryInterceptor;
import org.anyline.data.interceptor.UpdateInterceptor;
import org.anyline.data.jdbc.ds.JDBCRuntime;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.run.Run;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.Procedure;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="anyline.interceptor.proxy")
public class InterceptorProxy {
    private static Map<ACTION.DDL, List<DDInterceptor>> dds = new HashMap<ACTION.DDL, List<DDInterceptor>>();
    private static List<QueryInterceptor> queryInterceptors = new ArrayList<QueryInterceptor>();
    private static List<CountInterceptor> countInterceptors = new ArrayList<CountInterceptor>();
    private static List<UpdateInterceptor> updateInterceptors = new ArrayList<UpdateInterceptor>();
    private static List<InsertInterceptor> insertInterceptors = new ArrayList<InsertInterceptor>();
    private static List<DeleteInterceptor> deleteInterceptors = new ArrayList<DeleteInterceptor>();
    private static List<ExecuteInterceptor> executeInterceptors = new ArrayList<ExecuteInterceptor>();

    @Autowired(required=false)
    public void setQueryInterceptors(Map<String, QueryInterceptor> interceptors) {
        for (QueryInterceptor interceptor : interceptors.values()) {
            queryInterceptors.add(interceptor);
        }
        JDBCInterceptor.sort(queryInterceptors);
    }

    @Autowired(required=false)
    public void setCountInterceptors(Map<String, CountInterceptor> interceptors) {
        for (CountInterceptor interceptor : interceptors.values()) {
            countInterceptors.add(interceptor);
        }
        JDBCInterceptor.sort(countInterceptors);
    }

    @Autowired(required=false)
    public void setUpdateInterceptors(Map<String, UpdateInterceptor> interceptors) {
        for (UpdateInterceptor interceptor : interceptors.values()) {
            updateInterceptors.add(interceptor);
        }
        JDBCInterceptor.sort(updateInterceptors);
    }

    @Autowired(required=false)
    public void setInsertInterceptors(Map<String, InsertInterceptor> interceptors) {
        for (InsertInterceptor interceptor : interceptors.values()) {
            insertInterceptors.add(interceptor);
        }
        JDBCInterceptor.sort(insertInterceptors);
    }

    @Autowired(required=false)
    public void setDeleteInterceptors(Map<String, DeleteInterceptor> interceptors) {
        for (DeleteInterceptor interceptor : interceptors.values()) {
            deleteInterceptors.add(interceptor);
        }
        JDBCInterceptor.sort(insertInterceptors);
    }

    @Autowired(required=false)
    public void setExecuteInterceptors(Map<String, ExecuteInterceptor> interceptors) {
        for (ExecuteInterceptor interceptor : interceptors.values()) {
            executeInterceptors.add(interceptor);
        }
        JDBCInterceptor.sort(executeInterceptors);
    }

    @Autowired(required=false)
    public void setDDInterceptors(Map<String, DDInterceptor> interceptors) {
        for (DDInterceptor dDInterceptor : interceptors.values()) {
            ACTION.DDL action;
            List<ACTION.DDL> actions = dDInterceptor.actions();
            if (null != actions) {
                for (ACTION.DDL action2 : actions) {
                    this.reg(action2, dDInterceptor);
                }
            }
            if (null == (action = dDInterceptor.action())) continue;
            this.reg(action, dDInterceptor);
        }
        for (List list : dds.values()) {
            JDBCInterceptor.sort(list);
        }
    }

    public void reg(ACTION.DDL action, DDInterceptor interceptor) {
        List<DDInterceptor> interceptors = dds.get(action);
        if (null == interceptors) {
            interceptors = new ArrayList<DDInterceptor>();
        }
        interceptors.add(interceptor);
    }

    public static ACTION.SWITCH prepareQuery(JDBCRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (QueryInterceptor interceptor : queryInterceptors) {
            swt = interceptor.prepare(runtime, prepare, configs, conditions);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareQuery(JDBCRuntime runtime, String random, Procedure procedure, PageNavi navi) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (QueryInterceptor interceptor : queryInterceptors) {
            swt = interceptor.prepare(runtime, procedure, navi);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH beforeQuery(JDBCRuntime runtime, String random, Run run, PageNavi navi) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (QueryInterceptor interceptor : queryInterceptors) {
            swt = interceptor.before(runtime, run, navi);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH beforeQuery(JDBCRuntime runtime, String random, Procedure procedure, List<Parameter> inputs, List<Parameter> outputs, PageNavi navi) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (QueryInterceptor interceptor : queryInterceptors) {
            swt = interceptor.before(runtime, procedure, inputs, outputs, navi);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH afterQuery(JDBCRuntime runtime, String random, Run run, boolean exe, Object result, PageNavi navi, long millis) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (QueryInterceptor interceptor : queryInterceptors) {
            swt = interceptor.after(runtime, run, exe, result, navi, millis);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH afterQuery(JDBCRuntime runtime, String random, Procedure procedure, List<Parameter> inputs, List<Parameter> outputs, PageNavi navi, boolean success, Object resutl, long millis) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (QueryInterceptor interceptor : queryInterceptors) {
            swt = interceptor.after(runtime, procedure, inputs, outputs, navi, success, resutl, millis);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareCount(JDBCRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (CountInterceptor interceptor : countInterceptors) {
            swt = interceptor.prepare(runtime, prepare, configs, conditions);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH beforeCount(JDBCRuntime runtime, String random, Run run) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (CountInterceptor interceptor : countInterceptors) {
            swt = interceptor.before(runtime, run);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH afterCount(JDBCRuntime runtime, String random, Run run, boolean exe, int result, long millis) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (CountInterceptor interceptor : countInterceptors) {
            swt = interceptor.after(runtime, run, exe, result, millis);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareUpdate(JDBCRuntime runtime, String random, String dest, Object data, ConfigStore configs, List<String> columns) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (UpdateInterceptor interceptor : updateInterceptors) {
            swt = interceptor.prepare(runtime, dest, data, configs, columns);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH beforeUpdate(JDBCRuntime runtime, String random, Run run, String dest, Object data, ConfigStore configs, List<String> columns) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (UpdateInterceptor interceptor : updateInterceptors) {
            swt = interceptor.before(runtime, run, dest, data, configs, columns);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH afterUpdate(JDBCRuntime runtime, String random, Run run, String dest, Object data, ConfigStore configs, List<String> columns, boolean success, int result, long millis) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (UpdateInterceptor interceptor : updateInterceptors) {
            swt = interceptor.after(runtime, run, dest, data, configs, columns, success, result, millis);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareInsert(JDBCRuntime runtime, String random, String dest, Object data, boolean checkPrimary, List<String> columns) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (InsertInterceptor interceptor : insertInterceptors) {
            swt = interceptor.prepare(runtime, dest, data, checkPrimary, columns);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH beforeInsert(JDBCRuntime runtime, String random, Run run, String dest, Object data, boolean checkPrimary, List<String> columns) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (InsertInterceptor interceptor : insertInterceptors) {
            swt = interceptor.before(runtime, run, dest, data, checkPrimary, columns);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH afterInsert(JDBCRuntime runtime, String random, Run run, String dest, Object data, boolean checkPrimary, List<String> columns, boolean success, int result, long millis) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (InsertInterceptor interceptor : insertInterceptors) {
            swt = interceptor.after(runtime, run, dest, data, checkPrimary, columns, success, result, millis);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareDelete(JDBCRuntime runtime, String random, String table, String key, Collection values) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (DeleteInterceptor interceptor : deleteInterceptors) {
            swt = interceptor.prepare(runtime, table, key, values);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareDelete(JDBCRuntime runtime, String random, String table, ConfigStore configs, String ... conditions) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (DeleteInterceptor interceptor : deleteInterceptors) {
            swt = interceptor.prepare(runtime, table, configs, conditions);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareDelete(JDBCRuntime runtime, String random, String dest, Object obj, String ... columns) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (DeleteInterceptor interceptor : deleteInterceptors) {
            swt = interceptor.prepare(runtime, dest, obj, columns);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH beforeDelete(JDBCRuntime runtime, String random, Run run) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (DeleteInterceptor interceptor : deleteInterceptors) {
            swt = interceptor.before(runtime, run);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH afterDelete(JDBCRuntime runtime, String random, Run run, boolean success, int result, long millis) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (DeleteInterceptor interceptor : deleteInterceptors) {
            swt = interceptor.after(runtime, run, success, result, millis);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareExecute(JDBCRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (ExecuteInterceptor interceptor : executeInterceptors) {
            swt = interceptor.prepare(runtime, prepare, configs, conditions);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareExecute(JDBCRuntime runtime, String random, Procedure procedure) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (ExecuteInterceptor interceptor : executeInterceptors) {
            swt = interceptor.prepare(runtime, procedure);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH beforeExecute(JDBCRuntime runtime, String random, Run run) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (ExecuteInterceptor interceptor : executeInterceptors) {
            swt = interceptor.before(runtime, run);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH beforeExecute(JDBCRuntime runtime, String random, Procedure procedure, String sql, List<Parameter> inputs, List<Parameter> outputs) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (ExecuteInterceptor interceptor : executeInterceptors) {
            swt = interceptor.before(runtime, procedure, sql, inputs, outputs);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH afterExecute(JDBCRuntime runtime, String random, Run run, boolean success, int result, long millis) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (ExecuteInterceptor interceptor : executeInterceptors) {
            swt = interceptor.after(runtime, run, success, result, millis);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH afterExecute(JDBCRuntime runtime, String random, Procedure procedure, String sql, List<Parameter> inputs, List<Parameter> outputs, boolean success, boolean result, long millis) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (ExecuteInterceptor interceptor : executeInterceptors) {
            swt = interceptor.after(runtime, procedure, sql, inputs, outputs, success, result, millis);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepare(JDBCRuntime runtime, String random, ACTION.DDL action, Object metadata) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        List<DDInterceptor> interceptors = dds.get(action);
        if (null != interceptors) {
            for (DDInterceptor interceptor : interceptors) {
                swt = interceptor.prepare(runtime, random, action, metadata);
                if (swt == ACTION.SWITCH.CONTINUE) continue;
                return swt;
            }
        }
        return swt;
    }

    public static ACTION.SWITCH before(JDBCRuntime runtime, String random, ACTION.DDL action, Object metadata, List<Run> runs) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        List<DDInterceptor> interceptors = dds.get(action);
        if (null != interceptors) {
            for (DDInterceptor interceptor : interceptors) {
                swt = interceptor.before(runtime, random, action, metadata, runs);
                if (swt == ACTION.SWITCH.CONTINUE) continue;
                return swt;
            }
        }
        return swt;
    }

    public static ACTION.SWITCH after(JDBCRuntime runtime, String random, ACTION.DDL action, Object metadata, List<Run> runs, boolean result, long millis) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        List<DDInterceptor> interceptors = dds.get(action);
        if (null != interceptors) {
            for (DDInterceptor interceptor : interceptors) {
                swt = interceptor.after(runtime, random, action, metadata, runs, result, millis);
                if (swt == ACTION.SWITCH.CONTINUE) continue;
                return swt;
            }
        }
        return swt;
    }
}

