/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.run;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.anyline.data.jdbc.ds.DataSourceHolder;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.ParseResult;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.Group;
import org.anyline.data.prepare.GroupStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.init.DefaultGroupStore;
import org.anyline.data.prepare.xml.init.DefaultXMLConditionChain;
import org.anyline.data.run.BasicRun;
import org.anyline.data.run.Run;
import org.anyline.data.util.ThreadConfig;
import org.anyline.entity.Compare;
import org.anyline.entity.DefaultOrderStore;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.DefaultOgnlMemberAccess;

public class XMLRun
extends BasicRun
implements Run {
    private List<String> conditions;
    private List<String> staticConditions;

    public XMLRun() {
        this.builder = new StringBuilder();
        this.conditionChain = new DefaultXMLConditionChain();
        this.orderStore = new DefaultOrderStore();
        this.groupStore = new DefaultGroupStore();
    }

    @Override
    public Run setPrepare(RunPrepare prepare) {
        this.prepare = prepare;
        this.table = prepare.getTable();
        this.copyParam();
        return this;
    }

    @Override
    public void init() {
        List<Group> groups;
        super.init();
        if (null != this.configStore) {
            PageNavi navi;
            List orders;
            for (Config conf : this.configStore.getConfigChain().getConfigs()) {
                this.setConditionValue(conf.getSwitch(), conf.getCompare(), conf.getPrefix(), conf.getVariable(), conf.getValues());
            }
            Iterator<Object> orderStore = this.configStore.getOrders();
            if (null != orderStore && null != (orders = orderStore.getOrders())) {
                for (Order order : orders) {
                    this.orderStore.order(order);
                }
            }
            if ((navi = this.configStore.getPageNavi()) != null) {
                this.pageNavi = navi;
            }
        }
        if (null != this.conditions) {
            for (String condition : this.conditions) {
                ParseResult parser = ConfigParser.parse(condition, false);
                Object value = ConfigParser.getValues(parser);
                if (parser.getParamFetchType() == ParseResult.FETCH_REQUEST_VALUE_TYPE_MULTIPLE) {
                    value = BeanUtil.object2list(value);
                }
                this.setConditionValue(parser.getSwitch(), parser.getCompare(), parser.getPrefix(), parser.getVar(), value);
            }
        }
        for (Condition con : this.conditionChain.getConditions()) {
            if (con.isActive()) continue;
            if (con.getSwitch() == Compare.EMPTY_VALUE_SWITCH.BREAK) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][con:{}]", (Object)con.getId());
                this.valid = false;
                continue;
            }
            if (con.getSwitch() == Compare.EMPTY_VALUE_SWITCH.IGNORE) {
                log.warn("[valid:false][\u5ffd\u7565\u5f53\u524d\u6761\u4ef6][con:{}]", (Object)con.getId());
                continue;
            }
            con.setActive(true);
            List<Variable> vars = con.getVariables();
            if (null == vars) continue;
            for (Variable var : vars) {
                var.setValue(false, null);
            }
        }
        GroupStore groupStore = this.prepare.getGroups();
        if (null != groupStore && null != (groups = groupStore.getGroups())) {
            for (Group group : groups) {
                this.groupStore.group(group);
            }
        }
        this.checkTest();
        this.parseText();
    }

    @Override
    public boolean checkValid() {
        if (!this.valid) {
            return false;
        }
        if (null != this.variables) {
            for (Variable var : this.variables) {
                if (var.getSwitch() != Compare.EMPTY_VALUE_SWITCH.BREAK || !BasicUtil.isEmpty((boolean)true, var.getValues())) continue;
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][var:{}]", (Object)var.getKey());
                this.valid = false;
                return false;
            }
        }
        if (null != this.conditionChain && !this.conditionChain.isValid()) {
            this.valid = false;
            return false;
        }
        return this.valid;
    }

    protected void parseText() {
        String result = this.prepare.getText();
        if (null != this.variables) {
            List<Object> varValues;
            String replaceKey;
            String value;
            List<Object> varValues2;
            for (Variable var : this.variables) {
                if (null == var || var.getType() != 3) continue;
                varValues2 = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, varValues2) && null != (value = (String)varValues2.get(0))) {
                    value = value.replace("'", "").replace("%", "");
                }
                replaceKey = var.getFullKey();
                if (null != value) {
                    result = result.replace(replaceKey, value);
                    continue;
                }
                result = result.replace(replaceKey, "NULL");
            }
            for (Variable var : this.variables) {
                if (null == var || var.getType() != 2) continue;
                varValues2 = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, varValues2) && null != (value = (String)varValues2.get(0))) {
                    value = value.replace("'", "").replace("%", "");
                }
                if (null == value) {
                    value = "";
                }
                if (var.getSignType() == 1) {
                    result = result.replace("::" + var.getKey(), value);
                    result = result.replace(":" + var.getKey(), value);
                    continue;
                }
                if (var.getSignType() != 2) continue;
                result = result.replace("${" + var.getKey() + "}", value);
                result = result.replace("#{" + var.getKey() + "}", value);
            }
            boolean IS_AUTO_SPLIT_ARRAY = ThreadConfig.check(DataSourceHolder.curDataSource()).IS_AUTO_SPLIT_ARRAY();
            for (Variable var : this.variables) {
                if (null == var || var.getType() != 1 || !BasicUtil.isNotEmpty((boolean)true, varValues = var.getValues())) continue;
                replaceKey = var.getFullKey();
                if (var.getCompare() == Compare.LIKE) {
                    result = result.replace("'%" + replaceKey + "%'", this.adapter.concat("'%'", "?", "'%'"));
                    this.addValues(Compare.EQUAL, var.getKey(), varValues.get(0), IS_AUTO_SPLIT_ARRAY);
                    continue;
                }
                if (var.getCompare() == Compare.LIKE_SUFFIX) {
                    result = result.replace("'%" + replaceKey + "'", this.adapter.concat("'%'", "?"));
                    this.addValues(Compare.EQUAL, var.getKey(), varValues.get(0), IS_AUTO_SPLIT_ARRAY);
                    continue;
                }
                if (var.getCompare() == Compare.LIKE_PREFIX) {
                    result = result.replace("'" + replaceKey + "%'", this.adapter.concat("?", "'%'"));
                    this.addValues(Compare.EQUAL, var.getKey(), varValues.get(0), IS_AUTO_SPLIT_ARRAY);
                    continue;
                }
                if (var.getCompare() == Compare.IN) {
                    String replaceDst = "";
                    for (Object tmp : varValues) {
                        replaceDst = replaceDst + " ?";
                    }
                    this.addValues(Compare.IN, var.getKey(), varValues, IS_AUTO_SPLIT_ARRAY);
                    replaceDst = replaceDst.trim().replace(" ", ",");
                    result = result.replace(replaceKey, replaceDst);
                    continue;
                }
                result = result.replace(replaceKey, "?");
                this.addValues(Compare.EQUAL, var.getKey(), varValues.get(0), IS_AUTO_SPLIT_ARRAY);
            }
            for (Variable var : this.variables) {
                if (null == var || var.getType() != 0) continue;
                varValues = var.getValues();
                String value2 = null;
                if (BasicUtil.isNotEmpty((boolean)true, varValues)) {
                    value2 = (String)varValues.get(0);
                }
                this.addValues(Compare.EQUAL, var.getKey(), value2, IS_AUTO_SPLIT_ARRAY);
            }
        }
        this.builder.append(result);
        this.appendCondition();
        this.appendStaticCondition();
        this.appendGroup();
    }

    private void copyParam() {
        List<Group> list;
        GroupStore xmlGroupStore;
        List xmlOrders;
        OrderStore xmlOrderStore;
        ConditionChain xmlConditionChain;
        List<Variable> xmlVars = this.prepare.getSQLVariables();
        if (null != xmlVars) {
            if (null == this.variables) {
                this.variables = new ArrayList();
            }
            for (Variable var : xmlVars) {
                if (null == var) continue;
                try {
                    this.variables.add((Variable)var.clone());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (null != (xmlConditionChain = this.prepare.getConditionChain())) {
            List<Condition> conditions;
            if (null == this.conditionChain) {
                this.conditionChain = new DefaultXMLConditionChain();
            }
            if (null != (conditions = xmlConditionChain.getConditions())) {
                for (Condition condition : conditions) {
                    if (null == condition) continue;
                    try {
                        this.conditionChain.addCondition((Condition)condition.clone());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (null != (xmlOrderStore = this.prepare.getOrders()) && null != (xmlOrders = xmlOrderStore.getOrders())) {
            for (Order order : xmlOrders) {
                this.orderStore.order(order);
            }
        }
        if (null != (xmlGroupStore = this.prepare.getGroups()) && null != (list = xmlGroupStore.getGroups())) {
            for (Group group : list) {
                this.groupStore.group(group);
            }
        }
    }

    private void appendGroup() {
        if (null != this.groupStore) {
            this.builder.append(this.groupStore.getRunText(this.delimiterFr + this.delimiterTo));
        }
    }

    private void checkTest() {
        if (null != this.conditionChain) {
            for (Condition con : this.conditionChain.getConditions()) {
                String test = con.getTest();
                if (null != test) {
                    Map<String, Object> map = con.getRunValuesMap();
                    HashMap runtimeValues = new HashMap();
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        Collection cols;
                        Iterator iterator;
                        String mapKey = entry.getKey();
                        Object mapValue = entry.getValue();
                        if (null == mapValue || !(mapValue instanceof Collection) || !(iterator = (cols = (Collection)mapValue).iterator()).hasNext()) continue;
                        Object obj = iterator.next();
                        runtimeValues.put(mapKey, obj);
                    }
                    try {
                        OgnlContext context = new OgnlContext(null, null, (MemberAccess)new DefaultOgnlMemberAccess(true));
                        Boolean result = (Boolean)Ognl.getValue((String)test, (Map)context, runtimeValues);
                        if (!result.booleanValue()) {
                            con.setActive(false);
                            continue;
                        }
                        if (con.getVariableType() != 2) continue;
                        con.setActive(true);
                        this.conditionChain.setActive(true);
                    }
                    catch (OgnlException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (con.getVariableType() != 2) continue;
                con.setActive(true);
                this.conditionChain.setActive(true);
            }
        }
    }

    private void appendCondition() {
        if (null == this.conditionChain || !this.conditionChain.isActive()) {
            return;
        }
        if (!XMLRun.endWithWhere(this.builder.toString())) {
            this.builder.append(" WHERE 1=1");
        }
        this.builder.append(this.conditionChain.getRunText(null, this.adapter));
        this.addValues(this.conditionChain.getRunValues());
    }

    private void appendStaticCondition() {
        if (!XMLRun.endWithWhere(this.builder.toString())) {
            this.builder.append(" WHERE 1=1");
        }
        if (null != this.staticConditions) {
            for (String con : this.staticConditions) {
                this.builder.append("\nAND ").append(con);
            }
        }
    }

    public void setConfigs(ConfigStore configs) {
        this.configStore = configs;
        if (null != configs) {
            this.pageNavi = configs.getPageNavi();
        }
    }

    @Override
    public Variable getVariable(String key) {
        if (null != this.variables) {
            for (Variable v : this.variables) {
                if (null == v || !v.getKey().equalsIgnoreCase(key)) continue;
                return v;
            }
        }
        return null;
    }

    private List<Variable> getVariables(String key) {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        if (null != this.variables) {
            for (Variable v : this.variables) {
                if (null == v || !v.getKey().equalsIgnoreCase(key)) continue;
                vars.add(v);
            }
        }
        return vars;
    }

    @Override
    public Run setConditionValue(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String prefix, String variable, Object value) {
        if (null != this.variables && (BasicUtil.isEmpty((Object)prefix) || prefix.equals(variable))) {
            List<Variable> vars = this.getVariables(variable);
            for (Variable var : vars) {
                var.setValue(value);
            }
        }
        if (null == variable) {
            return this;
        }
        Condition con = null;
        con = null == prefix ? this.getCondition(variable) : this.getCondition(prefix);
        Variable var = this.getVariable(variable);
        if (null == con && null == var) {
            return this;
        }
        if (null != con) {
            con.setValue(variable, value);
            if (con.isActive()) {
                this.conditionChain.setActive(true);
            }
        }
        return this;
    }

    @Override
    public Run addCondition(String ... conditions) {
        if (null != conditions) {
            for (String condition : conditions) {
                if (null == condition) continue;
                String up = (condition = condition.trim()).toUpperCase().replaceAll("\\s+", " ").trim();
                if (up.startsWith("ORDER BY")) {
                    String[] orders;
                    String orderStr = condition.substring(up.indexOf("ORDER BY") + "ORDER BY".length()).trim();
                    for (String item : orders = orderStr.split(",")) {
                        if (null != this.configStore) {
                            this.configStore.order(item);
                        }
                        if (null == this.orderStore) continue;
                        this.orderStore.order(item);
                    }
                    continue;
                }
                if (up.startsWith("GROUP BY")) {
                    String[] groups;
                    String groupStr = condition.substring(up.indexOf("GROUP BY") + "GROUP BY".length()).trim();
                    for (String item : groups = groupStr.split(",")) {
                        if (null == this.configStore) continue;
                        this.configStore.group(item);
                    }
                    continue;
                }
                this.addCondition(condition);
            }
        }
        return this;
    }

    public void addSatticCondition(String condition) {
        if (null == this.staticConditions) {
            this.staticConditions = new ArrayList<String>();
        }
        this.staticConditions.add(condition);
    }

    public Run addCondition(String condition) {
        if (BasicUtil.isEmpty((Object)condition)) {
            return this;
        }
        if (condition.startsWith("${") && condition.endsWith("}")) {
            this.addSatticCondition(condition.substring(2, condition.length() - 1));
            return this;
        }
        if (condition.contains(":")) {
            boolean isTime = false;
            int idx = condition.indexOf(":");
            if (condition.indexOf("'") < idx && condition.indexOf("'", idx + 1) > 0) {
                isTime = true;
            }
            if (!isTime) {
                if (null == this.conditions) {
                    this.conditions = new ArrayList<String>();
                }
                this.conditions.add(condition);
                return this;
            }
        }
        this.addSatticCondition(condition);
        return this;
    }

    @Override
    public Run addOrders(OrderStore orderStore) {
        if (null == orderStore) {
            return this;
        }
        List orders = orderStore.getOrders();
        if (null == orders) {
            return this;
        }
        for (Order order : orders) {
            this.orderStore.order(order);
        }
        return this;
    }

    @Override
    public Run addOrder(Order order) {
        this.orderStore.order(order);
        return this;
    }

    public Run addCondition(String prefix, String variable, Object value) {
        if (null != this.variables && BasicUtil.isEmpty((Object)variable)) {
            for (Variable v : this.variables) {
                if (null == v || !v.getKey().equalsIgnoreCase(prefix)) continue;
                v.setValue(value);
            }
        }
        if (null == prefix) {
            return this;
        }
        Condition con = this.getCondition(prefix);
        if (null == con) {
            return this;
        }
        variable = ((String)BasicUtil.nvl((Object[])new String[]{variable, prefix})).toString();
        con.setValue(variable, value);
        return this;
    }

    @Override
    public void setConfigStore(ConfigStore configStore) {
        this.configStore = configStore;
    }

    public Run addCondition(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String column, Object value) {
        this.setConditionValue(swt, compare, column, null, value);
        return this;
    }
}

