/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.param;

import java.util.ArrayList;
import java.util.List;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.entity.Join;
import org.anyline.util.BasicUtil;

public class TableBuilder {
    private String table;
    private String datasource;
    private String alias;
    private List<String> columns = new ArrayList<String>();
    private List<Join> joins = new ArrayList<Join>();

    public static TableBuilder init() {
        TableBuilder builder = new TableBuilder();
        return builder;
    }

    public static TableBuilder init(String table) {
        TableBuilder builder = new TableBuilder();
        builder.setTable(table);
        return builder;
    }

    public static TableBuilder init(String table, String columns) {
        TableBuilder builder = new TableBuilder();
        builder.setTable(table);
        builder.addColumns(columns);
        return builder;
    }

    public TableBuilder setDatasource(String datasoruce) {
        this.datasource = datasoruce;
        return this;
    }

    public TableBuilder setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public TableBuilder setTable(String table) {
        this.table = table;
        return this;
    }

    public TableBuilder addColumn(String column) {
        if (!this.columns.contains(column)) {
            this.columns.add(column);
        }
        return this;
    }

    public TableBuilder addColumns(String ... columns) {
        if (null != columns) {
            for (String column : columns) {
                this.addColumn(column);
            }
        }
        return this;
    }

    public RunPrepare build() {
        DefaultTablePrepare sql = new DefaultTablePrepare();
        sql.setDataSource(this.datasource);
        sql.setTable(this.table);
        if (BasicUtil.isNotEmpty((Object)this.alias)) {
            sql.setAlias(this.alias);
        }
        for (Join join : this.joins) {
            sql.join(join);
        }
        for (String col : this.columns) {
            sql.addColumn(col);
        }
        return sql;
    }

    public TableBuilder join(Join join) {
        this.joins.add(join);
        return this;
    }

    public TableBuilder join(Join.TYPE type, String table, String condition) {
        Join join = new Join();
        join.setName(table);
        join.setType(type);
        join.setCondition(condition);
        return this.join(join);
    }

    public String getTable() {
        return this.table;
    }

    public TableBuilder inner(String table, String condition) {
        return this.join(Join.TYPE.INNER, table, condition);
    }

    public TableBuilder left(String table, String condition) {
        return this.join(Join.TYPE.LEFT, table, condition);
    }

    public TableBuilder right(String table, String condition) {
        return this.join(Join.TYPE.RIGHT, table, condition);
    }

    public TableBuilder full(String table, String condition) {
        return this.join(Join.TYPE.FULL, table, condition);
    }
}

