/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.ds;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.adapter.init.ConvertAdapter;
import org.anyline.data.jdbc.ds.RuntimeHolder;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.SpringContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class DataSourceHolder {
    public static Logger log = LoggerFactory.getLogger(DataSourceHolder.class);
    private static final ThreadLocal<String> THREAD_RECALL_SOURCE = new ThreadLocal();
    private static final ThreadLocal<String> THREAD_CUR_SOURCE = new ThreadLocal();
    private static final ThreadLocal<Boolean> THREAD_AUTO_RECOVER = new ThreadLocal();
    private static List<String> dataSources = new ArrayList<String>();
    private static Map<String, DatabaseType> types = new HashMap<String, DatabaseType>();
    private static Map<TransactionStatus, String> transactionStatus = new Hashtable<TransactionStatus, String>();

    public static List<String> list() {
        return dataSources;
    }

    public static String curDataSource() {
        return THREAD_CUR_SOURCE.get();
    }

    public static DatabaseType dialect() {
        String ds = DataSourceHolder.curDataSource();
        return types.get(ds);
    }

    public static void dialect(String ds, DatabaseType type) {
        types.put(ds, type);
    }

    public static void setDataSource(String dataSource) {
        DataSourceHolder.setDataSource(dataSource, false);
    }

    public static void destroyDataSource(String dataSource) {
        dataSources.remove(dataSource);
        RuntimeHolder.destroyRuntime(dataSource);
    }

    public static void setDataSource(String dataSource, boolean auto) {
        if (null == dataSource || !dataSources.contains(dataSource)) {
            throw new RuntimeException("\u6570\u636e\u6e90\u672a\u6ce8\u518c:" + dataSource);
        }
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.info("[\u5207\u6362\u6570\u636e\u6e90][thread:{}][\u6570\u636e\u6e90:{}>{}][auto recover:{}]", new Object[]{Thread.currentThread().getId(), THREAD_RECALL_SOURCE.get(), dataSource, auto});
        }
        THREAD_RECALL_SOURCE.set(THREAD_CUR_SOURCE.get());
        THREAD_CUR_SOURCE.set(dataSource);
        THREAD_AUTO_RECOVER.set(auto);
    }

    public static void recoverDataSource() {
        String fr = THREAD_CUR_SOURCE.get();
        String to = THREAD_RECALL_SOURCE.get();
        if (null == fr && null == to) {
            return;
        }
        if (null != fr && fr.equals(to)) {
            return;
        }
        THREAD_CUR_SOURCE.set(to);
        log.info("[\u8fd8\u539f\u6570\u636e\u6e90][thread:{}][\u6570\u636e\u6e90:{}>{}][auto recover:{}]", new Object[]{Thread.currentThread().getId(), fr, to});
    }

    public static void setDefaultDataSource() {
        DataSourceHolder.clearDataSource();
        if (dataSources.contains("dataSource")) {
            DataSourceHolder.setDataSource("dataSource");
        } else if (dataSources.contains("default")) {
            DataSourceHolder.setDataSource("default");
        }
        THREAD_AUTO_RECOVER.set(false);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.info("[\u5207\u6362\u6570\u636e\u6e90][thread:{}][\u6570\u636e\u6e90:{}>\u9ed8\u8ba4\u6570\u636e\u6e90]", (Object)Thread.currentThread().getId(), (Object)THREAD_RECALL_SOURCE.get());
        }
    }

    public static void clearDataSource() {
        THREAD_CUR_SOURCE.remove();
    }

    public static boolean isAutoRecover() {
        if (null == THREAD_AUTO_RECOVER || null == THREAD_AUTO_RECOVER.get()) {
            return false;
        }
        return THREAD_AUTO_RECOVER.get();
    }

    public static String parseDataSource(String src) {
        if (null != src && src.startsWith("<")) {
            int fr = src.indexOf("<");
            int to = src.indexOf(">");
            if (fr != -1) {
                String ds = src.substring(fr + 1, to);
                src = src.substring(to + 1);
                DataSourceHolder.setDataSource(ds, true);
            }
        }
        return src;
    }

    public static String parseDataSource(String dest, Object obj) {
        if (BasicUtil.isNotEmpty((Object)dest) || null == obj) {
            return DataSourceHolder.parseDataSource(dest);
        }
        String result = "";
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            String link = row.getDataLink();
            if (BasicUtil.isNotEmpty((Object)link)) {
                DataSourceHolder.setDataSource(link, true);
            }
            result = row.getDataSource();
        } else if (obj instanceof DataSet) {
            DataSet set = (DataSet)obj;
            if (set.size() > 0) {
                result = DataSourceHolder.parseDataSource(dest, set.getRow(0));
            }
        } else if (obj instanceof Collection) {
            Object first = ((Collection)obj).iterator().next();
            result = EntityAdapterProxy.table(first.getClass()).getName();
        } else {
            result = EntityAdapterProxy.table(obj.getClass()).getName();
        }
        result = DataSourceHolder.parseDataSource(result);
        return result;
    }

    public static void reg(String ds) {
        if (!dataSources.contains(ds)) {
            dataSources.add(ds);
        }
    }

    public static TransactionStatus startTransaction(String datasource, DefaultTransactionDefinition definition) {
        DataSourceTransactionManager dtm = null;
        if (BasicUtil.isEmpty((Object)datasource) || !ConfigTable.IS_OPEN_TRANSACTION_MANAGER) {
            dtm = (DataSourceTransactionManager)SpringContextUtil.getBean((String)"transactionManager");
            datasource = "";
        } else {
            dtm = (DataSourceTransactionManager)SpringContextUtil.getBean((String)("anyline.transaction." + datasource));
        }
        TransactionStatus status = dtm.getTransaction((TransactionDefinition)definition);
        transactionStatus.put(status, datasource);
        return status;
    }

    public static TransactionStatus startTransaction(String datasource, int behavior) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setPropagationBehavior(behavior);
        return DataSourceHolder.startTransaction(datasource, definition);
    }

    public static TransactionStatus startTransaction(String datasource) {
        return DataSourceHolder.startTransaction(datasource, 0);
    }

    public static TransactionStatus startTransaction(DefaultTransactionDefinition definition) {
        return DataSourceHolder.startTransaction(DataSourceHolder.curDataSource(), definition);
    }

    public static TransactionStatus startTransaction(int behavior) {
        return DataSourceHolder.startTransaction(DataSourceHolder.curDataSource(), behavior);
    }

    public static TransactionStatus startTransaction() {
        return DataSourceHolder.startTransaction(DataSourceHolder.curDataSource());
    }

    public static void commit(TransactionStatus status) {
        String datasource = transactionStatus.get(status);
        DataSourceTransactionManager dtm = null;
        dtm = BasicUtil.isEmpty((Object)datasource) || !ConfigTable.IS_OPEN_TRANSACTION_MANAGER ? (DataSourceTransactionManager)SpringContextUtil.getBean((String)"transactionManager") : (DataSourceTransactionManager)SpringContextUtil.getBean((String)("anyline.transaction." + datasource));
        dtm.commit(status);
        transactionStatus.remove(status);
    }

    public static void rollback(TransactionStatus status) {
        String datasource = transactionStatus.get(status);
        DataSourceTransactionManager dtm = null;
        dtm = BasicUtil.isEmpty((Object)datasource) || !ConfigTable.IS_OPEN_TRANSACTION_MANAGER ? (DataSourceTransactionManager)SpringContextUtil.getBean((String)"transactionManager") : (DataSourceTransactionManager)SpringContextUtil.getBean((String)("anyline.transaction." + datasource));
        dtm.rollback(status);
        transactionStatus.remove(status);
    }

    public static boolean contains(String ds) {
        return dataSources.contains(ds);
    }

    public static String regTransactionManager(String key, DataSource ds) {
        return DataSourceHolder.regTransactionManager(key, ds, false);
    }

    public static String regTransactionManager(String key, DataSource ds, boolean primary) {
        String tm_id = "anyline.transaction." + key;
        if (ConfigTable.IS_OPEN_TRANSACTION_MANAGER) {
            DefaultListableBeanFactory factory = (DefaultListableBeanFactory)SpringContextUtil.getApplicationContext().getAutowireCapableBeanFactory();
            BeanDefinitionBuilder tm_builder = BeanDefinitionBuilder.genericBeanDefinition(DataSourceTransactionManager.class);
            tm_builder.addPropertyValue("dataSource", (Object)ds);
            tm_builder.setPrimary(primary);
            AbstractBeanDefinition tm_definition = tm_builder.getBeanDefinition();
            factory.registerBeanDefinition(tm_id, (BeanDefinition)tm_definition);
            log.info("[\u521b\u5efa\u4e8b\u52a1\u63a7\u5236\u5668][\u6570\u636e\u6e90:{}][bean:{}]", (Object)key, (Object)tm_id);
        }
        return tm_id;
    }

    public static String regTransactionManager(String key, String ds) {
        return DataSourceHolder.regTransactionManager(key, ds, false);
    }

    public static String regTransactionManager(String key, String ds, boolean primary) {
        String tm_id = "anyline.transaction." + key;
        if (ConfigTable.IS_OPEN_TRANSACTION_MANAGER) {
            DefaultListableBeanFactory factory = (DefaultListableBeanFactory)SpringContextUtil.getApplicationContext().getAutowireCapableBeanFactory();
            BeanDefinitionBuilder tm_builder = BeanDefinitionBuilder.genericBeanDefinition(DataSourceTransactionManager.class);
            tm_builder.addPropertyReference("dataSource", ds);
            tm_builder.setPrimary(primary);
            AbstractBeanDefinition tm_definition = tm_builder.getBeanDefinition();
            factory.registerBeanDefinition(tm_id, (BeanDefinition)tm_definition);
            log.info("[\u521b\u5efa\u4e8b\u52a1\u63a7\u5236\u5668][\u6570\u636e\u6e90:{}][bean:{}]", (Object)key, (Object)tm_id);
        }
        return tm_id;
    }

    private static String addDataSource(String key, String ds, boolean over) throws Exception {
        if (!over && dataSources.contains(key)) {
            throw new Exception("[\u91cd\u590d\u6ce8\u518c][thread:" + Thread.currentThread().getId() + "][key:" + key + "]");
        }
        if (ConfigTable.IS_DEBUG && log.isInfoEnabled()) {
            log.info("[\u521b\u5efa\u6570\u636e\u6e90][thread:{}][key:{}]", (Object)Thread.currentThread().getId(), (Object)key);
        }
        DataSourceHolder.regTransactionManager(key, ds);
        DataSourceHolder.reg(key);
        RuntimeHolder.reg(key, ds);
        return ds;
    }

    private static DataSource addDataSource(String key, DataSource ds, boolean over) throws Exception {
        if (!over && dataSources.contains(key)) {
            throw new Exception("[\u91cd\u590d\u6ce8\u518c][thread:" + Thread.currentThread().getId() + "][key:" + key + "]");
        }
        if (ConfigTable.IS_DEBUG && log.isInfoEnabled()) {
            log.info("[\u521b\u5efa\u6570\u636e\u6e90][thread:{}][key:{}]", (Object)Thread.currentThread().getId(), (Object)key);
        }
        DataSourceHolder.regTransactionManager(key, ds);
        DataSourceHolder.reg(key);
        RuntimeHolder.reg(key, ds);
        return ds;
    }

    public static String reg(String key, String pool, String driver, String url, String user, String password) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("type", pool);
        param.put("driver", driver);
        param.put("url", url);
        param.put("user", user);
        param.put("password", password);
        return DataSourceHolder.reg(key, param);
    }

    public static String reg(String key, DatabaseType type, String url, String user, String password) throws Exception {
        return DataSourceHolder.reg(key, "om.zaxxer.hikari.HikariDataSource", type.driver(), url, user, password);
    }

    public static String reg(String key, Map param, boolean over) throws Exception {
        return DataSourceHolder.addDataSource(key, DataSourceHolder.reg(key, param), over);
    }

    public static String reg(String key, Map param) throws Exception {
        String ds = DataSourceHolder.build(key, param);
        return DataSourceHolder.addDataSource(key, ds, true);
    }

    public static DataSource reg(String key, DataSource ds, boolean over) throws Exception {
        return DataSourceHolder.addDataSource(key, ds, over);
    }

    public static DataSource reg(String key, DataSource ds) throws Exception {
        return DataSourceHolder.addDataSource(key, ds, true);
    }

    public static DataSource getDataSource() {
        return RuntimeHolder.getDataSource();
    }

    public static DataSource getDataSource(String key) {
        return RuntimeHolder.getDataSource(key);
    }

    public static String reg(String key, String prefix, Environment env) {
        try {
            String type;
            if (BasicUtil.isNotEmpty((Object)prefix) && !prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            if (null == (type = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"type"}))) {
                type = BeanUtil.value((String)"spring.datasource.", (Environment)env, (String[])new String[]{"type"});
            }
            if (type == null) {
                type = "com.zaxxer.hikari.HikariDataSource";
            }
            String driverClassName = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"driver", "driver-class", "driver-class-name"});
            String url = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"url", "jdbc-url"});
            String username = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"user", "username", "user-name"});
            String password = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"password"});
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("url", url);
            map.put("jdbcUrl", url);
            map.put("driver", driverClassName);
            map.put("driverClass", driverClassName);
            map.put("driverClassName", driverClassName);
            map.put("user", username);
            map.put("username", username);
            map.put("password", password);
            String ds = DataSourceHolder.build(key, map);
            DataSourceHolder.addDataSource(key, ds, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String build(String key, Map params) throws Exception {
        String ds_id = "anyline.datasource." + key;
        try {
            String type = (String)params.get("pool");
            if (BasicUtil.isEmpty((Object)type)) {
                type = (String)params.get("type");
            }
            if (type == null) {
                type = "com.zaxxer.hikari.HikariDataSource";
            }
            Class<?> poolClass = Class.forName(type);
            Object driver = BeanUtil.propertyNvl((Map)params, (String[])new String[]{"driver", "driver-class", "driver-class-name"});
            if (null == driver) {
                return null;
            }
            if (driver instanceof String) {
                Class.forName(driver.toString());
            } else if (driver instanceof Class) {
                driver = ((Class)driver).newInstance();
            }
            Object url = BeanUtil.propertyNvl((Map)params, (String[])new String[]{"url", "jdbc-url"});
            Object user = BeanUtil.propertyNvl((Map)params, (String[])new String[]{"user", "username"});
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.putAll(params);
            map.put("url", url);
            map.put("jdbcUrl", url);
            map.put("driver", driver);
            map.put("driverClass", driver);
            map.put("driverClassName", driver);
            map.put("user", user);
            map.put("username", user);
            DefaultListableBeanFactory factory = (DefaultListableBeanFactory)SpringContextUtil.getApplicationContext().getAutowireCapableBeanFactory();
            BeanDefinitionBuilder ds_builder = BeanDefinitionBuilder.genericBeanDefinition(poolClass);
            List fields = ClassUtil.getFields(poolClass, (boolean)false, (boolean)false);
            for (Field field : fields) {
                String name = field.getName();
                Object value = map.get(name);
                if (null == (value = ConvertAdapter.convert(value, field.getType()))) continue;
                ds_builder.addPropertyValue(name, value);
            }
            AbstractBeanDefinition ds_definition = ds_builder.getBeanDefinition();
            factory.registerBeanDefinition(ds_id, (BeanDefinition)ds_definition);
        }
        catch (Exception e) {
            log.error("[\u6ce8\u518c\u6570\u636e\u6e90\u5931\u8d25][\u6570\u636e\u6e90:{}][msg:{}]", (Object)key, (Object)e.toString());
            return null;
        }
        return ds_id;
    }

    static {
        THREAD_AUTO_RECOVER.set(false);
    }
}

