/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.adapter.init;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.anyline.adapter.DataReader;
import org.anyline.adapter.DataWriter;
import org.anyline.adapter.EntityAdapter;
import org.anyline.adapter.KeyAdapter;
import org.anyline.adapter.init.ConvertAdapter;
import org.anyline.dao.AnylineDao;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.jdbc.ds.DataSourceHolder;
import org.anyline.data.metadata.StandardColumnType;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.prepare.auto.TextPrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.prepare.xml.XMLPrepare;
import org.anyline.data.run.BasicRun;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.run.TableRun;
import org.anyline.data.run.TextRun;
import org.anyline.data.run.XMLRun;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.generator.GeneratorConfig;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.type.ColumnType;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.anyline.util.SQLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;

public abstract class DefaultJDBCAdapter
implements JDBCAdapter {
    protected static final Logger log = LoggerFactory.getLogger(DefaultJDBCAdapter.class);
    protected DatabaseType db;
    public String delimiterFr = "";
    public String delimiterTo = "";
    protected Map<String, ColumnType> types = new Hashtable<String, ColumnType>();
    protected Map<Object, DataReader> readers = new Hashtable<Object, DataReader>();
    protected Map<Object, DataWriter> writers = new Hashtable<Object, DataWriter>();
    @Autowired(required=false)
    protected PrimaryGenerator primaryGenerator;
    protected AnylineDao dao;
    protected Map<String, String> versions = new Hashtable<String, String>();

    @Override
    public AnylineDao getDao() {
        return this.dao;
    }

    @Override
    public void setDao(AnylineDao dao) {
        this.dao = dao;
    }

    @Override
    public String version() {
        return null;
    }

    @Override
    public DatabaseType compatible() {
        return null;
    }

    public DefaultJDBCAdapter() {
        block0: for (StandardColumnType type : StandardColumnType.values()) {
            DatabaseType[] dbs;
            for (DatabaseType db : dbs = type.dbs()) {
                if (db != this.type()) continue;
                this.types.put(type.getName(), type);
                continue block0;
            }
        }
    }

    @Override
    public String getDelimiterFr() {
        return this.delimiterFr;
    }

    @Override
    public String getDelimiterTo() {
        return this.delimiterTo;
    }

    protected PrimaryGenerator checkPrimaryGenerator(DatabaseType type, String table) {
        PrimaryGenerator generator = GeneratorConfig.get((String)table);
        if (null != generator) {
            return generator;
        }
        if (null == this.primaryGenerator) {
            if (null == this.primaryGenerator) {
                this.primaryGenerator = GeneratorConfig.get();
            }
            if (null == this.primaryGenerator) {
                if (ConfigTable.PRIMARY_GENERATOR_SNOWFLAKE_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATORS.SNOWFLAKE;
                } else if (ConfigTable.PRIMARY_GENERATOR_UUID_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATORS.RANDOM;
                } else if (ConfigTable.PRIMARY_GENERATOR_UUID_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATORS.UUID;
                } else if (ConfigTable.PRIMARY_GENERATOR_TIME_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATORS.TIME;
                } else if (ConfigTable.PRIMARY_GENERATOR_TIMESTAMP_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATORS.TIMESTAMP;
                }
            }
        }
        if (null != this.primaryGenerator) {
            return this.primaryGenerator;
        }
        return null;
    }

    public void setDelimiter(String delimiter) {
        if (BasicUtil.isNotEmpty((Object)delimiter)) {
            if ((delimiter = delimiter.replaceAll("\\s", "")).length() == 1) {
                this.delimiterFr = delimiter;
                this.delimiterTo = delimiter;
            } else {
                this.delimiterFr = delimiter.substring(0, 1);
                this.delimiterTo = delimiter.substring(1, 2);
            }
        }
    }

    @Override
    public ColumnType type(String type) {
        if (null == type) {
            return null;
        }
        return this.types.get(type.toUpperCase());
    }

    @Override
    public DataReader reader(Class clazz) {
        if (null == clazz) {
            return null;
        }
        return this.readers.get(clazz);
    }

    @Override
    public DataReader reader(ColumnType type) {
        if (null == type) {
            return null;
        }
        return this.readers.get(type);
    }

    @Override
    public DataWriter writer(Object support) {
        if (null == support) {
            return null;
        }
        return this.writers.get(support);
    }

    @Override
    public Run buildInsertRun(JdbcTemplate template, String dest, Object obj, boolean checkPrimary, List<String> columns) {
        if (null == obj) {
            return null;
        }
        if (null == dest) {
            dest = DataSourceHolder.parseDataSource(dest, obj);
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            if (list.size() > 0) {
                return this.createInsertRunFromCollection(template, dest, list, checkPrimary, columns);
            }
            return null;
        }
        return this.createInsertRun(template, dest, obj, checkPrimary, columns);
    }

    @Override
    public void createInserts(JdbcTemplate template, Run run, String dest, DataSet set, List<String> keys) {
    }

    @Override
    public void createInserts(JdbcTemplate template, Run run, String dest, Collection list, List<String> keys) {
    }

    @Override
    public List<String> confirmInsertColumns(String dest, Object obj, List<String> columns, boolean batch) {
        List<String> keys = new ArrayList<String>();
        if (null == obj) {
            return new ArrayList<String>();
        }
        ArrayList<String> mastKeys = new ArrayList<String>();
        ArrayList<String> ignores = new ArrayList<String>();
        ArrayList<String> factKeys = new ArrayList<String>();
        boolean each = true;
        if (null != columns && columns.size() > 0) {
            each = false;
            keys = new ArrayList();
            for (String column : columns) {
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("+")) {
                    column = column.substring(1);
                    mastKeys.add(column);
                    each = true;
                } else if (column.startsWith("-")) {
                    column = column.substring(1);
                    ignores.add(column);
                    each = true;
                } else if (column.startsWith("?")) {
                    column = column.substring(1);
                    factKeys.add(column);
                    each = true;
                }
                keys.add(column);
            }
        }
        if (each) {
            boolean isInsertNullColumn = false;
            boolean isInsertEmptyColumn = false;
            DataRow row = null;
            if (obj instanceof DataRow) {
                row = (DataRow)obj;
                mastKeys.addAll(row.getUpdateColumns());
                ignores.addAll(row.getIgnoreUpdateColumns());
                keys = row.keys();
                isInsertNullColumn = row.isInsertNullColumn();
                isInsertEmptyColumn = row.isInsertEmptyColumn();
            } else {
                isInsertNullColumn = ConfigTable.IS_INSERT_NULL_FIELD;
                isInsertEmptyColumn = ConfigTable.IS_INSERT_EMPTY_FIELD;
                if (EntityAdapterProxy.hasAdapter()) {
                    keys.addAll(Column.names((LinkedHashMap)EntityAdapterProxy.columns(obj.getClass(), (EntityAdapter.MODE)EntityAdapter.MODE.INSERT)));
                } else {
                    keys = new ArrayList();
                    List fields = ClassUtil.getFields(obj.getClass(), (boolean)false, (boolean)false);
                    for (Field field : fields) {
                        Class<?> clazz = field.getType();
                        if (clazz != String.class && clazz != Date.class && !ClassUtil.isPrimitiveClass(clazz)) continue;
                        keys.add(field.getName());
                    }
                }
            }
            if (batch) {
                isInsertNullColumn = true;
                isInsertEmptyColumn = true;
            }
            if (log.isDebugEnabled()) {
                log.debug("[confirm insert columns][columns:{}]", keys);
            }
            BeanUtil.removeAll(ignores, columns);
            BeanUtil.removeAll(keys, ignores);
            if (log.isDebugEnabled()) {
                log.debug("[confirm insert columns][ignores:{}]", ignores);
            }
            int size = keys.size();
            for (int i = size - 1; i >= 0; --i) {
                String key = keys.get(i);
                if (mastKeys.contains(key)) continue;
                Object value = null;
                value = !(obj instanceof Map) && EntityAdapterProxy.hasAdapter() ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key);
                if (null == value) {
                    if (factKeys.contains(key)) {
                        keys.remove(key);
                        continue;
                    }
                    if (isInsertNullColumn) continue;
                    keys.remove(i);
                    continue;
                }
                if (!"".equals(value.toString().trim())) continue;
                if (factKeys.contains(key)) {
                    keys.remove(key);
                    continue;
                }
                if (isInsertEmptyColumn) continue;
                keys.remove(i);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("[confirm insert columns][result:{}]", keys);
        }
        keys = this.checkMetadata(dest, keys);
        keys = BeanUtil.distinct(keys);
        return keys;
    }

    @Override
    public String batchInsertSeparator() {
        return ",";
    }

    @Override
    public boolean supportInsertPlaceholder() {
        return true;
    }

    protected void setPrimaryValue(Object obj, Object value) {
        if (null == obj) {
            return;
        }
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            row.put(row.getPrimaryKey(), value);
        } else if (EntityAdapterProxy.hasAdapter()) {
            Column key = EntityAdapterProxy.primaryKey(obj.getClass());
            Field field = EntityAdapterProxy.field(obj.getClass(), (Column)key);
            BeanUtil.setFieldValue((Object)obj, (Field)field, (Object)value);
        }
    }

    protected Run createInsertRun(JdbcTemplate template, String dest, Object obj, boolean checkPrimary, List<String> columns) {
        return null;
    }

    protected Run createInsertRunFromCollection(JdbcTemplate template, String dest, Collection list, boolean checkPrimary, List<String> columns) {
        return null;
    }

    @Override
    public String generatedKey() {
        return null;
    }

    @Override
    public Run buildUpdateRun(String dest, Object obj, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        if (null == obj) {
            return null;
        }
        if (null == dest) {
            dest = DataSourceHolder.parseDataSource(null, obj);
        }
        if (!(obj instanceof DataRow) && obj instanceof Map) {
            obj = new DataRow((Map)obj);
        }
        if (obj instanceof DataRow) {
            return this.buildUpdateRunFromDataRow(dest, (DataRow)obj, configs, checkPrimary, columns);
        }
        return this.buildUpdateRunFromEntity(dest, obj, configs, checkPrimary, columns);
    }

    protected Run buildUpdateRunFromEntity(String dest, Object obj, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        return null;
    }

    protected Run buildUpdateRunFromDataRow(String dest, DataRow row, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        return null;
    }

    public List<String> checkMetadata(String table, List<String> columns) {
        if (!ConfigTable.IS_AUTO_CHECK_METADATA || null == this.dao) {
            return columns;
        }
        ArrayList<String> list = new ArrayList<String>();
        Set<String> metadatas = this.dao.columns(table).keySet();
        if (metadatas.size() > 0) {
            for (String item : columns) {
                if (metadatas.contains(item.toUpperCase())) {
                    list.add(item);
                    continue;
                }
                log.warn("[{}][column:{}.{}][insert/update\u5ffd\u7565\u5f53\u524d\u5217\u540d]", new Object[]{LogUtil.format((String)"\u5217\u540d\u68c0\u6d4b\u4e0d\u5b58\u5728", (int)33), table, item});
            }
        } else {
            log.warn("[{}][table:{}][\u5ffd\u7565\u5217\u540d\u68c0\u6d4b]", (Object)LogUtil.format((String)"\u8868\u7ed3\u6784\u68c0\u6d4b\u5931\u8d25(\u68c0\u67e5\u8868\u540d\u662f\u5426\u5b58\u5728)", (int)33), (Object)table);
        }
        log.info("[check column metadata][src:{}][result:{}]", (Object)columns.size(), (Object)list.size());
        return list;
    }

    protected List<String> confirmUpdateColumns(String dest, DataRow row, ConfigStore configs, List<String> columns) {
        ArrayList<String> keys = null;
        if (null == row) {
            return new ArrayList<String>();
        }
        boolean each = true;
        ArrayList conditions = new ArrayList();
        List masters = BeanUtil.copy((Collection)row.getUpdateColumns());
        List ignores = BeanUtil.copy((Collection)row.getIgnoreUpdateColumns());
        ArrayList<String> factKeys = new ArrayList<String>();
        BeanUtil.removeAll((List)ignores, columns);
        if (null != columns && columns.size() > 0) {
            each = false;
            keys = new ArrayList();
            for (String column : columns) {
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("+")) {
                    column = column.substring(1);
                    masters.add(column);
                    each = true;
                } else if (column.startsWith("-")) {
                    column = column.substring(1);
                    ignores.add(column);
                    each = true;
                } else if (column.startsWith("?")) {
                    column = column.substring(1);
                    factKeys.add(column);
                    each = true;
                }
                keys.add(column);
            }
        } else if (null != masters && masters.size() > 0) {
            each = false;
            keys = masters;
        }
        if (each) {
            keys = row.keys();
            for (String k : masters) {
                if (keys.contains(k)) continue;
                keys.add(k);
            }
            boolean isUpdateNullColumn = row.isUpdateNullColumn();
            boolean isUpdateEmptyColumn = row.isUpdateEmptyColumn();
            BeanUtil.removeAll(keys, (List)ignores);
            int size = keys.size();
            for (int i = size - 1; i >= 0; --i) {
                String key = (String)keys.get(i);
                if (masters.contains(key)) continue;
                Object value = row.get(key);
                if (null == value) {
                    if (factKeys.contains(key)) {
                        keys.remove(key);
                        continue;
                    }
                    if (isUpdateNullColumn) continue;
                    keys.remove(i);
                    continue;
                }
                if (!"".equals(value.toString().trim())) continue;
                if (factKeys.contains(key)) {
                    keys.remove(key);
                    continue;
                }
                if (isUpdateEmptyColumn) continue;
                keys.remove(i);
            }
        }
        keys.removeAll(ignores);
        keys = this.checkMetadata(dest, keys);
        keys = BeanUtil.distinct(keys);
        return keys;
    }

    @Override
    public Run buildQueryRun(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        BasicRun run = null;
        if (prepare instanceof TablePrepare) {
            run = new TableRun(this, prepare.getTable());
        } else if (prepare instanceof XMLPrepare) {
            run = new XMLRun();
        } else if (prepare instanceof TextPrepare) {
            run = new TextRun();
        }
        if (null != run) {
            run.setAdapter(this);
            run.setPrepare(prepare);
            run.setConfigStore(configs);
            run.addCondition(conditions);
            if (run.checkValid()) {
                run.init();
                this.buildQueryRunContent(run);
            }
        }
        return run;
    }

    @Override
    public void buildQueryRunContent(Run run) {
        if (null != run) {
            if (run instanceof TableRun) {
                TableRun r = (TableRun)run;
                this.buildQueryRunContent(r);
            } else if (run instanceof XMLRun) {
                XMLRun r = (XMLRun)run;
                this.buildQueryRunContent(r);
            } else if (run instanceof TextRun) {
                TextRun r = (TextRun)run;
                this.buildQueryRunContent(r);
            }
        }
    }

    protected void buildQueryRunContent(XMLRun run) {
    }

    protected void buildQueryRunContent(TextRun run) {
    }

    protected void buildQueryRunContent(TableRun run) {
    }

    @Override
    public List<Run> buildQuerySequence(boolean next, String ... names) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQuerySequence(boolean next, String ... names)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public void buildExecuteRunContent(Run run) {
        if (null != run) {
            if (run instanceof TableRun) {
                TableRun r = (TableRun)run;
                this.buildExecuteRunContent(r);
            } else if (run instanceof XMLRun) {
                XMLRun r = (XMLRun)run;
                this.buildExecuteRunContent(r);
            } else if (run instanceof TextRun) {
                TextRun r = (TextRun)run;
                this.buildExecuteRunContent(r);
            }
        }
    }

    protected void buildExecuteRunContent(XMLRun run) {
    }

    protected void buildExecuteRunContent(TextRun run) {
    }

    protected void buildExecuteRunContent(TableRun run) {
    }

    @Override
    public List<Map<String, Object>> process(List<Map<String, Object>> list) {
        return list;
    }

    @Override
    public Run buildExecuteRun(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        BasicRun run = null;
        if (prepare instanceof XMLPrepare) {
            run = new XMLRun();
        } else if (prepare instanceof TextPrepare) {
            run = new TextRun();
        }
        if (null != run) {
            run.setAdapter(this);
            run.setPrepare(prepare);
            run.setConfigStore(configs);
            run.addCondition(conditions);
            run.init();
            this.buildQueryRunContent(run);
        }
        return run;
    }

    @Override
    public String parseExists(Run run) {
        return null;
    }

    @Override
    public String parseTotalQuery(Run run) {
        return null;
    }

    @Override
    public Run buildDeleteRun(String table, String key, Object values) {
        return this.createDeleteRunSQLFromTable(table, key, values);
    }

    @Override
    public Run buildDeleteRun(String dest, Object obj, String ... columns) {
        if (null == obj) {
            return null;
        }
        Run run = null;
        if (null == dest) {
            dest = DataSourceHolder.parseDataSource(dest, obj);
        }
        if (null == dest) {
            Table table;
            Object entity = obj;
            if (obj instanceof Collection) {
                entity = ((Collection)obj).iterator().next();
            }
            if (EntityAdapterProxy.hasAdapter() && null != (table = EntityAdapterProxy.table(entity.getClass()))) {
                dest = table.getName();
            }
        }
        if (obj instanceof ConfigStore) {
            run = new TableRun(this, dest);
            DefaultTablePrepare prepare = new DefaultTablePrepare();
            prepare.setDataSource(dest);
            run.setPrepare(prepare);
            run.setConfigStore((ConfigStore)obj);
            run.addCondition(columns);
            run.init();
            this.buildDeleteRunContent(run);
        } else {
            run = this.createDeleteRunSQLFromEntity(dest, obj, columns);
        }
        return run;
    }

    @Override
    public Run buildDeleteRunContent(Run run) {
        if (null != run && run instanceof TableRun) {
            TableRun r = (TableRun)run;
            return this.buildDeleteRunContent(r);
        }
        return run;
    }

    protected Run buildDeleteRunContent(TableRun run) {
        return null;
    }

    protected Run createDeleteRunSQLFromTable(String table, String key, Object values) {
        return null;
    }

    protected Run createDeleteRunSQLFromEntity(String dest, Object obj, String ... columns) {
        return null;
    }

    @Override
    public List<Run> buildTruncateSQL(String table) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("TRUNCATE TABLE ");
        SQLUtil.delimiter((StringBuilder)builder, (String)table, (String)this.delimiterFr, (String)this.delimiterTo);
        return runs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkSchema(DataSource dataSource, Table table) {
        if (null == table || null != table.getCheckSchemaTime()) {
            return;
        }
        Connection con = null;
        try {
            if (null == table.getCatalog() || null == table.getSchema()) {
                con = DataSourceUtils.getConnection((DataSource)dataSource);
                this.checkSchema(con, table);
            }
        }
        catch (Exception e) {
            log.warn("[check schema][fail:{}]", (Object)e.toString());
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)dataSource)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)dataSource);
            }
        }
    }

    @Override
    public void checkSchema(Connection con, Table table) {
        try {
            if (null == table.getCatalog()) {
                table.setCatalog(con.getCatalog());
            }
            if (null == table.getSchema()) {
                table.setSchema(con.getSchema());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        table.setCheckSchemaTime(new Date());
    }

    @Override
    public List<Run> buildQueryDatabaseRunSQL() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDatabaseRunSQL()"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public LinkedHashMap<String, Database> databases(int index, boolean create, LinkedHashMap<String, Database> databases, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Database> databases(int index, boolean create, LinkedHashMap<String, Database> databases, DataSet set)"), (int)37));
        }
        return new LinkedHashMap<String, Database>();
    }

    @Override
    public List<Run> buildQueryTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryTableRunSQL(String catalog, String schema, String pattern, String types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryTableCommentRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryTableCommentRunSQL(String catalog, String schema, String pattern, String types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Table> LinkedHashMap<String, T> tables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(boolean create, LinkedHashMap<String, T> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        ResultSet set = dbmd.getTables(catalog, schema, pattern, types);
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        Map<String, Integer> keys = this.keys(set);
        while (set.next()) {
            String tableName = this.string(keys, "TABLE_NAME", set);
            if (BasicUtil.isEmpty((Object)tableName)) {
                tableName = this.string(keys, "NAME", set);
            }
            if (BasicUtil.isEmpty((Object)tableName)) continue;
            Table table = (Table)tables.get(tableName.toUpperCase());
            if (null == table) {
                if (!create) continue;
                table = new Table();
                tables.put(tableName.toUpperCase(), table);
            }
            table.setCatalog((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CAT", set), catalog}));
            table.setSchema((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_SCHEM", set), schema}));
            table.setName(tableName);
            table.setType((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_TYPE", set), table.getType()}));
            table.setComment((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REMARKS", set), table.getComment()}));
            table.setTypeCat((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_CAT", set), table.getTypeCat()}));
            table.setTypeName((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_NAME", set), table.getTypeName()}));
            table.setSelfReferencingColumn((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "SELF_REFERENCING_COL_NAME", set), table.getSelfReferencingColumn()}));
            table.setRefGeneration((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REF_GENERATION", set), table.getRefGeneration()}));
            tables.put(tableName.toUpperCase(), table);
        }
        return tables;
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> comments(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        for (DataRow row : set) {
            Table table;
            String name = row.getString("TABLE_NAME");
            String comment = row.getString("TABLE_COMMENT");
            if (null == name || null == comment || null == (table = (Table)tables.get(name.toUpperCase()))) continue;
            table.setComment(comment);
        }
        return tables;
    }

    @Override
    public List<Run> buildQueryViewRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryViewRunSQL(String catalog, String schema, String pattern, String types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> views, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends View> LinkedHashMap<String, T> views(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> views, DataSet set)"), (int)37));
        }
        if (null == views) {
            views = new LinkedHashMap();
        }
        return views;
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(boolean create, LinkedHashMap<String, T> views, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        ResultSet set = dbmd.getTables(catalog, schema, pattern, new String[]{"VIEW"});
        if (null == views) {
            views = new LinkedHashMap();
        }
        Map<String, Integer> keys = this.keys(set);
        while (set.next()) {
            String viewName = this.string(keys, "TABLE_NAME", set);
            if (BasicUtil.isEmpty((Object)viewName)) {
                viewName = this.string(keys, "NAME", set);
            }
            if (BasicUtil.isEmpty((Object)viewName)) continue;
            View view = (View)views.get(viewName.toUpperCase());
            if (null == view) {
                if (!create) continue;
                view = new View();
                views.put(viewName.toUpperCase(), view);
            }
            view.setCatalog((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CAT", set), catalog}));
            view.setSchema((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_SCHEM", set), schema}));
            view.setName(viewName);
            view.setType((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_TYPE", set), view.getType()}));
            view.setComment((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REMARKS", set), view.getComment()}));
            view.setTypeCat((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_CAT", set), view.getTypeCat()}));
            view.setTypeName((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_NAME", set), view.getTypeName()}));
            view.setSelfReferencingColumn((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "SELF_REFERENCING_COL_NAME", set), view.getSelfReferencingColumn()}));
            view.setRefGeneration((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REF_GENERATION", set), view.getRefGeneration()}));
            views.put(viewName.toUpperCase(), view);
        }
        return views;
    }

    @Override
    public List<Run> buildQueryMasterTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryMasterTableRunSQL(String catalog, String schema, String pattern, String types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean create, LinkedHashMap<String, T> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends MasterTable> LinkedHashMap<String, T> mtables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public List<Run> buildQueryPartitionTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPartitionTableRunSQL(String catalog, String schema, String pattern, String types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPartitionTableRunSQL(MasterTable master, Map<String,Object> tags)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags, String name) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPartitionTableRunSQL(MasterTable master, Map<String,Object> tags, String name)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, PartitionTable> ptables(int total, int index, boolean create, MasterTable table, String catalog, String schema, LinkedHashMap<String, PartitionTable> tables, DataSet set)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean create, LinkedHashMap<String, T> tables, DatabaseMetaData dbmd, String catalog, String schema, MasterTable master) throws Exception {
        return tables;
    }

    @Override
    public List<Run> buildQueryColumnRunSQL(Table table, boolean metadata) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryColumnRunSQL(Table table, boolean metadata)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Integer len;
            String name = row.getString("COLUMN_NAME");
            Column column = (Column)columns.get(name.toUpperCase());
            if (null == column) {
                column = new Column();
            }
            column.setCatalog((String)BasicUtil.evl((Object[])new String[]{row.getString("TABLE_CATALOG"), table.getCatalog(), column.getCatalog()}));
            column.setSchema((String)BasicUtil.evl((Object[])new String[]{row.getString("TABLE_SCHEMA"), table.getSchema(), column.getSchema()}));
            column.setTable(table);
            column.setTable((String)BasicUtil.evl((Object[])new String[]{row.getString("TABLE_NAME"), table.getName(), column.getTableName(true)}));
            column.setName(name);
            if (null == column.getPosition()) {
                column.setPosition(row.getInt("ORDINAL_POSITION", null));
            }
            column.setComment((String)BasicUtil.evl((Object[])new String[]{row.getString(new String[]{"COLUMN_COMMENT", "COMMENTS"}), column.getComment()}));
            column.setTypeName((String)BasicUtil.evl((Object[])new String[]{row.getString("DATA_TYPE"), column.getTypeName()}));
            String def = BasicUtil.evl((Object[])new Object[]{row.get(new String[]{"COLUMN_DEFAULT", "DATA_DEFAULT"}), column.getDefaultValue()}) + "";
            if (BasicUtil.isNotEmpty((Object)def)) {
                while (def.startsWith("(") && def.endsWith(")")) {
                    def = def.substring(1, def.length() - 1);
                }
                column.setDefaultValue((Object)def);
            }
            if (-1 == column.isAutoIncrement()) {
                column.setAutoIncrement(row.getBoolean("IS_IDENTITY", null));
            }
            if (-1 == column.isAutoIncrement()) {
                column.setAutoIncrement(row.getBoolean("IS_AUTOINCREMENT", null));
            }
            if (-1 == column.isAutoIncrement() && row.getStringNvl("EXTRA", new String[0]).toLowerCase().contains("auto_increment")) {
                column.setAutoIncrement(Boolean.valueOf(true));
            }
            if (-1 == column.isNullable()) {
                column.setNullable(row.getBoolean(new String[]{"IS_NULLABLE", "NULLABLE"}));
            }
            if (null == (len = row.getInt(new String[]{"NUMERIC_PRECISION", "PRECISION", "DATA_PRECISION"}))) {
                len = row.getInt(new String[]{"CHARACTER_MAXIMUM_LENGTH", "MAX_LENGTH", "DATA_LENGTH"});
            }
            column.setPrecision(len);
            if (null == column.getScale()) {
                column.setScale(row.getInt(new String[]{"NUMERIC_SCALE", "SCALE", "DATA_SCALE"}));
            }
            if (null == column.getCharset()) {
                column.setCharset(row.getString("CHARACTER_SET_NAME"));
            }
            if (null == column.getCollate()) {
                column.setCollate(row.getString("COLLATION_NAME"));
            }
            if (null == column.getColumnType()) {
                ColumnType columnType = this.type(column.getTypeName());
                column.setColumnType(columnType);
            }
            columns.put(name.toUpperCase(), column);
        }
        return columns;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(boolean create, LinkedHashMap<String, T> columns, Table table, SqlRowSet set) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        SqlRowSetMetaData rsm = set.getMetaData();
        for (int i = 1; i <= rsm.getColumnCount(); ++i) {
            Column column;
            String name = rsm.getColumnName(i);
            if (BasicUtil.isEmpty((Object)name) || null != (column = (Column)columns.get(name.toUpperCase())) || !create) continue;
            if (BasicUtil.isEmpty((Object)(column = this.column(column, rsm, i)).getName())) {
                column.setName(name);
            }
            columns.put(column.getName().toUpperCase(), column);
        }
        return columns;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(boolean create, LinkedHashMap<String, T> columns, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        String catalog = table.getCatalog();
        String schema = table.getSchema();
        ResultSet set = dbmd.getColumns(catalog, schema, table.getName(), pattern);
        Map<String, Integer> keys = this.keys(set);
        while (set.next()) {
            String remark;
            String name = set.getString("COLUMN_NAME");
            if (null == name) continue;
            String columnCatalog = this.string(keys, "TABLE_CAT", set, null);
            String columnSchema = this.string(keys, "TABLE_SCHEM", set, null);
            if (!BasicUtil.equalsIgnoreCase((Object)catalog, (Object)columnCatalog) || !BasicUtil.equalsIgnoreCase((Object)schema, (Object)columnSchema)) continue;
            Column column = (Column)columns.get(name.toUpperCase());
            if (null == column) {
                if (!create) continue;
                column = new Column(name);
                columns.put(name.toUpperCase(), column);
            }
            if ("TAG".equals(remark = this.string(keys, "REMARKS", set, column.getComment()))) {
                column = new Tag();
            }
            column.setCatalog(columnCatalog);
            column.setSchema(columnSchema);
            column.setComment(remark);
            column.setTable((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_NAME", set, table.getName()), column.getTableName(true)}));
            column.setType(this.integer(keys, "DATA_TYPE", set, column.getType()));
            column.setType(this.integer(keys, "SQL_DATA_TYPE", set, column.getType()));
            String jdbcType = this.string(keys, "TYPE_NAME", set, column.getTypeName());
            if (BasicUtil.isEmpty((Object)column.getTypeName())) {
                column.setTypeName(jdbcType);
            }
            column.setJdbcType(jdbcType);
            column.setPrecision(this.integer(keys, "COLUMN_SIZE", set, column.getPrecision()));
            column.setScale(this.integer(keys, "DECIMAL_DIGITS", set, column.getScale()));
            column.setNullable(this.bool(keys, "NULLABLE", set, column.isNullable()));
            column.setDefaultValue(this.value(keys, "COLUMN_DEF", set, column.getDefaultValue()));
            column.setPosition(this.integer(keys, "ORDINAL_POSITION", set, column.getPosition()));
            column.setAutoIncrement(this.bool(keys, "IS_AUTOINCREMENT", set, column.isAutoIncrement()));
            ColumnType columnType = this.type(column.getTypeName());
            column.setColumnType(columnType);
            this.column(column, set);
            column.setName(name);
        }
        ResultSet rs = dbmd.getPrimaryKeys(table.getCatalog(), table.getSchema(), table.getName());
        while (rs.next()) {
            String name = rs.getString(4);
            Column column = (Column)columns.get(name.toUpperCase());
            if (null == column) continue;
            column.setPrimaryKey(Boolean.valueOf(true));
        }
        return columns;
    }

    @Override
    public Column column(Column column, ResultSet rs) {
        if (null == column) {
            column = new Column();
        }
        try {
            Map<String, Integer> keys = this.keys(rs);
            if (null == column.getName()) {
                column.setName(this.string(keys, "COLUMN_NAME", rs));
            }
            if (null == column.getType()) {
                column.setType(BasicUtil.parseInt((Object)this.string(keys, "DATA_TYPE", rs), null));
            }
            if (null == column.getType()) {
                column.setType(BasicUtil.parseInt((Object)this.string(keys, "SQL_DATA_TYPE", rs), null));
            }
            if (null == column.getTypeName()) {
                String jdbcType = this.string(keys, "TYPE_NAME", rs);
                column.setJdbcType(jdbcType);
                if (BasicUtil.isEmpty((Object)column.getTypeName())) {
                    column.setTypeName(jdbcType);
                }
            }
            if (null == column.getPrecision()) {
                column.setPrecision(this.integer(keys, "COLUMN_SIZE", rs, null));
            }
            if (null == column.getScale()) {
                column.setScale(BasicUtil.parseInt((Object)this.string(keys, "DECIMAL_DIGITS", rs), null));
            }
            if (null == column.getPosition()) {
                column.setPosition(BasicUtil.parseInt((Object)this.string(keys, "ORDINAL_POSITION", rs), (Integer)0));
            }
            if (-1 == column.isAutoIncrement()) {
                column.setAutoIncrement(BasicUtil.parseBoolean((Object)this.string(keys, "IS_AUTOINCREMENT", rs), (Boolean)false));
            }
            if (-1 == column.isGenerated()) {
                column.setGenerated(BasicUtil.parseBoolean((Object)this.string(keys, "IS_GENERATEDCOLUMN", rs), (Boolean)false));
            }
            if (null == column.getComment()) {
                column.setComment(this.string(keys, "REMARKS", rs));
            }
            if (null == column.getPosition()) {
                column.setPosition(BasicUtil.parseInt((Object)this.string(keys, "ORDINAL_POSITION", rs), (Integer)0));
            }
            if (BasicUtil.isEmpty((Object)column.getDefaultValue())) {
                column.setDefaultValue((Object)this.string(keys, "COLUMN_DEF", rs));
            }
            ColumnType columnType = this.type(column.getTypeName());
            column.setColumnType(columnType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return column;
    }

    @Override
    public Column column(Column column, SqlRowSetMetaData rsm, int index) {
        if (null == column) {
            column = new Column();
            try {
                column.setCatalog((String)BasicUtil.evl((Object[])new String[]{rsm.getCatalogName(index)}));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getCatalogName]");
            }
            try {
                column.setSchema((String)BasicUtil.evl((Object[])new String[]{rsm.getSchemaName(index)}));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getSchemaName]");
            }
            try {
                column.setClassName(rsm.getColumnClassName(index));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnClassName]");
            }
            try {
                column.setCurrency(Boolean.valueOf(rsm.isCurrency(index)));
            }
            catch (Exception e) {
                column.setCaseSensitive(Boolean.valueOf(rsm.isCaseSensitive(index)));
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isCurrency]");
            }
            try {
                column.setOriginalName(rsm.getColumnName(index));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnName]");
            }
            try {
                column.setName(rsm.getColumnLabel(index));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnLabel]");
            }
            try {
                column.setPrecision(Integer.valueOf(rsm.getPrecision(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getPrecision]");
            }
            try {
                column.setScale(Integer.valueOf(rsm.getScale(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getScale]");
            }
            try {
                column.setDisplaySize(Integer.valueOf(rsm.getColumnDisplaySize(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnDisplaySize]");
            }
            try {
                column.setSigned(Boolean.valueOf(rsm.isSigned(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isSigned]");
            }
            try {
                column.setTable(rsm.getTableName(index));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getTableName]");
            }
            try {
                column.setType(Integer.valueOf(rsm.getColumnType(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnType]");
            }
            try {
                String jdbcType = rsm.getColumnTypeName(index);
                column.setJdbcType(jdbcType);
                if (BasicUtil.isEmpty((Object)column.getTypeName())) {
                    column.setTypeName(jdbcType);
                }
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnTypeName]");
            }
            ColumnType columnType = this.type(column.getTypeName());
            column.setColumnType(columnType);
        }
        return column;
    }

    @Override
    public Column column(Column column, ResultSetMetaData rsm, int index) {
        if (null == column) {
            column = new Column();
        }
        try {
            column.setCatalog((String)BasicUtil.evl((Object[])new String[]{rsm.getCatalogName(index)}));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getCatalogName]");
        }
        try {
            column.setSchema((String)BasicUtil.evl((Object[])new String[]{rsm.getSchemaName(index)}));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getSchemaName]");
        }
        try {
            column.setClassName(rsm.getColumnClassName(index));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnClassName]");
        }
        try {
            column.setCaseSensitive(Boolean.valueOf(rsm.isCaseSensitive(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isCaseSensitive]");
        }
        try {
            column.setCurrency(Boolean.valueOf(rsm.isCurrency(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isCurrency]");
        }
        try {
            column.setOriginalName(rsm.getColumnName(index));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnName]");
        }
        try {
            column.setName(rsm.getColumnLabel(index));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnLabel]");
        }
        try {
            column.setPrecision(Integer.valueOf(rsm.getPrecision(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getPrecision]");
        }
        try {
            column.setScale(Integer.valueOf(rsm.getScale(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getScale]");
        }
        try {
            column.setDisplaySize(Integer.valueOf(rsm.getColumnDisplaySize(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnDisplaySize]");
        }
        try {
            column.setSigned(Boolean.valueOf(rsm.isSigned(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isSigned]");
        }
        try {
            column.setTable(rsm.getTableName(index));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getTableName]");
        }
        try {
            column.setType(Integer.valueOf(rsm.getColumnType(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnType]");
        }
        try {
            String jdbcType = rsm.getColumnTypeName(index);
            column.setJdbcType(jdbcType);
            if (BasicUtil.isEmpty((Object)column.getTypeName())) {
                column.setTypeName(jdbcType);
            }
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnTypeName]");
        }
        ColumnType columnType = this.type(column.getTypeName());
        column.setColumnType(columnType);
        return column;
    }

    protected Map<String, Integer> keys(ResultSet set) throws Exception {
        ResultSetMetaData rsmd = set.getMetaData();
        HashMap<String, Integer> keys = new HashMap<String, Integer>();
        if (null != rsmd) {
            for (int i = 1; i < rsmd.getColumnCount(); ++i) {
                keys.put(rsmd.getColumnLabel(i).toUpperCase(), i);
            }
        }
        return keys;
    }

    @Override
    public List<Run> buildQueryTagRunSQL(Table table, boolean metadata) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryTagRunSQL(Table table, boolean metadata)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Tag> LinkedHashMap<String, T> tags(int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set)"), (int)37));
        }
        if (null == tags) {
            tags = new LinkedHashMap();
        }
        return tags;
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(boolean create, Table table, LinkedHashMap<String, T> tags, SqlRowSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Tag> LinkedHashMap<String, T> tags(boolean create, Table table, LinkedHashMap<String, T> tags, SqlRowSet set)"), (int)37));
        }
        if (null == tags) {
            tags = new LinkedHashMap();
        }
        return tags;
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(boolean create, LinkedHashMap<String, T> tags, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Tag> LinkedHashMap<String, T> tags(boolean create, LinkedHashMap<String, T> tags, DatabaseMetaData dbmd, Table table, String pattern)"), (int)37));
        }
        if (null == tags) {
            tags = new LinkedHashMap();
        }
        return tags;
    }

    @Override
    public List<Run> buildQueryPrimaryRunSQL(Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPrimaryRunSQL(Table table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public PrimaryKey primary(int index, Table table, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 PrimaryKey primary(int index, Table table, DataSet set)"), (int)37));
        }
        return null;
    }

    @Override
    public List<Run> buildQueryForeignsRunSQL(Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryForeignsRunSQL(Table table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends ForeignKey> LinkedHashMap<String, T> foreigns(int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<Run> buildQueryIndexRunSQL(Table table, String name) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryIndexRunSQL(Table table, String name)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Index> LinkedHashMap<String, T> indexs(int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set)"), (int)37));
        }
        if (null == indexs) {
            indexs = new LinkedHashMap();
        }
        return indexs;
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(boolean create, Table table, LinkedHashMap<String, T> indexs, SqlRowSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Index> LinkedHashMap<String, T> indexs(boolean create, Table table, LinkedHashMap<String, T> indexs, SqlRowSet set)"), (int)37));
        }
        if (null == indexs) {
            indexs = new LinkedHashMap();
        }
        return indexs;
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(boolean create, LinkedHashMap<String, T> indexs, DatabaseMetaData dbmd, Table table, boolean unique, boolean approximate) throws Exception {
        if (null == indexs) {
            indexs = new LinkedHashMap();
        }
        ResultSet set = dbmd.getIndexInfo(table.getCatalog(), table.getSchema(), table.getName(), unique, approximate);
        Map<String, Integer> keys = this.keys(set);
        LinkedHashMap<String, Column> columns = null;
        while (set.next()) {
            String name = this.string(keys, "INDEX_NAME", set);
            if (null == name) continue;
            Index index = (Index)indexs.get(name.toUpperCase());
            if (null == index) {
                if (!create) continue;
                index = new Index();
                indexs.put(name.toUpperCase(), index);
                index.setName(this.string(keys, "INDEX_NAME", set));
                index.setUnique(this.bool(keys, "NON_UNIQUE", set, false) == false);
                index.setCatalog((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CAT", set), table.getCatalog()}));
                index.setSchema((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_SCHEM", set), table.getSchema()}));
                index.setTable(this.string(keys, "TABLE_NAME", set));
                indexs.put(name.toUpperCase(), index);
                columns = new LinkedHashMap<String, Column>();
                index.setColumns(columns);
                if (name.equalsIgnoreCase("PRIMARY")) {
                    index.setCluster(true);
                    index.setPrimary(true);
                } else if (name.equalsIgnoreCase("PK_" + table.getName())) {
                    index.setCluster(true);
                    index.setPrimary(true);
                }
            } else {
                columns = index.getColumns();
            }
            String columnName = this.string(keys, "COLUMN_NAME", set);
            Column col = table.getColumn(columnName.toUpperCase());
            Column column = null;
            if (null != col) {
                column = col.clone();
            } else {
                column = new Column();
                column.setName(columnName);
            }
            String order = this.string(keys, "ASC_OR_DESC", set);
            order = null != order && order.startsWith("D") ? "DESC" : "ASC";
            column.setOrder(order);
            column.setPosition(this.integer(keys, "ORDINAL_POSITION", set, null));
            columns.put(column.getName().toUpperCase(), column);
        }
        return indexs;
    }

    @Override
    public List<Run> buildQueryConstraintRunSQL(Table table, boolean metadata) throws Exception {
        log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryConstraintRunSQL(Table table, boolean metadata)"), (int)37));
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(int constraint, boolean create, Table table, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Constraint> constraints(int constraint, boolean create,  Table table, LinkedHashMap<String, Constraint> constraints, DataSet set)"), (int)37));
        }
        if (null == constraints) {
            constraints = new LinkedHashMap();
        }
        return constraints;
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean create, Table table, LinkedHashMap<String, T> constraints, SqlRowSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Constraint> LinkedHashMap<String, T> constraints(boolean create, Table table, LinkedHashMap<String, T> constraints, SqlRowSet set)"), (int)37));
        }
        if (null == constraints) {
            constraints = new LinkedHashMap();
        }
        return constraints;
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean create, Table table, LinkedHashMap<String, T> constraints, ResultSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Constraint> LinkedHashMap<String, T> constraints(boolean create, Table table, LinkedHashMap<String, T> constraints, ResultSet set)"), (int)37));
        }
        if (null == constraints) {
            constraints = new LinkedHashMap();
        }
        return constraints;
    }

    @Override
    public List<Run> buildQueryTriggerRunSQL(Table table, List<Trigger.EVENT> events) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 buildQueryTriggerRunSQL(Table table, List<Trigger.EVENT> events)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Trigger> LinkedHashMap<String, T> triggers(int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set)"), (int)37));
        }
        if (null == triggers) {
            this.readers = new LinkedHashMap<Object, DataReader>();
        }
        return triggers;
    }

    @Override
    public List<Run> buildQueryProcedureRunSQL(String catalog, String schema, String name) {
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(int index, boolean create, LinkedHashMap<String, T> procedures, DataSet set) throws Exception {
        return new LinkedHashMap();
    }

    @Override
    public List<Run> buildQueryFunctionRunSQL(String catalog, String schema, String name) {
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(int index, boolean create, LinkedHashMap<String, T> functions, DataSet set) throws Exception {
        return new LinkedHashMap();
    }

    @Override
    public List<Run> buildCreateRunSQL(Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE ").append(table.getKeyword()).append(" ");
        this.checkTableExists(builder, false);
        this.name(builder, table);
        LinkedHashMap columMap = table.getColumns();
        Collection columns = null;
        List pks = table.primarys();
        if (null != columMap && null != (columns = columMap.values()) && columns.size() > 0) {
            builder.append("(\n");
            int idx = 0;
            for (Object column : columns) {
                builder.append("\t");
                if (idx > 0) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
                this.define(builder, (Column)column).append("\n");
                ++idx;
            }
            builder.append("\t");
            if (pks.size() == 1) {
                this.primary(builder, table);
            }
            builder.append(")");
        }
        this.comment(builder, table);
        List<Run> tableComment = this.buildAddCommentRunSQL(table);
        if (null != tableComment) {
            runs.addAll(tableComment);
        }
        if (null != columns) {
            for (Object column : columns) {
                List<Run> columnComment = this.buildAddCommentRunSQL((Column)column);
                if (null == columnComment) continue;
                runs.addAll(columnComment);
            }
        }
        if (pks.size() > 1) {
            PrimaryKey primary = new PrimaryKey();
            primary.setTable(table);
            for (Column col : pks) {
                primary.addColumn(col);
            }
            List<Run> pksql = this.buildAddRunSQL(primary);
            if (null != pksql) {
                runs.addAll(pksql);
            }
        }
        return runs;
    }

    @Override
    public List<Run> buildAddCommentRunSQL(Table table) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRunSQL(Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRunSQL(Table table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRunSQL(Table table, Collection<Column> columns) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        for (Column column : columns) {
            String action = column.getAction();
            if ("add".equalsIgnoreCase(action)) {
                runs.addAll(this.buildAddRunSQL(column, false));
                continue;
            }
            if ("alter".equalsIgnoreCase(action)) {
                runs.addAll(this.buildAlterRunSQL(column, false));
                continue;
            }
            if (!"drop".equalsIgnoreCase(action)) continue;
            runs.addAll(this.buildDropRunSQL(column, false));
        }
        return runs;
    }

    @Override
    public List<Run> buildRenameRunSQL(Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRunSQL(Table table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRunSQL(Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRunSQL(Table table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRunSQL(Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        String catalog = table.getCatalog();
        String schema = table.getSchema();
        builder.append("DROP ").append(table.getKeyword()).append(" ");
        this.checkTableExists(builder, true);
        this.name(builder, table);
        return runs;
    }

    @Override
    public StringBuilder checkTableExists(StringBuilder builder, boolean exists) {
        builder.append(" IF ");
        if (!exists) {
            builder.append("NOT ");
        }
        builder.append("EXISTS ");
        return builder;
    }

    @Override
    public StringBuilder primary(StringBuilder builder, Table table) {
        List pks = table.primarys();
        if (pks.size() > 0) {
            builder.append(",PRIMARY KEY (");
            boolean first = true;
            for (Column pk : pks) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)pk.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                first = false;
            }
            builder.append(")");
        }
        return builder;
    }

    @Override
    public StringBuilder comment(StringBuilder builder, Table table) {
        String comment = table.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            builder.append(" COMMENT'").append(comment).append("'");
        }
        return builder;
    }

    @Override
    public StringBuilder name(StringBuilder builder, Table table) {
        String catalog = table.getCatalog();
        String schema = table.getSchema();
        String name = table.getName();
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)name, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return builder;
    }

    @Override
    public List<Run> buildCreateRunSQL(View view) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE VIEW ");
        this.name(builder, (Table)view);
        builder.append(" AS \n").append(view.getDefinition());
        runs.addAll(this.buildAddCommentRunSQL(view));
        return runs;
    }

    @Override
    public List<Run> buildAddCommentRunSQL(View view) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRunSQL(View view) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER VIEW ");
        this.name(builder, (Table)view);
        builder.append(" AS \n").append(view.getDefinition());
        return runs;
    }

    @Override
    public List<Run> buildRenameRunSQL(View view) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRunSQL(View view)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRunSQL(View view) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRunSQL(View view)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRunSQL(View view) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP ").append(view.getKeyword()).append(" ");
        this.checkViewExists(builder, true);
        this.name(builder, (Table)view);
        return runs;
    }

    @Override
    public StringBuilder checkViewExists(StringBuilder builder, boolean exists) {
        builder.append(" IF ");
        if (!exists) {
            builder.append("NOT ");
        }
        builder.append("EXISTS ");
        return builder;
    }

    @Override
    public StringBuilder comment(StringBuilder builder, View view) {
        return builder;
    }

    @Override
    public List<Run> buildCreateRunSQL(MasterTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRunSQL(MasterTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAddCommentRunSQL(MasterTable table) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRunSQL(MasterTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRunSQL(MasterTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRunSQL(MasterTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildDropRunSQL(MasterTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRunSQL(MasterTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRunSQL(MasterTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRunSQL(MasterTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRunSQL(MasterTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildCreateRunSQL(PartitionTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRunSQL(PartitionTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAddCommentRunSQL(PartitionTable table) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRunSQL(PartitionTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRunSQL(PartitionTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRunSQL(PartitionTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildDropRunSQL(PartitionTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRunSQL(PartitionTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRunSQL(PartitionTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRunSQL(PartitionTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRunSQL(PartitionTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public String alterColumnKeyword() {
        return "ALTER";
    }

    @Override
    public List<Run> buildAddRunSQL(Column column, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        if (!slice) {
            Table table = column.getTable(true);
            builder.append("ALTER ").append(table.getKeyword()).append(" ");
            this.name(builder, table);
        }
        this.addColumnGuide(builder, column);
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
        this.define(builder, column);
        runs.addAll(this.buildAddCommentRunSQL(column));
        return runs;
    }

    @Override
    public List<Run> buildAddRunSQL(Column column) throws Exception {
        return this.buildAddRunSQL(column, false);
    }

    @Override
    public StringBuilder addColumnGuide(StringBuilder builder, Column column) {
        return builder.append(" ADD ").append(column.getKeyword()).append(" ");
    }

    @Override
    public List<Run> buildAlterRunSQL(Column column, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        Column update = column.getUpdate();
        if (null != update) {
            List<Run> cmts;
            String ucomment;
            String comment;
            List<Run> nulls;
            int unullable;
            int nullable;
            List<Run> defs;
            List<Run> list;
            String uname;
            String name = column.getName();
            if (!BasicUtil.equalsIgnoreCase((Object)name, (Object)(uname = update.getName())) && !uname.endsWith("_TMP_UPDATE_TYPE")) {
                runs.addAll(this.buildRenameRunSQL(column));
            }
            String type = this.type(null, column).toString();
            String utype = this.type(null, update).toString();
            boolean exe = false;
            if (!BasicUtil.equalsIgnoreCase((Object)type, (Object)utype)) {
                list = this.buildChangeTypeRunSQL(column);
                if (null != list) {
                    runs.addAll(list);
                    exe = true;
                }
            } else if ((column.getPrecision() != update.getPrecision() || column.getScale() != update.getScale()) && null != (list = this.buildChangeTypeRunSQL(column))) {
                runs.addAll(list);
                exe = true;
            }
            Object def = column.getDefaultValue();
            Object udef = update.getDefaultValue();
            if (!BasicUtil.equalsIgnoreCase((Object)def, (Object)udef) && null != (defs = this.buildChangeDefaultRunSQL(column))) {
                runs.addAll(defs);
            }
            if ((nullable = column.isNullable()) != (unullable = update.isNullable()) && null != (nulls = this.buildChangeNullableRunSQL(column))) {
                runs.addAll(nulls);
            }
            if (!BasicUtil.equalsIgnoreCase((Object)(comment = column.getComment()), (Object)(ucomment = update.getComment())) && null != (cmts = this.buildChangeCommentRunSQL(column))) {
                runs.addAll(cmts);
            }
        }
        return runs;
    }

    @Override
    public List<Run> buildAlterRunSQL(Column column) throws Exception {
        return this.buildAlterRunSQL(column, false);
    }

    @Override
    public List<Run> buildDropRunSQL(Column column, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        if (column instanceof Tag) {
            Tag tag = (Tag)column;
            return this.buildDropRunSQL(tag);
        }
        if (!slice) {
            Table table = column.getTable(true);
            builder.append("ALTER ").append(table.getKeyword()).append(" ");
            this.name(builder, table);
        }
        this.dropColumnGuide(builder, column);
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildDropRunSQL(Column column) throws Exception {
        return this.buildDropRunSQL(column, false);
    }

    @Override
    public StringBuilder dropColumnGuide(StringBuilder builder, Column column) {
        return builder.append(" DROP ").append(column.getKeyword()).append(" ");
    }

    @Override
    public List<Run> buildRenameRunSQL(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        Table table = column.getTable(true);
        builder.append("ALTER ").append(table.getKeyword()).append(" ");
        this.name(builder, table);
        builder.append(" RENAME ").append(column.getKeyword()).append(" ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getUpdate().getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        column.setName(column.getUpdate().getName());
        return runs;
    }

    @Override
    public List<Run> buildChangeTypeRunSQL(Column column) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeTypeRunSQL(Column column)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeDefaultRunSQL(Column column) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeDefaultRunSQL(Column column)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeNullableRunSQL(Column column) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeNullableRunSQL(Column column)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRunSQL(Column column) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRunSQL(Column column)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAddCommentRunSQL(Column column) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropAutoIncrement(Column column) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildDropAutoIncrement(Column column)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder define(StringBuilder builder, Column column) {
        this.type(builder, column);
        this.charset(builder, column);
        this.defaultValue(builder, column);
        this.nullable(builder, column);
        this.primary(builder, column);
        if (column.isPrimaryKey() == 1) {
            this.increment(builder, column);
        }
        this.onupdate(builder, column);
        this.comment(builder, column);
        this.position(builder, column);
        return builder;
    }

    @Override
    public StringBuilder type(StringBuilder builder, Column column) {
        if (null == builder) {
            builder = new StringBuilder();
        }
        boolean isIgnorePrecision = false;
        boolean isIgnoreScale = false;
        String typeName = column.getTypeName();
        ColumnType type = this.type(typeName);
        if (null != type) {
            if (!type.support()) {
                throw new RuntimeException("\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301:" + typeName);
            }
            isIgnorePrecision = type.ignorePrecision();
            isIgnoreScale = type.ignoreScale();
            typeName = type.getName();
        } else {
            isIgnorePrecision = this.isIgnorePrecision(column);
            isIgnoreScale = this.isIgnoreScale(column);
        }
        return this.type(builder, column, typeName, isIgnorePrecision, isIgnoreScale);
    }

    @Override
    public StringBuilder type(StringBuilder builder, Column column, String type, boolean isIgnorePrecision, boolean isIgnoreScale) {
        Integer precision;
        if (null == builder) {
            builder = new StringBuilder();
        }
        builder.append(type);
        if (!isIgnorePrecision && null != (precision = column.getPrecision())) {
            if (precision > 0) {
                builder.append("(").append(precision);
                Integer scale = column.getScale();
                if (null != scale && scale > 0 && !isIgnoreScale) {
                    builder.append(",").append(scale);
                }
                builder.append(")");
            } else if (precision == -1) {
                builder.append("(max)");
            }
        }
        return builder;
    }

    @Override
    public Boolean checkIgnorePrecision(String type) {
        if ((type = type.toUpperCase()).contains("INT")) {
            return false;
        }
        if (type.contains("DATE")) {
            return true;
        }
        if (type.contains("TIME")) {
            return true;
        }
        if (type.contains("YEAR")) {
            return true;
        }
        if (type.contains("TEXT")) {
            return true;
        }
        if (type.contains("BLOB")) {
            return true;
        }
        if (type.contains("JSON")) {
            return true;
        }
        if (type.contains("POINT")) {
            return true;
        }
        if (type.contains("LINE")) {
            return true;
        }
        if (type.contains("POLYGON")) {
            return true;
        }
        if (type.contains("GEOMETRY")) {
            return true;
        }
        return null;
    }

    @Override
    public Boolean checkIgnoreScale(String type) {
        if ((type = type.toUpperCase()).contains("INT")) {
            return true;
        }
        if (type.contains("DATE")) {
            return true;
        }
        if (type.contains("TIME")) {
            return true;
        }
        if (type.contains("YEAR")) {
            return true;
        }
        if (type.contains("TEXT")) {
            return true;
        }
        if (type.contains("BLOB")) {
            return true;
        }
        if (type.contains("JSON")) {
            return true;
        }
        if (type.contains("POINT")) {
            return true;
        }
        if (type.contains("LINE")) {
            return true;
        }
        if (type.contains("POLYGON")) {
            return true;
        }
        if (type.contains("GEOMETRY")) {
            return true;
        }
        return null;
    }

    @Override
    public boolean isIgnorePrecision(Column column) {
        String chk;
        Boolean chkResult;
        ColumnType type = column.getColumnType();
        if (null != type) {
            return type.ignorePrecision();
        }
        String typeName = column.getTypeName();
        if (null != typeName && null != (chkResult = this.checkIgnorePrecision(chk = typeName.toUpperCase()))) {
            return chkResult;
        }
        return false;
    }

    @Override
    public boolean isIgnoreScale(Column column) {
        String chk;
        Boolean chkResult;
        ColumnType type = column.getColumnType();
        if (null != type) {
            return type.ignoreScale();
        }
        String name = column.getTypeName();
        if (null != name && null != (chkResult = this.checkIgnoreScale(chk = name.toUpperCase()))) {
            return chkResult;
        }
        return false;
    }

    @Override
    public StringBuilder nullable(StringBuilder builder, Column column) {
        int nullable;
        if (column.isNullable() == 0 && (nullable = column.isNullable()) != -1) {
            if (nullable == 0) {
                builder.append(" NOT");
            }
            builder.append(" NULL");
        }
        return builder;
    }

    @Override
    public StringBuilder charset(StringBuilder builder, Column column) {
        String charset;
        String typeName = column.getTypeName();
        if (null != typeName && typeName.toLowerCase().contains("char") && BasicUtil.isNotEmpty((Object)(charset = column.getCharset()))) {
            builder.append(" CHARACTER SET ").append(charset);
            String collate = column.getCollate();
            if (BasicUtil.isNotEmpty((Object)collate)) {
                builder.append(" COLLATE ").append(collate);
            }
        }
        return builder;
    }

    @Override
    public StringBuilder defaultValue(StringBuilder builder, Column column) {
        Object def = column.getDefaultValue();
        if (null != def) {
            builder.append(" DEFAULT ");
            boolean isCharColumn = this.isCharColumn(column);
            if (def instanceof JDBCAdapter.SQL_BUILD_IN_VALUE) {
                String value = this.value(column, (JDBCAdapter.SQL_BUILD_IN_VALUE)((Object)def));
                if (null != value) {
                    builder.append(value);
                }
            } else {
                if (null == (def = this.write(column, def, false))) {
                    def = column.getDefaultValue();
                }
                builder.append(def);
            }
        }
        return builder;
    }

    @Override
    public StringBuilder primary(StringBuilder builder, Column column) {
        return builder;
    }

    @Override
    public StringBuilder increment(StringBuilder builder, Column column) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 StringBuilder increment(StringBuilder builder, Column column)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder onupdate(StringBuilder builder, Column column) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 StringBuilder onupdate(StringBuilder builder, Column column)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder position(StringBuilder builder, Column column) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 StringBuilder position(StringBuilder builder, Column column)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder comment(StringBuilder builder, Column column) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 StringBuilder comment(StringBuilder builder, Column column)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder checkColumnExists(StringBuilder builder, boolean exists) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 checkColumnExists(StringBuilder builder, boolean exists)"), (int)37));
        }
        return builder;
    }

    @Override
    public List<Run> buildAddRunSQL(Tag tag) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        Table table = tag.getTable(true);
        builder.append("ALTER ").append(table.getKeyword()).append(" ");
        this.name(builder, table);
        builder.append(" ADD TAG ");
        SQLUtil.delimiter((StringBuilder)builder, (String)tag.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
        this.define(builder, (Column)tag);
        return runs;
    }

    @Override
    public List<Run> buildAlterRunSQL(Tag tag) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        Tag update = tag.getUpdate();
        if (null != update) {
            String ucomment;
            String comment;
            int unullable;
            int nullable;
            List<Run> list;
            String uname;
            String name = tag.getName();
            if (!BasicUtil.equalsIgnoreCase((Object)name, (Object)(uname = update.getName())) && !uname.endsWith("_TMP_UPDATE_TYPE")) {
                runs.addAll(this.buildRenameRunSQL(tag));
            }
            tag.setName(uname);
            String type = this.type(null, (Column)tag).toString();
            String utype = this.type(null, (Column)update).toString();
            if (!BasicUtil.equalsIgnoreCase((Object)type, (Object)utype)) {
                list = this.buildChangeTypeRunSQL(tag);
                if (null != list) {
                    runs.addAll(list);
                }
            } else if ((tag.getPrecision() != update.getPrecision() || tag.getScale() != update.getScale()) && null != (list = this.buildChangeTypeRunSQL(tag))) {
                runs.addAll(list);
            }
            Object def = tag.getDefaultValue();
            Object udef = update.getDefaultValue();
            if (!BasicUtil.equalsIgnoreCase((Object)def, (Object)udef)) {
                runs.addAll(this.buildChangeDefaultRunSQL(tag));
            }
            if ((nullable = tag.isNullable()) != (unullable = update.isNullable())) {
                runs.addAll(this.buildChangeNullableRunSQL(tag));
            }
            if (!BasicUtil.equalsIgnoreCase((Object)(comment = tag.getComment()), (Object)(ucomment = update.getComment()))) {
                runs.addAll(this.buildChangeCommentRunSQL(tag));
            }
        }
        return runs;
    }

    @Override
    public List<Run> buildDropRunSQL(Tag tag) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        Table table = tag.getTable(true);
        builder.append("ALTER ").append(table.getKeyword()).append(" ");
        this.name(builder, table);
        builder.append(" DROP ").append(tag.getKeyword()).append(" ");
        SQLUtil.delimiter((StringBuilder)builder, (String)tag.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildRenameRunSQL(Tag tag) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        Table table = tag.getTable(true);
        builder.append("ALTER ").append(table.getKeyword()).append(" ");
        this.name(builder, table);
        builder.append(" RENAME ").append(tag.getKeyword()).append(" ");
        SQLUtil.delimiter((StringBuilder)builder, (String)tag.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" ");
        SQLUtil.delimiter((StringBuilder)builder, (String)tag.getUpdate().getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildChangeDefaultRunSQL(Tag tag) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeDefaultRunSQL(Tag tag)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeNullableRunSQL(Tag tag) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeNullableRunSQL(Tag tag)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRunSQL(Tag tag) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRunSQL(Tag tag)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeTypeRunSQL(Tag tag) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeTypeRunSQL(Tag tag)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder checkTagExists(StringBuilder builder, boolean exists) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 StringBuilder checkTagExists(StringBuilder builder, boolean exists)"), (int)37));
        }
        return builder;
    }

    @Override
    public List<Run> buildAddRunSQL(PrimaryKey primary) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAddRunSQL(PrimaryKey primary)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRunSQL(PrimaryKey primary) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRunSQL(PrimaryKey primary)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRunSQL(PrimaryKey primary) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, primary.getTable(true));
        builder.append(" DROP CONSTRAINT ");
        SQLUtil.delimiter((StringBuilder)builder, (String)primary.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildRenameRunSQL(PrimaryKey primary) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAddRunSQL(PrimaryKey primary)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAddRunSQL(ForeignKey foreign) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap columns = foreign.getColumns();
        if (columns.size() > 0) {
            builder.append("ALTER TABLE ");
            this.name(builder, foreign.getTable(true));
            builder.append(" ADD");
            if (BasicUtil.isNotEmpty((Object)foreign.getName())) {
                builder.append(" CONSTRAINT ").append(foreign.getName());
            }
            builder.append(" FOREIGN KEY (");
            boolean first = true;
            for (Column column : columns.values()) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                first = false;
            }
            builder.append(")");
            builder.append(" REFERENCES ").append(foreign.getReference().getName()).append("(");
            first = true;
            for (Column column : columns.values()) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getReference(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                first = false;
            }
            builder.append(")");
        }
        return runs;
    }

    @Override
    public List<Run> buildAlterRunSQL(ForeignKey foreign) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRunSQL(PrimaryKey primary)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRunSQL(ForeignKey foreign) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE");
        this.name(builder, foreign.getTable(true));
        builder.append(" DROP FOREIGN KEY ").append(foreign.getName());
        return runs;
    }

    @Override
    public List<Run> buildRenameRunSQL(ForeignKey foreign) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRunSQL(ForeignKey foreign) "), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAddRunSQL(Index index) throws Exception {
        String name = index.getName();
        if (BasicUtil.isEmpty((Object)name)) {
            name = "index_" + BasicUtil.getRandomString((int)10);
        }
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE");
        if (index.isUnique()) {
            builder.append(" UNIQUE");
        } else if (index.isFulltext()) {
            builder.append(" FULLTEXT");
        } else if (index.isSpatial()) {
            builder.append(" SPATIAL");
        }
        builder.append(" INDEX ").append(name).append(" ON ");
        Table table = index.getTable(true);
        this.name(builder, table);
        builder.append("(");
        int qty = 0;
        for (Column column : index.getColumns().values()) {
            if (qty > 0) {
                builder.append(",");
            }
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            String order = column.getOrder();
            if (BasicUtil.isNotEmpty((Object)order)) {
                builder.append(" ").append(order);
            }
            ++qty;
        }
        builder.append(")");
        String type = index.getType();
        if (BasicUtil.isNotEmpty((Object)type)) {
            builder.append("USING ").append(type).append(" ");
        }
        this.comment(builder, index);
        return runs;
    }

    @Override
    public List<Run> buildAlterRunSQL(Index index) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAddRunSQL(Index index)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRunSQL(Index index) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        Table table = index.getTable(true);
        if (index.isPrimary()) {
            builder.append("ALTER TABLE ");
            this.name(builder, table);
            builder.append(" DROP CONSTRAINT ").append(index.getName());
        } else {
            builder.append("DROP INDEX ").append(index.getName());
            if (BasicUtil.isNotEmpty((Object)table)) {
                builder.append(" ON ");
                this.name(builder, table);
            }
        }
        return runs;
    }

    @Override
    public List<Run> buildRenameRunSQL(Index index) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAddRunSQL(Index index)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public void comment(StringBuilder builder, Index index) {
    }

    @Override
    public List<Run> buildAddRunSQL(Constraint constraint) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAddRunSQL(Constraint constraint)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRunSQL(Constraint constraint) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRunSQL(Constraint constraint)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRunSQL(Constraint constraint) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        Table table = constraint.getTable(true);
        this.name(builder, table);
        builder.append(" DROP CONSTRAINT ").append(constraint.getName());
        return runs;
    }

    @Override
    public List<Run> buildRenameRunSQL(Constraint constraint) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        Table table = constraint.getTable(true);
        String catalog = constraint.getCatalog();
        String schema = table.getSchema();
        builder.append("ALTER CONSTRAINT ");
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)constraint.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" RENAME TO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)constraint.getUpdate().getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildCreateRunSQL(Trigger trigger) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE TRIGGER ").append(trigger.getName());
        builder.append(" ").append(trigger.getTime().sql()).append(" ");
        List events = trigger.getEvents();
        boolean first = true;
        for (Trigger.EVENT event : events) {
            if (!first) {
                builder.append(" OR ");
            }
            builder.append(event);
            first = false;
        }
        builder.append(" ON ");
        this.name(builder, trigger.getTable(true));
        this.each(builder, trigger);
        builder.append("\n").append(trigger.getDefinition());
        return runs;
    }

    @Override
    public void each(StringBuilder builder, Trigger trigger) {
        if (trigger.isEach()) {
            builder.append(" FOR EACH ROW ");
        } else {
            builder.append(" FOR EACH STATEMENT ");
        }
    }

    @Override
    public List<Run> buildAlterRunSQL(Trigger trigger) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRunSQL(Trigger trigger) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP TRIGGER ");
        Table table = trigger.getTable(true);
        if (null != table) {
            String catalog = table.getCatalog();
            String schema = table.getSchema();
            if (BasicUtil.isNotEmpty((Object)catalog)) {
                SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
            }
            if (BasicUtil.isNotEmpty((Object)schema)) {
                SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
            }
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)trigger.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildRenameRunSQL(Trigger trigger) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        Table table = trigger.getTable(true);
        String catalog = table.getCatalog();
        String schema = table.getSchema();
        builder.append("ALTER TRIGGER ");
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)trigger.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" RENAME TO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)trigger.getUpdate().getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildCreateRunSQL(Procedure procedure) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE PROCEDURE ");
        String catalog = procedure.getCatalog();
        String schema = procedure.getSchema();
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)procedure.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append("(\n");
        List ins = procedure.getInputs();
        List outs = procedure.getOutputs();
        boolean first = true;
        for (Parameter parameter : ins) {
            if (parameter.isOutput()) continue;
            if (!first) {
                builder.append(",");
            }
            this.parameter(builder, parameter);
        }
        for (Parameter parameter : outs) {
            if (!first) {
                builder.append(",");
            }
            this.parameter(builder, parameter);
        }
        builder.append("\n)");
        String returnType = procedure.getReturnType();
        if (BasicUtil.isNotEmpty((Object)returnType)) {
            builder.append(" RETURNS ").append(returnType);
        }
        builder.append("\n");
        builder.append(procedure.getDefinition());
        return runs;
    }

    @Override
    public void parameter(StringBuilder builder, Parameter parameter) {
        boolean in = parameter.isInput();
        boolean out = parameter.isOutput();
        if (in) {
            builder.append("IN");
        }
        if (out) {
            builder.append("OUT");
        }
        builder.append(" ").append(parameter.getName());
        ColumnType type = parameter.getColumnType();
        boolean isIgnorePrecision = type.ignorePrecision();
        boolean isIgnoreScale = type.ignoreScale();
        builder.append(type);
        if (!isIgnorePrecision) {
            Integer precision = parameter.getPrecision();
            Integer scale = parameter.getScale();
            if (null != precision) {
                if (precision > 0) {
                    builder.append("(").append(precision);
                    if (null != scale && scale > 0 && !isIgnoreScale) {
                        builder.append(",").append(scale);
                    }
                    builder.append(")");
                } else if (precision == -1) {
                    builder.append("(max)");
                }
            }
        }
    }

    @Override
    public List<Run> buildAlterRunSQL(Procedure procedure) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRunSQL(Procedure procedure) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP PROCEDURE ");
        String catalog = procedure.getCatalog();
        String schema = procedure.getSchema();
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)procedure.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildRenameRunSQL(Procedure procedure) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        String catalog = procedure.getCatalog();
        String schema = procedure.getSchema();
        builder.append("ALTER PROCEDURE ");
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)procedure.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" RENAME TO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)procedure.getUpdate().getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildCreateRunSQL(Function function) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRunSQL(Function function) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRunSQL(Function function) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP FUNCTION ");
        String catalog = function.getCatalog();
        String schema = function.getSchema();
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)function.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildRenameRunSQL(Function function) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        String catalog = function.getCatalog();
        String schema = function.getSchema();
        builder.append("ALTER FUNCTION ");
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)function.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" RENAME TO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)function.getUpdate().getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public boolean isBooleanColumn(Column column) {
        String type;
        String clazz = column.getClassName();
        return null != clazz ? (clazz = clazz.toLowerCase()).contains("boolean") : null != (type = column.getTypeName()) && ((type = type.toLowerCase()).equals("bit") || type.equals("bool"));
    }

    @Override
    public boolean isNumberColumn(Column column) {
        String type;
        String clazz = column.getClassName();
        return null != clazz ? (clazz = clazz.toLowerCase()).startsWith("int") || clazz.contains("integer") || clazz.contains("long") || clazz.contains("decimal") || clazz.contains("float") || clazz.contains("double") || clazz.contains("timestamp") || clazz.contains("short") : null != (type = column.getTypeName()) && ((type = type.toLowerCase()).startsWith("int") || type.contains("float") || type.contains("double") || type.contains("short") || type.contains("long") || type.contains("decimal") || type.contains("numeric") || type.contains("timestamp"));
    }

    @Override
    public boolean isCharColumn(Column column) {
        return !this.isNumberColumn(column) && !this.isBooleanColumn(column);
    }

    @Override
    public String value(Column column, JDBCAdapter.SQL_BUILD_IN_VALUE value) {
        return null;
    }

    protected String string(Map<String, Integer> keys, String key, ResultSet set, String def) throws Exception {
        Object value = this.value(keys, key, set);
        if (null != value) {
            return value.toString();
        }
        return def;
    }

    protected String string(Map<String, Integer> keys, String key, ResultSet set) throws Exception {
        return this.string(keys, key, set, null);
    }

    protected Integer integer(Map<String, Integer> keys, String key, ResultSet set, Integer def) throws Exception {
        Object value = this.value(keys, key, set);
        if (null != value) {
            return BasicUtil.parseInt((Object)value, (Integer)def);
        }
        return null;
    }

    protected Boolean bool(Map<String, Integer> keys, String key, ResultSet set, Boolean def) throws Exception {
        Object value = this.value(keys, key, set);
        if (null != value) {
            return BasicUtil.parseBoolean((Object)value, (Boolean)def);
        }
        return null;
    }

    protected Boolean bool(Map<String, Integer> keys, String key, ResultSet set, int def) throws Exception {
        Boolean defaultValue = null;
        if (def == 0) {
            defaultValue = false;
        } else if (def == 1) {
            defaultValue = true;
        }
        return this.bool(keys, key, set, defaultValue);
    }

    protected Object value(Map<String, Integer> keys, String key, ResultSet set, Object def) throws Exception {
        Integer index = keys.get(key);
        if (null != index && index >= 0) {
            try {
                return set.getObject(index);
            }
            catch (Exception e) {
                return def;
            }
        }
        return def;
    }

    protected Object value(Map<String, Integer> keys, String key, ResultSet set) throws Exception {
        return this.value(keys, key, set, null);
    }

    @Override
    public String getPrimaryKey(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof DataRow) {
            return ((DataRow)obj).getPrimaryKey();
        }
        if (EntityAdapterProxy.hasAdapter()) {
            return EntityAdapterProxy.primaryKey(obj.getClass()).getName();
        }
        return null;
    }

    @Override
    public Object getPrimaryValue(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof DataRow) {
            return ((DataRow)obj).getPrimaryValue();
        }
        if (EntityAdapterProxy.hasAdapter()) {
            return EntityAdapterProxy.primaryValue((Object)obj);
        }
        return null;
    }

    public String parseTable(String table) {
        if (null == table) {
            return table;
        }
        table = table.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), "");
        if ((table = DataSourceHolder.parseDataSource(table, null)).contains(".")) {
            String[] tmps = table.split("\\.");
            table = SQLUtil.delimiter((String)tmps[0], (String)this.getDelimiterFr(), (String)this.getDelimiterTo()) + "." + SQLUtil.delimiter((String)tmps[1], (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        } else {
            table = SQLUtil.delimiter((String)table, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        }
        return table;
    }

    @Override
    public Object write(Column metadata, Object value, boolean placeholder) {
        if (null == value) {
            return value;
        }
        Object result = value;
        if (null != metadata && null != value) {
            String typeName;
            ColumnType ctype = metadata.getColumnType();
            if (null == ctype && null != (typeName = metadata.getTypeName())) {
                ctype = this.type(typeName.toUpperCase());
            }
            if (null != ctype) {
                if (!placeholder) {
                    result = ctype.write(value, null, false);
                } else {
                    Class writeClass = ctype.compatible();
                    result = ConvertAdapter.convert((Object)value, (Class)writeClass);
                }
            }
        } else if (!placeholder && null != value && !BasicUtil.isNumber((Object)value)) {
            result = "'" + result + "'";
        }
        return result;
    }

    @Override
    public Object read(Column metadata, Object value, Class clazz) {
        Object result = value;
        if (null == value) {
            return null;
        }
        DataReader reader = null;
        ColumnType ctype = null;
        if (null != metadata) {
            String typeName;
            ctype = metadata.getColumnType();
            if (null == ctype && null != (typeName = metadata.getTypeName())) {
                ctype = this.type(typeName);
            }
            if (null != ctype) {
                reader = this.reader(ctype);
            }
        }
        if (null == reader) {
            reader = this.reader(value.getClass());
        }
        if (null != reader) {
            result = reader.read(value);
        }
        if ((null == reader || null == result) && null != ctype) {
            result = ctype.read(value, null, clazz);
        }
        return result;
    }

    @Override
    public void value(StringBuilder builder, Object obj, String key) {
        Object value = null;
        if (obj instanceof DataRow) {
            value = ((DataRow)obj).get(key);
        } else if (EntityAdapterProxy.hasAdapter()) {
            Field field = EntityAdapterProxy.field(obj.getClass(), (String)key);
            value = BeanUtil.getFieldValue((Object)obj, (Field)field);
        } else {
            value = BeanUtil.getFieldValue((Object)obj, (String)key);
        }
        if (null == value) {
            if (value instanceof JDBCAdapter.SQL_BUILD_IN_VALUE) {
                builder.append(this.value(null, (JDBCAdapter.SQL_BUILD_IN_VALUE)((Object)value)));
            } else {
                ColumnType type = this.type(value.getClass().getName());
                if (null != type) {
                    value = type.write(value, null, false);
                }
                builder.append(value);
            }
        } else {
            builder.append("null");
        }
    }

    @Override
    public boolean convert(String catalog, String schema, String table, RunValue run) {
        boolean result = false;
        if (ConfigTable.IS_AUTO_CHECK_METADATA) {
            LinkedHashMap columns = null;
            if (null != this.dao) {
                columns = this.dao.columns(catalog, schema, table);
            }
            result = this.convert(columns, run);
        } else {
            result = this.convert((Column)null, run);
        }
        return result;
    }

    @Override
    public boolean convert(Map<String, Column> columns, RunValue value) {
        boolean result = false;
        if (null != columns && null != value) {
            Column meta = columns.get(value.getKey().toUpperCase());
            result = this.convert(meta, value);
        }
        return result;
    }

    @Override
    public boolean convert(Column metadata, RunValue run) {
        if (null == run) {
            return true;
        }
        Object value = run.getValue();
        if (null == value) {
            return true;
        }
        try {
            if (null != metadata) {
                value = this.convert(metadata, value);
            } else {
                DataWriter writer = this.writer(value.getClass());
                if (null != writer) {
                    value = writer.write(value, true);
                }
            }
            run.setValue(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public Object convert(Column metadata, Object value) {
        if (null == value) {
            return value;
        }
        try {
            if (null != metadata) {
                ColumnType columnType = metadata.getColumnType();
                value = this.convert(columnType, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public Object convert(ColumnType columnType, Object value) {
        if (null == columnType) {
            return value;
        }
        String typeName = columnType.getName();
        boolean parseJson = false;
        if (null != typeName && !(value instanceof String)) {
            if (typeName.contains("JSON")) {
                value = BeanUtil.object2json((Object)value);
                parseJson = true;
            } else if (typeName.contains("XML")) {
                value = BeanUtil.object2xml((Object)value);
                parseJson = true;
            }
        }
        if (!parseJson && null != columnType) {
            DataWriter writer = this.writer(columnType);
            if (null != writer) {
                value = writer.write(value, true);
            } else {
                Class transfer = columnType.transfer();
                Class compatible = columnType.compatible();
                if (null != transfer) {
                    value = ConvertAdapter.convert((Object)value, (Class)transfer);
                }
                if (null != compatible) {
                    value = ConvertAdapter.convert((Object)value, (Class)compatible);
                }
            }
        }
        return value;
    }

    public PrimaryGenerator getPrimaryGenerator() {
        return this.primaryGenerator;
    }

    public void setPrimaryGenerator(PrimaryGenerator primaryGenerator) {
        this.primaryGenerator = primaryGenerator;
    }

    @Override
    public String objectName(String name) {
        KeyAdapter.KEY_CASE keyCase = this.type().nameCase();
        if (null != keyCase) {
            return keyCase.convert(name);
        }
        return name;
    }
}

