/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.dao.init.springjdbc;

import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.dao.AnylineDao;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.adapter.init.PersistenceAdapter;
import org.anyline.data.cache.PageLazyStore;
import org.anyline.data.jdbc.ds.DataSourceHolder;
import org.anyline.data.jdbc.ds.JDBCRuntime;
import org.anyline.data.jdbc.ds.RuntimeHolder;
import org.anyline.data.listener.DDListener;
import org.anyline.data.listener.DMListener;
import org.anyline.data.metadata.persistence.ManyToMany;
import org.anyline.data.metadata.persistence.OneToMany;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.prepare.auto.TextPrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.prepare.auto.init.DefaultTextPrepare;
import org.anyline.data.prepare.xml.XMLPrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.util.ThreadConfig;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.exception.AnylineException;
import org.anyline.exception.SQLQueryException;
import org.anyline.exception.SQLUpdateException;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.proxy.CacheProxy;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.proxy.InterceptorProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.anyline.util.regular.RegularUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Primary
@Repository(value="anyline.dao")
public class DefaultDao<E>
implements AnylineDao<E> {
    protected static final Logger log = LoggerFactory.getLogger(DefaultDao.class);
    @Autowired(required=false)
    protected static DMListener dmListener;
    @Autowired(required=false)
    protected static DDListener ddListener;
    protected static boolean isBatchInsertRun;
    protected JDBCRuntime runtime = null;

    protected JDBCRuntime runtime() {
        if (null != this.runtime) {
            this.runtime.setDao(this);
            return this.runtime;
        }
        JDBCRuntime r = RuntimeHolder.getRuntime();
        if (null != r) {
            r.setDao(this);
        }
        return r;
    }

    public boolean isFix() {
        return false;
    }

    public DMListener getListener() {
        return dmListener;
    }

    @Autowired(required=false)
    public void setListener(DMListener listener) {
        dmListener = listener;
    }

    public JDBCRuntime getRuntime() {
        return this.runtime;
    }

    @Override
    public void setRuntime(JDBCRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public void setDatasource(String datasource) {
    }

    @Override
    public List<Map<String, Object>> maps(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.maps(true, prepare, configs, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Map<String, Object>> maps(boolean recover, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        String random;
        List<Object> maps = null;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        Long fr = System.currentTimeMillis();
        boolean sql_success = false;
        Run run = null;
        JDBCRuntime runtime = this.runtime();
        swt = InterceptorProxy.prepareQuery(runtime, random = this.random(), prepare, configs, conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return new ArrayList<Map<String, Object>>();
        }
        if (null != dmListener) {
            swt = dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return new ArrayList<Map<String, Object>>();
        }
        try {
            JDBCAdapter adapter = runtime.getAdapter();
            run = adapter.buildQueryRun(prepare, configs, conditions);
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled() && !run.isValid()) {
                String tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
                String src = "";
                src = prepare instanceof TablePrepare ? prepare.getTable() : prepare.getText();
                tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, src, configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + this.runtime().datasource() + "]";
                log.warn(tmp);
            }
            fr = System.currentTimeMillis();
            if (run.isValid()) {
                swt = InterceptorProxy.beforeQuery(runtime, random, run, null);
                if (swt == ACTION.SWITCH.BREAK) {
                    ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                    return arrayList;
                }
                if (null != dmListener) {
                    dmListener.beforeQuery(runtime, random, run, -1);
                }
                maps = this.maps(runtime, random, run.getFinalQuery(), run.getValues());
                if (null != adapter) {
                    maps = adapter.process(maps);
                }
                sql_success = true;
            } else {
                maps = new ArrayList();
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        if (null != dmListener) {
            dmListener.afterQuery(runtime, random, run, sql_success, maps, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterQuery(runtime, random, run, sql_success, maps, null, System.currentTimeMillis() - fr);
        return maps;
    }

    @Override
    public List<Map<String, Object>> maps(RunPrepare prepare, String ... conditions) {
        return this.maps(prepare, (ConfigStore)null, conditions);
    }

    @Override
    public DataSet querys(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.querys(null, null, true, prepare, configs, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSet querys(JDBCRuntime runtime, String random, boolean recover, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        DataSet set = null;
        Long fr = System.currentTimeMillis();
        boolean sql_success = false;
        Run run = null;
        PageNavi navi = null;
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null == random) {
            random = this.random();
        }
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null != dmListener) {
            swt = dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return new DataSet();
        }
        swt = InterceptorProxy.prepareQuery(runtime, random, prepare, configs, conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return new DataSet();
        }
        try {
            JDBCAdapter adapter = runtime.getAdapter();
            run = adapter.buildQueryRun(prepare, configs, conditions);
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled() && !run.isValid()) {
                String tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
                String src = "";
                src = prepare instanceof TablePrepare ? prepare.getTable() : prepare.getText();
                tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, src, configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + this.runtime().datasource() + "]";
                log.warn(tmp);
            }
            navi = run.getPageNavi();
            int total = 0;
            if (run.isValid() && null != navi) {
                if (null != dmListener) {
                    dmListener.beforeTotal(runtime, random, run);
                }
                fr = System.currentTimeMillis();
                if (navi.getLastRow() == 0) {
                    total = 1;
                } else if (navi.getTotalRow() == 0) {
                    total = this.getTotal(run.getTotalQuery(), run.getValues());
                    navi.setTotalRow(total);
                } else {
                    total = navi.getTotalRow();
                }
                if (null != dmListener) {
                    dmListener.afterTotal(runtime, random, run, true, total, System.currentTimeMillis() - fr);
                }
                if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("[\u67e5\u8be2\u8bb0\u5f55\u603b\u6570][\u884c\u6570:{}]", (Object)total);
                }
            }
            fr = System.currentTimeMillis();
            if (run.isValid()) {
                if (null == navi || total > 0) {
                    if (null != dmListener) {
                        dmListener.beforeQuery(runtime, random, run, total);
                    }
                    if ((swt = InterceptorProxy.beforeQuery(runtime, random, run, navi)) == ACTION.SWITCH.BREAK) {
                        DataSet dataSet = new DataSet();
                        return dataSet;
                    }
                    set = this.select(runtime, random, prepare.getTable(), run.getFinalQuery(), run.getValues());
                    sql_success = true;
                } else {
                    set = new DataSet();
                }
            } else {
                set = new DataSet();
            }
            set.setDataSource(prepare.getDataSource());
            set.setNavi(navi);
            if (null != navi && navi.isLazy()) {
                PageLazyStore.setTotal(navi.getLazyKey(), navi.getTotalRow());
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        if (null != dmListener) {
            dmListener.afterQuery(runtime, random, run, sql_success, set, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterQuery(runtime, random, run, sql_success, set, navi, System.currentTimeMillis() - fr);
        return set;
    }

    @Override
    public <T> EntitySet<T> querys(Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.querys(null, null, true, clazz, configs, conditions);
    }

    protected <T> EntitySet<T> querys(JDBCRuntime runtime, String random, boolean recover, Class<T> clazz, ConfigStore configs, String ... conditions) {
        DefaultTablePrepare prepare = new DefaultTablePrepare();
        return this.querys(runtime, random, recover, (RunPrepare)prepare, clazz, configs, conditions);
    }

    @Override
    public <T> EntitySet<T> querys(RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.querys(null, null, true, prepare, clazz, configs, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> EntitySet<T> querys(JDBCRuntime runtime, String random, boolean recover, RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        EntitySet<T> list = null;
        Long fr = System.currentTimeMillis();
        Run run = null;
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null == random) {
            random = this.random();
        }
        boolean sql_success = false;
        PageNavi navi = null;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null != dmListener) {
            swt = dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return new EntitySet();
        }
        swt = InterceptorProxy.prepareQuery(runtime, random, prepare, configs, conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return new EntitySet();
        }
        try {
            if (BasicUtil.isEmpty((Object)prepare.getDataSource()) && !(prepare instanceof TextPrepare) && !(prepare instanceof XMLPrepare) && EntityAdapterProxy.hasAdapter()) {
                prepare.setDataSource(EntityAdapterProxy.table(clazz).getName());
            }
            JDBCAdapter adapter = runtime.getAdapter();
            run = adapter.buildQueryRun(prepare, configs, conditions);
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled() && !run.isValid()) {
                String tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
                tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, clazz.getName(), configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + this.runtime().datasource() + "]";
                log.warn(tmp);
            }
            navi = run.getPageNavi();
            int total = 0;
            if (run.isValid()) {
                if (null != navi) {
                    if (null != dmListener) {
                        dmListener.beforeTotal(runtime, random, run);
                    }
                    fr = System.currentTimeMillis();
                    if (navi.getLastRow() == 0) {
                        total = 1;
                    } else if (navi.getTotalRow() == 0) {
                        total = this.getTotal(run.getTotalQuery(), run.getValues());
                        navi.setTotalRow(total);
                    } else {
                        total = navi.getTotalRow();
                    }
                    if (null != dmListener) {
                        dmListener.afterTotal(runtime, random, run, true, total, System.currentTimeMillis() - fr);
                    }
                }
                if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("[\u67e5\u8be2\u8bb0\u5f55\u603b\u6570][\u884c\u6570:{}]", (Object)total);
                }
            }
            fr = System.currentTimeMillis();
            if (run.isValid()) {
                if (null == navi || total > 0) {
                    swt = InterceptorProxy.beforeQuery(runtime, random, run, navi);
                    if (swt == ACTION.SWITCH.BREAK) {
                        EntitySet entitySet = new EntitySet();
                        return entitySet;
                    }
                    if (null != dmListener) {
                        dmListener.beforeQuery(runtime, random, run, total);
                    }
                    fr = System.currentTimeMillis();
                    list = this.select(runtime, random, clazz, run.getTable(), run.getFinalQuery(), run.getValues(), ThreadConfig.check(runtime.getKey()).ENTITY_FIELD_SELECT_DEPENDENCY());
                    sql_success = false;
                } else {
                    list = new EntitySet();
                }
            } else {
                list = new EntitySet<T>();
            }
            list.setNavi(navi);
            if (null != navi && navi.isLazy()) {
                PageLazyStore.setTotal(navi.getLazyKey(), navi.getTotalRow());
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        if (null != dmListener) {
            dmListener.afterQuery(runtime, random, run, sql_success, list, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterQuery(runtime, random, run, sql_success, list, navi, System.currentTimeMillis() - fr);
        return list;
    }

    @Override
    public DataSet querys(RunPrepare prepare, String ... conditions) {
        return this.querys(prepare, (ConfigStore)null, conditions);
    }

    @Override
    public DataSet selects(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.querys(prepare, configs, conditions);
    }

    @Override
    public DataSet selects(RunPrepare prepare, String ... conditions) {
        return this.querys(prepare, (ConfigStore)null, conditions);
    }

    @Override
    public DataRow sequence(boolean next, String ... names) {
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        JDBCAdapter adapter = runtime.getAdapter();
        List<Run> runs = adapter.buildQuerySequence(next, names);
        if (null != runs && runs.size() > 0) {
            Run run = runs.get(0);
            if (!run.isValid()) {
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][sequence:" + names);
                }
                return new DataRow();
            }
            DataSet set = this.select(runtime, random, null, run.getFinalQuery(), run.getValues());
            if (set.size() > 0) {
                return set.getRow(0);
            }
        }
        return new DataRow();
    }

    @Override
    public int count(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.count(null, null, true, prepare, configs, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int count(JDBCRuntime runtime, String random, boolean recover, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        int count = -1;
        Long fr = System.currentTimeMillis();
        Run run = null;
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null == random) {
            random = this.random();
        }
        boolean sql_success = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        swt = InterceptorProxy.prepareCount(runtime, random, prepare, configs, conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1;
        }
        if (null != dmListener) {
            swt = dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        try {
            run = adapter.buildQueryRun(prepare, configs, conditions);
            if (!run.isValid()) {
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][RunPrepare:" + ConfigParser.createSQLSign(false, false, prepare.getTable(), configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + this.runtime().datasource() + "]");
                }
                int n = -1;
                return n;
            }
            fr = System.currentTimeMillis();
            if (null != dmListener) {
                dmListener.beforeCount(runtime, random, run);
            }
            if ((swt = InterceptorProxy.beforeCount(runtime, random, run)) == ACTION.SWITCH.BREAK) {
                int n = -1;
                return n;
            }
            fr = System.currentTimeMillis();
            count = this.getTotal(run.getTotalQuery(), run.getValues());
            sql_success = true;
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        if (null != dmListener) {
            dmListener.afterCount(runtime, random, run, sql_success, count, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterCount(runtime, random, run, sql_success, count, System.currentTimeMillis() - fr);
        return count;
    }

    @Override
    public int count(RunPrepare prepare, String ... conditions) {
        return this.count(prepare, (ConfigStore)null, conditions);
    }

    @Override
    public boolean exists(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.exists(null, null, true, prepare, configs, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean exists(JDBCRuntime runtime, String random, boolean recover, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        boolean result = false;
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null == random) {
            random = this.random();
        }
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null != dmListener) {
            swt = dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        try {
            JDBCAdapter adapter = runtime.getAdapter();
            Run run = adapter.buildQueryRun(prepare, configs, conditions);
            if (!run.isValid()) {
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][RunPrepare:" + ConfigParser.createSQLSign(false, false, prepare.getTable(), configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + this.runtime().datasource() + "]");
                }
                boolean bl = false;
                return bl;
            }
            String txt = run.getFinalExists();
            List<Object> values = run.getValues();
            long fr = System.currentTimeMillis();
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, txt, this.paramLogFormat(values)});
            }
            try {
                if (null != dmListener) {
                    dmListener.beforeExists(runtime, random, run);
                }
                Map map = null;
                if (null == values || values.size() <= 0 || !BasicUtil.isEmpty((boolean)true, values)) {
                    map = null != values && values.size() > 0 ? runtime.getTemplate().queryForMap(txt, values.toArray()) : runtime.getTemplate().queryForMap(txt);
                    result = null == map ? false : BasicUtil.parseBoolean(map.get("IS_EXISTS"), (Boolean)false);
                }
                Long millis = System.currentTimeMillis() - fr;
                if (null != dmListener) {
                    dmListener.afterExists(runtime, random, run, true, result, millis);
                }
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check(runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[SLOW SQL][action:exists][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, txt, this.paramLogFormat(values)});
                    if (null != dmListener) {
                        dmListener.slow(runtime, random, ACTION.DML.EXISTS, run, txt, values, null, true, result, millis);
                    }
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((boolean)result, (int)34)});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    throw e;
                }
                if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                    log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), prepare, this.paramLogFormat(values)});
                }
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return result;
    }

    @Override
    public boolean exists(RunPrepare prepare, String ... conditions) {
        return this.exists(prepare, (ConfigStore)null, conditions);
    }

    protected int getTotal(String sql, List<Object> values) {
        int total = 0;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        DataSet set = this.select(runtime, random, null, sql, values);
        total = set.getInt(0, "CNT", 0);
        return total;
    }

    @Override
    public int update(String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.update(null, null, true, dest, data, configs, columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int update(JDBCRuntime runtime, String random, boolean recover, String dest, Object data, ConfigStore configs, List<String> columns) {
        dest = DataSourceHolder.parseDataSource(dest, data);
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        boolean sql_success = false;
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null == random) {
            random = this.random();
        }
        if ((swt = InterceptorProxy.prepareUpdate(runtime, random, dest, data, configs, columns)) == ACTION.SWITCH.BREAK) {
            return -1;
        }
        if (null != dmListener) {
            swt = dmListener.prepareUpdate(runtime, random, dest, data, configs, false, columns);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        if (null == data) {
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                throw new SQLUpdateException("\u66f4\u65b0\u7a7a\u6570\u636e");
            }
            log.error("\u66f4\u65b0\u7a7a\u6570\u636e");
        }
        int result = 0;
        if (data instanceof DataSet) {
            DataSet set = (DataSet)data;
            for (int i = 0; i < set.size(); ++i) {
                result += this.update(runtime, random, false, dest, set.getRow(i), configs, columns);
            }
            return result;
        }
        Run run = adapter.buildUpdateRun(dest, data, configs, false, columns);
        if (!run.isValid()) {
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + dest + "]");
            }
            return -1;
        }
        String sql = run.getFinalUpdate();
        if (BasicUtil.isEmpty((Object)sql)) {
            log.warn("[\u4e0d\u5177\u5907\u66f4\u65b0\u6761\u4ef6][dest:{}]", (Object)dest);
            return -1;
        }
        List<Object> values = run.getValues();
        long fr = System.currentTimeMillis();
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, this.paramLogFormat(values)});
        }
        long millis = -1L;
        try {
            swt = InterceptorProxy.beforeUpdate(runtime, random, run, dest, data, configs, columns);
            if (swt == ACTION.SWITCH.BREAK) {
                int n = -1;
                return n;
            }
            if (null != dmListener) {
                swt = dmListener.beforeUpdate(runtime, random, run, dest, data, columns);
            }
            if (swt == ACTION.SWITCH.BREAK) {
                int n = -1;
                return n;
            }
            result = runtime.getTemplate().update(sql, values.toArray());
            this.checkMany2ManyDependencySave(runtime, random, data, ConfigTable.ENTITY_FIELD_INSERT_DEPENDENCY, 1);
            this.checkOne2ManyDependencySave(runtime, random, data, ConfigTable.ENTITY_FIELD_INSERT_DEPENDENCY, 1);
            millis = System.currentTimeMillis() - fr;
            boolean slow = false;
            long SLOW_SQL_MILLIS = ThreadConfig.check(runtime.getKey()).SLOW_SQL_MILLIS();
            if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
                slow = true;
                log.warn("{}[SLOW SQL][action:update][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, sql, this.paramLogFormat(values)});
                if (null != dmListener) {
                    dmListener.slow(runtime, random, ACTION.DML.UPDATE, run, sql, values, null, true, result, millis);
                }
            }
            if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((int)result, (int)34)});
            }
            sql_success = true;
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                SQLUpdateException ex = new SQLUpdateException("update\u5f02\u5e38:" + e.toString(), e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u66f4\u65b0\u5f02\u5e38:", (int)33) + e.toString(), sql, this.paramLogFormat(run.getUpdateColumns(), values)});
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        if (null != dmListener) {
            dmListener.afterUpdate(runtime, random, run, result, dest, data, columns, sql_success, result, millis);
        }
        InterceptorProxy.afterUpdate(runtime, random, run, dest, data, configs, columns, sql_success, result, System.currentTimeMillis() - fr);
        return result;
    }

    @Override
    public int update(Object data, ConfigStore configs, String ... columns) {
        return this.update(null, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int update(String dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(dest, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int update(Object data, ConfigStore configs, List<String> columns) {
        return this.update(null, data, configs, columns);
    }

    @Override
    public int update(String dest, Object data, String ... columns) {
        return this.update(dest, data, (ConfigStore)null, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int update(Object data, String ... columns) {
        return this.update(null, data, (ConfigStore)null, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int update(String dest, Object data, List<String> columns) {
        return this.update(dest, data, (ConfigStore)null, columns);
    }

    @Override
    public int update(Object data, List<String> columns) {
        return this.update(null, data, (ConfigStore)null, columns);
    }

    @Override
    public int save(String dest, Object data, boolean checkPrimary, String ... columns) {
        if (null == data) {
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                throw new SQLUpdateException("save\u7a7a\u6570\u636e");
            }
            log.error("save\u7a7a\u6570\u636e");
            return -1;
        }
        if (data instanceof Collection) {
            Collection items = (Collection)data;
            int cnt = 0;
            for (Object item : items) {
                cnt += this.save(dest, item, checkPrimary, columns);
            }
            return cnt;
        }
        return this.saveObject(dest, data, checkPrimary, columns);
    }

    @Override
    public int save(Object data, boolean checkPrimary, String ... columns) {
        return this.save(null, data, checkPrimary, columns);
    }

    @Override
    public int save(String dest, Object data, String ... columns) {
        return this.save(dest, data, false, columns);
    }

    @Override
    public int save(Object data, String ... columns) {
        return this.save(null, data, false, columns);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int saveObject(String dest, Object data, boolean checkPrimary, String ... columns) {
        if (null == data) {
            return 0;
        }
        boolean isNew = this.checkIsNew(data);
        if (isNew) {
            return this.insert(dest, data, checkPrimary, columns);
        }
        Boolean override = this.checkOverride(data);
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null == override) return this.update(dest, data, columns);
        DefaultTablePrepare prepare = new DefaultTablePrepare(dest);
        Map<String, Object> pvs = this.checkPv(data);
        DefaultConfigStore stores = new DefaultConfigStore(new String[0]);
        for (String k : pvs.keySet()) {
            stores.and(k, pvs.get(k));
        }
        boolean exists = this.exists((RunPrepare)prepare, stores, new String[0]);
        if (!exists) return this.insert(dest, data, checkPrimary, columns);
        if (override.booleanValue()) {
            return this.update(dest, data, columns);
        }
        log.warn("[\u8df3\u8fc7\u66f4\u65b0][\u6570\u636e\u5df2\u5b58\u5728:{}({})]", (Object)dest, (Object)BeanUtil.map2json(pvs));
        return 0;
    }

    protected Boolean checkOverride(Object obj) {
        Boolean result = null;
        if (null != obj && obj instanceof DataRow) {
            result = ((DataRow)obj).getOverride();
        }
        return result;
    }

    protected Map<String, Object> checkPv(Object obj) {
        HashMap<String, Object> pvs = new HashMap<String, Object>();
        if (null != obj && obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            List ks = row.getPrimaryKeys();
            for (String k : ks) {
                pvs.put(k, row.get(k));
            }
        }
        return pvs;
    }

    protected boolean checkIsNew(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            return row.isNew();
        }
        if (EntityAdapterProxy.hasAdapter()) {
            Map values = EntityAdapterProxy.primaryValues((Object)obj);
            for (Map.Entry entry : values.entrySet()) {
                if (!BasicUtil.isNotEmpty(entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int insert(String dest, Object data, boolean checkPrimary, List<String> columns) {
        return this.insert(null, null, true, dest, data, checkPrimary, columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int insert(JDBCRuntime runtime, String random, boolean recover, String dest, Object data, boolean checkPrimary, List<String> columns) {
        Run run;
        DataSet set;
        Map tags;
        dest = DataSourceHolder.parseDataSource(dest, data);
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null == random) {
            random = this.random();
        }
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        boolean sql_success = false;
        swt = InterceptorProxy.prepareInsert(runtime, random, dest, data, checkPrimary, columns);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1;
        }
        if (null != dmListener) {
            swt = dmListener.prepareInsert(runtime, random, dest, data, checkPrimary, columns);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        if (null != data && data instanceof DataSet && null != (tags = (set = (DataSet)data).getTags()) && tags.size() > 0) {
            LinkedHashMap ptables = this.ptables(false, new MasterTable(dest), tags);
            if (ptables.size() != 1) {
                String msg = "\u5206\u533a\u8868\u5b9a\u4f4d\u5f02\u5e38,\u4e3b\u8868:" + dest + ",\u6807\u7b7e:" + BeanUtil.map2json((Map)tags) + ",\u5206\u533a\u8868:" + BeanUtil.object2json(ptables.keySet());
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new SQLUpdateException(msg);
                }
                log.error(msg);
                return -1;
            }
            dest = ((PartitionTable)ptables.values().iterator().next()).getName();
        }
        if (null == (run = adapter.buildInsertRun(runtime.getTemplate(), dest, data, checkPrimary, columns))) {
            return 0;
        }
        int cnt = 0;
        String sql = run.getFinalInsert();
        List<Object> values = run.getValues();
        long fr = System.currentTimeMillis();
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, this.paramLogFormat(run.getInsertColumns(), values)});
        }
        long millis = -1L;
        try {
            swt = InterceptorProxy.beforeInsert(runtime, random, run, dest, data, checkPrimary, columns);
            if (swt == ACTION.SWITCH.BREAK) {
                int n = -1;
                return n;
            }
            if (null != dmListener) {
                swt = dmListener.beforeInsert(runtime, random, run, dest, data, checkPrimary, columns);
            }
            if (swt == ACTION.SWITCH.BREAK) {
                int n = -1;
                return n;
            }
            cnt = adapter.insert(runtime.getTemplate(), random, data, sql, values, null);
            int ENTITY_FIELD_INSERT_DEPENDENCY = ThreadConfig.check(runtime.getKey()).ENTITY_FIELD_INSERT_DEPENDENCY();
            this.checkMany2ManyDependencySave(runtime, random, data, ENTITY_FIELD_INSERT_DEPENDENCY, 0);
            this.checkOne2ManyDependencySave(runtime, random, data, ENTITY_FIELD_INSERT_DEPENDENCY, 0);
            millis = System.currentTimeMillis() - fr;
            boolean slow = false;
            long SLOW_SQL_MILLIS = ThreadConfig.check(runtime.getKey()).SLOW_SQL_MILLIS();
            if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
                slow = true;
                log.warn("{}[SLOW SQL][action:insert][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, sql, this.paramLogFormat(values)});
                if (null != dmListener) {
                    dmListener.slow(runtime, random, ACTION.DML.INSERT, run, sql, values, null, true, cnt, millis);
                }
            }
            if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((int)cnt, (int)34)});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                SQLUpdateException ex = new SQLUpdateException("insert\u5f02\u5e38:" + e.toString(), e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u63d2\u5165\u5f02\u5e38:", (int)33) + e.toString(), sql, this.paramLogFormat(run.getInsertColumns(), values)});
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        if (null != dmListener) {
            dmListener.afterInsert(runtime, random, run, cnt, dest, data, checkPrimary, columns, sql_success, cnt, millis);
        }
        InterceptorProxy.afterInsert(runtime, random, run, dest, data, checkPrimary, columns, sql_success, cnt, System.currentTimeMillis() - fr);
        return cnt;
    }

    private int checkMany2ManyDependencySave(JDBCRuntime runtime, String random, Object obj, int dependency, int mode) {
        int result = 0;
        if (dependency <= 0) {
            return result;
        }
        if (obj instanceof DataSet || obj instanceof DataRow || obj instanceof Map) {
            return result;
        }
        if (obj instanceof EntitySet) {
            EntitySet set = (EntitySet)obj;
            for (Object entity : set) {
                this.checkMany2ManyDependencySave(runtime, random, entity, dependency, mode);
            }
        } else {
            Class<?> clazz = obj.getClass();
            Column pc = EntityAdapterProxy.primaryKey(clazz);
            String pk = null;
            if (null != pc) {
                pk = pc.getName();
            }
            List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"ManyToMany"});
            for (Field field : fields) {
                try {
                    ManyToMany join = PersistenceAdapter.manyToMany(field);
                    Map primaryValueMap = EntityAdapterProxy.primaryValue((Object)obj);
                    Object pv = primaryValueMap.get(pk.toUpperCase());
                    Object fv = BeanUtil.getFieldValue((Object)obj, (Field)field);
                    if (null == fv) continue;
                    DataSet set = new DataSet();
                    Collection fvs = new ArrayList();
                    if (null == join.dependencyTable) {
                        if (fv.getClass().isArray()) {
                            fvs = BeanUtil.array2collection((Object)fv);
                        } else if (fv instanceof Collection) {
                            fvs = (Collection)fv;
                        }
                    } else {
                        Object objs;
                        Column joinpc = EntityAdapterProxy.primaryKey(clazz);
                        String joinpk = null;
                        if (null != joinpc) {
                            joinpk = joinpc.getName();
                        }
                        if (fv.getClass().isArray()) {
                            for (Object item : objs = (Object[])fv) {
                                fvs.add(EntityAdapterProxy.primaryValue((Object)item).get(joinpk.toUpperCase()));
                            }
                        } else if (fv instanceof Collection) {
                            objs = (Collection)fv;
                            Iterator iterator = objs.iterator();
                            while (iterator.hasNext()) {
                                Object item = iterator.next();
                                fvs.add(EntityAdapterProxy.primaryValue(item).get(joinpk.toUpperCase()));
                            }
                        }
                    }
                    for (Object item : fvs) {
                        DataRow row = new DataRow();
                        row.put(join.joinColumn, pv);
                        row.put(join.inverseJoinColumn, item);
                        set.add(row);
                    }
                    if (mode == 1) {
                        this.deletes(false, join.joinTable, join.joinColumn, pv + "");
                    }
                    this.insert(runtime, random, false, join.joinTable, (Object)set, new String[0]);
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                        continue;
                    }
                    log.error("[check Many2ManyDependency Save][result:fail][msg:{}]", (Object)e.toString());
                }
            }
        }
        --dependency;
        return result;
    }

    private int checkOne2ManyDependencySave(JDBCRuntime runtime, String random, Object obj, int dependency, int mode) {
        int result = 0;
        if (dependency <= 0) {
            return result;
        }
        if (obj instanceof DataSet || obj instanceof DataRow || obj instanceof Map) {
            return result;
        }
        if (obj instanceof EntitySet) {
            EntitySet set = (EntitySet)obj;
            for (Object entity : set) {
                this.checkOne2ManyDependencySave(runtime, random, entity, dependency, mode);
            }
        } else {
            Class<?> clazz = obj.getClass();
            Column pc = EntityAdapterProxy.primaryKey(clazz);
            String pk = null;
            if (null != pc) {
                pk = pc.getName();
            }
            List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"OneToMany"});
            for (Field field : fields) {
                try {
                    OneToMany join = PersistenceAdapter.oneToMany(field);
                    Object pv = EntityAdapterProxy.primaryValue((Object)obj).get(pk.toUpperCase());
                    Object fv = BeanUtil.getFieldValue((Object)obj, (Field)field);
                    if (null == fv) continue;
                    if (null == join.joinField) {
                        throw new RuntimeException(field + "\u5173\u8054\u5c5e\u6027\u5f02\u5e38");
                    }
                    if (null == join.joinColumn) {
                        throw new RuntimeException(field + "\u5173\u8054\u5217\u5f02\u5e38");
                    }
                    if (null == join.dependencyTable) {
                        throw new RuntimeException(field + "\u5173\u8054\u8868\u5f02\u5e38");
                    }
                    if (mode == 1) {
                        this.deletes(false, join.dependencyTable, join.joinColumn, pv + "");
                    }
                    ArrayList<Object> items = new ArrayList<Object>();
                    if (fv.getClass().isArray()) {
                        Object[] objs = (Object[])fv;
                        for (Object item : objs) {
                            BeanUtil.setFieldValue((Object)item, (Field)join.joinField, pv);
                            items.add(item);
                        }
                    } else if (fv instanceof Collection) {
                        Collection cols = (Collection)fv;
                        for (Object item : cols) {
                            BeanUtil.setFieldValue(item, (Field)join.joinField, pv);
                            items.add(item);
                        }
                    }
                    this.insert(runtime, random, false, join.dependencyTable, items, new String[0]);
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                        continue;
                    }
                    log.error("[check One2ManyDependency Save][result:fail][msg:{}]", (Object)e.toString());
                }
            }
        }
        --dependency;
        return result;
    }

    @Override
    public int insert(Object data, boolean checkPrimary, List<String> columns) {
        return this.insert(null, data, checkPrimary, columns);
    }

    @Override
    public int insert(String dest, Object data, List<String> columns) {
        return this.insert(dest, data, false, columns);
    }

    @Override
    public int insert(Object data, List<String> columns) {
        return this.insert(null, data, false, columns);
    }

    @Override
    public int insert(String dest, Object data, boolean checkPrimary, String ... columns) {
        return this.insert(dest, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int insert(Object data, boolean checkPrimary, String ... columns) {
        return this.insert(null, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int insert(String dest, Object data, String ... columns) {
        return this.insert(dest, data, false, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    protected int insert(JDBCRuntime runtime, String random, boolean recover, String dest, Object data, String ... columns) {
        return this.insert(runtime, random, recover, dest, data, false, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int insert(Object data, String ... columns) {
        return this.insert(null, data, false, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    protected List<Map<String, Object>> maps(JDBCRuntime runtime, String random, String sql, List<Object> values) {
        List<Map<String, Object>> maps;
        block12: {
            JDBCAdapter adapter = runtime.getAdapter();
            maps = null;
            if (BasicUtil.isEmpty((Object)sql)) {
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    throw new SQLQueryException("\u672a\u6307\u5b9aSQL");
                }
                log.error("\u672a\u6307\u5b9aSQL");
                return new ArrayList<Map<String, Object>>();
            }
            long fr = System.currentTimeMillis();
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, this.paramLogFormat(values)});
            }
            try {
                maps = null != values && values.size() > 0 ? runtime.getTemplate().queryForList(sql, values.toArray()) : runtime.getTemplate().queryForList(sql);
                long mid = System.currentTimeMillis();
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check(runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L && mid - fr > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[SLOW SQL][action:select][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, mid - fr, sql, this.paramLogFormat(values)});
                    if (null != dmListener) {
                        dmListener.slow(runtime, random, ACTION.DML.SELECT, null, sql, values, null, true, maps, mid);
                    }
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)(mid - fr));
                }
                if (null != adapter) {
                    maps = adapter.process(maps);
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, System.currentTimeMillis() - mid, maps.size()});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38:" + e.toString(), e);
                    ex.setSql(sql);
                    ex.setValues(values);
                    throw ex;
                }
                if (!ConfigTable.IS_SHOW_SQL_WHEN_ERROR) break block12;
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), sql, this.paramLogFormat(values)});
            }
        }
        return maps;
    }

    protected static DataRow row(boolean system, JDBCRuntime runtime, LinkedHashMap<String, Column> metadatas, ResultSet rs) {
        DataRow row = new DataRow();
        try {
            Column column;
            String name;
            int i;
            JDBCAdapter adapter = runtime.getAdapter();
            ResultSetMetaData rsmd = rs.getMetaData();
            int qty = rsmd.getColumnCount();
            if (!system && metadatas.isEmpty()) {
                for (i = 1; i <= qty; ++i) {
                    name = rsmd.getColumnName(i);
                    if (null == name || name.toUpperCase().equals("PAGE_ROW_NUMBER_")) continue;
                    column = metadatas.get(name);
                    column = adapter.column(column, rsmd, i);
                    metadatas.put(name.toUpperCase(), column);
                }
            }
            for (i = 1; i <= qty; ++i) {
                name = rsmd.getColumnLabel(i);
                if (null == name || name.toUpperCase().equals("PAGE_ROW_NUMBER_")) continue;
                column = metadatas.get(name.toUpperCase());
                Object value = adapter.read(column, rs.getObject(name), null);
                row.put(false, name, value);
            }
            row.setMetadatas(metadatas);
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[\u5c01\u88c5\u7ed3\u679c\u96c6][result:fail][msg:{}]", (Object)e.toString());
        }
        return row;
    }

    protected DataSet select(JDBCRuntime runtime, String random, String table, String sql, List<Object> values) {
        return this.select(runtime, random, false, table, sql, values);
    }

    protected DataSet select(JDBCRuntime runtime, String random, String table, Run run) {
        if (null == run) {
            return new DataSet();
        }
        return this.select(runtime, random, false, table, run.getFinalQuery(), run.getValues());
    }

    protected DataSet select(JDBCRuntime runtime, String random, final boolean system, String table, String sql, List<Object> values) {
        DataSet set;
        block18: {
            if (BasicUtil.isEmpty((Object)sql)) {
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    throw new SQLQueryException("\u672a\u6307\u5b9aSQL");
                }
                log.error("\u672a\u6307\u5b9aSQL");
                return new DataSet();
            }
            long fr = System.currentTimeMillis();
            if (null == runtime) {
                runtime = this.runtime();
            }
            if (null == random) {
                random = this.random();
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, this.paramLogFormat(values)});
            }
            set = new DataSet();
            LinkedHashMap<Object, Object> columns = new LinkedHashMap();
            if (!system && ThreadConfig.check(runtime.getKey()).IS_AUTO_CHECK_METADATA() && null != table) {
                columns = this.columns(runtime, random, false, new Table(null, null, table));
            }
            try {
                final JDBCRuntime rt = runtime;
                final long[] mid = new long[]{System.currentTimeMillis()};
                final boolean[] process = new boolean[]{false};
                final LinkedHashMap metadatas = new LinkedHashMap();
                metadatas.putAll(columns);
                set.setMetadatas(metadatas);
                if (null != values && values.size() > 0) {
                    runtime.getTemplate().query(sql, values.toArray(), new RowCallbackHandler(){

                        public void processRow(ResultSet rs) throws SQLException {
                            if (!process[0]) {
                                mid[0] = System.currentTimeMillis();
                            }
                            DataRow row = DefaultDao.row(system, rt, metadatas, rs);
                            set.add(row);
                            process[0] = true;
                        }
                    });
                } else {
                    runtime.getTemplate().query(sql, new RowCallbackHandler(){

                        public void processRow(ResultSet rs) throws SQLException {
                            if (!process[0]) {
                                mid[0] = System.currentTimeMillis();
                            }
                            DataRow row = DefaultDao.row(system, rt, metadatas, rs);
                            set.add(row);
                            process[0] = true;
                        }
                    });
                }
                if (!process[0]) {
                    mid[0] = System.currentTimeMillis();
                }
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check(runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L) {
                    slow = true;
                    if (mid[0] - fr > SLOW_SQL_MILLIS) {
                        log.warn("{}[SLOW SQL][action:select][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, mid[0] - fr, sql, this.paramLogFormat(values)});
                        if (null != dmListener) {
                            dmListener.slow(runtime, random, ACTION.DML.SELECT, null, sql, values, null, true, set, mid[0] - fr);
                        }
                    }
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)(mid[0] - fr));
                }
                set.setDatalink(runtime.datasource());
                if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, System.currentTimeMillis() - mid[0], set.size()});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38:" + e.toString(), e);
                    ex.setSql(sql);
                    ex.setValues(values);
                    throw ex;
                }
                if (!ConfigTable.IS_SHOW_SQL_WHEN_ERROR) break block18;
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), sql, this.paramLogFormat(values)});
            }
        }
        return set;
    }

    protected <T> EntitySet<T> select(JDBCRuntime runtime, String random, Class<T> clazz, String table, String sql, List<Object> values, int dependency) {
        EntitySet set = new EntitySet();
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null == random) {
            random = this.random();
        }
        DataSet rows = this.select(runtime, random, table, sql, values);
        for (DataRow row : rows) {
            Object entity = null;
            entity = EntityAdapterProxy.hasAdapter() ? EntityAdapterProxy.entity(clazz, (Map)row, null) : row.entity(clazz, new String[0]);
            set.add(entity);
        }
        if (dependency > 0) {
            this.checkMany2ManyDependencyQuery(runtime, random, set, dependency);
            this.checkOne2ManyDependencyQuery(runtime, random, set, dependency);
        }
        return set;
    }

    protected <T> void checkMany2ManyDependencyQuery(JDBCRuntime runtime, String random, EntitySet<T> set, int dependency) {
        if (set.size() == 0 || dependency <= 0) {
            return;
        }
        --dependency;
        Class<?> clazz = set.get(0).getClass();
        Column pc = EntityAdapterProxy.primaryKey(clazz);
        String pk = null;
        if (null != pc) {
            pk = pc.getName();
        }
        List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"ManyToMany"});
        Compare compare = ThreadConfig.check(runtime.getKey()).ENTITY_FIELD_SELECT_DEPENDENCY_COMPARE();
        for (Field field : fields) {
            try {
                DefaultConfigStore conditions;
                String sql;
                ManyToMany join = PersistenceAdapter.manyToMany(field);
                if (Compare.EQUAL == compare || set.size() == 1) {
                    for (Object entity : set) {
                        Map primaryValueMap = EntityAdapterProxy.primaryValue(entity);
                        if (null == join.dependencyTable) {
                            DataSet items = this.querys(runtime, random, false, (RunPrepare)new DefaultTablePrepare(join.joinTable), (ConfigStore)new DefaultConfigStore(new String[0]), "++" + join.joinColumn + ":" + primaryValueMap.get(pk.toUpperCase()));
                            List ids = items.getStrings(join.inverseJoinColumn);
                            BeanUtil.setFieldValue(entity, (Field)field, (Object)ids);
                            continue;
                        }
                        sql = "SELECT * FROM " + join.dependencyTable + " WHERE " + join.dependencyPk + " IN (SELECT " + join.inverseJoinColumn + " FROM " + join.joinTable + " WHERE " + join.joinColumn + "=?" + ")";
                        ArrayList<Object> params = new ArrayList<Object>();
                        params.add(primaryValueMap.get(pk.toUpperCase()));
                        EntitySet<T> dependencys = this.select(runtime, random, join.itemClass, null, sql, params, dependency);
                        BeanUtil.setFieldValue(entity, (Field)field, dependencys);
                    }
                    continue;
                }
                if (Compare.IN != compare) continue;
                ArrayList pvs = new ArrayList();
                HashMap idmap = new HashMap();
                for (Object entity : set) {
                    Map primaryValueMap = EntityAdapterProxy.primaryValue(entity);
                    Object pv = primaryValueMap.get(pk.toUpperCase());
                    pvs.add(pv);
                    idmap.put(entity, pv);
                }
                if (null == join.dependencyTable) {
                    conditions = new DefaultConfigStore(new String[0]);
                    conditions.and(join.joinColumn, pvs);
                    DataSet allItems = this.querys(runtime, random, false, (RunPrepare)new DefaultTablePrepare(join.joinTable), (ConfigStore)conditions, new String[0]);
                    for (Object entity : set) {
                        DataSet items = allItems.getRows(new String[]{join.joinColumn, idmap.get(entity) + ""});
                        List ids = items.getStrings(join.inverseJoinColumn);
                        BeanUtil.setFieldValue(entity, (Field)field, (Object)ids);
                    }
                    continue;
                }
                conditions = new DefaultConfigStore(new String[0]);
                conditions.param("JOIN_PVS", pvs);
                sql = "SELECT M.*, F." + join.joinColumn + " FK_" + join.joinColumn + " FROM " + join.dependencyTable + " M RIGHT JOIN " + join.joinTable + " F ON M." + join.dependencyPk + " = " + join.inverseJoinColumn + " WHERE " + join.joinColumn + " IN(#{JOIN_PVS})";
                DataSet alls = this.querys(runtime, random, false, (RunPrepare)new DefaultTextPrepare(sql), (ConfigStore)conditions, new String[0]);
                for (Object entity : set) {
                    DataSet items = alls.getRows(new String[]{"FK_" + join.joinColumn, idmap.get(entity) + ""});
                    BeanUtil.setFieldValue(entity, (Field)field, (Object)items.entity(join.itemClass));
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                    continue;
                }
                log.error("[check Many2ManyDependency query][result:fail][msg:{}]", (Object)e.toString());
            }
        }
    }

    protected <T> void checkOne2ManyDependencyQuery(JDBCRuntime runtime, String random, EntitySet<T> set, int dependency) {
        if (set.size() == 0 || dependency <= 0) {
            return;
        }
        --dependency;
        Class<?> clazz = set.get(0).getClass();
        Column pc = EntityAdapterProxy.primaryKey(clazz);
        String pk = null;
        if (null != pc) {
            pk = pc.getName();
        }
        List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"OneToMany"});
        Compare compare = ThreadConfig.check(runtime.getKey()).ENTITY_FIELD_SELECT_DEPENDENCY_COMPARE();
        for (Field field : fields) {
            try {
                OneToMany join = PersistenceAdapter.oneToMany(field);
                if (Compare.EQUAL == compare || set.size() == 1) {
                    for (Object entity : set) {
                        Object pv = EntityAdapterProxy.primaryValue(entity).get(pk.toUpperCase());
                        Map primaryValueMap = EntityAdapterProxy.primaryValue(entity);
                        ArrayList params = new ArrayList();
                        params.add(primaryValueMap.get(pk.toUpperCase()));
                        EntitySet<T> dependencys = this.querys(runtime, random, false, join.dependencyClass, new DefaultConfigStore(new String[0]).and(join.joinColumn, pv), new String[0]);
                        BeanUtil.setFieldValue(entity, (Field)field, dependencys);
                    }
                    continue;
                }
                if (Compare.IN != compare) continue;
                ArrayList pvs = new ArrayList();
                HashMap idmap = new HashMap();
                for (Object entity : set) {
                    Map primaryValueMap = EntityAdapterProxy.primaryValue(entity);
                    Object pv = primaryValueMap.get(pk.toUpperCase());
                    pvs.add(pv);
                    idmap.put(entity, pv);
                }
                DefaultConfigStore conditions = new DefaultConfigStore(new String[0]);
                conditions.and(join.joinColumn, pvs);
                EntitySet<T> alls = this.querys(runtime, random, false, join.dependencyClass, (ConfigStore)conditions, new String[0]);
                for (Object entity : set) {
                    EntitySet items = alls.gets(join.joinField, idmap.get(entity));
                    BeanUtil.setFieldValue(entity, (Field)field, (Object)items);
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                    continue;
                }
                log.error("[check One2ManyDependency query][result:fail][msg:{}]", (Object)e.toString());
            }
        }
    }

    @Override
    public int execute(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.execute(null, null, true, prepare, configs, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execute(JDBCRuntime runtime, String random, boolean recover, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        int result = -1;
        boolean sql_success = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null == random) {
            random = this.random();
        }
        JDBCAdapter adapter = runtime.getAdapter();
        swt = InterceptorProxy.prepareExecute(runtime, random, prepare, configs, conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1;
        }
        Run run = adapter.buildExecuteRun(prepare, configs, conditions);
        if (!run.isValid()) {
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][RunPrepare:" + ConfigParser.createSQLSign(false, false, prepare.getTable(), configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + this.runtime().datasource() + "]");
            }
            return -1;
        }
        String txt = run.getFinalExecute();
        List<Object> values = run.getValues();
        long fr = System.currentTimeMillis();
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, txt, this.paramLogFormat(values)});
        }
        long millis = -1L;
        try {
            swt = InterceptorProxy.beforeExecute(runtime, random, run);
            if (swt == ACTION.SWITCH.BREAK) {
                int n = -1;
                return n;
            }
            if (null != dmListener) {
                swt = dmListener.beforeExecute(runtime, random, run);
            }
            if (swt == ACTION.SWITCH.BREAK) {
                int n = -1;
                return n;
            }
            result = null != values && values.size() > 0 ? runtime.getTemplate().update(txt, values.toArray()) : runtime.getTemplate().update(txt);
            sql_success = true;
            millis = System.currentTimeMillis() - fr;
            boolean slow = false;
            long SLOW_SQL_MILLIS = ThreadConfig.check(runtime.getKey()).SLOW_SQL_MILLIS();
            if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
                slow = true;
                log.warn("{}[SLOW SQL][action:execute][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, txt, this.paramLogFormat(values)});
                if (null != dmListener) {
                    dmListener.slow(runtime, random, ACTION.DML.EXECUTE, run, txt, values, null, true, result, millis);
                }
            }
            if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((int)result, (int)34)});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                throw e;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"SQL\u6267\u884c\u5f02\u5e38:", (int)33) + e.toString(), prepare, this.paramLogFormat(values)});
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        if (null != dmListener) {
            dmListener.afterExecute(runtime, random, run, sql_success, result, millis);
        }
        InterceptorProxy.afterExecute(runtime, random, run, sql_success, result, System.currentTimeMillis() - fr);
        return result;
    }

    @Override
    public int execute(RunPrepare prepare, String ... conditions) {
        return this.execute(prepare, (ConfigStore)null, conditions);
    }

    @Override
    public boolean execute(Procedure procedure) {
        return this.execute(null, null, true, procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean execute(JDBCRuntime runtime, String random, boolean recover, final Procedure procedure) {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        boolean sql_success = false;
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null == random) {
            random = this.random();
        }
        if ((swt = InterceptorProxy.prepareExecute(runtime, random, procedure)) == ACTION.SWITCH.BREAK) {
            return false;
        }
        if (null != dmListener) {
            swt = dmListener.prepareExecute(runtime, random, procedure);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        List list = new ArrayList();
        final List inputs = procedure.getInputs();
        final List outputs = procedure.getOutputs();
        long fr = System.currentTimeMillis();
        String sql = " {";
        boolean returnIndex = false;
        if (procedure.hasReturn()) {
            sql = sql + "? = ";
            returnIndex = true;
        }
        sql = sql + "call " + procedure.getName() + "(";
        final int sizeIn = inputs.size();
        final int sizeOut = outputs.size();
        int size = sizeIn + sizeOut;
        for (int i = 0; i < size; ++i) {
            sql = sql + "?";
            if (i >= size - 1) continue;
            sql = sql + ",";
        }
        sql = sql + ")}";
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, sql, this.paramLogFormat(inputs), this.paramLogFormat(outputs)});
        }
        long millis = -1L;
        try {
            swt = InterceptorProxy.beforeExecute(runtime, random, procedure, sql, inputs, outputs);
            if (swt == ACTION.SWITCH.BREAK) {
                boolean bl = false;
                return bl;
            }
            if (null != dmListener) {
                swt = dmListener.beforeExecute(runtime, random, procedure);
            }
            if (swt == ACTION.SWITCH.BREAK) {
                boolean bl = false;
                return bl;
            }
            list = (List)runtime.getTemplate().execute(sql, (CallableStatementCallback)new CallableStatementCallback<Object>(){

                public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                    Parameter param;
                    int i;
                    ArrayList<Object> result = new ArrayList<Object>();
                    int returnIndex = 0;
                    if (procedure.hasReturn()) {
                        returnIndex = 1;
                        cs.registerOutParameter(1, 12);
                    }
                    for (i = 1; i <= sizeIn; ++i) {
                        param = (Parameter)inputs.get(i - 1);
                        Object value = param.getValue();
                        if (null == value || "NULL".equalsIgnoreCase(value.toString())) {
                            value = null;
                        }
                        cs.setObject(i + returnIndex, value, (int)param.getType());
                    }
                    for (i = 1; i <= sizeOut; ++i) {
                        param = (Parameter)outputs.get(i - 1);
                        if (null == param.getValue()) {
                            cs.registerOutParameter(i + sizeIn + returnIndex, (int)param.getType());
                            continue;
                        }
                        cs.setObject(i + sizeIn + returnIndex, param.getValue(), (int)param.getType());
                    }
                    cs.execute();
                    if (procedure.hasReturn()) {
                        result.add(cs.getObject(1));
                    }
                    if (sizeOut > 0) {
                        for (i = 1; i <= sizeOut; ++i) {
                            Object output = cs.getObject(sizeIn + returnIndex + i);
                            result.add(output);
                        }
                    }
                    return result;
                }
            });
            sql_success = true;
            procedure.setResult(list);
            result = true;
            millis = System.currentTimeMillis() - fr;
            boolean slow = false;
            long SLOW_SQL_MILLIS = ThreadConfig.check(runtime.getKey()).SLOW_SQL_MILLIS();
            if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
                log.warn("{}[SLOW SQL][action:procedure][millis:{}ms][sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, millis, sql, this.paramLogFormat(inputs), this.paramLogFormat(list)});
                if (null != dmListener) {
                    dmListener.slow(runtime, random, ACTION.DML.PROCEDURE, null, sql, inputs, list, true, result, millis);
                }
            }
            if (null != dmListener) {
                dmListener.afterExecute(runtime, random, procedure, result, millis);
            }
            if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[\u6267\u884c\u8017\u65f6:{}ms]\n[output param:{}]", new Object[]{random, millis, list});
            }
        }
        catch (Exception e) {
            result = false;
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                SQLUpdateException ex = new SQLUpdateException("execute\u5f02\u5e38:" + e.toString(), e);
                ex.setSql(sql);
                throw ex;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, LogUtil.format((String)"\u5b58\u50a8\u8fc7\u7a0b\u6267\u884c\u5f02\u5e38:", (int)33) + e.toString(), sql, this.paramLogFormat(inputs), this.paramLogFormat(outputs)});
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        InterceptorProxy.afterExecute(runtime, random, procedure, sql, inputs, outputs, sql_success, result, System.currentTimeMillis() - fr);
        return result;
    }

    @Override
    public DataSet querys(Procedure procedure, PageNavi navi) {
        return this.querys(null, null, true, procedure, navi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSet querys(JDBCRuntime runtime, String random, boolean recover, final Procedure procedure, final PageNavi navi) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null == random) {
            random = this.random();
        }
        boolean sql_success = false;
        long fr = System.currentTimeMillis();
        ACTION.SWITCH swt = InterceptorProxy.prepareQuery(runtime, random, procedure, navi);
        if (swt == ACTION.SWITCH.BREAK) {
            return new DataSet();
        }
        final List inputs = procedure.getInputs();
        final List outputs = procedure.getOutputs();
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[sql:\n{}\n][input param:{}]\n[output param:{}]", new Object[]{random, procedure.getName(), this.paramLogFormat(inputs), this.paramLogFormat(outputs)});
        }
        final String rdm = random;
        DataSet set = null;
        long millis = -1L;
        try {
            swt = InterceptorProxy.beforeQuery(runtime, random, procedure, inputs, outputs, navi);
            if (swt == ACTION.SWITCH.BREAK) {
                DataSet dataSet = new DataSet();
                return dataSet;
            }
            if (null != dmListener) {
                dmListener.beforeQuery(runtime, random, procedure);
            }
            final JDBCRuntime rt = runtime;
            set = (DataSet)runtime.getTemplate().execute(new CallableStatementCreator(){

                public CallableStatement createCallableStatement(Connection conn) throws SQLException {
                    Parameter param;
                    int i;
                    String sql = "{call " + procedure.getName() + "(";
                    int sizeIn = inputs.size();
                    int sizeOut = outputs.size();
                    int size = sizeIn + sizeOut;
                    for (int i2 = 0; i2 < size; ++i2) {
                        sql = sql + "?";
                        if (i2 >= size - 1) continue;
                        sql = sql + ",";
                    }
                    sql = sql + ")}";
                    CallableStatement cs = conn.prepareCall(sql);
                    for (i = 1; i <= sizeIn; ++i) {
                        param = (Parameter)inputs.get(i - 1);
                        Object value = param.getValue();
                        if (null == value || "NULL".equalsIgnoreCase(value.toString())) {
                            value = null;
                        }
                        cs.setObject(i, value, (int)param.getType());
                    }
                    for (i = 1; i <= sizeOut; ++i) {
                        param = (Parameter)outputs.get(i - 1);
                        if (null == param.getValue()) {
                            cs.registerOutParameter(i + sizeIn, (int)param.getType());
                            continue;
                        }
                        cs.setObject(i, param.getValue(), (int)param.getType());
                    }
                    return cs;
                }
            }, (CallableStatementCallback)new CallableStatementCallback<Object>(){

                public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                    ResultSet rs = cs.executeQuery();
                    DataSet set = new DataSet();
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int cols = rsmd.getColumnCount();
                    for (int i = 1; i <= cols; ++i) {
                        set.addHead(rsmd.getColumnLabel(i));
                    }
                    long mid = System.currentTimeMillis();
                    int index = 0;
                    int first = -1;
                    int last = -1;
                    if (null != navi) {
                        first = navi.getFirstRow();
                        last = navi.getLastRow();
                    }
                    while (rs.next()) {
                        if (first == -1 || index >= first && index <= last) {
                            DataRow row = new DataRow();
                            for (int i = 1; i <= cols; ++i) {
                                row.put(rsmd.getColumnLabel(i), rs.getObject(i));
                            }
                            set.addRow(row);
                        }
                        if (first == -1 || ++index <= last && (first != 0 || last != 0)) continue;
                    }
                    if (null != navi) {
                        navi.setTotalRow(index);
                        set.setNavi(navi);
                    }
                    set.setDatalink(rt.datasource());
                    if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                        log.info("{}[\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{rdm, System.currentTimeMillis() - mid, set.size()});
                    }
                    return set;
                }
            });
            sql_success = true;
            millis = System.currentTimeMillis() - fr;
            boolean slow = false;
            long SLOW_SQL_MILLIS = ThreadConfig.check(runtime.getKey()).SLOW_SQL_MILLIS();
            if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
                log.warn("{}[SLOW SQL][action:procedure][millis:{}ms][sql:\n{}\n][input param:{}]\n[output param:{}]", new Object[]{random, millis, procedure.getName(), this.paramLogFormat(inputs), this.paramLogFormat(outputs)});
                if (null != dmListener) {
                    dmListener.slow(runtime, random, ACTION.DML.PROCEDURE, null, procedure.getName(), inputs, outputs, true, set, millis);
                }
            }
            if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)millis);
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38:" + e.toString(), e);
                throw ex;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, LogUtil.format((String)"\u5b58\u50a8\u8fc7\u7a0b\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), procedure.getName(), this.paramLogFormat(inputs), this.paramLogFormat(outputs)});
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        if (null != dmListener) {
            dmListener.afterQuery(runtime, random, procedure, sql_success, set, millis);
        }
        InterceptorProxy.afterQuery(runtime, random, procedure, inputs, outputs, navi, sql_success, set, System.currentTimeMillis() - fr);
        return set;
    }

    @Override
    public <T> int deletes(String table, String key, Collection<T> values) {
        return this.deletes(true, table, key, values);
    }

    protected <T> int deletes(JDBCRuntime runtime, String random, boolean recover, String table, String key, Collection<T> values) {
        ACTION.SWITCH swt;
        table = DataSourceHolder.parseDataSource(table, null);
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null == random) {
            random = this.random();
        }
        if ((swt = InterceptorProxy.prepareDelete(runtime, random, table, key, values)) == ACTION.SWITCH.BREAK) {
            return -1;
        }
        if (null != dmListener) {
            swt = dmListener.prepareDelete(runtime, random, table, key, values);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        Run run = adapter.buildDeleteRun(table, key, values);
        if (!run.isValid()) {
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][table:" + table + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
            }
            return -1;
        }
        int result = this.exeDelete(runtime, random, recover, run);
        return result;
    }

    @Override
    public int deletes(String table, String key, Object ... values) {
        return this.deletes(true, table, key, values);
    }

    protected int deletes(boolean recover, String table, String key, Object ... values) {
        table = DataSourceHolder.parseDataSource(table, null);
        JDBCRuntime runtime = this.runtime();
        ArrayList<Object> list = new ArrayList<Object>();
        if (null != values) {
            for (Object value : values) {
                if (value instanceof Collection) {
                    list.addAll((Collection)value);
                    continue;
                }
                list.add(value);
            }
        }
        return this.deletes((JDBCRuntime)null, (String)null, recover, table, key, (Collection)list);
    }

    @Override
    public int delete(String dest, Object obj, String ... columns) {
        dest = DataSourceHolder.parseDataSource(dest, obj);
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        int size = 0;
        if (null != obj) {
            if (obj instanceof Collection) {
                Collection list = (Collection)obj;
                for (Object item : list) {
                    int qty = this.delete(dest, item, columns);
                    if (qty <= 0) continue;
                    size += qty;
                }
                if (log.isInfoEnabled()) {
                    log.info("[delete Collection][\u5f71\u54cd\u884c\u6570:{}]", (Object)LogUtil.format((int)size, (int)34));
                }
            } else {
                swt = InterceptorProxy.prepareDelete(runtime, random, dest, obj, columns);
                if (swt == ACTION.SWITCH.BREAK) {
                    return -1;
                }
                if (null != dmListener) {
                    swt = dmListener.prepareDelete(runtime, random, dest, obj, columns);
                }
                if (swt == ACTION.SWITCH.BREAK) {
                    return -1;
                }
                JDBCAdapter adapter = runtime.getAdapter();
                Run run = adapter.buildDeleteRun(dest, obj, columns);
                if (!run.isValid()) {
                    if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                        log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + dest + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
                    }
                    return -1;
                }
                size = this.exeDelete(runtime, random, true, run);
                if (size > 0 && ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY > 0 && !(obj instanceof DataRow)) {
                    this.checkMany2ManyDependencyDelete(runtime, random, obj, ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY);
                    this.checkOne2ManyDependencyDelete(runtime, random, obj, ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY);
                }
            }
        }
        return size;
    }

    private int checkMany2ManyDependencyDelete(JDBCRuntime runtime, String random, Object entity, int dependency) {
        int result = 0;
        if (dependency <= 0) {
            return result;
        }
        --dependency;
        Class<?> clazz = entity.getClass();
        Column pc = EntityAdapterProxy.primaryKey(clazz);
        String pk = null;
        if (null != pc) {
            pk = pc.getName();
        }
        List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"ManyToMany"});
        for (Field field : fields) {
            try {
                ManyToMany join = PersistenceAdapter.manyToMany(field);
                this.deletes(false, join.joinTable, join.joinColumn, EntityAdapterProxy.primaryValue((Object)entity).get(pk.toUpperCase()) + "");
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                    continue;
                }
                log.error("[check Many2ManyDependency delete][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        return result;
    }

    private int checkOne2ManyDependencyDelete(JDBCRuntime runtime, String random, Object entity, int dependency) {
        int result = 0;
        if (dependency <= 0) {
            return result;
        }
        --dependency;
        Class<?> clazz = entity.getClass();
        Column pc = EntityAdapterProxy.primaryKey(clazz);
        String pk = null;
        if (null != pc) {
            pk = pc.getName();
        }
        List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"OneToMany"});
        for (Field field : fields) {
            try {
                OneToMany join = PersistenceAdapter.oneToMany(field);
                this.deletes(false, join.dependencyTable, join.joinColumn, EntityAdapterProxy.primaryValue((Object)entity).get(pk.toUpperCase()) + "");
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                    continue;
                }
                log.error("[check One2ManyDependency delete][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        return result;
    }

    @Override
    public int delete(String table, ConfigStore configs, String ... conditions) {
        table = DataSourceHolder.parseDataSource(table, null);
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        swt = InterceptorProxy.prepareDelete(runtime, random, table, configs, conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1;
        }
        if (null != dmListener) {
            swt = dmListener.prepareDelete(runtime, random, table, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        Run run = adapter.buildDeleteRun(table, configs, conditions);
        if (!run.isValid()) {
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][table:" + table + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
            }
            return -1;
        }
        int result = this.exeDelete(runtime, random, true, run);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int exeDelete(JDBCRuntime runtime, String random, boolean recover, Run run) {
        int result = -1;
        boolean sql_success = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        String sql = run.getFinalDelete();
        List<Object> values = run.getValues();
        long fr = System.currentTimeMillis();
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, this.paramLogFormat(values)});
        }
        if ((swt = InterceptorProxy.beforeDelete(runtime, random, run)) == ACTION.SWITCH.BREAK) {
            return -1;
        }
        if (null != dmListener) {
            swt = dmListener.beforeDelete(runtime, random, run);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1;
        }
        long millis = -1L;
        try {
            result = null == values ? runtime.getTemplate().update(sql) : runtime.getTemplate().update(sql, values.toArray());
            sql_success = true;
            millis = System.currentTimeMillis() - fr;
            boolean slow = false;
            long SLOW_SQL_MILLIS = ThreadConfig.check(runtime.getKey()).SLOW_SQL_MILLIS();
            if (SLOW_SQL_MILLIS > 0L) {
                slow = true;
                if (millis > SLOW_SQL_MILLIS) {
                    log.warn("{}[SLOW SQL][action:delete][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, sql, this.paramLogFormat(values)});
                    if (null != dmListener) {
                        dmListener.slow(runtime, random, ACTION.DML.DELETE, run, sql, values, null, sql_success, result, millis);
                    }
                }
            }
            if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((int)result, (int)34)});
            }
        }
        catch (Exception e) {
            result = 0;
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                SQLUpdateException ex = new SQLUpdateException("delete\u5f02\u5e38:" + e.toString(), e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u5220\u9664\u5f02\u5e38:", (int)33) + e.toString(), sql, this.paramLogFormat(values)});
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        if (null != dmListener) {
            dmListener.afterDelete(runtime, random, run, sql_success, result, millis);
        }
        InterceptorProxy.afterDelete(runtime, random, run, sql_success, result, millis);
        return result;
    }

    @Override
    public int truncate(String table) {
        table = DataSourceHolder.parseDataSource(table);
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        List<Run> runs = adapter.buildTruncateSQL(table);
        if (null != runs && runs.size() > 0) {
            DefaultTextPrepare prepare = new DefaultTextPrepare(runs.get(0).getFinalUpdate());
            return this.execute((RunPrepare)prepare, new String[0]);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, Database> databases() {
        LinkedHashMap<String, Database> databases = new LinkedHashMap<String, Database>();
        DataSource ds = null;
        Connection con = null;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String random = this.random();
        try {
            long fr;
            block14: {
                fr = System.currentTimeMillis();
                ds = runtime.getTemplate().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                try {
                    List<Run> runs = adapter.buildQueryDatabaseRunSQL();
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, null, run.getFinalQuery(), run.getValues()).toUpperKey();
                            databases = adapter.databases(idx++, true, databases, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block14;
                    log.warn("{}[databases][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[databases][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, databases.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            } else {
                log.error("[databases][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return databases;
    }

    private void tableMap(JDBCRuntime runtime, String random, DataSource ds, Connection con, String catalog, String schema) {
        Map<String, String> names = CacheProxy.names(catalog, schema);
        if (null == names || names.isEmpty()) {
            if (null == runtime) {
                runtime = this.runtime();
            }
            if (null == random) {
                random = this.random();
            }
            JDBCAdapter adapter = runtime.getAdapter();
            LinkedHashMap<Object, Object> tables = new LinkedHashMap();
            boolean sys = false;
            try {
                List<Run> runs = adapter.buildQueryTableRunSQL(null, null, null, null);
                if (null != runs && runs.size() > 0) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, null, run.getFinalQuery(), run.getValues()).toUpperKey();
                        tables = adapter.tables(idx++, true, catalog, schema, tables, set);
                        sys = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!sys) {
                try {
                    tables = adapter.tables(true, null, con.getMetaData(), catalog, schema, null, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (null != tables) {
                for (Table table : tables.values()) {
                    CacheProxy.name(table.getCatalog(), table.getSchema(), table.getName(), table.getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(boolean greedy, String catalog, String schema, String pattern, String types) {
        LinkedHashMap<Object, Table> tables = new LinkedHashMap();
        DataSource ds = null;
        Connection con = null;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String random = this.random();
        try {
            String origin;
            long fr;
            block37: {
                String[] tps;
                block36: {
                    fr = System.currentTimeMillis();
                    ds = runtime.getTemplate().getDataSource();
                    con = DataSourceUtils.getConnection((DataSource)ds);
                    Table search = new Table();
                    if (null == catalog || null == schema) {
                        Table tmp = new Table();
                        if (!greedy) {
                            adapter.checkSchema(con, tmp);
                        }
                        if (null == catalog) {
                            catalog = tmp.getCatalog();
                        }
                        if (null == schema) {
                            schema = tmp.getSchema();
                        }
                    }
                    if (null == (origin = CacheProxy.name(greedy, catalog, schema, pattern))) {
                        this.tableMap(runtime, random, ds, con, catalog, schema);
                    }
                    if (null == (origin = CacheProxy.name(greedy, catalog, schema, pattern))) {
                        origin = pattern;
                    }
                    search.setName(origin);
                    search.setCatalog(catalog);
                    search.setSchema(schema);
                    tps = null;
                    if (null != types) {
                        tps = types.toUpperCase().trim().split(",");
                    }
                    try {
                        List<Run> runs = adapter.buildQueryTableRunSQL(catalog, schema, origin, types);
                        if (null != runs) {
                            int idx = 0;
                            for (Run run : runs) {
                                DataSet set = this.select(runtime, random, null, run.getFinalQuery(), run.getValues()).toUpperKey();
                                tables = adapter.tables(idx++, true, catalog, schema, tables, set);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block36;
                        log.warn("{}[tables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
                if (null == tables || tables.size() == 0) {
                    try {
                        LinkedHashMap jdbcTables = adapter.tables(true, null, con.getMetaData(), catalog, schema, origin, tps);
                        for (String key : jdbcTables.keySet()) {
                            Table item;
                            if (tables.containsKey(key.toUpperCase()) || null == (item = (Table)jdbcTables.get(key)) || !greedy && !(catalog + "_" + schema).equalsIgnoreCase(item.getCatalog() + "_" + item.getSchema())) continue;
                            tables.put(key.toUpperCase(), item);
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        log.warn("{}[tables][][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636ejdbc\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
                boolean comment = false;
                if (null != tables) {
                    for (Table table : tables.values()) {
                        if (!BasicUtil.isNotEmpty((Object)table.getComment())) continue;
                        comment = true;
                        break;
                    }
                }
                if (!comment) {
                    try {
                        List<Run> runs = adapter.buildQueryTableCommentRunSQL(catalog, schema, null, types);
                        if (null != runs) {
                            int idx = 0;
                            for (Run run : runs) {
                                DataSet set = this.select(runtime, random, null, run.getFinalQuery(), run.getValues()).toUpperKey();
                                tables = adapter.comments(idx++, true, catalog, schema, tables, set);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block37;
                        log.info("{}[tables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[tables][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, origin, types, tables.size(), System.currentTimeMillis() - fr});
            }
            if (BasicUtil.isNotEmpty((Object)origin)) {
                LinkedHashMap<String, Table> tmps = new LinkedHashMap<String, Table>();
                List keys = BeanUtil.getMapKeys(tables);
                for (String key : keys) {
                    Table item = (Table)tables.get(key);
                    String name = item.getName(greedy);
                    if (!RegularUtil.match((String)name, (String)origin)) continue;
                    tmps.put(name.toUpperCase(), item);
                }
                tables = tmps;
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            } else {
                log.error("[tables][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return tables;
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(boolean greedy, String schema, String name, String types) {
        return this.tables(greedy, null, schema, name, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(boolean greedy, String name, String types) {
        return this.tables(greedy, null, null, name, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(boolean greedy, String types) {
        return this.tables(greedy, null, null, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(boolean greedy) {
        return this.tables(greedy, null, null, null, "TABLE");
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(String catalog, String schema, String pattern, String types) {
        return this.tables(false, catalog, schema, pattern, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(String schema, String name, String types) {
        return this.tables(false, null, schema, name, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(String name, String types) {
        return this.tables(false, null, null, name, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(String types) {
        return this.tables(false, null, null, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables() {
        return this.tables(false, null, null, null, "TABLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends View> LinkedHashMap<String, T> views(boolean greedy, String catalog, String schema, String pattern, String types) {
        LinkedHashMap<Object, Object> views = new LinkedHashMap();
        DataSource ds = null;
        Connection con = null;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String random = this.random();
        try {
            LinkedHashMap<Object, Object> tmps;
            String[] tps;
            long fr;
            block29: {
                fr = System.currentTimeMillis();
                ds = runtime.getTemplate().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                View search = new View();
                if (null == catalog || null == schema) {
                    View tmp = new View();
                    if (!greedy) {
                        adapter.checkSchema(con, (Table)tmp);
                    }
                    if (null == catalog) {
                        catalog = tmp.getCatalog();
                    }
                    if (null == schema) {
                        schema = tmp.getSchema();
                    }
                }
                search.setName(pattern);
                search.setCatalog(catalog);
                search.setSchema(schema);
                tps = null;
                tps = null != types ? types.toUpperCase().trim().split(",") : new String[]{"VIEW"};
                DataRow view_map = CacheProxy.getViewMaps(runtime.datasource());
                if (null != pattern) {
                    if (view_map.isEmpty()) {
                        LinkedHashMap<String, T> all = this.views(greedy, catalog, schema, null, types);
                        if (!greedy) {
                            for (View view : all.values()) {
                                if (!(catalog + "_" + schema).equals(view.getCatalog() + "_" + view.getSchema())) continue;
                                view_map.put(view.getName(greedy).toUpperCase(), (Object)view.getName(greedy));
                            }
                        }
                    }
                    pattern = view_map.containsKey(search.getName(greedy).toUpperCase()) ? view_map.getString(search.getName(greedy).toUpperCase()) : search.getName(greedy);
                }
                try {
                    List<Run> runs = adapter.buildQueryViewRunSQL(catalog, schema, pattern, types);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, null, run.getFinalQuery(), run.getValues()).toUpperKey();
                            views = adapter.views(idx++, true, catalog, schema, views, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block29;
                    log.warn("{}[views][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            if (null == views || views.size() == 0) {
                try {
                    tmps = adapter.views(true, null, con.getMetaData(), catalog, schema, pattern, tps);
                    for (String string : tmps.keySet()) {
                        View item;
                        if (views.containsKey(string.toUpperCase()) || null == (item = (View)tmps.get(string)) || !greedy && !(catalog + "_" + schema).equalsIgnoreCase(item.getCatalog() + "_" + item.getSchema())) continue;
                        views.put(string.toUpperCase(), item);
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    log.warn("{}[views][][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636ejdbc\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[views][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, pattern, types, views.size(), System.currentTimeMillis() - fr});
            }
            if (BasicUtil.isNotEmpty((Object)pattern)) {
                tmps = new LinkedHashMap();
                List keys = BeanUtil.getMapKeys(views);
                for (String key : keys) {
                    View item = (View)views.get(key);
                    String name = item.getName(greedy);
                    if (!RegularUtil.match((String)name, (String)pattern)) continue;
                    tmps.put(name.toUpperCase(), item);
                }
                views = tmps;
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            } else {
                log.error("[views][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return views;
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(boolean greedy, String schema, String name, String types) {
        return this.views(greedy, null, schema, name, types);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(boolean greedy, String name, String types) {
        return this.views(greedy, null, null, name, types);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(boolean greedy, String types) {
        return this.views(greedy, null, null, types);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(boolean greedy) {
        return this.views(greedy, null, null, null, "TABLE");
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(String catalog, String schema, String pattern, String types) {
        return this.views(false, catalog, schema, pattern, types);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(String schema, String name, String types) {
        return this.views(false, null, schema, name, types);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(String name, String types) {
        return this.views(false, null, null, name, types);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(String types) {
        return this.views(false, null, null, types);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views() {
        return this.views(false, null, null, null, "TABLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean greedy, String catalog, String schema, String pattern, String types) {
        LinkedHashMap<Object, MasterTable> tables = new LinkedHashMap();
        DataSource ds = null;
        Connection con = null;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String random = this.random();
        try {
            String[] tps;
            long fr;
            block28: {
                fr = System.currentTimeMillis();
                ds = runtime.getTemplate().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                if (null == catalog || null == schema) {
                    Table tmp = new Table();
                    if (!greedy) {
                        adapter.checkSchema(con, tmp);
                    }
                    if (null == catalog) {
                        catalog = tmp.getCatalog();
                    }
                    if (null == schema) {
                        schema = tmp.getSchema();
                    }
                }
                tps = null;
                if (null != types) {
                    tps = types.toUpperCase().trim().split(",");
                }
                DataRow table_map = CacheProxy.getTableMaps(runtime.datasource());
                if (null != pattern) {
                    if (table_map.isEmpty()) {
                        LinkedHashMap<String, T> all = this.mtables(catalog, schema, null, types);
                        for (Table table : all.values()) {
                            table_map.put(table.getName().toUpperCase(), (Object)table.getName());
                        }
                    }
                    if (table_map.containsKey(pattern.toUpperCase())) {
                        pattern = table_map.getString(pattern.toUpperCase());
                    }
                }
                try {
                    List<Run> runs = adapter.buildQueryMasterTableRunSQL(catalog, schema, pattern, types);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, null, run.getFinalQuery(), run.getValues()).toUpperKey();
                            tables = adapter.mtables(idx++, true, catalog, schema, tables, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block28;
                    log.warn("{}[stables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            if (null == tables || tables.size() == 0) {
                try {
                    LinkedHashMap tmps = adapter.mtables(true, null, con.getMetaData(), catalog, schema, pattern, tps);
                    for (String key : tmps.keySet()) {
                        MasterTable item;
                        if (tables.containsKey(key.toUpperCase()) || null == (item = (MasterTable)tmps.get(key)) || !greedy && !(catalog + "_" + schema).equalsIgnoreCase(item.getCatalog() + "_" + item.getSchema())) continue;
                        tables.put(key.toUpperCase(), item);
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    log.warn("{}[stables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636ejdbc\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[stables][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, pattern, types, tables.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            } else {
                log.error("[mtables][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return tables;
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean greedy, String schema, String name, String types) {
        return this.mtables(greedy, null, schema, name, types);
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean greedy, String name, String types) {
        return this.mtables(greedy, null, null, name, types);
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean greedy, String types) {
        return this.mtables(greedy, null, types);
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean greedy) {
        return this.mtables(greedy, "STABLE");
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(String catalog, String schema, String pattern, String types) {
        return this.mtables(false, catalog, schema, pattern, types);
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(String schema, String name, String types) {
        return this.mtables(false, null, schema, name, types);
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(String name, String types) {
        return this.mtables(false, null, null, name, types);
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(String types) {
        return this.mtables(false, null, types);
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables() {
        return this.mtables(false, "STABLE");
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, String catalog, String schema, String master, String name) {
        MasterTable mtable = new MasterTable(catalog, schema, master);
        return this.ptables(greedy, mtable, null, name);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, String schema, String master, String name) {
        return this.ptables(greedy, null, schema, master, name);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, String master, String name) {
        return this.ptables(greedy, null, null, master, name);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, String master) {
        return this.ptables(greedy, null, null, master, null);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, MasterTable master) {
        return this.ptables(greedy, master, null);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, MasterTable master, Map<String, Object> tags) {
        return this.ptables(greedy, master, tags, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, MasterTable master, Map<String, Object> tags, String name) {
        LinkedHashMap tables = new LinkedHashMap();
        DataSource ds = null;
        Connection con = null;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String random = this.random();
        try {
            long fr;
            block14: {
                fr = System.currentTimeMillis();
                ds = runtime.getTemplate().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                try {
                    List<Run> runs = adapter.buildQueryPartitionTableRunSQL(master, tags, name);
                    if (null != runs) {
                        int idx = 0;
                        int total = runs.size();
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, null, run.getFinalQuery(), run.getValues()).toUpperKey();
                            tables = adapter.ptables(total, idx++, true, master, master.getCatalog(), master.getSchema(), tables, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block14;
                    log.warn("{}[tables][{}][stable:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), master.getName(), e.toString()});
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[tables][stable:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, master.getName(), tables.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            } else {
                log.error("[ptables][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return tables;
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(String catalog, String schema, String master, String name) {
        MasterTable mtable = new MasterTable(catalog, schema, master);
        return this.ptables(false, mtable, null, name);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(String schema, String master, String name) {
        return this.ptables(false, null, schema, master, name);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(String master, String name) {
        return this.ptables(false, null, null, master, name);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(String master) {
        return this.ptables(false, null, null, master, null);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(MasterTable master) {
        return this.ptables(false, master, null);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(MasterTable master, Map<String, Object> tags) {
        return this.ptables(false, master, tags, null);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(MasterTable master, Map<String, Object> tags, String name) {
        return this.ptables(false, master, tags, name);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(boolean greedy, Table table) {
        return this.columns(null, null, greedy, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T extends Column> LinkedHashMap<String, T> columns(JDBCRuntime runtime, String random, boolean greedy, Table table) {
        LinkedHashMap columns;
        block34: {
            if (null == runtime) {
                runtime = this.runtime();
            }
            if (null == random) {
                random = this.random();
            }
            if (null == table) return new LinkedHashMap();
            if (BasicUtil.isEmpty((Object)table.getName())) {
                return new LinkedHashMap();
            }
            columns = CacheProxy.columns(runtime.getKey(), table.getName());
            if (null != columns && !columns.isEmpty()) {
                return columns;
            }
            long fr = System.currentTimeMillis();
            DataSource ds = null;
            Connection con = null;
            DatabaseMetaData metadata = null;
            try {
                List<Run> runs;
                int qty_jdbc;
                int qty_metadata;
                int qty_dialect;
                String schema;
                String catalog;
                JDBCAdapter adapter;
                block31: {
                    adapter = runtime.getAdapter();
                    if (!greedy) {
                        this.checkSchema(runtime, table);
                    }
                    catalog = table.getCatalog();
                    schema = table.getSchema();
                    try {
                        ds = runtime.getTemplate().getDataSource();
                        con = DataSourceUtils.getConnection((DataSource)ds);
                        metadata = con.getMetaData();
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        log.warn("[metadata][resutl:fail][msg:{}]", (Object)e.toString());
                    }
                    qty_dialect = 0;
                    qty_metadata = 0;
                    qty_jdbc = 0;
                    try {
                        runs = adapter.buildQueryColumnRunSQL(table, false);
                        if (null != runs) {
                            int idx = 0;
                            for (Run run : runs) {
                                DataSet set = this.select(runtime, random, true, null, run.getFinalQuery(), run.getValues());
                                columns = adapter.columns(idx, true, table, columns, set);
                                ++idx;
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block31;
                        log.warn("{}[columns][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                    }
                }
                qty_dialect = columns.size();
                if (columns.size() == 0) {
                    block32: {
                        try {
                            runs = adapter.buildQueryColumnRunSQL(table, true);
                            if (null != runs) {
                                for (Run run : runs) {
                                    SqlRowSet set = runtime.getTemplate().queryForRowSet(run.getFinalQuery());
                                    columns = adapter.columns(true, columns, table, set);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                e.printStackTrace();
                            }
                            if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block32;
                            log.warn("{}[columns][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636emetadata\u89e3\u6790\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                        }
                    }
                    qty_metadata = columns.size() - qty_dialect;
                }
                if (columns.size() == 0) {
                    block33: {
                        try {
                            columns = adapter.columns(true, columns, metadata, table, null);
                        }
                        catch (Exception e) {
                            if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block33;
                            e.printStackTrace();
                        }
                    }
                    qty_jdbc = columns.size() - qty_metadata - qty_dialect;
                }
                if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[columns][catalog:{}][schema:{}][table:{}][total:{}][\u6839\u636emetadata\u89e3\u6790:{}][\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2:{}][\u6839\u636ejdbc\u63a5\u53e3\u8865\u5145:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, table, columns.size(), qty_metadata, qty_dialect, qty_jdbc, System.currentTimeMillis() - fr});
                }
                if (DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) break block34;
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                    break block34;
                } else {
                    log.error("[columns][result:fail][table:{}][msg:{}]", new Object[]{random, table, e.toString()});
                }
                break block34;
            }
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            break block34;
            finally {
                if (!DataSourceUtils.isConnectionTransactional(con, ds)) {
                    DataSourceUtils.releaseConnection(con, ds);
                }
            }
        }
        CacheProxy.columns(runtime.getKey(), table.getName(), columns);
        return columns;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(boolean greedy, String table) {
        return this.columns(greedy, null, null, table);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(boolean greedy, String catalog, String schema, String table) {
        Table tab = new Table(catalog, schema, table);
        return this.columns(greedy, tab);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(Table table) {
        return this.columns(false, table);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(String table) {
        return this.columns(false, null, null, table);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(String catalog, String schema, String table) {
        Table tab = new Table(catalog, schema, table);
        return this.columns(false, tab);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(boolean greedy, Table table) {
        return this.tags(this.runtime(), greedy, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Tag> LinkedHashMap<String, T> tags(JDBCRuntime runtime, boolean greedy, Table table) {
        LinkedHashMap tags;
        block31: {
            if (null == table) return new LinkedHashMap();
            if (BasicUtil.isEmpty((Object)table.getName())) {
                return new LinkedHashMap();
            }
            tags = CacheProxy.tags(runtime.getKey(), table.getName());
            if (null != tags && !tags.isEmpty()) {
                return tags;
            }
            long fr = System.currentTimeMillis();
            DataSource ds = null;
            Connection con = null;
            String random = this.random();
            DatabaseMetaData metadata = null;
            try {
                String schema;
                String catalog;
                block30: {
                    JDBCAdapter adapter;
                    block29: {
                        List<Run> runs;
                        block28: {
                            adapter = runtime.getAdapter();
                            if (!greedy) {
                                this.checkSchema(runtime, table);
                            }
                            catalog = table.getCatalog();
                            schema = table.getSchema();
                            try {
                                ds = runtime.getTemplate().getDataSource();
                                con = DataSourceUtils.getConnection((DataSource)ds);
                                metadata = con.getMetaData();
                            }
                            catch (Exception e) {
                                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                    e.printStackTrace();
                                }
                                log.warn("[][result:fail][msg:{}]", (Object)e.toString());
                            }
                            try {
                                runs = adapter.buildQueryTagRunSQL(table, false);
                                if (null != runs) {
                                    int idx = 0;
                                    for (Run run : runs) {
                                        DataSet set = this.select(runtime, random, null, run).toUpperKey();
                                        tags = adapter.tags(idx, true, table, tags, set);
                                        ++idx;
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                    e.printStackTrace();
                                }
                                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block28;
                                log.warn("{}[tags][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                            }
                        }
                        if (null == tags || tags.size() == 0) {
                            try {
                                runs = adapter.buildQueryTagRunSQL(table, true);
                                if (null != runs) {
                                    for (Run run : runs) {
                                        SqlRowSet set = runtime.getTemplate().queryForRowSet(run.getFinalQuery());
                                        tags = adapter.tags(true, table, tags, set);
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                    e.printStackTrace();
                                }
                                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block29;
                                log.warn("{}[tags][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636emetadata\u89e3\u6790\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                            }
                        }
                    }
                    if (null == tags || tags.size() == 0) {
                        try {
                            tags = adapter.tags(false, tags, metadata, table, null);
                        }
                        catch (Exception e) {
                            if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block30;
                            e.printStackTrace();
                        }
                    }
                }
                if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[tags][catalog:{}][schema:{}][table:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, table, System.currentTimeMillis() - fr});
                }
                if (DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) break block31;
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                break block31;
            }
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            break block31;
            finally {
                if (!DataSourceUtils.isConnectionTransactional(con, ds)) {
                    DataSourceUtils.releaseConnection(con, ds);
                }
            }
        }
        CacheProxy.tags(runtime.getKey(), table.getName(), tags);
        return tags;
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(boolean greedy, String table) {
        Table tab = new Table();
        tab.setName(table);
        return this.tags(greedy, tab);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(boolean greedy, String catalog, String schema, String table) {
        Table tab = new Table();
        tab.setCatalog(catalog);
        tab.setSchema(schema);
        tab.setName(table);
        return this.tags(greedy, tab);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(Table table) {
        return this.tags(false, table);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(String table) {
        return this.tags(false, table);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(String catalog, String schema, String table) {
        return this.tags(false, catalog, schema, table);
    }

    @Override
    public PrimaryKey primary(boolean greedy, Table table) {
        PrimaryKey primary;
        block7: {
            primary = null;
            JDBCRuntime runtime = this.runtime();
            JDBCAdapter adapter = runtime.getAdapter();
            if (!greedy) {
                this.checkSchema(runtime, table);
            }
            String tab = table.getName();
            String catalog = table.getCatalog();
            String schema = table.getSchema();
            Object ds = null;
            String random = this.random();
            Object metadata = null;
            try {
                List<Run> runs = adapter.buildQueryPrimaryRunSQL(table);
                if (null != runs) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, null, run).toUpperKey();
                        primary = adapter.primary(idx, table, set);
                        if (null != primary) {
                            primary.setTable(table);
                        }
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block7;
                log.warn("{}[primary][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
            }
        }
        table.setPrimaryKey(primary);
        return primary;
    }

    @Override
    public PrimaryKey primary(boolean greedy, String table) {
        Table tab = new Table();
        tab.setName(table);
        return this.primary(greedy, tab);
    }

    @Override
    public PrimaryKey primary(boolean greedy, String catalog, String schema, String table) {
        Table tab = new Table();
        tab.setCatalog(catalog);
        tab.setSchema(schema);
        tab.setName(table);
        return this.primary(greedy, tab);
    }

    @Override
    public PrimaryKey primary(Table table) {
        return this.primary(false, table);
    }

    @Override
    public PrimaryKey primary(String table) {
        return this.primary(false, table);
    }

    @Override
    public PrimaryKey primary(String catalog, String schema, String table) {
        return this.primary(false, catalog, schema, table);
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(boolean greedy, Table table) {
        LinkedHashMap foreigns;
        block5: {
            foreigns = new LinkedHashMap();
            JDBCRuntime runtime = this.runtime();
            String random = this.random();
            JDBCAdapter adapter = runtime.getAdapter();
            if (!greedy) {
                this.checkSchema(runtime, table);
            }
            try {
                List<Run> runs = adapter.buildQueryForeignsRunSQL(table);
                if (null != runs) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, null, run).toUpperKey();
                        foreigns = adapter.foreigns(idx, table, foreigns, set);
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block5;
                e.printStackTrace();
            }
        }
        return foreigns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(boolean greedy, Table table, String name) {
        List<Run> runs;
        Iterator<Run> index;
        LinkedHashMap<String, Object> indexs = null;
        if (null == table) {
            table = new Table();
        }
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        JDBCAdapter adapter = runtime.getAdapter();
        if (!greedy) {
            this.checkSchema(runtime, table);
        }
        if (null != table.getName()) {
            DataSource ds = null;
            Connection con = null;
            try {
                ds = runtime.getTemplate().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                indexs = adapter.indexs(true, indexs, con.getMetaData(), table, false, false);
                table.setIndexs(indexs);
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
            }
            finally {
                if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                    DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
                }
            }
            if (BasicUtil.isNotEmpty((Object)name)) {
                index = (Index)indexs.get(name.toUpperCase());
                indexs = new LinkedHashMap();
                indexs.put(name.toUpperCase(), index);
            }
        }
        if (null != (runs = adapter.buildQueryIndexRunSQL(table, name))) {
            int idx = 0;
            for (Run run : runs) {
                block22: {
                    DataSet set = this.select(runtime, random, null, run).toUpperKey();
                    try {
                        indexs = adapter.indexs(idx, true, table, indexs, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block22;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        PrimaryKey pk = null;
        for (Index index2 : indexs.values()) {
            if (!index2.isPrimary()) continue;
            pk = index2;
            break;
        }
        if (null == pk) {
            pk = table.getPrimaryKey();
            if (null == pk) {
                pk = this.primary(table);
            }
            if (null != pk) {
                index = (Index)indexs.get(pk.getName().toUpperCase());
                if (null != index) {
                    index.setPrimary(true);
                } else {
                    indexs.put(pk.getName().toUpperCase(), pk);
                }
            }
        }
        return indexs;
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(boolean greedy, Table table) {
        return this.indexs(greedy, table, null);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(boolean greedy, String table, String name) {
        return this.indexs(greedy, new Table(table), name);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(boolean greedy, String table) {
        return this.indexs(greedy, new Table(table), null);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(boolean greedy, String catalog, String schema, String table) {
        return this.indexs(greedy, new Table(catalog, schema, table), null);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(Table table, String name) {
        return this.indexs(false, table, name);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(Table table) {
        return this.indexs(false, table);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(String table, String name) {
        return this.indexs(false, table, name);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(String table) {
        return this.indexs(false, table);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(String catalog, String schema, String table) {
        return this.indexs(false, catalog, schema, table);
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean greedy, Table table, String name) {
        return null;
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean greedy, Table table) {
        return this.constraints(greedy, table, null);
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean greedy, String table) {
        return this.constraints(greedy, new Table(table));
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean greedy, String table, String name) {
        return this.constraints(greedy, new Table(table), name);
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean greedy, String catalog, String schema, String table) {
        return this.constraints(greedy, new Table(catalog, schema, table));
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(Table table, String name) {
        return this.constraints(false, table, name);
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(Table table) {
        return this.constraints(false, table);
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(String table) {
        return this.constraints(false, new Table(table));
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(String table, String name) {
        return this.constraints(false, new Table(table), name);
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(String catalog, String schema, String table) {
        return this.constraints(false, new Table(catalog, schema, table));
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(boolean greedy, Table table, List<Trigger.EVENT> events) {
        List<Run> runs;
        LinkedHashMap triggers = new LinkedHashMap();
        if (null == table) {
            table = new Table();
        }
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        JDBCAdapter adapter = runtime.getAdapter();
        if (!greedy) {
            this.checkSchema(runtime, table);
        }
        if (null != (runs = adapter.buildQueryTriggerRunSQL(table, events))) {
            int idx = 0;
            for (Run run : runs) {
                block6: {
                    DataSet set = this.select(runtime, random, null, run).toUpperKey();
                    try {
                        triggers = adapter.triggers(idx, true, table, triggers, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block6;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return triggers;
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(boolean greedy, String catalog, String schema, String name) {
        LinkedHashMap procedures = new LinkedHashMap();
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        JDBCAdapter adapter = runtime.getAdapter();
        List<Run> runs = adapter.buildQueryProcedureRunSQL(catalog, schema, name);
        if (null != runs) {
            int idx = 0;
            for (Run run : runs) {
                block4: {
                    DataSet set = this.select(runtime, random, null, run).toUpperKey();
                    try {
                        procedures = adapter.procedures(idx, true, procedures, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block4;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return procedures;
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(boolean greedy, String catalog, String schema, String name) {
        LinkedHashMap functions = new LinkedHashMap();
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        JDBCAdapter adapter = runtime.getAdapter();
        List<Run> runs = adapter.buildQueryFunctionRunSQL(catalog, schema, name);
        if (null != runs) {
            int idx = 0;
            for (Run run : runs) {
                block4: {
                    DataSet set = this.select(runtime, random, null, run).toUpperKey();
                    try {
                        functions = adapter.functions(idx, true, functions, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block4;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return functions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(Table meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.TABLE_CREATE;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildCreateRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeCreate(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(Table table) throws Exception {
        List<Run> alters;
        boolean change_pk;
        boolean result = true;
        ArrayList<Run> runs = new ArrayList<Run>();
        Table update = table.getUpdate();
        LinkedHashMap columns = table.getColumns();
        LinkedHashMap ucolumns = update.getColumns();
        String name = table.getName();
        String uname = update.getName();
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        JDBCAdapter adapter = runtime.getAdapter();
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, ACTION.DDL.TABLE_ALTER, table);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.parepareAlter(runtime, random, table);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, table);
        this.checkSchema(runtime, update);
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            result = this.rename(runtime, random, table, uname);
            table.setName(uname);
        }
        if (!result) {
            return result;
        }
        String comment = update.getComment() + "";
        if (!comment.equals(table.getComment()) && (swt = InterceptorProxy.prepare(runtime, random, ACTION.DDL.TABLE_COMMENT, table)) != ACTION.SWITCH.BREAK) {
            if (BasicUtil.isNotEmpty((Object)table.getComment())) {
                runs.addAll(adapter.buildChangeCommentRunSQL(update));
            } else {
                runs.addAll(adapter.buildAddCommentRunSQL(update));
            }
            swt = InterceptorProxy.before(runtime, random, ACTION.DDL.TABLE_COMMENT, table, runs);
            if (swt != ACTION.SWITCH.BREAK) {
                long cmt_fr = System.currentTimeMillis();
                result = this.execute(runtime, random, ACTION.DDL.TABLE_COMMENT, runs) && result;
                InterceptorProxy.after(runtime, random, ACTION.DDL.TABLE_COMMENT, table, runs, result, System.currentTimeMillis() - cmt_fr);
            }
        }
        LinkedHashMap<String, Object> cols = new LinkedHashMap<String, Object>();
        for (Object ucolumn : ucolumns.values()) {
            Column column = (Column)columns.get(ucolumn.getName().toUpperCase());
            if (null != ucolumn.getUpdate()) {
                ucolumn = ucolumn.getUpdate();
            }
            if (null != column) {
                if (column.equals((Column)ucolumn)) continue;
                column.setTable(update);
                column.setUpdate((Column)ucolumn, false, false);
                column.setAction("alter");
                cols.put(column.getName().toUpperCase(), column);
                continue;
            }
            ucolumn.setTable(update);
            ucolumn.setAction("add");
            cols.put(ucolumn.getName().toUpperCase(), ucolumn);
        }
        ArrayList<String> deletes = new ArrayList<String>();
        for (Column column : ucolumns.values()) {
            if (!column.isDrop()) continue;
            deletes.add(column.getName().toUpperCase());
            column.setAction("drop");
            cols.put(column.getName().toUpperCase(), column);
        }
        if (table.isAutoDropColumn()) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || column.isDrop() || deletes.contains(column.getName().toUpperCase()) || "drop".equals(column.getAction()) || null != (ucolumn = (Column)ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                column.setAction("drop");
                cols.put(column.getName().toUpperCase(), column);
            }
        }
        PrimaryKey src_primary = this.primary(table);
        PrimaryKey cur_primary = update.getPrimaryKey();
        String src_define = "";
        String cur_define = "";
        if (null != src_primary) {
            src_define = BeanUtil.concat(src_primary.getColumns().values(), (String)"name", (String)",");
        }
        if (null != cur_primary) {
            cur_define = BeanUtil.concat(cur_primary.getColumns().values(), (String)"name", (String)",");
        }
        boolean bl = change_pk = !cur_define.equalsIgnoreCase(src_define);
        if (change_pk) {
            LinkedHashMap pks = src_primary.getColumns();
            LinkedHashMap npks = cur_primary.getColumns();
            for (String k : pks.keySet()) {
                Column auto = (Column)columns.get(k.toUpperCase());
                if (null == auto || auto.isAutoIncrement() != 1 || npks.containsKey(auto.getName().toUpperCase())) continue;
                auto.setPrimaryKey(Boolean.valueOf(false));
                result = this.execute(runtime, random, ACTION.DDL.TABLE_ALTER, adapter.buildDropAutoIncrement(auto)) && result;
            }
            if (null != src_primary) {
                this.drop(src_primary);
            }
        }
        if (null != (alters = adapter.buildAlterRunSQL(table, cols.values())) && alters.size() > 0) {
            boolean bl2 = result = this.execute(runtime, random, ACTION.DDL.COLUMN_ALTER, alters) && result;
        }
        if (change_pk && null != cur_primary) {
            this.add(cur_primary);
        }
        CacheProxy.clear();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(Table meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.TABLE_DROP;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildDropRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    private List<Run> runs(String sql) {
        ArrayList<Run> runs = new ArrayList<Run>();
        runs.add(new SimpleRun(sql));
        return runs;
    }

    @Override
    public boolean rename(Table origin, String name) throws Exception {
        return this.rename(null, null, origin, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(JDBCRuntime runtime, String random, Table origin, String name) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.TABLE_RENAME;
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null == random) {
            random = this.random();
        }
        origin.setNewName(name);
        swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        List<Run> runs = adapter.buildRenameRunSQL(origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(View meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.VIEW_CREATE;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)meta);
        List<Run> runs = adapter.buildCreateRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeCreate(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(View meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.VIEW_ALTER;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)meta);
        List<Run> runs = adapter.buildAlterRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAlter(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(View meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.VIEW_DROP;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)meta);
        List<Run> runs = adapter.buildDropRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean rename(View origin, String name) throws Exception {
        return this.rename(this.runtime(), origin, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(JDBCRuntime runtime, View origin, String name) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.VIEW_RENAME;
        String random = this.random();
        origin.setNewName(name);
        if (null == runtime) {
            runtime = this.runtime();
        }
        swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)origin);
        List<Run> runs = adapter.buildRenameRunSQL(origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(MasterTable meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.MASTER_TABLE_CREATE;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)meta);
        List<Run> runs = adapter.buildCreateRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeCreate(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(MasterTable table) throws Exception {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        if (null != ddListener) {
            // empty if block
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        boolean result = true;
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)table);
        MasterTable update = table.getUpdate();
        LinkedHashMap columns = table.getColumns();
        LinkedHashMap ucolumns = update.getColumns();
        LinkedHashMap tags = table.getTags();
        LinkedHashMap utags = update.getTags();
        String name = table.getName();
        String uname = update.getName();
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            result = this.rename(runtime, random, (Table)table, uname);
        }
        for (Column ucolumn : ucolumns.values()) {
            Column column = (Column)columns.get(ucolumn.getName().toUpperCase());
            if (null != column) {
                column.setTable((Table)update);
                column.setUpdate(ucolumn, false, false);
                this.alter(column);
                result = true;
                continue;
            }
            ucolumn.setTable((Table)update);
            this.add(ucolumn);
            result = true;
        }
        if (table.isAutoDropColumn()) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || null != (ucolumn = (Column)ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable((Table)update);
                this.drop(column);
                result = true;
            }
        }
        for (Tag utag : utags.values()) {
            Tag tag = (Tag)tags.get(utag.getName().toUpperCase());
            if (null != tag) {
                tag.setTable((Table)update);
                tag.setUpdate(utag, false, false);
                this.alter(tag);
                result = true;
                continue;
            }
            utag.setTable((Table)update);
            this.add(utag);
            result = true;
        }
        if (table.isAutoDropColumn()) {
            for (Tag tag : tags.values()) {
                Tag utag = (Tag)utags.get(tag.getName().toUpperCase());
                if (null != utag) continue;
                tag.setTable((Table)update);
                this.drop(tag);
                result = true;
            }
        }
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[alter master table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(MasterTable meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.MASTER_TABLE_DROP;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)meta);
        List<Run> runs = adapter.buildDropRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean rename(MasterTable origin, String name) throws Exception {
        return this.rename(this.runtime(), origin, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(JDBCRuntime runtime, MasterTable origin, String name) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.MASTER_TABLE_RENAME;
        if (null == runtime) {
            runtime = this.runtime();
        }
        String random = this.random();
        origin.setNewName(name);
        swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)origin);
        List<Run> runs = adapter.buildRenameRunSQL(origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(PartitionTable meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.PARTITION_TABLE_CREATE;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)meta);
        List<Run> runs = adapter.buildCreateRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeCreate(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][master:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getMasterName(), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][master:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getMasterName(), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(PartitionTable table) throws Exception {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        if (null != ddListener) {
            // empty if block
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        boolean result = true;
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)table);
        Table update = table.getUpdate();
        LinkedHashMap columns = table.getColumns();
        LinkedHashMap ucolumns = update.getColumns();
        String name = table.getName();
        String uname = update.getName();
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            result = this.rename(runtime, random, table, uname);
        }
        for (Column ucolumn : ucolumns.values()) {
            Column column = (Column)columns.get(ucolumn.getName().toUpperCase());
            if (null != column) {
                column.setTable(update);
                column.setUpdate(ucolumn, false, false);
                this.alter(column);
                result = true;
                continue;
            }
            ucolumn.setTable(update);
            this.add(ucolumn);
            result = true;
        }
        if (table.isAutoDropColumn()) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || null != (ucolumn = (Column)ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                this.drop(column);
                result = true;
            }
        }
        if (null != ddListener) {
            // empty if block
        }
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[alter partition table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(PartitionTable meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.PARTITION_TABLE_DROP;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)meta);
        List<Run> runs = adapter.buildDropRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][master:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getMasterName(), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][master:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getMasterName(), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean rename(PartitionTable origin, String name) throws Exception {
        return this.rename(null, null, origin, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean rename(JDBCRuntime runtime, String random, PartitionTable origin, String name) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.PARTITION_TABLE_RENAME;
        origin.setNewName(name);
        if (null == random) {
            random = this.random();
        }
        if (null == runtime) {
            runtime = this.runtime();
        }
        swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)origin);
        List<Run> runs = adapter.buildRenameRunSQL(origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][master:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getMasterName(), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][master:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getMasterName(), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Column meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.COLUMN_ADD;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAdd(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildAddRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAdd(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(Table table, Column column) throws Exception {
        return this.alter(table, column, true);
    }

    @Override
    public boolean alter(Column column) throws Exception {
        Table table = column.getTable(true);
        if (null == table) {
            LinkedHashMap tables = this.tables(column.getCatalog(), column.getSchema(), column.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + column.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + column.getTableName(true));
            } else {
                table = (Table)tables.values().iterator().next();
            }
        }
        return this.alter(table, column, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(Column meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.COLUMN_DROP;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildDropRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean alter(Table table, Column meta, boolean trigger) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.COLUMN_ALTER;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildAlterRunSQL(meta, false);
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Exception e) {
            block19: {
                try {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    log.warn("{}[{}][exception:{}]", new Object[]{random, LogUtil.format((String)"\u4fee\u6539Column\u6267\u884c\u5f02\u5e38", (int)33), e.toString()});
                    if (trigger && null != ddListener && !BasicUtil.equalsIgnoreCase((Object)meta.getTypeName(), (Object)meta.getUpdate().getTypeName())) {
                        if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION != 0) {
                            swt = ddListener.afterAlterColumnException(runtime, random, table, meta, e);
                        }
                        log.warn("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u5c1d\u8bd5\u4fee\u6b63\u6570\u636e][\u4fee\u6b63\u7ed3\u679c:{}]", (Object)random, (Object)swt);
                        if (swt == ACTION.SWITCH.CONTINUE) {
                            result = this.alter(table, meta, false);
                        }
                        break block19;
                    }
                    log.error("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u4e2d\u65ad\u6267\u884c]", (Object)random);
                    result = false;
                    throw e;
                }
                catch (Throwable throwable) {
                    long millis = System.currentTimeMillis() - fr;
                    if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                        log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
                    }
                    swt = ACTION.SWITCH.CONTINUE;
                    if (null != ddListener) {
                        swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
                    }
                    if (swt == ACTION.SWITCH.CONTINUE) {
                        swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
                    }
                    throw throwable;
                }
            }
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(Column origin, String name) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.COLUMN_RENAME;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        origin.setNewName(name);
        swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        List<Run> runs = adapter.buildRenameRunSQL(origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Tag meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.TAG_ADD;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAdd(runtime, random, (Column)meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Column)meta);
        List<Run> runs = adapter.buildAddRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAdd(runtime, random, (Column)meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAdd(runtime, random, (Column)meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAdd(runtime, random, (Column)meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(Table table, Tag tag) throws Exception {
        return this.alter(table, tag, true);
    }

    @Override
    public boolean alter(Tag tag) throws Exception {
        Table table = tag.getTable(true);
        if (null == table) {
            LinkedHashMap tables = this.tables(false, tag.getCatalog(), tag.getSchema(), tag.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + tag.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + tag.getTableName(true));
            } else {
                table = (Table)tables.values().iterator().next();
            }
        }
        return this.alter(table, tag, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(Tag meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.TAG_DROP;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, (Column)meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Column)meta);
        List<Run> runs = adapter.buildDropRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, (Column)meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, (Column)meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, (Column)meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean alter(Table table, Tag meta, boolean trigger) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.TAG_ALTER;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAlter(runtime, random, (Column)meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Column)meta);
        List<Run> runs = adapter.buildAlterRunSQL((Column)meta, false);
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Exception e) {
            block19: {
                try {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    log.warn("{}[{}][exception:{}]", new Object[]{random, LogUtil.format((String)"\u4fee\u6539TAG\u6267\u884c\u5f02\u5e38", (int)33), e.toString()});
                    if (trigger && null != ddListener && !BasicUtil.equalsIgnoreCase((Object)meta.getTypeName(), (Object)meta.getUpdate().getTypeName())) {
                        if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION != 0) {
                            swt = ddListener.afterAlterColumnException(runtime, random, table, (Column)meta, e);
                        }
                        log.warn("{}[\u4fee\u6539TAG\u6267\u884c\u5f02\u5e38][\u5c1d\u8bd5\u4fee\u6b63\u6570\u636e][\u4fee\u6b63\u7ed3\u679c:{}]", (Object)random, (Object)swt);
                        if (swt == ACTION.SWITCH.CONTINUE) {
                            result = this.alter(table, meta, false);
                        }
                        break block19;
                    }
                    log.error("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u4e2d\u65ad\u6267\u884c]", (Object)random);
                    result = false;
                    throw e;
                }
                catch (Throwable throwable) {
                    long millis = System.currentTimeMillis() - fr;
                    if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                        log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
                    }
                    swt = ACTION.SWITCH.CONTINUE;
                    if (null != ddListener) {
                        swt = ddListener.afterAlter(runtime, random, (Column)meta, runs, result, millis);
                    }
                    if (swt == ACTION.SWITCH.CONTINUE) {
                        swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
                    }
                    throw throwable;
                }
            }
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, (Column)meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, (Column)meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(Tag origin, String name) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.TAG_RENAME;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        origin.setNewName(name);
        swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, (Column)origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Column)origin);
        List<Run> runs = adapter.buildRenameRunSQL(origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, (Column)origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, (Column)origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, (Column)origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(PrimaryKey meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.PRIMARY_ADD;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAdd(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Index)meta);
        List<Run> runs = adapter.buildAddRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAdd(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(PrimaryKey primary) throws Exception {
        Table table = primary.getTable(true);
        if (null == table) {
            LinkedHashMap tables = this.tables(false, primary.getCatalog(), primary.getSchema(), primary.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + primary.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + primary.getTableName(true));
            } else {
                table = (Table)tables.values().iterator().next();
            }
        }
        return this.alter(table, primary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(Table table, PrimaryKey meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.PRIMARY_ALTER;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Index)meta);
        List<Run> runs = adapter.buildAlterRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAlter(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(PrimaryKey meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.PRIMARY_DROP;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Index)meta);
        List<Run> runs = adapter.buildDropRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(PrimaryKey origin, String name) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.PRIMARY_RENAME;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        origin.setNewName(name);
        swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Index)origin);
        List<Run> runs = adapter.buildRenameRunSQL(origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(ForeignKey meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.FOREIGN_ADD;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAdd(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Constraint)meta);
        List<Run> runs = adapter.buildAddRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAdd(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(ForeignKey meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            LinkedHashMap tables = this.tables(false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.values().iterator().next();
            }
        }
        return this.alter(table, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(Table table, ForeignKey meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.TRIGGER_ALTER;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Constraint)meta);
        List<Run> runs = adapter.buildAlterRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAlter(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(ForeignKey meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.FOREIGN_DROP;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Constraint)meta);
        List<Run> runs = adapter.buildDropRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(ForeignKey origin, String name) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.FOREIGN_RENAME;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        origin.setNewName(name);
        swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Constraint)origin);
        List<Run> runs = adapter.buildRenameRunSQL(origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Index meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.INDEX_ADD;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAdd(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildAddRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAdd(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(Index meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            LinkedHashMap tables = this.tables(false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.values().iterator().next();
            }
        }
        return this.alter(table, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(Table table, Index index) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.INDEX_ALTER;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, index);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAlter(runtime, random, index);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, index);
        List<Run> runs = adapter.buildAlterRunSQL(index);
        swt = InterceptorProxy.before(runtime, random, action, index, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAlter(runtime, random, index, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, index.getTableName(true), index.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, index, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, index, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, index.getTableName(true), index.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, index, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, index, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(Index meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.INDEX_DROP;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildDropRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(Index origin, String name) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.INDEX_RENAME;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        origin.setNewName(name);
        swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        List<Run> runs = adapter.buildRenameRunSQL(origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Constraint meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_ADD;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAdd(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildAddRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAdd(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(Constraint meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            LinkedHashMap tables = this.tables(false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.values().iterator().next();
            }
        }
        return this.alter(table, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(Table table, Constraint meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_ALTER;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildAlterRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAlter(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(Constraint meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_DROP;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildDropRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(Constraint origin, String name) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_RENAME;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        origin.setNewName(name);
        swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        List<Run> runs = adapter.buildRenameRunSQL(origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Trigger meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.TRIGGER_ADD;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildCreateRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeCreate(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(Trigger meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.TRIGGER_ALTER;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildAlterRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAlter(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(Trigger meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.TRIGGER_DROP;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildDropRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(Trigger origin, String name) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.TRIGGER_RENAME;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        origin.setNewName(name);
        swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        List<Run> runs = adapter.buildRenameRunSQL(origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(Procedure meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        JDBCRuntime runtime = this.runtime();
        ACTION.DDL action = ACTION.DDL.PRIMARY_ADD;
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildCreateRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeCreate(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(Procedure meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.PROCEDURE_ALTER;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildAlterRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAlter(runtime, random, meta, runs);
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(Procedure meta) throws Exception {
        boolean result = true;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        JDBCRuntime runtime = this.runtime();
        ACTION.DDL action = ACTION.DDL.PROCEDURE_DROP;
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildDropRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(Procedure origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PROCEDURE_RENAME;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        JDBCRuntime runtime = this.runtime();
        origin.setNewName(name);
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        List<Run> runs = adapter.buildRenameRunSQL(origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null == ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, origin.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, origin.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(Function meta) throws Exception {
        boolean result = true;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.FUNCTION_CREATE;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildCreateRunSQL(meta);
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            swt = ACTION.SWITCH.CONTINUE;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            if (null != ddListener) {
                swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        swt = ACTION.SWITCH.CONTINUE;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        if (null != ddListener) {
            swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(Function meta) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        ACTION.DDL action = ACTION.DDL.FUNCTION_ALTER;
        swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildAlterRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(Function meta) throws Exception {
        ACTION.DDL action;
        String random;
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        JDBCRuntime runtime = this.runtime();
        swt = InterceptorProxy.prepare(runtime, random = this.random(), action = ACTION.DDL.FUNCTION_DROP, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildDropRunSQL(meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(Function origin, String name) throws Exception {
        boolean result = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        ACTION.DDL action = ACTION.DDL.FUNCTION_RENAME;
        JDBCRuntime runtime = this.runtime();
        String random = this.random();
        origin.setNewName(name);
        swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        List<Run> runs = adapter.buildRenameRunSQL(origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    public boolean execute(JDBCRuntime runtime, String random, ACTION.DDL action, Run run) {
        if (null == run) {
            return false;
        }
        boolean result = false;
        String sql = run.getFinalUpdate();
        if (BasicUtil.isNotEmpty((Object)sql)) {
            Long fr = System.currentTimeMillis();
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                random = this.random();
                log.info("{}[action:{}][ds:{}][sql:\n{}\n]", new Object[]{random, action, runtime.datasource(), sql});
            }
            runtime.getTemplate().update(sql);
            result = true;
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][ds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, runtime.datasource(), result, System.currentTimeMillis() - fr});
            }
        }
        return result;
    }

    public boolean execute(JDBCRuntime runtime, String random, ACTION.DDL action, List<Run> runs) {
        boolean result = true;
        int idx = 0;
        for (Run run : runs) {
            result = this.execute(runtime, random + "-" + idx++, action, run) && result;
        }
        return result;
    }

    public void checkSchema(JDBCRuntime runtime, Table table) {
        if (null != table) {
            JDBCAdapter adapter = runtime.getAdapter();
            adapter.checkSchema(runtime.getTemplate().getDataSource(), table);
        }
    }

    public void checkSchema(JDBCRuntime runtime, Column column) {
        Table table = column.getTable(true);
        if (null != table) {
            this.checkSchema(runtime, table);
            column.setCatalog(table.getCatalog());
            column.setSchema(table.getSchema());
        }
    }

    public void checkSchema(JDBCRuntime runtime, Index index) {
        Table table = index.getTable(true);
        if (null != table) {
            this.checkSchema(runtime, table);
            index.setCatalog(table.getCatalog());
            index.setSchema(table.getSchema());
        }
    }

    public void checkSchema(JDBCRuntime runtime, Constraint constraint) {
        Table table = constraint.getTable(true);
        if (null != table) {
            this.checkSchema(runtime, table);
            constraint.setCatalog(table.getCatalog());
            constraint.setSchema(table.getSchema());
        }
    }

    public void checkSchema(JDBCRuntime runtime, Trigger trigger) {
        Table table = trigger.getTable(true);
        if (null != table) {
            this.checkSchema(runtime, table);
        }
    }

    public void checkSchema(JDBCRuntime runtime, Procedure procedure) {
        Table table = new Table(procedure.getCatalog(), procedure.getSchema());
        this.checkSchema(runtime, table);
        procedure.setCatalog(table.getCatalog());
        procedure.setSchema(table.getSchema());
    }

    public void checkSchema(JDBCRuntime runtime, Function function) {
        Table table = new Table(function.getCatalog(), function.getSchema());
        this.checkSchema(runtime, table);
        function.setCatalog(table.getCatalog());
        function.setSchema(table.getSchema());
    }

    protected String paramLogFormat(List<?> params) {
        StringBuilder builder = new StringBuilder();
        if (null != params && params.size() > 0) {
            builder.append("\n");
            int idx = 0;
            for (Object param : params) {
                builder.append("param").append(idx++).append("=");
                builder.append(param);
                if (null != param) {
                    builder.append("(").append(ClassUtil.type(param)).append(")");
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String paramLogFormat(List<?> keys, List<?> values) {
        StringBuilder builder = new StringBuilder();
        if (null != keys && null != values && keys.size() > 0) {
            builder.append("\n");
            if (keys.size() != values.size()) return this.paramLogFormat(values);
            int size = keys.size();
            for (int i = 0; i < size; ++i) {
                Object key = keys.get(i);
                Object value = values.get(i);
                builder.append(keys.get(i)).append("=");
                builder.append(value);
                if (null != value) {
                    builder.append("(").append(ClassUtil.type(value)).append(")");
                }
                builder.append("\n");
            }
            return builder.toString();
        } else {
            if (null == values) return builder.toString();
            builder.append(BeanUtil.concat(values, (boolean)true)).append("\n");
        }
        return builder.toString();
    }

    private String random() {
        StringBuilder builder = new StringBuilder();
        builder.append("[SQL:").append(System.currentTimeMillis()).append("-").append(BasicUtil.getRandomNumberString((int)8)).append("][thread:").append(Thread.currentThread().getId()).append("][ds:").append(this.runtime().datasource()).append("]");
        return builder.toString();
    }

    static {
        isBatchInsertRun = false;
    }
}

