/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.run;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.SyntaxHelper;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.auto.AutoCondition;
import org.anyline.data.prepare.auto.init.DefaultAutoCondition;
import org.anyline.data.prepare.auto.init.DefaultAutoConditionChain;
import org.anyline.data.prepare.init.DefaultVariable;
import org.anyline.data.run.BasicRun;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.entity.Compare;
import org.anyline.entity.DefaultOrderStore;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.util.BasicUtil;
import org.anyline.util.regular.Regular;
import org.anyline.util.regular.RegularUtil;

public class TextRun
extends BasicRun
implements Run {
    public TextRun() {
        this.builder = new StringBuilder();
        this.conditionChain = new DefaultAutoConditionChain();
        this.orderStore = new DefaultOrderStore();
        this.setStrict(false);
    }

    @Override
    public Run setPrepare(RunPrepare prepare) {
        this.prepare = prepare;
        this.table = prepare.getTable();
        this.parseText();
        return this;
    }

    @Override
    public void init() {
        List<Condition> conditions;
        super.init();
        if (null != this.conditionChain && null != (conditions = this.conditionChain.getConditions())) {
            for (Condition condition : conditions) {
                if (null == condition) continue;
                AutoCondition con = (AutoCondition)condition;
                List<Variable> vars = this.getVariables(con.getId());
                if (vars.size() > 0) {
                    con.setVariableSlave(true);
                    for (Variable var : vars) {
                        var.setValue(false, con.getValues());
                    }
                    continue;
                }
                this.setConditionValue(con.getSwitch(), con.getCompare(), con.getId(), null, con.getValues());
            }
        }
        if (null != this.configStore) {
            PageNavi navi;
            List orders;
            List<Config> confs = this.configStore.getConfigChain().getConfigs();
            for (Config conf : confs) {
                boolean overCondition = conf.isOverCondition();
                boolean overValue = conf.isOverValue();
                List<Object> values = conf.getValues();
                Compare compare = conf.getCompare();
                String varKey = conf.getVariable();
                List<Variable> vars = this.getVariables(varKey);
                List<Condition> cons = this.getConditions(varKey);
                boolean isUse = false;
                for (Condition con : cons) {
                    boolean isConVarSetValue;
                    if (null == con) continue;
                    boolean bl = isConVarSetValue = con.isSetValue() || con.isSetValue(varKey);
                    if (isConVarSetValue && !overValue) continue;
                    isUse = true;
                    con.setVariableSlave(true);
                    this.setConditionValue(conf.getSwitch(), conf.getCompare(), varKey, varKey, values);
                }
                for (Variable var : vars) {
                    if (!overValue && var.isSetValue()) continue;
                    isUse = true;
                    var.setValue(false, values);
                }
                if (compare == Compare.NONE || overCondition || isUse) continue;
                this.conditionChain.addCondition(conf.createAutoCondition(this.conditionChain));
            }
            OrderStore orderStore = this.configStore.getOrders();
            if (null != orderStore && null != (orders = orderStore.getOrders())) {
                for (Order order : orders) {
                    this.addOrder(order);
                }
            }
            if ((navi = this.configStore.getPageNavi()) != null) {
                this.pageNavi = navi;
            }
        }
    }

    private void parseText() {
        String text = this.prepare.getText();
        if (null == text) {
            return;
        }
        try {
            int varType = -1;
            Compare compare = Compare.EQUAL;
            List keys = null;
            int type = 0;
            keys = RegularUtil.fetchs((String)text, (String)"([^\\s\\$#]+)\\s*\\(?(\\s*[\\$|#]*{\\w+})(\\+|\\s|'|\\)|%)?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN);
            type = 2;
            if (keys.size() == 0) {
                keys = RegularUtil.fetchs((String)text, (String)"(\\S+)\\s*\\(?(\\s*:+\\w+)(\\s|'|\\)|%|\\,)?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN);
                type = 1;
            }
            if (BasicUtil.isNotEmpty((boolean)true, (Object)keys)) {
                for (int i = 0; i < keys.size(); ++i) {
                    List keyItem = (List)keys.get(i);
                    Variable var = SyntaxHelper.buildVariable(type, (String)keyItem.get(0), (String)keyItem.get(1), (String)keyItem.get(2), (String)keyItem.get(3));
                    if (null == var) continue;
                    var.setSwitch(Compare.EMPTY_VALUE_SWITCH.NULL);
                    this.addVariable(var);
                }
            } else {
                List idxKeys = RegularUtil.fetch((String)text, (String)"\\?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN, (int)0);
                if (BasicUtil.isNotEmpty((boolean)true, (Object)idxKeys)) {
                    for (int i = 0; i < idxKeys.size(); ++i) {
                        DefaultVariable var = new DefaultVariable();
                        var.setType(0);
                        var.setSwitch(Compare.EMPTY_VALUE_SWITCH.NULL);
                        this.addVariable(var);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkValid() {
        if (null != this.conditionChain && !this.conditionChain.isValid()) {
            this.valid = false;
        }
    }

    public void appendGroup() {
        if (null != this.groupStore) {
            this.builder.append(this.groupStore.getRunText(this.delimiterFr + this.delimiterTo));
        }
    }

    public void appendCondition() {
        if (null == this.conditionChain) {
            return;
        }
        List<Condition> cons = this.conditionChain.getConditions();
        if (null == cons || cons.size() == 0) {
            return;
        }
        String txt = this.builder.toString();
        boolean where = TextRun.endWithWhere(txt);
        if (!where) {
            this.builder.append(" WHERE 1=1");
        }
        this.builder.append(this.conditionChain.getRunText(null, this.adapter));
        this.addValues(this.conditionChain.getRunValues());
    }

    public void setConfigs(ConfigStore configs) {
        this.configStore = configs;
        if (null != configs) {
            this.pageNavi = configs.getPageNavi();
        }
    }

    @Override
    public Run setConditionValue(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String condition, String variable, Object value) {
        if (null != this.variables && BasicUtil.isEmpty((Object)variable)) {
            for (Variable v : this.variables) {
                if (null == v || !v.getKey().equalsIgnoreCase(condition)) continue;
                v.setValue(value);
            }
        }
        if (null == condition) {
            return this;
        }
        Condition con = this.getCondition(condition);
        if (null == con) {
            return this;
        }
        variable = ((String)BasicUtil.nvl((Object[])new String[]{variable, condition})).toString();
        con.setValue(variable, value);
        return this;
    }

    public TextRun addValues(String key, Object obj) {
        if (null == obj) {
            return this;
        }
        if (null == this.values) {
            this.values = new ArrayList();
        }
        if (null != obj && obj instanceof RunValue) {
            throw new RuntimeException("run value");
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            for (Object item : list) {
                this.addValues(key, item);
            }
        } else {
            this.addValues(new RunValue(key, obj));
        }
        return this;
    }

    @Override
    public Run addOrders(OrderStore orderStore) {
        if (null == orderStore) {
            return this;
        }
        List orders = orderStore.getOrders();
        if (null == orders) {
            return this;
        }
        for (Order order : orders) {
            this.orderStore.order(order);
        }
        return this;
    }

    @Override
    public Run addOrder(Order order) {
        this.orderStore.order(order);
        return this;
    }

    public Run addCondition(String condition, String variable, Object value) {
        if (null != this.variables && BasicUtil.isEmpty((Object)variable)) {
            for (Variable v : this.variables) {
                if (null == v || !v.getKey().equalsIgnoreCase(condition)) continue;
                v.setValue(value);
            }
        }
        if (null == condition) {
            return this;
        }
        Condition con = this.getCondition(condition);
        if (null == con) {
            return this;
        }
        variable = ((String)BasicUtil.nvl((Object[])new String[]{variable, condition})).toString();
        con.setValue(variable, value);
        return this;
    }

    @Override
    public Run addCondition(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String prefix, String var, Object value) {
        DefaultAutoCondition condition = new DefaultAutoCondition(swt, compare, prefix, var, value);
        if (null == this.conditionChain) {
            this.conditionChain = new DefaultAutoConditionChain();
        }
        this.conditionChain.addCondition(condition);
        return this;
    }

    @Override
    public Variable getVariable(String key) {
        if (null == key || null == this.variables) {
            return null;
        }
        for (Variable var : this.variables) {
            if (null == var || !key.equalsIgnoreCase(var.getKey())) continue;
            return var;
        }
        return null;
    }

    public List<Variable> getVariables(String key) {
        ArrayList<Variable> list = new ArrayList<Variable>();
        if (null == key || null == this.variables) {
            return list;
        }
        for (Variable var : this.variables) {
            if (null == var || !key.equalsIgnoreCase(var.getKey())) continue;
            list.add(var);
        }
        return list;
    }
}

