/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.entity.data.DatabaseType;
import org.anyline.util.BasicUtil;
import org.anyline.util.LogUtil;
import org.anyline.util.SpringContextUtil;
import org.anyline.util.regular.RegularUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.SQLAdapterUtil")
public class SQLAdapterUtil {
    private static final Logger log = LoggerFactory.getLogger(SQLAdapterUtil.class);
    private static ConcurrentHashMap<String, JDBCAdapter> adapters = new ConcurrentHashMap();
    private static Map<String, Boolean> supports = new HashMap<String, Boolean>();
    private static JDBCAdapter defaultAdapter = null;

    @Autowired(required=false)
    public void setAdapters(Map<String, JDBCAdapter> map) {
        for (JDBCAdapter adapter : map.values()) {
            String version = adapter.version();
            if (null == version) {
                adapters.put(adapter.type().name(), adapter);
            } else {
                adapters.put(adapter.type().name() + "_" + adapter.version(), adapter);
            }
            supports.put(adapter.type().name(), true);
        }
    }

    public static boolean support(DatabaseType type) {
        return supports.containsKey(type.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static JDBCAdapter getAdapter(String datasource, JdbcTemplate template) {
        block12: {
            if (null != SQLAdapterUtil.defaultAdapter) {
                return SQLAdapterUtil.defaultAdapter;
            }
            if (SQLAdapterUtil.adapters.size() == 1) {
                SQLAdapterUtil.defaultAdapter = SQLAdapterUtil.adapters.values().iterator().next();
                return SQLAdapterUtil.defaultAdapter;
            }
            adapter = null;
            adapter = SQLAdapterUtil.adapters.get("al-ds:" + datasource);
            if (null != adapter) {
                return adapter;
            }
            ds = null;
            con = null;
            try {
                name = null;
                version = null;
                if (null != template && null == (adapter = SQLAdapterUtil.getAdapter(datasource, name = (meta = (con = DataSourceUtils.getConnection((DataSource)(ds = template.getDataSource()))).getMetaData()).getDatabaseProductName().toLowerCase().replace(" ", ""), version = meta.getDatabaseProductVersion()))) {
                    adapter = SQLAdapterUtil.getAdapter(datasource, meta.getURL().toLowerCase(), version);
                }
                if (null != adapter) break block12;
                SQLAdapterUtil.log.warn("[\u68c0\u6d4b\u6570\u636e\u5e93\u9002\u914d\u5668][\u68c0\u6d4b\u5931\u8d25][\u53ef\u7528\u9002\u914d\u5668\u6570\u91cf:{}][\u68c0\u6d4b\u5176\u4ed6\u53ef\u7528\u7684\u9002\u914d\u5668]", (Object)SQLAdapterUtil.adapters.size());
                adapter = (JDBCAdapter)SpringContextUtil.getBean(JDBCAdapter.class);
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable var8_9) {
                    if (!DataSourceUtils.isConnectionTransactional(con, ds)) {
                        DataSourceUtils.releaseConnection(con, ds);
                    }
                    throw var8_9;
                }
                if (!DataSourceUtils.isConnectionTransactional(con, ds)) {
                    DataSourceUtils.releaseConnection(con, (DataSource)ds);
                } else {
                    ** GOTO lbl34
                }
            }
        }
        if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
        }
        if (null == adapter) {
            SQLAdapterUtil.log.error("[\u68c0\u6d4b\u6570\u636e\u5e93\u9002\u914d\u5668][\u68c0\u6d4b\u5176\u4ed6\u53ef\u7528\u7684\u9002\u914d\u5668\u5931\u8d25][\u53ef\u7528\u9002\u914d\u5668\u6570\u91cf:{}][{}]", (Object)SQLAdapterUtil.adapters.size(), (Object)LogUtil.format((String)"\u53ef\u80fd\u6ca1\u6709\u4f9d\u8d56anyline-data-jdbc-*(\u5982mysql,neo4j)\u6216\u6ca1\u6709\u626b\u63cforg.anyline\u5305", (int)31));
        }
        return adapter;
    }

    private static JDBCAdapter getAdapter(String datasource, String name, String version) {
        JDBCAdapter adapter = null;
        if (null != version) {
            version = version.toLowerCase();
        }
        if (SQLAdapterUtil.support(DatabaseType.MYSQL) && name.contains("mysql")) {
            adapter = adapters.get(DatabaseType.MYSQL.name());
        } else if (SQLAdapterUtil.support(DatabaseType.MSSQL) && (name.contains("mssql") || name.contains("sqlserver"))) {
            if (null != version) {
                version = version.split("\\.")[0];
                double v = BasicUtil.parseDouble((Object)version, (Double)0.0);
                String key = null;
                key = v >= 9.0 ? "2005" : "2000";
                adapter = adapters.get(DatabaseType.MSSQL.name() + "_" + key);
            }
            if (null == adapter) {
                adapter = adapters.get(DatabaseType.MSSQL.name() + "_2005");
            }
        } else if (SQLAdapterUtil.support(DatabaseType.ORACLE) && name.contains("oracle")) {
            if (null != version) {
                if (null != (version = RegularUtil.cut((String)version, (String[])new String[]{"release", "-"}))) {
                    version = version.split("\\.")[0];
                }
                double v = BasicUtil.parseDouble((Object)version, (Double)0.0);
                String key = null;
                key = v >= 12.0 ? "12" : "11";
                adapter = adapters.get(DatabaseType.ORACLE.name() + "_" + key);
            }
            if (null == adapter) {
                adapter = adapters.get(DatabaseType.ORACLE.name() + "_" + version);
            }
        } else if (SQLAdapterUtil.support(DatabaseType.PostgreSQL) && name.contains("postgresql")) {
            adapter = adapters.get(DatabaseType.PostgreSQL.name());
        } else if (SQLAdapterUtil.support(DatabaseType.ClickHouse) && name.contains("clickhouse")) {
            adapter = adapters.get(DatabaseType.ClickHouse.name());
        } else if (SQLAdapterUtil.support(DatabaseType.DB2) && name.contains("db2")) {
            adapter = adapters.get(DatabaseType.DB2.name());
        } else if (SQLAdapterUtil.support(DatabaseType.Derby) && name.contains("derby")) {
            adapter = adapters.get(DatabaseType.Derby.name());
        } else if (SQLAdapterUtil.support(DatabaseType.DM) && name.contains("dmdbms")) {
            adapter = adapters.get(DatabaseType.DM.name());
        } else if (SQLAdapterUtil.support(DatabaseType.HighGo) && name.contains("hgdb") || name.contains("highgo")) {
            adapter = adapters.get(DatabaseType.HighGo.name());
        } else if (SQLAdapterUtil.support(DatabaseType.KingBase) && name.contains("kingbase")) {
            adapter = adapters.get(DatabaseType.KingBase.name());
        } else if (SQLAdapterUtil.support(DatabaseType.GBase) && name.contains("gbase")) {
            adapter = adapters.get(DatabaseType.GBase.name());
        } else if (SQLAdapterUtil.support(DatabaseType.OceanBase) && name.contains("oceanbase")) {
            adapter = adapters.get(DatabaseType.OceanBase.name());
        } else if (SQLAdapterUtil.support(DatabaseType.OpenGauss) && name.contains("opengauss")) {
            adapter = adapters.get(DatabaseType.OpenGauss.name());
        } else if (SQLAdapterUtil.support(DatabaseType.PolarDB) && name.contains("polardb")) {
            adapter = adapters.get(DatabaseType.PolarDB.name());
        } else if (SQLAdapterUtil.support(DatabaseType.SQLite) && name.contains("sqlite")) {
            adapter = adapters.get(DatabaseType.SQLite.name());
        } else if (SQLAdapterUtil.support(DatabaseType.SQLite) && name.contains("informix")) {
            adapter = adapters.get(DatabaseType.Informix.name());
        } else if (SQLAdapterUtil.support(DatabaseType.H2) && name.contains(":h2:")) {
            adapter = adapters.get(DatabaseType.H2.name());
        } else if (SQLAdapterUtil.support(DatabaseType.HSQLDB) && name.contains("hsqldb")) {
            adapter = adapters.get(DatabaseType.HSQLDB.name());
        } else if (SQLAdapterUtil.support(DatabaseType.TDengine) && name.contains("taos")) {
            adapter = adapters.get(DatabaseType.TDengine.name());
        } else if (SQLAdapterUtil.support(DatabaseType.Neo4j) && name.contains("neo4j")) {
            adapter = adapters.get(DatabaseType.Neo4j.name());
        } else if (SQLAdapterUtil.support(DatabaseType.Neo4j) && name.contains("uxdb")) {
            adapter = adapters.get(DatabaseType.UXDB.name());
        }
        if (null != adapter) {
            adapters.put("al-ds:" + datasource, adapter);
            log.info("[\u68c0\u6d4b\u6570\u636e\u5e93\u9002\u914d\u5668][datasource:{}][\u7279\u5f81:{}][\u9002\u914d\u5668:{}]", new Object[]{datasource, name, adapter});
        }
        return adapter;
    }
}

