/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.listener.init;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.listener.DDListener;
import org.anyline.data.run.RunValue;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.DefaultPageNavi;
import org.anyline.entity.PageNavi;
import org.anyline.entity.data.Column;
import org.anyline.entity.data.Constraint;
import org.anyline.entity.data.ForeignKey;
import org.anyline.entity.data.Function;
import org.anyline.entity.data.Index;
import org.anyline.entity.data.MasterTable;
import org.anyline.entity.data.PartitionTable;
import org.anyline.entity.data.PrimaryKey;
import org.anyline.entity.data.Procedure;
import org.anyline.entity.data.Table;
import org.anyline.entity.data.Trigger;
import org.anyline.entity.data.View;
import org.anyline.service.AnylineService;
import org.anyline.util.ConfigTable;
import org.anyline.util.regular.RegularUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="anyline.jdbc.listener.dd.default")
public class DefaultDDListener
implements DDListener {
    protected Logger log = LoggerFactory.getLogger(DefaultDDListener.class);
    protected AnylineService service;
    protected JDBCAdapter adapter;

    @Override
    public boolean beforeAdd(Column column) {
        return true;
    }

    @Override
    public void afterAdd(Column column, boolean result) {
    }

    @Override
    public boolean beforeAlter(Column column) {
        return true;
    }

    @Override
    public void afterAlter(Column column, boolean result) {
    }

    @Override
    public boolean afterAlterColumnException(Table table, Column column, Exception exception) {
        if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION == 0) {
            return false;
        }
        boolean result = false;
        if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION == 1) {
            this.exeAfterException(table, column, exception);
        } else {
            int rows = this.service.count(table.getName(), new String[0]);
            result = rows > ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION ? this.afterAlterColumnException(table, column, rows, exception) : this.exeAfterException(table, column, exception);
        }
        return result;
    }

    @Override
    public boolean afterAlterColumnException(Table table, Column column, int rows, Exception exception) {
        return false;
    }

    public boolean exeAfterException(Table table, Column column, Exception exception) {
        Column update = column.getUpdate();
        boolean isNum = this.adapter.isNumberColumn(update);
        if (this.adapter.isCharColumn(column) && !this.adapter.isCharColumn(update)) {
            int page = 1;
            int vol = 100;
            DefaultPageNavi navi = new DefaultPageNavi();
            navi.setPageRows(vol);
            List pks = table.primarys();
            if (pks.size() == 0 && null == table.getColumn(DataRow.DEFAULT_PRIMARY_KEY)) {
                return false;
            }
            ArrayList<String> keys = new ArrayList<String>();
            for (Column pk : pks) {
                keys.add(pk.getName());
            }
            while (true) {
                navi.setCurPage(page);
                DataSet set = this.service.querys(table.getName(), (PageNavi)navi, new String[0]);
                if (set.size() == 0) break;
                set.setPrimaryKey(true, keys);
                for (DataRow row : set) {
                    String value = row.getString(column.getName() + "_TMP_UPDATE_TYPE");
                    if (null == value) {
                        value = row.getString(column.getName());
                    }
                    if (null == value) continue;
                    Object convert = null;
                    if (isNum) {
                        value = this.char2number(value);
                    }
                    RunValue run = new RunValue();
                    run.setValue(value);
                    this.adapter.convert(update, run);
                    convert = run.getValue();
                    row.put(column.getName(), convert);
                    this.log.warn("[after exception][\u6570\u636e\u4fee\u6b63][{}>{}]", (Object)value, convert);
                    this.service.update(table.getName(), (Object)row, column.getName());
                }
                if (set.size() < vol) break;
                ++page;
            }
        }
        return true;
    }

    private String char2number(String value) {
        value = value.replaceAll("\\s", "");
        try {
            value = RegularUtil.fetchNumber((String)value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public boolean beforeAlter(Table table, Collection<Column> columns) {
        return true;
    }

    @Override
    public void afterAlter(Table table, Collection<Column> columns, boolean result) {
    }

    @Override
    public boolean beforeDrop(Column column) {
        return true;
    }

    @Override
    public void afterDrop(Column column, boolean result) {
    }

    @Override
    public boolean beforeRename(Column column) {
        return true;
    }

    @Override
    public void afterRename(Column column, boolean result) {
    }

    @Override
    public boolean beforeCreate(Table table) {
        return true;
    }

    @Override
    public void afterCreate(Table table, boolean result) {
    }

    @Override
    public boolean beforeAlter(Table table) {
        return true;
    }

    @Override
    public void afterAlter(Table table, boolean result) {
    }

    @Override
    public boolean beforeDrop(Table table) {
        return true;
    }

    @Override
    public void afterDrop(Table table, boolean result) {
    }

    @Override
    public boolean beforeRename(Table table) {
        return true;
    }

    @Override
    public void afterRename(Table table, boolean result) {
    }

    @Override
    public boolean beforeCreate(View view) {
        return true;
    }

    @Override
    public void afterCreate(View view, boolean result) {
    }

    @Override
    public boolean beforeAlter(View view) {
        return true;
    }

    @Override
    public void afterAlter(View view, boolean result) {
    }

    @Override
    public boolean beforeDrop(View view) {
        return true;
    }

    @Override
    public void afterDrop(View view, boolean result) {
    }

    @Override
    public boolean beforeRename(View view) {
        return true;
    }

    @Override
    public void afterRename(View view, boolean result) {
    }

    @Override
    public boolean beforeCreate(MasterTable table) {
        return true;
    }

    @Override
    public void afterCreate(MasterTable table, boolean result) {
    }

    @Override
    public boolean beforeAlter(MasterTable table) {
        return true;
    }

    @Override
    public void afterAlter(MasterTable table, boolean result) {
    }

    @Override
    public boolean beforeDrop(MasterTable table) {
        return true;
    }

    @Override
    public void afterDrop(MasterTable table, boolean result) {
    }

    @Override
    public boolean beforeRename(MasterTable table) {
        return true;
    }

    @Override
    public void afterRename(MasterTable table, boolean result) {
    }

    @Override
    public boolean beforeCreate(PartitionTable table) {
        return true;
    }

    @Override
    public void afterCreate(PartitionTable table, boolean result) {
    }

    @Override
    public boolean beforeAlter(PartitionTable table) {
        return true;
    }

    @Override
    public void afterAlter(PartitionTable table, boolean result) {
    }

    @Override
    public boolean beforeDrop(PartitionTable table) {
        return true;
    }

    @Override
    public void afterDrop(PartitionTable table, boolean result) {
    }

    @Override
    public boolean beforeRename(PartitionTable table) {
        return true;
    }

    @Override
    public void afterRename(PartitionTable table, boolean result) {
    }

    @Override
    public boolean beforeAdd(PrimaryKey primary) {
        return true;
    }

    @Override
    public void afterAdd(PrimaryKey primary, boolean result) {
    }

    @Override
    public boolean beforeAlter(PrimaryKey primary) {
        return true;
    }

    @Override
    public void afterAlter(PrimaryKey primary, boolean result) {
    }

    @Override
    public boolean beforeDrop(PrimaryKey primary) {
        return true;
    }

    @Override
    public void afterDrop(PrimaryKey primary, boolean result) {
    }

    @Override
    public boolean beforeRename(PrimaryKey primary) {
        return true;
    }

    @Override
    public void afterRename(PrimaryKey primary, boolean result) {
    }

    @Override
    public boolean beforeAdd(ForeignKey foreign) {
        return true;
    }

    @Override
    public void afterAdd(ForeignKey foreign, boolean result) {
    }

    @Override
    public boolean beforeAlter(ForeignKey foreign) {
        return true;
    }

    @Override
    public void afterAlter(ForeignKey foreign, boolean result) {
    }

    @Override
    public boolean beforeDrop(ForeignKey foreign) {
        return true;
    }

    @Override
    public void afterDrop(ForeignKey foreign, boolean result) {
    }

    @Override
    public boolean beforeRename(ForeignKey foreign) {
        return true;
    }

    @Override
    public void afterRename(ForeignKey foreign, boolean result) {
    }

    @Override
    public boolean beforeAdd(Index index) {
        return true;
    }

    @Override
    public void afterAdd(Index index, boolean result) {
    }

    @Override
    public boolean beforeAlter(Index index) {
        return true;
    }

    @Override
    public void afterAlter(Index index, boolean result) {
    }

    @Override
    public boolean beforeDrop(Index index) {
        return true;
    }

    @Override
    public void afterDrop(Index index, boolean result) {
    }

    @Override
    public boolean beforeRename(Index index) {
        return true;
    }

    @Override
    public void afterRename(Index index, boolean result) {
    }

    @Override
    public boolean beforeAdd(Constraint constraint) {
        return true;
    }

    @Override
    public void afterAdd(Constraint constraint, boolean result) {
    }

    @Override
    public boolean beforeAlter(Constraint constraint) {
        return true;
    }

    @Override
    public void afterAlter(Constraint constraint, boolean result) {
    }

    @Override
    public boolean beforeDrop(Constraint constraint) {
        return true;
    }

    @Override
    public void afterDrop(Constraint constraint, boolean result) {
    }

    @Override
    public boolean beforeRename(Constraint constraint) {
        return true;
    }

    @Override
    public void afterRename(Constraint constraint, boolean result) {
    }

    @Override
    public boolean beforeCreate(Procedure procedure) {
        return true;
    }

    @Override
    public void afterCreate(Procedure procedure, boolean result) {
    }

    @Override
    public boolean beforeAlter(Procedure procedure) {
        return true;
    }

    @Override
    public void afterAlter(Procedure procedure, boolean result) {
    }

    @Override
    public boolean beforeDrop(Procedure procedure) {
        return true;
    }

    @Override
    public void afterDrop(Procedure procedure, boolean result) {
    }

    @Override
    public boolean beforeRename(Procedure procedure) {
        return true;
    }

    @Override
    public void afterRename(Procedure procedure, boolean result) {
    }

    @Override
    public boolean beforeCreate(Function function) {
        return true;
    }

    @Override
    public void afterCreate(Function function, boolean result) {
    }

    @Override
    public boolean beforeAlter(Function function) {
        return true;
    }

    @Override
    public void afterAlter(Function function, boolean result) {
    }

    @Override
    public boolean beforeDrop(Function function) {
        return true;
    }

    @Override
    public void afterDrop(Function function, boolean result) {
    }

    @Override
    public boolean beforeRename(Function function) {
        return true;
    }

    @Override
    public void afterRename(Function function, boolean result) {
    }

    @Override
    public boolean beforeCreate(Trigger trigger) {
        return true;
    }

    @Override
    public void afterCreate(Trigger trigger, boolean result) {
    }

    @Override
    public boolean beforeAlter(Trigger trigger) {
        return true;
    }

    @Override
    public void afterAlter(Trigger trigger, boolean result) {
    }

    @Override
    public boolean beforeDrop(Trigger trigger) {
        return true;
    }

    @Override
    public void afterDrop(Trigger trigger, boolean result) {
    }

    @Override
    public boolean beforeRename(Trigger trigger) {
        return true;
    }

    @Override
    public void afterRename(Trigger trigger, boolean result) {
    }

    @Override
    public void setService(AnylineService service) {
        this.service = service;
    }

    public AnylineService setService() {
        return this.service;
    }

    @Override
    public AnylineService getService() {
        return this.service;
    }

    public JDBCAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public void setAdapter(JDBCAdapter adapter) {
        this.adapter = adapter;
    }
}

