/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.ds;

import javax.sql.DataSource;
import org.anyline.dao.AnylineDao;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.jdbc.ds.DataSourceHolder;
import org.anyline.data.jdbc.util.SQLAdapterUtil;
import org.springframework.jdbc.core.JdbcTemplate;

public class JDBCRuntime {
    private String key;
    private JdbcTemplate template;
    private JDBCAdapter adapter;
    private AnylineDao dao;

    public JDBCRuntime() {
    }

    public JDBCRuntime(String key, JdbcTemplate template, JDBCAdapter adapter) {
        this.key = key;
        this.template = template;
        this.adapter = adapter;
    }

    public DataSource getDatasource() {
        return this.template.getDataSource();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public JdbcTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(JdbcTemplate template) {
        this.template = template;
    }

    public AnylineDao getDao() {
        return this.dao;
    }

    public void setDao(AnylineDao dao) {
        this.dao = dao;
    }

    public JDBCAdapter getAdapter() {
        if (null == this.adapter) {
            String ds = this.key;
            if ("common".equals(ds)) {
                ds = DataSourceHolder.curDataSource();
            }
            this.adapter = SQLAdapterUtil.getAdapter(ds, this.template);
            if (null != this.adapter && null == this.adapter.getDao()) {
                this.adapter.setDao(this.dao);
            }
        }
        return this.adapter;
    }

    public String datasource() {
        String ds = this.key;
        if ("common".equals(ds)) {
            ds = DataSourceHolder.curDataSource();
        }
        return ds;
    }

    public void setAdapter(JDBCAdapter adapter) {
        this.adapter = adapter;
    }
}

