/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.ds;

import org.anyline.data.jdbc.ds.DataSourceHolder;
import org.anyline.data.jdbc.ds.JDBCRuntime;
import org.anyline.data.jdbc.ds.RuntimeHolder;
import org.anyline.data.jdbc.util.DataSourceUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.SpringContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component(value="anyline.listener.ds.EnvironmentListener")
public class EnvironmentListener
implements ApplicationContextAware {
    public static Logger log = LoggerFactory.getLogger(EnvironmentListener.class);
    private static ApplicationContext context;
    private static DefaultListableBeanFactory factory;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
        factory = (DefaultListableBeanFactory)context.getAutowireCapableBeanFactory();
        SpringContextUtil.init((ApplicationContext)context);
        RuntimeHolder.init(factory);
        this.load();
    }

    private void load() {
        JdbcTemplate template;
        Environment env = context.getEnvironment();
        String prefixs = env.getProperty("spring.datasource.list");
        boolean multiple = false;
        if (null != prefixs) {
            for (String prefix : prefixs.split(",")) {
                try {
                    String ds = DataSourceUtil.buildDataSource(prefix, "spring.datasource." + prefix, env);
                    if (null == ds) continue;
                    DataSourceHolder.regTransactionManager(prefix, ds);
                    DataSourceHolder.reg(prefix);
                    RuntimeHolder.reg(prefix, ds);
                    multiple = true;
                    log.info("[\u521b\u5efa\u6570\u636e\u6e90][prefix:{}]", (Object)prefix);
                }
                catch (Exception e) {
                    log.error("[\u521b\u5efa\u6570\u636e\u6e90\u5931\u8d25][prefix:{}][msg:{}]", (Object)prefix, (Object)e.toString());
                }
            }
        }
        if (null != (template = (JdbcTemplate)SpringContextUtil.getBean(JdbcTemplate.class))) {
            if (multiple) {
                RuntimeHolder.reg("default", template, null);
                if (ConfigTable.IS_OPEN_PRIMARY_TRANSACTION_MANAGER) {
                    DataSourceHolder.regTransactionManager("primary", template.getDataSource(), true);
                }
            }
            JDBCRuntime runtime = new JDBCRuntime("common", template, null);
            RuntimeHolder.reg("common", runtime);
        }
    }
}

