/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.dao.init.springjdbc;

import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.dao.AnylineDao;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.adapter.init.PersistenceAdapter;
import org.anyline.data.cache.PageLazyStore;
import org.anyline.data.jdbc.ds.DataSourceHolder;
import org.anyline.data.jdbc.ds.JDBCRuntime;
import org.anyline.data.jdbc.ds.RuntimeHolder;
import org.anyline.data.listener.DDListener;
import org.anyline.data.listener.DMListener;
import org.anyline.data.metadata.persistence.ManyToMany;
import org.anyline.data.metadata.persistence.OneToMany;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.prepare.auto.TextPrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.prepare.auto.init.DefaultTextPrepare;
import org.anyline.data.prepare.xml.XMLPrepare;
import org.anyline.data.run.Run;
import org.anyline.data.util.ThreadConfig;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.entity.data.Column;
import org.anyline.entity.data.Constraint;
import org.anyline.entity.data.Database;
import org.anyline.entity.data.ForeignKey;
import org.anyline.entity.data.Function;
import org.anyline.entity.data.Index;
import org.anyline.entity.data.MasterTable;
import org.anyline.entity.data.Parameter;
import org.anyline.entity.data.PartitionTable;
import org.anyline.entity.data.PrimaryKey;
import org.anyline.entity.data.Procedure;
import org.anyline.entity.data.Table;
import org.anyline.entity.data.Tag;
import org.anyline.entity.data.Trigger;
import org.anyline.entity.data.View;
import org.anyline.exception.AnylineException;
import org.anyline.exception.SQLQueryException;
import org.anyline.exception.SQLUpdateException;
import org.anyline.proxy.CacheProxy;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.anyline.util.regular.RegularUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Primary
@Repository(value="anyline.dao")
public class DefaultDao<E>
implements AnylineDao<E> {
    protected static final Logger log = LoggerFactory.getLogger(DefaultDao.class);
    @Autowired(required=false)
    protected static DMListener dmListener;
    @Autowired(required=false)
    protected static DDListener ddListener;
    protected static boolean isBatchInsertRun;
    protected JDBCRuntime runtime = null;

    protected JDBCRuntime runtime() {
        if (null != this.runtime) {
            this.runtime.setDao(this);
            return this.runtime;
        }
        JDBCRuntime r = RuntimeHolder.getRuntime();
        if (null != r) {
            r.setDao(this);
        }
        return r;
    }

    public boolean isFix() {
        return false;
    }

    public DMListener getListener() {
        return dmListener;
    }

    @Autowired(required=false)
    public void setListener(DMListener listener) {
        dmListener = listener;
    }

    public JDBCRuntime getRuntime() {
        return this.runtime;
    }

    @Override
    public void setRuntime(JDBCRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public void setDatasource(String datasource) {
    }

    @Override
    public List<Map<String, Object>> maps(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.maps(true, prepare, configs, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Map<String, Object>> maps(boolean recover, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        List<Map<String, Object>> maps = null;
        try {
            boolean exe = true;
            if (null != dmListener) {
                exe = dmListener.beforeBuildQuery(prepare, configs, conditions);
            }
            if (!exe) {
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                return arrayList;
            }
            JDBCRuntime runtime = this.runtime();
            JDBCAdapter adapter = runtime.getAdapter();
            Run run = adapter.buildQueryRun(prepare, configs, conditions);
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled() && !run.isValid()) {
                String tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
                String src = "";
                src = prepare instanceof TablePrepare ? prepare.getTable() : prepare.getText();
                tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, src, configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + this.runtime().datasource() + "]";
                log.warn(tmp);
            }
            if (run.isValid()) {
                if (null != dmListener) {
                    dmListener.beforeQuery(run, -1);
                }
                Long fr = System.currentTimeMillis();
                maps = this.maps(runtime, run.getFinalQuery(), run.getValues());
                if (null != adapter) {
                    maps = adapter.process(maps);
                }
                if (null != dmListener) {
                    dmListener.afterQuery(run, maps, System.currentTimeMillis() - fr);
                }
            } else {
                maps = new ArrayList<Map<String, Object>>();
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return maps;
    }

    @Override
    public List<Map<String, Object>> maps(RunPrepare prepare, String ... conditions) {
        return this.maps(prepare, (ConfigStore)null, conditions);
    }

    @Override
    public DataSet querys(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.querys(true, prepare, configs, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSet querys(boolean recover, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        DataSet set = null;
        try {
            Long fr;
            boolean exe = true;
            if (null != dmListener) {
                exe = dmListener.beforeBuildQuery(prepare, configs, conditions);
            }
            if (!exe) {
                DataSet dataSet = new DataSet();
                return dataSet;
            }
            JDBCRuntime runtime = this.runtime();
            JDBCAdapter adapter = runtime.getAdapter();
            Run run = adapter.buildQueryRun(prepare, configs, conditions);
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled() && !run.isValid()) {
                String tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
                String src = "";
                src = prepare instanceof TablePrepare ? prepare.getTable() : prepare.getText();
                tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, src, configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + this.runtime().datasource() + "]";
                log.warn(tmp);
            }
            PageNavi navi = run.getPageNavi();
            int total = 0;
            if (run.isValid() && null != navi) {
                if (null != dmListener) {
                    dmListener.beforeTotal(run);
                }
                fr = System.currentTimeMillis();
                if (navi.getLastRow() == 0) {
                    total = 1;
                } else if (navi.getTotalRow() == 0) {
                    total = this.getTotal(run.getTotalQuery(), run.getValues());
                    navi.setTotalRow(total);
                } else {
                    total = navi.getTotalRow();
                }
                if (null != dmListener) {
                    dmListener.afterTotal(run, total, System.currentTimeMillis() - fr);
                }
                if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("[\u67e5\u8be2\u8bb0\u5f55\u603b\u6570][\u884c\u6570:{}]", (Object)total);
                }
            }
            if (run.isValid()) {
                fr = System.currentTimeMillis();
                if (null == navi || total > 0) {
                    if (null != dmListener) {
                        dmListener.beforeQuery(run, total);
                    }
                    set = this.select(runtime, prepare.getTable(), run.getFinalQuery(), run.getValues());
                    if (null != dmListener) {
                        dmListener.afterQuery(run, set, System.currentTimeMillis() - fr);
                    }
                } else {
                    set = new DataSet();
                }
            } else {
                set = new DataSet();
            }
            set.setDataSource(prepare.getDataSource());
            set.setNavi(navi);
            if (null != navi && navi.isLazy()) {
                PageLazyStore.setTotal(navi.getLazyKey(), navi.getTotalRow());
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return set;
    }

    @Override
    public <T> EntitySet<T> querys(Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.querys(true, clazz, configs, conditions);
    }

    protected <T> EntitySet<T> querys(boolean recover, Class<T> clazz, ConfigStore configs, String ... conditions) {
        DefaultTablePrepare prepare = new DefaultTablePrepare();
        return this.querys(recover, (RunPrepare)prepare, clazz, configs, conditions);
    }

    @Override
    public <T> EntitySet<T> querys(RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.querys(true, prepare, clazz, configs, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> EntitySet<T> querys(boolean recover, RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        EntitySet<T> list = null;
        try {
            Long fr;
            boolean exe = true;
            if (null != dmListener) {
                exe = dmListener.beforeBuildQuery(prepare, configs, conditions);
            }
            if (!exe) {
                EntitySet entitySet = new EntitySet();
                return entitySet;
            }
            if (BasicUtil.isEmpty((Object)prepare.getDataSource()) && !(prepare instanceof TextPrepare) && !(prepare instanceof XMLPrepare) && EntityAdapterProxy.hasAdapter()) {
                prepare.setDataSource(EntityAdapterProxy.table(clazz).getName());
            }
            JDBCRuntime runtime = this.runtime();
            JDBCAdapter adapter = runtime.getAdapter();
            Run run = adapter.buildQueryRun(prepare, configs, conditions);
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled() && !run.isValid()) {
                String tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
                tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, clazz.getName(), configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + this.runtime().datasource() + "]";
                log.warn(tmp);
            }
            PageNavi navi = run.getPageNavi();
            int total = 0;
            if (run.isValid()) {
                if (null != navi) {
                    if (null != dmListener) {
                        dmListener.beforeTotal(run);
                    }
                    fr = System.currentTimeMillis();
                    if (navi.getLastRow() == 0) {
                        total = 1;
                    } else if (navi.getTotalRow() == 0) {
                        total = this.getTotal(run.getTotalQuery(), run.getValues());
                        navi.setTotalRow(total);
                    } else {
                        total = navi.getTotalRow();
                    }
                    if (null != dmListener) {
                        dmListener.afterTotal(run, total, System.currentTimeMillis() - fr);
                    }
                }
                if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("[\u67e5\u8be2\u8bb0\u5f55\u603b\u6570][\u884c\u6570:{}]", (Object)total);
                }
            }
            if (run.isValid()) {
                fr = System.currentTimeMillis();
                if (null == navi || total > 0) {
                    if (null != dmListener) {
                        dmListener.beforeQuery(run, total);
                    }
                    fr = System.currentTimeMillis();
                    list = this.select(runtime, clazz, run.getTable(), run.getFinalQuery(), run.getValues(), ThreadConfig.check(runtime.getKey()).ENTITY_FIELD_SELECT_DEPENDENCY());
                    if (null != dmListener) {
                        dmListener.afterQuery(run, list, System.currentTimeMillis() - fr);
                    }
                } else {
                    list = new EntitySet();
                }
            } else {
                list = new EntitySet<T>();
            }
            list.setNavi(navi);
            if (null != navi && navi.isLazy()) {
                PageLazyStore.setTotal(navi.getLazyKey(), navi.getTotalRow());
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return list;
    }

    @Override
    public DataSet querys(RunPrepare prepare, String ... conditions) {
        return this.querys(prepare, (ConfigStore)null, conditions);
    }

    @Override
    public DataSet selects(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.querys(prepare, configs, conditions);
    }

    @Override
    public DataSet selects(RunPrepare prepare, String ... conditions) {
        return this.querys(prepare, (ConfigStore)null, conditions);
    }

    @Override
    public DataRow sequence(boolean next, String ... names) {
        JDBCAdapter adapter;
        String sql;
        JDBCRuntime runtime = this.runtime();
        DataSet set = this.select(runtime, "", sql = (adapter = runtime.getAdapter()).buildQuerySequence(next, names), null);
        if (set.size() > 0) {
            return set.getRow(0);
        }
        return new DataRow();
    }

    @Override
    public int count(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.count(true, prepare, configs, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int count(boolean recover, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        int count = -1;
        try {
            boolean exe = true;
            if (null != dmListener) {
                exe = dmListener.beforeBuildQuery(prepare, configs, conditions);
            }
            if (!exe) {
                int n = -1;
                return n;
            }
            JDBCRuntime runtime = this.runtime();
            JDBCAdapter adapter = runtime.getAdapter();
            Run run = adapter.buildQueryRun(prepare, configs, conditions);
            Long fr = System.currentTimeMillis();
            if (null != dmListener) {
                dmListener.beforeCount(run);
            }
            fr = System.currentTimeMillis();
            count = this.getTotal(run.getTotalQuery(), run.getValues());
            if (null != dmListener) {
                dmListener.afterCount(run, count, System.currentTimeMillis() - fr);
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return count;
    }

    @Override
    public int count(RunPrepare prepare, String ... conditions) {
        return this.count(prepare, (ConfigStore)null, conditions);
    }

    @Override
    public boolean exists(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.exists(true, prepare, configs, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean exists(boolean recover, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        boolean result = false;
        try {
            boolean exe = true;
            if (null != dmListener) {
                exe = dmListener.beforeBuildQuery(prepare, configs, conditions);
            }
            if (!exe) {
                boolean bl = false;
                return bl;
            }
            JDBCRuntime runtime = this.runtime();
            JDBCAdapter adapter = runtime.getAdapter();
            Run run = adapter.buildQueryRun(prepare, configs, conditions);
            String txt = run.getFinalExists();
            List<Object> values = run.getValues();
            long fr = System.currentTimeMillis();
            String random = "";
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                random = this.random();
                log.info("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, txt, this.paramLogFormat(values)});
            }
            try {
                if (null != dmListener) {
                    dmListener.beforeExists(run);
                }
                Map map = null;
                if (null == values || values.size() <= 0 || !BasicUtil.isEmpty((boolean)true, values)) {
                    map = null != values && values.size() > 0 ? runtime.getTemplate().queryForMap(txt, values.toArray()) : runtime.getTemplate().queryForMap(txt);
                    result = null == map ? false : BasicUtil.parseBoolean(map.get("IS_EXISTS"), (Boolean)false);
                }
                Long millis = System.currentTimeMillis() - fr;
                if (null != dmListener) {
                    dmListener.afterExists(run, result, millis);
                }
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check(runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[SLOW SQL][action:exists][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, txt, this.paramLogFormat(values)});
                    if (null != dmListener) {
                        dmListener.slow("exists", run, txt, values, null, millis);
                    }
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((boolean)result, (int)34)});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    throw e;
                }
                if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                    log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), prepare, this.paramLogFormat(values)});
                }
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return result;
    }

    @Override
    public boolean exists(RunPrepare prepare, String ... conditions) {
        return this.exists(prepare, (ConfigStore)null, conditions);
    }

    protected int getTotal(String sql, List<Object> values) {
        int total = 0;
        JDBCRuntime runtime = this.runtime();
        DataSet set = this.select(runtime, null, sql, values);
        total = set.getInt(0, "CNT", 0);
        return total;
    }

    @Override
    public int update(String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.update(true, dest, data, configs, columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int update(boolean recover, String dest, Object data, ConfigStore configs, List<String> columns) {
        dest = DataSourceHolder.parseDataSource(dest, data);
        boolean exe = true;
        if (null != dmListener) {
            exe = dmListener.beforeBuildUpdate(dest, data, configs, false, columns);
        }
        if (!exe) {
            return -1;
        }
        if (null == data) {
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                throw new SQLUpdateException("\u66f4\u65b0\u7a7a\u6570\u636e");
            }
            log.error("\u66f4\u65b0\u7a7a\u6570\u636e");
        }
        int result = 0;
        if (data instanceof DataSet) {
            DataSet set = (DataSet)data;
            for (int i = 0; i < set.size(); ++i) {
                result += this.update(dest, (Object)set.getRow(i), configs, columns);
            }
            return result;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        Run run = adapter.buildUpdateRun(dest, data, configs, false, columns);
        String sql = run.getFinalUpdate();
        if (BasicUtil.isEmpty((Object)sql)) {
            log.warn("[\u4e0d\u5177\u5907\u66f4\u65b0\u6761\u4ef6][dest:{}]", (Object)dest);
            return -1;
        }
        List<Object> values = run.getValues();
        long fr = System.currentTimeMillis();
        String random = "";
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            random = this.random();
            log.info("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, this.paramLogFormat(run.getUpdateColumns(), values)});
        }
        try {
            boolean listenerResult = true;
            if (null != dmListener) {
                listenerResult = dmListener.beforeUpdate(run, dest, data, columns);
            }
            if (listenerResult) {
                result = runtime.getTemplate().update(sql, values.toArray());
                this.checkMany2ManyDependencySave(runtime, data, ConfigTable.ENTITY_FIELD_INSERT_DEPENDENCY, 1);
                this.checkOne2ManyDependencySave(runtime, data, ConfigTable.ENTITY_FIELD_INSERT_DEPENDENCY, 1);
                Long millis = System.currentTimeMillis() - fr;
                if (null != dmListener) {
                    dmListener.afterUpdate(run, result, dest, data, columns, millis);
                }
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check(runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[SLOW SQL][action:update][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, sql, this.paramLogFormat(values)});
                    if (null != dmListener) {
                        dmListener.slow("update", run, sql, values, null, millis);
                    }
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((int)result, (int)34)});
                }
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                SQLUpdateException ex = new SQLUpdateException("update\u5f02\u5e38:" + e.toString(), e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u66f4\u65b0\u5f02\u5e38:", (int)33) + e.toString(), sql, this.paramLogFormat(run.getUpdateColumns(), values)});
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return result;
    }

    @Override
    public int update(Object data, ConfigStore configs, String ... columns) {
        return this.update(null, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int update(String dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(dest, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int update(Object data, ConfigStore configs, List<String> columns) {
        return this.update(null, data, configs, columns);
    }

    @Override
    public int update(String dest, Object data, String ... columns) {
        return this.update(dest, data, (ConfigStore)null, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int update(Object data, String ... columns) {
        return this.update(null, data, (ConfigStore)null, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int update(String dest, Object data, List<String> columns) {
        return this.update(dest, data, (ConfigStore)null, columns);
    }

    @Override
    public int update(Object data, List<String> columns) {
        return this.update(null, data, (ConfigStore)null, columns);
    }

    @Override
    public int save(String dest, Object data, boolean checkPrimary, String ... columns) {
        if (null == data) {
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                throw new SQLUpdateException("save\u7a7a\u6570\u636e");
            }
            log.error("save\u7a7a\u6570\u636e");
            return -1;
        }
        if (data instanceof Collection) {
            Collection items = (Collection)data;
            int cnt = 0;
            for (Object item : items) {
                cnt += this.save(dest, item, checkPrimary, columns);
            }
            return cnt;
        }
        return this.saveObject(dest, data, checkPrimary, columns);
    }

    @Override
    public int save(Object data, boolean checkPrimary, String ... columns) {
        return this.save(null, data, checkPrimary, columns);
    }

    @Override
    public int save(String dest, Object data, String ... columns) {
        return this.save(dest, data, false, columns);
    }

    @Override
    public int save(Object data, String ... columns) {
        return this.save(null, data, false, columns);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int saveObject(String dest, Object data, boolean checkPrimary, String ... columns) {
        if (null == data) {
            return 0;
        }
        boolean isNew = this.checkIsNew(data);
        if (isNew) {
            return this.insert(dest, data, checkPrimary, columns);
        }
        Boolean override = this.checkOverride(data);
        boolean exe = true;
        if (null == override) return this.update(dest, data, columns);
        DefaultTablePrepare prepare = new DefaultTablePrepare(dest);
        Map<String, Object> pvs = this.checkPv(data);
        DefaultConfigStore stores = new DefaultConfigStore(new String[0]);
        for (String k : pvs.keySet()) {
            stores.and(k, pvs.get(k));
        }
        boolean exists = this.exists((RunPrepare)prepare, stores, new String[0]);
        if (!exists) return this.insert(dest, data, checkPrimary, columns);
        if (override.booleanValue()) {
            return this.update(dest, data, columns);
        }
        log.warn("[\u8df3\u8fc7\u66f4\u65b0][\u6570\u636e\u5df2\u5b58\u5728:{}({})]", (Object)dest, (Object)BeanUtil.map2json(pvs));
        return 0;
    }

    protected Boolean checkOverride(Object obj) {
        Boolean result = null;
        if (null != obj && obj instanceof DataRow) {
            result = ((DataRow)obj).getOverride();
        }
        return result;
    }

    protected Map<String, Object> checkPv(Object obj) {
        HashMap<String, Object> pvs = new HashMap<String, Object>();
        if (null != obj && obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            List ks = row.getPrimaryKeys();
            for (String k : ks) {
                pvs.put(k, row.get(k));
            }
        }
        return pvs;
    }

    protected boolean checkIsNew(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            return row.isNew();
        }
        if (EntityAdapterProxy.hasAdapter()) {
            Map values = EntityAdapterProxy.primaryValues((Object)obj);
            for (Map.Entry entry : values.entrySet()) {
                if (!BasicUtil.isNotEmpty(entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int insert(String dest, Object data, boolean checkPrimary, List<String> columns) {
        return this.insert(true, dest, data, checkPrimary, columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int insert(boolean recover, String dest, Object data, boolean checkPrimary, List<String> columns) {
        Run run;
        DataSet set;
        Map tags;
        dest = DataSourceHolder.parseDataSource(dest, data);
        boolean exe = true;
        if (null != dmListener) {
            exe = dmListener.beforeBuildInsert(dest, data, checkPrimary, columns);
        }
        if (!exe) {
            return -1;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        if (null != data && data instanceof DataSet && null != (tags = (set = (DataSet)data).getTags()) && tags.size() > 0) {
            LinkedHashMap ptables = this.ptables(false, new MasterTable(dest), tags);
            if (ptables.size() != 1) {
                String msg = "\u5206\u533a\u8868\u5b9a\u4f4d\u5f02\u5e38,\u4e3b\u8868:" + dest + ",\u6807\u7b7e:" + BeanUtil.map2json((Map)tags) + ",\u5206\u533a\u8868:" + BeanUtil.object2json(ptables.keySet());
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new SQLUpdateException(msg);
                }
                log.error(msg);
                return -1;
            }
            dest = ((PartitionTable)ptables.values().iterator().next()).getName();
        }
        if (null == (run = adapter.buildInsertRun(runtime.getTemplate(), dest, data, checkPrimary, columns))) {
            return 0;
        }
        int cnt = 0;
        String sql = run.getFinalInsert();
        List<Object> values = run.getValues();
        long fr = System.currentTimeMillis();
        String random = "";
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            random = this.random();
            log.info("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, this.paramLogFormat(run.getInsertColumns(), values)});
        }
        try {
            boolean listenerResult = true;
            if (null != dmListener) {
                listenerResult = dmListener.beforeInsert(run, dest, data, checkPrimary, columns);
            }
            if (listenerResult) {
                cnt = adapter.insert(runtime.getTemplate(), random, data, sql, values, null);
                int ENTITY_FIELD_INSERT_DEPENDENCY = ThreadConfig.check(runtime.getKey()).ENTITY_FIELD_INSERT_DEPENDENCY();
                this.checkMany2ManyDependencySave(runtime, data, ENTITY_FIELD_INSERT_DEPENDENCY, 0);
                this.checkOne2ManyDependencySave(runtime, data, ENTITY_FIELD_INSERT_DEPENDENCY, 0);
                Long millis = System.currentTimeMillis() - fr;
                if (null != dmListener) {
                    dmListener.afterInsert(run, cnt, dest, data, checkPrimary, columns, millis);
                }
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check(runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[SLOW SQL][action:insert][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, sql, this.paramLogFormat(values)});
                    if (null != dmListener) {
                        dmListener.slow("insert", run, sql, values, null, millis);
                    }
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((int)cnt, (int)34)});
                }
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                SQLUpdateException ex = new SQLUpdateException("insert\u5f02\u5e38:" + e.toString(), e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u63d2\u5165\u5f02\u5e38:", (int)33) + e.toString(), sql, this.paramLogFormat(run.getInsertColumns(), values)});
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return cnt;
    }

    private int checkMany2ManyDependencySave(JDBCRuntime runtime, Object obj, int dependency, int mode) {
        int result = 0;
        if (dependency <= 0) {
            return result;
        }
        if (obj instanceof DataSet || obj instanceof DataRow || obj instanceof Map) {
            return result;
        }
        if (obj instanceof EntitySet) {
            EntitySet set = (EntitySet)obj;
            for (Object entity : set) {
                this.checkMany2ManyDependencySave(runtime, entity, dependency, mode);
            }
        } else {
            Class<?> clazz = obj.getClass();
            Column pc = EntityAdapterProxy.primaryKey(clazz);
            String pk = null;
            if (null != pc) {
                pk = pc.getName();
            }
            List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"ManyToMany"});
            for (Field field : fields) {
                try {
                    ManyToMany join = PersistenceAdapter.manyToMany(field);
                    Map primaryValueMap = EntityAdapterProxy.primaryValue((Object)obj);
                    Object pv = primaryValueMap.get(pk.toUpperCase());
                    Object fv = BeanUtil.getFieldValue((Object)obj, (Field)field);
                    if (null == fv) continue;
                    DataSet set = new DataSet();
                    Collection fvs = new ArrayList();
                    if (null == join.dependencyTable) {
                        if (fv.getClass().isArray()) {
                            fvs = BeanUtil.array2collection((Object)fv);
                        } else if (fv instanceof Collection) {
                            fvs = (Collection)fv;
                        }
                    } else {
                        Object objs;
                        Column joinpc = EntityAdapterProxy.primaryKey(clazz);
                        String joinpk = null;
                        if (null != joinpc) {
                            joinpk = joinpc.getName();
                        }
                        if (fv.getClass().isArray()) {
                            for (Object item : objs = (Object[])fv) {
                                fvs.add(EntityAdapterProxy.primaryValue((Object)item).get(joinpk.toUpperCase()));
                            }
                        } else if (fv instanceof Collection) {
                            objs = (Collection)fv;
                            Iterator iterator = objs.iterator();
                            while (iterator.hasNext()) {
                                Object item = iterator.next();
                                fvs.add(EntityAdapterProxy.primaryValue(item).get(joinpk.toUpperCase()));
                            }
                        }
                    }
                    for (Object item : fvs) {
                        DataRow row = new DataRow();
                        row.put(join.joinColumn, pv);
                        row.put(join.inverseJoinColumn, item);
                        set.add(row);
                    }
                    if (mode == 1) {
                        this.deletes(false, join.joinTable, join.joinColumn, pv + "");
                    }
                    this.insert(false, join.joinTable, (Object)set, new String[0]);
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                        continue;
                    }
                    log.error("[check Many2ManyDependency Save][result:fail][msg:{}]", (Object)e.toString());
                }
            }
        }
        --dependency;
        return result;
    }

    private int checkOne2ManyDependencySave(JDBCRuntime runtime, Object obj, int dependency, int mode) {
        int result = 0;
        if (dependency <= 0) {
            return result;
        }
        if (obj instanceof DataSet || obj instanceof DataRow || obj instanceof Map) {
            return result;
        }
        if (obj instanceof EntitySet) {
            EntitySet set = (EntitySet)obj;
            for (Object entity : set) {
                this.checkOne2ManyDependencySave(runtime, entity, dependency, mode);
            }
        } else {
            Class<?> clazz = obj.getClass();
            Column pc = EntityAdapterProxy.primaryKey(clazz);
            String pk = null;
            if (null != pc) {
                pk = pc.getName();
            }
            List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"OneToMany"});
            for (Field field : fields) {
                try {
                    OneToMany join = PersistenceAdapter.oneToMany(field);
                    Object pv = EntityAdapterProxy.primaryValue((Object)obj).get(pk.toUpperCase());
                    Object fv = BeanUtil.getFieldValue((Object)obj, (Field)field);
                    if (null == fv) continue;
                    if (null == join.joinField) {
                        throw new RuntimeException(field + "\u5173\u8054\u5c5e\u6027\u5f02\u5e38");
                    }
                    if (null == join.joinColumn) {
                        throw new RuntimeException(field + "\u5173\u8054\u5217\u5f02\u5e38");
                    }
                    if (null == join.dependencyTable) {
                        throw new RuntimeException(field + "\u5173\u8054\u8868\u5f02\u5e38");
                    }
                    if (mode == 1) {
                        this.deletes(false, join.dependencyTable, join.joinColumn, pv + "");
                    }
                    ArrayList<Object> items = new ArrayList<Object>();
                    if (fv.getClass().isArray()) {
                        Object[] objs = (Object[])fv;
                        for (Object item : objs) {
                            BeanUtil.setFieldValue((Object)item, (Field)join.joinField, pv);
                            items.add(item);
                        }
                    } else if (fv instanceof Collection) {
                        Collection cols = (Collection)fv;
                        for (Object item : cols) {
                            BeanUtil.setFieldValue(item, (Field)join.joinField, pv);
                            items.add(item);
                        }
                    }
                    this.insert(false, join.dependencyTable, items, new String[0]);
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                        continue;
                    }
                    log.error("[check One2ManyDependency Save][result:fail][msg:{}]", (Object)e.toString());
                }
            }
        }
        --dependency;
        return result;
    }

    @Override
    public int insert(Object data, boolean checkPrimary, List<String> columns) {
        return this.insert(null, data, checkPrimary, columns);
    }

    @Override
    public int insert(String dest, Object data, List<String> columns) {
        return this.insert(dest, data, false, columns);
    }

    @Override
    public int insert(Object data, List<String> columns) {
        return this.insert(null, data, false, columns);
    }

    @Override
    public int insert(String dest, Object data, boolean checkPrimary, String ... columns) {
        return this.insert(dest, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int insert(Object data, boolean checkPrimary, String ... columns) {
        return this.insert(null, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int insert(String dest, Object data, String ... columns) {
        return this.insert(dest, data, false, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    protected int insert(boolean recover, String dest, Object data, String ... columns) {
        return this.insert(recover, dest, data, false, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int insert(Object data, String ... columns) {
        return this.insert(null, data, false, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    protected List<Map<String, Object>> maps(JDBCRuntime runtime, String sql, List<Object> values) {
        List<Map<String, Object>> maps;
        block12: {
            JDBCAdapter adapter = runtime.getAdapter();
            maps = null;
            if (BasicUtil.isEmpty((Object)sql)) {
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    throw new SQLQueryException("\u672a\u6307\u5b9aSQL");
                }
                log.error("\u672a\u6307\u5b9aSQL");
                return new ArrayList<Map<String, Object>>();
            }
            long fr = System.currentTimeMillis();
            String random = "";
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                random = this.random();
                log.info("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, this.paramLogFormat(values)});
            }
            try {
                maps = null != values && values.size() > 0 ? runtime.getTemplate().queryForList(sql, values.toArray()) : runtime.getTemplate().queryForList(sql);
                long mid = System.currentTimeMillis();
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check(runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L && mid - fr > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[SLOW SQL][action:select][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, mid - fr, sql, this.paramLogFormat(values)});
                    if (null != dmListener) {
                        dmListener.slow("select", null, sql, values, null, mid);
                    }
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)(mid - fr));
                }
                if (null != adapter) {
                    maps = adapter.process(maps);
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, System.currentTimeMillis() - mid, maps.size()});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38:" + e.toString(), e);
                    ex.setSql(sql);
                    ex.setValues(values);
                    throw ex;
                }
                if (!ConfigTable.IS_SHOW_SQL_WHEN_ERROR) break block12;
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), sql, this.paramLogFormat(values)});
            }
        }
        return maps;
    }

    protected static DataRow row(boolean system, JDBCRuntime runtime, LinkedHashMap<String, Column> metadatas, ResultSet rs) {
        DataRow row = new DataRow();
        try {
            Column column;
            String name;
            int i;
            JDBCAdapter adapter = runtime.getAdapter();
            ResultSetMetaData rsmd = rs.getMetaData();
            int qty = rsmd.getColumnCount();
            if (!system && metadatas.isEmpty()) {
                for (i = 1; i <= qty; ++i) {
                    name = rsmd.getColumnName(i);
                    if (null == name || name.toUpperCase().equals("PAGE_ROW_NUMBER_")) continue;
                    column = metadatas.get(name);
                    column = adapter.column(column, rsmd, i);
                    metadatas.put(name.toUpperCase(), column);
                }
            }
            for (i = 1; i <= qty; ++i) {
                name = rsmd.getColumnLabel(i);
                if (null == name || name.toUpperCase().equals("PAGE_ROW_NUMBER_")) continue;
                column = metadatas.get(name.toUpperCase());
                Object value = adapter.read(column, rs.getObject(name), null);
                row.put(false, name, value);
            }
            row.setMetadatas(metadatas);
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[\u5c01\u88c5\u7ed3\u679c\u96c6][result:fail][msg:{}]", (Object)e.toString());
        }
        return row;
    }

    protected DataSet select(JDBCRuntime runtime, String table, String sql, List<Object> values) {
        return this.select(false, runtime, table, sql, values);
    }

    protected DataSet select(final boolean system, final JDBCRuntime runtime, String table, String sql, List<Object> values) {
        DataSet set;
        block16: {
            if (BasicUtil.isEmpty((Object)sql)) {
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    throw new SQLQueryException("\u672a\u6307\u5b9aSQL");
                }
                log.error("\u672a\u6307\u5b9aSQL");
                return new DataSet();
            }
            long fr = System.currentTimeMillis();
            String random = "";
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                random = this.random();
                log.info("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, this.paramLogFormat(values)});
            }
            set = new DataSet();
            LinkedHashMap<Object, Object> columns = new LinkedHashMap();
            if (!system && ThreadConfig.check(runtime.getKey()).IS_AUTO_CHECK_METADATA() && null != table) {
                columns = this.columns(runtime, false, new Table(null, null, table));
            }
            try {
                final long[] mid = new long[]{System.currentTimeMillis()};
                final boolean[] process = new boolean[]{false};
                final LinkedHashMap metadatas = new LinkedHashMap();
                metadatas.putAll(columns);
                set.setMetadatas(metadatas);
                if (null != values && values.size() > 0) {
                    runtime.getTemplate().query(sql, values.toArray(), new RowCallbackHandler(){

                        public void processRow(ResultSet rs) throws SQLException {
                            if (!process[0]) {
                                mid[0] = System.currentTimeMillis();
                            }
                            DataRow row = DefaultDao.row(system, runtime, metadatas, rs);
                            set.add(row);
                            process[0] = true;
                        }
                    });
                } else {
                    runtime.getTemplate().query(sql, new RowCallbackHandler(){

                        public void processRow(ResultSet rs) throws SQLException {
                            if (!process[0]) {
                                mid[0] = System.currentTimeMillis();
                            }
                            DataRow row = DefaultDao.row(system, runtime, metadatas, rs);
                            set.add(row);
                            process[0] = true;
                        }
                    });
                }
                if (!process[0]) {
                    mid[0] = System.currentTimeMillis();
                }
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check(runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L) {
                    slow = true;
                    if (mid[0] - fr > SLOW_SQL_MILLIS) {
                        log.warn("{}[SLOW SQL][action:select][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, mid[0] - fr, sql, this.paramLogFormat(values)});
                        if (null != dmListener) {
                            dmListener.slow("select", null, sql, values, null, mid[0] - fr);
                        }
                    }
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)(mid[0] - fr));
                }
                set.setDatalink(runtime.datasource());
                if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, System.currentTimeMillis() - mid[0], set.size()});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38:" + e.toString(), e);
                    ex.setSql(sql);
                    ex.setValues(values);
                    throw ex;
                }
                if (!ConfigTable.IS_SHOW_SQL_WHEN_ERROR) break block16;
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), sql, this.paramLogFormat(values)});
            }
        }
        return set;
    }

    protected <T> EntitySet<T> select(JDBCRuntime runtime, Class<T> clazz, String table, String sql, List<Object> values, int dependency) {
        EntitySet set = new EntitySet();
        DataSet rows = this.select(runtime, table, sql, values);
        for (DataRow row : rows) {
            Object entity = null;
            entity = EntityAdapterProxy.hasAdapter() ? EntityAdapterProxy.entity(clazz, (Map)row, null) : row.entity(clazz, new String[0]);
            set.add(entity);
        }
        if (dependency > 0) {
            this.checkMany2ManyDependencyQuery(runtime, set, dependency);
            this.checkOne2ManyDependencyQuery(runtime, set, dependency);
        }
        return set;
    }

    protected <T> void checkMany2ManyDependencyQuery(JDBCRuntime runtime, EntitySet<T> set, int dependency) {
        if (set.size() == 0 || dependency <= 0) {
            return;
        }
        --dependency;
        Class<?> clazz = set.get(0).getClass();
        Column pc = EntityAdapterProxy.primaryKey(clazz);
        String pk = null;
        if (null != pc) {
            pk = pc.getName();
        }
        List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"ManyToMany"});
        Compare compare = ThreadConfig.check(runtime.getKey()).ENTITY_FIELD_SELECT_DEPENDENCY_COMPARE();
        for (Field field : fields) {
            try {
                DefaultConfigStore conditions;
                String sql;
                ManyToMany join = PersistenceAdapter.manyToMany(field);
                if (Compare.EQUAL == compare || set.size() == 1) {
                    for (Object entity : set) {
                        Map primaryValueMap = EntityAdapterProxy.primaryValue(entity);
                        if (null == join.dependencyTable) {
                            DataSet items = this.querys(false, (RunPrepare)new DefaultTablePrepare(join.joinTable), (ConfigStore)new DefaultConfigStore(new String[0]), "++" + join.joinColumn + ":" + primaryValueMap.get(pk.toUpperCase()));
                            List ids = items.getStrings(join.inverseJoinColumn);
                            BeanUtil.setFieldValue(entity, (Field)field, (Object)ids);
                            continue;
                        }
                        sql = "SELECT * FROM " + join.dependencyTable + " WHERE " + join.dependencyPk + " IN (SELECT " + join.inverseJoinColumn + " FROM " + join.joinTable + " WHERE " + join.joinColumn + "=?" + ")";
                        ArrayList<Object> params = new ArrayList<Object>();
                        params.add(primaryValueMap.get(pk.toUpperCase()));
                        EntitySet<T> dependencys = this.select(runtime, join.itemClass, null, sql, params, dependency);
                        BeanUtil.setFieldValue(entity, (Field)field, dependencys);
                    }
                    continue;
                }
                if (Compare.IN != compare) continue;
                ArrayList pvs = new ArrayList();
                HashMap idmap = new HashMap();
                for (Object entity : set) {
                    Map primaryValueMap = EntityAdapterProxy.primaryValue(entity);
                    Object pv = primaryValueMap.get(pk.toUpperCase());
                    pvs.add(pv);
                    idmap.put(entity, pv);
                }
                if (null == join.dependencyTable) {
                    conditions = new DefaultConfigStore(new String[0]);
                    conditions.and(join.joinColumn, pvs);
                    DataSet allItems = this.querys(false, (RunPrepare)new DefaultTablePrepare(join.joinTable), (ConfigStore)conditions, new String[0]);
                    for (Object entity : set) {
                        DataSet items = allItems.getRows(new String[]{join.joinColumn, idmap.get(entity) + ""});
                        List ids = items.getStrings(join.inverseJoinColumn);
                        BeanUtil.setFieldValue(entity, (Field)field, (Object)ids);
                    }
                    continue;
                }
                conditions = new DefaultConfigStore(new String[0]);
                conditions.param("JOIN_PVS", pvs);
                sql = "SELECT M.*, F." + join.joinColumn + " FK_" + join.joinColumn + " FROM " + join.dependencyTable + " M RIGHT JOIN " + join.joinTable + " F ON M." + join.dependencyPk + " = " + join.inverseJoinColumn + " WHERE " + join.joinColumn + " IN(#{JOIN_PVS})";
                DataSet alls = this.querys(false, (RunPrepare)new DefaultTextPrepare(sql), (ConfigStore)conditions, new String[0]);
                for (Object entity : set) {
                    DataSet items = alls.getRows(new String[]{"FK_" + join.joinColumn, idmap.get(entity) + ""});
                    BeanUtil.setFieldValue(entity, (Field)field, (Object)items.entity(join.itemClass));
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                    continue;
                }
                log.error("[check Many2ManyDependency query][result:fail][msg:{}]", (Object)e.toString());
            }
        }
    }

    protected <T> void checkOne2ManyDependencyQuery(JDBCRuntime runtime, EntitySet<T> set, int dependency) {
        if (set.size() == 0 || dependency <= 0) {
            return;
        }
        --dependency;
        Class<?> clazz = set.get(0).getClass();
        Column pc = EntityAdapterProxy.primaryKey(clazz);
        String pk = null;
        if (null != pc) {
            pk = pc.getName();
        }
        List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"OneToMany"});
        Compare compare = ThreadConfig.check(runtime.getKey()).ENTITY_FIELD_SELECT_DEPENDENCY_COMPARE();
        for (Field field : fields) {
            try {
                OneToMany join = PersistenceAdapter.oneToMany(field);
                if (Compare.EQUAL == compare || set.size() == 1) {
                    for (Object entity : set) {
                        Object pv = EntityAdapterProxy.primaryValue(entity).get(pk.toUpperCase());
                        Map primaryValueMap = EntityAdapterProxy.primaryValue(entity);
                        ArrayList params = new ArrayList();
                        params.add(primaryValueMap.get(pk.toUpperCase()));
                        EntitySet<T> dependencys = this.querys(false, join.dependencyClass, new DefaultConfigStore(new String[0]).and(join.joinColumn, pv), new String[0]);
                        BeanUtil.setFieldValue(entity, (Field)field, dependencys);
                    }
                    continue;
                }
                if (Compare.IN != compare) continue;
                ArrayList pvs = new ArrayList();
                HashMap idmap = new HashMap();
                for (Object entity : set) {
                    Map primaryValueMap = EntityAdapterProxy.primaryValue(entity);
                    Object pv = primaryValueMap.get(pk.toUpperCase());
                    pvs.add(pv);
                    idmap.put(entity, pv);
                }
                DefaultConfigStore conditions = new DefaultConfigStore(new String[0]);
                conditions.and(join.joinColumn, pvs);
                EntitySet<T> alls = this.querys(false, join.dependencyClass, (ConfigStore)conditions, new String[0]);
                for (Object entity : set) {
                    EntitySet items = alls.gets(join.joinField, idmap.get(entity));
                    BeanUtil.setFieldValue(entity, (Field)field, (Object)items);
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                    continue;
                }
                log.error("[check One2ManyDependency query][result:fail][msg:{}]", (Object)e.toString());
            }
        }
    }

    @Override
    public int execute(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.execute(true, prepare, configs, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execute(boolean recover, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        int result = -1;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        Run run = adapter.buildExecuteRun(prepare, configs, conditions);
        if (!run.isValid()) {
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][RunPrepare:" + ConfigParser.createSQLSign(false, false, prepare.getTable(), configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + this.runtime().datasource() + "]");
            }
            return -1;
        }
        String txt = run.getFinalExecute();
        List<Object> values = run.getValues();
        long fr = System.currentTimeMillis();
        String random = "";
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            random = this.random();
            log.info("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, txt, this.paramLogFormat(values)});
        }
        try {
            boolean listenerResult = true;
            if (null != dmListener) {
                listenerResult = dmListener.beforeExecute(run);
            }
            if (listenerResult) {
                result = null != values && values.size() > 0 ? runtime.getTemplate().update(txt, values.toArray()) : runtime.getTemplate().update(txt);
                Long millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check(runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[SLOW SQL][action:execute][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, txt, this.paramLogFormat(values)});
                    if (null != dmListener) {
                        dmListener.slow("execute", run, txt, values, null, millis);
                    }
                }
                if (null != dmListener) {
                    dmListener.afterExecute(run, result, (long)millis);
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((int)result, (int)34)});
                }
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                throw e;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"SQL\u6267\u884c\u5f02\u5e38:", (int)33) + e.toString(), prepare, this.paramLogFormat(values)});
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return result;
    }

    @Override
    public int execute(RunPrepare prepare, String ... conditions) {
        return this.execute(prepare, (ConfigStore)null, conditions);
    }

    @Override
    public boolean execute(Procedure procedure) {
        return this.execute(true, procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean execute(boolean recover, final Procedure procedure) {
        boolean result = false;
        List list = new ArrayList();
        final List inputs = procedure.getInputs();
        final List outputs = procedure.getOutputs();
        long fr = System.currentTimeMillis();
        String random = "";
        String sql = " {";
        boolean returnIndex = false;
        if (procedure.hasReturn()) {
            sql = sql + "? = ";
            returnIndex = true;
        }
        sql = sql + "call " + procedure.getName() + "(";
        final int sizeIn = inputs.size();
        final int sizeOut = outputs.size();
        int size = sizeIn + sizeOut;
        for (int i = 0; i < size; ++i) {
            sql = sql + "?";
            if (i >= size - 1) continue;
            sql = sql + ",";
        }
        sql = sql + ")}";
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            random = this.random();
            log.info("{}[sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, sql, this.paramLogFormat(inputs), this.paramLogFormat(outputs)});
        }
        try {
            JDBCRuntime runtime = this.runtime();
            boolean listenerResult = true;
            if (null != dmListener) {
                listenerResult = dmListener.beforeExecute(procedure);
            }
            if (listenerResult) {
                list = (List)runtime.getTemplate().execute(sql, (CallableStatementCallback)new CallableStatementCallback<Object>(){

                    public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                        Parameter param;
                        int i;
                        ArrayList<Object> result = new ArrayList<Object>();
                        int returnIndex = 0;
                        if (procedure.hasReturn()) {
                            returnIndex = 1;
                            cs.registerOutParameter(1, 12);
                        }
                        for (i = 1; i <= sizeIn; ++i) {
                            param = (Parameter)inputs.get(i - 1);
                            Object value = param.getValue();
                            if (null == value || "NULL".equalsIgnoreCase(value.toString())) {
                                value = null;
                            }
                            cs.setObject(i + returnIndex, value, (int)param.getType());
                        }
                        for (i = 1; i <= sizeOut; ++i) {
                            param = (Parameter)outputs.get(i - 1);
                            if (null == param.getValue()) {
                                cs.registerOutParameter(i + sizeIn + returnIndex, (int)param.getType());
                                continue;
                            }
                            cs.setObject(i + sizeIn + returnIndex, param.getValue(), (int)param.getType());
                        }
                        cs.execute();
                        if (procedure.hasReturn()) {
                            result.add(cs.getObject(1));
                        }
                        if (sizeOut > 0) {
                            for (i = 1; i <= sizeOut; ++i) {
                                Object output = cs.getObject(sizeIn + returnIndex + i);
                                result.add(output);
                            }
                        }
                        return result;
                    }
                });
                procedure.setResult(list);
                result = true;
                Long millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check(runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
                    log.warn("{}[SLOW SQL][action:procedure][millis:{}ms][sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, millis, sql, this.paramLogFormat(inputs), this.paramLogFormat(list)});
                    if (null != dmListener) {
                        dmListener.slow("procedure", null, sql, inputs, list, millis);
                    }
                }
                if (null != dmListener) {
                    dmListener.afterExecute(procedure, result, (long)millis);
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[\u6267\u884c\u8017\u65f6:{}ms]\n[output param:{}]", new Object[]{random, millis, list});
                }
            }
        }
        catch (Exception e) {
            result = false;
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                SQLUpdateException ex = new SQLUpdateException("execute\u5f02\u5e38:" + e.toString(), e);
                ex.setSql(sql);
                throw ex;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, LogUtil.format((String)"\u5b58\u50a8\u8fc7\u7a0b\u6267\u884c\u5f02\u5e38:", (int)33) + e.toString(), sql, this.paramLogFormat(inputs), this.paramLogFormat(outputs)});
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return result;
    }

    @Override
    public DataSet querys(Procedure procedure, PageNavi navi) {
        return this.querys(true, procedure, navi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSet querys(boolean recover, final Procedure procedure, final PageNavi navi) {
        final List inputs = procedure.getInputs();
        final List outputs = procedure.getOutputs();
        long fr = System.currentTimeMillis();
        String random = "";
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            random = this.random();
            log.info("{}[sql:\n{}\n][input param:{}]\n[output param:{}]", new Object[]{random, procedure.getName(), this.paramLogFormat(inputs), this.paramLogFormat(outputs)});
        }
        final String rdm = random;
        DataSet set = null;
        try {
            final JDBCRuntime runtime = this.runtime();
            if (null != dmListener) {
                dmListener.beforeQuery(procedure);
            }
            set = (DataSet)runtime.getTemplate().execute(new CallableStatementCreator(){

                public CallableStatement createCallableStatement(Connection conn) throws SQLException {
                    Parameter param;
                    int i;
                    String sql = "{call " + procedure.getName() + "(";
                    int sizeIn = inputs.size();
                    int sizeOut = outputs.size();
                    int size = sizeIn + sizeOut;
                    for (int i2 = 0; i2 < size; ++i2) {
                        sql = sql + "?";
                        if (i2 >= size - 1) continue;
                        sql = sql + ",";
                    }
                    sql = sql + ")}";
                    CallableStatement cs = conn.prepareCall(sql);
                    for (i = 1; i <= sizeIn; ++i) {
                        param = (Parameter)inputs.get(i - 1);
                        Object value = param.getValue();
                        if (null == value || "NULL".equalsIgnoreCase(value.toString())) {
                            value = null;
                        }
                        cs.setObject(i, value, (int)param.getType());
                    }
                    for (i = 1; i <= sizeOut; ++i) {
                        param = (Parameter)outputs.get(i - 1);
                        if (null == param.getValue()) {
                            cs.registerOutParameter(i + sizeIn, (int)param.getType());
                            continue;
                        }
                        cs.setObject(i, param.getValue(), (int)param.getType());
                    }
                    return cs;
                }
            }, (CallableStatementCallback)new CallableStatementCallback<Object>(){

                public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                    ResultSet rs = cs.executeQuery();
                    DataSet set = new DataSet();
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int cols = rsmd.getColumnCount();
                    for (int i = 1; i <= cols; ++i) {
                        set.addHead(rsmd.getColumnLabel(i));
                    }
                    long mid = System.currentTimeMillis();
                    int index = 0;
                    int first = -1;
                    int last = -1;
                    if (null != navi) {
                        first = navi.getFirstRow();
                        last = navi.getLastRow();
                    }
                    while (rs.next()) {
                        if (first == -1 || index >= first && index <= last) {
                            DataRow row = new DataRow();
                            for (int i = 1; i <= cols; ++i) {
                                row.put(rsmd.getColumnLabel(i), rs.getObject(i));
                            }
                            set.addRow(row);
                        }
                        if (first == -1 || ++index <= last && (first != 0 || last != 0)) continue;
                    }
                    if (null != navi) {
                        navi.setTotalRow(index);
                        set.setNavi(navi);
                    }
                    set.setDatalink(runtime.datasource());
                    if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                        log.info("{}[\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{rdm, System.currentTimeMillis() - mid, set.size()});
                    }
                    return set;
                }
            });
            Long millis = System.currentTimeMillis() - fr;
            boolean slow = false;
            long SLOW_SQL_MILLIS = ThreadConfig.check(runtime.getKey()).SLOW_SQL_MILLIS();
            if (SLOW_SQL_MILLIS > 0L && millis > SLOW_SQL_MILLIS) {
                log.warn("{}[SLOW SQL][action:procedure][millis:{}ms][sql:\n{}\n][input param:{}]\n[output param:{}]", new Object[]{random, millis, procedure.getName(), this.paramLogFormat(inputs), this.paramLogFormat(outputs)});
                if (null != dmListener) {
                    dmListener.slow("procedure", null, procedure.getName(), inputs, outputs, millis);
                }
            }
            if (null != dmListener) {
                dmListener.afterQuery(procedure, set, (long)millis);
            }
            if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)millis);
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38:" + e.toString(), e);
                throw ex;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, LogUtil.format((String)"\u5b58\u50a8\u8fc7\u7a0b\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), procedure.getName(), this.paramLogFormat(inputs), this.paramLogFormat(outputs)});
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return set;
    }

    @Override
    public <T> int deletes(String table, String key, Collection<T> values) {
        table = DataSourceHolder.parseDataSource(table, null);
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        Run run = adapter.buildDeleteRun(table, key, values);
        int result = this.exeDelete(true, runtime, run);
        return result;
    }

    @Override
    public int deletes(String table, String key, Object ... values) {
        return this.deletes(true, table, key, values);
    }

    protected int deletes(boolean recover, String table, String key, Object ... values) {
        table = DataSourceHolder.parseDataSource(table, null);
        ArrayList<Object> list = new ArrayList<Object>();
        if (null != values) {
            for (Object value : values) {
                if (value instanceof Collection) {
                    list.addAll((Collection)value);
                    continue;
                }
                list.add(value);
            }
        }
        boolean exe = true;
        if (null != dmListener) {
            exe = dmListener.beforeBuildDelete(table, key, list);
        }
        if (!exe) {
            return -1;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        Run run = adapter.buildDeleteRun(table, key, list);
        int result = this.exeDelete(recover, runtime, run);
        return result;
    }

    @Override
    public int delete(String dest, Object obj, String ... columns) {
        dest = DataSourceHolder.parseDataSource(dest, obj);
        int size = 0;
        if (null != obj) {
            if (obj instanceof Collection) {
                Collection list = (Collection)obj;
                for (Object item : list) {
                    int qty = this.delete(dest, item, columns);
                    if (qty <= 0) continue;
                    size += qty;
                }
                if (log.isInfoEnabled()) {
                    log.info("[delete Collection][\u5f71\u54cd\u884c\u6570:{}]", (Object)LogUtil.format((int)size, (int)34));
                }
            } else {
                JDBCAdapter adapter;
                Run run;
                boolean exe = true;
                if (null != dmListener) {
                    exe = dmListener.beforeBuildDelete(dest, obj, columns);
                }
                if (!exe) {
                    return -1;
                }
                JDBCRuntime runtime = this.runtime();
                size = this.exeDelete(true, runtime, run = (adapter = runtime.getAdapter()).buildDeleteRun(dest, obj, columns));
                if (size > 0 && ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY > 0 && !(obj instanceof DataRow)) {
                    this.checkMany2ManyDependencyDelete(runtime, obj, ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY);
                    this.checkOne2ManyDependencyDelete(runtime, obj, ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY);
                }
            }
        }
        return size;
    }

    private int checkMany2ManyDependencyDelete(JDBCRuntime runtime, Object entity, int dependency) {
        int result = 0;
        if (dependency <= 0) {
            return result;
        }
        --dependency;
        Class<?> clazz = entity.getClass();
        Column pc = EntityAdapterProxy.primaryKey(clazz);
        String pk = null;
        if (null != pc) {
            pk = pc.getName();
        }
        List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"ManyToMany"});
        for (Field field : fields) {
            try {
                ManyToMany join = PersistenceAdapter.manyToMany(field);
                this.deletes(false, join.joinTable, join.joinColumn, EntityAdapterProxy.primaryValue((Object)entity).get(pk.toUpperCase()) + "");
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                    continue;
                }
                log.error("[check Many2ManyDependency delete][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        return result;
    }

    private int checkOne2ManyDependencyDelete(JDBCRuntime runtime, Object entity, int dependency) {
        int result = 0;
        if (dependency <= 0) {
            return result;
        }
        --dependency;
        Class<?> clazz = entity.getClass();
        Column pc = EntityAdapterProxy.primaryKey(clazz);
        String pk = null;
        if (null != pc) {
            pk = pc.getName();
        }
        List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"OneToMany"});
        for (Field field : fields) {
            try {
                OneToMany join = PersistenceAdapter.oneToMany(field);
                this.deletes(false, join.dependencyTable, join.joinColumn, EntityAdapterProxy.primaryValue((Object)entity).get(pk.toUpperCase()) + "");
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                    continue;
                }
                log.error("[check One2ManyDependency delete][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        return result;
    }

    @Override
    public int delete(String table, ConfigStore configs, String ... conditions) {
        table = DataSourceHolder.parseDataSource(table, null);
        boolean exe = true;
        if (null != dmListener) {
            exe = dmListener.beforeBuildDelete(table, configs, conditions);
        }
        if (!exe) {
            return -1;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        Run run = adapter.buildDeleteRun(table, configs, conditions);
        int result = this.exeDelete(true, runtime, run);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int exeDelete(boolean recover, JDBCRuntime runtime, Run run) {
        int result = 0;
        String sql = run.getFinalDelete();
        List<Object> values = run.getValues();
        long fr = System.currentTimeMillis();
        String random = "";
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            random = this.random();
            log.info("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, this.paramLogFormat(values)});
        }
        try {
            boolean listenerResult = true;
            if (null != dmListener) {
                listenerResult = dmListener.beforeDelete(run);
            }
            if (listenerResult) {
                result = null == values ? runtime.getTemplate().update(sql) : runtime.getTemplate().update(sql, values.toArray());
                Long millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ThreadConfig.check(runtime.getKey()).SLOW_SQL_MILLIS();
                if (SLOW_SQL_MILLIS > 0L) {
                    slow = true;
                    if (millis > SLOW_SQL_MILLIS) {
                        log.warn("{}[SLOW SQL][action:delete][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, sql, this.paramLogFormat(values)});
                        if (null != dmListener) {
                            dmListener.slow("delete", run, sql, values, null, millis);
                        }
                    }
                }
                if (null != dmListener) {
                    dmListener.afterDelete(run, result, millis);
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((int)result, (int)34)});
                }
            }
        }
        catch (Exception e) {
            result = 0;
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                SQLUpdateException ex = new SQLUpdateException("delete\u5f02\u5e38:" + e.toString(), e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u5220\u9664\u5f02\u5e38:", (int)33) + e.toString(), sql, this.paramLogFormat(values)});
            }
        }
        finally {
            if (recover && !this.isFix() && DataSourceHolder.isAutoRecover()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return result;
    }

    @Override
    public int truncate(String table) {
        table = DataSourceHolder.parseDataSource(table);
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String sql = adapter.buildTruncateSQL(table);
        DefaultTextPrepare prepare = new DefaultTextPrepare(sql);
        return this.execute((RunPrepare)prepare, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, Database> databases() {
        LinkedHashMap<String, Database> databases = new LinkedHashMap<String, Database>();
        DataSource ds = null;
        Connection con = null;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String random = this.random();
        try {
            long fr;
            block14: {
                fr = System.currentTimeMillis();
                ds = runtime.getTemplate().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                try {
                    List<String> sqls = adapter.buildQueryDatabaseRunSQL();
                    if (null != sqls) {
                        int idx = 0;
                        for (String sql : sqls) {
                            if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                            DataSet set = this.select(runtime, null, sql, null).toUpperKey();
                            databases = adapter.databases(idx++, true, databases, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block14;
                    log.warn("{}[databases][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[databases][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, databases.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            } else {
                log.error("[databases][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return databases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(boolean greedy, String catalog, String schema, String pattern, String types) {
        LinkedHashMap<Object, Table> tables = new LinkedHashMap();
        DataSource ds = null;
        Connection con = null;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String random = this.random();
        try {
            long fr;
            block36: {
                DataSet set;
                List<String> sqls;
                String[] tps;
                block35: {
                    fr = System.currentTimeMillis();
                    ds = runtime.getTemplate().getDataSource();
                    con = DataSourceUtils.getConnection((DataSource)ds);
                    Table search = new Table();
                    if (null == catalog || null == schema) {
                        Table tmp = new Table();
                        if (!greedy) {
                            adapter.checkSchema(con, tmp);
                        }
                        if (null == catalog) {
                            catalog = tmp.getCatalog();
                        }
                        if (null == schema) {
                            schema = tmp.getSchema();
                        }
                    }
                    search.setName(pattern);
                    search.setCatalog(catalog);
                    search.setSchema(schema);
                    tps = null;
                    if (null != types) {
                        tps = types.toUpperCase().trim().split(",");
                    }
                    DataRow table_map = CacheProxy.getTableMaps(runtime.datasource());
                    if (null != pattern) {
                        if (table_map.isEmpty()) {
                            LinkedHashMap<String, T> all = this.tables(greedy, catalog, schema, null, null);
                            if (!greedy) {
                                for (Table table : all.values()) {
                                    if (!(catalog + "_" + schema).equals(table.getCatalog() + "_" + table.getSchema())) continue;
                                    table_map.put(table.getName(greedy).toUpperCase(), (Object)table.getName(greedy));
                                }
                            }
                        }
                        pattern = table_map.containsKey(search.getName(greedy).toUpperCase()) ? table_map.getString(search.getName(greedy).toUpperCase()) : search.getName(greedy);
                    }
                    try {
                        sqls = adapter.buildQueryTableRunSQL(catalog, schema, pattern, types);
                        if (null != sqls) {
                            int idx = 0;
                            for (String sql : sqls) {
                                if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                                set = this.select(runtime, null, sql, null).toUpperKey();
                                tables = adapter.tables(idx++, true, catalog, schema, tables, set);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block35;
                        log.warn("{}[tables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                    }
                }
                if (null == tables || tables.size() == 0) {
                    try {
                        LinkedHashMap jdbcTables = adapter.tables(true, null, con.getMetaData(), catalog, schema, pattern, tps);
                        for (String key : jdbcTables.keySet()) {
                            Table item;
                            if (tables.containsKey(key.toUpperCase()) || null == (item = (Table)jdbcTables.get(key)) || !greedy && !(catalog + "_" + schema).equalsIgnoreCase(item.getCatalog() + "_" + item.getSchema())) continue;
                            tables.put(key.toUpperCase(), item);
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        log.warn("{}[tables][][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636ejdbc\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                    }
                }
                try {
                    sqls = adapter.buildQueryTableCommentRunSQL(catalog, schema, null, types);
                    if (null != sqls) {
                        int idx = 0;
                        for (String sql : sqls) {
                            if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                            set = this.select(runtime, null, sql, null).toUpperKey();
                            tables = adapter.comments(idx++, true, catalog, schema, tables, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block36;
                    log.info("{}[tables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[tables][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, pattern, types, tables.size(), System.currentTimeMillis() - fr});
            }
            if (BasicUtil.isNotEmpty((Object)pattern)) {
                LinkedHashMap<String, Table> tmps = new LinkedHashMap<String, Table>();
                List keys = BeanUtil.getMapKeys(tables);
                for (String key : keys) {
                    Table item = (Table)tables.get(key);
                    String name = item.getName(greedy);
                    if (!RegularUtil.match((String)name, (String)pattern)) continue;
                    tmps.put(name.toUpperCase(), item);
                }
                tables = tmps;
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            } else {
                log.error("[tables][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return tables;
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(boolean greedy, String schema, String name, String types) {
        return this.tables(greedy, null, schema, name, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(boolean greedy, String name, String types) {
        return this.tables(greedy, null, null, name, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(boolean greedy, String types) {
        return this.tables(greedy, null, null, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(boolean greedy) {
        return this.tables(greedy, null, null, null, "TABLE");
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(String catalog, String schema, String pattern, String types) {
        return this.tables(false, catalog, schema, pattern, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(String schema, String name, String types) {
        return this.tables(false, null, schema, name, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(String name, String types) {
        return this.tables(false, null, null, name, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(String types) {
        return this.tables(false, null, null, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables() {
        return this.tables(false, null, null, null, "TABLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends View> LinkedHashMap<String, T> views(boolean greedy, String catalog, String schema, String pattern, String types) {
        LinkedHashMap<Object, Object> views = new LinkedHashMap();
        DataSource ds = null;
        Connection con = null;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String random = this.random();
        try {
            LinkedHashMap<Object, Object> tmps;
            String[] tps;
            long fr;
            block29: {
                fr = System.currentTimeMillis();
                ds = runtime.getTemplate().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                View search = new View();
                if (null == catalog || null == schema) {
                    View tmp = new View();
                    if (!greedy) {
                        adapter.checkSchema(con, (Table)tmp);
                    }
                    if (null == catalog) {
                        catalog = tmp.getCatalog();
                    }
                    if (null == schema) {
                        schema = tmp.getSchema();
                    }
                }
                search.setName(pattern);
                search.setCatalog(catalog);
                search.setSchema(schema);
                tps = null;
                tps = null != types ? types.toUpperCase().trim().split(",") : new String[]{"VIEW"};
                DataRow view_map = CacheProxy.getViewMaps(runtime.datasource());
                if (null != pattern) {
                    if (view_map.isEmpty()) {
                        LinkedHashMap<String, T> all = this.views(greedy, catalog, schema, null, types);
                        if (!greedy) {
                            for (View view : all.values()) {
                                if (!(catalog + "_" + schema).equals(view.getCatalog() + "_" + view.getSchema())) continue;
                                view_map.put(view.getName(greedy).toUpperCase(), (Object)view.getName(greedy));
                            }
                        }
                    }
                    pattern = view_map.containsKey(search.getName(greedy).toUpperCase()) ? view_map.getString(search.getName(greedy).toUpperCase()) : search.getName(greedy);
                }
                try {
                    List<String> sqls = adapter.buildQueryViewRunSQL(catalog, schema, pattern, types);
                    if (null != sqls) {
                        int idx = 0;
                        for (String sql : sqls) {
                            if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                            DataSet set = this.select(runtime, null, sql, null).toUpperKey();
                            views = adapter.views(idx++, true, catalog, schema, views, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block29;
                    log.warn("{}[views][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            if (null == views || views.size() == 0) {
                try {
                    tmps = adapter.views(true, null, con.getMetaData(), catalog, schema, pattern, tps);
                    for (String string : tmps.keySet()) {
                        View item;
                        if (views.containsKey(string.toUpperCase()) || null == (item = (View)tmps.get(string)) || !greedy && !(catalog + "_" + schema).equalsIgnoreCase(item.getCatalog() + "_" + item.getSchema())) continue;
                        views.put(string.toUpperCase(), item);
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    log.warn("{}[views][][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636ejdbc\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[views][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, pattern, types, views.size(), System.currentTimeMillis() - fr});
            }
            if (BasicUtil.isNotEmpty((Object)pattern)) {
                tmps = new LinkedHashMap();
                List keys = BeanUtil.getMapKeys(views);
                for (String key : keys) {
                    View item = (View)views.get(key);
                    String name = item.getName(greedy);
                    if (!RegularUtil.match((String)name, (String)pattern)) continue;
                    tmps.put(name.toUpperCase(), item);
                }
                views = tmps;
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            } else {
                log.error("[views][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return views;
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(boolean greedy, String schema, String name, String types) {
        return this.views(greedy, null, schema, name, types);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(boolean greedy, String name, String types) {
        return this.views(greedy, null, null, name, types);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(boolean greedy, String types) {
        return this.views(greedy, null, null, types);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(boolean greedy) {
        return this.views(greedy, null, null, null, "TABLE");
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(String catalog, String schema, String pattern, String types) {
        return this.views(false, catalog, schema, pattern, types);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(String schema, String name, String types) {
        return this.views(false, null, schema, name, types);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(String name, String types) {
        return this.views(false, null, null, name, types);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(String types) {
        return this.views(false, null, null, types);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views() {
        return this.views(false, null, null, null, "TABLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean greedy, String catalog, String schema, String pattern, String types) {
        LinkedHashMap<Object, MasterTable> tables = new LinkedHashMap();
        DataSource ds = null;
        Connection con = null;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String random = this.random();
        try {
            String[] tps;
            long fr;
            block28: {
                fr = System.currentTimeMillis();
                ds = runtime.getTemplate().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                if (null == catalog || null == schema) {
                    Table tmp = new Table();
                    if (!greedy) {
                        adapter.checkSchema(con, tmp);
                    }
                    if (null == catalog) {
                        catalog = tmp.getCatalog();
                    }
                    if (null == schema) {
                        schema = tmp.getSchema();
                    }
                }
                tps = null;
                if (null != types) {
                    tps = types.toUpperCase().trim().split(",");
                }
                DataRow table_map = CacheProxy.getTableMaps(runtime.datasource());
                if (null != pattern) {
                    if (table_map.isEmpty()) {
                        LinkedHashMap<String, T> all = this.mtables(catalog, schema, null, types);
                        for (Table table : all.values()) {
                            table_map.put(table.getName().toUpperCase(), (Object)table.getName());
                        }
                    }
                    if (table_map.containsKey(pattern.toUpperCase())) {
                        pattern = table_map.getString(pattern.toUpperCase());
                    }
                }
                try {
                    List<String> sqls = adapter.buildQueryMasterTableRunSQL(catalog, schema, pattern, types);
                    if (null != sqls) {
                        int idx = 0;
                        for (String sql : sqls) {
                            if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                            DataSet set = this.select(runtime, null, sql, null).toUpperKey();
                            tables = adapter.mtables(idx++, true, catalog, schema, tables, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block28;
                    log.warn("{}[stables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            if (null == tables || tables.size() == 0) {
                try {
                    LinkedHashMap tmps = adapter.mtables(true, null, con.getMetaData(), catalog, schema, pattern, tps);
                    for (String key : tmps.keySet()) {
                        MasterTable item;
                        if (tables.containsKey(key.toUpperCase()) || null == (item = (MasterTable)tmps.get(key)) || !greedy && !(catalog + "_" + schema).equalsIgnoreCase(item.getCatalog() + "_" + item.getSchema())) continue;
                        tables.put(key.toUpperCase(), item);
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    log.warn("{}[stables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636ejdbc\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[stables][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, pattern, types, tables.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            } else {
                log.error("[mtables][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return tables;
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean greedy, String schema, String name, String types) {
        return this.mtables(greedy, null, schema, name, types);
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean greedy, String name, String types) {
        return this.mtables(greedy, null, null, name, types);
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean greedy, String types) {
        return this.mtables(greedy, null, types);
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean greedy) {
        return this.mtables(greedy, "STABLE");
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(String catalog, String schema, String pattern, String types) {
        return this.mtables(false, catalog, schema, pattern, types);
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(String schema, String name, String types) {
        return this.mtables(false, null, schema, name, types);
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(String name, String types) {
        return this.mtables(false, null, null, name, types);
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(String types) {
        return this.mtables(false, null, types);
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables() {
        return this.mtables(false, "STABLE");
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, String catalog, String schema, String master, String name) {
        MasterTable mtable = new MasterTable(catalog, schema, master);
        return this.ptables(greedy, mtable, null, name);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, String schema, String master, String name) {
        return this.ptables(greedy, null, schema, master, name);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, String master, String name) {
        return this.ptables(greedy, null, null, master, name);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, String master) {
        return this.ptables(greedy, null, null, master, null);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, MasterTable master) {
        return this.ptables(greedy, master, null);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, MasterTable master, Map<String, Object> tags) {
        return this.ptables(greedy, master, tags, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, MasterTable master, Map<String, Object> tags, String name) {
        LinkedHashMap tables = new LinkedHashMap();
        DataSource ds = null;
        Connection con = null;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String random = this.random();
        try {
            long fr;
            block14: {
                fr = System.currentTimeMillis();
                ds = runtime.getTemplate().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                try {
                    List<String> sqls = adapter.buildQueryPartitionTableRunSQL(master, tags, name);
                    if (null != sqls) {
                        int idx = 0;
                        int total = sqls.size();
                        for (String sql : sqls) {
                            if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                            DataSet set = this.select(runtime, null, sql, null).toUpperKey();
                            tables = adapter.ptables(total, idx++, true, master, master.getCatalog(), master.getSchema(), tables, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block14;
                    log.warn("{}[tables][{}][stable:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), master.getName(), e.toString()});
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[tables][stable:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, master.getName(), tables.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            } else {
                log.error("[ptables][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return tables;
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(String catalog, String schema, String master, String name) {
        MasterTable mtable = new MasterTable(catalog, schema, master);
        return this.ptables(false, mtable, null, name);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(String schema, String master, String name) {
        return this.ptables(false, null, schema, master, name);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(String master, String name) {
        return this.ptables(false, null, null, master, name);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(String master) {
        return this.ptables(false, null, null, master, null);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(MasterTable master) {
        return this.ptables(false, master, null);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(MasterTable master, Map<String, Object> tags) {
        return this.ptables(false, master, tags, null);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(MasterTable master, Map<String, Object> tags, String name) {
        return this.ptables(false, master, tags, name);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(boolean greedy, Table table) {
        return this.columns(this.runtime(), greedy, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Column> LinkedHashMap<String, T> columns(JDBCRuntime runtime, boolean greedy, Table table) {
        LinkedHashMap columns;
        block34: {
            if (null == table) return new LinkedHashMap();
            if (BasicUtil.isEmpty((Object)table.getName())) {
                return new LinkedHashMap();
            }
            columns = CacheProxy.columns(runtime.getKey(), table.getName());
            if (null != columns && !columns.isEmpty()) {
                return columns;
            }
            long fr = System.currentTimeMillis();
            DataSource ds = null;
            Connection con = null;
            String random = null;
            DatabaseMetaData metadata = null;
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                random = this.random();
            }
            try {
                List<String> sqls;
                int qty_jdbc;
                int qty_metadata;
                int qty_dialect;
                String schema;
                String catalog;
                JDBCAdapter adapter;
                block31: {
                    adapter = runtime.getAdapter();
                    if (!greedy) {
                        this.checkSchema(runtime, table);
                    }
                    catalog = table.getCatalog();
                    schema = table.getSchema();
                    try {
                        ds = runtime.getTemplate().getDataSource();
                        con = DataSourceUtils.getConnection((DataSource)ds);
                        metadata = con.getMetaData();
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        log.warn("[metadata][resutl:fail][msg:{}]", (Object)e.toString());
                    }
                    qty_dialect = 0;
                    qty_metadata = 0;
                    qty_jdbc = 0;
                    try {
                        sqls = adapter.buildQueryColumnRunSQL(table, false);
                        if (null != sqls) {
                            int idx = 0;
                            for (String sql : sqls) {
                                if (BasicUtil.isNotEmpty((Object)sql)) {
                                    DataSet set = this.select(true, runtime, null, sql, null);
                                    columns = adapter.columns(idx, true, table, columns, set);
                                }
                                ++idx;
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block31;
                        log.warn("{}[columns][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                    }
                }
                qty_dialect = columns.size();
                if (columns.size() == 0) {
                    block32: {
                        try {
                            sqls = adapter.buildQueryColumnRunSQL(table, true);
                            if (null != sqls) {
                                for (String sql : sqls) {
                                    if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                                    SqlRowSet set = runtime.getTemplate().queryForRowSet(sql);
                                    columns = adapter.columns(true, columns, table, set);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                e.printStackTrace();
                            }
                            if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block32;
                            log.warn("{}[columns][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636emetadata\u89e3\u6790\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                        }
                    }
                    qty_metadata = columns.size() - qty_dialect;
                }
                if (columns.size() == 0) {
                    block33: {
                        try {
                            columns = adapter.columns(true, columns, metadata, table, null);
                        }
                        catch (Exception e) {
                            if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block33;
                            e.printStackTrace();
                        }
                    }
                    qty_jdbc = columns.size() - qty_metadata - qty_dialect;
                }
                if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[columns][catalog:{}][schema:{}][table:{}][total:{}][\u6839\u636emetadata\u89e3\u6790:{}][\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2:{}][\u6839\u636ejdbc\u63a5\u53e3\u8865\u5145:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, table, columns.size(), qty_metadata, qty_dialect, qty_jdbc, System.currentTimeMillis() - fr});
                }
                if (DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) break block34;
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                    break block34;
                } else {
                    log.error("[columns][result:fail][table:{}][msg:{}]", new Object[]{random, table, e.toString()});
                }
                break block34;
            }
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            break block34;
            finally {
                if (!DataSourceUtils.isConnectionTransactional(con, ds)) {
                    DataSourceUtils.releaseConnection(con, ds);
                }
            }
        }
        CacheProxy.columns(runtime.getKey(), table.getName(), columns);
        return columns;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(boolean greedy, String table) {
        return this.columns(greedy, null, null, table);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(boolean greedy, String catalog, String schema, String table) {
        Table tab = new Table(catalog, schema, table);
        return this.columns(greedy, tab);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(Table table) {
        return this.columns(false, table);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(String table) {
        return this.columns(false, null, null, table);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(String catalog, String schema, String table) {
        Table tab = new Table(catalog, schema, table);
        return this.columns(false, tab);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(boolean greedy, Table table) {
        return this.tags(this.runtime(), greedy, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Tag> LinkedHashMap<String, T> tags(JDBCRuntime runtime, boolean greedy, Table table) {
        LinkedHashMap tags;
        block33: {
            if (null == table) return new LinkedHashMap();
            if (BasicUtil.isEmpty((Object)table.getName())) {
                return new LinkedHashMap();
            }
            tags = CacheProxy.tags(runtime.getKey(), table.getName());
            if (null != tags && !tags.isEmpty()) {
                return tags;
            }
            long fr = System.currentTimeMillis();
            DataSource ds = null;
            Connection con = null;
            String random = null;
            DatabaseMetaData metadata = null;
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                random = this.random();
            }
            try {
                String schema;
                String catalog;
                block32: {
                    JDBCAdapter adapter;
                    block31: {
                        List<String> sqls;
                        block30: {
                            adapter = runtime.getAdapter();
                            if (!greedy) {
                                this.checkSchema(runtime, table);
                            }
                            catalog = table.getCatalog();
                            schema = table.getSchema();
                            try {
                                ds = runtime.getTemplate().getDataSource();
                                con = DataSourceUtils.getConnection((DataSource)ds);
                                metadata = con.getMetaData();
                            }
                            catch (Exception e) {
                                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                    e.printStackTrace();
                                }
                                log.warn("[][result:fail][msg:{}]", (Object)e.toString());
                            }
                            try {
                                sqls = adapter.buildQueryTagRunSQL(table, false);
                                if (null != sqls) {
                                    int idx = 0;
                                    for (String sql : sqls) {
                                        if (BasicUtil.isNotEmpty((Object)sql)) {
                                            DataSet set = this.select(runtime, null, sql, null).toUpperKey();
                                            tags = adapter.tags(idx, true, table, tags, set);
                                        }
                                        ++idx;
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                    e.printStackTrace();
                                }
                                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block30;
                                log.warn("{}[tags][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                            }
                        }
                        if (null == tags || tags.size() == 0) {
                            try {
                                sqls = adapter.buildQueryTagRunSQL(table, true);
                                if (null != sqls) {
                                    for (String sql : sqls) {
                                        if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                                        SqlRowSet set = runtime.getTemplate().queryForRowSet(sql);
                                        tags = adapter.tags(true, table, tags, set);
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                    e.printStackTrace();
                                }
                                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block31;
                                log.warn("{}[tags][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636emetadata\u89e3\u6790\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                            }
                        }
                    }
                    if (null == tags || tags.size() == 0) {
                        try {
                            tags = adapter.tags(false, tags, metadata, table, null);
                        }
                        catch (Exception e) {
                            if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block32;
                            e.printStackTrace();
                        }
                    }
                }
                if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                    log.info("{}[tags][catalog:{}][schema:{}][table:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, table, System.currentTimeMillis() - fr});
                }
                if (DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) break block33;
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                break block33;
            }
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            break block33;
            finally {
                if (!DataSourceUtils.isConnectionTransactional(con, ds)) {
                    DataSourceUtils.releaseConnection(con, ds);
                }
            }
        }
        CacheProxy.tags(runtime.getKey(), table.getName(), tags);
        return tags;
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(boolean greedy, String table) {
        Table tab = new Table();
        tab.setName(table);
        return this.tags(greedy, tab);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(boolean greedy, String catalog, String schema, String table) {
        Table tab = new Table();
        tab.setCatalog(catalog);
        tab.setSchema(schema);
        tab.setName(table);
        return this.tags(greedy, tab);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(Table table) {
        return this.tags(false, table);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(String table) {
        return this.tags(false, table);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(String catalog, String schema, String table) {
        return this.tags(false, catalog, schema, table);
    }

    @Override
    public PrimaryKey primary(boolean greedy, Table table) {
        PrimaryKey primary;
        block8: {
            primary = null;
            JDBCRuntime runtime = this.runtime();
            JDBCAdapter adapter = runtime.getAdapter();
            if (!greedy) {
                this.checkSchema(runtime, table);
            }
            String tab = table.getName();
            String catalog = table.getCatalog();
            String schema = table.getSchema();
            Object ds = null;
            String random = null;
            Object metadata = null;
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                random = this.random();
            }
            try {
                List<String> sqls = adapter.buildQueryPrimaryRunSQL(table);
                if (null != sqls) {
                    int idx = 0;
                    for (String sql : sqls) {
                        DataSet set;
                        if (BasicUtil.isNotEmpty((Object)sql) && null != (primary = adapter.primary(idx, table, set = this.select(runtime, null, sql, null).toUpperKey()))) {
                            primary.setTable(table);
                        }
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block8;
                log.warn("{}[primary][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
            }
        }
        return primary;
    }

    @Override
    public PrimaryKey primary(boolean greedy, String table) {
        Table tab = new Table();
        tab.setName(table);
        return this.primary(greedy, tab);
    }

    @Override
    public PrimaryKey primary(boolean greedy, String catalog, String schema, String table) {
        Table tab = new Table();
        tab.setCatalog(catalog);
        tab.setSchema(schema);
        tab.setName(table);
        return this.primary(greedy, tab);
    }

    @Override
    public PrimaryKey primary(Table table) {
        return this.primary(false, table);
    }

    @Override
    public PrimaryKey primary(String table) {
        return this.primary(false, table);
    }

    @Override
    public PrimaryKey primary(String catalog, String schema, String table) {
        return this.primary(false, catalog, schema, table);
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(boolean greedy, Table table) {
        LinkedHashMap foreigns;
        block6: {
            foreigns = new LinkedHashMap();
            JDBCRuntime runtime = this.runtime();
            JDBCAdapter adapter = runtime.getAdapter();
            if (!greedy) {
                this.checkSchema(runtime, table);
            }
            try {
                List<String> sqls = adapter.buildQueryForeignsRunSQL(table);
                if (null != sqls) {
                    int idx = 0;
                    for (String sql : sqls) {
                        if (BasicUtil.isNotEmpty((Object)sql)) {
                            DataSet set = this.select(runtime, null, sql, null).toUpperKey();
                            foreigns = adapter.foreigns(idx, table, foreigns, set);
                        }
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block6;
                e.printStackTrace();
            }
        }
        return foreigns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(boolean greedy, Table table, String name) {
        List<String> sqls;
        LinkedHashMap<String, Object> indexs = null;
        if (null == table) {
            table = new Table();
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        if (!greedy) {
            this.checkSchema(runtime, table);
        }
        if (null != table.getName()) {
            DataSource ds = null;
            Connection con = null;
            try {
                ds = runtime.getTemplate().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                indexs = adapter.indexs(true, indexs, con.getMetaData(), table, false, false);
                table.setIndexs(indexs);
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
            }
            finally {
                if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                    DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
                }
            }
            if (BasicUtil.isNotEmpty((Object)name)) {
                Index index = (Index)indexs.get(name.toUpperCase());
                indexs = new LinkedHashMap();
                indexs.put(name.toUpperCase(), index);
            }
        }
        if (null != (sqls = adapter.buildQueryIndexRunSQL(table, name))) {
            int idx = 0;
            for (String sql : sqls) {
                block17: {
                    if (BasicUtil.isNotEmpty((Object)sql)) {
                        DataSet set = this.select(runtime, null, sql, null).toUpperKey();
                        try {
                            indexs = adapter.indexs(idx, true, table, indexs, set);
                        }
                        catch (Exception e) {
                            if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block17;
                            e.printStackTrace();
                        }
                    }
                }
                ++idx;
            }
        }
        return indexs;
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(boolean greedy, Table table) {
        return this.indexs(greedy, table, null);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(boolean greedy, String table, String name) {
        return this.indexs(greedy, new Table(table), name);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(boolean greedy, String table) {
        return this.indexs(greedy, new Table(table), null);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(boolean greedy, String catalog, String schema, String table) {
        return this.indexs(greedy, new Table(catalog, schema, table), null);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(Table table, String name) {
        return this.indexs(false, table, name);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(Table table) {
        return this.indexs(false, table);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(String table, String name) {
        return this.indexs(false, table, name);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(String table) {
        return this.indexs(false, table);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(String catalog, String schema, String table) {
        return this.indexs(false, catalog, schema, table);
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean greedy, Table table, String name) {
        return null;
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean greedy, Table table) {
        return this.constraints(greedy, table, null);
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean greedy, String table) {
        return this.constraints(greedy, new Table(table));
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean greedy, String table, String name) {
        return this.constraints(greedy, new Table(table), name);
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean greedy, String catalog, String schema, String table) {
        return this.constraints(greedy, new Table(catalog, schema, table));
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(Table table, String name) {
        return this.constraints(false, table, name);
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(Table table) {
        return this.constraints(false, table);
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(String table) {
        return this.constraints(false, new Table(table));
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(String table, String name) {
        return this.constraints(false, new Table(table), name);
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(String catalog, String schema, String table) {
        return this.constraints(false, new Table(catalog, schema, table));
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(boolean greedy, Table table, List<Trigger.EVENT> events) {
        List<String> sqls;
        LinkedHashMap triggers = new LinkedHashMap();
        if (null == table) {
            table = new Table();
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        if (!greedy) {
            this.checkSchema(runtime, table);
        }
        if (null != (sqls = adapter.buildQueryTriggerRunSQL(table, events))) {
            int idx = 0;
            for (String sql : sqls) {
                block7: {
                    if (BasicUtil.isNotEmpty((Object)sql)) {
                        DataSet set = this.select(runtime, null, sql, null).toUpperKey();
                        try {
                            triggers = adapter.triggers(idx, true, table, triggers, set);
                        }
                        catch (Exception e) {
                            if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block7;
                            e.printStackTrace();
                        }
                    }
                }
                ++idx;
            }
        }
        return triggers;
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(boolean greedy, String catalog, String schema, String name) {
        LinkedHashMap procedures = new LinkedHashMap();
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        List<String> sqls = adapter.buildQueryProcedureRunSQL(catalog, schema, name);
        if (null != sqls) {
            int idx = 0;
            for (String sql : sqls) {
                block5: {
                    if (BasicUtil.isNotEmpty((Object)sql)) {
                        DataSet set = this.select(runtime, null, sql, null).toUpperKey();
                        try {
                            procedures = adapter.procedures(idx, true, procedures, set);
                        }
                        catch (Exception e) {
                            if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block5;
                            e.printStackTrace();
                        }
                    }
                }
                ++idx;
            }
        }
        return procedures;
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(boolean greedy, String catalog, String schema, String name) {
        LinkedHashMap functions = new LinkedHashMap();
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        List<String> sqls = adapter.buildQueryFunctionRunSQL(catalog, schema, name);
        if (null != sqls) {
            int idx = 0;
            for (String sql : sqls) {
                block5: {
                    if (BasicUtil.isNotEmpty((Object)sql)) {
                        DataSet set = this.select(runtime, null, sql, null).toUpperKey();
                        try {
                            functions = adapter.functions(idx, true, functions, set);
                        }
                        catch (Exception e) {
                            if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block5;
                            e.printStackTrace();
                        }
                    }
                }
                ++idx;
            }
        }
        return functions;
    }

    @Override
    public boolean create(Table table) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeCreate(table);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, table);
        String random = this.random();
        long fr = System.currentTimeMillis();
        List<String> sqls = adapter.buildCreateRunSQL(table);
        boolean result = this.execute(runtime, random, "create table", sqls);
        if (sqls.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[create table][table:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), System.currentTimeMillis() - fr});
        }
        if (null != ddListener) {
            ddListener.afterCreate(table, result);
        }
        return result;
    }

    @Override
    public boolean alter(Table table) throws Exception {
        List<String> alters;
        boolean change_pk;
        String comment;
        boolean result = true;
        Table update = table.getUpdate();
        LinkedHashMap columns = table.getColumns();
        LinkedHashMap ucolumns = update.getColumns();
        String name = table.getName();
        String uname = update.getName();
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String random = this.random();
        long fr = System.currentTimeMillis();
        this.checkSchema(runtime, table);
        this.checkSchema(runtime, update);
        if (!name.equalsIgnoreCase(uname)) {
            result = this.rename(runtime, table, uname);
            table.setName(uname);
        }
        if (!(comment = update.getComment() + "").equals(table.getComment())) {
            String sql = adapter.buildChangeCommentRunSQL(update);
            result = this.execute(runtime, random, "alter table comment", sql) && result;
        }
        LinkedHashMap<String, Object> cols = new LinkedHashMap<String, Object>();
        for (Object ucolumn : ucolumns.values()) {
            Column column = (Column)columns.get(ucolumn.getName().toUpperCase());
            if (null != ucolumn.getUpdate()) {
                ucolumn = ucolumn.getUpdate();
            }
            if (null != column) {
                if (column.equals((Column)ucolumn)) continue;
                column.setTable(update);
                column.setUpdate((Column)ucolumn, false, false);
                column.setAction("alter");
                cols.put(column.getName().toUpperCase(), column);
                continue;
            }
            ucolumn.setTable(update);
            ucolumn.setAction("add");
            cols.put(ucolumn.getName().toUpperCase(), ucolumn);
        }
        ArrayList<String> deletes = new ArrayList<String>();
        for (Column column : ucolumns.values()) {
            if (!column.isDrop()) continue;
            deletes.add(column.getName().toUpperCase());
            column.setAction("drop");
            cols.put(column.getName().toUpperCase(), column);
        }
        if (table.isAutoDropColumn()) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || column.isDrop() || deletes.contains(column.getName().toUpperCase()) || "drop".equals(column.getAction()) || null != (ucolumn = (Column)ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                column.setAction("drop");
                cols.put(column.getName().toUpperCase(), column);
            }
        }
        PrimaryKey src_primary = this.primary(table);
        PrimaryKey cur_primary = update.getPrimaryKey();
        String src_define = "";
        String cur_define = "";
        if (null != src_primary) {
            src_define = BeanUtil.concat(src_primary.getColumns().values(), (String)"name", (String)",");
        }
        if (null != cur_primary) {
            cur_define = BeanUtil.concat(cur_primary.getColumns().values(), (String)"name", (String)",");
        }
        boolean bl = change_pk = !cur_define.equalsIgnoreCase(src_define);
        if (change_pk && null != src_primary) {
            this.drop(src_primary);
        }
        if (null != (alters = adapter.buildAlterRunSQL(table, cols.values())) && alters.size() > 0) {
            boolean bl2 = result = this.execute(runtime, random, "alter table column", alters) && result;
        }
        if (change_pk && null != cur_primary) {
            this.add(cur_primary);
        }
        CacheProxy.clear();
        return result;
    }

    @Override
    public boolean drop(Table table) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeDrop(table);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, table);
        String random = this.random();
        String sql = adapter.buildDropRunSQL(table);
        boolean result = this.execute(runtime, "drop table", sql);
        if (null != ddListener) {
            ddListener.afterDrop(table, result);
        }
        return result;
    }

    @Override
    public boolean rename(Table origin, String name) throws Exception {
        return this.rename(this.runtime(), origin, name);
    }

    public boolean rename(JDBCRuntime runtime, Table origin, String name) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeRename(origin);
        }
        if (!exe) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        origin.setNewName(name);
        boolean result = this.execute(runtime, "rename table", adapter.buildRenameRunSQL(origin));
        if (null != ddListener) {
            ddListener.afterRename(origin, result);
        }
        return false;
    }

    @Override
    public boolean create(View view) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeCreate(view);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)view);
        String random = this.random();
        long fr = System.currentTimeMillis();
        List<String> sqls = adapter.buildCreateRunSQL(view);
        boolean result = this.execute(runtime, random, "drop view", sqls);
        if (sqls.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[create view][view:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, view.getName(), System.currentTimeMillis() - fr});
        }
        if (null != ddListener) {
            ddListener.afterCreate(view, result);
        }
        return result;
    }

    @Override
    public boolean alter(View view) throws Exception {
        boolean result = false;
        View update = view.getUpdate();
        String name = view.getName();
        String uname = update.getName();
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        this.checkSchema(runtime, (Table)view);
        this.checkSchema(runtime, (Table)update);
        if (!name.equalsIgnoreCase(uname)) {
            this.rename(runtime, view, uname);
            CacheProxy.clear();
        }
        return result;
    }

    @Override
    public boolean drop(View view) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeDrop(view);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)view);
        String sql = adapter.buildDropRunSQL(view);
        boolean result = this.execute(runtime, "drop view", sql);
        if (null != ddListener) {
            ddListener.afterDrop(view, result);
        }
        return result;
    }

    @Override
    public boolean rename(View origin, String name) throws Exception {
        return this.rename(this.runtime(), origin, name);
    }

    public boolean rename(JDBCRuntime runtime, View origin, String name) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeRename(origin);
        }
        if (!exe) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)origin);
        origin.setNewName(name);
        boolean result = this.execute(runtime, "rename view", adapter.buildRenameRunSQL(origin));
        if (null != ddListener) {
            ddListener.afterRename(origin, result);
        }
        return false;
    }

    @Override
    public boolean create(MasterTable table) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeDrop(table);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)table);
        List<String> sqls = adapter.buildCreateRunSQL(table);
        long fr = System.currentTimeMillis();
        String random = this.random();
        boolean result = this.execute(runtime, random, "create MasterTable", sqls);
        if (null != ddListener) {
            ddListener.afterDrop(table, result);
        }
        if (sqls.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[create master table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean alter(MasterTable table) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeAlter(table);
        }
        if (!exe) {
            return false;
        }
        boolean result = true;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)table);
        MasterTable update = table.getUpdate();
        LinkedHashMap columns = table.getColumns();
        LinkedHashMap ucolumns = update.getColumns();
        LinkedHashMap tags = table.getTags();
        LinkedHashMap utags = update.getTags();
        String name = table.getName();
        String uname = update.getName();
        long fr = System.currentTimeMillis();
        String random = this.random();
        if (!name.equalsIgnoreCase(uname)) {
            result = this.rename(runtime, table, uname);
        }
        for (Column ucolumn : ucolumns.values()) {
            Column column = (Column)columns.get(ucolumn.getName().toUpperCase());
            if (null != column) {
                column.setTable((Table)update);
                column.setUpdate(ucolumn, false, false);
                this.alter(column);
                result = true;
                continue;
            }
            ucolumn.setTable((Table)update);
            this.add(ucolumn);
            result = true;
        }
        if (table.isAutoDropColumn()) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || null != (ucolumn = (Column)ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable((Table)update);
                this.drop(column);
                result = true;
            }
        }
        for (Tag utag : utags.values()) {
            Tag tag = (Tag)tags.get(utag.getName().toUpperCase());
            if (null != tag) {
                tag.setTable((Table)update);
                tag.setUpdate(utag, false, false);
                this.alter(tag);
                result = true;
                continue;
            }
            utag.setTable((Table)update);
            this.add(utag);
            result = true;
        }
        if (table.isAutoDropColumn()) {
            for (Tag tag : tags.values()) {
                Tag utag = (Tag)utags.get(tag.getName().toUpperCase());
                if (null != utag) continue;
                tag.setTable((Table)update);
                this.drop(tag);
                result = true;
            }
        }
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[alter master table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean drop(MasterTable table) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeDrop(table);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)table);
        String sql = adapter.buildDropRunSQL(table);
        boolean result = this.execute(runtime, "drop MasterTable", sql);
        if (null != ddListener) {
            ddListener.afterDrop(table, result);
        }
        return result;
    }

    @Override
    public boolean rename(MasterTable origin, String name) throws Exception {
        return this.rename(this.runtime(), origin, name);
    }

    public boolean rename(JDBCRuntime runtime, MasterTable origin, String name) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeRename(origin);
        }
        if (!exe) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)origin);
        origin.setNewName(name);
        boolean result = this.execute(runtime, "rename MasterTable", adapter.buildRenameRunSQL(origin));
        if (null != ddListener) {
            ddListener.afterRename(origin, result);
        }
        return false;
    }

    @Override
    public boolean create(PartitionTable table) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeCreate(table);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)table);
        long fr = System.currentTimeMillis();
        String random = this.random();
        List<String> sqls = adapter.buildCreateRunSQL(table);
        boolean result = this.execute(runtime, random, "create PartitionTable", sqls);
        if (null != ddListener) {
            ddListener.afterCreate(table, result);
        }
        if (sqls.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[create partition table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean alter(PartitionTable table) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeAlter(table);
        }
        if (!exe) {
            return false;
        }
        boolean result = true;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String random = this.random();
        this.checkSchema(runtime, (Table)table);
        Table update = table.getUpdate();
        LinkedHashMap columns = table.getColumns();
        LinkedHashMap ucolumns = update.getColumns();
        String name = table.getName();
        String uname = update.getName();
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            result = this.rename(runtime, table, uname);
        }
        for (Column ucolumn : ucolumns.values()) {
            Column column = (Column)columns.get(ucolumn.getName().toUpperCase());
            if (null != column) {
                column.setTable(update);
                column.setUpdate(ucolumn, false, false);
                this.alter(column);
                result = true;
                continue;
            }
            ucolumn.setTable(update);
            this.add(ucolumn);
            result = true;
        }
        if (table.isAutoDropColumn()) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || null != (ucolumn = (Column)ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                this.drop(column);
                result = true;
            }
        }
        if (null != ddListener) {
            ddListener.afterAlter(table, result);
        }
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[alter partition table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean drop(PartitionTable table) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeDrop(table);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)table);
        String sql = adapter.buildDropRunSQL(table);
        boolean result = this.execute(runtime, "drop PartitionTable", sql);
        if (null != ddListener) {
            ddListener.afterDrop(table, result);
        }
        return result;
    }

    @Override
    public boolean rename(PartitionTable origin, String name) throws Exception {
        return this.rename(this.runtime(), origin, name);
    }

    public boolean rename(JDBCRuntime runtime, PartitionTable origin, String name) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeRename(origin);
        }
        if (!exe) {
            return false;
        }
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)origin);
        origin.setNewName(name);
        boolean result = this.execute(runtime, "rename PartitionTable", adapter.buildRenameRunSQL(origin));
        if (null != ddListener) {
            ddListener.afterRename(origin, result);
        }
        return false;
    }

    @Override
    public boolean add(Column column) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeAdd(column);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, column);
        long fr = System.currentTimeMillis();
        String random = this.random();
        List<String> sqls = adapter.buildAddRunSQL(column);
        boolean result = this.execute(runtime, random, "add column", sqls);
        if (null != ddListener) {
            ddListener.afterAdd(column, result);
        }
        if (sqls.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[add column][table:{}][column:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, column.getTableName(true), column.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean alter(Table table, Column column) throws Exception {
        return this.alter(table, column, true);
    }

    @Override
    public boolean alter(Column column) throws Exception {
        Table table = column.getTable(true);
        if (null == table) {
            LinkedHashMap tables = this.tables(column.getCatalog(), column.getSchema(), column.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + column.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + column.getTableName(true));
            } else {
                table = (Table)tables.values().iterator().next();
            }
        }
        return this.alter(table, column, true);
    }

    @Override
    public boolean drop(Column column) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeDrop(column);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, column);
        String sql = adapter.buildDropRunSQL(column);
        boolean result = this.execute(runtime, "drop column", sql);
        if (null != ddListener) {
            ddListener.afterDrop(column, result);
        }
        return result;
    }

    private boolean alter(Table table, Column column, boolean trigger) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeAlter(column);
        }
        if (!exe) {
            return false;
        }
        boolean result = true;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, column);
        long fr = System.currentTimeMillis();
        String random = this.random();
        List<String> sqls = adapter.buildAlterRunSQL(column, false);
        try {
            result = this.execute(runtime, random, "alter column", sqls);
            if (null != ddListener) {
                ddListener.afterAlter(column, result);
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.warn("{}[{}][exception:{}]", new Object[]{random, LogUtil.format((String)"\u4fee\u6539Column\u6267\u884c\u5f02\u5e38", (int)33), e.toString()});
            if (trigger && null != ddListener && !BasicUtil.equalsIgnoreCase((Object)column.getTypeName(), (Object)column.getUpdate().getTypeName())) {
                if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION != 0) {
                    exe = ddListener.afterAlterColumnException(table, column, e);
                }
                log.warn("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u5c1d\u8bd5\u4fee\u6b63\u6570\u636e][\u4fee\u6b63\u7ed3\u679c:{}]", (Object)random, (Object)exe);
                if (exe) {
                    result = this.alter(table, column, false);
                }
            }
            log.error("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u4e2d\u65ad\u6267\u884c]", (Object)random);
            result = false;
            throw e;
        }
        if (sqls.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[update column][table:{}][column:{}][qty:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, column.getTableName(true), column.getName(), sqls.size(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean rename(Column origin, String name) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeRename(origin);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        origin.setNewName(name);
        boolean result = this.execute(runtime, "rename column", adapter.buildRenameRunSQL(origin));
        if (null != ddListener) {
            ddListener.afterRename(origin, result);
        }
        return result;
    }

    @Override
    public boolean add(Tag tag) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeAdd((Column)tag);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Column)tag);
        String sql = adapter.buildAddRunSQL(tag);
        boolean result = this.execute(runtime, "add tag", sql);
        if (null != ddListener) {
            ddListener.afterAdd((Column)tag, result);
        }
        return result;
    }

    @Override
    public boolean alter(Table table, Tag tag) throws Exception {
        return this.alter(table, tag, true);
    }

    @Override
    public boolean alter(Tag tag) throws Exception {
        Table table = tag.getTable(true);
        if (null == table) {
            LinkedHashMap tables = this.tables(false, tag.getCatalog(), tag.getSchema(), tag.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + tag.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + tag.getTableName(true));
            } else {
                table = (Table)tables.values().iterator().next();
            }
        }
        return this.alter(table, tag, true);
    }

    @Override
    public boolean drop(Tag tag) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeDrop((Column)tag);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Column)tag);
        String sql = adapter.buildDropRunSQL(tag);
        boolean result = this.execute(runtime, "drop tag", sql);
        if (null != ddListener) {
            ddListener.afterDrop((Column)tag, result);
        }
        return result;
    }

    private boolean alter(Table table, Tag tag, boolean trigger) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeAlter((Column)tag);
        }
        if (!exe) {
            return false;
        }
        boolean result = true;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Column)tag);
        long fr = System.currentTimeMillis();
        String random = this.random();
        List<String> sqls = adapter.buildAlterRunSQL(tag);
        try {
            result = this.execute(runtime, random, "alter tag", sqls);
            if (null != ddListener) {
                ddListener.afterAlter((Column)tag, result);
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.warn("{}[{}][exception:{}]", new Object[]{random, LogUtil.format((String)"\u4fee\u6539tag\u6267\u884c\u5f02\u5e38", (int)33), e.toString()});
            if (trigger && null != ddListener && !BasicUtil.equalsIgnoreCase((Object)tag.getTypeName(), (Object)tag.getUpdate().getTypeName())) {
                if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION != 0) {
                    exe = ddListener.afterAlterColumnException(table, (Column)tag, e);
                }
                log.warn("{}[\u4fee\u6539tag\u6267\u884c\u5f02\u5e38][\u5c1d\u8bd5\u4fee\u6b63\u6570\u636e][\u4fee\u6b63\u7ed3\u679c:{}]", (Object)random, (Object)exe);
                if (exe) {
                    result = this.alter(table, tag, false);
                }
            }
            log.error("{}[\u4fee\u6539tag\u6267\u884c\u5f02\u5e38][\u4e2d\u65ad\u6267\u884c]", (Object)random);
            result = false;
            throw e;
        }
        if (sqls.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[update tag][table:{}][tag:{}][qty:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, tag.getTableName(true), tag.getName(), sqls.size(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean rename(Tag origin, String name) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeRename((Column)origin);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Column)origin);
        origin.setNewName(name);
        boolean result = this.execute(runtime, "rename tag", adapter.buildRenameRunSQL(origin));
        if (null != ddListener) {
            ddListener.afterRename((Column)origin, result);
        }
        return result;
    }

    @Override
    public boolean add(PrimaryKey primary) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeAdd(primary);
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Index)primary);
        String sql = adapter.buildAddRunSQL(primary);
        boolean result = this.execute(runtime, "add primary", sql);
        if (null != ddListener) {
            ddListener.afterAdd(primary, result);
        }
        return result;
    }

    @Override
    public boolean alter(PrimaryKey primary) throws Exception {
        Table table = primary.getTable(true);
        if (null == table) {
            LinkedHashMap tables = this.tables(false, primary.getCatalog(), primary.getSchema(), primary.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + primary.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + primary.getTableName(true));
            } else {
                table = (Table)tables.values().iterator().next();
            }
        }
        return this.alter(table, primary);
    }

    @Override
    public boolean alter(Table table, PrimaryKey primary) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeAlter(primary);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Index)primary);
        String random = this.random();
        long fr = System.currentTimeMillis();
        List<String> sqls = adapter.buildAlterRunSQL(primary);
        boolean result = this.execute(runtime, random, "alter primary", sqls);
        if (null != ddListener) {
            ddListener.afterAlter(primary, result);
        }
        if (sqls.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[alter primary][table:{}][primary:{}][qty:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, primary.getTableName(true), primary.getName(), sqls.size(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean drop(PrimaryKey primary) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeAdd(primary);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Index)primary);
        String sql = adapter.buildDropRunSQL(primary);
        boolean result = this.execute(runtime, "drop primary", sql);
        if (null != ddListener) {
            ddListener.afterDrop(primary, result);
        }
        return result;
    }

    @Override
    public boolean rename(PrimaryKey origin, String name) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeRename(origin);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Index)origin);
        origin.setNewName(name);
        boolean result = this.execute(runtime, "rename primary", adapter.buildRenameRunSQL(origin));
        if (null != ddListener) {
            ddListener.afterRename(origin, result);
        }
        return result;
    }

    @Override
    public boolean add(ForeignKey foreign) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeAdd(foreign);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Constraint)foreign);
        String sql = adapter.buildAddRunSQL(foreign);
        boolean result = this.execute(runtime, "add foreign", sql);
        if (null != ddListener) {
            ddListener.afterAdd(foreign, result);
        }
        return result;
    }

    @Override
    public boolean alter(ForeignKey foreign) throws Exception {
        Table table = foreign.getTable(true);
        if (null == table) {
            LinkedHashMap tables = this.tables(false, foreign.getCatalog(), foreign.getSchema(), foreign.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + foreign.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + foreign.getTableName(true));
            } else {
                table = (Table)tables.values().iterator().next();
            }
        }
        return this.alter(table, foreign);
    }

    @Override
    public boolean alter(Table table, ForeignKey foreign) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeAlter(foreign);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Constraint)foreign);
        long fr = System.currentTimeMillis();
        String random = this.random();
        List<String> sqls = adapter.buildAlterRunSQL(foreign);
        boolean result = this.execute(runtime, random, "alter foreign", sqls);
        if (null != ddListener) {
            ddListener.afterAlter(foreign, result);
        }
        if (sqls.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[alter foreign][table:{}][primary:{}][qty:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, foreign.getTableName(true), foreign.getName(), sqls.size(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean drop(ForeignKey foreign) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeDrop(foreign);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Constraint)foreign);
        String sql = adapter.buildDropRunSQL(foreign);
        boolean result = this.execute(runtime, "drop foreign", sql);
        if (null != ddListener) {
            ddListener.afterDrop(foreign, result);
        }
        return result;
    }

    @Override
    public boolean rename(ForeignKey origin, String name) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeRename(origin);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Constraint)origin);
        origin.setNewName(name);
        boolean result = this.execute(runtime, "rename foreign", adapter.buildRenameRunSQL(origin));
        if (null != ddListener) {
            ddListener.afterRename(origin, result);
        }
        return result;
    }

    @Override
    public boolean add(Index index) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeAdd(index);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, index);
        String sql = adapter.buildAddRunSQL(index);
        boolean result = this.execute(runtime, "add index", sql);
        if (null != ddListener) {
            ddListener.afterAdd(index, result);
        }
        return result;
    }

    @Override
    public boolean alter(Index index) throws Exception {
        Table table = index.getTable(true);
        if (null == table) {
            LinkedHashMap tables = this.tables(false, index.getCatalog(), index.getSchema(), index.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + index.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + index.getTableName(true));
            } else {
                table = (Table)tables.values().iterator().next();
            }
        }
        return this.alter(table, index);
    }

    @Override
    public boolean alter(Table table, Index index) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeAlter(index);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        String random = this.random();
        this.checkSchema(runtime, index);
        List<String> sqls = adapter.buildAlterRunSQL(index);
        boolean result = this.execute(runtime, random, "alter index", sqls);
        if (null != ddListener) {
            ddListener.afterAlter(index, result);
        }
        if (sqls.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[alter index][table:{}][index:{}][qty:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, index.getTableName(true), index.getName(), sqls.size(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean drop(Index index) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeDrop(index);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, index);
        String sql = adapter.buildDropRunSQL(index);
        boolean result = this.execute(runtime, "drop index", sql);
        if (null != ddListener) {
            ddListener.afterDrop(index, result);
        }
        return result;
    }

    @Override
    public boolean rename(Index origin, String name) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeRename(origin);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        origin.setNewName(name);
        boolean result = this.execute(runtime, "rename index", adapter.buildRenameRunSQL(origin));
        if (null != ddListener) {
            ddListener.afterRename(origin, result);
        }
        return result;
    }

    @Override
    public boolean add(Constraint constraint) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeAdd(constraint);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, constraint);
        String sql = adapter.buildAddRunSQL(constraint);
        boolean result = this.execute(runtime, "add constraint", sql);
        if (null != ddListener) {
            ddListener.afterAdd(constraint, result);
        }
        return result;
    }

    @Override
    public boolean alter(Constraint constraint) throws Exception {
        Table table = constraint.getTable(true);
        if (null == table) {
            LinkedHashMap tables = this.tables(false, constraint.getCatalog(), constraint.getSchema(), constraint.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + constraint.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + constraint.getTableName(true));
            } else {
                table = (Table)tables.values().iterator().next();
            }
        }
        return this.alter(table, constraint);
    }

    @Override
    public boolean alter(Table table, Constraint constraint) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeAlter(constraint);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String random = this.random();
        this.checkSchema(runtime, constraint);
        long fr = System.currentTimeMillis();
        List<String> sqls = adapter.buildAlterRunSQL(constraint);
        boolean result = this.execute(runtime, random, "alter constraint", sqls);
        if (null != ddListener) {
            ddListener.afterAlter(constraint, result);
        }
        if (sqls.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[alter constraint][table:{}][constraint:{}][qty:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, constraint.getTableName(true), constraint.getName(), sqls.size(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean drop(Constraint constraint) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeDrop(constraint);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, constraint);
        String sql = adapter.buildDropRunSQL(constraint);
        boolean result = this.execute(runtime, "drop constraint", sql);
        if (null != ddListener) {
            ddListener.afterDrop(constraint, result);
        }
        return result;
    }

    @Override
    public boolean rename(Constraint origin, String name) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeRename(origin);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        origin.setNewName(name);
        boolean result = this.execute(runtime, "rename constraint", adapter.buildRenameRunSQL(origin));
        if (null != ddListener) {
            ddListener.afterRename(origin, result);
        }
        return result;
    }

    @Override
    public boolean create(Trigger trigger) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeCreate(trigger);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, trigger);
        String sql = adapter.buildCreateRunSQL(trigger);
        boolean result = this.execute(runtime, "create trigger", sql);
        if (null != ddListener) {
            ddListener.afterCreate(trigger, result);
        }
        return result;
    }

    @Override
    public boolean alter(Trigger trigger) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeAlter(trigger);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        String random = this.random();
        this.checkSchema(runtime, trigger);
        List<String> sqls = adapter.buildAlterRunSQL(trigger);
        boolean result = this.execute(runtime, random, "alter trigger", sqls);
        if (null != ddListener) {
            ddListener.afterAlter(trigger, result);
        }
        if (sqls.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[alter trigger][table:{}][trigger:{}][qty:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, trigger.getTableName(true), trigger.getName(), sqls.size(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean drop(Trigger trigger) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeDrop(trigger);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, trigger);
        String sql = adapter.buildDropRunSQL(trigger);
        boolean result = this.execute(runtime, "drop trigger", sql);
        if (null != ddListener) {
            ddListener.afterDrop(trigger, result);
        }
        return result;
    }

    @Override
    public boolean rename(Trigger origin, String name) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeRename(origin);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        origin.setNewName(name);
        boolean result = this.execute(runtime, "rename trigger", adapter.buildRenameRunSQL(origin));
        if (null != ddListener) {
            ddListener.afterRename(origin, result);
        }
        return result;
    }

    @Override
    public boolean create(Procedure procedure) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeCreate(procedure);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, procedure);
        String sql = adapter.buildCreateRunSQL(procedure);
        boolean result = this.execute(runtime, "create procedure", sql);
        if (null != ddListener) {
            ddListener.afterCreate(procedure, result);
        }
        return result;
    }

    @Override
    public boolean alter(Procedure procedure) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeAlter(procedure);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        String random = this.random();
        this.checkSchema(runtime, procedure);
        List<String> sqls = adapter.buildAlterRunSQL(procedure);
        boolean result = this.execute(runtime, random, "alter procedure", sqls);
        if (null != ddListener) {
            ddListener.afterAlter(procedure, result);
        }
        if (sqls.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[update procedure][procedure:{}][qty:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, procedure.getName(), sqls.size(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean drop(Procedure procedure) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeDrop(procedure);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, procedure);
        String sql = adapter.buildDropRunSQL(procedure);
        boolean result = this.execute(runtime, "drop procedure", sql);
        if (null != ddListener) {
            ddListener.afterDrop(procedure, result);
        }
        return result;
    }

    @Override
    public boolean rename(Procedure origin, String name) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeRename(origin);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        origin.setNewName(name);
        boolean result = this.execute(runtime, "rename procedure", adapter.buildRenameRunSQL(origin));
        if (null != ddListener) {
            ddListener.afterRename(origin, result);
        }
        return result;
    }

    @Override
    public boolean create(Function function) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeCreate(function);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, function);
        String sql = adapter.buildCreateRunSQL(function);
        boolean result = this.execute(runtime, "create function", sql);
        if (null != ddListener) {
            ddListener.afterCreate(function, result);
        }
        return result;
    }

    @Override
    public boolean alter(Function function) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeDrop(function);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        String random = this.random();
        this.checkSchema(runtime, function);
        List<String> sqls = adapter.buildAlterRunSQL(function);
        boolean result = this.execute(runtime, random, "update function", sqls);
        if (null != ddListener) {
            ddListener.afterAlter(function, result);
        }
        if (sqls.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[update function][function:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, function.getName(), sqls.size(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean drop(Function function) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeDrop(function);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, function);
        String sql = adapter.buildDropRunSQL(function);
        boolean result = this.execute(runtime, "drop function", sql);
        if (null != ddListener) {
            ddListener.afterDrop(function, result);
        }
        return result;
    }

    @Override
    public boolean rename(Function origin, String name) throws Exception {
        boolean exe = true;
        if (null != ddListener) {
            exe = ddListener.beforeRename(origin);
        }
        if (!exe) {
            return false;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        origin.setNewName(name);
        boolean result = this.execute(runtime, "rename function", adapter.buildRenameRunSQL(origin));
        if (null != ddListener) {
            ddListener.afterRename(origin, result);
        }
        return result;
    }

    public boolean execute(JDBCRuntime runtime, String title, String sql) {
        return this.execute(runtime, this.random(), title, sql);
    }

    public boolean execute(JDBCRuntime runtime, String random, String title, String sql) {
        boolean result = false;
        if (BasicUtil.isNotEmpty((Object)sql)) {
            Long fr = System.currentTimeMillis();
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                random = this.random();
                log.info("{}[{}][ds:{}][sql:\n{}\n]", new Object[]{random, title, runtime.datasource(), sql});
            }
            runtime.getTemplate().update(sql);
            if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[{}][ds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, title, runtime.datasource(), result, System.currentTimeMillis() - fr});
            }
        }
        result = true;
        return result;
    }

    public boolean execute(JDBCRuntime runtime, String random, String title, List<String> sqls) {
        boolean result = true;
        int idx = 0;
        for (String sql : sqls) {
            result = this.execute(runtime, random + "-" + idx++, title, sql) && result;
        }
        return result;
    }

    public boolean execute(JDBCRuntime runtime, String title, List<String> sqls) {
        return this.execute(runtime, this.random(), title, sqls);
    }

    public void checkSchema(JDBCRuntime runtime, Table table) {
        if (null != table) {
            JDBCAdapter adapter = runtime.getAdapter();
            adapter.checkSchema(runtime.getTemplate().getDataSource(), table);
        }
    }

    public void checkSchema(JDBCRuntime runtime, Column column) {
        Table table = column.getTable(true);
        if (null != table) {
            this.checkSchema(runtime, table);
            column.setCatalog(table.getCatalog());
            column.setSchema(table.getSchema());
        }
    }

    public void checkSchema(JDBCRuntime runtime, Index index) {
        Table table = index.getTable(true);
        if (null != table) {
            this.checkSchema(runtime, table);
            index.setCatalog(table.getCatalog());
            index.setSchema(table.getSchema());
        }
    }

    public void checkSchema(JDBCRuntime runtime, Constraint constraint) {
        Table table = constraint.getTable(true);
        if (null != table) {
            this.checkSchema(runtime, table);
            constraint.setCatalog(table.getCatalog());
            constraint.setSchema(table.getSchema());
        }
    }

    public void checkSchema(JDBCRuntime runtime, Trigger trigger) {
        Table table = trigger.getTable(true);
        if (null != table) {
            this.checkSchema(runtime, table);
        }
    }

    public void checkSchema(JDBCRuntime runtime, Procedure procedure) {
        Table table = new Table(procedure.getCatalog(), procedure.getSchema());
        this.checkSchema(runtime, table);
        procedure.setCatalog(table.getCatalog());
        procedure.setSchema(table.getSchema());
    }

    public void checkSchema(JDBCRuntime runtime, Function function) {
        Table table = new Table(function.getCatalog(), function.getSchema());
        this.checkSchema(runtime, table);
        function.setCatalog(table.getCatalog());
        function.setSchema(table.getSchema());
    }

    protected String paramLogFormat(List<?> params) {
        StringBuilder builder = new StringBuilder();
        if (null != params && params.size() > 0) {
            builder.append("\n");
            int idx = 0;
            for (Object param : params) {
                builder.append("param").append(idx++).append("=");
                builder.append(param);
                if (null != param) {
                    builder.append("(").append(ClassUtil.type(param)).append(")");
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String paramLogFormat(List<?> keys, List<?> values) {
        StringBuilder builder = new StringBuilder();
        if (null != keys && null != values && keys.size() > 0) {
            builder.append("\n");
            if (keys.size() != values.size()) return this.paramLogFormat(values);
            int size = keys.size();
            for (int i = 0; i < size; ++i) {
                Object key = keys.get(i);
                Object value = values.get(i);
                builder.append(keys.get(i)).append("=");
                builder.append(value);
                if (null != value) {
                    builder.append("(").append(ClassUtil.type(value)).append(")");
                }
                builder.append("\n");
            }
            return builder.toString();
        } else {
            if (null == values) return builder.toString();
            builder.append(BeanUtil.concat(values, (boolean)true)).append("\n");
        }
        return builder.toString();
    }

    private String random() {
        StringBuilder builder = new StringBuilder();
        builder.append("[SQL:").append(System.currentTimeMillis()).append("-").append(BasicUtil.getRandomNumberString((int)8)).append("][thread:").append(Thread.currentThread().getId()).append("][ds:").append(this.runtime().datasource()).append("]");
        return builder.toString();
    }

    static {
        isBatchInsertRun = false;
    }
}

