package org.anyline.data.interceptor;

import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.RunPrepare;

public interface DMInterceptor {

    enum ACTION{
        QUERY           ("查询"),
        INSERT          ("插入"),
        UPDATE          ("更新"),
        DELETE          ("删除"),
        EXISTS          ("是否存在"),
        COUNT           ("行数统计"),

        ;
        private final String title;
        ACTION(String title){
            this.title = title;
        }
    }

    default int order(){
        return 1;
    }
    int before(Runtime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions);
    int after(Runtime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions);
}
