package org.anyline.data.interceptor;

import java.util.List;

public interface DDInterceptor {
    enum ACTION{
        TABLE_CREATE    ("表创建"),
        TABLE_ALTER     ("表结构修改"),
        TABLE_DROP      ("表删除"),
        TABLE_RENAME    ("表重命名"),

        COLUMN_CREATE   ("列创建"),
        COLUMN_ALTER    ("列结构修改"),
        COLUMN_DROP     ("列删除"),
        COLUMN_RENAME   ("列重命名"),
        ;
        private final String title;
        ACTION(String title){
            this.title = title;
        }
    }
    /*
     * before1
     * before2
     * before3
     * EXE
     * after1
     * after2
     * after3
    * */
    enum RESULT{
        CONINUE("正常执行"),
        SKIP("跳过后续before/after"), //before1返回SKIP则跳过before2,before3,但不影响after2,after3,
        BREAK("中断主流程执行")
        ;
        private final String title;
        RESULT(String title){
            this.title = title;
        }
    }

    /**
     * 执行顺序 最小的先执行
     * @return int
     */
    default int order(){
        return 100;
    }

    /**
     * 可触发当前拦截器的事件
     * @return
     */
    List<ACTION> actions();

    int before(Runtime runtime, Object entity);

}
