/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.adapter.init.ConvertAdapter;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.SpringContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.env.Environment;

public class DataSourceUtil {
    private static final String DATASOURCE_TYPE_DEFAULT = "com.zaxxer.hikari.HikariDataSource";
    public static Logger log = LoggerFactory.getLogger(DataSourceUtil.class);

    public static String buildDataSource(String key, String prefix, Environment env) {
        try {
            String type;
            if (BasicUtil.isNotEmpty((Object)prefix) && !prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            if (null == (type = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"type"}))) {
                type = BeanUtil.value((String)"spring.datasource.", (Environment)env, (String[])new String[]{"type"});
            }
            if (type == null) {
                type = DATASOURCE_TYPE_DEFAULT;
            }
            String driverClassName = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"driver", "driver-class", "driver-class-name"});
            String url = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"url", "jdbc-url"});
            String username = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"user", "username", "user-name"});
            String password = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"password"});
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("url", url);
            map.put("jdbcUrl", url);
            map.put("driver", driverClassName);
            map.put("driverClass", driverClassName);
            map.put("driverClassName", driverClassName);
            map.put("user", username);
            map.put("username", username);
            map.put("password", password);
            return DataSourceUtil.regDatasource(key, map);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DataSource buildDataSource(Map params) throws Exception {
        try {
            String type = (String)params.get("pool");
            if (BasicUtil.isEmpty((Object)type)) {
                type = (String)params.get("type");
            }
            if (type == null) {
                throw new Exception("\u672a\u8bbe\u7f6e\u6570\u636e\u6e90\u7c7b\u578b(\u5982:pool=com.zaxxer.hikari.HikariDataSource)");
            }
            Class<?> poolClass = Class.forName(type);
            Object driver = BeanUtil.propertyNvl((Map)params, (String[])new String[]{"driver", "driver-class", "driver-class-name"});
            Object url = BeanUtil.propertyNvl((Map)params, (String[])new String[]{"url", "jdbc-url"});
            Object user = BeanUtil.propertyNvl((Map)params, (String[])new String[]{"user", "username"});
            DataSource ds = (DataSource)poolClass.newInstance();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.putAll(params);
            map.put("url", url);
            map.put("jdbcUrl", url);
            map.put("driver", driver);
            map.put("driverClass", driver);
            map.put("driverClassName", driver);
            map.put("user", user);
            map.put("username", user);
            BeanUtil.setFieldsValue((Object)ds, map, (boolean)false);
            return ds;
        }
        catch (Exception e) {
            log.error("[\u6ce8\u518c\u6570\u636e\u6e90\u5931\u8d25][\u6570\u636e\u6e90:{}][msg:{}]", (Object)e.toString());
            return null;
        }
    }

    public static String regDatasource(String key, Map params) throws Exception {
        String ds_id = "anyline.datasource." + key;
        try {
            String type = (String)params.get("pool");
            if (BasicUtil.isEmpty((Object)type)) {
                type = (String)params.get("type");
            }
            if (type == null) {
                type = DATASOURCE_TYPE_DEFAULT;
            }
            Class<?> poolClass = Class.forName(type);
            Object driver = BeanUtil.propertyNvl((Map)params, (String[])new String[]{"driver", "driver-class", "driver-class-name"});
            if (null == driver) {
                return null;
            }
            Class.forName(driver.toString());
            Object url = BeanUtil.propertyNvl((Map)params, (String[])new String[]{"url", "jdbc-url"});
            Object user = BeanUtil.propertyNvl((Map)params, (String[])new String[]{"user", "username"});
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.putAll(params);
            map.put("url", url);
            map.put("jdbcUrl", url);
            map.put("driver", driver);
            map.put("driverClass", driver);
            map.put("driverClassName", driver);
            map.put("user", user);
            map.put("username", user);
            DefaultListableBeanFactory factory = (DefaultListableBeanFactory)SpringContextUtil.getApplicationContext().getAutowireCapableBeanFactory();
            BeanDefinitionBuilder ds_builder = BeanDefinitionBuilder.genericBeanDefinition(poolClass);
            List fields = ClassUtil.getFields(poolClass, (boolean)false, (boolean)false);
            for (Field field : fields) {
                String name = field.getName();
                Object value = map.get(name);
                if (null == (value = ConvertAdapter.convert(value, field.getType()))) continue;
                ds_builder.addPropertyValue(name, value);
            }
            AbstractBeanDefinition ds_definition = ds_builder.getBeanDefinition();
            factory.registerBeanDefinition(ds_id, (BeanDefinition)ds_definition);
        }
        catch (Exception e) {
            log.error("[\u6ce8\u518c\u6570\u636e\u6e90\u5931\u8d25][\u6570\u636e\u6e90:{}][msg:{}]", (Object)key, (Object)e.toString());
            return null;
        }
        return ds_id;
    }

    private static void setFieldsValue(Object obj, String prefix, Environment env) {
        List fields = ClassUtil.getFieldsName(obj.getClass());
        for (String field : fields) {
            String value = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{field});
            if (!BasicUtil.isNotEmpty((Object)value)) continue;
            BeanUtil.setFieldValue((Object)obj, (String)field, (Object)value);
        }
    }
}

