/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.ds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.data.jdbc.ds.RuntimeHolder;
import org.anyline.data.jdbc.util.DataSourceUtil;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.data.DatabaseType;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.SpringContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class DataSourceHolder {
    public static Logger log = LoggerFactory.getLogger(DataSourceHolder.class);
    private static final ThreadLocal<String> THREAD_RECALL_SOURCE = new ThreadLocal();
    private static final ThreadLocal<String> THREAD_CUR_SOURCE = new ThreadLocal();
    private static final ThreadLocal<Boolean> THREAD_AUTO_RECOVER = new ThreadLocal();
    private static List<String> dataSources = new ArrayList<String>();
    private static Map<String, DatabaseType> types = new HashMap<String, DatabaseType>();
    private static Map<TransactionStatus, String> transactionStatus = new Hashtable<TransactionStatus, String>();

    public static List<String> list() {
        return dataSources;
    }

    public static String curDataSource() {
        return THREAD_CUR_SOURCE.get();
    }

    public static DatabaseType dialect() {
        String ds = DataSourceHolder.curDataSource();
        return types.get(ds);
    }

    public static void dialect(String ds, DatabaseType type) {
        types.put(ds, type);
    }

    public static void setDataSource(String dataSource) {
        DataSourceHolder.setDataSource(dataSource, false);
    }

    public static void destroyDataSource(String dataSource) {
        dataSources.remove(dataSource);
        RuntimeHolder.destroyRuntime(dataSource);
    }

    public static void setDataSource(String dataSource, boolean auto) {
        if (null == dataSource || !dataSources.contains(dataSource)) {
            throw new RuntimeException("\u6570\u636e\u6e90\u672a\u6ce8\u518c:" + dataSource);
        }
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u5207\u6362\u6570\u636e\u6e90][thread:{}][\u6570\u636e\u6e90:{}>{}][auto recover:{}]", new Object[]{Thread.currentThread().getId(), THREAD_RECALL_SOURCE.get(), dataSource, auto});
        }
        THREAD_RECALL_SOURCE.set(THREAD_CUR_SOURCE.get());
        THREAD_CUR_SOURCE.set(dataSource);
        THREAD_AUTO_RECOVER.set(auto);
    }

    public static void recoverDataSource() {
        THREAD_CUR_SOURCE.set(THREAD_RECALL_SOURCE.get());
    }

    public static void setDefaultDataSource() {
        DataSourceHolder.clearDataSource();
        if (dataSources.contains("dataSource")) {
            DataSourceHolder.setDataSource("dataSource");
        } else if (dataSources.contains("default")) {
            DataSourceHolder.setDataSource("default");
        }
        THREAD_AUTO_RECOVER.set(false);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u5207\u6362\u6570\u636e\u6e90][thread:{}][\u6570\u636e\u6e90:{}>\u9ed8\u8ba4\u6570\u636e\u6e90]", (Object)Thread.currentThread().getId(), (Object)THREAD_RECALL_SOURCE.get());
        }
    }

    public static void clearDataSource() {
        THREAD_CUR_SOURCE.remove();
    }

    public static boolean isAutoDefault() {
        if (null == THREAD_AUTO_RECOVER || null == THREAD_AUTO_RECOVER.get()) {
            return false;
        }
        return THREAD_AUTO_RECOVER.get();
    }

    public static String parseDataSource(String src) {
        if (null != src && src.startsWith("<")) {
            int fr = src.indexOf("<");
            int to = src.indexOf(">");
            if (fr != -1) {
                String ds = src.substring(fr + 1, to);
                src = src.substring(to + 1);
                DataSourceHolder.setDataSource(ds, true);
            }
        }
        return src;
    }

    public static String parseDataSource(String dest, Object obj) {
        if (BasicUtil.isNotEmpty((Object)dest) || null == obj) {
            return DataSourceHolder.parseDataSource(dest);
        }
        String result = "";
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            String link = row.getDataLink();
            if (BasicUtil.isNotEmpty((Object)link)) {
                DataSourceHolder.setDataSource(link, true);
            }
            result = row.getDataSource();
        } else if (obj instanceof DataSet) {
            DataSet set = (DataSet)obj;
            if (set.size() > 0) {
                result = DataSourceHolder.parseDataSource(dest, set.getRow(0));
            }
        } else if (obj instanceof Collection) {
            Object first = ((Collection)obj).iterator().next();
            result = EntityAdapterProxy.table(first.getClass()).getName();
        } else {
            result = EntityAdapterProxy.table(obj.getClass()).getName();
        }
        result = DataSourceHolder.parseDataSource(result);
        return result;
    }

    public static void reg(String ds) {
        if (!dataSources.contains(ds)) {
            dataSources.add(ds);
        }
    }

    public static TransactionStatus startTransaction(String datasource, DefaultTransactionDefinition definition) {
        DataSourceTransactionManager dtm = null;
        if (BasicUtil.isEmpty((Object)datasource)) {
            dtm = (DataSourceTransactionManager)SpringContextUtil.getBean((String)"transactionManager");
            datasource = "";
        } else {
            dtm = (DataSourceTransactionManager)SpringContextUtil.getBean((String)("anyline.transaction." + datasource));
        }
        TransactionStatus status = dtm.getTransaction((TransactionDefinition)definition);
        transactionStatus.put(status, datasource);
        return status;
    }

    public static TransactionStatus startTransaction(String datasource, int behavior) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setPropagationBehavior(behavior);
        return DataSourceHolder.startTransaction(datasource, definition);
    }

    public static TransactionStatus startTransaction(String datasource) {
        return DataSourceHolder.startTransaction(datasource, 0);
    }

    public static TransactionStatus startTransaction(DefaultTransactionDefinition definition) {
        return DataSourceHolder.startTransaction(DataSourceHolder.curDataSource(), definition);
    }

    public static TransactionStatus startTransaction(int behavior) {
        return DataSourceHolder.startTransaction(DataSourceHolder.curDataSource(), behavior);
    }

    public static TransactionStatus startTransaction() {
        return DataSourceHolder.startTransaction(DataSourceHolder.curDataSource());
    }

    public static void commit(TransactionStatus status) {
        String datasource = transactionStatus.get(status);
        DataSourceTransactionManager dtm = null;
        dtm = BasicUtil.isEmpty((Object)datasource) ? (DataSourceTransactionManager)SpringContextUtil.getBean((String)"transactionManager") : (DataSourceTransactionManager)SpringContextUtil.getBean((String)("anyline.transaction." + datasource));
        dtm.commit(status);
        transactionStatus.remove(status);
    }

    public static void rollback(TransactionStatus status) {
        String datasource = transactionStatus.get(status);
        DataSourceTransactionManager dtm = null;
        dtm = BasicUtil.isEmpty((Object)datasource) ? (DataSourceTransactionManager)SpringContextUtil.getBean((String)"transactionManager") : (DataSourceTransactionManager)SpringContextUtil.getBean((String)("anyline.transaction." + datasource));
        dtm.rollback(status);
        transactionStatus.remove(status);
    }

    public static boolean contains(String ds) {
        return dataSources.contains(ds);
    }

    public static String regTransactionManager(String key, DataSource ds) {
        return DataSourceHolder.regTransactionManager(key, ds, false);
    }

    public static String regTransactionManager(String key, DataSource ds, boolean primary) {
        String tm_id = "anyline.transaction." + key;
        DefaultListableBeanFactory factory = (DefaultListableBeanFactory)SpringContextUtil.getApplicationContext().getAutowireCapableBeanFactory();
        BeanDefinitionBuilder tm_builder = BeanDefinitionBuilder.genericBeanDefinition(DataSourceTransactionManager.class);
        tm_builder.addPropertyValue("dataSource", (Object)ds);
        tm_builder.setPrimary(primary);
        AbstractBeanDefinition tm_definition = tm_builder.getBeanDefinition();
        factory.registerBeanDefinition(tm_id, (BeanDefinition)tm_definition);
        log.warn("[\u521b\u5efa\u4e8b\u52a1\u63a7\u5236\u5668][\u6570\u636e\u6e90:{}][bean:{}]", (Object)key, (Object)tm_id);
        return tm_id;
    }

    public static String regTransactionManager(String key, String ds) {
        return DataSourceHolder.regTransactionManager(key, ds, false);
    }

    public static String regTransactionManager(String key, String ds, boolean primary) {
        String tm_id = "anyline.transaction." + key;
        DefaultListableBeanFactory factory = (DefaultListableBeanFactory)SpringContextUtil.getApplicationContext().getAutowireCapableBeanFactory();
        BeanDefinitionBuilder tm_builder = BeanDefinitionBuilder.genericBeanDefinition(DataSourceTransactionManager.class);
        tm_builder.addPropertyReference("dataSource", ds);
        tm_builder.setPrimary(primary);
        AbstractBeanDefinition tm_definition = tm_builder.getBeanDefinition();
        factory.registerBeanDefinition(tm_id, (BeanDefinition)tm_definition);
        log.warn("[\u521b\u5efa\u4e8b\u52a1\u63a7\u5236\u5668][\u6570\u636e\u6e90:{}][bean:{}]", (Object)key, (Object)tm_id);
        return tm_id;
    }

    private static String addDataSource(String key, String ds, boolean over) throws Exception {
        if (!over && dataSources.contains(key)) {
            throw new Exception("[\u91cd\u590d\u6ce8\u518c][thread:" + Thread.currentThread().getId() + "][key:" + key + "]");
        }
        if (ConfigTable.IS_DEBUG && log.isInfoEnabled()) {
            log.info("[\u521b\u5efa\u6570\u636e\u6e90][thread:{}][key:{}]", (Object)Thread.currentThread().getId(), (Object)key);
        }
        DataSourceHolder.regTransactionManager(key, ds);
        DataSourceHolder.reg(key);
        RuntimeHolder.reg(key, ds);
        return ds;
    }

    private static DataSource addDataSource(String key, DataSource ds, boolean over) throws Exception {
        if (!over && dataSources.contains(key)) {
            throw new Exception("[\u91cd\u590d\u6ce8\u518c][thread:" + Thread.currentThread().getId() + "][key:" + key + "]");
        }
        if (ConfigTable.IS_DEBUG && log.isInfoEnabled()) {
            log.info("[\u521b\u5efa\u6570\u636e\u6e90][thread:{}][key:{}]", (Object)Thread.currentThread().getId(), (Object)key);
        }
        DataSourceHolder.regTransactionManager(key, ds);
        DataSourceHolder.reg(key);
        RuntimeHolder.reg(key, ds);
        return ds;
    }

    public static String reg(String key, String pool, String driver, String url, String user, String password) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("type", pool);
        param.put("driver", driver);
        param.put("url", url);
        param.put("user", user);
        param.put("password", password);
        return DataSourceHolder.reg(key, param);
    }

    public static String reg(String key, DatabaseType type, String url, String user, String password) throws Exception {
        return DataSourceHolder.reg(key, "om.zaxxer.hikari.HikariDataSource", type.driver(), url, user, password);
    }

    public static String reg(String key, Map param, boolean over) throws Exception {
        return DataSourceHolder.addDataSource(key, DataSourceUtil.regDatasource(key, param), over);
    }

    public static String reg(String key, Map param) throws Exception {
        String ds = DataSourceUtil.regDatasource(key, param);
        return DataSourceHolder.addDataSource(key, ds, true);
    }

    public static DataSource reg(String key, DataSource ds, boolean over) throws Exception {
        return DataSourceHolder.addDataSource(key, ds, over);
    }

    public static DataSource reg(String key, DataSource ds) throws Exception {
        return DataSourceHolder.addDataSource(key, ds, true);
    }

    public static DataSource getDataSource() {
        return RuntimeHolder.getDataSource();
    }

    public static DataSource getDataSource(String key) {
        return RuntimeHolder.getDataSource(key);
    }

    static {
        THREAD_AUTO_RECOVER.set(false);
    }
}

