/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.entity.Column;
import org.anyline.data.entity.Constraint;
import org.anyline.data.entity.Index;
import org.anyline.data.entity.PrimaryKey;
import org.anyline.data.entity.Tag;
import org.anyline.data.listener.DDListener;
import org.anyline.data.listener.init.DefaultDDListener;
import org.anyline.exception.AnylineException;
import org.anyline.service.AnylineService;
import org.anyline.util.BasicUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;

public class Table
implements org.anyline.entity.data.Table {
    protected String keyword = "TABLE";
    protected String catalog;
    protected String schema;
    protected String name;
    protected String type;
    protected String comment;
    protected String typeCat;
    protected String typeSchema;
    protected String typeName;
    protected String selfReferencingColumn;
    protected String refGeneration;
    protected String engine;
    protected String charset;
    protected String collate;
    protected Long ttl;
    protected Date checkSchemaTime;
    protected PrimaryKey primaryKey;
    protected LinkedHashMap<String, Column> columns = new LinkedHashMap();
    protected LinkedHashMap<String, Tag> tags = new LinkedHashMap();
    protected LinkedHashMap<String, Index> indexs = new LinkedHashMap();
    protected LinkedHashMap<String, Constraint> constraints = new LinkedHashMap();
    protected Table update;
    protected transient DDListener listener;
    protected boolean autoDropColumn = ConfigTable.IS_DDL_AUTO_DROP_COLUMN;

    public Table() {
        this.listener = new DefaultDDListener();
    }

    public Table(String name) {
        this(null, name);
    }

    public Table(String schema, String table) {
        this(null, schema, table);
    }

    public Table(String catalog, String schema, String name) {
        this.catalog = catalog;
        this.schema = schema;
        this.name = name;
        this.listener = new DefaultDDListener();
    }

    public List<Column> primarys() {
        ArrayList<Column> pks = new ArrayList<Column>();
        for (Column column : this.columns.values()) {
            if (column.isPrimaryKey() != 1) continue;
            pks.add(column);
        }
        Collections.sort(pks, new Comparator<Column>(){

            @Override
            public int compare(Column o1, Column o2) {
                Integer p1 = o1.getPosition();
                Integer p2 = o2.getPosition();
                if (null == p1) {
                    return -1;
                }
                if (null == p2) {
                    return 1;
                }
                return p1 > p2 ? 1 : -1;
            }
        });
        return pks;
    }

    public Column primary() {
        List<Column> pks = this.primarys();
        if (pks.isEmpty()) {
            return null;
        }
        return pks.get(0);
    }

    public Table clone() {
        Table table = new Table();
        table.catalog = this.catalog;
        table.schema = this.schema;
        table.name = this.name;
        table.comment = this.comment;
        table.type = this.type;
        table.typeCat = this.typeCat;
        table.typeSchema = this.typeSchema;
        table.typeName = this.typeName;
        table.selfReferencingColumn = this.selfReferencingColumn;
        table.refGeneration = this.refGeneration;
        table.engine = this.engine;
        table.charset = this.charset;
        table.collate = this.collate;
        table.ttl = this.ttl;
        table.checkSchemaTime = this.checkSchemaTime;
        table.primaryKey = this.primaryKey;
        table.columns = this.columns;
        table.tags = this.tags;
        table.indexs = this.indexs;
        table.constraints = this.constraints;
        table.listener = this.listener;
        table.autoDropColumn = this.autoDropColumn;
        table.update = this.update;
        return table;
    }

    public Table update() {
        this.update = this.clone();
        this.update.setUpdate(null);
        return this.update;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    public Table getUpdate() {
        return this.update;
    }

    public Table setUpdate(Table update) {
        this.update = update;
        return this;
    }

    public Table addColumn(Column column) {
        column.setTable(this);
        if (null == this.columns) {
            this.columns = new LinkedHashMap();
        }
        this.columns.put(column.getName(), column);
        return this;
    }

    public Column addColumn(String name, String type) {
        return this.addColumn(name, type, true, null);
    }

    public Column addColumn(String name, String type, boolean nullable, Object def) {
        Column column = new Column();
        column.setName(name);
        column.setNullable(nullable);
        column.setDefaultValue(def);
        column.setTypeName(type);
        this.addColumn(column);
        return column;
    }

    public Table setPrimaryKey(String ... keys) {
        if (null != this.columns) {
            for (String key : keys) {
                Column column = this.columns.get(key.toUpperCase());
                if (null == column) {
                    throw new AnylineException("\u672a\u5339\u914d\u5230" + key + ",\u8bf7\u8bdc\u6dfb\u52a0\u5230columns");
                }
                column.setPrimaryKey(true);
            }
        } else {
            throw new AnylineException("\u8bf7\u5148\u8bbe\u7f6ecolumns");
        }
        return this;
    }

    public Table setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
        if (null != primaryKey) {
            primaryKey.setTable(this);
        }
        return this;
    }

    public Table addTag(Tag tag) {
        tag.setTable(this);
        if (null == this.tags) {
            this.tags = new LinkedHashMap();
        }
        this.tags.put(tag.getName(), tag);
        return this;
    }

    public Tag addTag(String name, String type) {
        return this.addTag(name, type, true, null);
    }

    public Tag addTag(String name, String type, Object value) {
        Tag tag = new Tag(name, type, value);
        this.addTag(tag);
        return tag;
    }

    public Tag addTag(String name, String type, boolean nullable, Object def) {
        Tag tag = new Tag();
        tag.setName(name);
        tag.setNullable(nullable);
        tag.setDefaultValue(def);
        tag.setTypeName(type);
        this.addTag(tag);
        return tag;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public Table setCatalog(String catalog) {
        this.catalog = catalog;
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public Table setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getName(boolean greedy) {
        String result = "";
        if (greedy) {
            if (BasicUtil.isNotEmpty((Object)this.catalog)) {
                result = this.catalog + ".";
            }
            if (BasicUtil.isNotEmpty((Object)this.schema)) {
                result = result + this.schema + ".";
            }
            result = result + this.name;
        } else {
            result = this.name;
        }
        return result;
    }

    public Table setName(String name) {
        this.name = name;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Table setType(String type) {
        this.type = type;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public Table setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public String getTypeCat() {
        return this.typeCat;
    }

    public Table setTypeCat(String typeCat) {
        this.typeCat = typeCat;
        return this;
    }

    public String getTypeSchema() {
        return this.typeSchema;
    }

    public Table setTypeSchema(String typeSchema) {
        this.typeSchema = typeSchema;
        return this;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Table setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public String getSelfReferencingColumn() {
        return this.selfReferencingColumn;
    }

    public Table setSelfReferencingColumn(String selfReferencingColumn) {
        this.selfReferencingColumn = selfReferencingColumn;
        return this;
    }

    public String getRefGeneration() {
        return this.refGeneration;
    }

    public Table setRefGeneration(String refGeneration) {
        this.refGeneration = refGeneration;
        return this;
    }

    public LinkedHashMap<String, Column> getColumns() {
        if (null == this.columns) {
            this.columns = new LinkedHashMap();
        }
        return this.columns;
    }

    public Table setColumns(LinkedHashMap<String, Column> columns) {
        this.columns = columns;
        if (null != columns) {
            for (Column column : columns.values()) {
                column.setTable(this);
            }
        }
        return this;
    }

    public LinkedHashMap<String, Tag> getTags() {
        if (null == this.tags) {
            this.tags = new LinkedHashMap();
        }
        return this.tags;
    }

    public Table setTags(LinkedHashMap<String, Tag> tags) {
        this.tags = tags;
        if (null != tags) {
            for (Column column : tags.values()) {
                column.setTable(this);
            }
        }
        return this;
    }

    public LinkedHashMap<String, Index> getIndexs() {
        if (null == this.indexs) {
            this.indexs = new LinkedHashMap();
        }
        return this.indexs;
    }

    public PrimaryKey getPrimaryKey() {
        if (null == this.primaryKey) {
            for (Column column : this.columns.values()) {
                if (column.isPrimaryKey() != 1) continue;
                if (null == this.primaryKey) {
                    this.primaryKey = new PrimaryKey();
                    this.primaryKey.setName(this.getName() + "_PK");
                    this.primaryKey.setTable(this);
                }
                this.primaryKey.addColumn(column);
            }
        }
        if (null == this.primaryKey) {
            for (Index index : this.indexs.values()) {
                if (!index.isPrimary()) continue;
                this.primaryKey = new PrimaryKey();
                this.primaryKey.setName(index.getName());
                this.primaryKey.setTable(this);
                this.primaryKey.setColumns(index.getColumns());
            }
        }
        return this.primaryKey;
    }

    public Table setIndexs(LinkedHashMap<String, Index> indexs) {
        this.indexs = indexs;
        return this;
    }

    public LinkedHashMap<String, Constraint> getConstraints() {
        if (null == this.constraints) {
            this.constraints = new LinkedHashMap();
        }
        return this.constraints;
    }

    public Table setConstraints(LinkedHashMap<String, Constraint> constraints) {
        this.constraints = constraints;
        return this;
    }

    public Column getColumn(String name) {
        if (null == this.columns) {
            return null;
        }
        return this.columns.get(name.toUpperCase());
    }

    public Column getTag(String name) {
        return this.tags.get(name.toUpperCase());
    }

    public String getEngine() {
        return this.engine;
    }

    public Table setEngine(String engine) {
        this.engine = engine;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public Table setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public String getCollate() {
        return this.collate;
    }

    public Table setCollate(String collate) {
        this.collate = collate;
        return this;
    }

    public DDListener getListener() {
        return this.listener;
    }

    public Table setListener(DDListener listener) {
        this.listener = listener;
        return this;
    }

    public AnylineService getService() {
        if (null != this.listener) {
            return this.listener.getService();
        }
        return null;
    }

    public Table setService(AnylineService service) {
        if (null != this.listener) {
            this.listener.setService(service);
        }
        return this;
    }

    public Table setCreater(JDBCAdapter adapter) {
        if (null != this.listener) {
            this.listener.setAdapter(adapter);
        }
        return this;
    }

    public Date getCheckSchemaTime() {
        return this.checkSchemaTime;
    }

    public void setCheckSchemaTime(Date checkSchemaTime) {
        this.checkSchemaTime = checkSchemaTime;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String toString() {
        return this.keyword + ":" + this.name;
    }

    public boolean isAutoDropColumn() {
        return this.autoDropColumn;
    }

    public void setAutoDropColumn(boolean autoDropColumn) {
        this.autoDropColumn = autoDropColumn;
    }

    static {
        ClassUtil.regImplement(org.anyline.entity.data.Table.class, Table.class);
    }
}

