/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.param.init;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigChain;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ParseResult;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.auto.init.DefaultAutoCondition;
import org.anyline.data.prepare.auto.init.DefaultAutoConditionChain;
import org.anyline.entity.Compare;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfig
implements Config {
    protected static final Logger log = LoggerFactory.getLogger(DefaultConfig.class);
    protected String text;
    protected List<Object> values;
    protected List<Object> orValues;
    protected boolean empty;
    protected ParseResult parser;
    protected boolean overCondition = true;
    protected boolean overValue = true;

    @Override
    public Object clone() {
        DefaultConfig config = new DefaultConfig();
        config.parser = this.parser;
        config.empty = this.empty;
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object value : this.values) {
            values.add(value);
        }
        config.values = values;
        return config;
    }

    public DefaultConfig() {
        this.parser = new ParseResult();
    }

    @Override
    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("join", this.getJoin());
        map.put("prefix", this.getPrefix());
        map.put("var", this.getVariable());
        map.put("key", this.getKey());
        map.put("compare", this.getCompare().getCode());
        map.put("values", this.values);
        return BeanUtil.map2json(map);
    }

    @Override
    public String cacheKey() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("prefix", this.getPrefix());
        map.put("compare", this.getCompare().getCode());
        map.put("values", this.values);
        return BeanUtil.map2json(map);
    }

    public DefaultConfig(String config) {
        this.parser = ConfigParser.parse(config, true);
    }

    @Override
    public void setValue(Map<String, Object> values) {
        try {
            this.values = ConfigParser.getValues(values, this.parser);
            this.empty = BasicUtil.isEmpty((boolean)true, this.values);
            this.setOrValue(values);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOrValue(Map<String, Object> values) {
        try {
            this.orValues = ConfigParser.getValues(values, this.parser.getOr());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<Object> getValues() {
        return this.values;
    }

    @Override
    public List<Object> getOrValues() {
        return this.orValues;
    }

    @Override
    public void addValue(Object value) {
        if (null == this.values) {
            this.values = new ArrayList<Object>();
        }
        if (null != value) {
            if (value instanceof Collection) {
                Collection list = (Collection)value;
                for (Object item : list) {
                    this.addValue(item);
                }
            } else if (value instanceof Object[]) {
                Object[] tmps;
                for (Object tmp : tmps = (Object[])value) {
                    this.addValue(tmp);
                }
            } else {
                this.values.add(value);
            }
        } else {
            this.values.add(value);
        }
    }

    @Override
    public void setValue(Object value) {
        this.values = new ArrayList<Object>();
        this.addValue(value);
    }

    public void setOrValue(Object value) {
        this.orValues = new ArrayList<Object>();
        this.addValue(value);
    }

    @Override
    public Condition createAutoCondition(ConditionChain chain) {
        Condition condition = null;
        if (this.isRequire() || !this.isEmpty()) {
            if (this instanceof ConfigChain) {
                condition = new DefaultAutoConditionChain((ConfigChain)((Object)this));
                condition.setJoin(this.getJoin());
                condition.setContainer(chain);
            } else if (null != this.text) {
                condition = new DefaultAutoCondition(this);
                condition.setRunText(this.text);
                condition.setContainer(chain);
                condition.setActive(true);
                condition.setVariableType(2);
            } else {
                condition = new DefaultAutoCondition(this).setOrCompare(this.getOrCompare()).setJoin(this.parser.getJoin());
                condition.setContainer(chain);
            }
        }
        return condition;
    }

    @Override
    public String getPrefix() {
        return this.parser.getPrefix();
    }

    @Override
    public void setPrefix(String prefix) {
        this.parser.setPrefix(prefix);
    }

    @Override
    public String getVariable() {
        return this.parser.getVar();
    }

    @Override
    public void setVariable(String variable) {
        this.parser.setVar(variable);
    }

    @Override
    public String getKey() {
        return this.parser.getKey();
    }

    @Override
    public void setKey(String key) {
        this.parser.setKey(key);
    }

    @Override
    public Compare getCompare() {
        return this.parser.getCompare();
    }

    @Override
    public void setCompare(Compare compare) {
        this.parser.setCompare(compare);
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    @Override
    public boolean isRequire() {
        return this.parser.isRequired();
    }

    @Override
    public void setRequire(boolean require) {
        this.parser.setRequired(require);
    }

    @Override
    public boolean isStrictRequired() {
        return this.parser.isStrictRequired();
    }

    @Override
    public void setStrictRequired(boolean strictRequired) {
        this.parser.setStrictRequired(strictRequired);
    }

    @Override
    public String getJoin() {
        return this.parser.getJoin();
    }

    @Override
    public void setJoin(String join) {
        this.parser.setJoin(join);
    }

    @Override
    public boolean isKeyEncrypt() {
        return this.parser.isKeyEncrypt();
    }

    @Override
    public boolean isValueEncrypt() {
        return this.parser.isValueEncrypt();
    }

    @Override
    public Compare getOrCompare() {
        ParseResult or = this.parser.getOr();
        if (null != or) {
            return or.getCompare();
        }
        return this.parser.getCompare();
    }

    @Override
    public void setOrCompare(Compare compare) {
        ParseResult or = this.parser.getOr();
        if (null != or) {
            or.setCompare(compare);
        }
    }

    public void setTable(String table) {
    }

    public String getTable() {
        return this.parser.getPrefix();
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean isOverCondition() {
        return this.overCondition;
    }

    @Override
    public void setOverCondition(boolean overCondition) {
        this.overCondition = overCondition;
    }

    @Override
    public boolean isOverValue() {
        return this.overValue;
    }

    @Override
    public void setOverValue(boolean overValue) {
        this.overValue = overValue;
    }
}

