/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import org.anyline.adapter.KeyAdapter;
import org.anyline.adapter.init.ConvertAdapter;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.Point;
import org.anyline.entity.data.DatabaseType;
import org.anyline.entity.metadata.ColumnType;
import org.anyline.util.Base64Util;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.DateUtil;

public enum StandardColumnType implements ColumnType
{
    CHAR("CHAR", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.PostgreSQL}, String.class, false, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            if (null == value) {
                value = def;
            }
            if (!(value instanceof String)) {
                value = value instanceof java.util.Date ? DateUtil.format((java.util.Date)((java.util.Date)value)) : value.toString();
            }
            if (!placeholder) {
                value = "'" + value + "'";
            }
            return value;
        }
    }
    ,
    NCHAR("NCHAR", new DatabaseType[]{DatabaseType.ORACLE, DatabaseType.MSSQL}, String.class, false, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    CLOB("CLOB", new DatabaseType[]{DatabaseType.ORACLE}, String.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    NCLOB("NCLOB", new DatabaseType[]{DatabaseType.ORACLE}, String.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    NVARCHAR("NVARCHAR", new DatabaseType[]{DatabaseType.MSSQL}, String.class, false, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    NVARCHAR2("NVARCHAR2", new DatabaseType[]{DatabaseType.ORACLE}, String.class, false, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    LONGTEXT("LONGTEXT", new DatabaseType[]{DatabaseType.MYSQL}, String.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    MEDIUMTEXT("MEDIUMTEXT", new DatabaseType[]{DatabaseType.MYSQL}, String.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    TEXT("TEXT", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.PostgreSQL, DatabaseType.SQLite}, String.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    NTEXT("NTEXT", new DatabaseType[]{DatabaseType.MSSQL}, String.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    TINYTEXT("TINYTEXT", new DatabaseType[]{DatabaseType.MYSQL}, String.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    VARCHAR("VARCHAR", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.PostgreSQL, DatabaseType.ORACLE}, String.class, false, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    VARCHAR2("VARCHAR2", new DatabaseType[]{DatabaseType.ORACLE}, String.class, false, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    SYSNAME("SYSNAME", new DatabaseType[]{DatabaseType.MSSQL}, String.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    UUID("UUID", new DatabaseType[]{DatabaseType.PostgreSQL}, String.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            if (null == value) {
                value = def;
            }
            if (null != value) {
                value = java.util.UUID.fromString(value.toString());
            }
            if (null == value) {
                value = def;
            }
            return value;
        }
    }
    ,
    UNIQUEIDENTIFIER("UNIQUEIDENTIFIER", new DatabaseType[]{DatabaseType.MSSQL}, String.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    BINARY("BINARY", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.MSSQL}, byte[].class, false, true),
    VARBINARY("VARBINARY", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.MSSQL}, byte[].class, false, true),
    JSON("JSON", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.PostgreSQL}, String.class, true, true){

        @Override
        public Object convert(Object value, Class target, Object def) {
            if (null == value) {
                return def;
            }
            Class transfer = this.transfer();
            Class compatible = this.compatible();
            try {
                JsonNode node;
                value = null == target ? ((node = BeanUtil.JSON_MAPPER.readTree(value.toString())).isArray() ? DataSet.parseJson((JsonNode)node) : DataRow.parseJson((JsonNode)node)) : super.convert(value, target, def);
            }
            catch (Exception e) {
                value = super.convert(value, target, def);
            }
            return value;
        }

        @Override
        public Object read(Object value, Object def, Class clazz) {
            if (null == value) {
                return value;
            }
            if (value.getClass() == clazz) {
                return value;
            }
            String str = value.toString().trim();
            try {
                JsonNode node = BeanUtil.JSON_MAPPER.readTree(str);
                if (null == clazz) {
                    if (node.isArray()) {
                        DataSet list = new ArrayList();
                        Iterator items = node.iterator();
                        boolean isDataRow = true;
                        while (items.hasNext()) {
                            JsonNode item = (JsonNode)items.next();
                            Object row = DataRow.parseJsonObject((KeyAdapter.KEY_CASE)KeyAdapter.KEY_CASE.CONFIG, (JsonNode)item);
                            if (!(row instanceof DataRow)) {
                                isDataRow = false;
                            }
                            list.add(row);
                        }
                        value = isDataRow ? DataSet.parse(list, (String[])new String[0]) : list;
                    } else {
                        value = DataRow.parseJson((JsonNode)node);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return value;
        }
    }
    ,
    XML("XML", new DatabaseType[]{DatabaseType.MSSQL}, String.class, true, true){}
    ,
    BIT("BIT", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.MSSQL}, Boolean.class, true, true),
    VARBIT("VARBIT", new DatabaseType[]{DatabaseType.PostgreSQL}, Byte[].class, true, true),
    SHORT("SHORT", new DatabaseType[0], Short.class, true, true),
    INT("INT", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.MSSQL}, Integer.class, true, true),
    LONG("LONG", new DatabaseType[]{DatabaseType.ORACLE}, String.class, true, true){}
    ,
    SERIAL("SERIAL", new DatabaseType[]{DatabaseType.PostgreSQL}, Integer.class, true, true),
    SERIAL2("SERIAL2", new DatabaseType[]{DatabaseType.PostgreSQL}, Integer.class, true, true),
    SERIAL4("SERIAL4", new DatabaseType[]{DatabaseType.PostgreSQL}, Integer.class, true, true),
    SERIAL8("SERIAL8", new DatabaseType[]{DatabaseType.PostgreSQL}, Long.class, true, true),
    SMALLSERIAL("SERIAL2", new DatabaseType[]{DatabaseType.PostgreSQL}, Integer.class, true, true),
    BIGSERIAL("SERIAL8", new DatabaseType[]{DatabaseType.PostgreSQL}, Long.class, true, true),
    INT2("INT2", new DatabaseType[]{DatabaseType.PostgreSQL}, Integer.class, true, true),
    INT4("INT4", new DatabaseType[]{DatabaseType.PostgreSQL}, Integer.class, true, true),
    INT8("INT8", new DatabaseType[]{DatabaseType.PostgreSQL}, Long.class, true, true),
    BIGINT("BIGINT", new DatabaseType[]{DatabaseType.MYSQL}, Long.class, true, true),
    MEDIUMINT("MEDIUMINT", new DatabaseType[]{DatabaseType.MYSQL}, Integer.class, true, true),
    INTEGER("MEDIUMINT", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.SQLite}, Integer.class, true, true),
    SMALLINT("SMALLINT", new DatabaseType[]{DatabaseType.MYSQL}, Integer.class, true, true),
    TINYINT("TINYINT", new DatabaseType[]{DatabaseType.MYSQL}, Integer.class, true, true){}
    ,
    BOOLEAN("BOOLEAN", new DatabaseType[]{DatabaseType.PostgreSQL}, Boolean.class, true, true),
    BOOL("BOOLEAN", new DatabaseType[]{DatabaseType.PostgreSQL}, Boolean.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return BOOLEAN.write(value, def, placeholder);
        }
    }
    ,
    DECIMAL("DECIMAL", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.PostgreSQL, DatabaseType.ORACLE}, BigDecimal.class, false, false){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            if (null == value) {
                value = def;
            }
            BigDecimal result = BasicUtil.parseDecimal((Object)value, null);
            if (null != def && null == result) {
                result = BasicUtil.parseDecimal((Object)def, null);
            }
            return result;
        }
    }
    ,
    DOUBLE("DOUBLE", new DatabaseType[]{DatabaseType.MYSQL}, Double.class, false, false){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            if (null == value) {
                value = def;
            }
            Double result = BasicUtil.parseDouble((Object)value, null);
            if (null != def && null == result) {
                result = BasicUtil.parseDouble((Object)def, null);
            }
            return result;
        }
    }
    ,
    FLOAT("FLOAT", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.ORACLE}, Float.class, false, false){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            if (null == value) {
                value = def;
            }
            Float result = BasicUtil.parseFloat((Object)value, null);
            if (null != def && null == result) {
                result = BasicUtil.parseFloat((Object)def, null);
            }
            return result;
        }
    }
    ,
    MS_FLOAT("FLOAT", new DatabaseType[]{DatabaseType.MSSQL}, Float.class, false, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return FLOAT.write(value, def, placeholder);
        }
    }
    ,
    FLOAT4("FLOAT4", new DatabaseType[]{DatabaseType.PostgreSQL}, Float.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return FLOAT.write(value, def, placeholder);
        }
    }
    ,
    ORACLE_FLOAT("FLOAT", new DatabaseType[]{DatabaseType.ORACLE}, BigDecimal.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return DECIMAL.write(value, def, placeholder);
        }
    }
    ,
    FLOAT8("FLOAT8", new DatabaseType[]{DatabaseType.PostgreSQL}, Double.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return DOUBLE.write(value, def, placeholder);
        }
    }
    ,
    BINARY_DOUBLE("BINARY_DOUBLE", new DatabaseType[]{DatabaseType.ORACLE}, Double.class, false, false){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return DOUBLE.write(value, def, placeholder);
        }
    }
    ,
    BINARY_FLOAT("BINARY_FLOAT", new DatabaseType[]{DatabaseType.ORACLE}, Float.class, false, false){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return DOUBLE.write(value, def, placeholder);
        }
    }
    ,
    MONEY("MONEY", new DatabaseType[]{DatabaseType.PostgreSQL}, BigDecimal.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return DECIMAL.write(value, def, placeholder);
        }
    }
    ,
    SMALLMONEY("SMALLMONEY", new DatabaseType[]{DatabaseType.MSSQL}, BigDecimal.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return DECIMAL.write(value, def, placeholder);
        }
    }
    ,
    NUMERIC("NUMERIC", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.SQLite}, BigDecimal.class, false, false){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return DECIMAL.write(value, def, placeholder);
        }
    }
    ,
    NUMBER("NUMBER", new DatabaseType[]{DatabaseType.ORACLE}, BigDecimal.class, false, false){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return DECIMAL.write(value, def, placeholder);
        }
    }
    ,
    REAL("REAL", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.SQLite}, Double.class, false, false){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return FLOAT.write(value, def, placeholder);
        }
    }
    ,
    DATE("DATE", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.PostgreSQL}, Date.class, false, false){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            java.util.Date date;
            if (null == value) {
                value = def;
            }
            if (null == (date = DateUtil.parse((Object)value)) && null != def) {
                date = DateUtil.parse((Object)def);
            }
            if (null != date) {
                value = placeholder ? new Date(date.getTime()) : "'" + DateUtil.format((java.util.Date)date, (String)"yyyy-MM-dd");
            }
            return value;
        }
    }
    ,
    DATETIME("DATETIME", new DatabaseType[]{DatabaseType.MYSQL}, LocalDateTime.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            java.util.Date date;
            if (null == value) {
                value = def;
            }
            if (null == (date = DateUtil.parse((Object)value)) && null != def) {
                date = DateUtil.parse((Object)def);
            }
            value = null != date ? (placeholder ? new Timestamp(date.getTime()) : "'" + DateUtil.format((java.util.Date)date) + "'") : null;
            return value;
        }
    }
    ,
    DATETIME2("DATETIME2", new DatabaseType[]{DatabaseType.MSSQL}, Timestamp.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    DATETIMEOFFSET("DATETIMEOFFSET", new DatabaseType[]{DatabaseType.MSSQL}, Timestamp.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    SMALLDATETIME("SMALLDATETIME", new DatabaseType[]{DatabaseType.MSSQL}, Timestamp.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    SQL_DATETIMEOFFSET("SQL_DATETIMEOFFSET", new DatabaseType[]{DatabaseType.MSSQL}, Timestamp.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    TIME("TIME", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.PostgreSQL}, Time.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            java.util.Date date;
            if (null == value) {
                value = def;
            }
            if (null == (date = DateUtil.parse((Object)value)) && null != def) {
                date = DateUtil.parse((Object)def);
            }
            value = null != date ? (placeholder ? new Time(date.getTime()) : "'" + DateUtil.format((java.util.Date)date, (String)"HH:mm:ss") + "'") : null;
            return value;
        }
    }
    ,
    TIMEZ("TIMEZ", new DatabaseType[]{DatabaseType.PostgreSQL}, Time.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return TIME.write(value, def, placeholder);
        }
    }
    ,
    TIMESTAMP("TIMESTAMP", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.PostgreSQL, DatabaseType.ORACLE}, Timestamp.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    TIMESTAMP_ZONE("TIMESTAMP", new DatabaseType[]{DatabaseType.PostgreSQL}, Timestamp.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    TIMESTAMP_LOCAL_ZONE("TIMESTAMP", new DatabaseType[]{DatabaseType.PostgreSQL}, Timestamp.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    YEAR("YEAR", new DatabaseType[]{DatabaseType.MYSQL}, Date.class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return DATE.write(value, def, placeholder);
        }
    }
    ,
    BLOB("BLOB", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.ORACLE, DatabaseType.SQLite}, byte[].class, true, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            if (clazz != byte[].class && clazz == String.class) {
                value = new String((byte[])value);
            }
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            if (null == value) {
                value = def;
            }
            if (!(value instanceof byte[]) && value instanceof String) {
                String str = (String)value;
                if (Base64Util.verify((String)str)) {
                    try {
                        value = Base64Util.decode((String)str);
                    }
                    catch (Exception e) {
                        value = str.getBytes();
                    }
                } else {
                    value = str.getBytes();
                }
            }
            return value;
        }
    }
    ,
    LONGBLOB("LONGBLOB", new DatabaseType[]{DatabaseType.MYSQL}, byte[].class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return BLOB.write(value, def, placeholder);
        }
    }
    ,
    MEDIUMBLOB("MEDIUMBLOB", new DatabaseType[]{DatabaseType.MYSQL}, byte[].class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return BLOB.write(value, def, placeholder);
        }
    }
    ,
    TINYBLOB("TINYBLOB", new DatabaseType[]{DatabaseType.MYSQL}, byte[].class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return BLOB.write(value, def, placeholder);
        }
    }
    ,
    MULTILINESTRING("MULTILINESTRING", new DatabaseType[]{DatabaseType.MYSQL}, byte[].class, true, true),
    BYTEA("BYTEA", new DatabaseType[]{DatabaseType.PostgreSQL}, byte[].class, true, true),
    JSONB("JSONB", new DatabaseType[]{DatabaseType.PostgreSQL}, byte[].class, true, true){

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return BLOB.write(value, def, placeholder);
        }
    }
    ,
    IMAGE("IMAGE", new DatabaseType[]{DatabaseType.MSSQL}, byte[].class, true, true),
    BFILE("BFILE", new DatabaseType[]{DatabaseType.ORACLE}, byte[].class, true, true),
    POINT("POINT", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.PostgreSQL}, Point.class, byte[].class, (Boolean)true, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            if (null == value) {
                return value;
            }
            Point point = BasicUtil.parsePoint((Object)value);
            if (null == clazz) {
                value = point;
            } else if (null != point) {
                if (clazz == Point.class) {
                    value = point;
                } else if (clazz == double[].class) {
                    value = BeanUtil.Double2double((Double[])point.getArray(), (double)0.0);
                } else if (clazz == Double[].class) {
                    value = point.getArray();
                } else if (clazz == byte[].class) {
                    value = point.bytes();
                }
            }
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            Double[] ds;
            if (null == value) {
                value = def;
            }
            if (value instanceof byte[]) {
                return value;
            }
            if (value instanceof Point) {
                value = ((Point)value).bytes();
            } else if (value instanceof double[]) {
                double[] ds2 = (double[])value;
                if (ds2.length == 2 && ds2.length >= 2) {
                    value = new Point(Double.valueOf(ds2[0]), Double.valueOf(ds2[1])).bytes();
                }
            } else if (value instanceof Double[] && (ds = (Double[])value).length == 2 && null != ds[0] && null != ds[1]) {
                value = new Point(ds[0], ds[1]).bytes();
            }
            return value;
        }
    }
    ,
    MULTIPOLYGON("MULTIPOLYGON", new DatabaseType[]{DatabaseType.MYSQL}, byte[].class, true, true),
    MULTIPOINT("MULTIPOINT", new DatabaseType[]{DatabaseType.MYSQL}, byte[].class, true, true),
    POLYGON("POLYGON", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.PostgreSQL}, byte[].class, true, true),
    GEOMETRY("GEOMETRY", new DatabaseType[]{DatabaseType.MYSQL}, byte[].class, true, true),
    GEOMETRYCOLLECTION("GEOMETRYCOLLECTION", new DatabaseType[]{DatabaseType.MYSQL}, byte[].class, true, true),
    HIERARCHYID("HIERARCHYID", new DatabaseType[]{DatabaseType.MSSQL}, byte[].class, true, true),
    LINE("LINE", new DatabaseType[]{DatabaseType.MYSQL, DatabaseType.PostgreSQL}, byte[].class, true, true),
    LSEG("LSEG", new DatabaseType[]{DatabaseType.PostgreSQL}, byte[].class, true, true),
    GEOGRAPHY("GEOGRAPHY", new DatabaseType[]{DatabaseType.MSSQL}, byte[].class, true, true),
    BOX("BOX", new DatabaseType[]{DatabaseType.PostgreSQL}, byte[].class, true, true),
    CIDR("CIDR", new DatabaseType[]{DatabaseType.PostgreSQL}, byte[].class, true, true),
    CIRCLE("CIRCLE", new DatabaseType[]{DatabaseType.PostgreSQL}, byte[].class, true, true),
    INET("INET", new DatabaseType[]{DatabaseType.PostgreSQL}, byte[].class, true, true),
    ENUM("ENUM", new DatabaseType[]{DatabaseType.MYSQL}, String.class, true, true),
    INTERVAL("INTERVAL", new DatabaseType[]{DatabaseType.PostgreSQL}, null, true, true),
    PATH("PATH", new DatabaseType[]{DatabaseType.PostgreSQL}, null, true, true),
    RAW("RAW", new DatabaseType[]{DatabaseType.ORACLE}, byte[].class, true, true),
    ROWID("ROWID", new DatabaseType[]{DatabaseType.ORACLE}, null, true, true),
    SET("SET", new DatabaseType[]{DatabaseType.MYSQL}, String.class, true, true),
    TSQUERY("TSQUERY", new DatabaseType[]{DatabaseType.PostgreSQL}, null, true, true),
    TSVECTOR("TSVECTOR", new DatabaseType[]{DatabaseType.PostgreSQL}, null, true, true),
    MACADDR("MACADDR", new DatabaseType[]{DatabaseType.PostgreSQL}, null, true, true),
    PG_SNAPSHOT("PG_SNAPSHOT", new DatabaseType[]{DatabaseType.PostgreSQL}, null, true, true),
    TXID_SNAPSHOT("TXID_SNAPSHOT", new DatabaseType[]{DatabaseType.PostgreSQL}, null, true, true),
    UROWID("UROWID", new DatabaseType[]{DatabaseType.ORACLE}, null, true, true),
    SQL_VARIANT("SQL_VARIANT", new DatabaseType[]{DatabaseType.MSSQL}, null, true, true);

    private final DatabaseType[] dbs;
    private final String name;
    private Class transfer;
    private final Class compatible;
    private final Boolean ignorePrecision;
    private final Boolean ignoreScale;

    private StandardColumnType(String name, DatabaseType[] dbs, Class transfer, Class compatible, Boolean ignorePrecision, Boolean ignoreScale) {
        this.name = name;
        this.dbs = dbs;
        this.transfer = transfer;
        this.compatible = compatible;
        this.ignorePrecision = ignorePrecision;
        this.ignoreScale = ignoreScale;
    }

    private StandardColumnType(String name, DatabaseType[] dbs, Class compatible, Boolean ignorePrecision, Boolean ignoreScale) {
        this.name = name;
        this.dbs = dbs;
        this.compatible = compatible;
        this.ignorePrecision = ignorePrecision;
        this.ignoreScale = ignoreScale;
    }

    public Object convert(Object value, Object def) {
        return this.convert(value, null, def);
    }

    public Object convert(Object value, Class target) {
        Object def = null;
        return this.convert(value, target, def);
    }

    public Object convert(Object value, Class target, Object def) {
        if (null == target) {
            target = this.compatible;
        }
        if (null != value) {
            if (value.getClass() == target) {
                return value;
            }
            if (null != this.transfer) {
                value = ConvertAdapter.convert((Object)value, (Class)this.transfer, (Object)def);
            }
            value = ConvertAdapter.convert((Object)value, (Class)target, (Object)def);
        }
        return value;
    }

    public Object convert(Object value, Object obj, Field field) {
        return this.convert(value, field.getType());
    }

    public Object read(Object value, Object def, Class clazz) {
        if (null == clazz) {
            clazz = this.transfer;
        }
        if (null == clazz) {
            clazz = this.compatible;
        }
        value = ConvertAdapter.convert((Object)value, (Class)clazz, (Object)def);
        return value;
    }

    public Object write(Object value, Object def, boolean placeholder) {
        if (null != value) {
            if (value.getClass() == this.compatible) {
                return value;
            }
            if (null != this.transfer) {
                value = ConvertAdapter.convert((Object)value, (Class)this.transfer, (Object)def);
            }
            value = ConvertAdapter.convert((Object)value, (Class)this.compatible, (Object)def);
        }
        return value;
    }

    public String getName() {
        return this.name;
    }

    public boolean ignorePrecision() {
        return this.ignorePrecision;
    }

    public boolean ignoreScale() {
        return this.ignoreScale;
    }

    public boolean support() {
        return true;
    }

    public Class compatible() {
        return this.compatible;
    }

    public Class transfer() {
        return this.transfer;
    }

    public DatabaseType[] dbs() {
        return this.dbs;
    }
}

