/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.cache;

import java.util.Hashtable;
import org.anyline.util.ConfigTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageLazyStore {
    private static final Logger log = LoggerFactory.getLogger(PageLazyStore.class);
    private static Hashtable<String, Integer> lazyTotal = new Hashtable();
    private static Hashtable<String, Long> lazyTime = new Hashtable();

    public static int getTotal(String key, long period) {
        Long fr = lazyTime.get(key);
        long age = -1L;
        if (null != fr && (age = System.currentTimeMillis() - fr) > period) {
            lazyTotal.remove(key);
            lazyTime.remove(key);
            if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                log.info("[\u8bb0\u5f55\u603b\u6570\u8fc7\u671f][key:{}][\u751f\u5b58:{}/{}]", new Object[]{key, age, period});
            }
            return 0;
        }
        Integer result = lazyTotal.get(key);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.info("[\u63d0\u53d6\u8bb0\u5f55\u603b\u6570][key:{}][total:{}][\u751f\u5b58:{}/{}]", new Object[]{key, result, age, period});
        }
        if (null == result) {
            return 0;
        }
        return result;
    }

    public static void setTotal(String key, int total) {
        Integer old = lazyTotal.get(key);
        if (null == old || old != total) {
            lazyTime.put(key, System.currentTimeMillis());
            lazyTotal.put(key, total);
            if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                log.warn("[\u91cd\u7f6e\u8bb0\u5f55\u603b\u6570][key:{}][old:{}][new:{}]", new Object[]{key, old, total});
            }
        } else if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u7f13\u5b58\u8bb0\u5f55\u603b\u6570][key:{}][total:{}]", (Object)key, (Object)total);
        }
    }
}

