/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.auto.init;

import java.util.ArrayList;
import java.util.List;
import org.anyline.data.entity.Join;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ParseResult;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.auto.AutoPrepare;
import org.anyline.data.prepare.auto.init.DefaultAutoCondition;
import org.anyline.data.prepare.auto.init.DefaultAutoConditionChain;
import org.anyline.data.prepare.init.DefaultPrepare;
import org.anyline.entity.Compare;
import org.anyline.entity.Order;
import org.anyline.util.BasicUtil;

public class DefaultAutoPrepare
extends DefaultPrepare
implements AutoPrepare {
    protected String datasoruce;
    protected String schema;
    protected String table;
    protected String distinct = "";
    protected String alias;
    protected List<String> columns = new ArrayList<String>();
    protected List<Join> joins = new ArrayList<Join>();

    public DefaultAutoPrepare() {
        this.chain = new DefaultAutoConditionChain();
    }

    @Override
    public RunPrepare init() {
        return this;
    }

    @Override
    public RunPrepare setDataSource(String table) {
        if (null == table) {
            return this;
        }
        this.table = table;
        this.parseTable();
        return this;
    }

    @Override
    public RunPrepare addCondition(boolean required, boolean strictRequired, String column, Object value, Compare compare) {
        if (null == this.chain) {
            this.chain = new DefaultAutoConditionChain();
        }
        DefaultAutoCondition condition = new DefaultAutoCondition(required, strictRequired, null, column, value, compare);
        this.chain.addCondition(condition);
        return this;
    }

    @Override
    public RunPrepare addCondition(boolean required, String column, Object value, Compare compare) {
        return this.addCondition(required, false, column, value, compare);
    }

    @Override
    public RunPrepare addCondition(String condition) {
        if (BasicUtil.isEmpty((Object)condition)) {
            return this;
        }
        if (condition.contains(":")) {
            ParseResult parser = ConfigParser.parse(condition, false);
            List<Object> value = ConfigParser.getValues(parser);
            this.addCondition(parser.isRequired(), parser.isStrictRequired(), parser.getVar(), value, parser.getCompare());
        } else {
            DefaultAutoCondition con = new DefaultAutoCondition(condition);
            this.chain.addCondition(con);
        }
        return this;
    }

    @Override
    public void addColumn(String columns) {
        if (BasicUtil.isEmpty((Object)columns)) {
            return;
        }
        if (null == this.columns) {
            this.columns = new ArrayList<String>();
        }
        if (columns.contains(",")) {
            this.parseMultColumns(columns);
        } else {
            this.columns.add(columns);
        }
    }

    protected void parseMultColumns(String src) {
        ArrayList<String> cols = new ArrayList<String>();
        while (src.contains("${")) {
            src = src.trim();
            int fr = src.indexOf("${");
            String tmp = "";
            if (0 == fr) {
                tmp = src.substring(0, src.indexOf("}") + 1);
                src = src.substring(src.indexOf("}") + 1);
            } else {
                tmp = src.substring(0, fr);
                src = src.substring(fr);
            }
            cols.add(tmp);
        }
        cols.add(src);
        for (String c : cols) {
            String[] cs;
            if (c.contains("${")) {
                this.columns.add(c);
                continue;
            }
            for (String item : cs = c.split(",")) {
                if ((item = item.trim()).length() <= 0) continue;
                this.columns.add(item);
            }
        }
    }

    public void parseTable() {
        if (null != this.table) {
            String[] tmps;
            if (this.table.startsWith("<")) {
                this.datasoruce = this.table.substring(1, this.table.indexOf(">"));
                this.table = this.table.substring(this.table.indexOf(">") + 1);
            }
            String tag = " as ";
            String lower = this.table.toLowerCase();
            int tagIdx = lower.lastIndexOf(tag);
            if (tagIdx > 0 && !this.table.substring(tagIdx + tag.length()).contains(")")) {
                this.alias = this.table.substring(tagIdx + tag.length()).trim();
                this.table = this.table.substring(0, tagIdx).trim();
            }
            if (this.table.contains("(")) {
                String colStr = this.table.substring(this.table.indexOf("(") + 1, this.table.lastIndexOf(")")).trim();
                if (colStr.toLowerCase().startsWith("distinct")) {
                    this.distinct = "distinct";
                    colStr = colStr.substring(9).trim();
                }
                this.parseColumn(colStr);
                this.table = this.table.substring(0, this.table.indexOf("("));
            }
            if (null != this.table && this.table.contains(".")) {
                String[] tbs = this.table.split("\\.");
                this.table = tbs[1];
                this.schema = tbs[0];
            }
            if (this.table.contains(" ") && !(tmps = this.table.split(" "))[0].contains("(")) {
                this.table = tmps[0];
                this.alias = tmps[1];
            }
        }
    }

    private void parseColumn(String sql) {
        if (BasicUtil.isEmpty((Object)sql)) {
            return;
        }
        if (sql.contains("${")) {
            while (sql.contains("${")) {
                int to;
                int fr;
                String col;
                String pre = (sql = sql.trim()).substring(0, sql.indexOf("${"));
                if (BasicUtil.isNotEmpty((Object)pre)) {
                    String[] pres;
                    for (String item : pres = pre.split(",")) {
                        if (!BasicUtil.isNotEmpty((Object)(item = item.trim())) || this.columns.contains(item)) continue;
                        this.columns.add(item);
                    }
                }
                if (!this.columns.contains(col = sql.substring((fr = sql.indexOf("${")) + 2, to = sql.indexOf("}")).trim())) {
                    this.columns.add(col);
                }
                sql = sql.substring(sql.indexOf("}") + 1).trim();
            }
        } else {
            String[] cols;
            for (String item : cols = sql.split(",")) {
                if (!BasicUtil.isNotEmpty((Object)(item = item.trim())) || this.columns.contains(item)) continue;
                this.columns.add(item);
            }
        }
    }

    @Override
    public String getDataSource() {
        String ds = this.table;
        if (BasicUtil.isNotEmpty((Object)ds) && BasicUtil.isNotEmpty((Object)this.schema)) {
            ds = this.schema + "." + ds;
        }
        if (BasicUtil.isEmpty((Object)ds)) {
            ds = this.schema;
        }
        return ds;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public void setTable(String table) {
        this.table = table;
    }

    @Override
    public RunPrepare order(Order order) {
        return this;
    }

    @Override
    public ConditionChain getConditionChain() {
        return this.chain;
    }

    @Override
    public void createRunText(StringBuilder builder) {
    }

    @Override
    public String getDistinct() {
        return this.distinct;
    }

    @Override
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public List<Variable> getSQLVariables() {
        return null;
    }

    @Override
    public void setStrict(boolean strict) {
    }

    @Override
    public boolean isStrict() {
        return false;
    }

    @Override
    public List<Join> getJoins() {
        return this.joins;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }
}

