/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.jdbc.ds.DataSourceHolder;
import org.anyline.entity.data.DatabaseType;
import org.anyline.util.LogUtil;
import org.anyline.util.SpringContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Repository;

@Repository
public class SQLAdapterUtil {
    private static final Logger log = LoggerFactory.getLogger(SQLAdapterUtil.class);
    private static ConcurrentHashMap<String, JDBCAdapter> adapters = new ConcurrentHashMap();
    private static JDBCAdapter defaultAdapter = null;

    @Autowired(required=false)
    public void setAdapters(Map<String, JDBCAdapter> map) {
        for (JDBCAdapter adapter : map.values()) {
            adapters.put(adapter.type().getCode(), adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static JDBCAdapter getAdapter(JdbcTemplate template) {
        block12: {
            if (null != SQLAdapterUtil.defaultAdapter) {
                return SQLAdapterUtil.defaultAdapter;
            }
            if (SQLAdapterUtil.adapters.size() == 1) {
                SQLAdapterUtil.defaultAdapter = SQLAdapterUtil.adapters.values().iterator().next();
                return SQLAdapterUtil.defaultAdapter;
            }
            adapter = null;
            type = DataSourceHolder.dialect();
            if (null != type && null != (adapter = SQLAdapterUtil.getAdapter(type.getName()))) {
                return adapter;
            }
            ds = null;
            con = null;
            try {
                name = null;
                if (null != template && null == (adapter = SQLAdapterUtil.getAdapter(name = (meta = (con = DataSourceUtils.getConnection((DataSource)(ds = template.getDataSource()))).getMetaData()).getDatabaseProductName().toLowerCase().replace(" ", "")))) {
                    adapter = SQLAdapterUtil.getAdapter(meta.getURL().toLowerCase());
                }
                if (null != adapter) break block12;
                SQLAdapterUtil.log.warn("[\u68c0\u6d4b\u6570\u636e\u5e93\u9002\u914d\u5668][\u68c0\u6d4b\u5931\u8d25][\u53ef\u7528\u9002\u914d\u5668\u6570\u91cf:{}][\u68c0\u6d4b\u5176\u4ed6\u53ef\u7528\u7684\u9002\u914d\u5668]", (Object)SQLAdapterUtil.adapters.size());
                adapter = (JDBCAdapter)SpringContextUtil.getBean(JDBCAdapter.class);
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable var7_8) {
                    if (!DataSourceUtils.isConnectionTransactional(con, ds)) {
                        DataSourceUtils.releaseConnection(con, (DataSource)ds);
                    }
                    throw var7_8;
                }
                if (!DataSourceUtils.isConnectionTransactional(con, (DataSource)ds)) {
                    DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
                } else {
                    ** GOTO lbl33
                }
            }
        }
        if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
        }
        if (null == adapter) {
            SQLAdapterUtil.log.error("[\u68c0\u6d4b\u6570\u636e\u5e93\u9002\u914d\u5668][\u68c0\u6d4b\u5176\u4ed6\u53ef\u7528\u7684\u9002\u914d\u5668\u5931\u8d25][\u53ef\u7528\u9002\u914d\u5668\u6570\u91cf:{}][{}]", (Object)SQLAdapterUtil.adapters.size(), (Object)LogUtil.format((String)"\u53ef\u80fd\u6ca1\u6709\u4f9d\u8d56anyline-data-jdbc-*(\u5982mysql,neo4j)\u6216\u6ca1\u6709\u626b\u63cforg.anyline\u5305", (int)31));
        }
        return adapter;
    }

    private static JDBCAdapter getAdapter(String name) {
        JDBCAdapter adapter = null;
        adapter = adapters.get(name);
        if (null != adapter) {
            return adapter;
        }
        if (adapters.containsKey(DatabaseType.MYSQL.getCode()) && name.contains("mysql")) {
            adapter = adapters.get(DatabaseType.MYSQL.getCode());
        } else if (adapters.containsKey(DatabaseType.MSSQL.getCode()) && (name.contains("mssql") || name.contains("sqlserver"))) {
            adapter = adapters.get(DatabaseType.MSSQL.getCode());
        } else if (adapters.containsKey(DatabaseType.ORACLE.getCode()) && name.contains("oracle")) {
            adapter = adapters.get(DatabaseType.ORACLE.getCode());
        } else if (adapters.containsKey(DatabaseType.PostgreSQL.getCode()) && name.contains("postgresql")) {
            adapter = adapters.get(DatabaseType.PostgreSQL.getCode());
        } else if (adapters.containsKey(DatabaseType.ClickHouse.getCode()) && name.contains("clickhouse")) {
            adapter = adapters.get(DatabaseType.ClickHouse.getCode());
        } else if (adapters.containsKey(DatabaseType.DB2.getCode()) && name.contains("db2")) {
            adapter = adapters.get(DatabaseType.DB2.getCode());
        } else if (adapters.containsKey(DatabaseType.Derby.getCode()) && name.contains("derby")) {
            adapter = adapters.get(DatabaseType.Derby.getCode());
        } else if (adapters.containsKey(DatabaseType.DM.getCode()) && name.contains("dmdbms")) {
            adapter = adapters.get(DatabaseType.DM.getCode());
        } else if (adapters.containsKey(DatabaseType.HighGo.getCode()) && name.contains("hgdb") || name.contains("highgo")) {
            adapter = adapters.get(DatabaseType.HighGo.getCode());
        } else if (adapters.containsKey(DatabaseType.KingBase.getCode()) && name.contains("kingbase")) {
            adapter = adapters.get(DatabaseType.KingBase.getCode());
        } else if (adapters.containsKey(DatabaseType.OceanBase.getCode()) && name.contains("oceanbase")) {
            adapter = adapters.get(DatabaseType.OceanBase.getCode());
        } else if (adapters.containsKey(DatabaseType.PolarDB.getCode()) && name.contains("polardb")) {
            adapter = adapters.get(DatabaseType.PolarDB.getCode());
        } else if (adapters.containsKey(DatabaseType.SQLite.getCode()) && name.contains("sqlite")) {
            adapter = adapters.get(DatabaseType.SQLite.getCode());
        } else if (adapters.containsKey(DatabaseType.H2.getCode()) && name.contains(":h2:")) {
            adapter = adapters.get(DatabaseType.H2.getCode());
        } else if (adapters.containsKey(DatabaseType.HSQLDB.getCode()) && name.contains("hsqldb")) {
            adapter = adapters.get(DatabaseType.HSQLDB.getCode());
        } else if (adapters.containsKey(DatabaseType.TDengine.getCode()) && name.contains("taos")) {
            adapter = adapters.get(DatabaseType.TDengine.getCode());
        } else if (adapters.containsKey(DatabaseType.Neo4j.getCode()) && name.contains("neo4j")) {
            adapter = adapters.get(DatabaseType.Neo4j.getCode());
        }
        if (null != adapter) {
            adapters.put(name, adapter);
            log.warn("[\u68c0\u6d4b\u6570\u636e\u5e93\u9002\u914d\u5668][\u6839\u636eurl\u68c0\u6d4b\u5b8c\u6210][url:{}][\u9002\u914d\u5668:{}]", (Object)name, (Object)adapter);
        }
        return adapter;
    }
}

