/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.util;

import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.springframework.core.env.Environment;

public class DataSourceUtil {
    private static final String DATASOURCE_TYPE_DEFAULT = "com.zaxxer.hikari.HikariDataSource";

    public static DataSource buildDataSource(String prefix, Environment env) {
        try {
            String type;
            if (BasicUtil.isNotEmpty((Object)prefix) && !prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            if (null == (type = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"type"}))) {
                type = BeanUtil.value((String)"spring.datasource.", (Environment)env, (String[])new String[]{"type"});
            }
            if (type == null) {
                type = DATASOURCE_TYPE_DEFAULT;
            }
            Class<?> dataSourceType = Class.forName(type);
            String driverClassName = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"driver", "driver-class", "driver-class-name"});
            String url = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"url", "jdbc-url"});
            String username = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"user", "username", "user-name"});
            String password = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"password"});
            DataSource ds = (DataSource)dataSourceType.newInstance();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("url", url);
            map.put("jdbcUrl", url);
            map.put("driver", driverClassName);
            map.put("driverClass", driverClassName);
            map.put("driverClassName", driverClassName);
            map.put("user", username);
            map.put("username", username);
            map.put("password", password);
            BeanUtil.setFieldsValue((Object)ds, map);
            return ds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void setFieldsValue(Object obj, String prefix, Environment env) {
        List fields = ClassUtil.getFieldsName(obj.getClass());
        for (String field : fields) {
            String value = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{field});
            if (!BasicUtil.isNotEmpty((Object)value)) continue;
            BeanUtil.setFieldValue((Object)obj, (String)field, (Object)value);
        }
    }
}

