/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.adapter;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.adapter.EntityAdapter;
import org.anyline.data.adapter.DefaultJDBCAdapter;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.entity.Column;
import org.anyline.data.entity.Join;
import org.anyline.data.jdbc.ds.DataSourceHolder;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.auto.AutoPrepare;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.TableRun;
import org.anyline.data.run.TextRun;
import org.anyline.data.run.XMLRun;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.exception.SQLException;
import org.anyline.exception.SQLUpdateException;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.proxy.ServiceProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.anyline.util.SQLUtil;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public abstract class SQLAdapter
extends DefaultJDBCAdapter
implements JDBCAdapter {
    @Override
    public Run buildInsertRun(JdbcTemplate template, String dest, Object obj, boolean checkPrimary, List<String> columns) {
        return super.buildInsertRun(template, dest, obj, checkPrimary, columns);
    }

    @Override
    public void createInserts(JdbcTemplate template, Run run, String dest, DataSet set, List<String> keys) {
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        builder.append("INSERT INTO ").append(this.parseTable(dest));
        builder.append("(");
        int keySize = keys.size();
        for (int i = 0; i < keySize; ++i) {
            String key = keys.get(i);
            SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            if (i >= keySize - 1) continue;
            builder.append(",");
        }
        builder.append(") VALUES ");
        int dataSize = set.size();
        for (int i = 0; i < dataSize; ++i) {
            DataRow row = set.getRow(i);
            if (null == row) continue;
            if (row.hasPrimaryKeys() && BasicUtil.isEmpty((Object)row.getPrimaryValue())) {
                ArrayList<String> pks = row.getPrimaryKeys();
                if (null == pks) {
                    pks = new ArrayList<String>();
                }
                if (pks.size() == 0) {
                    pks.add(ConfigTable.DEFAULT_PRIMARY_KEY);
                }
                this.createPrimaryValue(row, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pks, null);
            }
            this.insertValue(template, run, row, true, false, true, keys);
            if (i >= dataSize - 1) continue;
            builder.append(this.batchInsertSeparator());
        }
    }

    @Override
    public void createInserts(JdbcTemplate template, Run run, String dest, Collection list, List<String> keys) {
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            this.createInserts(template, run, dest, set, keys);
            return;
        }
        builder.append("INSERT INTO ").append(this.parseTable(dest));
        builder.append("(");
        int keySize = keys.size();
        for (int i = 0; i < keySize; ++i) {
            String key = keys.get(i);
            SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            if (i >= keySize - 1) continue;
            builder.append(",");
        }
        builder.append(") VALUES ");
        int dataSize = list.size();
        int idx = 0;
        for (Object obj : list) {
            if (obj instanceof DataRow) {
                DataRow row = (DataRow)obj;
                if (row.hasPrimaryKeys() && BasicUtil.isEmpty((Object)row.getPrimaryValue())) {
                    this.createPrimaryValue(row, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), row.getPrimaryKeys(), null);
                }
                this.insertValue(template, run, row, true, false, true, keys);
            } else {
                if (EntityAdapterProxy.hasAdapter()) {
                    EntityAdapterProxy.createPrimaryValue(obj);
                } else {
                    this.createPrimaryValue(obj, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), null, null);
                }
                this.insertValue(template, run, obj, true, false, true, keys);
            }
            if (idx < dataSize - 1) {
                builder.append(this.batchInsertSeparator());
            }
            ++idx;
        }
    }

    @Override
    protected Run createInsertRun(JdbcTemplate template, String dest, Object obj, boolean checkPrimary, List<String> columns) {
        TableRun run = new TableRun(this, dest);
        StringBuilder builder = new StringBuilder();
        if (BasicUtil.isEmpty((Object)dest)) {
            throw new SQLException("\u672a\u6307\u5b9a\u8868");
        }
        int from = 1;
        StringBuilder valuesBuilder = new StringBuilder();
        DataRow row = null;
        if (obj instanceof DataRow) {
            row = (DataRow)obj;
            if (row.hasPrimaryKeys()) {
                this.createPrimaryValue(row, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), row.getPrimaryKeys(), null);
            }
        } else {
            from = 2;
            Object pk = null;
            Object pv = null;
            if (EntityAdapterProxy.hasAdapter()) {
                EntityAdapterProxy.createPrimaryValue((Object)obj);
            } else {
                this.createPrimaryValue(obj, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), null, null);
            }
        }
        run.setFrom(from);
        List<String> keys = this.confirmInsertColumns(dest, obj, columns, false);
        if (null == keys || keys.size() == 0) {
            throw new SQLException("\u672a\u6307\u5b9a\u5217(DataRow\u6216Entity\u4e2d\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u5c5e\u6027\u503c)[" + obj.getClass().getName() + ":" + BeanUtil.object2json((Object)obj) + "]");
        }
        builder.append("INSERT INTO ").append(this.parseTable(dest));
        builder.append("(");
        valuesBuilder.append(") VALUES (");
        ArrayList<String> insertColumns = new ArrayList<String>();
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            String key = keys.get(i);
            Object value = null;
            value = null != row ? row.get(key) : (EntityAdapterProxy.hasAdapter() ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key));
            String str = null;
            if (value instanceof String) {
                str = (String)value;
            }
            SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            if (null != str && str.startsWith("${") && str.endsWith("}")) {
                value = str.substring(2, str.length() - 1);
                valuesBuilder.append(value);
            } else if (null != value && value instanceof JDBCAdapter.SQL_BUILD_IN_VALUE) {
                value = this.value((JDBCAdapter.SQL_BUILD_IN_VALUE)((Object)value));
                valuesBuilder.append(value);
            } else {
                insertColumns.add(key);
                if (this.supportInsertPlaceholder()) {
                    valuesBuilder.append("?");
                    if ("NULL".equals(value)) {
                        value = null;
                    }
                    this.addRunValue(run, Compare.EQUAL, key, value);
                } else {
                    valuesBuilder.append(this.write(null, value, false));
                }
            }
            if (i >= size - 1) continue;
            builder.append(",");
            valuesBuilder.append(",");
        }
        valuesBuilder.append(")");
        builder.append((CharSequence)valuesBuilder);
        run.setBuilder(builder);
        run.setInsertColumns(insertColumns);
        return run;
    }

    @Override
    protected Run createInsertRunFromCollection(JdbcTemplate template, String dest, Collection list, boolean checkPrimary, List<String> columns) {
        TableRun run = new TableRun(this, dest);
        if (null == list || list.size() == 0) {
            throw new SQLException("\u7a7a\u6570\u636e");
        }
        DataRow first = null;
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            first = set.getRow(0);
            if (BasicUtil.isEmpty((Object)dest)) {
                dest = DataSourceHolder.parseDataSource(dest, set);
            }
            if (BasicUtil.isEmpty((Object)dest)) {
                dest = DataSourceHolder.parseDataSource(dest, first);
            }
        } else {
            first = (DataRow)list.iterator().next();
            if (BasicUtil.isEmpty((Object)dest) && EntityAdapterProxy.hasAdapter()) {
                dest = EntityAdapterProxy.table(first.getClass()).getName();
            }
        }
        if (BasicUtil.isEmpty((Object)dest)) {
            throw new SQLException("\u672a\u6307\u5b9a\u8868");
        }
        List<String> keys = this.confirmInsertColumns(dest, first, columns, true);
        if (null == keys || keys.size() == 0) {
            throw new SQLException("\u672a\u6307\u5b9a\u5217(DataRow\u6216Entity\u4e2d\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u5c5e\u6027\u503c)[" + first.getClass().getName() + ":" + BeanUtil.object2json((Object)first) + "]");
        }
        this.createInserts(template, (Run)run, dest, list, keys);
        return run;
    }

    protected void insertValue(JdbcTemplate template, Run run, Object obj, boolean placeholder, boolean alias, boolean scope, List<String> keys) {
        StringBuilder builder = run.getBuilder();
        int keySize = keys.size();
        if (scope) {
            builder.append("(");
        }
        int from = 1;
        if (obj instanceof DataRow) {
            from = 1;
        }
        run.setFrom(from);
        for (int i = 0; i < keySize; ++i) {
            boolean place = placeholder;
            String key = keys.get(i);
            Object value = null;
            value = obj instanceof DataRow ? BeanUtil.getFieldValue((Object)obj, (String)key) : BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key));
            if (value != null) {
                String str;
                if (value instanceof JDBCAdapter.SQL_BUILD_IN_VALUE) {
                    place = false;
                } else if (value instanceof String && (str = (String)value).startsWith("${") && str.endsWith("}")) {
                    place = false;
                }
            }
            if (place) {
                builder.append("?");
                this.addRunValue(run, Compare.EQUAL, key, value);
            } else {
                builder.append(this.write(null, obj, false));
            }
            if (alias) {
                builder.append(" AS ").append(key);
            }
            if (i >= keySize - 1) continue;
            builder.append(",");
        }
        if (scope) {
            builder.append(")");
        }
    }

    public String getPrimayKey(Object obj) {
        String key = null;
        if (obj instanceof Collection) {
            obj = ((Collection)obj).iterator().next();
        }
        key = obj instanceof DataRow ? ((DataRow)obj).getPrimaryKey() : EntityAdapterProxy.primaryKey(obj.getClass()).getName();
        return key;
    }

    @Override
    public int insert(JdbcTemplate template, String random, Object data, final String sql, final List<Object> values, final String[] pks) throws Exception {
        int cnt = 0;
        GeneratedKeyHolder keyholder = new GeneratedKeyHolder();
        cnt = template.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws java.sql.SQLException {
                PreparedStatement ps = null;
                ps = null != pks && pks.length > 0 ? con.prepareStatement(sql, pks) : con.prepareStatement(sql, 1);
                int idx = 0;
                if (null != values) {
                    for (Object obj : values) {
                        ps.setObject(++idx, obj);
                    }
                }
                return ps;
            }
        }, (KeyHolder)keyholder);
        this.identity(random, data, (KeyHolder)keyholder);
        return cnt;
    }

    @Override
    public boolean identity(String random, Object data, KeyHolder keyholder) {
        block16: {
            try {
                if (null == keyholder) {
                    return false;
                }
                List keys = keyholder.getKeyList();
                String id_key = this.generatedKey();
                if (null == id_key && keys.size() > 0) {
                    Map key = (Map)keys.get(0);
                    id_key = (String)key.keySet().iterator().next();
                }
                if (data instanceof Collection) {
                    Long num;
                    Object last;
                    Object item;
                    ArrayList ids = new ArrayList();
                    Collection list = (Collection)data;
                    Iterator iterator = list.iterator();
                    if (iterator.hasNext() && BasicUtil.isNotEmpty((Object)this.getPrimaryValue(item = iterator.next()))) {
                        return true;
                    }
                    if (BasicUtil.isEmpty((Object)id_key)) {
                        return false;
                    }
                    int i = 0;
                    int data_size = list.size();
                    if (list.size() == keys.size()) {
                        for (Object item2 : list) {
                            Map key = (Map)keys.get(i);
                            Object id = key.get(id_key);
                            ids.add(id);
                            this.setPrimaryValue(item2, id);
                            ++i;
                        }
                    } else if (null != keys && keys.size() > 0 && (last = ((Map)keys.get(0)).get(id_key)) instanceof Number && null != (num = BasicUtil.parseLong((Object)last.toString(), null))) {
                        num = num - (long)data_size + 1L;
                        for (Object item3 : list) {
                            Long l = num;
                            Long l2 = num = Long.valueOf(num + 1L);
                            this.setPrimaryValue(item3, l);
                        }
                    }
                    if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                        log.warn("{}[exe insert][\u751f\u6210\u4e3b\u952e:{}]", (Object)random, ids);
                    }
                    break block16;
                }
                if (null != keys && keys.size() > 0 && BasicUtil.isEmpty((Object)this.getPrimaryValue(data))) {
                    Object id = ((Map)keys.get(0)).get(id_key);
                    this.setPrimaryValue(data, id);
                    if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                        log.warn("{}[exe insert][\u751f\u6210\u4e3b\u952e:{}]", (Object)random, id);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                    log.warn("{}[exe insert][\u8fd4\u56de\u4e3b\u952e\u5931\u8d25]", (Object)random);
                }
                return false;
            }
        }
        return true;
    }

    protected boolean isMultipleValue(TableRun run, String key) {
        LinkedHashMap<String, Column> columns;
        String table = run.getTable();
        if (null != table && null != (columns = ServiceProxy.metadata().columns(table))) {
            Column column = columns.get(key.toUpperCase());
            return this.isMultipleValue(column);
        }
        return false;
    }

    protected boolean isMultipleValue(Column column) {
        String type;
        return null != column && ((type = column.getTypeName().toUpperCase()).contains("POINT") || type.contains("GEOMETRY") || type.contains("POLYGON"));
    }

    @Override
    protected Run buildUpdateRunFromEntity(String dest, Object obj, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        TableRun run = new TableRun(this, dest);
        run.setFrom(2);
        StringBuilder builder = run.getBuilder();
        List<Object> keys = new ArrayList();
        ArrayList<Object> primaryKeys = new ArrayList<Object>();
        if (null != columns && columns.size() > 0) {
            keys = columns;
        } else if (EntityAdapterProxy.hasAdapter()) {
            keys.addAll(EntityAdapterProxy.columns(obj.getClass(), (EntityAdapter.MODE)EntityAdapter.MODE.UPDATE).keySet());
        }
        if (EntityAdapterProxy.hasAdapter()) {
            primaryKeys.addAll(EntityAdapterProxy.primaryKeys(obj.getClass()).keySet());
        } else {
            primaryKeys = new ArrayList();
            primaryKeys.add(DataRow.DEFAULT_PRIMARY_KEY);
        }
        for (String string : primaryKeys) {
            if (columns.contains(string)) continue;
            keys.remove(string);
        }
        if (!columns.contains(DataRow.DEFAULT_PRIMARY_KEY)) {
            keys.remove(DataRow.DEFAULT_PRIMARY_KEY);
        }
        keys = this.checkMetadata(dest, keys);
        keys = BeanUtil.distinct(keys);
        ArrayList<String> updateColumns = new ArrayList<String>();
        int n = keys.size();
        if (n > 0) {
            builder.append("UPDATE ").append(this.parseTable(dest));
            builder.append(" SET").append("\n\t");
            boolean first = true;
            for (int i = 0; i < n; ++i) {
                String string = (String)keys.get(i);
                Object value = null;
                if (EntityAdapterProxy.hasAdapter()) {
                    Field field = EntityAdapterProxy.field(obj.getClass(), (String)string);
                    value = BeanUtil.getFieldValue((Object)obj, (Field)field);
                } else {
                    value = BeanUtil.getFieldValue((Object)obj, (String)string);
                }
                if (null != value && value.toString().startsWith("${") && value.toString().endsWith("}")) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                    if (!first) {
                        builder.append(",");
                    }
                    SQLUtil.delimiter((StringBuilder)builder, (String)string, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ").append(value).append("\n\t");
                    first = false;
                    continue;
                }
                if ("NULL".equals(value)) {
                    value = null;
                }
                boolean chk = true;
                if (null == value) {
                    if (!ConfigTable.IS_UPDATE_NULL_FIELD) {
                        chk = false;
                    }
                } else if ("".equals(value) && !ConfigTable.IS_UPDATE_EMPTY_FIELD) {
                    chk = false;
                }
                if (!chk) continue;
                if (!first) {
                    builder.append(",");
                }
                first = false;
                SQLUtil.delimiter((StringBuilder)builder, (String)string, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ?").append("\n\t");
                updateColumns.add(string);
                Compare compare = Compare.EQUAL;
                if (this.isMultipleValue(run, string)) {
                    compare = Compare.IN;
                }
                this.addRunValue(run, compare, string, value);
            }
            builder.append("\n");
            builder.append("\nWHERE 1=1").append("\n\t");
            if (null == configs) {
                for (String string : primaryKeys) {
                    builder.append(" AND ");
                    SQLUtil.delimiter((StringBuilder)builder, (String)string, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ?");
                    updateColumns.add(string);
                    if (EntityAdapterProxy.hasAdapter()) {
                        Field field = EntityAdapterProxy.field(obj.getClass(), (String)string);
                        this.addRunValue(run, Compare.EQUAL, string, BeanUtil.getFieldValue((Object)obj, (Field)field));
                        continue;
                    }
                    this.addRunValue(run, Compare.EQUAL, string, BeanUtil.getFieldValue((Object)obj, (String)string));
                }
            } else {
                run.setConfigStore(configs);
                run.init();
                run.appendCondition();
            }
        }
        run.setUpdateColumns(updateColumns);
        return run;
    }

    @Override
    protected Run buildUpdateRunFromDataRow(String dest, DataRow row, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        TableRun run = new TableRun(this, dest);
        run.setFrom(1);
        StringBuilder builder = run.getBuilder();
        List<String> keys = this.confirmUpdateColumns(dest, row, configs, columns);
        List primaryKeys = row.getPrimaryKeys();
        if (primaryKeys.size() == 0) {
            throw new SQLUpdateException("[\u66f4\u65b0\u66f4\u65b0\u5f02\u5e38][\u66f4\u65b0\u6761\u4ef6\u4e3a\u7a7a,update\u65b9\u6cd5\u4e0d\u652f\u6301\u66f4\u65b0\u6574\u8868\u64cd\u4f5c]");
        }
        for (String pk : primaryKeys) {
            if (columns.contains(pk)) continue;
            keys.remove(pk);
        }
        if (!columns.contains(DataRow.DEFAULT_PRIMARY_KEY)) {
            keys.remove(DataRow.DEFAULT_PRIMARY_KEY);
        }
        ArrayList<String> updateColumns = new ArrayList<String>();
        int size = keys.size();
        if (size > 0) {
            builder.append("UPDATE ").append(this.parseTable(dest));
            builder.append(" SET").append("\n\t");
            for (int i = 0; i < size; ++i) {
                String key = keys.get(i);
                Object value = row.get(key);
                if (null != value && value.toString().startsWith("${") && value.toString().endsWith("}")) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                    SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ").append(value).append("\n\t");
                } else {
                    SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ?").append("\n\t");
                    if ("NULL".equals(value)) {
                        value = null;
                    }
                    updateColumns.add(key);
                    Compare compare = Compare.EQUAL;
                    this.addRunValue(run, compare, key, value);
                }
                if (i >= size - 1) continue;
                builder.append(",");
            }
            builder.append("\n");
            builder.append("\nWHERE 1=1").append("\n\t");
            if (null == configs) {
                for (String pk : primaryKeys) {
                    builder.append(" AND ");
                    SQLUtil.delimiter((StringBuilder)builder, (String)pk, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ?");
                    updateColumns.add(pk);
                    this.addRunValue(run, Compare.EQUAL, pk, row.get(pk));
                }
            } else {
                run.setConfigStore(configs);
                run.init();
                run.appendCondition();
            }
        }
        run.setUpdateColumns(updateColumns);
        return run;
    }

    @Override
    public Object buildConditionLike(StringBuilder builder, Compare compare, Object value) {
        if (compare == Compare.LIKE) {
            builder.append(" LIKE ").append(this.concat("'%'", "?", "'%'"));
        } else if (compare == Compare.LIKE_PREFIX || compare == Compare.START_WITH) {
            builder.append(" LIKE ").append(this.concat("?", "'%'"));
        } else if (compare == Compare.LIKE_SUFFIX || compare == Compare.END_WITH) {
            builder.append(" LIKE ").append(this.concat("'%'", "?"));
        }
        return value;
    }

    @Override
    public Object buildConditionFindInSet(StringBuilder builder, String column, Compare compare, Object value) {
        log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 Object buildConditionFindInSet(StringBuilder builder, String column, Compare compare, Object value)"), (int)37));
        return null;
    }

    @Override
    public StringBuilder buildConditionIn(StringBuilder builder, Compare compare, Object value) {
        if (compare == Compare.NOT_IN) {
            builder.append(" NOT");
        }
        builder.append(" IN (");
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                builder.append("?");
                if (i >= size - 1) continue;
                builder.append(",");
            }
            builder.append(")");
        } else {
            builder.append("= ?");
        }
        return builder;
    }

    @Override
    protected void buildQueryRunContent(XMLRun run) {
    }

    @Override
    protected void buildQueryRunContent(TextRun run) {
        this.replaceVariable(run);
        run.appendCondition();
        run.appendGroup();
        run.checkValid();
    }

    protected void replaceVariable(TextRun run) {
        StringBuilder builder = run.getBuilder();
        RunPrepare prepare = run.getPrepare();
        List<Variable> variables = run.getVariables();
        String result = prepare.getText();
        if (null != variables) {
            List<Object> varValues;
            String value;
            List<Object> values;
            for (Variable var : variables) {
                if (null == var || var.getType() != 3) continue;
                values = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, values)) {
                    value = var.getCompare() == Compare.IN ? BeanUtil.concat((Collection)BeanUtil.wrap(values, (String)"'")) : values.get(0).toString();
                }
                if (null != value) {
                    result = result.replace(var.getFullKey(), value);
                    continue;
                }
                result = result.replace(var.getFullKey(), "NULL");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 2) continue;
                values = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, values)) {
                    value = var.getCompare() == Compare.IN ? BeanUtil.concat((Collection)BeanUtil.wrap(values, (String)"'")) : values.get(0).toString();
                }
                if (null != value) {
                    result = result.replace(var.getFullKey(), value);
                    continue;
                }
                result = result.replace(var.getFullKey(), "");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 1) continue;
                varValues = var.getValues();
                if (BasicUtil.isNotEmpty((boolean)true, varValues)) {
                    if (var.getCompare() == Compare.IN) {
                        String replaceDst = "";
                        for (Object tmp : varValues) {
                            replaceDst = replaceDst + " ?";
                        }
                        this.addRunValue(run, Compare.IN, var.getKey(), varValues);
                        replaceDst = replaceDst.trim().replace(" ", ",");
                        result = result.replace(var.getFullKey(), replaceDst);
                        continue;
                    }
                    result = result.replace(var.getFullKey(), "?");
                    this.addRunValue(run, Compare.EQUAL, var.getKey(), varValues.get(0));
                    continue;
                }
                result = result.replace(var.getFullKey(), "NULL");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 0) continue;
                varValues = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, varValues)) {
                    value = (String)varValues.get(0);
                }
                this.addRunValue(run, Compare.EQUAL, var.getKey(), value);
            }
        }
        builder.append(result);
    }

    @Override
    protected void buildQueryRunContent(TableRun run) {
        List<Join> joins;
        StringBuilder builder = run.getBuilder();
        TablePrepare sql = (TablePrepare)run.getPrepare();
        builder.append("SELECT ");
        if (null != sql.getDistinct()) {
            builder.append(sql.getDistinct());
        }
        builder.append("\n\t");
        List<String> columns = sql.getColumns();
        if (null != columns && columns.size() > 0) {
            int size = columns.size();
            for (int i = 0; i < size; ++i) {
                String column = columns.get(i);
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("${") && column.endsWith("}")) {
                    column = column.substring(2, column.length() - 1);
                    builder.append(column);
                } else if (column.toUpperCase().contains(" AS ") || column.contains("(") || column.contains(",")) {
                    builder.append(column);
                } else if ("*".equals(column)) {
                    builder.append("*");
                } else {
                    SQLUtil.delimiter((StringBuilder)builder, (String)column, (String)this.delimiterFr, (String)this.delimiterTo);
                }
                if (i >= size - 1) continue;
                builder.append(",");
            }
            builder.append("\n");
        } else {
            builder.append("*");
            builder.append("\n");
        }
        builder.append("FROM").append("\n\t");
        if (null != run.getSchema()) {
            SQLUtil.delimiter((StringBuilder)builder, (String)run.getSchema(), (String)this.delimiterFr, (String)this.delimiterTo).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)run.getTable(), (String)this.delimiterFr, (String)this.delimiterTo);
        builder.append("\n");
        if (BasicUtil.isNotEmpty((Object)sql.getAlias())) {
            builder.append("  ").append(sql.getAlias());
        }
        if (null != (joins = sql.getJoins())) {
            for (Join join : joins) {
                builder.append("\n\t").append(join.getType().getCode()).append(" ");
                if (null != join.getSchema()) {
                    SQLUtil.delimiter((StringBuilder)builder, (String)join.getSchema(), (String)this.delimiterFr, (String)this.delimiterTo).append(".");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)join.getName(), (String)this.delimiterFr, (String)this.delimiterTo);
                if (BasicUtil.isNotEmpty((Object)join.getAlias())) {
                    builder.append("  ").append(join.getAlias());
                }
                builder.append(" ON ").append(join.getCondition());
            }
        }
        builder.append("\nWHERE 1=1\n\t");
        run.appendCondition();
        run.appendGroup();
        run.appendOrderStore();
        run.checkValid();
    }

    @Override
    public String parseExists(Run run) {
        String sql = "SELECT EXISTS(\n" + run.getBuilder().toString() + "\n)  IS_EXISTS";
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE ");
        return sql;
    }

    @Override
    protected void buildExecuteRunContent(TextRun run) {
        this.replaceVariable(run);
        run.appendCondition();
        run.appendGroup();
        run.checkValid();
    }

    @Override
    public String parseTotalQuery(Run run) {
        String sql = "SELECT COUNT(*) AS CNT FROM (\n" + run.getBuilder().toString() + "\n) F";
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE ");
        return sql;
    }

    @Override
    protected Run buildDeleteRunContent(TableRun run) {
        List<Join> joins;
        AutoPrepare prepare = (AutoPrepare)run.getPrepare();
        StringBuilder builder = run.getBuilder();
        builder.append("DELETE FROM ");
        if (null != run.getSchema()) {
            SQLUtil.delimiter((StringBuilder)builder, (String)run.getSchema(), (String)this.delimiterFr, (String)this.delimiterTo).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)run.getTable(), (String)this.delimiterFr, (String)this.delimiterTo);
        builder.append("\n");
        if (BasicUtil.isNotEmpty((Object)prepare.getAlias())) {
            builder.append("  ").append(prepare.getAlias());
        }
        if (null != (joins = prepare.getJoins())) {
            for (Join join : joins) {
                builder.append("\n\t").append(join.getType().getCode()).append(" ");
                if (null != join.getSchema()) {
                    SQLUtil.delimiter((StringBuilder)builder, (String)join.getSchema(), (String)this.delimiterFr, (String)this.delimiterTo).append(".");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)join.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                if (BasicUtil.isNotEmpty((Object)join.getAlias())) {
                    builder.append("  ").append(join.getAlias());
                }
                builder.append(" ON ").append(join.getCondition());
            }
        }
        builder.append("\nWHERE 1=1\n\t");
        run.appendCondition();
        run.appendGroup();
        run.appendOrderStore();
        run.checkValid();
        return run;
    }

    @Override
    protected Run createDeleteRunSQLFromTable(String table, String key, Object values) {
        if (null == table || null == key || null == values) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        TableRun run = new TableRun(this, table);
        builder.append("DELETE FROM ");
        SQLUtil.delimiter((StringBuilder)builder, (String)table, (String)this.delimiterFr, (String)this.delimiterTo);
        builder.append(" WHERE ");
        if (values instanceof Collection) {
            Collection cons = (Collection)values;
            SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            if (cons.size() > 1) {
                builder.append(" IN(");
                int idx = 0;
                for (Object obj : cons) {
                    if (idx > 0) {
                        builder.append(",");
                    }
                    builder.append("?");
                    ++idx;
                }
                builder.append(")");
            } else if (cons.size() == 1) {
                for (Object obj : cons) {
                    builder.append("=?");
                }
            } else {
                throw new SQLUpdateException("\u5220\u9664\u5f02\u5e38:\u5220\u9664\u6761\u4ef6\u4e3a\u7a7a,delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u6574\u8868\u64cd\u4f5c.");
            }
            this.addRunValue(run, Compare.IN, key, values);
        } else {
            SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            builder.append("=?");
            this.addRunValue(run, Compare.EQUAL, key, values);
        }
        run.setBuilder(builder);
        return run;
    }

    @Override
    protected Run createDeleteRunSQLFromEntity(String dest, Object obj, String ... columns) {
        TableRun run = new TableRun(this, dest);
        run.setFrom(2);
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM ");
        SQLUtil.delimiter((StringBuilder)builder, (String)this.parseTable(dest), (String)this.delimiterFr, (String)this.delimiterTo);
        builder.append(" WHERE ");
        List<String> keys = new ArrayList();
        if (null != columns && columns.length > 0) {
            for (String col : columns) {
                keys.add(col);
            }
        } else if (obj instanceof DataRow) {
            keys = ((DataRow)obj).getPrimaryKeys();
        } else if (EntityAdapterProxy.hasAdapter()) {
            keys.addAll(EntityAdapterProxy.primaryKeys(obj.getClass()).keySet());
        }
        int size = keys.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    builder.append("\nAND ");
                }
                String key = (String)keys.get(i);
                SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ? ");
                Object value = null;
                value = obj instanceof DataRow ? ((DataRow)obj).get(key) : (EntityAdapterProxy.hasAdapter() ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key));
                this.addRunValue(run, Compare.EQUAL, key, value);
            }
        } else {
            throw new SQLUpdateException("\u5220\u9664\u5f02\u5e38:\u5220\u9664\u6761\u4ef6\u4e3a\u7a7a,delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u6574\u8868\u64cd\u4f5c.");
        }
        run.setBuilder(builder);
        return run;
    }

    protected void addRunValue(Run run, Compare compare, String key, Object value) {
        if (null != value) {
            LinkedHashMap<String, Column> columns;
            String table;
            Column column = null;
            if (ConfigTable.IS_AUTO_CHECK_METADATA && null != (table = run.getTable()) && null != (columns = ServiceProxy.metadata().columns(table)) && null != (column = columns.get(key.toUpperCase()))) {
                value = this.convert(column, value);
            }
        }
        run.addValues(compare, key, value, ConfigTable.IS_AUTO_SPLIT_ARRAY);
    }

    protected String concatFun(String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            result = "concat(";
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + ",";
                }
                result = result + arg;
            }
            result = result + ")";
        }
        return result;
    }

    protected String concatOr(String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + " || ";
                }
                result = result + arg;
            }
        }
        return result;
    }

    protected String concatAdd(String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + " + ";
                }
                result = result + arg;
            }
        }
        return result;
    }
}

