/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.dao.init.springjdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.dao.AnylineDao;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.cache.PageLazyStore;
import org.anyline.data.entity.Constraint;
import org.anyline.data.entity.Database;
import org.anyline.data.entity.Index;
import org.anyline.data.entity.MasterTable;
import org.anyline.data.entity.PartitionTable;
import org.anyline.data.entity.PrimaryKey;
import org.anyline.data.entity.Table;
import org.anyline.data.entity.Tag;
import org.anyline.data.entity.View;
import org.anyline.data.jdbc.ds.DataSourceHolder;
import org.anyline.data.jdbc.ds.JDBCRuntime;
import org.anyline.data.jdbc.ds.RuntimeHolder;
import org.anyline.data.listener.DDListener;
import org.anyline.data.listener.DMListener;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.Procedure;
import org.anyline.data.prepare.ProcedureParam;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.prepare.auto.init.DefaultTextPrepare;
import org.anyline.data.run.Run;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.entity.data.Column;
import org.anyline.exception.AnylineException;
import org.anyline.exception.SQLQueryException;
import org.anyline.exception.SQLUpdateException;
import org.anyline.proxy.CacheProxy;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.anyline.util.regular.RegularUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.dao")
public class DefaultDao<E>
implements AnylineDao<E> {
    protected static final Logger log = LoggerFactory.getLogger(DefaultDao.class);
    @Autowired(required=false)
    protected DMListener listener;
    protected static boolean isBatchInsertRun = false;
    protected JDBCRuntime runtime = null;

    protected JDBCRuntime runtime() {
        if (null != this.runtime) {
            return this.runtime;
        }
        return RuntimeHolder.getRuntime();
    }

    public DMListener getListener() {
        return this.listener;
    }

    public void setListener(DMListener listener) {
        this.listener = listener;
    }

    public JDBCRuntime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(JDBCRuntime runtime) {
        this.runtime = runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> maps(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        List<Map<String, Object>> maps = null;
        try {
            boolean exe = true;
            if (null != this.listener) {
                exe = this.listener.beforeBuildQuery(prepare, configs, conditions);
            }
            if (!exe) {
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                return arrayList;
            }
            JDBCRuntime runtime = this.runtime();
            JDBCAdapter adapter = runtime.getAdapter();
            Run run = adapter.buildQueryRun(prepare, configs, conditions);
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled() && !run.isValid()) {
                String tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
                String src = "";
                src = prepare instanceof TablePrepare ? prepare.getTable() : prepare.getText();
                tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, src, configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + this.runtime().getKey() + "]";
                log.warn(tmp);
            }
            if (run.isValid()) {
                if (null != this.listener) {
                    this.listener.beforeQuery(run, -1);
                }
                Long fr = System.currentTimeMillis();
                maps = this.maps(runtime, run.getFinalQuery(), run.getValues());
                if (null != adapter) {
                    maps = adapter.process(maps);
                }
                if (null != this.listener) {
                    this.listener.afterQuery(run, maps, System.currentTimeMillis() - fr);
                }
            } else {
                maps = new ArrayList<Map<String, Object>>();
            }
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return maps;
    }

    @Override
    public List<Map<String, Object>> maps(RunPrepare prepare, String ... conditions) {
        return this.maps(prepare, (ConfigStore)null, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet querys(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        DataSet set = null;
        try {
            Long fr;
            boolean exe = true;
            if (null != this.listener) {
                exe = this.listener.beforeBuildQuery(prepare, configs, conditions);
            }
            if (!exe) {
                DataSet dataSet = new DataSet();
                return dataSet;
            }
            JDBCRuntime runtime = this.runtime();
            JDBCAdapter adapter = runtime.getAdapter();
            Run run = adapter.buildQueryRun(prepare, configs, conditions);
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled() && !run.isValid()) {
                String tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
                String src = "";
                src = prepare instanceof TablePrepare ? prepare.getTable() : prepare.getText();
                tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, src, configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + this.runtime().getKey() + "]";
                log.warn(tmp);
            }
            PageNavi navi = run.getPageNavi();
            int total = 0;
            if (run.isValid()) {
                if (null != navi) {
                    if (null != this.listener) {
                        this.listener.beforeTotal(run);
                    }
                    fr = System.currentTimeMillis();
                    if (navi.getLastRow() == 0) {
                        total = 1;
                    } else if (navi.getTotalRow() == 0) {
                        total = this.getTotal(run.getTotalQuery(), run.getValues());
                        navi.setTotalRow(total);
                    } else {
                        total = navi.getTotalRow();
                    }
                    if (null != this.listener) {
                        this.listener.afterTotal(run, total, System.currentTimeMillis() - fr);
                    }
                }
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("[\u67e5\u8be2\u8bb0\u5f55\u603b\u6570][\u884c\u6570:{}]", (Object)total);
                }
            }
            if (run.isValid()) {
                fr = System.currentTimeMillis();
                if (null == navi || total > 0) {
                    if (null != this.listener) {
                        this.listener.beforeQuery(run, total);
                    }
                    set = this.select(runtime, prepare.getTable(), run.getFinalQuery(), run.getValues());
                    if (null != this.listener) {
                        this.listener.afterQuery(run, set, System.currentTimeMillis() - fr);
                    }
                } else {
                    set = new DataSet();
                }
            } else {
                set = new DataSet();
            }
            set.setDataSource(prepare.getDataSource());
            set.setNavi(navi);
            if (null != navi && navi.isLazy()) {
                PageLazyStore.setTotal(navi.getLazyKey(), navi.getTotalRow());
            }
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return set;
    }

    @Override
    public <T> EntitySet<T> querys(Class<T> clazz, ConfigStore configs, String ... conditions) {
        DefaultTablePrepare prepare = new DefaultTablePrepare();
        return this.querys((RunPrepare)prepare, clazz, configs, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> EntitySet<T> querys(RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        EntitySet<T> list = null;
        try {
            Long fr;
            boolean exe = true;
            if (null != this.listener) {
                exe = this.listener.beforeBuildQuery(prepare, configs, conditions);
            }
            if (!exe) {
                EntitySet entitySet = new EntitySet();
                return entitySet;
            }
            if (BasicUtil.isEmpty((Object)prepare.getDataSource()) && EntityAdapterProxy.hasAdapter()) {
                prepare.setDataSource(EntityAdapterProxy.table(clazz).getName());
            }
            JDBCRuntime runtime = this.runtime();
            JDBCAdapter adapter = runtime.getAdapter();
            Run run = adapter.buildQueryRun(prepare, configs, conditions);
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled() && !run.isValid()) {
                String tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
                tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, clazz.getName(), configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + this.runtime().getKey() + "]";
                log.warn(tmp);
            }
            PageNavi navi = run.getPageNavi();
            int total = 0;
            if (run.isValid()) {
                if (null != navi) {
                    if (null != this.listener) {
                        this.listener.beforeTotal(run);
                    }
                    fr = System.currentTimeMillis();
                    if (navi.getLastRow() == 0) {
                        total = 1;
                    } else if (navi.getTotalRow() == 0) {
                        total = this.getTotal(run.getTotalQuery(), run.getValues());
                        navi.setTotalRow(total);
                    } else {
                        total = navi.getTotalRow();
                    }
                    if (null != this.listener) {
                        this.listener.afterTotal(run, total, System.currentTimeMillis() - fr);
                    }
                }
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("[\u67e5\u8be2\u8bb0\u5f55\u603b\u6570][\u884c\u6570:{}]", (Object)total);
                }
            }
            if (run.isValid()) {
                fr = System.currentTimeMillis();
                if (null == navi || total > 0) {
                    if (null != this.listener) {
                        this.listener.beforeQuery(run, total);
                    }
                    fr = System.currentTimeMillis();
                    list = this.select(runtime, clazz, run.getTable(), run.getFinalQuery(), run.getValues());
                    if (null != this.listener) {
                        this.listener.afterQuery(run, list, System.currentTimeMillis() - fr);
                    }
                } else {
                    list = new EntitySet();
                }
            } else {
                list = new EntitySet<T>();
            }
            list.setNavi(navi);
            if (null != navi && navi.isLazy()) {
                PageLazyStore.setTotal(navi.getLazyKey(), navi.getTotalRow());
            }
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return list;
    }

    @Override
    public DataSet querys(RunPrepare prepare, String ... conditions) {
        return this.querys(prepare, (ConfigStore)null, conditions);
    }

    @Override
    public DataSet selects(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.querys(prepare, configs, conditions);
    }

    @Override
    public DataSet selects(RunPrepare prepare, String ... conditions) {
        return this.querys(prepare, (ConfigStore)null, conditions);
    }

    @Override
    public DataRow sequence(boolean next, String ... names) {
        JDBCAdapter adapter;
        String sql;
        JDBCRuntime runtime = this.runtime();
        DataSet set = this.select(runtime, "", sql = (adapter = runtime.getAdapter()).buildQuerySequence(next, names), null);
        if (set.size() > 0) {
            return set.getRow(0);
        }
        return new DataRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        int count = -1;
        try {
            boolean exe = true;
            if (null != this.listener) {
                exe = this.listener.beforeBuildQuery(prepare, configs, conditions);
            }
            if (!exe) {
                int n = -1;
                return n;
            }
            JDBCRuntime runtime = this.runtime();
            JDBCAdapter adapter = runtime.getAdapter();
            Run run = adapter.buildQueryRun(prepare, configs, conditions);
            Long fr = System.currentTimeMillis();
            if (null != this.listener) {
                this.listener.beforeCount(run);
            }
            fr = System.currentTimeMillis();
            count = this.getTotal(run.getTotalQuery(), run.getValues());
            if (null != this.listener) {
                this.listener.afterCount(run, count, System.currentTimeMillis() - fr);
            }
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return count;
    }

    @Override
    public int count(RunPrepare prepare, String ... conditions) {
        return this.count(prepare, (ConfigStore)null, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        boolean result = false;
        try {
            boolean exe = true;
            if (null != this.listener) {
                exe = this.listener.beforeBuildQuery(prepare, configs, conditions);
            }
            if (!exe) {
                boolean bl = false;
                return bl;
            }
            JDBCRuntime runtime = this.runtime();
            JDBCAdapter adapter = runtime.getAdapter();
            Run run = adapter.buildQueryRun(prepare, configs, conditions);
            String txt = run.getFinalExists();
            List<Object> values = run.getValues();
            long fr = System.currentTimeMillis();
            String random = "";
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                random = this.random();
                log.warn("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, txt, this.paramLogFormat(values)});
            }
            try {
                if (null != this.listener) {
                    this.listener.beforeExists(run);
                }
                Map map = null;
                if (null == values || values.size() <= 0 || !BasicUtil.isEmpty((boolean)true, values)) {
                    map = null != values && values.size() > 0 ? runtime.getTemplate().queryForMap(txt, values.toArray()) : runtime.getTemplate().queryForMap(txt);
                    result = null == map ? false : BasicUtil.parseBoolean(map.get("IS_EXISTS"), (Boolean)false);
                }
                Long millis = System.currentTimeMillis() - fr;
                if (null != this.listener) {
                    this.listener.afterExists(run, result, millis);
                }
                boolean slow = false;
                if (ConfigTable.SLOW_SQL_MILLIS > 0L && millis > ConfigTable.SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[SLOW SQL][action:exists][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, txt, this.paramLogFormat(values)});
                    if (null != this.listener) {
                        this.listener.slow("exists", run, txt, values, null, millis);
                    }
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("{}[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((boolean)result, (int)34)});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                    log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), prepare, this.paramLogFormat(values)});
                }
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    throw e;
                }
            }
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return result;
    }

    @Override
    public boolean exists(RunPrepare prepare, String ... conditions) {
        return this.exists(prepare, (ConfigStore)null, conditions);
    }

    protected int getTotal(String sql, List<Object> values) {
        int total = 0;
        JDBCRuntime runtime = this.runtime();
        DataSet set = this.select(runtime, null, sql, values);
        total = set.getInt(0, "CNT", 0);
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(String dest, Object data, ConfigStore configs, List<String> columns) {
        dest = DataSourceHolder.parseDataSource(dest, data);
        boolean exe = true;
        if (null != this.listener) {
            exe = this.listener.beforeBuildUpdate(dest, data, configs, false, columns);
        }
        if (!exe) {
            return -1;
        }
        if (null == data) {
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                throw new SQLUpdateException("\u66f4\u65b0\u7a7a\u6570\u636e");
            }
            log.error("\u66f4\u65b0\u7a7a\u6570\u636e");
        }
        int result = 0;
        if (data instanceof DataSet) {
            DataSet set = (DataSet)data;
            for (int i = 0; i < set.size(); ++i) {
                result += this.update(dest, (Object)set.getRow(i), configs, columns);
            }
            return result;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        Run run = adapter.buildUpdateRun(dest, data, configs, false, columns);
        String sql = run.getFinalUpdate();
        if (BasicUtil.isEmpty((Object)sql)) {
            log.warn("[\u4e0d\u5177\u5907\u66f4\u65b0\u6761\u4ef6][dest:{}]", (Object)dest);
            return -1;
        }
        List<Object> values = run.getValues();
        long fr = System.currentTimeMillis();
        String random = "";
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, this.paramLogFormat(run.getUpdateColumns(), values)});
        }
        try {
            boolean listenerResult = true;
            if (null != this.listener) {
                listenerResult = this.listener.beforeUpdate(run, dest, data, columns);
            }
            if (listenerResult) {
                result = runtime.getTemplate().update(sql, values.toArray());
                Long millis = System.currentTimeMillis() - fr;
                if (null != this.listener) {
                    this.listener.afterUpdate(run, result, dest, data, columns, millis);
                }
                boolean slow = false;
                if (ConfigTable.SLOW_SQL_MILLIS > 0L && millis > ConfigTable.SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[SLOW SQL][action:update][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, sql, this.paramLogFormat(values)});
                    if (null != this.listener) {
                        this.listener.slow("update", run, sql, values, null, millis);
                    }
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("{}[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((int)result, (int)34)});
                }
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                SQLUpdateException ex = new SQLUpdateException("insert\u5f02\u5e38:" + e.toString(), e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u66f4\u65b0\u5f02\u5e38:", (int)33) + e.toString(), sql, this.paramLogFormat(run.getUpdateColumns(), values)});
            }
            e.printStackTrace();
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return result;
    }

    @Override
    public int update(Object data, ConfigStore configs, String ... columns) {
        return this.update(null, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int update(String dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(dest, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int update(Object data, ConfigStore configs, List<String> columns) {
        return this.update(null, data, configs, columns);
    }

    @Override
    public int update(String dest, Object data, String ... columns) {
        return this.update(dest, data, (ConfigStore)null, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int update(Object data, String ... columns) {
        return this.update(null, data, (ConfigStore)null, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int update(String dest, Object data, List<String> columns) {
        return this.update(dest, data, (ConfigStore)null, columns);
    }

    @Override
    public int update(Object data, List<String> columns) {
        return this.update(null, data, (ConfigStore)null, columns);
    }

    @Override
    public int save(String dest, Object data, boolean checkPrimary, String ... columns) {
        if (null == data) {
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                throw new SQLUpdateException("save\u7a7a\u6570\u636e");
            }
            log.error("save\u7a7a\u6570\u636e");
            return -1;
        }
        if (data instanceof Collection) {
            Collection items = (Collection)data;
            int cnt = 0;
            for (Object item : items) {
                cnt += this.save(dest, item, checkPrimary, columns);
            }
            return cnt;
        }
        return this.saveObject(dest, data, checkPrimary, columns);
    }

    @Override
    public int save(Object data, boolean checkPrimary, String ... columns) {
        return this.save(null, data, checkPrimary, columns);
    }

    @Override
    public int save(String dest, Object data, String ... columns) {
        return this.save(dest, data, false, columns);
    }

    @Override
    public int save(Object data, String ... columns) {
        return this.save(null, data, false, columns);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int saveObject(String dest, Object data, boolean checkPrimary, String ... columns) {
        if (null == data) {
            return 0;
        }
        boolean isNew = this.checkIsNew(data);
        if (isNew) {
            return this.insert(dest, data, checkPrimary, columns);
        }
        Boolean override = this.checkOverride(data);
        boolean exe = true;
        if (null == override) return this.update(dest, data, columns);
        DefaultTablePrepare prepare = new DefaultTablePrepare(dest);
        Map<String, Object> pvs = this.checkPv(data);
        DefaultConfigStore stores = new DefaultConfigStore(new String[0]);
        for (String k : pvs.keySet()) {
            stores.and(k, pvs.get(k));
        }
        boolean exists = this.exists((RunPrepare)prepare, stores, new String[0]);
        if (!exists) return this.insert(dest, data, checkPrimary, columns);
        if (override.booleanValue()) {
            return this.update(dest, data, columns);
        }
        log.warn("[\u8df3\u8fc7\u66f4\u65b0][\u6570\u636e\u5df2\u5b58\u5728:{}({})]", (Object)dest, (Object)BeanUtil.map2json(pvs));
        return 0;
    }

    protected Boolean checkOverride(Object obj) {
        Boolean result = null;
        if (null != obj && obj instanceof DataRow) {
            result = ((DataRow)obj).getOverride();
        }
        return result;
    }

    protected Map<String, Object> checkPv(Object obj) {
        HashMap<String, Object> pvs = new HashMap<String, Object>();
        if (null != obj && obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            List ks = row.getPrimaryKeys();
            for (String k : ks) {
                pvs.put(k, row.get(k));
            }
        }
        return pvs;
    }

    protected boolean checkIsNew(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            return row.isNew();
        }
        if (EntityAdapterProxy.hasAdapter()) {
            Map values = EntityAdapterProxy.primaryValues((Object)obj);
            for (Map.Entry entry : values.entrySet()) {
                if (!BasicUtil.isNotEmpty(entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insert(String dest, Object data, boolean checkPrimary, List<String> columns) {
        Run run;
        DataSet set;
        Map tags;
        dest = DataSourceHolder.parseDataSource(dest, data);
        boolean exe = true;
        if (null != this.listener) {
            exe = this.listener.beforeBuildInsert(dest, data, checkPrimary, columns);
        }
        if (!exe) {
            return -1;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        if (null != data && data instanceof DataSet && null != (tags = (set = (DataSet)data).getTags()) && tags.size() > 0) {
            LinkedHashMap<String, PartitionTable> ptables = this.ptables(false, new MasterTable(dest), tags);
            if (ptables.size() != 1) {
                String msg = "\u5206\u533a\u8868\u5b9a\u4f4d\u5f02\u5e38,\u4e3b\u8868:" + dest + ",\u6807\u7b7e:" + BeanUtil.map2json((Map)tags) + ",\u5206\u533a\u8868:" + BeanUtil.object2json(ptables.keySet());
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new SQLUpdateException(msg);
                }
                log.error(msg);
                return -1;
            }
            dest = ptables.values().iterator().next().getName();
        }
        if (null == (run = adapter.buildInsertRun(runtime.getTemplate(), dest, data, checkPrimary, columns))) {
            return 0;
        }
        int cnt = 0;
        String sql = run.getFinalInsert();
        List<Object> values = run.getValues();
        long fr = System.currentTimeMillis();
        String random = "";
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, this.paramLogFormat(run.getInsertColumns(), values)});
        }
        try {
            boolean listenerResult = true;
            if (null != this.listener) {
                listenerResult = this.listener.beforeInsert(run, dest, data, checkPrimary, columns);
            }
            if (listenerResult) {
                cnt = adapter.insert(runtime.getTemplate(), random, data, sql, values, null);
                Long millis = System.currentTimeMillis() - fr;
                if (null != this.listener) {
                    this.listener.afterInsert(run, cnt, dest, data, checkPrimary, columns, millis);
                }
                boolean slow = false;
                if (ConfigTable.SLOW_SQL_MILLIS > 0L && millis > ConfigTable.SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[SLOW SQL][action:insert][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, sql, this.paramLogFormat(values)});
                    if (null != this.listener) {
                        this.listener.slow("insert", run, sql, values, null, millis);
                    }
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("{}[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((int)cnt, (int)34)});
                }
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                SQLUpdateException ex = new SQLUpdateException("insert\u5f02\u5e38:" + e.toString(), e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u63d2\u5165\u5f02\u5e38:", (int)33) + e.toString(), sql, this.paramLogFormat(run.getInsertColumns(), values)});
            }
            e.printStackTrace();
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return cnt;
    }

    @Override
    public int insert(Object data, boolean checkPrimary, List<String> columns) {
        return this.insert(null, data, checkPrimary, columns);
    }

    @Override
    public int insert(String dest, Object data, List<String> columns) {
        return this.insert(dest, data, false, columns);
    }

    @Override
    public int insert(Object data, List<String> columns) {
        return this.insert(null, data, false, columns);
    }

    @Override
    public int insert(String dest, Object data, boolean checkPrimary, String ... columns) {
        return this.insert(dest, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int insert(Object data, boolean checkPrimary, String ... columns) {
        return this.insert(null, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int insert(String dest, Object data, String ... columns) {
        return this.insert(dest, data, false, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int insert(Object data, String ... columns) {
        return this.insert(null, data, false, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    protected List<Map<String, Object>> maps(JDBCRuntime runtime, String sql, List<Object> values) {
        JDBCAdapter adapter = runtime.getAdapter();
        List<Map<String, Object>> maps = null;
        if (BasicUtil.isEmpty((Object)sql)) {
            if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                throw new SQLQueryException("\u672a\u6307\u5b9aSQL");
            }
            log.error("\u672a\u6307\u5b9aSQL");
            return new ArrayList<Map<String, Object>>();
        }
        long fr = System.currentTimeMillis();
        String random = "";
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, this.paramLogFormat(values)});
        }
        try {
            maps = null != values && values.size() > 0 ? runtime.getTemplate().queryForList(sql, values.toArray()) : runtime.getTemplate().queryForList(sql);
            long mid = System.currentTimeMillis();
            boolean slow = false;
            if (ConfigTable.SLOW_SQL_MILLIS > 0L && mid - fr > ConfigTable.SLOW_SQL_MILLIS) {
                slow = true;
                log.warn("{}[SLOW SQL][action:select][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, mid - fr, sql, this.paramLogFormat(values)});
                if (null != this.listener) {
                    this.listener.slow("select", null, sql, values, null, mid);
                }
            }
            if (!slow && ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)(mid - fr));
            }
            if (null != adapter) {
                maps = adapter.process(maps);
            }
            if (!slow && ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, System.currentTimeMillis() - mid, maps.size()});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38:" + e.toString(), e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), sql, this.paramLogFormat(values)});
            }
            e.printStackTrace();
        }
        return maps;
    }

    protected static DataRow row(JDBCRuntime runtime, LinkedHashMap<String, Column> metadatas, ResultSet rs) {
        DataRow row = new DataRow();
        try {
            Column column;
            String name;
            int i;
            JDBCAdapter adapter = runtime.getAdapter();
            ResultSetMetaData rsmd = rs.getMetaData();
            int qty = rsmd.getColumnCount();
            if (metadatas.isEmpty()) {
                for (i = 1; i <= qty; ++i) {
                    name = rsmd.getColumnName(i);
                    if (null == name || name.toUpperCase().equals("PAGE_ROW_NUMBER_")) continue;
                    column = metadatas.get(name);
                    column = adapter.column((org.anyline.data.entity.Column)column, rsmd, i);
                    metadatas.put(name.toUpperCase(), column);
                }
            }
            for (i = 1; i <= qty; ++i) {
                name = rsmd.getColumnLabel(i);
                if (null == name || name.toUpperCase().equals("PAGE_ROW_NUMBER_")) continue;
                column = metadatas.get(name.toUpperCase());
                row.put(false, name, rs.getObject(name));
            }
            row.setMetadatas(metadatas);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return row;
    }

    protected DataSet select(final JDBCRuntime runtime, String table, String sql, List<Object> values) {
        if (BasicUtil.isEmpty((Object)sql)) {
            if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                throw new SQLQueryException("\u672a\u6307\u5b9aSQL");
            }
            log.error("\u672a\u6307\u5b9aSQL");
            return new DataSet();
        }
        long fr = System.currentTimeMillis();
        String random = "";
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, this.paramLogFormat(values)});
        }
        final DataSet set = new DataSet();
        LinkedHashMap<String, org.anyline.data.entity.Column> columns = new LinkedHashMap();
        if (ConfigTable.IS_AUTO_CHECK_METADATA && null != table && null == (columns = CacheProxy.columns(table))) {
            columns = this.columns(table);
            CacheProxy.columns(table, columns);
        }
        try {
            final long[] mid = new long[]{System.currentTimeMillis()};
            final boolean[] process = new boolean[]{false};
            final LinkedHashMap<String, org.anyline.data.entity.Column> metadatas = new LinkedHashMap<String, org.anyline.data.entity.Column>();
            metadatas.putAll(columns);
            set.setMetadatas(metadatas);
            if (null != values && values.size() > 0) {
                runtime.getTemplate().query(sql, values.toArray(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        if (!process[0]) {
                            mid[0] = System.currentTimeMillis();
                        }
                        DataRow row = DefaultDao.row(runtime, metadatas, rs);
                        set.add(row);
                        process[0] = true;
                    }
                });
            } else {
                runtime.getTemplate().query(sql, new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        if (!process[0]) {
                            mid[0] = System.currentTimeMillis();
                        }
                        DataRow row = DefaultDao.row(runtime, metadatas, rs);
                        set.add(row);
                        process[0] = true;
                    }
                });
            }
            if (!process[0]) {
                mid[0] = System.currentTimeMillis();
            }
            boolean slow = false;
            if (ConfigTable.SLOW_SQL_MILLIS > 0L) {
                slow = true;
                if (mid[0] - fr > ConfigTable.SLOW_SQL_MILLIS) {
                    log.warn("{}[SLOW SQL][action:select][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, mid[0] - fr, sql, this.paramLogFormat(values)});
                    if (null != this.listener) {
                        this.listener.slow("select", null, sql, values, null, mid[0] - fr);
                    }
                }
            }
            if (!slow && ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)(mid[0] - fr));
            }
            set.setDatalink(DataSourceHolder.curDataSource());
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, System.currentTimeMillis() - mid[0], set.size()});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38:" + e.toString(), e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), sql, this.paramLogFormat(values)});
            }
            e.printStackTrace();
        }
        return set;
    }

    protected <T> EntitySet<T> select(JDBCRuntime runtime, Class<T> clazz, String table, String sql, List<Object> values) {
        EntitySet set = new EntitySet();
        DataSet rows = this.select(runtime, table, sql, values);
        for (DataRow row : rows) {
            Object entity;
            if (EntityAdapterProxy.hasAdapter()) {
                entity = EntityAdapterProxy.entity(clazz, (Map)row, null);
                set.add(entity);
                continue;
            }
            entity = row.entity(clazz, new String[0]);
            set.add(entity);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        int result = -1;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        Run run = adapter.buildExecuteRun(prepare, configs, conditions);
        if (!run.isValid()) {
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][RunPrepare:" + ConfigParser.createSQLSign(false, false, prepare.getTable(), configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + this.runtime().getKey() + "]");
            }
            return -1;
        }
        String txt = run.getFinalExecute();
        List<Object> values = run.getValues();
        long fr = System.currentTimeMillis();
        String random = "";
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, txt, this.paramLogFormat(values)});
        }
        try {
            boolean listenerResult = true;
            if (null != this.listener) {
                listenerResult = this.listener.beforeExecute(run);
            }
            if (listenerResult) {
                result = null != values && values.size() > 0 ? runtime.getTemplate().update(txt, values.toArray()) : runtime.getTemplate().update(txt);
                Long millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                if (ConfigTable.SLOW_SQL_MILLIS > 0L && millis > ConfigTable.SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[SLOW SQL][action:execute][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, txt, this.paramLogFormat(values)});
                    if (null != this.listener) {
                        this.listener.slow("execute", run, txt, values, null, millis);
                    }
                }
                if (null != this.listener) {
                    this.listener.afterExecute(run, result, (long)millis);
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("{}[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((int)result, (int)34)});
                }
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                throw e;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"SQL\u6267\u884c\u5f02\u5e38:", (int)33) + e.toString(), prepare, this.paramLogFormat(values)});
            }
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return result;
    }

    @Override
    public int execute(RunPrepare prepare, String ... conditions) {
        return this.execute(prepare, (ConfigStore)null, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(final Procedure procedure) {
        boolean result = false;
        ArrayList<Object> list = new ArrayList();
        final List<ProcedureParam> inputs = procedure.getInputs();
        final List<ProcedureParam> outputs = procedure.getOutputs();
        long fr = System.currentTimeMillis();
        String random = "";
        String sql = " {";
        boolean returnIndex = false;
        if (procedure.hasReturn()) {
            sql = sql + "? = ";
            returnIndex = true;
        }
        sql = sql + "call " + procedure.getName() + "(";
        final int sizeIn = inputs.size();
        final int sizeOut = outputs.size();
        int size = sizeIn + sizeOut;
        for (int i = 0; i < size; ++i) {
            sql = sql + "?";
            if (i >= size - 1) continue;
            sql = sql + ",";
        }
        sql = sql + ")}";
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, sql, this.paramLogFormat(inputs), this.paramLogFormat(outputs)});
        }
        try {
            JDBCRuntime runtime = this.runtime();
            boolean listenerResult = true;
            if (null != this.listener) {
                listenerResult = this.listener.beforeExecute(procedure);
            }
            if (listenerResult) {
                list = (List)runtime.getTemplate().execute(sql, (CallableStatementCallback)new CallableStatementCallback<Object>(){

                    public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                        ProcedureParam param;
                        int i;
                        ArrayList<Object> result = new ArrayList<Object>();
                        int returnIndex = 0;
                        if (procedure.hasReturn()) {
                            returnIndex = 1;
                            cs.registerOutParameter(1, 12);
                        }
                        for (i = 1; i <= sizeIn; ++i) {
                            param = (ProcedureParam)inputs.get(i - 1);
                            Object value = param.getValue();
                            if (null == value || "NULL".equalsIgnoreCase(value.toString())) {
                                value = null;
                            }
                            cs.setObject(i + returnIndex, value, (int)param.getType());
                        }
                        for (i = 1; i <= sizeOut; ++i) {
                            param = (ProcedureParam)outputs.get(i - 1);
                            if (null == param.getValue()) {
                                cs.registerOutParameter(i + sizeIn + returnIndex, (int)param.getType());
                                continue;
                            }
                            cs.setObject(i + sizeIn + returnIndex, param.getValue(), (int)param.getType());
                        }
                        cs.execute();
                        if (procedure.hasReturn()) {
                            result.add(cs.getObject(1));
                        }
                        if (sizeOut > 0) {
                            for (i = 1; i <= sizeOut; ++i) {
                                Object output = cs.getObject(sizeIn + returnIndex + i);
                                result.add(output);
                            }
                        }
                        return result;
                    }
                });
                procedure.setResult(list);
                result = true;
                Long millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                if (ConfigTable.SLOW_SQL_MILLIS > 0L && millis > ConfigTable.SLOW_SQL_MILLIS) {
                    log.warn("{}[SLOW SQL][action:procedure][millis:{}ms][sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, millis, sql, this.paramLogFormat(inputs), this.paramLogFormat(list)});
                    if (null != this.listener) {
                        this.listener.slow("procedure", null, sql, inputs, list, millis);
                    }
                }
                if (null != this.listener) {
                    this.listener.afterExecute(procedure, result, (long)millis);
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("{}[\u6267\u884c\u8017\u65f6:{}ms]\n[output param:{}]", new Object[]{random, millis, list});
                }
            }
        }
        catch (Exception e) {
            result = false;
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                SQLUpdateException ex = new SQLUpdateException("execute\u5f02\u5e38:" + e.toString(), e);
                ex.setSql(sql);
                throw ex;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, LogUtil.format((String)"\u5b58\u50a8\u8fc7\u7a0b\u6267\u884c\u5f02\u5e38:", (int)33) + e.toString(), sql, this.paramLogFormat(inputs), this.paramLogFormat(outputs)});
            }
            e.printStackTrace();
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet querys(final Procedure procedure, final PageNavi navi) {
        final List<ProcedureParam> inputs = procedure.getInputs();
        final List<ProcedureParam> outputs = procedure.getOutputs();
        long fr = System.currentTimeMillis();
        String random = "";
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n][input param:{}]\n[output param:{}]", new Object[]{random, procedure.getName(), this.paramLogFormat(inputs), this.paramLogFormat(outputs)});
        }
        final String rdm = random;
        DataSet set = null;
        try {
            JDBCRuntime runtime = this.runtime();
            if (null != this.listener) {
                this.listener.beforeQuery(procedure);
            }
            set = (DataSet)runtime.getTemplate().execute(new CallableStatementCreator(){

                public CallableStatement createCallableStatement(Connection conn) throws SQLException {
                    ProcedureParam param;
                    int i;
                    String sql = "{call " + procedure.getName() + "(";
                    int sizeIn = inputs.size();
                    int sizeOut = outputs.size();
                    int size = sizeIn + sizeOut;
                    for (int i2 = 0; i2 < size; ++i2) {
                        sql = sql + "?";
                        if (i2 >= size - 1) continue;
                        sql = sql + ",";
                    }
                    sql = sql + ")}";
                    CallableStatement cs = conn.prepareCall(sql);
                    for (i = 1; i <= sizeIn; ++i) {
                        param = (ProcedureParam)inputs.get(i - 1);
                        Object value = param.getValue();
                        if (null == value || "NULL".equalsIgnoreCase(value.toString())) {
                            value = null;
                        }
                        cs.setObject(i, value, (int)param.getType());
                    }
                    for (i = 1; i <= sizeOut; ++i) {
                        param = (ProcedureParam)outputs.get(i - 1);
                        if (null == param.getValue()) {
                            cs.registerOutParameter(i + sizeIn, (int)param.getType());
                            continue;
                        }
                        cs.setObject(i, param.getValue(), (int)param.getType());
                    }
                    return cs;
                }
            }, (CallableStatementCallback)new CallableStatementCallback<Object>(){

                public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                    ResultSet rs = cs.executeQuery();
                    DataSet set = new DataSet();
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int cols = rsmd.getColumnCount();
                    for (int i = 1; i <= cols; ++i) {
                        set.addHead(rsmd.getColumnLabel(i));
                    }
                    long mid = System.currentTimeMillis();
                    int index = 0;
                    int first = -1;
                    int last = -1;
                    if (null != navi) {
                        first = navi.getFirstRow();
                        last = navi.getLastRow();
                    }
                    while (rs.next()) {
                        if (first == -1 || index >= first && index <= last) {
                            DataRow row = new DataRow();
                            for (int i = 1; i <= cols; ++i) {
                                row.put(rsmd.getColumnLabel(i), rs.getObject(i));
                            }
                            set.addRow(row);
                        }
                        if (first == -1 || ++index <= last && (first != 0 || last != 0)) continue;
                    }
                    if (null != navi) {
                        navi.setTotalRow(index);
                        set.setNavi(navi);
                    }
                    set.setDatalink(DataSourceHolder.curDataSource());
                    if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                        log.warn("{}[\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{rdm, System.currentTimeMillis() - mid, set.size()});
                    }
                    return set;
                }
            });
            Long millis = System.currentTimeMillis() - fr;
            boolean slow = false;
            if (ConfigTable.SLOW_SQL_MILLIS > 0L && millis > ConfigTable.SLOW_SQL_MILLIS) {
                log.warn("{}[SLOW SQL][action:procedure][millis:{}ms][sql:\n{}\n][input param:{}]\n[output param:{}]", new Object[]{random, millis, procedure.getName(), this.paramLogFormat(inputs), this.paramLogFormat(outputs)});
                if (null != this.listener) {
                    this.listener.slow("procedure", null, procedure.getName(), inputs, outputs, millis);
                }
            }
            if (null != this.listener) {
                this.listener.afterQuery(procedure, set, (long)millis);
            }
            if (!slow && ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)millis);
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38:" + e.toString(), e);
                throw ex;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, LogUtil.format((String)"\u5b58\u50a8\u8fc7\u7a0b\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), procedure.getName(), this.paramLogFormat(inputs), this.paramLogFormat(outputs)});
            }
            e.printStackTrace();
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return set;
    }

    @Override
    public int deletes(String table, String key, Collection<Object> values) {
        table = DataSourceHolder.parseDataSource(table, null);
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        Run run = adapter.buildDeleteRun(table, key, values);
        int result = this.exeDelete(runtime, run);
        return result;
    }

    @Override
    public int deletes(String table, String key, String ... values) {
        table = DataSourceHolder.parseDataSource(table, null);
        ArrayList<String> list = new ArrayList<String>();
        if (null != values) {
            for (String value : values) {
                list.add(value);
            }
        }
        boolean exe = true;
        if (null != this.listener) {
            exe = this.listener.beforeBuildDelete(table, key, list);
        }
        if (!exe) {
            return -1;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        Run run = adapter.buildDeleteRun(table, key, list);
        int result = this.exeDelete(runtime, run);
        return result;
    }

    @Override
    public int delete(String dest, Object obj, String ... columns) {
        dest = DataSourceHolder.parseDataSource(dest, obj);
        int size = 0;
        if (null != obj) {
            if (obj instanceof Collection) {
                Collection list = (Collection)obj;
                for (Object item : list) {
                    int qty = this.delete(dest, item, columns);
                    if (qty <= 0) continue;
                    size += qty;
                }
                if (log.isWarnEnabled()) {
                    log.warn("[delete Collection][\u5f71\u54cd\u884c\u6570:{}]", (Object)LogUtil.format((int)size, (int)34));
                }
            } else {
                boolean exe = true;
                if (null != this.listener) {
                    exe = this.listener.beforeBuildDelete(dest, obj, columns);
                }
                if (!exe) {
                    return -1;
                }
                JDBCRuntime runtime = this.runtime();
                JDBCAdapter adapter = runtime.getAdapter();
                Run run = adapter.buildDeleteRun(dest, obj, columns);
                size = this.exeDelete(runtime, run);
            }
        }
        return size;
    }

    @Override
    public int delete(String table, ConfigStore configs, String ... conditions) {
        table = DataSourceHolder.parseDataSource(table, null);
        boolean exe = true;
        if (null != this.listener) {
            exe = this.listener.beforeBuildDelete(table, configs, conditions);
        }
        if (!exe) {
            return -1;
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        Run run = adapter.buildDeleteRun(table, configs, conditions);
        int result = this.exeDelete(runtime, run);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int exeDelete(JDBCRuntime runtime, Run run) {
        int result = 0;
        String sql = run.getFinalDelete();
        List<Object> values = run.getValues();
        long fr = System.currentTimeMillis();
        String random = "";
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, this.paramLogFormat(values)});
        }
        try {
            boolean listenerResult = true;
            if (null != this.listener) {
                listenerResult = this.listener.beforeDelete(run);
            }
            if (listenerResult) {
                result = null == values ? runtime.getTemplate().update(sql) : runtime.getTemplate().update(sql, values.toArray());
                Long millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                if (ConfigTable.SLOW_SQL_MILLIS > 0L) {
                    slow = true;
                    if (millis > ConfigTable.SLOW_SQL_MILLIS) {
                        log.warn("{}[SLOW SQL][action:delete][millis:{}ms][sql:\n{}\n]\n[param:{}]", new Object[]{random, millis, sql, this.paramLogFormat(values)});
                        if (null != this.listener) {
                            this.listener.slow("delete", run, sql, values, null, millis);
                        }
                    }
                }
                if (null != this.listener) {
                    this.listener.afterDelete(run, result, millis);
                }
                if (!slow && ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("{}[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((int)result, (int)34)});
                }
            }
        }
        catch (Exception e) {
            result = 0;
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                SQLUpdateException ex = new SQLUpdateException("delete\u5f02\u5e38:" + e.toString(), e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u5220\u9664\u5f02\u5e38:", (int)33) + e.toString(), sql, this.paramLogFormat(values)});
            }
            e.printStackTrace();
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return result;
    }

    @Override
    public int truncate(String table) {
        table = DataSourceHolder.parseDataSource(table);
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String sql = adapter.buildTruncateSQL(table);
        DefaultTextPrepare prepare = new DefaultTextPrepare(sql);
        return this.execute((RunPrepare)prepare, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, Database> databases() {
        LinkedHashMap<String, Database> databases = new LinkedHashMap<String, Database>();
        DataSource ds = null;
        Connection con = null;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String random = this.random();
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                ds = runtime.getTemplate().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                try {
                    List<String> sqls = adapter.buildQueryDatabaseRunSQL();
                    if (null != sqls) {
                        int idx = 0;
                        for (String sql : sqls) {
                            if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                            DataSet set = this.select(runtime, null, sql, null).toUpperKey();
                            databases = adapter.databases(idx++, true, databases, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[databases][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[databases][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, databases.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional(con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return databases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, Table> tables(boolean greedy, String catalog, String schema, String pattern, String types) {
        LinkedHashMap<String, Table> tables = new LinkedHashMap<String, Table>();
        DataSource ds = null;
        Connection con = null;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String random = this.random();
        try {
            LinkedHashMap<String, Table> tmps;
            String[] tps;
            long fr;
            block25: {
                fr = System.currentTimeMillis();
                ds = runtime.getTemplate().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                Table search = new Table();
                if (null == catalog || null == schema) {
                    Table tmp = new Table();
                    if (!greedy) {
                        adapter.checkSchema(con, tmp);
                    }
                    if (null == catalog) {
                        catalog = tmp.getCatalog();
                    }
                    if (null == schema) {
                        schema = tmp.getSchema();
                    }
                }
                search.setName(pattern);
                search.setCatalog(catalog);
                search.setSchema(schema);
                tps = null;
                if (null != types) {
                    tps = types.toUpperCase().trim().split(",");
                }
                DataRow table_map = CacheProxy.getTableMaps(DataSourceHolder.curDataSource() + "_" + types);
                if (null != pattern) {
                    if (table_map.isEmpty()) {
                        LinkedHashMap<String, Table> all = this.tables(greedy, catalog, schema, null, null);
                        if (!greedy) {
                            for (Table table : all.values()) {
                                if (!(catalog + "_" + schema).equals(table.getCatalog() + "_" + table.getSchema())) continue;
                                table_map.put(table.getName(greedy).toUpperCase(), (Object)table.getName(greedy));
                            }
                        }
                    }
                    pattern = table_map.containsKey(search.getName(greedy).toUpperCase()) ? table_map.getString(search.getName(greedy).toUpperCase()) : search.getName(greedy);
                }
                try {
                    List<String> sqls = adapter.buildQueryTableRunSQL(catalog, schema, pattern, types);
                    if (null != sqls) {
                        int idx = 0;
                        for (String sql : sqls) {
                            if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                            DataSet set = this.select(runtime, null, sql, null).toUpperKey();
                            tables = adapter.tables(idx++, true, catalog, schema, tables, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block25;
                    log.warn("{}[tables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            try {
                tmps = adapter.tables(true, null, con.getMetaData(), catalog, schema, pattern, tps);
                for (String string : tmps.keySet()) {
                    Table item;
                    if (tables.containsKey(string.toUpperCase()) || null == (item = tmps.get(string)) || !greedy && !(catalog + "_" + schema).equalsIgnoreCase(item.getCatalog() + "_" + item.getSchema())) continue;
                    tables.put(string.toUpperCase(), item);
                }
            }
            catch (Exception e) {
                log.warn("{}[tables][][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636ejdbc\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
            }
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[tables][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, pattern, types, tables.size(), System.currentTimeMillis() - fr});
            }
            if (BasicUtil.isNotEmpty((Object)pattern)) {
                tmps = new LinkedHashMap();
                List keys = BeanUtil.getMapKeys(tables);
                for (String key : keys) {
                    Table item = tables.get(key);
                    String name = item.getName(greedy);
                    if (!RegularUtil.match((String)name, (String)pattern)) continue;
                    tmps.put(name.toUpperCase(), item);
                }
                tables = tmps;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional(con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return tables;
    }

    @Override
    public LinkedHashMap<String, Table> tables(boolean greedy, String schema, String name, String types) {
        return this.tables(greedy, null, schema, name, types);
    }

    @Override
    public LinkedHashMap<String, Table> tables(boolean greedy, String name, String types) {
        return this.tables(greedy, null, null, name, types);
    }

    @Override
    public LinkedHashMap<String, Table> tables(boolean greedy, String types) {
        return this.tables(greedy, null, null, types);
    }

    @Override
    public LinkedHashMap<String, Table> tables(boolean greedy) {
        return this.tables(greedy, null, null, null, "TABLE");
    }

    @Override
    public LinkedHashMap<String, Table> tables(String catalog, String schema, String pattern, String types) {
        return this.tables(false, catalog, schema, pattern, types);
    }

    @Override
    public LinkedHashMap<String, Table> tables(String schema, String name, String types) {
        return this.tables(false, null, schema, name, types);
    }

    @Override
    public LinkedHashMap<String, Table> tables(String name, String types) {
        return this.tables(false, null, null, name, types);
    }

    @Override
    public LinkedHashMap<String, Table> tables(String types) {
        return this.tables(false, null, null, types);
    }

    @Override
    public LinkedHashMap<String, Table> tables() {
        return this.tables(false, null, null, null, "TABLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, View> views(boolean greedy, String catalog, String schema, String pattern, String types) {
        LinkedHashMap<String, View> views = new LinkedHashMap<String, View>();
        DataSource ds = null;
        Connection con = null;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String random = this.random();
        try {
            LinkedHashMap<String, View> tmps;
            String[] tps;
            long fr;
            block24: {
                fr = System.currentTimeMillis();
                ds = runtime.getTemplate().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                View search = new View();
                if (null == catalog || null == schema) {
                    View tmp = new View();
                    if (!greedy) {
                        adapter.checkSchema(con, (Table)tmp);
                    }
                    if (null == catalog) {
                        catalog = tmp.getCatalog();
                    }
                    if (null == schema) {
                        schema = tmp.getSchema();
                    }
                }
                search.setName(pattern);
                search.setCatalog(catalog);
                search.setSchema(schema);
                tps = null;
                tps = null != types ? types.toUpperCase().trim().split(",") : new String[]{"VIEW"};
                DataRow view_map = CacheProxy.getViewMaps(DataSourceHolder.curDataSource() + "");
                if (null != pattern) {
                    if (view_map.isEmpty()) {
                        LinkedHashMap<String, View> all = this.views(greedy, catalog, schema, null, types);
                        if (!greedy) {
                            for (View view : all.values()) {
                                if (!(catalog + "_" + schema).equals(view.getCatalog() + "_" + view.getSchema())) continue;
                                view_map.put(view.getName(greedy).toUpperCase(), (Object)view.getName(greedy));
                            }
                        }
                    }
                    pattern = view_map.containsKey(search.getName(greedy).toUpperCase()) ? view_map.getString(search.getName(greedy).toUpperCase()) : search.getName(greedy);
                }
                try {
                    List<String> sqls = adapter.buildQueryViewRunSQL(catalog, schema, pattern, types);
                    if (null != sqls) {
                        int idx = 0;
                        for (String sql : sqls) {
                            if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                            DataSet set = this.select(runtime, null, sql, null).toUpperKey();
                            views = adapter.views(idx++, true, catalog, schema, views, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block24;
                    log.warn("{}[views][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            try {
                tmps = adapter.views(true, null, con.getMetaData(), catalog, schema, pattern, tps);
                for (String string : tmps.keySet()) {
                    View item;
                    if (views.containsKey(string.toUpperCase()) || null == (item = tmps.get(string)) || !greedy && !(catalog + "_" + schema).equalsIgnoreCase(item.getCatalog() + "_" + item.getSchema())) continue;
                    views.put(string.toUpperCase(), item);
                }
            }
            catch (Exception e) {
                log.warn("{}[views][][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636ejdbc\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
            }
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[views][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, pattern, types, views.size(), System.currentTimeMillis() - fr});
            }
            if (BasicUtil.isNotEmpty((Object)pattern)) {
                tmps = new LinkedHashMap();
                List keys = BeanUtil.getMapKeys(views);
                for (String key : keys) {
                    View item = views.get(key);
                    String name = item.getName(greedy);
                    if (!RegularUtil.match((String)name, (String)pattern)) continue;
                    tmps.put(name.toUpperCase(), item);
                }
                views = tmps;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional(con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return views;
    }

    @Override
    public LinkedHashMap<String, View> views(boolean greedy, String schema, String name, String types) {
        return this.views(greedy, null, schema, name, types);
    }

    @Override
    public LinkedHashMap<String, View> views(boolean greedy, String name, String types) {
        return this.views(greedy, null, null, name, types);
    }

    @Override
    public LinkedHashMap<String, View> views(boolean greedy, String types) {
        return this.views(greedy, null, null, types);
    }

    @Override
    public LinkedHashMap<String, View> views(boolean greedy) {
        return this.views(greedy, null, null, null, "TABLE");
    }

    @Override
    public LinkedHashMap<String, View> views(String catalog, String schema, String pattern, String types) {
        return this.views(false, catalog, schema, pattern, types);
    }

    @Override
    public LinkedHashMap<String, View> views(String schema, String name, String types) {
        return this.views(false, null, schema, name, types);
    }

    @Override
    public LinkedHashMap<String, View> views(String name, String types) {
        return this.views(false, null, null, name, types);
    }

    @Override
    public LinkedHashMap<String, View> views(String types) {
        return this.views(false, null, null, types);
    }

    @Override
    public LinkedHashMap<String, View> views() {
        return this.views(false, null, null, null, "TABLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, MasterTable> mtables(boolean greedy, String catalog, String schema, String pattern, String types) {
        LinkedHashMap<String, MasterTable> tables = new LinkedHashMap<String, MasterTable>();
        DataSource ds = null;
        Connection con = null;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String random = this.random();
        try {
            String[] tps;
            long fr;
            block23: {
                fr = System.currentTimeMillis();
                ds = runtime.getTemplate().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                if (null == catalog || null == schema) {
                    Table tmp = new Table();
                    if (!greedy) {
                        adapter.checkSchema(con, tmp);
                    }
                    if (null == catalog) {
                        catalog = tmp.getCatalog();
                    }
                    if (null == schema) {
                        schema = tmp.getSchema();
                    }
                }
                tps = null;
                if (null != types) {
                    tps = types.toUpperCase().trim().split(",");
                }
                DataRow table_map = CacheProxy.getTableMaps(DataSourceHolder.curDataSource() + "_" + types);
                if (null != pattern) {
                    if (table_map.isEmpty()) {
                        LinkedHashMap<String, MasterTable> all = this.mtables(catalog, schema, null, types);
                        for (Table table : all.values()) {
                            table_map.put(table.getName().toUpperCase(), (Object)table.getName());
                        }
                    }
                    if (table_map.containsKey(pattern.toUpperCase())) {
                        pattern = table_map.getString(pattern.toUpperCase());
                    }
                }
                try {
                    List<String> sqls = adapter.buildQueryMasterTableRunSQL(catalog, schema, pattern, types);
                    if (null != sqls) {
                        int idx = 0;
                        for (String sql : sqls) {
                            if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                            DataSet set = this.select(runtime, null, sql, null).toUpperKey();
                            tables = adapter.mtables(idx++, true, catalog, schema, tables, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block23;
                    log.warn("{}[stables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            try {
                LinkedHashMap<String, MasterTable> tmps = adapter.mtables(true, null, con.getMetaData(), catalog, schema, pattern, tps);
                for (String string : tmps.keySet()) {
                    MasterTable item;
                    if (tables.containsKey(string.toUpperCase()) || null == (item = tmps.get(string)) || !greedy && !(catalog + "_" + schema).equalsIgnoreCase(item.getCatalog() + "_" + item.getSchema())) continue;
                    tables.put(string.toUpperCase(), item);
                }
            }
            catch (Exception e) {
                log.warn("{}[stables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636ejdbc\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
            }
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[stables][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, pattern, types, tables.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional(con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return tables;
    }

    @Override
    public LinkedHashMap<String, MasterTable> mtables(boolean greedy, String schema, String name, String types) {
        return this.mtables(greedy, null, schema, name, types);
    }

    @Override
    public LinkedHashMap<String, MasterTable> mtables(boolean greedy, String name, String types) {
        return this.mtables(greedy, null, null, name, types);
    }

    @Override
    public LinkedHashMap<String, MasterTable> mtables(boolean greedy, String types) {
        return this.mtables(greedy, null, types);
    }

    @Override
    public LinkedHashMap<String, MasterTable> mtables(boolean greedy) {
        return this.mtables(greedy, "STABLE");
    }

    @Override
    public LinkedHashMap<String, MasterTable> mtables(String catalog, String schema, String pattern, String types) {
        return this.mtables(false, catalog, schema, pattern, types);
    }

    @Override
    public LinkedHashMap<String, MasterTable> mtables(String schema, String name, String types) {
        return this.mtables(false, null, schema, name, types);
    }

    @Override
    public LinkedHashMap<String, MasterTable> mtables(String name, String types) {
        return this.mtables(false, null, null, name, types);
    }

    @Override
    public LinkedHashMap<String, MasterTable> mtables(String types) {
        return this.mtables(false, null, types);
    }

    @Override
    public LinkedHashMap<String, MasterTable> mtables() {
        return this.mtables(false, "STABLE");
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(boolean greedy, String catalog, String schema, String master, String name) {
        MasterTable mtable = new MasterTable(catalog, schema, master);
        return this.ptables(greedy, mtable, null, name);
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(boolean greedy, String schema, String master, String name) {
        return this.ptables(greedy, null, schema, master, name);
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(boolean greedy, String master, String name) {
        return this.ptables(greedy, null, null, master, name);
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(boolean greedy, String master) {
        return this.ptables(greedy, null, null, master, null);
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(boolean greedy, MasterTable master) {
        return this.ptables(greedy, master, null);
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(boolean greedy, MasterTable master, Map<String, Object> tags) {
        return this.ptables(greedy, master, tags, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, PartitionTable> ptables(boolean greedy, MasterTable master, Map<String, Object> tags, String name) {
        LinkedHashMap<String, PartitionTable> tables = new LinkedHashMap<String, PartitionTable>();
        DataSource ds = null;
        Connection con = null;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        String random = this.random();
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                ds = runtime.getTemplate().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                try {
                    List<String> sqls = adapter.buildQueryPartitionTableRunSQL(master, tags, name);
                    if (null != sqls) {
                        int idx = 0;
                        int total = sqls.size();
                        for (String sql : sqls) {
                            if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                            DataSet set = this.select(runtime, null, sql, null).toUpperKey();
                            tables = adapter.ptables(total, idx++, true, master, master.getCatalog(), master.getSchema(), tables, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[tables][{}][stable:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), master.getName(), e.toString()});
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[tables][stable:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, master.getName(), tables.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional(con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return tables;
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(String catalog, String schema, String master, String name) {
        MasterTable mtable = new MasterTable(catalog, schema, master);
        return this.ptables(false, mtable, null, name);
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(String schema, String master, String name) {
        return this.ptables(false, null, schema, master, name);
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(String master, String name) {
        return this.ptables(false, null, null, master, name);
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(String master) {
        return this.ptables(false, null, null, master, null);
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(MasterTable master) {
        return this.ptables(false, master, null);
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(MasterTable master, Map<String, Object> tags) {
        return this.ptables(false, master, tags, null);
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(MasterTable master, Map<String, Object> tags, String name) {
        return this.ptables(false, master, tags, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, org.anyline.data.entity.Column> columns(boolean greedy, Table table) {
        int qty1;
        String schema;
        String catalog;
        JDBCAdapter adapter;
        DatabaseMetaData metadata;
        String random;
        Connection con;
        DataSource ds;
        long fr;
        LinkedHashMap<String, org.anyline.data.entity.Column> columns;
        block22: {
            List<String> sqls;
            JDBCRuntime runtime;
            block21: {
                columns = new LinkedHashMap<String, org.anyline.data.entity.Column>();
                if (null == table || BasicUtil.isEmpty((Object)table.getName())) {
                    return columns;
                }
                fr = System.currentTimeMillis();
                ds = null;
                con = null;
                random = null;
                metadata = null;
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    random = this.random();
                }
                runtime = this.runtime();
                adapter = runtime.getAdapter();
                if (!greedy) {
                    adapter.checkSchema(runtime.getTemplate().getDataSource(), table);
                }
                catalog = table.getCatalog();
                schema = table.getSchema();
                try {
                    ds = runtime.getTemplate().getDataSource();
                    con = DataSourceUtils.getConnection((DataSource)ds);
                    metadata = con.getMetaData();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    sqls = adapter.buildQueryColumnRunSQL(table, true);
                    if (null != sqls) {
                        for (String sql : sqls) {
                            if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                            SqlRowSet set = runtime.getTemplate().queryForRowSet(sql);
                            columns = adapter.columns(true, columns, table, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block21;
                    log.warn("{}[columns][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636emetadata\u89e3\u6790\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                }
            }
            qty1 = columns.size();
            try {
                sqls = adapter.buildQueryColumnRunSQL(table, false);
                if (null != sqls) {
                    int idx = 0;
                    for (String sql : sqls) {
                        if (BasicUtil.isNotEmpty((Object)sql)) {
                            DataSet set = this.select(runtime, null, sql, null);
                            columns = adapter.columns(idx, true, table, columns, set);
                        }
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block22;
                log.warn("{}[columns][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
            }
        }
        int qty2 = columns.size() - qty1;
        try {
            columns = adapter.columns(true, columns, metadata, table, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        int qty3 = columns.size() - qty1 - qty2;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[columns][catalog:{}][schema:{}][table:{}][total:{}][\u6839\u636emetadata\u89e3\u6790:{}][\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2:{}][\u6839\u636ejdbc\u63a5\u53e3\u8865\u5145:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, table, columns.size(), qty1, qty2, qty3, System.currentTimeMillis() - fr});
        }
        return columns;
    }

    @Override
    public LinkedHashMap<String, org.anyline.data.entity.Column> columns(boolean greedy, String table) {
        return this.columns(greedy, null, null, table);
    }

    @Override
    public LinkedHashMap<String, org.anyline.data.entity.Column> columns(boolean greedy, String catalog, String schema, String table) {
        Table tab = new Table(catalog, schema, table);
        return this.columns(greedy, tab);
    }

    @Override
    public LinkedHashMap<String, org.anyline.data.entity.Column> columns(Table table) {
        return this.columns(false, table);
    }

    @Override
    public LinkedHashMap<String, org.anyline.data.entity.Column> columns(String table) {
        return this.columns(false, null, null, table);
    }

    @Override
    public LinkedHashMap<String, org.anyline.data.entity.Column> columns(String catalog, String schema, String table) {
        Table tab = new Table(catalog, schema, table);
        return this.columns(false, tab);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, Tag> tags(boolean greedy, Table table) {
        String schema;
        String catalog;
        JDBCAdapter adapter;
        DatabaseMetaData metadata;
        String random;
        Connection con;
        DataSource ds;
        long fr;
        LinkedHashMap<String, Tag> tags;
        block22: {
            List<String> sqls;
            JDBCRuntime runtime;
            block21: {
                tags = new LinkedHashMap<String, Tag>();
                if (null == table || BasicUtil.isEmpty((Object)table.getName())) {
                    return tags;
                }
                fr = System.currentTimeMillis();
                ds = null;
                con = null;
                random = null;
                metadata = null;
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    random = this.random();
                }
                runtime = this.runtime();
                adapter = runtime.getAdapter();
                if (!greedy) {
                    this.checkSchema(runtime, table);
                }
                catalog = table.getCatalog();
                schema = table.getSchema();
                try {
                    ds = runtime.getTemplate().getDataSource();
                    con = DataSourceUtils.getConnection((DataSource)ds);
                    metadata = con.getMetaData();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    sqls = adapter.buildQueryTagRunSQL(table, true);
                    if (null != sqls) {
                        for (String sql : sqls) {
                            if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                            SqlRowSet set = runtime.getTemplate().queryForRowSet(sql);
                            tags = adapter.tags(true, table, tags, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block21;
                    log.warn("{}[tags][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636emetadata\u89e3\u6790\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                }
            }
            try {
                sqls = adapter.buildQueryTagRunSQL(table, false);
                if (null != sqls) {
                    int idx = 0;
                    for (String sql : sqls) {
                        if (BasicUtil.isNotEmpty((Object)sql)) {
                            DataSet set = this.select(runtime, null, sql, null).toUpperKey();
                            tags = adapter.tags(idx, true, table, tags, set);
                        }
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block22;
                log.warn("{}[tags][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
            }
        }
        try {
            tags = adapter.tags(false, tags, metadata, table, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[tags][catalog:{}][schema:{}][table:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, table, System.currentTimeMillis() - fr});
        }
        return tags;
    }

    @Override
    public LinkedHashMap<String, Tag> tags(boolean greedy, String table) {
        Table tab = new Table();
        tab.setName(table);
        return this.tags(greedy, tab);
    }

    @Override
    public LinkedHashMap<String, Tag> tags(boolean greedy, String catalog, String schema, String table) {
        Table tab = new Table();
        tab.setCatalog(catalog);
        tab.setSchema(schema);
        tab.setName(table);
        return this.tags(greedy, tab);
    }

    @Override
    public LinkedHashMap<String, Tag> tags(Table table) {
        return this.tags(false, table);
    }

    @Override
    public LinkedHashMap<String, Tag> tags(String table) {
        return this.tags(false, table);
    }

    @Override
    public LinkedHashMap<String, Tag> tags(String catalog, String schema, String table) {
        return this.tags(false, catalog, schema, table);
    }

    @Override
    public PrimaryKey primary(boolean greedy, Table table) {
        PrimaryKey primary;
        block7: {
            primary = null;
            JDBCRuntime runtime = this.runtime();
            JDBCAdapter adapter = runtime.getAdapter();
            if (!greedy) {
                adapter.checkSchema(runtime.getTemplate().getDataSource(), table);
            }
            String tab = table.getName();
            String catalog = table.getCatalog();
            String schema = table.getSchema();
            Object ds = null;
            Object con = null;
            String random = null;
            Object metadata = null;
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                random = this.random();
            }
            try {
                List<String> sqls = adapter.buildQueryPrimaryRunSQL(table);
                if (null != sqls) {
                    int idx = 0;
                    for (String sql : sqls) {
                        DataSet set;
                        if (BasicUtil.isNotEmpty((Object)sql) && null != (primary = adapter.primary(idx, table, set = this.select(runtime, null, sql, null).toUpperKey()))) {
                            primary.setTable(table);
                        }
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block7;
                log.warn("{}[tags][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
            }
        }
        return primary;
    }

    @Override
    public PrimaryKey primary(boolean greedy, String table) {
        Table tab = new Table();
        tab.setName(table);
        return this.primary(greedy, tab);
    }

    @Override
    public PrimaryKey primary(boolean greedy, String catalog, String schema, String table) {
        Table tab = new Table();
        tab.setCatalog(catalog);
        tab.setSchema(schema);
        tab.setName(table);
        return this.primary(greedy, tab);
    }

    @Override
    public PrimaryKey primary(Table table) {
        return this.primary(false, table);
    }

    @Override
    public PrimaryKey primary(String table) {
        return this.primary(false, table);
    }

    @Override
    public PrimaryKey primary(String catalog, String schema, String table) {
        return this.primary(false, catalog, schema, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, Index> indexs(boolean greedy, Table table, String name) {
        List<String> sqls;
        LinkedHashMap<String, Index> indexs = null;
        if (null == table) {
            table = new Table();
        }
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        if (!greedy) {
            adapter.checkSchema(runtime.getTemplate().getDataSource(), table);
        }
        if (null != table.getName()) {
            DataSource ds = null;
            Connection con = null;
            try {
                ds = runtime.getTemplate().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                indexs = adapter.indexs(true, indexs, con.getMetaData(), table, false, false);
                table.setIndexs(indexs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                    DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
                }
            }
            if (BasicUtil.isNotEmpty((Object)name)) {
                Index index = (Index)indexs.get(name.toUpperCase());
                indexs = new LinkedHashMap();
                indexs.put(name.toUpperCase(), index);
            }
        }
        if (null != (sqls = adapter.buildQueryIndexRunSQL(table, name))) {
            int idx = 0;
            for (String sql : sqls) {
                if (BasicUtil.isNotEmpty((Object)sql)) {
                    DataSet set = this.select(runtime, null, sql, null).toUpperKey();
                    try {
                        indexs = adapter.indexs(idx, true, table, indexs, set);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return indexs;
    }

    @Override
    public LinkedHashMap<String, Index> indexs(boolean greedy, Table table) {
        return this.indexs(greedy, table, null);
    }

    @Override
    public LinkedHashMap<String, Index> indexs(boolean greedy, String table, String name) {
        return this.indexs(greedy, new Table(table), name);
    }

    @Override
    public LinkedHashMap<String, Index> indexs(boolean greedy, String table) {
        return this.indexs(greedy, new Table(table), null);
    }

    @Override
    public LinkedHashMap<String, Index> indexs(boolean greedy, String catalog, String schema, String table) {
        return this.indexs(greedy, new Table(catalog, schema, table), null);
    }

    @Override
    public LinkedHashMap<String, Index> indexs(Table table, String name) {
        return this.indexs(false, table, name);
    }

    @Override
    public LinkedHashMap<String, Index> indexs(Table table) {
        return this.indexs(false, table);
    }

    @Override
    public LinkedHashMap<String, Index> indexs(String table, String name) {
        return this.indexs(false, table, name);
    }

    @Override
    public LinkedHashMap<String, Index> indexs(String table) {
        return this.indexs(false, table);
    }

    @Override
    public LinkedHashMap<String, Index> indexs(String catalog, String schema, String table) {
        return this.indexs(false, catalog, schema, table);
    }

    @Override
    public LinkedHashMap<String, Constraint> constraints(boolean greedy, Table table, String name) {
        return null;
    }

    @Override
    public LinkedHashMap<String, Constraint> constraints(boolean greedy, Table table) {
        return this.constraints(greedy, table, null);
    }

    @Override
    public LinkedHashMap<String, Constraint> constraints(boolean greedy, String table) {
        return this.constraints(greedy, new Table(table));
    }

    @Override
    public LinkedHashMap<String, Constraint> constraints(boolean greedy, String table, String name) {
        return this.constraints(greedy, new Table(table), name);
    }

    @Override
    public LinkedHashMap<String, Constraint> constraints(boolean greedy, String catalog, String schema, String table) {
        return this.constraints(greedy, new Table(catalog, schema, table));
    }

    @Override
    public LinkedHashMap<String, Constraint> constraints(Table table, String name) {
        return this.constraints(false, table, name);
    }

    @Override
    public LinkedHashMap<String, Constraint> constraints(Table table) {
        return this.constraints(false, table);
    }

    @Override
    public LinkedHashMap<String, Constraint> constraints(String table) {
        return this.constraints(false, new Table(table));
    }

    @Override
    public LinkedHashMap<String, Constraint> constraints(String table, String name) {
        return this.constraints(false, new Table(table), name);
    }

    @Override
    public LinkedHashMap<String, Constraint> constraints(String catalog, String schema, String table) {
        return this.constraints(false, new Table(catalog, schema, table));
    }

    @Override
    public boolean create(Table table) throws Exception {
        boolean result = false;
        long fr = System.currentTimeMillis();
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        adapter.checkSchema(runtime.getTemplate().getDataSource(), table);
        List<String> sqls = adapter.buildCreateRunSQL(table);
        DDListener listener = table.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeCreate(table);
        }
        if (exe) {
            for (String sql : sqls) {
                String random = null;
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    random = this.random();
                    log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
                }
                runtime.getTemplate().update(sql);
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) continue;
                log.warn("{}[create table][table:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), System.currentTimeMillis() - fr});
            }
            result = true;
        }
        if (null != listener) {
            listener.afterCreate(table, result);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean alter(Table table) throws Exception {
        boolean result = false;
        Table update = table.getUpdate();
        LinkedHashMap<String, org.anyline.data.entity.Column> columns = table.getColumns();
        LinkedHashMap<String, org.anyline.data.entity.Column> ucolumns = update.getColumns();
        String name = table.getName();
        String uname = update.getName();
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        adapter.checkSchema(runtime.getTemplate().getDataSource(), table);
        adapter.checkSchema(runtime.getTemplate().getDataSource(), update);
        if (!name.equalsIgnoreCase(uname)) {
            String sql = adapter.buildRenameRunSQL(table);
            Object var13_12 = null;
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                String string = this.random();
                log.warn("{}[sql:\n{}\n]", (Object)string, (Object)sql);
            }
            DDListener listener = table.getListener();
            boolean exe = true;
            if (null != listener) {
                exe = listener.beforeRename(table);
            }
            if (exe) {
                runtime.getTemplate().update(sql);
                result = true;
            }
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                void var13_14;
                log.warn("{}[rename table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{var13_14, table.getName(), result, System.currentTimeMillis() - fr});
            }
            if (null != listener) {
                listener.afterRename(table, result);
            }
        }
        for (org.anyline.data.entity.Column column : ucolumns.values()) {
            org.anyline.data.entity.Column column2 = columns.get(column.getName().toUpperCase());
            if (null != column2) {
                if (!column2.equals(column)) continue;
                column2.setTable(update);
                column2.setUpdate(column);
                column2.setService(table.getService());
                this.alter(column2);
                result = true;
                continue;
            }
            column.setTable(update);
            this.add(column);
            result = true;
        }
        ArrayList<String> deletes = new ArrayList<String>();
        for (org.anyline.data.entity.Column column2 : ucolumns.values()) {
            if (!column2.isDelete()) continue;
            this.drop(column2);
            deletes.add(column2.getName().toUpperCase());
        }
        if (table.isAutoDropColumn()) {
            for (org.anyline.data.entity.Column column2 : columns.values()) {
                org.anyline.data.entity.Column ucolumn;
                if (column2 instanceof Tag || column2.isDelete() || deletes.contains(column2.getName().toUpperCase()) || null != (ucolumn = ucolumns.get(column2.getName().toUpperCase()))) continue;
                column2.setTable(update);
                this.drop(column2);
                result = true;
            }
        }
        PrimaryKey primaryKey = this.primary(update);
        PrimaryKey cur_primary = update.getPrimaryKey();
        String src_define = "";
        String cur_define = "";
        if (null != primaryKey) {
            src_define = BeanUtil.concat(primaryKey.getColumns().values(), (String)"name", (String)",");
        }
        if (null != cur_primary) {
            cur_define = BeanUtil.concat(cur_primary.getColumns().values(), (String)"name", (String)",");
        }
        if (!cur_define.equalsIgnoreCase(src_define)) {
            if (null != primaryKey) {
                this.drop(primaryKey);
            }
            if (null != cur_primary) {
                this.add(cur_primary);
            }
        }
        CacheProxy.clearTableMaps(DataSourceHolder.curDataSource() + "");
        return result;
    }

    @Override
    public boolean drop(Table table) throws Exception {
        boolean result = false;
        long fr = System.currentTimeMillis();
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        adapter.checkSchema(runtime.getTemplate().getDataSource(), table);
        String sql = adapter.buildDropRunSQL(table);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = table.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(table);
        }
        if (exe) {
            runtime.getTemplate().update(sql);
            CacheProxy.clearTableMaps(DataSourceHolder.curDataSource() + "");
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[drop table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(table, result);
        }
        return result;
    }

    @Override
    public boolean create(View view) throws Exception {
        boolean result = false;
        long fr = System.currentTimeMillis();
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        adapter.checkSchema(runtime.getTemplate().getDataSource(), (Table)view);
        List<String> sqls = adapter.buildCreateRunSQL(view);
        DDListener listener = view.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeCreate(view);
        }
        if (exe) {
            for (String sql : sqls) {
                String random = null;
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    random = this.random();
                    log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
                }
                runtime.getTemplate().update(sql);
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) continue;
                log.warn("{}[create view][view:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, view.getName(), System.currentTimeMillis() - fr});
            }
            result = true;
        }
        if (null != listener) {
            listener.afterCreate(view, result);
        }
        return result;
    }

    @Override
    public boolean alter(View view) throws Exception {
        boolean result = false;
        View update = (View)view.getUpdate();
        String name = view.getName();
        String uname = update.getName();
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        adapter.checkSchema(runtime.getTemplate().getDataSource(), (Table)view);
        adapter.checkSchema(runtime.getTemplate().getDataSource(), (Table)update);
        if (!name.equalsIgnoreCase(uname)) {
            String sql = adapter.buildRenameRunSQL(view);
            String random = null;
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                random = this.random();
                log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
            }
            DDListener listener = view.getListener();
            boolean exe = true;
            if (null != listener) {
                exe = listener.beforeRename(view);
            }
            if (exe) {
                runtime.getTemplate().update(sql);
                result = true;
            }
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[rename view][view:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, view.getName(), result, System.currentTimeMillis() - fr});
            }
            if (null != listener) {
                listener.afterRename(view, result);
            }
        }
        CacheProxy.clearViewMaps(DataSourceHolder.curDataSource() + "");
        return result;
    }

    @Override
    public boolean drop(View view) throws Exception {
        boolean result = false;
        long fr = System.currentTimeMillis();
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        adapter.checkSchema(runtime.getTemplate().getDataSource(), (Table)view);
        String sql = adapter.buildDropRunSQL(view);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = view.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(view);
        }
        if (exe) {
            runtime.getTemplate().update(sql);
            CacheProxy.clearViewMaps(DataSourceHolder.curDataSource() + "");
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[drop view][view:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, view.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(view, result);
        }
        return result;
    }

    @Override
    public boolean create(MasterTable table) throws Exception {
        boolean result = false;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        adapter.checkSchema(runtime.getTemplate().getDataSource(), (Table)table);
        List<String> sqls = adapter.buildCreateRunSQL(table);
        String random = null;
        DDListener listener = table.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(table);
        }
        if (exe) {
            for (String sql : sqls) {
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    random = this.random();
                    log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
                }
                runtime.getTemplate().update(sql);
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) continue;
                log.warn("{}[create master table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
            }
            result = true;
        }
        if (null != listener) {
            listener.afterDrop(table, result);
        }
        return result;
    }

    @Override
    public boolean alter(MasterTable table) throws Exception {
        boolean result = false;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        adapter.checkSchema(runtime.getTemplate().getDataSource(), (Table)table);
        Table update = table.getUpdate();
        LinkedHashMap<String, org.anyline.data.entity.Column> columns = table.getColumns();
        LinkedHashMap<String, org.anyline.data.entity.Column> ucolumns = update.getColumns();
        LinkedHashMap<String, Tag> tags = table.getTags();
        LinkedHashMap<String, Tag> utags = update.getTags();
        String name = table.getName();
        String uname = update.getName();
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            String sql = adapter.buildRenameRunSQL(table);
            String random = null;
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                random = this.random();
                log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
            }
            DDListener listener = table.getListener();
            boolean exe = true;
            if (null != listener) {
                exe = listener.beforeRename(table);
            }
            if (exe) {
                runtime.getTemplate().update(sql);
                result = true;
            }
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[rename master table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
            }
            if (null != listener) {
                listener.afterRename(table, result);
            }
        }
        for (org.anyline.data.entity.Column ucolumn : ucolumns.values()) {
            org.anyline.data.entity.Column column = columns.get(ucolumn.getName().toUpperCase());
            if (null != column) {
                column.setTable(update);
                column.setUpdate(ucolumn);
                column.setService(table.getService());
                this.alter(column);
                result = true;
                continue;
            }
            ucolumn.setTable(update);
            this.add(ucolumn);
            result = true;
        }
        if (table.isAutoDropColumn()) {
            for (org.anyline.data.entity.Column column : columns.values()) {
                org.anyline.data.entity.Column ucolumn;
                if (column instanceof Tag || null != (ucolumn = ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                this.drop(column);
                result = true;
            }
        }
        for (Tag utag : utags.values()) {
            Tag tag = tags.get(utag.getName().toUpperCase());
            if (null != tag) {
                tag.setTable(update);
                tag.setUpdate(utag);
                tag.setService(table.getService());
                this.alter(tag);
                result = true;
                continue;
            }
            utag.setTable(update);
            this.add(utag);
            result = true;
        }
        if (table.isAutoDropColumn()) {
            for (Tag tag : tags.values()) {
                Tag utag = utags.get(tag.getName().toUpperCase());
                if (null != utag) continue;
                tag.setTable(update);
                this.drop(tag);
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean drop(MasterTable table) throws Exception {
        boolean result = false;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        adapter.checkSchema(runtime.getTemplate().getDataSource(), (Table)table);
        String sql = adapter.buildDropRunSQL(table);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = table.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(table);
        }
        if (exe) {
            runtime.getTemplate().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[drop master table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(table, result);
        }
        return result;
    }

    @Override
    public boolean create(PartitionTable table) throws Exception {
        boolean result = false;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        adapter.checkSchema(runtime.getTemplate().getDataSource(), (Table)table);
        List<String> sqls = adapter.buildCreateRunSQL(table);
        DDListener listener = table.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(table);
        }
        if (exe) {
            for (String sql : sqls) {
                String random = null;
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    random = this.random();
                    log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
                }
                runtime.getTemplate().update(sql);
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) continue;
                log.warn("{}[create partition table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
            }
            result = true;
        }
        if (null != listener) {
            listener.afterDrop(table, result);
        }
        return result;
    }

    @Override
    public boolean alter(PartitionTable table) throws Exception {
        boolean result = false;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        adapter.checkSchema(runtime.getTemplate().getDataSource(), (Table)table);
        Table update = table.getUpdate();
        LinkedHashMap<String, org.anyline.data.entity.Column> columns = table.getColumns();
        LinkedHashMap<String, org.anyline.data.entity.Column> ucolumns = update.getColumns();
        String name = table.getName();
        String uname = update.getName();
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            String sql = adapter.buildRenameRunSQL(table);
            String random = null;
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                random = this.random();
                log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
            }
            DDListener listener = table.getListener();
            boolean exe = true;
            if (null != listener) {
                exe = listener.beforeRename(table);
            }
            if (exe) {
                runtime.getTemplate().update(sql);
                result = true;
            }
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[rename partition table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
            }
            if (null != listener) {
                listener.afterRename(table, result);
            }
        }
        for (org.anyline.data.entity.Column ucolumn : ucolumns.values()) {
            org.anyline.data.entity.Column column = columns.get(ucolumn.getName().toUpperCase());
            if (null != column) {
                column.setTable(update);
                column.setUpdate(ucolumn);
                column.setService(table.getService());
                this.alter(column);
                result = true;
                continue;
            }
            ucolumn.setTable(update);
            this.add(ucolumn);
            result = true;
        }
        if (table.isAutoDropColumn()) {
            for (org.anyline.data.entity.Column column : columns.values()) {
                org.anyline.data.entity.Column ucolumn;
                if (column instanceof Tag || null != (ucolumn = ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                this.drop(column);
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean drop(PartitionTable table) throws Exception {
        boolean result = false;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        adapter.checkSchema(runtime.getTemplate().getDataSource(), (Table)table);
        String sql = adapter.buildDropRunSQL(table);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = table.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(table);
        }
        if (exe) {
            runtime.getTemplate().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[drop partition table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(table, result);
        }
        return result;
    }

    @Override
    public boolean add(org.anyline.data.entity.Column column) throws Exception {
        boolean result = false;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        this.checkSchema(runtime, column);
        String random = null;
        String sql = adapter.buildAddRunSQL(column);
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = column.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeAdd(column);
        }
        if (exe) {
            runtime.getTemplate().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[add column][table:{}][column:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, column.getTableName(), column.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean alter(Table table, org.anyline.data.entity.Column column) throws Exception {
        return this.alter(table, column, true);
    }

    @Override
    public boolean alter(org.anyline.data.entity.Column column) throws Exception {
        Table table = column.getTable();
        if (null == table) {
            LinkedHashMap<String, Table> tables = this.tables(column.getCatalog(), column.getSchema(), column.getTableName(), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + column.getTableName());
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + column.getTableName());
            } else {
                table = tables.values().iterator().next();
            }
        }
        return this.alter(table, column, true);
    }

    @Override
    public boolean drop(org.anyline.data.entity.Column column) throws Exception {
        boolean result = false;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        this.checkSchema(runtime, column);
        String sql = adapter.buildDropRunSQL(column);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = column.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(column);
        }
        if (exe) {
            runtime.getTemplate().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[drop column][table:{}][column:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, column.getTableName(), column.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(column, result);
        }
        return result;
    }

    private boolean alter(Table table, org.anyline.data.entity.Column column, boolean trigger) throws Exception {
        boolean result = true;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        String random = null;
        this.checkSchema(runtime, column);
        List<String> sqls = adapter.buildAlterRunSQL(column);
        random = this.random();
        DDListener listener = column.getListener();
        try {
            for (String sql : sqls) {
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
                }
                boolean exe = true;
                if (null != listener) {
                    exe = listener.beforeAlter(column);
                }
                if (!exe) continue;
                runtime.getTemplate().update(sql);
                result = true;
            }
        }
        catch (Exception e) {
            log.warn("{}[{}][exception:{}]", new Object[]{random, LogUtil.format((String)"\u4fee\u6539Column\u6267\u884c\u5f02\u5e38", (int)33), e.toString()});
            if (trigger && null != listener && !BasicUtil.equalsIgnoreCase((Object)column.getTypeName(), (Object)column.getUpdate().getTypeName())) {
                boolean exe = false;
                if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION != 0) {
                    exe = listener.afterAlterColumnException(table, column, e);
                }
                log.warn("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u5c1d\u8bd5\u4fee\u6b63\u6570\u636e][\u4fee\u6b63\u7ed3\u679c:{}]", (Object)random, (Object)exe);
                if (exe) {
                    result = this.alter(table, column, false);
                }
            }
            log.error("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u4e2d\u65ad\u6267\u884c]", (Object)random);
            result = false;
            throw e;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[update column][table:{}][column:{}][qty:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, column.getTableName(), column.getName(), sqls.size(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean add(Tag tag) throws Exception {
        boolean result = false;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        String random = null;
        this.checkSchema(runtime, tag);
        String sql = adapter.buildAddRunSQL(tag);
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = tag.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeAdd(tag);
        }
        if (exe) {
            runtime.getTemplate().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[add tag][table:{}][tag:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, tag.getTableName(), tag.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean alter(Table table, Tag tag) throws Exception {
        return this.alter(table, tag, true);
    }

    @Override
    public boolean alter(Tag tag) throws Exception {
        Table table = tag.getTable();
        if (null == table) {
            LinkedHashMap<String, Table> tables = this.tables(false, tag.getCatalog(), tag.getSchema(), tag.getTableName(), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + tag.getTableName());
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + tag.getTableName());
            } else {
                table = tables.values().iterator().next();
            }
        }
        return this.alter(table, tag, true);
    }

    @Override
    public boolean drop(Tag tag) throws Exception {
        boolean result = false;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        this.checkSchema(runtime, tag);
        String sql = adapter.buildDropRunSQL(tag);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = tag.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(tag);
        }
        if (exe) {
            runtime.getTemplate().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[drop tag][table:{}][tag:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, tag.getTableName(), tag.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(tag, result);
        }
        return result;
    }

    private boolean alter(Table table, Tag tag, boolean trigger) throws Exception {
        boolean result = true;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        String random = null;
        this.checkSchema(runtime, tag);
        List<String> sqls = adapter.buildAlterRunSQL(tag);
        random = this.random();
        DDListener listener = tag.getListener();
        try {
            for (String sql : sqls) {
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
                }
                boolean exe = true;
                if (null != listener) {
                    exe = listener.beforeAlter(tag);
                }
                if (!exe) continue;
                runtime.getTemplate().update(sql);
                result = true;
            }
        }
        catch (Exception e) {
            log.warn("{}[{}][exception:{}]", new Object[]{random, LogUtil.format((String)"\u4fee\u6539tag\u6267\u884c\u5f02\u5e38", (int)33), e.toString()});
            if (trigger && null != listener && !BasicUtil.equalsIgnoreCase((Object)tag.getTypeName(), (Object)tag.getUpdate().getTypeName())) {
                boolean exe = false;
                if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION != 0) {
                    exe = listener.afterAlterColumnException(table, tag, e);
                }
                log.warn("{}[\u4fee\u6539tag\u6267\u884c\u5f02\u5e38][\u5c1d\u8bd5\u4fee\u6b63\u6570\u636e][\u4fee\u6b63\u7ed3\u679c:{}]", (Object)random, (Object)exe);
                if (exe) {
                    result = this.alter(table, tag, false);
                }
            }
            log.error("{}[\u4fee\u6539tag\u6267\u884c\u5f02\u5e38][\u4e2d\u65ad\u6267\u884c]", (Object)random);
            result = false;
            throw e;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[update tag][table:{}][tag:{}][qty:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, tag.getTableName(), tag.getName(), sqls.size(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean add(PrimaryKey primary) throws Exception {
        boolean result = false;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        String random = null;
        this.checkSchema(runtime, primary);
        String sql = adapter.buildAddRunSQL(primary);
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = primary.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeAdd(primary);
        }
        if (exe) {
            runtime.getTemplate().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[add primary][table:{}][primary:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, primary.getTableName(), primary.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean alter(PrimaryKey primary) throws Exception {
        Table table = primary.getTable();
        if (null == table) {
            LinkedHashMap<String, Table> tables = this.tables(false, primary.getCatalog(), primary.getSchema(), primary.getTableName(), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + primary.getTableName());
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + primary.getTableName());
            } else {
                table = tables.values().iterator().next();
            }
        }
        return this.alter(table, primary);
    }

    @Override
    public boolean alter(Table table, PrimaryKey primary) throws Exception {
        boolean result = true;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        String random = null;
        this.checkSchema(runtime, primary);
        List<String> sqls = adapter.buildAlterRunSQL(primary);
        random = this.random();
        DDListener listener = primary.getListener();
        for (String sql : sqls) {
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
            }
            boolean exe = true;
            if (null != listener) {
                exe = listener.beforeAlter(primary);
            }
            if (!exe) continue;
            runtime.getTemplate().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[update primary][table:{}][primary:{}][qty:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, primary.getTableName(), primary.getName(), sqls.size(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean drop(PrimaryKey primary) throws Exception {
        boolean result = false;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        this.checkSchema(runtime, primary);
        String sql = adapter.buildDropRunSQL(primary);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = primary.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(primary);
        }
        if (exe) {
            runtime.getTemplate().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[drop index][table:{}][index:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, primary.getTableName(), primary.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(primary, result);
        }
        return result;
    }

    @Override
    public boolean add(Index index) throws Exception {
        boolean result = false;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        String random = null;
        this.checkSchema(runtime, index);
        String sql = adapter.buildAddRunSQL(index);
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = index.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeAdd(index);
        }
        if (exe) {
            runtime.getTemplate().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[add index][table:{}][index:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, index.getTableName(), index.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean alter(Index index) throws Exception {
        Table table = index.getTable();
        if (null == table) {
            LinkedHashMap<String, Table> tables = this.tables(false, index.getCatalog(), index.getSchema(), index.getTableName(), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + index.getTableName());
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + index.getTableName());
            } else {
                table = tables.values().iterator().next();
            }
        }
        return this.alter(table, index);
    }

    @Override
    public boolean alter(Table table, Index index) throws Exception {
        boolean result = true;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        String random = null;
        this.checkSchema(runtime, index);
        List<String> sqls = adapter.buildAlterRunSQL(index);
        random = this.random();
        DDListener listener = index.getListener();
        for (String sql : sqls) {
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
            }
            boolean exe = true;
            if (null != listener) {
                exe = listener.beforeAlter(index);
            }
            if (!exe) continue;
            runtime.getTemplate().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[update index][table:{}][index:{}][qty:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, index.getTableName(), index.getName(), sqls.size(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean drop(Index index) throws Exception {
        boolean result = false;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        this.checkSchema(runtime, index);
        String sql = adapter.buildDropRunSQL(index);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = index.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(index);
        }
        if (exe) {
            runtime.getTemplate().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[drop index][table:{}][index:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, index.getTableName(), index.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(index, result);
        }
        return result;
    }

    @Override
    public boolean add(Constraint constraint) throws Exception {
        boolean result = false;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        String random = null;
        this.checkSchema(runtime, constraint);
        String sql = adapter.buildAddRunSQL(constraint);
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = constraint.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeAdd(constraint);
        }
        if (exe) {
            runtime.getTemplate().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[add constraint][table:{}][constraint:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, constraint.getTableName(), constraint.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean alter(Constraint constraint) throws Exception {
        Table table = constraint.getTable();
        if (null == table) {
            LinkedHashMap<String, Table> tables = this.tables(false, constraint.getCatalog(), constraint.getSchema(), constraint.getTableName(), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + constraint.getTableName());
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + constraint.getTableName());
            } else {
                table = tables.values().iterator().next();
            }
        }
        return this.alter(table, constraint);
    }

    @Override
    public boolean alter(Table table, Constraint constraint) throws Exception {
        boolean result = true;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        String random = null;
        this.checkSchema(runtime, constraint);
        List<String> sqls = adapter.buildAlterRunSQL(constraint);
        random = this.random();
        DDListener listener = constraint.getListener();
        for (String sql : sqls) {
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
            }
            boolean exe = true;
            if (null != listener) {
                exe = listener.beforeAlter(constraint);
            }
            if (!exe) continue;
            runtime.getTemplate().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[update constraint][table:{}][constraint:{}][qty:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, constraint.getTableName(), constraint.getName(), sqls.size(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean drop(Constraint constraint) throws Exception {
        boolean result = false;
        JDBCRuntime runtime = this.runtime();
        JDBCAdapter adapter = runtime.getAdapter();
        long fr = System.currentTimeMillis();
        this.checkSchema(runtime, constraint);
        String sql = adapter.buildDropRunSQL(constraint);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = this.random();
            log.warn("{}[sql:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = constraint.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(constraint);
        }
        if (exe) {
            runtime.getTemplate().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[drop constraint][table:{}][constraint:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, constraint.getTableName(), constraint.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(constraint, result);
        }
        return result;
    }

    public void checkSchema(JDBCRuntime runtime, Table table) {
        if (null != table) {
            JDBCAdapter adapter = runtime.getAdapter();
            adapter.checkSchema(runtime.getTemplate().getDataSource(), table);
            table.setCatalog(table.getCatalog());
            table.setSchema(table.getSchema());
        }
    }

    public void checkSchema(JDBCRuntime runtime, org.anyline.data.entity.Column column) {
        Table table = column.getTable();
        if (null != table) {
            this.checkSchema(runtime, table);
            column.setCatalog(table.getCatalog());
            column.setSchema(table.getSchema());
        }
    }

    public void checkSchema(JDBCRuntime runtime, Index index) {
        Table table = index.getTable();
        if (null != table) {
            this.checkSchema(runtime, table);
            index.setCatalog(table.getCatalog());
            index.setSchema(table.getSchema());
        }
    }

    public void checkSchema(JDBCRuntime runtime, Constraint constraint) {
        Table table = constraint.getTable();
        if (null != table) {
            this.checkSchema(runtime, table);
            constraint.setCatalog(table.getCatalog());
            constraint.setSchema(table.getSchema());
        }
    }

    protected String paramLogFormat(List<?> params) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        if (null != params) {
            int idx = 0;
            for (Object param : params) {
                builder.append("param").append(idx++).append("=");
                builder.append(param);
                if (null != param) {
                    builder.append("(").append(param.getClass().getName()).append(")");
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String paramLogFormat(List<?> keys, List<?> values) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        if (null != keys && null != values) {
            if (keys.size() != values.size()) return this.paramLogFormat(values);
            int size = keys.size();
            for (int i = 0; i < size; ++i) {
                Object key = keys.get(i);
                Object value = values.get(i);
                builder.append(keys.get(i)).append("=");
                builder.append(value);
                if (null != value) {
                    builder.append("(").append(value.getClass().getName()).append(")");
                }
                builder.append("\n");
            }
            return builder.toString();
        } else {
            if (null == values) return builder.toString();
            builder.append(BeanUtil.concat(values, (boolean)true)).append("\n");
        }
        return builder.toString();
    }

    private String random() {
        StringBuilder builder = new StringBuilder();
        builder.append("[SQL:").append(System.currentTimeMillis()).append("-").append(BasicUtil.getRandomNumberString((int)8)).append("][thread:").append(Thread.currentThread().getId()).append("][ds:").append(this.runtime().getKey()).append("]");
        return builder.toString();
    }
}

