/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.run;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.SyntaxHelper;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.auto.AutoCondition;
import org.anyline.data.prepare.auto.init.DefaultAutoCondition;
import org.anyline.data.prepare.auto.init.DefaultAutoConditionChain;
import org.anyline.data.prepare.init.DefaultVariable;
import org.anyline.data.run.BasicRun;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.entity.Compare;
import org.anyline.entity.DefaultOrderStore;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.util.BasicUtil;
import org.anyline.util.regular.Regular;
import org.anyline.util.regular.RegularUtil;

public class TextRun
extends BasicRun
implements Run {
    public TextRun() {
        this.builder = new StringBuilder();
        this.conditionChain = new DefaultAutoConditionChain();
        this.orderStore = new DefaultOrderStore();
        this.setStrict(false);
    }

    @Override
    public Run setPrepare(RunPrepare prepare) {
        this.prepare = prepare;
        this.table = prepare.getTable();
        this.parseText();
        return this;
    }

    @Override
    public void init() {
        Object conditions;
        super.init();
        if (null != this.conditionChain && null != (conditions = this.conditionChain.getConditions())) {
            Iterator<Condition> iterator = conditions.iterator();
            while (iterator.hasNext()) {
                Condition condition = iterator.next();
                if (null == condition) continue;
                AutoCondition con = (AutoCondition)condition;
                List<Variable> vars = this.getVariables(con.getId());
                if (vars.size() > 0) {
                    con.setVariableSlave(true);
                    for (Variable var : vars) {
                        var.setValue(false, con.getValues());
                    }
                    continue;
                }
                this.setConditionValue(con.isRequired(), con.isStrictRequired(), con.getId(), null, con.getValues(), con.getCompare());
            }
        }
        if (null != this.configStore) {
            PageNavi navi;
            List orders;
            for (Config conf : this.configStore.getConfigChain().getConfigs()) {
                List<Variable> vars = this.getVariables(conf.getVariable());
                List<Condition> cons = this.getConditions(conf.getVariable());
                if (vars.size() > 0) {
                    for (Condition con : cons) {
                        if (null == con) continue;
                        con.setVariableSlave(true);
                    }
                    for (Variable var : vars) {
                        var.setValue(false, conf.getValues());
                    }
                }
                for (Condition con : cons) {
                    if (null == con) continue;
                    this.setConditionValue(conf.isRequire(), conf.isStrictRequired(), conf.getVariable(), conf.getVariable(), conf.getValues(), conf.getCompare());
                }
                if (vars.size() != 0 || cons.size() != 0) continue;
                this.conditionChain.addCondition(conf.createAutoCondition(this.conditionChain));
            }
            OrderStore orderStore = this.configStore.getOrders();
            if (null != orderStore && null != (orders = orderStore.getOrders())) {
                for (Order order : orders) {
                    this.addOrder(order);
                }
            }
            if ((navi = this.configStore.getPageNavi()) != null) {
                this.pageNavi = navi;
            }
        }
    }

    private void parseText() {
        String text = this.prepare.getText();
        if (null == text) {
            return;
        }
        try {
            int varType = -1;
            Compare compare = Compare.EQUAL;
            List keys = RegularUtil.fetchs((String)text, (String)"(\\S+)\\s*\\(?(\\s*:+\\w+)(\\s|'|\\)|%|\\,)?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN);
            int type = 1;
            if (keys.size() == 0) {
                keys = RegularUtil.fetchs((String)text, (String)"([^\\s$]+)\\s*\\(?(\\s*\\$*{\\w+})(\\+|\\s|'|\\)|%)?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN);
                type = 2;
            }
            if (BasicUtil.isNotEmpty((boolean)true, (Object)keys)) {
                for (int i = 0; i < keys.size(); ++i) {
                    List keyItem = (List)keys.get(i);
                    Variable var = SyntaxHelper.buildVariable(type, (String)keyItem.get(0), (String)keyItem.get(1), (String)keyItem.get(2), (String)keyItem.get(3));
                    if (null == var) continue;
                    var.setRequired(true);
                    this.addVariable(var);
                }
            } else {
                List idxKeys = RegularUtil.fetch((String)text, (String)"\\?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN, (int)0);
                if (BasicUtil.isNotEmpty((boolean)true, (Object)idxKeys)) {
                    for (int i = 0; i < idxKeys.size(); ++i) {
                        DefaultVariable var = new DefaultVariable();
                        var.setType(0);
                        var.setRequired(true);
                        this.addVariable(var);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkValid() {
        if (null != this.conditionChain && !this.conditionChain.isValid()) {
            this.valid = false;
        }
    }

    public void appendGroup() {
        if (null != this.groupStore) {
            this.builder.append(this.groupStore.getRunText(this.delimiterFr + this.delimiterTo));
        }
    }

    public void appendCondition() {
        if (null == this.conditionChain) {
            return;
        }
        List<Condition> cons = this.conditionChain.getConditions();
        if (null == cons || cons.size() == 0) {
            return;
        }
        String txt = this.builder.toString();
        boolean where = TextRun.endWithWhere(txt);
        if (!where) {
            this.builder.append(" WHERE 1=1");
        }
        this.builder.append(this.conditionChain.getRunText(null, this.adapter));
        this.addValues(this.conditionChain.getRunValues());
    }

    public void setConfigs(ConfigStore configs) {
        this.configStore = configs;
        if (null != configs) {
            this.pageNavi = configs.getPageNavi();
        }
    }

    @Override
    public Run setConditionValue(boolean required, boolean strictRequired, String condition, String variable, Object value, Compare compare) {
        if (null != this.variables && BasicUtil.isEmpty((Object)variable)) {
            for (Variable v : this.variables) {
                if (null == v || !v.getKey().equalsIgnoreCase(condition)) continue;
                v.setValue(value);
            }
        }
        if (null == condition) {
            return this;
        }
        Condition con = this.getCondition(condition);
        if (null == con) {
            return this;
        }
        variable = ((String)BasicUtil.nvl((Object[])new String[]{variable, condition})).toString();
        con.setValue(variable, value);
        return this;
    }

    @Override
    public Run setConditionValue(boolean required, String condition, String variable, Object value, Compare compare) {
        return this.setConditionValue(required, false, condition, variable, value, compare);
    }

    public TextRun addValues(String key, Object obj) {
        if (null == obj) {
            return this;
        }
        if (null == this.values) {
            this.values = new ArrayList();
        }
        if (null != obj && obj instanceof RunValue) {
            throw new RuntimeException("run value");
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            for (Object item : list) {
                this.addValues(key, item);
            }
        } else {
            this.addValues(new RunValue(key, obj));
        }
        return this;
    }

    @Override
    public Run addOrders(OrderStore orderStore) {
        if (null == orderStore) {
            return this;
        }
        List orders = orderStore.getOrders();
        if (null == orders) {
            return this;
        }
        for (Order order : orders) {
            this.orderStore.order(order);
        }
        return this;
    }

    @Override
    public Run addOrder(Order order) {
        this.orderStore.order(order);
        return this;
    }

    public Run addCondition(String condition, String variable, Object value) {
        if (null != this.variables && BasicUtil.isEmpty((Object)variable)) {
            for (Variable v : this.variables) {
                if (null == v || !v.getKey().equalsIgnoreCase(condition)) continue;
                v.setValue(value);
            }
        }
        if (null == condition) {
            return this;
        }
        Condition con = this.getCondition(condition);
        if (null == con) {
            return this;
        }
        variable = ((String)BasicUtil.nvl((Object[])new String[]{variable, condition})).toString();
        con.setValue(variable, value);
        return this;
    }

    @Override
    public Run addCondition(boolean required, boolean strictRequired, String prefix, String var, Object value, Compare compare) {
        DefaultAutoCondition condition = new DefaultAutoCondition(required, strictRequired, prefix, var, value, compare);
        if (null == this.conditionChain) {
            this.conditionChain = new DefaultAutoConditionChain();
        }
        this.conditionChain.addCondition(condition);
        return this;
    }

    public Variable getVariable(String key) {
        if (null == key || null == this.variables) {
            return null;
        }
        for (Variable var : this.variables) {
            if (null == var || !key.equalsIgnoreCase(var.getKey())) continue;
            return var;
        }
        return null;
    }

    public List<Variable> getVariables(String key) {
        ArrayList<Variable> list = new ArrayList<Variable>();
        if (null == key || null == this.variables) {
            return list;
        }
        for (Variable var : this.variables) {
            if (null == var || !key.equalsIgnoreCase(var.getKey())) continue;
            list.add(var);
        }
        return list;
    }
}

