/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.init;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.SQLStore;
import org.anyline.data.prepare.xml.init.DefaultXMLCondition;
import org.anyline.data.prepare.xml.init.DefaultXMLPrepare;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.FileUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSQLStore
extends SQLStore {
    private static DefaultSQLStore instance;
    private static Hashtable<String, RunPrepare> sqls;
    private static final Logger log;
    private static String sqlDir;
    private static long lastLoadTime;

    protected DefaultSQLStore() {
    }

    public static synchronized void loadSQL() {
        sqlDir = ConfigTable.SQL_STORE_DIR;
        if (null == sqlDir) {
            sqlDir = "${classpath}/sql";
        }
        if (FileUtil.getPathType((String)ConfigTable.getClassPath()) == 0) {
            if (sqlDir.contains("${classpath}")) {
                sqlDir = sqlDir.replace("${classpath}", ConfigTable.getClassPath());
            } else if (sqlDir.startsWith("/")) {
                sqlDir = ConfigTable.getWebRoot() + sqlDir;
            }
            sqlDir = sqlDir.substring(sqlDir.indexOf("!/")).replaceAll("!/", "") + "/";
            log.warn("[\u89e3\u6790SQL][dir:{}]", (Object)sqlDir);
            ArrayList<JarEntry> list = new ArrayList<JarEntry>();
            JarFile jFile = null;
            try {
                jFile = new JarFile(System.getProperty("java.class.path"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (jFile == null) {
                return;
            }
            log.warn("[\u89e3\u6790SQL][scan dir:{}]", (Object)sqlDir);
            Enumeration<JarEntry> jarEntrys = jFile.entries();
            while (jarEntrys.hasMoreElements()) {
                JarEntry entry = jarEntrys.nextElement();
                String name = entry.getName();
                if (name.indexOf(sqlDir) == -1 || !name.endsWith(".xml")) continue;
                list.add(entry);
            }
            for (JarEntry jarEntry : list) {
                String fileName = jarEntry.getName();
                InputStream is = DefaultSQLStore.class.getClassLoader().getResourceAsStream(fileName);
                String prefix = fileName.substring(fileName.indexOf("sql") + 4, fileName.lastIndexOf(".xml")).replace("/", ".").replace("\\", ".");
                sqls.putAll(DefaultSQLStore.parseSQLFile(prefix, is));
            }
        } else {
            File scanDir = null;
            if (sqlDir.contains("${classpath}")) {
                sqlDir = sqlDir.replace("${classpath}", ConfigTable.getClassPath());
                scanDir = new File(sqlDir);
            } else {
                scanDir = sqlDir.startsWith("/WEB-INF") ? new File(ConfigTable.getWebRoot(), sqlDir) : (sqlDir.startsWith("/") ? new File(sqlDir) : new File(ConfigTable.getWebRoot(), sqlDir));
            }
            log.warn("[\u89e3\u6790SQL][scan dir:{}]", (Object)scanDir.getAbsolutePath());
            List files = FileUtil.getAllChildrenFile((File)scanDir, (String[])new String[]{"xml"});
            for (File file : files) {
                if (ConfigTable.isSQLDebug()) {
                    log.warn("[\u89e3\u6790SQL] [FILE:{}]", (Object)file.getAbsolutePath());
                }
                sqls.putAll(DefaultSQLStore.parseSQLFile(file));
            }
        }
        lastLoadTime = System.currentTimeMillis();
    }

    private static Hashtable<String, RunPrepare> parseSQLFile(File file) {
        Hashtable<String, RunPrepare> result = new Hashtable<String, RunPrepare>();
        String fileName = file.getPath();
        fileName = fileName.substring(fileName.indexOf("sql") + 4, fileName.indexOf(".xml")).replace("/", ".").replace("\\", ".").replace("src/main", ".");
        Document document = DefaultSQLStore.createDocument(file);
        if (null == document) {
            return result;
        }
        Element root = document.getRootElement();
        HashMap<String, List<Condition>> gloableConditions = new HashMap<String, List<Condition>>();
        Iterator itrCons = root.elementIterator("conditions");
        while (itrCons.hasNext()) {
            Element conditionGroupElement = (Element)itrCons.next();
            String groupId = conditionGroupElement.attributeValue("id");
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            gloableConditions.put(groupId, conditions);
            Iterator itrParam = conditionGroupElement.elementIterator("condition");
            while (itrParam.hasNext()) {
                conditions.add(DefaultSQLStore.parseCondition(null, null, (Element)itrParam.next()));
            }
        }
        Iterator itrSql = root.elementIterator("sql");
        while (itrSql.hasNext()) {
            Element sqlElement = (Element)itrSql.next();
            String sqlId = fileName + ":" + sqlElement.attributeValue("id");
            boolean strict = BasicUtil.parseBoolean((Object)sqlElement.attributeValue("strict"), (Boolean)false);
            String sqlText = sqlElement.elementText("text");
            DefaultXMLPrepare prepare = new DefaultXMLPrepare();
            prepare.setDataSource(fileName + ":" + sqlId);
            prepare.setText(sqlText);
            prepare.setStrict(strict);
            Iterator itrParam = sqlElement.elementIterator("condition");
            while (itrParam.hasNext()) {
                DefaultSQLStore.parseCondition(prepare, gloableConditions, (Element)itrParam.next());
            }
            String group = sqlElement.elementText("group");
            String order = sqlElement.elementText("order");
            prepare.group(group);
            prepare.order(order);
            if (ConfigTable.isSQLDebug()) {
                log.warn("[\u89e3\u6790SQL][id:{}]\n[text:{}]", (Object)sqlId, (Object)sqlText);
            }
            result.put(sqlId, prepare);
        }
        return result;
    }

    private static Hashtable<String, RunPrepare> parseSQLFile(String prefix, InputStream is) {
        Hashtable<String, RunPrepare> result = new Hashtable<String, RunPrepare>();
        Document document = DefaultSQLStore.createDocument(is);
        if (null == document) {
            return result;
        }
        Element root = document.getRootElement();
        HashMap<String, List<Condition>> gloableConditions = new HashMap<String, List<Condition>>();
        Iterator itrCons = root.elementIterator("conditions");
        while (itrCons.hasNext()) {
            Element conditionGroupElement = (Element)itrCons.next();
            String groupId = conditionGroupElement.attributeValue("id");
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            gloableConditions.put(groupId, conditions);
            Iterator itrParam = conditionGroupElement.elementIterator("condition");
            while (itrParam.hasNext()) {
                conditions.add(DefaultSQLStore.parseCondition(null, null, (Element)itrParam.next()));
            }
        }
        Iterator itrSql = root.elementIterator("sql");
        while (itrSql.hasNext()) {
            Element sqlElement = (Element)itrSql.next();
            String sqlId = prefix + ":" + sqlElement.attributeValue("id");
            boolean strict = BasicUtil.parseBoolean((Object)sqlElement.attributeValue("strict"), (Boolean)false);
            String sqlText = sqlElement.elementText("text");
            DefaultXMLPrepare prepare = new DefaultXMLPrepare();
            prepare.setDataSource(prefix + ":" + sqlId);
            prepare.setText(sqlText);
            prepare.setStrict(strict);
            Iterator itrParam = sqlElement.elementIterator("condition");
            while (itrParam.hasNext()) {
                DefaultSQLStore.parseCondition(prepare, gloableConditions, (Element)itrParam.next());
            }
            String group = sqlElement.elementText("group");
            String order = sqlElement.elementText("order");
            prepare.group(group);
            prepare.order(order);
            if (ConfigTable.isSQLDebug()) {
                log.warn("[\u89e3\u6790SQL][id:{}]\n[text:{}]", (Object)sqlId, (Object)sqlText);
            }
            result.put(sqlId, prepare);
        }
        return result;
    }

    private static Condition parseCondition(RunPrepare prepare, Map<String, List<Condition>> map, Element element) {
        DefaultXMLCondition condition = null;
        String id = element.attributeValue("id");
        boolean required = BasicUtil.parseBoolean((Object)element.attributeValue("required"), (Boolean)false);
        boolean strictRequired = BasicUtil.parseBoolean((Object)element.attributeValue("strictRequired"), (Boolean)false);
        if (null != id) {
            boolean isStatic = BasicUtil.parseBoolean((Object)element.attributeValue("static"), (Boolean)false);
            String text = element.getText().trim();
            if (!text.toUpperCase().startsWith("AND ")) {
                text = "\nAND " + text;
            }
            condition = new DefaultXMLCondition(id, text, isStatic);
            condition.setRequired(required);
            condition.setStrictRequired(strictRequired);
            String test = element.attributeValue("test");
            condition.setTest(test);
            if (null != prepare) {
                prepare.addCondition(condition);
            }
        } else {
            List<Condition> conditions;
            String ref = element.attributeValue("ref");
            if (null != ref && null != prepare && null != map && null != (conditions = map.get(ref))) {
                for (Condition c : conditions) {
                    prepare.addCondition(c);
                }
            }
        }
        return condition;
    }

    private static Document createDocument(File file) {
        Document document = null;
        try {
            SAXReader reader = new SAXReader();
            document = reader.read(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    private static Document createDocument(InputStream is) {
        Document document = null;
        try {
            SAXReader reader = new SAXReader();
            document = reader.read(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    public static synchronized DefaultSQLStore getInstance() {
        if (instance == null) {
            instance = new DefaultSQLStore();
        }
        return instance;
    }

    public static RunPrepare parseSQL(String id) {
        RunPrepare prepare = null;
        if (ConfigTable.getReload() > 0 && (System.currentTimeMillis() - lastLoadTime) / 1000L > (long)ConfigTable.getReload()) {
            DefaultSQLStore.loadSQL();
        }
        try {
            if (ConfigTable.isSQLDebug()) {
                log.warn("[\u63d0\u53d6SQL][id:{}]", (Object)id);
            }
            log.info("sqlId:{}", (Object)id);
            prepare = sqls.get(id);
            if (null == prepare) {
                log.error("[SQL\u63d0\u53d6\u5931\u8d25][id:{}][\u6240\u6709\u53ef\u7528sql:{}]", (Object)id, (Object)BeanUtil.concat((Collection)BeanUtil.getMapKeys(sqls)));
            }
        }
        catch (Exception e) {
            log.error("[SQL\u63d0\u53d6\u5931\u8d25][id:{}]", (Object)id);
        }
        return prepare;
    }

    static {
        sqls = new Hashtable();
        log = LoggerFactory.getLogger(DefaultSQLStore.class);
        lastLoadTime = 0L;
        DefaultSQLStore.loadSQL();
    }
}

