/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare;

import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.init.DefaultVariable;
import org.anyline.entity.Compare;
import org.anyline.util.BasicUtil;

public class SyntaxHelper {
    public static Variable buildVariable(int signType, String all, String prefix, String fullKey, String afterChar) {
        int varType = -1;
        if (BasicUtil.isNotEmpty((Object)prefix) && prefix.matches(".*[a-zA-Z0-9]$")) {
            return null;
        }
        Compare compare = Compare.EQUAL;
        if (null == afterChar) {
            afterChar = "";
        }
        DefaultVariable var = new DefaultVariable();
        String key = null;
        if (signType == 1) {
            key = fullKey.replace(":", "");
        } else if (signType == 2) {
            key = fullKey.replace("${", "").replace("{", "").replace("}", "");
        }
        if (fullKey.startsWith("$") || fullKey.startsWith("::")) {
            varType = 3;
        } else if ("'".equals(afterChar)) {
            varType = 2;
        } else if (prefix.endsWith("%") || afterChar.startsWith("%")) {
            varType = 1;
            if (prefix.endsWith("%") && afterChar.startsWith("%")) {
                compare = Compare.LIKE;
            } else if (prefix.endsWith("%")) {
                compare = Compare.LIKE_PREFIX;
            } else if (afterChar.startsWith("%")) {
                compare = Compare.LIKE_SUFFIX;
            }
        } else {
            varType = 1;
            if (prefix.equalsIgnoreCase("IN") || prefix.equalsIgnoreCase("IN(")) {
                compare = Compare.IN;
            }
        }
        var.setSignType(signType);
        var.setKey(key);
        var.setType(varType);
        var.setCompare(compare);
        return var;
    }

    public static Compare parseCompare(int code) {
        for (Compare type : Compare.values()) {
            if (type.getCode() != code) continue;
            return type;
        }
        return null;
    }

    public static Compare parseCompare(String code) {
        if (BasicUtil.isEmpty((Object)code)) {
            return null;
        }
        for (Compare type : Compare.values()) {
            if (!code.equals(type.getCode() + "")) continue;
            return type;
        }
        return null;
    }
}

