/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.ds.DataSourceHolder;
import org.anyline.util.LogUtil;
import org.anyline.util.SpringContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Repository;

@Repository
public class SQLAdapterUtil {
    private static final Logger log = LoggerFactory.getLogger(SQLAdapterUtil.class);
    private static ConcurrentHashMap<String, JDBCAdapter> adapters = new ConcurrentHashMap();
    private static JDBCAdapter defaultAdapter = null;

    @Autowired(required=false)
    public void setAdapters(Map<String, JDBCAdapter> map) {
        for (JDBCAdapter adapter : map.values()) {
            adapters.put(adapter.type().getCode(), adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static JDBCAdapter getAdapter(JdbcTemplate jdbc) {
        block13: {
            if (null != SQLAdapterUtil.defaultAdapter) {
                SQLAdapterUtil.defaultAdapter.setJdbc(jdbc);
                return SQLAdapterUtil.defaultAdapter;
            }
            if (SQLAdapterUtil.adapters.size() == 1) {
                SQLAdapterUtil.defaultAdapter = SQLAdapterUtil.adapters.values().iterator().next();
                SQLAdapterUtil.defaultAdapter.setJdbc(jdbc);
                return SQLAdapterUtil.defaultAdapter;
            }
            adapter = null;
            type = DataSourceHolder.dialect();
            if (null != type && null != (adapter = SQLAdapterUtil.getAdapter(type.getName()))) {
                adapter.setJdbc(jdbc);
                return adapter;
            }
            ds = null;
            con = null;
            try {
                name = null;
                if (null != jdbc) {
                    ds = jdbc.getDataSource();
                    con = DataSourceUtils.getConnection((DataSource)ds);
                    name = con.getMetaData().getDatabaseProductName().toLowerCase().replace(" ", "");
                    name = name + " " + con.getMetaData().getURL().toLowerCase();
                    adapter = SQLAdapterUtil.getAdapter(name);
                }
                if (null != adapter) break block13;
                SQLAdapterUtil.log.warn("[\u68c0\u6d4b\u6570\u636e\u5e93\u9002\u914d\u5668][\u68c0\u6d4b\u5931\u8d25][\u53ef\u7528\u9002\u914d\u5668\u6570\u91cf:{}][\u68c0\u6d4b\u5176\u4ed6\u53ef\u7528\u7684\u9002\u914d\u5668]", (Object)SQLAdapterUtil.adapters.size());
                adapter = (JDBCAdapter)SpringContextUtil.getBean(JDBCAdapter.class);
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable var6_7) {
                    if (!DataSourceUtils.isConnectionTransactional(con, ds)) {
                        DataSourceUtils.releaseConnection(con, (DataSource)ds);
                    }
                    throw var6_7;
                }
                if (!DataSourceUtils.isConnectionTransactional(con, (DataSource)ds)) {
                    DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
                } else {
                    ** GOTO lbl40
                }
            }
        }
        if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
        }
        if (null == adapter) {
            SQLAdapterUtil.log.error("[\u68c0\u6d4b\u6570\u636e\u5e93\u9002\u914d\u5668][\u68c0\u6d4b\u5176\u4ed6\u53ef\u7528\u7684\u9002\u914d\u5668\u5931\u8d25][\u53ef\u7528\u9002\u914d\u5668\u6570\u91cf:{}][{}]", (Object)SQLAdapterUtil.adapters.size(), (Object)LogUtil.format((String)"\u53ef\u80fd\u6ca1\u6709\u4f9d\u8d56anyline-data-jdbc-*(\u5982mysql,neo4j)\u6216\u6ca1\u6709\u626b\u63cforg.anyline\u5305", (int)31));
        } else {
            adapter.setJdbc(jdbc);
        }
        return adapter;
    }

    private static JDBCAdapter getAdapter(String name) {
        JDBCAdapter adapter = null;
        adapter = adapters.get(name);
        if (null != adapter) {
            return adapter;
        }
        if (adapters.containsKey(JDBCAdapter.DB_TYPE.MYSQL.getCode()) && name.contains("mysql")) {
            adapter = adapters.get(JDBCAdapter.DB_TYPE.MYSQL.getCode());
        } else if (adapters.containsKey(JDBCAdapter.DB_TYPE.MSSQL.getCode()) && (name.contains("mssql") || name.contains("sqlserver"))) {
            adapter = adapters.get(JDBCAdapter.DB_TYPE.MSSQL.getCode());
        } else if (adapters.containsKey(JDBCAdapter.DB_TYPE.ORACLE.getCode()) && name.contains("oracle")) {
            adapter = adapters.get(JDBCAdapter.DB_TYPE.ORACLE.getCode());
        } else if (adapters.containsKey(JDBCAdapter.DB_TYPE.PostgreSQL.getCode()) && name.contains("postgresql")) {
            adapter = adapters.get(JDBCAdapter.DB_TYPE.PostgreSQL.getCode());
        } else if (adapters.containsKey(JDBCAdapter.DB_TYPE.ClickHouse.getCode()) && name.contains("clickhouse")) {
            adapter = adapters.get(JDBCAdapter.DB_TYPE.ClickHouse.getCode());
        } else if (adapters.containsKey(JDBCAdapter.DB_TYPE.DB2.getCode()) && name.contains("db2")) {
            adapter = adapters.get(JDBCAdapter.DB_TYPE.DB2.getCode());
        } else if (adapters.containsKey(JDBCAdapter.DB_TYPE.Derby.getCode()) && name.contains("derby")) {
            adapter = adapters.get(JDBCAdapter.DB_TYPE.Derby.getCode());
        } else if (adapters.containsKey(JDBCAdapter.DB_TYPE.DM.getCode()) && name.contains("dmdbms")) {
            adapter = adapters.get(JDBCAdapter.DB_TYPE.DM.getCode());
        } else if (adapters.containsKey(JDBCAdapter.DB_TYPE.HighGo.getCode()) && name.contains("hgdb") || name.contains("highgo")) {
            adapter = adapters.get(JDBCAdapter.DB_TYPE.HighGo.getCode());
        } else if (adapters.containsKey(JDBCAdapter.DB_TYPE.KingBase.getCode()) && name.contains("kingbase")) {
            adapter = adapters.get(JDBCAdapter.DB_TYPE.KingBase.getCode());
        } else if (adapters.containsKey(JDBCAdapter.DB_TYPE.OceanBase.getCode()) && name.contains("oceanbase")) {
            adapter = adapters.get(JDBCAdapter.DB_TYPE.OceanBase.getCode());
        } else if (adapters.containsKey(JDBCAdapter.DB_TYPE.PolarDB.getCode()) && name.contains("polardb")) {
            adapter = adapters.get(JDBCAdapter.DB_TYPE.PolarDB.getCode());
        } else if (adapters.containsKey(JDBCAdapter.DB_TYPE.SQLite.getCode()) && name.contains("sqlite")) {
            adapter = adapters.get(JDBCAdapter.DB_TYPE.SQLite.getCode());
        } else if (adapters.containsKey(JDBCAdapter.DB_TYPE.H2.getCode()) && name.contains(":h2:")) {
            adapter = adapters.get(JDBCAdapter.DB_TYPE.H2.getCode());
        } else if (adapters.containsKey(JDBCAdapter.DB_TYPE.HSQLDB.getCode()) && name.contains("hsqldb")) {
            adapter = adapters.get(JDBCAdapter.DB_TYPE.HSQLDB.getCode());
        } else if (adapters.containsKey(JDBCAdapter.DB_TYPE.TDengine.getCode()) && name.contains("taos")) {
            adapter = adapters.get(JDBCAdapter.DB_TYPE.TDengine.getCode());
        } else if (adapters.containsKey(JDBCAdapter.DB_TYPE.Neo4j.getCode()) && name.contains("neo4j")) {
            adapter = adapters.get(JDBCAdapter.DB_TYPE.Neo4j.getCode());
        }
        if (null != adapter) {
            adapters.put(name, adapter);
            log.warn("[\u68c0\u6d4b\u6570\u636e\u5e93\u9002\u914d\u5668][\u6839\u636eurl\u68c0\u6d4b\u5b8c\u6210][url:{}][\u9002\u914d\u5668:{}]", (Object)name, (Object)adapter);
        }
        return adapter;
    }
}

