/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.ds;

import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.anyline.data.jdbc.ds.DataSourceHolder;
import org.anyline.data.jdbc.ds.DynamicDataSource;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class DynamicDataSourceRegister
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private Logger log = LoggerFactory.getLogger(DynamicDataSourceRegister.class);
    private static final String DATASOURCE_TYPE_DEFAULT = "com.zaxxer.hikari.HikariDataSource";

    public void setEnvironment(Environment environment) {
        this.initDefaultDataSource(environment);
        this.initSpringDataSources(environment);
    }

    private void initDefaultDataSource(Environment env) {
        DataSource ds = DynamicDataSourceRegister.buildDataSource("spring.datasource", env);
        DynamicDataSource.setDefaultDatasource(ds);
    }

    private void initSpringDataSources(Environment env) {
        String prefixs = env.getProperty("spring.datasource.list");
        if (null != prefixs) {
            for (String prefix : prefixs.split(",")) {
                DataSource ds = DynamicDataSourceRegister.buildDataSource("spring.datasource." + prefix, env);
                DynamicDataSource.addDataSource(prefix, ds);
                DataSourceHolder.reg(prefix);
                this.log.info("[\u521b\u5efa\u6570\u636e\u6e90][prefix:{}]", (Object)prefix);
            }
        }
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry) {
        DataSourceHolder.reg("dataSource");
        for (String key : DynamicDataSource.getDataSources().keySet()) {
            this.log.info("[\u6ce8\u518c\u6570\u636e\u6e90][key:{}]", (Object)key);
            DataSourceHolder.reg(key);
        }
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(DynamicDataSource.class);
        beanDefinition.setSynthetic(true);
        MutablePropertyValues mpv = beanDefinition.getPropertyValues();
        mpv.addPropertyValue("defaultTargetDataSource", (Object)DynamicDataSource.getDefaultDatasource());
        mpv.addPropertyValue("targetDataSources", DynamicDataSource.getDataSources());
        beanDefinitionRegistry.registerBeanDefinition("dataSource", (BeanDefinition)beanDefinition);
    }

    public static DataSource buildDataSource(String prefix, Environment env) {
        try {
            String type;
            if (BasicUtil.isNotEmpty((Object)prefix) && !prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            if (null == (type = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"type"}))) {
                type = BeanUtil.value((String)"spring.datasource.", (Environment)env, (String[])new String[]{"type"});
            }
            if (type == null) {
                type = DATASOURCE_TYPE_DEFAULT;
            }
            Class<?> dataSourceType = Class.forName(type);
            String driverClassName = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"driver", "driver-class", "driver-class-name"});
            String url = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"url", "jdbc-url"});
            String username = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"user", "username", "user-name"});
            String password = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{"password"});
            DataSource ds = (DataSource)dataSourceType.newInstance();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("url", url);
            map.put("jdbcUrl", url);
            map.put("driver", driverClassName);
            map.put("driverClass", driverClassName);
            map.put("driverClassName", driverClassName);
            map.put("user", username);
            map.put("username", username);
            map.put("password", password);
            BeanUtil.setFieldsValue((Object)ds, map);
            return ds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void setFieldsValue(Object obj, String prefix, Environment env) {
        List fields = ClassUtil.getFieldsName(obj.getClass());
        for (String field : fields) {
            String value = BeanUtil.value((String)prefix, (Environment)env, (String[])new String[]{field});
            if (!BasicUtil.isNotEmpty((Object)value)) continue;
            BeanUtil.setFieldValue((Object)obj, (String)field, (Object)value);
        }
    }
}

