/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.ds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.ds.DynamicDataSource;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.EntityAdapterProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceHolder {
    public static Logger log = LoggerFactory.getLogger(DataSourceHolder.class);
    private static final ThreadLocal<String> THREAD_RECALL_SOURCE = new ThreadLocal();
    private static final ThreadLocal<String> THREAD_CUR_SOURCE = new ThreadLocal();
    private static final ThreadLocal<Boolean> THREAD_AUTO_RECOVER = new ThreadLocal();
    private static List<String> dataSources = new ArrayList<String>();
    private static Map<String, JDBCAdapter.DB_TYPE> types = new HashMap<String, JDBCAdapter.DB_TYPE>();

    public static String getDataSource() {
        return THREAD_CUR_SOURCE.get();
    }

    public static JDBCAdapter.DB_TYPE dialect() {
        String ds = DataSourceHolder.getDataSource();
        return types.get(ds);
    }

    public static void dialect(String ds, JDBCAdapter.DB_TYPE type) {
        types.put(ds, type);
    }

    public static void setDataSource(String dataSource) {
        DataSourceHolder.setDataSource(dataSource, false);
    }

    public static void setDataSource(String dataSource, boolean auto) {
        if (null == dataSource || !dataSources.contains(dataSource)) {
            throw new RuntimeException("\u6570\u636e\u6e90\u672a\u6ce8\u518c:" + dataSource);
        }
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u5207\u6362\u6570\u636e\u6e90][thread:{}][\u6570\u636e\u6e90:{}>{}][auto recover:{}]", new Object[]{Thread.currentThread().getId(), THREAD_RECALL_SOURCE.get(), dataSource, auto});
        }
        THREAD_RECALL_SOURCE.set(THREAD_CUR_SOURCE.get());
        THREAD_CUR_SOURCE.set(dataSource);
        THREAD_AUTO_RECOVER.set(auto);
    }

    public static void recoverDataSource() {
        THREAD_CUR_SOURCE.set(THREAD_RECALL_SOURCE.get());
    }

    public static void setDefaultDataSource() {
        DataSourceHolder.clearDataSource();
        if (dataSources.contains("dataSource")) {
            DataSourceHolder.setDataSource("dataSource");
        } else if (dataSources.contains("default")) {
            DataSourceHolder.setDataSource("default");
        }
        THREAD_AUTO_RECOVER.set(false);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u5207\u6362\u6570\u636e\u6e90][thread:{}][\u6570\u636e\u6e90:{}>\u9ed8\u8ba4\u6570\u636e\u6e90]", (Object)Thread.currentThread().getId(), (Object)THREAD_RECALL_SOURCE.get());
        }
    }

    public static void clearDataSource() {
        THREAD_CUR_SOURCE.remove();
    }

    public static boolean isAutoDefault() {
        if (null == THREAD_AUTO_RECOVER || null == THREAD_AUTO_RECOVER.get()) {
            return false;
        }
        return THREAD_AUTO_RECOVER.get();
    }

    public static String parseDataSource(String src) {
        if (null != src && src.startsWith("<")) {
            int fr = src.indexOf("<");
            int to = src.indexOf(">");
            if (fr != -1) {
                String ds = src.substring(fr + 1, to);
                src = src.substring(to + 1);
                DataSourceHolder.setDataSource(ds, true);
            }
        }
        return src;
    }

    public static String parseDataSource(String dest, Object obj) {
        if (BasicUtil.isNotEmpty((Object)dest) || null == obj) {
            return DataSourceHolder.parseDataSource(dest);
        }
        String result = "";
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            String link = row.getDataLink();
            if (BasicUtil.isNotEmpty((Object)link)) {
                DataSourceHolder.setDataSource(link, true);
            }
            result = row.getDataSource();
        } else if (obj instanceof DataSet) {
            DataSet set = (DataSet)obj;
            if (set.size() > 0) {
                result = DataSourceHolder.parseDataSource(dest, set.getRow(0));
            }
        } else if (obj instanceof Collection) {
            Object first = ((Collection)obj).iterator().next();
            result = EntityAdapterProxy.table(first.getClass());
        } else {
            result = EntityAdapterProxy.table(obj.getClass());
        }
        result = DataSourceHolder.parseDataSource(result);
        return result;
    }

    public static void reg(String ds) {
        if (!dataSources.contains(ds)) {
            dataSources.add(ds);
        }
    }

    public static boolean contains(String ds) {
        return dataSources.contains(ds);
    }

    public static DataSource addDataSource(String key, DataSource ds) throws Exception {
        return DataSourceHolder.addDataSource(key, ds, true);
    }

    public static DataSource addDataSource(DataSource ds) throws Exception {
        return DataSourceHolder.addDefaultDataSource(ds);
    }

    public static DataSource addDefaultDataSource(DataSource ds) throws Exception {
        return DataSourceHolder.addDataSource("dataSource", ds, true);
    }

    public static DataSource addDataSource(String key, DataSource ds, boolean over) throws Exception {
        if (!over && dataSources.contains(key)) {
            throw new Exception("[\u91cd\u590d\u6ce8\u518c][thread:" + Thread.currentThread().getId() + "][key:" + key + "]");
        }
        if (ConfigTable.IS_DEBUG && log.isInfoEnabled()) {
            log.info("[\u521b\u5efa\u6570\u636e\u6e90][thread:{}][key:{}]", (Object)Thread.currentThread().getId(), (Object)key);
        }
        DynamicDataSource.addDataSource(key, ds);
        if (!dataSources.contains(key)) {
            dataSources.add(key);
        }
        return ds;
    }

    public static DataSource reg(String key, String pool, String driver, String url, String user, String password) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("type", pool);
        param.put("driver", driver);
        param.put("url", url);
        param.put("user", user);
        param.put("password", password);
        DataSource ds = DataSourceHolder.buildDataSource(param);
        return DataSourceHolder.reg(key, ds, true);
    }

    public static DataSource reg(String key, JDBCAdapter.DB_TYPE type, String url, String user, String password) throws Exception {
        return DataSourceHolder.reg(key, "om.zaxxer.hikari.HikariDataSource", type.getDriver(), url, user, password);
    }

    public static DataSource reg(String key, DataSource ds, boolean over) throws Exception {
        return DataSourceHolder.addDataSource(key, ds, over);
    }

    public static DataSource reg(String key, DataSource ds) throws Exception {
        return DataSourceHolder.addDataSource(key, ds, true);
    }

    public static DataSource reg(String key, Map<String, ?> param, boolean over) throws Exception {
        return DataSourceHolder.addDataSource(key, DataSourceHolder.buildDataSource(param), over);
    }

    public static DataSource reg(String key, Map<String, ?> param) throws Exception {
        return DataSourceHolder.addDataSource(key, DataSourceHolder.buildDataSource(param), true);
    }

    public static DataSource buildDataSource(Map<String, ?> params) throws Exception {
        try {
            String type = (String)params.get("pool");
            if (BasicUtil.isEmpty((Object)type)) {
                type = (String)params.get("type");
            }
            if (type == null) {
                throw new Exception("\u672a\u8bbe\u7f6e\u6570\u636e\u6e90\u7c7b\u578b(\u5982:pool=com.zaxxer.hikari.HikariDataSource)");
            }
            Class<?> poolClass = Class.forName(type);
            Object driver = BeanUtil.propertyNvl(params, (String[])new String[]{"driver", "driver-class", "driver-class-name"});
            Object url = BeanUtil.propertyNvl(params, (String[])new String[]{"url", "jdbc-url"});
            Object user = BeanUtil.propertyNvl(params, (String[])new String[]{"user", "username"});
            DataSource ds = (DataSource)poolClass.newInstance();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.putAll(params);
            map.put("url", url);
            map.put("jdbcUrl", url);
            map.put("driver", driver);
            map.put("driverClass", driver);
            map.put("driverClassName", driver);
            map.put("user", user);
            map.put("username", user);
            BeanUtil.setFieldsValue((Object)ds, map);
            return ds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        THREAD_AUTO_RECOVER.set(false);
    }
}

