/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.service.init;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.cache.CacheElement;
import org.anyline.cache.CacheProvider;
import org.anyline.dao.AnylineDao;
import org.anyline.data.cache.CacheUtil;
import org.anyline.data.cache.PageLazyStore;
import org.anyline.data.entity.Column;
import org.anyline.data.entity.Constraint;
import org.anyline.data.entity.Database;
import org.anyline.data.entity.Index;
import org.anyline.data.entity.MasterTable;
import org.anyline.data.entity.PartitionTable;
import org.anyline.data.entity.Table;
import org.anyline.data.entity.Tag;
import org.anyline.data.jdbc.ds.DataSourceHolder;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.Procedure;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.prepare.auto.init.DefaultTextPrepare;
import org.anyline.data.prepare.init.DefaultProcedure;
import org.anyline.data.prepare.init.DefaultSQLStore;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.DefaultPageNavi;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.exception.AnylineException;
import org.anyline.proxy.CacheProxy;
import org.anyline.service.AnylineService;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.EntityAdapterProxy;
import org.anyline.util.LogUtil;
import org.anyline.util.regular.RegularUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="anyline.service")
public class DefaultService<E>
implements AnylineService<E> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    @Qualifier(value="anyline.dao")
    protected AnylineDao dao;
    @Autowired(required=false)
    @Qualifier(value="anyline.cache.provider")
    protected CacheProvider cacheProvider;
    public AnylineService.MetaDataService metadata = new AnylineService.MetaDataService(){

        @Override
        public LinkedHashMap<String, Database> databases() {
            return DefaultService.this.dao.databases();
        }

        @Override
        public boolean exists(Table table) {
            return null != this.table(table.getCatalog(), table.getSchema(), table.getName());
        }

        @Override
        public LinkedHashMap<String, Table> tables(String schema, String name, String types) {
            return this.tables(null, schema, name, types);
        }

        @Override
        public LinkedHashMap<String, Table> tables(String name, String types) {
            return this.tables(null, null, name, types);
        }

        @Override
        public LinkedHashMap<String, Table> tables(String types) {
            return this.tables(null, types);
        }

        @Override
        public LinkedHashMap<String, Table> tables() {
            return this.tables(null);
        }

        @Override
        public LinkedHashMap<String, Table> tables(String catalog, String schema, String name, String types) {
            return DefaultService.this.dao.tables(catalog, schema, name, types);
        }

        @Override
        public Table table(String catalog, String schema, String name) {
            Table table = null;
            LinkedHashMap<String, Table> tables = this.tables(catalog, schema, name, null);
            if (tables.size() > 0) {
                table = tables.values().iterator().next();
                table.setColumns(this.columns(table));
                table.setTags(this.tags(table));
                table.setIndexs(this.indexs(table));
            }
            return table;
        }

        @Override
        public Table table(String schema, String name) {
            return this.table(null, schema, name);
        }

        @Override
        public Table table(String name) {
            return this.table(null, null, name);
        }

        @Override
        public boolean exists(MasterTable table) {
            return false;
        }

        @Override
        public LinkedHashMap<String, MasterTable> mtables(String catalog, String schema, String name, String types) {
            return DefaultService.this.dao.mtables(catalog, schema, name, types);
        }

        @Override
        public LinkedHashMap<String, MasterTable> mtables(String schema, String name, String types) {
            return this.mtables(null, schema, name, types);
        }

        @Override
        public LinkedHashMap<String, MasterTable> mtables(String name, String types) {
            return this.mtables(null, null, name, types);
        }

        @Override
        public LinkedHashMap<String, MasterTable> mtables(String types) {
            return this.mtables(null, types);
        }

        @Override
        public LinkedHashMap<String, MasterTable> mtables() {
            return this.mtables("STABLE");
        }

        @Override
        public MasterTable mtable(String catalog, String schema, String name) {
            LinkedHashMap<String, MasterTable> tables = this.mtables(catalog, schema, name, "STABLE");
            if (tables.size() == 0) {
                return null;
            }
            MasterTable table = tables.values().iterator().next();
            table.setColumns(this.columns(table));
            table.setTags(this.tags(table));
            table.setIndexs(this.indexs(table));
            return table;
        }

        @Override
        public MasterTable mtable(String schema, String name) {
            return this.mtable(null, schema, name);
        }

        @Override
        public MasterTable mtable(String name) {
            return this.mtable(null, null, name);
        }

        @Override
        public boolean exists(PartitionTable table) {
            return false;
        }

        @Override
        public LinkedHashMap<String, PartitionTable> ptables(String catalog, String schema, String master, String name) {
            return DefaultService.this.dao.ptables(catalog, schema, master, name);
        }

        @Override
        public LinkedHashMap<String, PartitionTable> ptables(String schema, String master, String name) {
            return this.ptables(null, schema, master, name);
        }

        @Override
        public LinkedHashMap<String, PartitionTable> ptables(String master, String name) {
            return this.ptables(null, null, master, name);
        }

        @Override
        public LinkedHashMap<String, PartitionTable> ptables(String master) {
            return this.ptables(null, null, master, null);
        }

        @Override
        public LinkedHashMap<String, PartitionTable> ptables(MasterTable master) {
            return DefaultService.this.dao.ptables(master);
        }

        @Override
        public LinkedHashMap<String, PartitionTable> ptables(MasterTable master, Map<String, Object> tags) {
            return DefaultService.this.dao.ptables(master, tags);
        }

        @Override
        public LinkedHashMap<String, PartitionTable> ptables(MasterTable master, Map<String, Object> tags, String name) {
            return DefaultService.this.dao.ptables(master, tags, name);
        }

        @Override
        public PartitionTable ptable(String catalog, String schema, String master, String name) {
            LinkedHashMap<String, PartitionTable> tables = this.ptables(catalog, schema, master, name);
            if (tables.size() == 0) {
                return null;
            }
            PartitionTable table = tables.values().iterator().next();
            table.setColumns(this.columns(table));
            table.setTags(this.tags(table));
            table.setIndexs(this.indexs(table));
            return table;
        }

        @Override
        public PartitionTable ptable(String schema, String master, String name) {
            return this.ptable(null, schema, master, name);
        }

        @Override
        public PartitionTable ptable(String master, String name) {
            return this.ptable(null, null, master, name);
        }

        @Override
        public boolean exists(Column column) {
            try {
                Table table = this.table(column.getCatalog(), column.getSchema(), column.getTableName());
                if (null != table && table.getColumns().containsKey(column.getName().toUpperCase())) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        @Override
        public boolean exists(Table table, String name) {
            try {
                LinkedHashMap<String, Column> columns = table.getColumns();
                if (null == columns && columns.isEmpty()) {
                    columns = this.columns(table);
                }
                if (columns.containsKey(name.toUpperCase())) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        @Override
        public boolean exists(String table, String name) {
            try {
                LinkedHashMap<String, Column> columns = this.columns(table);
                if (columns.containsKey(name.toUpperCase())) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        @Override
        public boolean exists(String catalog, String schema, String table, String name) {
            try {
                LinkedHashMap<String, Column> columns = this.columns(catalog, schema, table);
                if (columns.containsKey(name.toUpperCase())) {
                    return true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return false;
        }

        @Override
        public LinkedHashMap<String, Column> columns(String table) {
            return this.columns(null, null, table);
        }

        @Override
        public LinkedHashMap<String, Column> columns(Table table) {
            LinkedHashMap<String, Column> columns = CacheProxy.columns(table.getName());
            if (null == columns) {
                columns = DefaultService.this.dao.columns(table);
                CacheProxy.columns(table.getName(), columns);
            }
            return columns;
        }

        @Override
        public LinkedHashMap<String, Column> columns(String catalog, String schema, String table) {
            return this.columns(new Table(catalog, schema, table));
        }

        @Override
        public Column column(Table table, String name) {
            Column column = null;
            LinkedHashMap<String, Column> columns = table.getColumns();
            if (null == columns && columns.isEmpty()) {
                columns = this.columns(table);
            }
            column = columns.get(name.toUpperCase());
            return column;
        }

        @Override
        public Column column(String table, String name) {
            Column column = null;
            LinkedHashMap<String, Column> columns = this.columns(table);
            column = columns.get(name.toUpperCase());
            return column;
        }

        @Override
        public Column column(String catalog, String schema, String table, String name) {
            Column column = null;
            LinkedHashMap<String, Column> columns = this.columns(catalog, schema, table);
            column = columns.get(name.toUpperCase());
            return column;
        }

        @Override
        public LinkedHashMap<String, Tag> tags(String catalog, String schema, String table) {
            return this.tags(new Table(catalog, schema, table));
        }

        @Override
        public LinkedHashMap<String, Tag> tags(String table) {
            return this.tags(null, null, table);
        }

        @Override
        public LinkedHashMap<String, Tag> tags(Table table) {
            LinkedHashMap<String, Tag> tags = CacheProxy.tags(table.getName());
            if (null == tags) {
                tags = DefaultService.this.dao.tags(table);
                CacheProxy.tags(table.getName(), tags);
            }
            return tags;
        }

        @Override
        public LinkedHashMap<String, Index> indexs(Table table) {
            return DefaultService.this.dao.indexs(table);
        }

        @Override
        public LinkedHashMap<String, Index> indexs(String table) {
            return this.indexs(new Table(table));
        }

        @Override
        public LinkedHashMap<String, Index> indexs(String catalog, String schema, String table) {
            return this.indexs(new Table(catalog, schema, table));
        }

        @Override
        public LinkedHashMap<String, Constraint> constraints(Table table) {
            return null;
        }

        @Override
        public LinkedHashMap<String, Constraint> constraints(String table) {
            return null;
        }

        @Override
        public LinkedHashMap<String, Constraint> constraints(String catalog, String schema, String table) {
            return null;
        }
    };
    public AnylineService.DDLService ddl = new AnylineService.DDLService(){

        @Override
        public boolean save(Table table) throws Exception {
            boolean result = false;
            Table otable = DefaultService.this.metadata.table(table.getCatalog(), table.getSchema(), table.getName());
            if (null != otable) {
                otable.setUpdate(table);
                result = this.alter(otable);
            } else {
                result = this.create(table);
            }
            DefaultService.this.clearColumnCache(table.getCatalog(), table.getSchema(), table.getName());
            return result;
        }

        @Override
        public boolean create(Table table) throws Exception {
            table.setService(DefaultService.this);
            boolean result = DefaultService.this.dao.create(table);
            DefaultService.this.clearColumnCache(table.getCatalog(), table.getSchema(), table.getName());
            return result;
        }

        @Override
        public boolean alter(Table table) throws Exception {
            table.setService(DefaultService.this);
            boolean result = DefaultService.this.dao.alter(table);
            DefaultService.this.clearColumnCache(table.getCatalog(), table.getSchema(), table.getName());
            return result;
        }

        @Override
        public boolean drop(Table table) throws Exception {
            table.setService(DefaultService.this);
            boolean result = DefaultService.this.dao.drop(table);
            DefaultService.this.clearColumnCache(table.getCatalog(), table.getSchema(), table.getName());
            return result;
        }

        @Override
        public boolean save(MasterTable table) throws Exception {
            boolean result = false;
            MasterTable otable = DefaultService.this.metadata.mtable(table.getCatalog(), table.getSchema(), table.getName());
            if (null != otable) {
                otable.setUpdate(table);
                result = this.alter(otable);
            } else {
                result = this.create(table);
            }
            DefaultService.this.clearColumnCache(table.getCatalog(), table.getSchema(), table.getName());
            return result;
        }

        @Override
        public boolean create(MasterTable table) throws Exception {
            table.setService(DefaultService.this);
            boolean result = DefaultService.this.dao.create(table);
            DefaultService.this.clearColumnCache(table.getCatalog(), table.getSchema(), table.getName());
            return result;
        }

        @Override
        public boolean alter(MasterTable table) throws Exception {
            table.setService(DefaultService.this);
            boolean result = DefaultService.this.dao.alter(table);
            DefaultService.this.clearColumnCache(table.getCatalog(), table.getSchema(), table.getName());
            return result;
        }

        @Override
        public boolean drop(MasterTable table) throws Exception {
            table.setService(DefaultService.this);
            boolean result = DefaultService.this.dao.drop(table);
            DefaultService.this.clearColumnCache(table.getCatalog(), table.getSchema(), table.getName());
            return result;
        }

        @Override
        public boolean save(PartitionTable table) throws Exception {
            boolean result = false;
            PartitionTable otable = DefaultService.this.metadata.ptable(table.getCatalog(), table.getSchema(), table.getName());
            if (null != otable) {
                otable.setUpdate(table);
                result = this.alter(otable);
            } else {
                result = this.create(table);
            }
            DefaultService.this.clearColumnCache(table.getCatalog(), table.getSchema(), table.getName());
            return result;
        }

        @Override
        public boolean create(PartitionTable table) throws Exception {
            table.setService(DefaultService.this);
            boolean result = DefaultService.this.dao.create(table);
            DefaultService.this.clearColumnCache(table.getCatalog(), table.getSchema(), table.getName());
            return result;
        }

        @Override
        public boolean alter(PartitionTable table) throws Exception {
            table.setService(DefaultService.this);
            boolean result = DefaultService.this.dao.alter(table);
            DefaultService.this.clearColumnCache(table.getCatalog(), table.getSchema(), table.getName());
            return result;
        }

        @Override
        public boolean drop(PartitionTable table) throws Exception {
            table.setService(DefaultService.this);
            boolean result = DefaultService.this.dao.drop(table);
            DefaultService.this.clearColumnCache(table.getCatalog(), table.getSchema(), table.getName());
            return result;
        }

        @Override
        public boolean save(Column column) throws Exception {
            boolean result = false;
            Table table = DefaultService.this.metadata.table(column.getCatalog(), column.getSchema(), column.getTableName());
            if (null == table) {
                throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + column.getTableName());
            }
            LinkedHashMap<String, Column> columns = table.getColumns();
            Column original = columns.get(column.getName().toUpperCase());
            result = null == original ? this.add(columns, column) : this.alter(table, column);
            DefaultService.this.clearColumnCache(column.getCatalog(), column.getSchema(), column.getTableName());
            return result;
        }

        @Override
        public boolean add(Column column) throws Exception {
            LinkedHashMap<String, Column> columns = DefaultService.this.metadata.columns(column.getCatalog(), column.getSchema(), column.getTableName());
            boolean result = this.add(columns, column);
            DefaultService.this.clearColumnCache(column.getCatalog(), column.getSchema(), column.getTableName());
            return result;
        }

        @Override
        public boolean alter(Column column) throws Exception {
            Table table = DefaultService.this.metadata.table(column.getCatalog(), column.getSchema(), column.getTableName());
            boolean result = this.alter(table, column);
            DefaultService.this.clearColumnCache(column.getCatalog(), column.getSchema(), column.getTableName());
            return result;
        }

        @Override
        public boolean drop(Column column) throws Exception {
            column.setService(DefaultService.this);
            boolean result = DefaultService.this.dao.drop(column);
            DefaultService.this.clearColumnCache(column.getCatalog(), column.getSchema(), column.getTableName());
            return result;
        }

        private boolean add(LinkedHashMap<String, Column> columns, Column column) throws Exception {
            column.setService(DefaultService.this);
            boolean result = DefaultService.this.dao.add(column);
            if (result) {
                columns.put(column.getName(), column);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean alter(Table table, Column column) throws Exception {
            boolean result = false;
            LinkedHashMap<String, Column> columns = table.getColumns();
            Column original = columns.get(column.getName().toUpperCase());
            Column update = column.getUpdate();
            if (null == update) {
                update = (Column)column.clone();
                String newName = column.getNewName();
                if (BasicUtil.isNotEmpty((Object)newName)) {
                    update.setName(newName);
                }
            }
            original.setUpdate(update);
            original.setService(DefaultService.this);
            String name = original.getName();
            try {
                result = DefaultService.this.dao.alter(table, original);
            }
            finally {
                original.setName(name);
            }
            if (result) {
                columns.remove(original.getName());
                BeanUtil.copyFieldValueWithoutNull((Object)original, (Object)update);
                original.setUpdate(update);
                BeanUtil.copyFieldValue((Object)column, (Object)original);
                columns.put(original.getName(), original);
            }
            return result;
        }

        @Override
        public boolean save(Tag tag) throws Exception {
            boolean result = false;
            Table table = DefaultService.this.metadata.table(tag.getCatalog(), tag.getSchema(), tag.getTableName());
            if (null == table) {
                throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + tag.getTableName());
            }
            LinkedHashMap<String, Tag> tags = table.getTags();
            Tag original = tags.get(tag.getName().toUpperCase());
            result = null == original ? this.add(tags, tag) : this.alter(table, tag);
            DefaultService.this.clearTagCache(tag.getCatalog(), tag.getSchema(), tag.getTableName());
            return result;
        }

        @Override
        public boolean add(Tag tag) throws Exception {
            LinkedHashMap<String, Tag> tags = DefaultService.this.metadata.tags(tag.getCatalog(), tag.getSchema(), tag.getTableName());
            boolean result = this.add(tags, tag);
            DefaultService.this.clearTagCache(tag.getCatalog(), tag.getSchema(), tag.getTableName());
            return result;
        }

        @Override
        public boolean alter(Tag tag) throws Exception {
            Table table = DefaultService.this.metadata.table(tag.getCatalog(), tag.getSchema(), tag.getTableName());
            boolean result = this.alter(table, tag);
            DefaultService.this.clearTagCache(tag.getCatalog(), tag.getSchema(), tag.getTableName());
            return result;
        }

        @Override
        public boolean drop(Tag tag) throws Exception {
            tag.setService(DefaultService.this);
            boolean result = DefaultService.this.dao.drop(tag);
            DefaultService.this.clearTagCache(tag.getCatalog(), tag.getSchema(), tag.getTableName());
            return result;
        }

        private boolean add(LinkedHashMap<String, Tag> tags, Tag tag) throws Exception {
            tag.setService(DefaultService.this);
            boolean result = DefaultService.this.dao.add(tag);
            if (result) {
                tags.put(tag.getName(), tag);
            }
            return result;
        }

        private boolean alter(Table table, Tag tag) throws Exception {
            boolean result = false;
            LinkedHashMap<String, Tag> tags = table.getTags();
            Tag original = tags.get(tag.getName().toUpperCase());
            Tag update = tag.getUpdate();
            if (null == update) {
                update = (Tag)tag.clone();
                String newName = tag.getNewName();
                if (BasicUtil.isNotEmpty((Object)newName)) {
                    update.setName(newName);
                }
            }
            original.setUpdate(update);
            original.setService(DefaultService.this);
            result = DefaultService.this.dao.alter(table, original);
            if (result) {
                tags.remove(original.getName());
                BeanUtil.copyFieldValueWithoutNull((Object)original, (Object)update);
                original.setUpdate(update);
                BeanUtil.copyFieldValue((Object)tag, (Object)original);
                tags.put(original.getName(), original);
            }
            return result;
        }

        @Override
        public boolean add(Index index) throws Exception {
            index.setService(DefaultService.this);
            return DefaultService.this.dao.add(index);
        }

        @Override
        public boolean alter(Index index) throws Exception {
            return false;
        }

        @Override
        public boolean drop(Index index) throws Exception {
            index.setService(DefaultService.this);
            return DefaultService.this.dao.drop(index);
        }

        @Override
        public boolean add(Constraint constraint) throws Exception {
            constraint.setService(DefaultService.this);
            return DefaultService.this.dao.add(constraint);
        }

        @Override
        public boolean alter(Constraint constraint) throws Exception {
            return false;
        }

        @Override
        public boolean drop(Constraint constraint) throws Exception {
            constraint.setService(DefaultService.this);
            return DefaultService.this.dao.drop(constraint);
        }
    };

    @Override
    public AnylineService datasource(String datasource) {
        DataSourceHolder.setDataSource(datasource);
        return this;
    }

    @Override
    public AnylineService datasource() {
        DataSourceHolder.setDefaultDataSource();
        return this;
    }

    @Override
    public AnylineService setDataSource(String datasource) {
        DataSourceHolder.setDataSource(datasource);
        return this;
    }

    @Override
    public AnylineService setDataSource(String datasource, boolean auto) {
        DataSourceHolder.setDataSource(datasource, auto);
        return this;
    }

    @Override
    public AnylineService setDefaultDataSource() {
        DataSourceHolder.setDefaultDataSource();
        return this;
    }

    @Override
    public AnylineService recoverDataSource() {
        DataSourceHolder.recoverDataSource();
        return this;
    }

    @Override
    public String getDataSource() {
        return DataSourceHolder.getDataSource();
    }

    @Override
    public DataSet querys(String src, ConfigStore configs, Object obj, String ... conditions) {
        src = BasicUtil.compress((String)src);
        conditions = BasicUtil.compress((String[])conditions);
        configs = this.append(configs, obj);
        return this.queryFromDao(src, configs, conditions);
    }

    @Override
    public DataSet querys(String src, PageNavi navi, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.setPageNavi(navi);
        return this.querys(src, (ConfigStore)configs, obj, conditions);
    }

    @Override
    public DataSet querys(String src, Object obj, String ... conditions) {
        return this.querys(src, (ConfigStore)null, obj, conditions);
    }

    @Override
    public DataSet querys(String src, int fr, int to, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(fr, to);
        return this.querys(src, (ConfigStore)configs, obj, conditions);
    }

    @Override
    public DataSet querys(String src, ConfigStore configs, String ... conditions) {
        return this.querys(src, configs, (Object)null, conditions);
    }

    @Override
    public DataSet querys(String src, PageNavi navi, String ... conditions) {
        return this.querys(src, navi, (Object)null, conditions);
    }

    @Override
    public DataSet querys(String src, String ... conditions) {
        return this.querys(src, (Object)null, conditions);
    }

    @Override
    public DataSet querys(String src, int fr, int to, String ... conditions) {
        return this.querys(src, fr, to, (Object)null, conditions);
    }

    @Override
    public List<String> column2param(String table) {
        List<String> columns = this.columns(table);
        return EntityAdapterProxy.column2param(columns);
    }

    @Override
    public List<Map<String, Object>> maps(String src, ConfigStore configs, Object obj, String ... conditions) {
        ArrayList<Map<String, Object>> maps;
        block4: {
            maps = null;
            src = BasicUtil.compress((String)src);
            conditions = BasicUtil.compress((String[])conditions);
            if (ConfigTable.isSQLDebug()) {
                this.log.warn("[\u89e3\u6790SQL][src:{}]", (Object)src);
            }
            try {
                RunPrepare prepare = this.createRunPrepare(src);
                configs = this.append(configs, obj);
                maps = this.dao.maps(prepare, configs, conditions);
            }
            catch (Exception e) {
                maps = new ArrayList();
                if (this.log.isWarnEnabled()) {
                    e.printStackTrace();
                }
                this.log.error("QUERY ERROR:" + e);
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block4;
                throw e;
            }
        }
        return maps;
    }

    @Override
    public List<Map<String, Object>> maps(String src, Object obj, String ... conditions) {
        return this.maps(src, null, obj, conditions);
    }

    @Override
    public List<Map<String, Object>> maps(String src, int fr, int to, Object obj, String ... conditions) {
        return this.maps(src, (ConfigStore)new DefaultConfigStore(fr, to), obj, conditions);
    }

    @Override
    public List<Map<String, Object>> maps(String src, ConfigStore configs, String ... conditions) {
        return this.maps(src, configs, (Object)null, conditions);
    }

    @Override
    public List<Map<String, Object>> maps(String src, String ... conditions) {
        return this.maps(src, (ConfigStore)null, conditions);
    }

    @Override
    public List<Map<String, Object>> maps(String src, int fr, int to, String ... conditions) {
        return this.maps(src, fr, to, (Object)null, conditions);
    }

    @Override
    public DataSet caches(String cache, String src, ConfigStore configs, Object obj, String ... conditions) {
        DataSet set = null;
        src = BasicUtil.compress((String)src);
        conditions = BasicUtil.compress((String[])conditions);
        set = null == cache || "true".equalsIgnoreCase(ConfigTable.getString((String)"CACHE_DISABLED")) ? this.querys(src, this.append(configs, obj), conditions) : (null != this.cacheProvider ? this.queryFromCache(cache, src, configs, conditions) : this.querys(src, configs, conditions));
        return set;
    }

    @Override
    public DataSet caches(String cache, String src, Object obj, String ... conditions) {
        return this.caches(cache, src, null, obj, conditions);
    }

    @Override
    public DataSet caches(String cache, String src, int fr, int to, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(fr, to);
        return this.caches(cache, src, (ConfigStore)configs, obj, conditions);
    }

    @Override
    public DataSet caches(String cache, String src, ConfigStore configs, String ... conditions) {
        return this.caches(cache, src, configs, (Object)null, conditions);
    }

    @Override
    public DataSet caches(String cache, String src, String ... conditions) {
        return this.caches(cache, src, null, (Object)null, conditions);
    }

    @Override
    public DataSet caches(String cache, String src, int fr, int to, String ... conditions) {
        return this.caches(cache, src, fr, to, (Object)null, conditions);
    }

    @Override
    public DataRow query(String src, ConfigStore store, Object obj, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0);
        navi.setLastRow(0);
        navi.setCalType(1);
        if (null == store) {
            store = new DefaultConfigStore(new String[0]);
        }
        store.setPageNavi((PageNavi)navi);
        DataSet set = this.querys(src, store, obj, conditions);
        if (null != set && set.size() > 0) {
            DataRow row = set.getRow(0);
            return row;
        }
        if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            return new DataRow();
        }
        return null;
    }

    @Override
    public DataRow query(String src, Object obj, String ... conditions) {
        return this.query(src, (ConfigStore)null, obj, conditions);
    }

    @Override
    public DataRow query(String src, ConfigStore store, String ... conditions) {
        return this.query(src, store, (Object)null, conditions);
    }

    @Override
    public DataRow query(String src, String ... conditions) {
        return this.query(src, (ConfigStore)null, conditions);
    }

    @Override
    public DataRow cache(String cache, String src, ConfigStore configs, Object obj, String ... conditions) {
        CacheElement cacheElement;
        if (null == cache) {
            return this.query(src, configs, obj, conditions);
        }
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0);
        navi.setLastRow(0);
        navi.setCalType(1);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        configs = this.append(configs, obj);
        configs.setPageNavi((PageNavi)navi);
        DataRow row = null;
        String key = "ROW:";
        if (cache.contains(":")) {
            String[] ks = BeanUtil.parseKeyValue((String)cache);
            cache = ks[0];
            key = key + ks[1] + ":";
        }
        key = key + CacheUtil.createCacheElementKey(true, true, src, configs, conditions);
        if (null != this.cacheProvider && null != (cacheElement = this.cacheProvider.get(cache, key)) && null != cacheElement.getValue()) {
            Object cacheValue = cacheElement.getValue();
            if (cacheValue instanceof DataRow) {
                row = (DataRow)cacheValue;
                row.setIsFromCache(true);
                return row;
            }
            this.log.error("[\u7f13\u5b58\u8bbe\u7f6e\u9519\u8bef,\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u6709\u91cd\u590dcache.name \u6216Java\u4ee3\u7801\u8c03\u7528\u4e2dcache.name\u6df7\u6dc6][channel:{}]", (Object)cache);
        }
        if (null != (row = this.query(src, configs, obj, conditions)) && null != this.cacheProvider) {
            this.cacheProvider.put(cache, key, (Object)row);
        }
        if (null == row && ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            row = new DataRow();
        }
        return row;
    }

    @Override
    public DataRow cache(String cache, String src, Object obj, String ... conditions) {
        return this.cache(cache, src, null, obj, conditions);
    }

    @Override
    public DataRow cache(String cache, String src, ConfigStore configs, String ... conditions) {
        return this.cache(cache, src, configs, (Object)null, conditions);
    }

    @Override
    public DataRow cache(String cache, String src, String ... conditions) {
        return this.cache(cache, src, null, (Object)null, conditions);
    }

    @Override
    @Deprecated
    public <T> EntitySet<T> querys(Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        return this.selects(clazz, configs, entity, conditions);
    }

    @Override
    public <T> EntitySet<T> querys(Class<T> clazz, PageNavi navi, T entity, String ... conditions) {
        return this.selects(clazz, navi, entity, conditions);
    }

    @Override
    public <T> EntitySet<T> querys(Class<T> clazz, T entity, String ... conditions) {
        return this.selects(clazz, entity, conditions);
    }

    @Override
    public <T> EntitySet<T> querys(Class<T> clazz, int first, int last, T entity, String ... conditions) {
        return this.selects(clazz, first, last, entity, conditions);
    }

    @Override
    public <T> T query(Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        return this.select(clazz, configs, entity, conditions);
    }

    @Override
    public <T> T query(Class<T> clazz, T entity, String ... conditions) {
        return this.select(clazz, entity, conditions);
    }

    @Override
    public <T> EntitySet<T> querys(Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.selects(clazz, configs, conditions);
    }

    @Override
    public <T> EntitySet<T> querys(Class<T> clazz, PageNavi navi, String ... conditions) {
        return this.selects(clazz, navi, conditions);
    }

    @Override
    public <T> EntitySet<T> querys(Class<T> clazz, String ... conditions) {
        return this.selects(clazz, conditions);
    }

    @Override
    public <T> EntitySet<T> querys(Class<T> clazz, int first, int last, String ... conditions) {
        return this.selects(clazz, first, last, conditions);
    }

    @Override
    public <T> T query(Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.select(clazz, configs, conditions);
    }

    @Override
    public <T> T query(Class<T> clazz, String ... conditions) {
        return this.select(clazz, conditions);
    }

    @Override
    public <T> EntitySet<T> selects(Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        return this.queryFromDao(clazz, this.append(configs, entity), conditions);
    }

    @Override
    public <T> EntitySet<T> selects(Class<T> clazz, PageNavi navi, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.setPageNavi(navi);
        return this.selects(clazz, (ConfigStore)configs, entity, conditions);
    }

    @Override
    public <T> EntitySet<T> selects(Class<T> clazz, T entity, String ... conditions) {
        return this.selects(clazz, (ConfigStore)null, entity, conditions);
    }

    @Override
    public <T> EntitySet<T> selects(Class<T> clazz, int fr, int to, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(fr, to);
        return this.selects(clazz, (ConfigStore)configs, entity, conditions);
    }

    @Override
    public <T> T select(Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0);
        navi.setLastRow(0);
        navi.setCalType(1);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        configs.setPageNavi((PageNavi)navi);
        EntitySet<T> list = this.selects(clazz, configs, entity, conditions);
        if (null != list && list.size() > 0) {
            return (T)list.get(0);
        }
        if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public <T> T select(Class<T> clazz, T entity, String ... conditions) {
        return this.select(clazz, (ConfigStore)null, entity, conditions);
    }

    @Override
    public <T> EntitySet<T> selects(Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.selects(clazz, configs, (T)null, conditions);
    }

    @Override
    public <T> EntitySet<T> selects(Class<T> clazz, PageNavi navi, String ... conditions) {
        return this.selects(clazz, navi, (T)null, conditions);
    }

    @Override
    public <T> EntitySet<T> selects(Class<T> clazz, String ... conditions) {
        return this.selects(clazz, (T)null, conditions);
    }

    @Override
    public <T> EntitySet<T> selects(Class<T> clazz, int fr, int to, String ... conditions) {
        return this.selects(clazz, fr, to, (T)null, conditions);
    }

    @Override
    public <T> T select(Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.select(clazz, configs, (T)null, conditions);
    }

    @Override
    public <T> T select(Class<T> clazz, String ... conditions) {
        return this.select(clazz, (T)null, conditions);
    }

    @Override
    public <T> EntitySet<T> selects(String src, Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        return this.queryFromDao(src, clazz, this.append(configs, entity), conditions);
    }

    @Override
    public <T> EntitySet<T> selects(String src, Class<T> clazz, PageNavi navi, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.setPageNavi(navi);
        return this.selects(src, clazz, (ConfigStore)configs, entity, conditions);
    }

    @Override
    public <T> EntitySet<T> selects(String src, Class<T> clazz, T entity, String ... conditions) {
        return this.selects(src, clazz, (ConfigStore)null, entity, conditions);
    }

    @Override
    public <T> EntitySet<T> selects(String src, Class<T> clazz, int fr, int to, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(fr, to);
        return this.selects(src, clazz, (ConfigStore)configs, entity, conditions);
    }

    @Override
    public <T> T select(String src, Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0);
        navi.setLastRow(0);
        navi.setCalType(1);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        configs.setPageNavi((PageNavi)navi);
        EntitySet<T> list = this.selects(src, clazz, configs, entity, conditions);
        if (null != list && list.size() > 0) {
            return (T)list.get(0);
        }
        if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public <T> T select(String src, Class<T> clazz, T entity, String ... conditions) {
        return this.select(src, clazz, (ConfigStore)null, entity, conditions);
    }

    @Override
    public <T> EntitySet<T> selects(String src, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.selects(src, clazz, configs, (T)null, conditions);
    }

    @Override
    public <T> EntitySet<T> selects(String src, Class<T> clazz, PageNavi navi, String ... conditions) {
        return this.selects(src, clazz, navi, (T)null, conditions);
    }

    @Override
    public <T> EntitySet<T> selects(String src, Class<T> clazz, String ... conditions) {
        return this.selects(src, clazz, (T)null, conditions);
    }

    @Override
    public <T> EntitySet<T> selects(String src, Class<T> clazz, int fr, int to, String ... conditions) {
        return this.selects(src, clazz, fr, to, (T)null, conditions);
    }

    @Override
    public <T> T select(String src, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.select(src, clazz, configs, (T)null, conditions);
    }

    @Override
    public <T> T select(String src, Class<T> clazz, String ... conditions) {
        return this.select(src, clazz, (T)null, conditions);
    }

    protected Class<E> parseGenericClass() {
        Type type = null;
        Class clazz = null;
        Type superClass = this.getClass().getGenericSuperclass();
        if (superClass instanceof ParameterizedType) {
            type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        }
        clazz = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
        return clazz;
    }

    @Override
    public EntitySet<E> gets(ConfigStore configs, String ... conditions) {
        Class<E> clazz = this.parseGenericClass();
        return this.selects(clazz, configs, conditions);
    }

    @Override
    public EntitySet<E> gets(PageNavi navi, String ... conditions) {
        Class<E> clazz = this.parseGenericClass();
        return this.selects(clazz, navi, conditions);
    }

    @Override
    public EntitySet<E> gets(String ... conditions) {
        Class<E> clazz = this.parseGenericClass();
        return this.selects(clazz, conditions);
    }

    @Override
    public EntitySet<E> gets(int fr, int to, String ... conditions) {
        Class<E> clazz = this.parseGenericClass();
        return this.selects(clazz, fr, to, conditions);
    }

    @Override
    public E get(ConfigStore configs, String ... conditions) {
        Class<E> clazz = this.parseGenericClass();
        return this.select(clazz, configs, conditions);
    }

    @Override
    public E get(String ... conditions) {
        Class<E> clazz = this.parseGenericClass();
        return this.select(clazz, conditions);
    }

    @Override
    public DataSet querys(RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        conditions = BasicUtil.compress((String[])conditions);
        DataSet set = this.queryFromDao(prepare, this.append(configs, obj), conditions);
        return set;
    }

    @Override
    public DataSet querys(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.querys(prepare, configs, (Object)null, conditions);
    }

    @Override
    public DataSet querys(RunPrepare prepare, Object obj, String ... conditions) {
        return this.querys(prepare, null, obj, conditions);
    }

    @Override
    public DataSet querys(RunPrepare prepare, String ... conditions) {
        return this.querys(prepare, null, (Object)null, conditions);
    }

    @Override
    public DataSet querys(RunPrepare prepare, int fr, int to, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(fr, to);
        return this.querys(prepare, (ConfigStore)configs, obj, conditions);
    }

    @Override
    public DataSet querys(RunPrepare prepare, int fr, int to, String ... conditions) {
        return this.querys(prepare, fr, to, (Object)null, conditions);
    }

    @Override
    public DataSet caches(String cache, RunPrepare table, ConfigStore configs, Object obj, String ... conditions) {
        DataSet set = null;
        conditions = BasicUtil.compress((String[])conditions);
        if (null == cache) {
            set = this.querys(table, configs, obj, conditions);
        } else if (null == this.cacheProvider) {
            set = this.querys(table, configs, obj, conditions);
        }
        return set;
    }

    @Override
    public DataSet caches(String cache, RunPrepare table, ConfigStore configs, String ... conditions) {
        return this.caches(cache, table, configs, (Object)null, conditions);
    }

    @Override
    public DataSet caches(String cache, RunPrepare table, Object obj, String ... conditions) {
        return this.caches(cache, table, null, obj, conditions);
    }

    @Override
    public DataSet caches(String cache, RunPrepare table, String ... conditions) {
        return this.caches(cache, table, null, (Object)null, conditions);
    }

    @Override
    public DataSet caches(String cache, RunPrepare table, int fr, int to, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(fr, to);
        return this.caches(cache, table, (ConfigStore)configs, obj, conditions);
    }

    @Override
    public DataSet caches(String cache, RunPrepare table, int fr, int to, String ... conditions) {
        return this.caches(cache, table, fr, to, (Object)null, conditions);
    }

    @Override
    public DataRow query(RunPrepare table, ConfigStore store, Object obj, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0);
        navi.setLastRow(0);
        navi.setCalType(1);
        if (null == store) {
            store = new DefaultConfigStore(new String[0]);
        }
        store.setPageNavi((PageNavi)navi);
        DataSet set = this.querys(table, store, obj, conditions);
        if (null != set && set.size() > 0) {
            DataRow row = set.getRow(0);
            return row;
        }
        if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            return new DataRow();
        }
        return null;
    }

    @Override
    public DataRow query(RunPrepare table, ConfigStore store, String ... conditions) {
        return this.query(table, store, (Object)null, conditions);
    }

    @Override
    public DataRow query(RunPrepare table, Object obj, String ... conditions) {
        return this.query(table, null, obj, conditions);
    }

    @Override
    public DataRow query(RunPrepare table, String ... conditions) {
        return this.query(table, null, (Object)null, conditions);
    }

    @Override
    public DataRow cache(String cache, RunPrepare table, ConfigStore configs, Object obj, String ... conditions) {
        CacheElement cacheElement;
        if (null == cache) {
            return this.query(table, configs, obj, conditions);
        }
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0);
        navi.setLastRow(0);
        navi.setCalType(1);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        configs.setPageNavi((PageNavi)navi);
        configs = this.append(configs, obj);
        DataRow row = null;
        String key = "ROW:";
        if (cache.contains(":")) {
            String[] ks = BeanUtil.parseKeyValue((String)cache);
            cache = ks[0];
            key = key + ks[1] + ":";
        }
        key = key + CacheUtil.createCacheElementKey(true, true, table.getTable(), configs, conditions);
        if (null != this.cacheProvider && null != (cacheElement = this.cacheProvider.get(cache, key)) && null != cacheElement.getValue()) {
            Object cacheValue = cacheElement.getValue();
            if (cacheValue instanceof DataRow) {
                row = (DataRow)cacheValue;
                row.setIsFromCache(true);
                return row;
            }
            this.log.error("[\u7f13\u5b58\u8bbe\u7f6e\u9519\u8bef,\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u6709\u91cd\u590dcache.name \u6216Java\u4ee3\u7801\u8c03\u7528\u4e2dcache.name\u6df7\u6dc6][channel:{}]", (Object)cache);
        }
        if (null != (row = this.query(table, configs, conditions)) && null != this.cacheProvider) {
            this.cacheProvider.put(cache, key, (Object)row);
        }
        if (null == row && ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            row = new DataRow();
        }
        return row;
    }

    @Override
    public DataRow cache(String cache, RunPrepare table, ConfigStore configs, String ... conditions) {
        return this.cache(cache, table, configs, (Object)null, conditions);
    }

    @Override
    public DataRow cache(String cache, RunPrepare table, Object obj, String ... conditions) {
        return this.cache(cache, table, null, obj, conditions);
    }

    @Override
    public DataRow cache(String cache, RunPrepare table, String ... conditions) {
        return this.cache(cache, table, null, (Object)null, conditions);
    }

    @Override
    public boolean removeCache(String channel, String src, ConfigStore configs, String ... conditions) {
        if (null != this.cacheProvider) {
            src = BasicUtil.compress((String)src);
            conditions = BasicUtil.compress((String[])conditions);
            String key = CacheUtil.createCacheElementKey(true, true, src, configs, conditions);
            this.cacheProvider.remove(channel, "SET:" + key);
            this.cacheProvider.remove(channel, "ROW:" + key);
            DefaultPageNavi navi = new DefaultPageNavi();
            navi.setFirstRow(0);
            navi.setLastRow(0);
            navi.setCalType(1);
            if (null == configs) {
                configs = new DefaultConfigStore(new String[0]);
            }
            configs.setPageNavi((PageNavi)navi);
            key = CacheUtil.createCacheElementKey(true, true, src, configs, conditions);
            this.cacheProvider.remove(channel, "ROW:" + key);
        }
        return true;
    }

    @Override
    public boolean removeCache(String channel, String src, String ... conditions) {
        return this.removeCache(channel, src, (ConfigStore)null, conditions);
    }

    @Override
    public boolean removeCache(String channel, String src, int fr, int to, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(fr, to);
        return this.removeCache(channel, src, configs, conditions);
    }

    @Override
    public boolean clearCache(String channel) {
        if (null != this.cacheProvider) {
            return this.cacheProvider.clear(channel);
        }
        return false;
    }

    @Override
    public boolean exists(String src, ConfigStore configs, Object obj, String ... conditions) {
        boolean result = false;
        src = BasicUtil.compress((String)src);
        conditions = BasicUtil.compress((String[])conditions);
        RunPrepare prepare = this.createRunPrepare(src);
        result = this.dao.exists(prepare, this.append(configs, obj), conditions);
        return result;
    }

    @Override
    public boolean exists(String src, ConfigStore configs, String ... conditions) {
        return this.exists(src, configs, (Object)null, conditions);
    }

    @Override
    public boolean exists(String src, Object obj, String ... conditions) {
        return this.exists(src, null, obj, conditions);
    }

    @Override
    public boolean exists(String src, String ... conditions) {
        return this.exists(src, null, (Object)null, conditions);
    }

    @Override
    public boolean exists(String src, DataRow row) {
        if (null != row) {
            List keys = row.getPrimaryKeys();
            if (null != keys) {
                String[] conditions = new String[keys.size()];
                int idx = 0;
                for (String key : keys) {
                    conditions[idx++] = key + ":" + row.getString(new String[]{key});
                }
                return this.exists(src, (ConfigStore)null, conditions);
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean exists(DataRow row) {
        return this.exists(null, row);
    }

    @Override
    public int count(String src, ConfigStore configs, Object obj, String ... conditions) {
        int count;
        block3: {
            count = -1;
            try {
                src = BasicUtil.compress((String)src);
                conditions = BasicUtil.compress((String[])conditions);
                RunPrepare prepare = this.createRunPrepare(src);
                count = this.dao.count(prepare, this.append(configs, obj), conditions);
            }
            catch (Exception e) {
                if (ConfigTable.IS_DEBUG && this.log.isWarnEnabled()) {
                    e.printStackTrace();
                }
                this.log.error("COUNT ERROR:" + e);
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block3;
                throw e;
            }
        }
        return count;
    }

    @Override
    public int count(String src, ConfigStore configs, String ... conditions) {
        return this.count(src, configs, (Object)null, conditions);
    }

    @Override
    public int count(String src, Object obj, String ... conditions) {
        return this.count(src, null, obj, conditions);
    }

    @Override
    public int count(String src, String ... conditions) {
        return this.count(src, null, (Object)null, conditions);
    }

    @Override
    public int update(boolean async, String dest, Object data, ConfigStore configs, List<String> fixs, String ... columns) {
        dest = DataSourceHolder.parseDataSource(dest, dest);
        fixs = BeanUtil.merge(fixs, (Object[])columns);
        final List cols = BeanUtil.merge((List)fixs, (Object[])columns);
        final String _dest = BasicUtil.compress((String)dest);
        final Object _data = data;
        final ConfigStore _configs = configs;
        if (async) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    DefaultService.this.dao.update(_dest, _data, _configs, cols);
                }
            }).start();
            return 0;
        }
        return this.dao.update(dest, data, configs, cols);
    }

    @Override
    public int update(boolean async, String dest, Object data, List<String> fixs, String ... columns) {
        return this.update(async, dest, data, null, fixs, columns);
    }

    @Override
    public int update(boolean async, String dest, Object data, String[] fixs, String ... columns) {
        return this.update(async, dest, data, null, BeanUtil.array2list((Object[][])new String[][]{fixs, columns}), new String[0]);
    }

    @Override
    public int update(boolean async, String dest, Object data, String ... columns) {
        return this.update(async, dest, data, null, BeanUtil.array2list((Object[][])new String[][]{columns}), new String[0]);
    }

    @Override
    public int update(boolean async, String dest, Object data, ConfigStore configs, String[] fixs, String ... columns) {
        return this.update(async, dest, data, configs, BeanUtil.array2list((Object[][])new String[][]{fixs, columns}), new String[0]);
    }

    @Override
    public int update(boolean async, String dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(async, dest, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}), new String[0]);
    }

    @Override
    public int update(boolean async, Object data, ConfigStore configs, List<String> fixs, String ... columns) {
        return this.update(async, null, data, configs, fixs, columns);
    }

    @Override
    public int update(boolean async, Object data, List<String> fixs, String ... columns) {
        return this.update(async, null, data, null, fixs, columns);
    }

    @Override
    public int update(boolean async, Object data, String[] fixs, String ... columns) {
        return this.update(async, null, data, null, BeanUtil.array2list((Object[][])new String[][]{fixs, columns}), new String[0]);
    }

    @Override
    public int update(boolean async, Object data, String ... columns) {
        return this.update(async, null, data, null, BeanUtil.array2list((Object[][])new String[][]{columns}), new String[0]);
    }

    @Override
    public int update(boolean async, Object data, ConfigStore configs, String[] fixs, String ... columns) {
        return this.update(async, null, data, configs, BeanUtil.array2list((Object[][])new String[][]{fixs, columns}), new String[0]);
    }

    @Override
    public int update(boolean async, Object data, ConfigStore configs, String ... columns) {
        return this.update(async, null, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}), new String[0]);
    }

    @Override
    public int update(String dest, Object data, ConfigStore configs, List<String> fixs, String ... columns) {
        return this.update(false, dest, data, configs, fixs, columns);
    }

    @Override
    public int update(String dest, Object data, ConfigStore configs, String[] fixs, String ... columns) {
        return this.update(false, dest, data, configs, BeanUtil.array2list((Object[][])new String[][]{fixs, columns}), new String[0]);
    }

    @Override
    public int update(String dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(false, dest, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}), new String[0]);
    }

    @Override
    public int update(String dest, Object data, List<String> fixs, String ... columns) {
        return this.update(false, dest, data, null, fixs, columns);
    }

    @Override
    public int update(String dest, Object data, String[] fixs, String ... columns) {
        return this.update(false, dest, data, null, BeanUtil.array2list((Object[][])new String[][]{fixs, columns}), new String[0]);
    }

    @Override
    public int update(String dest, Object data, String ... columns) {
        return this.update(false, dest, data, null, BeanUtil.array2list((Object[][])new String[][]{columns}), new String[0]);
    }

    @Override
    public int update(Object data, ConfigStore configs, List<String> fixs, String ... columns) {
        return this.update(false, null, data, configs, fixs, columns);
    }

    @Override
    public int update(Object data, ConfigStore configs, String[] fixs, String ... columns) {
        return this.update(false, null, data, configs, BeanUtil.array2list((Object[][])new String[][]{fixs, columns}), new String[0]);
    }

    @Override
    public int update(Object data, ConfigStore configs, String ... columns) {
        return this.update(false, null, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}), new String[0]);
    }

    @Override
    public int update(Object data, List<String> fixs, String ... columns) {
        return this.update(false, null, data, null, fixs, columns);
    }

    @Override
    public int update(Object data, String[] fixs, String ... columns) {
        return this.update(false, null, data, null, BeanUtil.array2list((Object[][])new String[][]{fixs, columns}), new String[0]);
    }

    @Override
    public int update(Object data, String ... columns) {
        return this.update(false, null, data, null, BeanUtil.array2list((Object[][])new String[][]{columns}), new String[0]);
    }

    @Override
    public int save(boolean async, String dest, Object data, boolean checkPrimary, String[] fixs, String ... columns) {
        return this.save(async, dest, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{fixs, columns}), new String[0]);
    }

    @Override
    public int save(boolean async, String dest, Object data, boolean checkPrimary, String ... columns) {
        return this.save(async, dest, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}), new String[0]);
    }

    @Override
    public int save(boolean async, String dest, Object data, boolean checkPrimary, List<String> fixs, String ... columns) {
        if (async) {
            final String _dest = dest;
            final Object _data = data;
            final boolean _chk = checkPrimary;
            final String[] cols = (String[])BeanUtil.list2array((List)BeanUtil.merge(fixs, (Object[])columns));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    DefaultService.this.save(_dest, _data, _chk, cols);
                }
            }).start();
            return 0;
        }
        return this.save(dest, data, checkPrimary, columns);
    }

    @Override
    public int save(String dest, Object data, boolean checkPrimary, List<String> fixs, String ... columns) {
        if (null == data) {
            return 0;
        }
        columns = (String[])BeanUtil.list2array((List)BeanUtil.merge(fixs, (Object[])columns));
        if (data instanceof Collection) {
            Collection datas = (Collection)data;
            int cnt = 0;
            for (Object obj : datas) {
                cnt += this.save(dest, obj, checkPrimary, columns);
            }
            return cnt;
        }
        return this.saveObject(dest, data, checkPrimary, columns, new String[0]);
    }

    @Override
    public int save(String dest, Object data, boolean checkPrimary, String[] fixs, String ... columns) {
        return this.save(dest, data, checkPrimary, (List<String>)BeanUtil.array2list((Object[][])new String[][]{fixs, columns}), new String[0]);
    }

    @Override
    public int save(String dest, Object data, boolean checkPrimary, String ... columns) {
        return this.save(dest, data, checkPrimary, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}), new String[0]);
    }

    @Override
    public int save(Object data, boolean checkPrimary, List<String> fixs, String ... columns) {
        return this.save(null, data, checkPrimary, (List<String>)BeanUtil.merge(fixs, (Object[])columns), new String[0]);
    }

    @Override
    public int save(Object data, boolean checkPrimary, String[] fixs, String ... columns) {
        return this.save(null, data, checkPrimary, (List<String>)BeanUtil.array2list((Object[][])new String[][]{fixs, columns}), new String[0]);
    }

    @Override
    public int save(Object data, boolean checkPrimary, String ... columns) {
        return this.save(null, data, checkPrimary, columns);
    }

    @Override
    public int save(boolean async, Object data, boolean checkPrimary, List<String> fixs, String ... columns) {
        return this.save(async, null, data, checkPrimary, fixs, columns);
    }

    @Override
    public int save(boolean async, Object data, boolean checkPrimary, String[] fixs, String ... columns) {
        return this.save(async, (String)null, data, checkPrimary, fixs, columns);
    }

    @Override
    public int save(boolean async, Object data, boolean checkPrimary, String ... columns) {
        return this.save(async, null, data, checkPrimary, columns);
    }

    @Override
    public int save(Object data, List<String> fixs, String ... columns) {
        return this.save(null, data, false, fixs, columns);
    }

    @Override
    public int save(Object data, String[] fixs, String ... columns) {
        return this.save((String)null, data, false, fixs, columns);
    }

    @Override
    public int save(Object data, String ... columns) {
        return this.save(null, data, false, columns);
    }

    @Override
    public int save(boolean async, Object data, List<String> fixs, String ... columns) {
        return this.save(async, null, data, false, fixs, columns);
    }

    @Override
    public int save(boolean async, Object data, String[] fixs, String ... columns) {
        return this.save(async, (String)null, data, false, fixs, columns);
    }

    @Override
    public int save(boolean async, Object data, String ... columns) {
        return this.save(async, null, data, false, columns);
    }

    @Override
    public int save(String dest, Object data, List<String> fixs, String ... columns) {
        return this.save(dest, data, false, fixs, columns);
    }

    @Override
    public int save(String dest, Object data, String[] fixs, String ... columns) {
        return this.save(dest, data, false, fixs, columns);
    }

    @Override
    public int save(String dest, Object data, String ... columns) {
        return this.save(dest, data, false, columns);
    }

    @Override
    public int save(boolean async, String dest, Object data, List<String> fixs, String ... columns) {
        return this.save(async, dest, data, false, fixs, columns);
    }

    @Override
    public int save(boolean async, String dest, Object data, String[] fixs, String ... columns) {
        return this.save(async, dest, data, false, fixs, columns);
    }

    @Override
    public int save(boolean async, String dest, Object data, String ... columns) {
        return this.save(async, dest, data, false, columns);
    }

    protected int saveObject(String dest, Object data, boolean checkPrimary, List<String> fixs, String ... columns) {
        if (BasicUtil.isEmpty((Object)dest)) {
            if (data instanceof DataRow || data instanceof DataSet) {
                dest = DataSourceHolder.parseDataSource(dest, data);
            } else if (EntityAdapterProxy.hasAdapter()) {
                dest = EntityAdapterProxy.table(data.getClass());
            }
        }
        return this.dao.save(dest, data, checkPrimary, (String[])BeanUtil.list2array((List)BeanUtil.merge(fixs, (Object[])columns)));
    }

    protected int saveObject(String dest, Object data, boolean checkPrimary, String[] fixs, String ... columns) {
        return this.saveObject(dest, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{fixs, columns}), new String[0]);
    }

    @Override
    public int insert(String dest, Object data, boolean checkPrimary, List<String> fixs, String ... columns) {
        dest = DataSourceHolder.parseDataSource(dest, data);
        columns = (String[])BeanUtil.list2array((List)BeanUtil.merge(fixs, (Object[])columns));
        return this.dao.insert(dest, data, checkPrimary, columns);
    }

    @Override
    public int insert(String dest, Object data, boolean checkPrimary, String[] fixs, String ... columns) {
        return this.insert(dest, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{fixs, columns}), new String[0]);
    }

    @Override
    public int insert(String dest, Object data, boolean checkPrimary, String ... columns) {
        return this.insert(dest, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}), new String[0]);
    }

    @Override
    public int insert(Object data, boolean checkPrimary, List<String> fixs, String ... columns) {
        return this.insert(null, data, checkPrimary, fixs, columns);
    }

    @Override
    public int insert(Object data, boolean checkPrimary, String[] fixs, String ... columns) {
        return this.insert(null, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{fixs, columns}), new String[0]);
    }

    @Override
    public int insert(Object data, boolean checkPrimary, String ... columns) {
        return this.insert(null, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}), new String[0]);
    }

    @Override
    public int insert(Object data, List<String> fixs, String ... columns) {
        return this.insert(null, data, false, fixs, columns);
    }

    @Override
    public int insert(Object data, String[] fixs, String ... columns) {
        return this.insert((String)null, data, false, fixs, columns);
    }

    @Override
    public int insert(Object data, String ... columns) {
        return this.insert(null, data, false, columns);
    }

    @Override
    public int insert(String dest, Object data, List<String> fixs, String ... columns) {
        return this.insert(dest, data, false, fixs, columns);
    }

    @Override
    public int insert(String dest, Object data, String[] fixs, String ... columns) {
        return this.insert(dest, data, false, fixs, columns);
    }

    @Override
    public int insert(String dest, Object data, String ... columns) {
        return this.insert(dest, data, false, columns);
    }

    @Override
    public boolean executeProcedure(String procedure, String ... inputs) {
        DefaultProcedure proc = new DefaultProcedure();
        proc.setName(procedure);
        for (String input : inputs) {
            proc.addInput(input);
        }
        return this.execute(proc, new String[0]);
    }

    @Override
    public boolean execute(Procedure procedure, String ... inputs) {
        procedure.setName(DataSourceHolder.parseDataSource(procedure.getName(), null));
        if (null != inputs) {
            for (String input : inputs) {
                procedure.addInput(input);
            }
        }
        return this.dao.execute(procedure);
    }

    @Override
    public DataSet querys(Procedure procedure, PageNavi navi, String ... inputs) {
        DataSet set;
        block5: {
            set = null;
            try {
                procedure.setName(DataSourceHolder.parseDataSource(procedure.getName()));
                if (null != inputs) {
                    for (String input : inputs) {
                        procedure.addInput(input);
                    }
                }
                set = this.dao.querys(procedure, navi);
            }
            catch (Exception e) {
                set = new DataSet();
                set.setException(e);
                this.log.error("QUERY ERROR:" + e);
                if (this.log.isWarnEnabled()) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block5;
                throw e;
            }
        }
        return set;
    }

    public DataSet querys(Procedure procedure, String ... inputs) {
        return this.querys(procedure, (PageNavi)null, inputs);
    }

    @Override
    public DataSet querys(Procedure procedure, int fr, int to, String ... inputs) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(fr);
        navi.setLastRow(to);
        return this.querys(procedure, (PageNavi)navi, inputs);
    }

    @Override
    public DataSet querysProcedure(String procedure, PageNavi navi, String ... inputs) {
        DefaultProcedure proc = new DefaultProcedure();
        proc.setName(procedure);
        if (null != inputs) {
            for (String input : inputs) {
                proc.addInput(input);
            }
        }
        return this.querys((Procedure)proc, navi, new String[0]);
    }

    @Override
    public DataSet querysProcedure(String procedure, int fr, int to, String ... inputs) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(fr);
        navi.setLastRow(to);
        return this.querysProcedure(procedure, (PageNavi)navi, inputs);
    }

    @Override
    public DataSet querysProcedure(String procedure, String ... inputs) {
        return this.querysProcedure(procedure, (PageNavi)null, inputs);
    }

    @Override
    public DataRow queryProcedure(String procedure, String ... inputs) {
        DefaultProcedure proc = new DefaultProcedure();
        proc.setName(procedure);
        return this.query(procedure, inputs);
    }

    @Override
    public DataRow query(Procedure procedure, String ... inputs) {
        DataSet set = this.querys(procedure, 0, 0, inputs);
        if (set.size() > 0) {
            return set.getRow(0);
        }
        if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            return new DataRow();
        }
        return null;
    }

    @Override
    public int execute(String src, ConfigStore store, String ... conditions) {
        int result = -1;
        src = BasicUtil.compress((String)src);
        src = DataSourceHolder.parseDataSource(src);
        conditions = BasicUtil.compress((String[])conditions);
        RunPrepare prepare = this.createRunPrepare(src);
        if (null == prepare) {
            return result;
        }
        result = this.dao.execute(prepare, store, conditions);
        return result;
    }

    @Override
    public int execute(String src, String ... conditions) {
        return this.execute(src, (ConfigStore)null, conditions);
    }

    @Override
    public int delete(String dest, DataSet set, String ... columns) {
        int cnt = 0;
        int size = set.size();
        for (int i = 0; i < size; ++i) {
            cnt += this.delete(dest, set.getRow(i), columns);
        }
        this.log.warn("[delete DataSet][\u5f71\u54cd\u884c\u6570:{}]", (Object)LogUtil.format((int)cnt, (int)34));
        return cnt;
    }

    @Override
    public int delete(DataSet set, String ... columns) {
        String dest = DataSourceHolder.parseDataSource(null, set);
        return this.delete(dest, set, columns);
    }

    @Override
    public int delete(String dest, DataRow row, String ... columns) {
        dest = DataSourceHolder.parseDataSource(dest, row);
        return this.dao.delete(dest, row, columns);
    }

    @Override
    public int delete(Object obj, String ... columns) {
        if (null == obj) {
            return 0;
        }
        String dest = null;
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            dest = DataSourceHolder.parseDataSource(null, row);
            return this.dao.delete(dest, row, columns);
        }
        if (EntityAdapterProxy.hasAdapter()) {
            dest = obj instanceof Collection ? EntityAdapterProxy.table(((Collection)obj).iterator().next().getClass()) : EntityAdapterProxy.table(obj.getClass());
            return this.dao.delete(dest, obj, columns);
        }
        return 0;
    }

    @Override
    public int delete(String table, String ... kvs) {
        table = DataSourceHolder.parseDataSource(table);
        DataRow row = DataRow.parseArray((String[])kvs);
        row.setPrimaryKey((Collection)row.keys());
        return this.dao.delete(table, row, new String[0]);
    }

    @Override
    public int deletes(String table, String key, Collection<Object> values) {
        table = DataSourceHolder.parseDataSource(table);
        return this.dao.deletes(table, key, values);
    }

    @Override
    public int deletes(String table, String key, String ... values) {
        table = DataSourceHolder.parseDataSource(table);
        return this.dao.deletes(table, key, values);
    }

    @Override
    public int delete(String table, ConfigStore configs, String ... conditions) {
        table = DataSourceHolder.parseDataSource(table);
        return this.dao.delete(table, configs, conditions);
    }

    protected PageNavi setPageLazy(String src, ConfigStore configs, String ... conditions) {
        PageNavi navi = null;
        String lazyKey = null;
        if (null != configs && null != (navi = configs.getPageNavi()) && navi.isLazy()) {
            lazyKey = CacheUtil.createCacheElementKey(false, false, src, configs, conditions);
            navi.setLazyKey(lazyKey);
            int total = PageLazyStore.getTotal(lazyKey, navi.getLazyPeriod());
            navi.setTotalRow(total);
        }
        return navi;
    }

    protected DataSet queryFromDao(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        DataSet set;
        block4: {
            set = null;
            if (ConfigTable.isSQLDebug()) {
                this.log.warn("[\u89e3\u6790SQL][src:{}]", (Object)prepare.getText());
            }
            try {
                this.setPageLazy(prepare.getText(), configs, conditions);
                set = this.dao.querys(prepare, configs, conditions);
            }
            catch (Exception e) {
                set = new DataSet();
                set.setException(e);
                if (this.log.isWarnEnabled()) {
                    e.printStackTrace();
                }
                this.log.error("QUERY ERROR:" + e);
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block4;
                throw e;
            }
        }
        return set;
    }

    protected DataSet queryFromDao(String src, ConfigStore configs, String ... conditions) {
        DataSet set;
        block4: {
            set = null;
            if (ConfigTable.isSQLDebug()) {
                this.log.warn("[\u89e3\u6790SQL][src:{}]", (Object)src);
            }
            try {
                this.setPageLazy(src, configs, conditions);
                RunPrepare prepare = this.createRunPrepare(src);
                set = this.dao.querys(prepare, configs, conditions);
            }
            catch (Exception e) {
                set = new DataSet();
                set.setException(e);
                if (this.log.isWarnEnabled()) {
                    e.printStackTrace();
                }
                this.log.error("QUERY ERROR:" + e);
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block4;
                throw e;
            }
        }
        return set;
    }

    protected <T> EntitySet<T> queryFromDao(String src, Class<T> clazz, ConfigStore configs, String ... conditions) {
        EntitySet<T> list;
        block4: {
            list = null;
            if (ConfigTable.isSQLDebug()) {
                this.log.warn("[\u89e3\u6790SQL][src:{}]", clazz);
            }
            try {
                this.setPageLazy(src, configs, conditions);
                RunPrepare prepare = this.createRunPrepare(src);
                list = this.dao.querys(prepare, clazz, configs, conditions);
            }
            catch (Exception e) {
                list = new EntitySet<T>();
                if (this.log.isWarnEnabled()) {
                    e.printStackTrace();
                }
                this.log.error("QUERY ERROR:" + e);
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block4;
                throw e;
            }
        }
        return list;
    }

    protected <T> EntitySet<T> queryFromDao(Class<T> clazz, ConfigStore configs, String ... conditions) {
        EntitySet<T> list;
        block4: {
            list = null;
            if (ConfigTable.isSQLDebug()) {
                this.log.warn("[\u89e3\u6790SQL][src:{}]", clazz);
            }
            try {
                this.setPageLazy(clazz.getName(), configs, conditions);
                list = this.dao.querys(clazz, configs, conditions);
            }
            catch (Exception e) {
                list = new EntitySet<T>();
                if (this.log.isWarnEnabled()) {
                    e.printStackTrace();
                }
                this.log.error("QUERY ERROR:" + e);
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block4;
                throw e;
            }
        }
        return list;
    }

    protected String parsePrimaryKey(String src, List<String> pks) {
        if (src.endsWith(">")) {
            int fr = src.lastIndexOf("<");
            int to = src.lastIndexOf(">");
            if (fr != -1) {
                String[] tmps;
                String pkstr = src.substring(fr + 1, to);
                src = src.substring(0, fr);
                for (String tmp : tmps = pkstr.split(",")) {
                    pks.add(tmp);
                    if (!ConfigTable.isSQLDebug()) continue;
                    this.log.warn("[\u89e3\u6790SQL\u4e3b\u952e] [KEY:{}]", (Object)tmp);
                }
            }
        }
        return src;
    }

    protected synchronized RunPrepare createRunPrepare(String src) {
        RunPrepare prepare = null;
        src = src.trim();
        ArrayList<String> pks = new ArrayList<String>();
        if (src.startsWith("${") && src.endsWith("}")) {
            if (ConfigTable.isSQLDebug()) {
                this.log.warn("[\u89e3\u6790SQL\u7c7b\u578b] [\u7c7b\u578b:{JAVA\u5b9a\u4e49}] [src:{}]", (Object)src);
            }
            src = src.substring(2, src.length() - 1);
            src = DataSourceHolder.parseDataSource(src);
            src = this.parsePrimaryKey(src, pks);
            prepare = new DefaultTextPrepare(src);
        } else {
            src = DataSourceHolder.parseDataSource(src);
            if ((src = this.parsePrimaryKey(src, pks)).replace("\n", "").replace("\r", "").trim().matches("^[a-zA-Z]+\\s+.+")) {
                if (ConfigTable.isSQLDebug()) {
                    this.log.warn("[\u89e3\u6790SQL\u7c7b\u578b] [\u7c7b\u578b:JAVA\u5b9a\u4e49] [src:{}]", (Object)src);
                }
                prepare = new DefaultTextPrepare(src);
            } else if (RegularUtil.match((String)src, (String)"(\\.|\\S)*\\S+:\\S+")) {
                if (ConfigTable.isSQLDebug()) {
                    this.log.warn("[\u89e3\u6790SQL\u7c7b\u578b] [\u7c7b\u578b:XML\u5b9a\u4e49] [src:{}]", (Object)src);
                }
                if (null == (prepare = DefaultSQLStore.parseSQL(src))) {
                    this.log.error("[\u89e3\u6790SQL\u7c7b\u578b][XML\u89e3\u6790\u5931\u8d25][src:{}]", (Object)src);
                }
            } else {
                if (ConfigTable.isSQLDebug()) {
                    this.log.warn("[\u89e3\u6790SQL\u7c7b\u578b] [\u7c7b\u578b:auto] [src:{}]", (Object)src);
                }
                prepare = new DefaultTablePrepare();
                prepare.setDataSource(src);
            }
        }
        if (null != prepare && pks.size() > 0) {
            prepare.setPrimaryKey(pks);
        }
        return prepare;
    }

    protected DataSet queryFromCache(String cache, String src, ConfigStore configs, String ... conditions) {
        if (ConfigTable.IS_DEBUG && this.log.isWarnEnabled()) {
            this.log.warn("[cache from][cache:{}][src:{}]", (Object)cache, (Object)src);
        }
        DataSet set = null;
        String key = "SET:";
        if (cache.contains(">")) {
            String[] tmp = cache.split(">");
            cache = tmp[0];
        }
        if (cache.contains(":")) {
            String[] ks = BeanUtil.parseKeyValue((String)cache);
            cache = ks[0];
            key = key + ks[1] + ":";
        }
        key = key + CacheUtil.createCacheElementKey(true, true, src, configs, conditions);
        RunPrepare prepare = this.createRunPrepare(src);
        if (null != this.cacheProvider) {
            CacheElement cacheElement = this.cacheProvider.get(cache, key);
            if (null != cacheElement && null != cacheElement.getValue()) {
                Object cacheValue = cacheElement.getValue();
                if (cacheValue instanceof DataSet) {
                    set = (DataSet)cacheValue;
                    set.setIsFromCache(true);
                } else {
                    this.log.error("[\u7f13\u5b58\u8bbe\u7f6e\u9519\u8bef,\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u6709\u91cd\u590dcache.name \u6216Java\u4ee3\u7801\u8c03\u7528\u4e2dcache.name\u6df7\u6dc6][channel:{}]", (Object)cache);
                }
                long age = (System.currentTimeMillis() - cacheElement.getCreateTime()) / 1000L;
                final int _max = cacheElement.getExpires();
                if ((double)age > (double)_max * 0.9) {
                    if (ConfigTable.IS_DEBUG && this.log.isWarnEnabled()) {
                        this.log.warn("[\u7f13\u5b58\u5373\u5c06\u5230\u671f\u63d0\u524d\u5237\u65b0][src:{}] [\u751f\u5b58:{}/{}]", new Object[]{src, age, _max});
                    }
                    final String _key = key;
                    final String _cache = cache;
                    final RunPrepare _sql = prepare;
                    final ConfigStore _configs = configs;
                    final String[] _conditions = conditions;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            CacheUtil.start(_key, _max / 10);
                            DataSet newSet = DefaultService.this.dao.querys(_sql, _configs, _conditions);
                            DefaultService.this.cacheProvider.put(_cache, _key, (Object)newSet);
                            CacheUtil.stop(_key, _max / 10);
                        }
                    }).start();
                }
            } else {
                this.setPageLazy(src, configs, conditions);
                set = this.dao.querys(prepare, configs, conditions);
                this.cacheProvider.put(cache, key, (Object)set);
            }
        }
        return set;
    }

    private ConfigStore append(ConfigStore configs, Object entity) {
        block8: {
            if (null == configs) {
                configs = new DefaultConfigStore(new String[0]);
            }
            if (null == entity) break block8;
            if (entity instanceof Map) {
                Map map = (Map)entity;
                for (Object key : map.keySet()) {
                    Object value = map.get(key);
                    if (value instanceof Collection) {
                        configs.ands(key.toString(), value);
                        continue;
                    }
                    configs.and(key.toString(), value);
                }
            } else {
                List fields = ClassUtil.getFields(entity.getClass());
                for (Field field : fields) {
                    Object value = BeanUtil.getFieldValue((Object)entity, (Field)field);
                    if (!BasicUtil.isNotEmpty((boolean)true, (Object)value)) continue;
                    String key = field.getName();
                    if (EntityAdapterProxy.hasAdapter()) {
                        key = EntityAdapterProxy.column(entity.getClass(), (Field)field);
                    }
                    if (BasicUtil.isEmpty((Object)key)) continue;
                    if (value instanceof Collection) {
                        configs.ands(key, value);
                        continue;
                    }
                    configs.and(key, value);
                }
            }
        }
        return configs;
    }

    @Override
    public List<String> tables(String catalog, String schema, String name, String types) {
        LinkedHashMap<String, Table> tables = this.metadata.tables(catalog, schema, name, types);
        ArrayList<String> list = new ArrayList<String>();
        for (Table table : tables.values()) {
            list.add(table.getName());
        }
        return list;
    }

    @Override
    public List<String> tables(String schema, String name, String types) {
        return this.tables(null, schema, name, types);
    }

    @Override
    public List<String> tables(String name, String types) {
        return this.tables(null, null, name, types);
    }

    @Override
    public List<String> tables(String types) {
        return this.tables(null, null, null, types);
    }

    @Override
    public List<String> tables() {
        return this.tables(null);
    }

    @Override
    public List<String> mtables(String catalog, String schema, String name, String types) {
        LinkedHashMap<String, MasterTable> tables = this.metadata.mtables(catalog, schema, name, types);
        ArrayList<String> list = new ArrayList<String>();
        for (MasterTable table : tables.values()) {
            list.add(table.getName());
        }
        return list;
    }

    @Override
    public List<String> mtables(String schema, String name, String types) {
        return this.mtables(null, schema, name, types);
    }

    @Override
    public List<String> mtables(String name, String types) {
        return this.mtables(null, null, name, types);
    }

    @Override
    public List<String> mtables(String types) {
        return this.mtables(null, null, null, types);
    }

    @Override
    public List<String> mtables() {
        return this.mtables("STABLE");
    }

    public LinkedHashMap<String, Column> columns(String table, boolean map) {
        return this.metadata.columns(table);
    }

    @Override
    public List<String> columns(Table table) {
        return this.columns(table.getCatalog(), table.getSchema(), table.getName());
    }

    @Override
    public List<String> columns(String table) {
        return this.columns(null, null, table);
    }

    @Override
    public List<String> columns(String catalog, String schema, String table) {
        LinkedHashMap<String, Column> columns = this.metadata.columns(catalog, schema, table);
        ArrayList<String> list = new ArrayList<String>();
        for (Column column : columns.values()) {
            list.add(column.getName());
        }
        return list;
    }

    @Override
    public List<String> tags(Table table) {
        return this.tags(table.getCatalog(), table.getSchema(), table.getName());
    }

    @Override
    public List<String> tags(String table) {
        return this.tags(null, null, table);
    }

    @Override
    public List<String> tags(String catalog, String schema, String table) {
        LinkedHashMap<String, Tag> tags = this.metadata.tags(catalog, schema, table);
        ArrayList<String> list = new ArrayList<String>();
        for (Tag tag : tags.values()) {
            list.add(tag.getName());
        }
        return list;
    }

    public boolean save(Table table) throws Exception {
        return this.ddl.save(table);
    }

    public boolean save(Column column) throws Exception {
        return this.ddl.save(column);
    }

    public boolean drop(Table table) throws Exception {
        return this.ddl.drop(table);
    }

    public boolean drop(Column column) throws Exception {
        return this.ddl.drop(column);
    }

    @Override
    public AnylineService.MetaDataService metadata() {
        return this.metadata;
    }

    @Override
    public AnylineService.DDLService ddl() {
        return this.ddl;
    }

    public void clearColumnCache(String catalog, String schema, String table) {
        CacheProxy.clearColumnCache(catalog, schema, table);
    }

    public void clearTagCache(String catalog, String schema, String table) {
        CacheProxy.clearTagCache(catalog, schema, table);
    }
}

