/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.auto.init;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.param.Config;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.auto.AutoCondition;
import org.anyline.data.prepare.init.DefaultCondition;
import org.anyline.data.run.RunValue;
import org.anyline.entity.Compare;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.SQLUtil;

public class DefaultAutoCondition
extends DefaultCondition
implements AutoCondition {
    private String table;
    private String column;
    private Object values;
    private Object orValues;
    private Compare compare = Compare.EQUAL;
    private Compare orCompare = Compare.EQUAL;

    public DefaultAutoCondition(Config config) {
        this.setJoin(config.getJoin());
        this.setTable(config.getPrefix());
        this.setColumn(config.getVariable());
        this.setValues(config.getValues());
        this.setOrValues(config.getOrValues());
        this.setCompare(config.getCompare());
        this.setRequired(config.isRequire());
        this.setStrictRequired(config.isStrictRequired());
        this.setVariableType(0);
        if (config.isRequire()) {
            this.setActive(true);
        }
    }

    public DefaultAutoCondition(boolean required, boolean strictRequired, String prefix, String var, Object values, Compare compare) {
        this.setRequired(required);
        this.setStrictRequired(strictRequired);
        this.setTable(prefix);
        this.setColumn(var);
        this.setValues(values);
        this.setCompare(compare);
        this.setVariableType(0);
        if (BasicUtil.isNotEmpty((boolean)true, (Object)values) || required) {
            this.setActive(true);
        }
    }

    public DefaultAutoCondition(String text) {
        this.text = text;
        this.active = true;
        this.setVariableType(2);
    }

    @Override
    public String getRunText(String prefix, JDBCAdapter adapter) {
        this.runValues = new ArrayList();
        String text = "";
        if (this.variableType == 2) {
            text = this.text;
        } else {
            String txt = "";
            if (BasicUtil.isNotEmpty((boolean)true, (Object)this.values) || this.isRequired()) {
                txt = this.getRunText(prefix, adapter, this.values, this.compare);
                if (BasicUtil.isNotEmpty((Object)txt)) {
                    text = txt;
                }
                if (BasicUtil.isNotEmpty((boolean)true, (Object)this.orValues) && BasicUtil.isNotEmpty((Object)(txt = this.getRunText(prefix, adapter, this.orValues, this.orCompare)))) {
                    text = BasicUtil.isEmpty((Object)text) ? txt : "(" + text + " OR " + txt + ")";
                }
            }
        }
        return text;
    }

    public String getRunText(String prefix, JDBCAdapter adapter, Object val, Compare compare) {
        StringBuilder builder = new StringBuilder();
        String delimiterFr = adapter.getDelimiterFr();
        String delimiterTo = adapter.getDelimiterTo();
        int compareCode = compare.getCode();
        if (compareCode == -1) {
            return "";
        }
        StringBuilder col_builder = new StringBuilder();
        if (!this.column.contains(".")) {
            if (BasicUtil.isNotEmpty((Object)prefix)) {
                SQLUtil.delimiter((StringBuilder)col_builder, (String)prefix, (String)delimiterFr, (String)delimiterTo).append(".");
            } else if (BasicUtil.isNotEmpty((Object)this.table)) {
                SQLUtil.delimiter((StringBuilder)col_builder, (String)this.table, (String)delimiterFr, (String)delimiterTo).append(".");
            }
        }
        SQLUtil.delimiter((StringBuilder)col_builder, (String)this.column, (String)delimiterFr, (String)delimiterTo);
        if (compareCode >= 60 && compareCode <= 62) {
            val = adapter.buildConditionFindInSet(builder, col_builder.toString(), compare, val);
        } else {
            builder.append((CharSequence)col_builder);
            if (compareCode == 10) {
                Object v = this.getValue(val);
                if (null == v || "NULL".equals(v.toString())) {
                    builder.append(" IS NULL");
                    if ("NULL".equals(this.getValue())) {
                        this.variableType = 2;
                    }
                } else {
                    builder.append(compare.getSQL());
                }
            } else if (compareCode == 20) {
                builder.append(compare.getSQL());
            } else if (compareCode == 21) {
                builder.append(compare.getSQL());
            } else if (compareCode == 30) {
                builder.append(compare.getSQL());
            } else if (compareCode == 110) {
                builder.append(compare.getSQL());
            } else if (compareCode == 31) {
                builder.append(compare.getSQL());
            } else if (compareCode == 80) {
                builder.append(compare.getSQL());
            } else if (compareCode == 40 || compareCode == 140) {
                adapter.buildConditionIn(builder, compare, val);
            } else if (compareCode >= 50 && compareCode <= 52) {
                val = adapter.buildConditionLike(builder, compare, val);
            }
        }
        if (null != val) {
            if (compareCode == 40 || compareCode == 140 || compareCode == 80) {
                List<Object> list = this.getValues(val);
                if (null != list) {
                    for (Object obj : list) {
                        this.runValues.add(new RunValue(this.column, obj));
                    }
                }
            } else {
                Object value = this.getValue(val);
                if (null != value && !"NULL".equals(value) || compareCode != 10) {
                    this.runValues.add(new RunValue(this.column, value));
                }
            }
        }
        return builder.toString();
    }

    public Object getValue(Object src) {
        Object value = null;
        if (null != src) {
            if (src instanceof List) {
                if (((List)src).size() > 0) {
                    value = ((List)src).get(0);
                }
            } else {
                value = src;
            }
        }
        return value;
    }

    public List<Object> getValues(Object src) {
        List<Object> values = new ArrayList<Object>();
        if (null != src) {
            if (src instanceof List) {
                values = (List)src;
            } else {
                values.add(src);
            }
        }
        return values;
    }

    @Override
    public Object getValue() {
        return this.getValue(this.values);
    }

    @Override
    public List<Object> getValues() {
        return this.getValues(this.values);
    }

    public Object getOrValue() {
        return this.getValue(this.orValues);
    }

    public List<Object> getOrValues() {
        return this.getValues(this.orValues);
    }

    @Override
    public String getId() {
        return this.column;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    @Override
    public void setColumn(String column) {
        this.column = column;
    }

    @Override
    public void setValues(Object values) {
        this.values = values;
    }

    public void setOrValues(Object values) {
        this.orValues = values;
    }

    @Override
    public Compare getCompare() {
        return this.compare;
    }

    @Override
    public AutoCondition setCompare(Compare compare) {
        this.compare = compare;
        return this;
    }

    public Compare getOrCompare() {
        return this.orCompare;
    }

    @Override
    public AutoCondition setOrCompare(Compare orCompare) {
        this.orCompare = orCompare;
        return this;
    }

    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("join", this.getJoin());
        map.put("column", this.column);
        map.put("compare", this.compare.getName());
        map.put("values", this.values);
        return BeanUtil.map2json(map);
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @Override
    public Condition setRunText(String text) {
        this.text = text;
        return this;
    }
}

