/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.ds;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.data.jdbc.ds.DataSourceHolder;
import org.anyline.util.SpringContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    private Logger log = LoggerFactory.getLogger(DynamicDataSource.class);
    private static final Map<String, DataSource> dataSources = new HashMap<String, DataSource>();
    private static DataSource defaultDatasource;

    protected Object determineCurrentLookupKey() {
        return DataSourceHolder.getDataSource();
    }

    protected DataSource determineTargetDataSource() {
        DataSource dataSource = null;
        Object lookupKey = this.determineCurrentLookupKey();
        dataSource = null == lookupKey || "default".equalsIgnoreCase(lookupKey.toString()) || "datasource".equalsIgnoreCase(lookupKey.toString()) || "defaultDatasource".equalsIgnoreCase(lookupKey.toString()) ? super.determineTargetDataSource() : dataSources.get(lookupKey);
        if (null == dataSource) {
            this.log.error("[\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25][thread:{}][key:{}]", (Object)Thread.currentThread().getId(), lookupKey);
            throw new RuntimeException("\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25:" + lookupKey);
        }
        return dataSource;
    }

    public static void addDataSource(String key, DataSource ds) {
        dataSources.put(key, ds);
        DynamicDataSource.reg(key, ds);
    }

    public static void setDefaultDatasource(DataSource ds) {
        defaultDatasource = ds;
        DynamicDataSource.reg("dataSource", ds);
    }

    public static DataSource getDefaultDatasource() {
        return defaultDatasource;
    }

    public static DataSource getDatasource(String key) {
        DataSource ds = dataSources.get(key);
        return ds;
    }

    public static Map<String, DataSource> getDataSources() {
        return dataSources;
    }

    private static void reg(String key, DataSource ds) {
        ApplicationContext context = SpringContextUtil.getApplicationContext();
        if (null != context && !context.containsBean(key)) {
            ((ConfigurableApplicationContext)context).getBeanFactory().registerSingleton(key, (Object)ds);
        }
    }
}

