/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.adapter;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.entity.Column;
import org.anyline.data.entity.Constraint;
import org.anyline.data.entity.Database;
import org.anyline.data.entity.Index;
import org.anyline.data.entity.MasterTable;
import org.anyline.data.entity.PartitionTable;
import org.anyline.data.entity.Table;
import org.anyline.data.entity.Tag;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.entity.Compare;
import org.anyline.entity.DataSet;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;

public interface JDBCAdapter {
    public static final String TAB = "\t";
    public static final String BR = "\n";
    public static final String BR_TAB = "\n\t";

    public DB_TYPE type();

    public String getDelimiterFr();

    public String getDelimiterTo();

    public void setJdbc(JdbcTemplate var1);

    public Run buildInsertRun(String var1, Object var2, boolean var3, List<String> var4);

    public void createInserts(Run var1, String var2, Collection var3, List<String> var4);

    public void createInserts(Run var1, String var2, DataSet var3, List<String> var4);

    public List<String> confirmInsertColumns(String var1, Object var2, List<String> var3);

    public String batchInsertSeparator();

    public boolean supportInsertPlaceholder();

    public int insert(String var1, Object var2, String var3, List<Object> var4, String[] var5) throws Exception;

    public boolean identity(String var1, Object var2, KeyHolder var3);

    public String generatedKey();

    public Run buildUpdateRun(String var1, Object var2, ConfigStore var3, boolean var4, List<String> var5);

    public Run buildQueryRun(RunPrepare var1, ConfigStore var2, String ... var3);

    public void buildQueryRunContent(Run var1);

    public String parseFinalQuery(Run var1);

    public Object buildConditionLike(StringBuilder var1, Compare var2, Object var3);

    public Object buildConditionFindInSet(StringBuilder var1, String var2, Compare var3, Object var4);

    public StringBuilder buildConditionIn(StringBuilder var1, Compare var2, Object var3);

    public List<Map<String, Object>> process(List<Map<String, Object>> var1);

    public String parseTotalQuery(Run var1);

    public String parseExists(Run var1);

    public Run buildExecuteRun(RunPrepare var1, ConfigStore var2, String ... var3);

    public void buildExecuteRunContent(Run var1);

    public Run buildDeleteRun(String var1, Object var2, String ... var3);

    public Run buildDeleteRun(String var1, String var2, Object var3);

    public Run buildDeleteRunContent(Run var1);

    public void checkSchema(Table var1);

    public void checkSchema(Connection var1, Table var2);

    public void checkSchema(Column var1);

    public void checkSchema(Index var1);

    public void checkSchema(Constraint var1);

    public List<String> buildQueryDatabaseRunSQL() throws Exception;

    public LinkedHashMap<String, Database> databases(int var1, boolean var2, LinkedHashMap<String, Database> var3, DataSet var4) throws Exception;

    public List<String> buildQueryTableRunSQL(String var1, String var2, String var3, String var4) throws Exception;

    public LinkedHashMap<String, Table> tables(int var1, boolean var2, String var3, String var4, LinkedHashMap<String, Table> var5, DataSet var6) throws Exception;

    public LinkedHashMap<String, Table> tables(boolean var1, LinkedHashMap<String, Table> var2, DatabaseMetaData var3, String var4, String var5, String var6, String ... var7) throws Exception;

    public List<String> buildQueryMasterTableRunSQL(String var1, String var2, String var3, String var4) throws Exception;

    public LinkedHashMap<String, MasterTable> mtables(int var1, boolean var2, String var3, String var4, LinkedHashMap<String, MasterTable> var5, DataSet var6) throws Exception;

    public LinkedHashMap<String, MasterTable> mtables(boolean var1, LinkedHashMap<String, MasterTable> var2, DatabaseMetaData var3, String var4, String var5, String var6, String ... var7) throws Exception;

    public List<String> buildQueryPartitionTableRunSQL(String var1, String var2, String var3, String var4) throws Exception;

    public List<String> buildQueryPartitionTableRunSQL(MasterTable var1, Map<String, Object> var2, String var3) throws Exception;

    public List<String> buildQueryPartitionTableRunSQL(MasterTable var1, Map<String, Object> var2) throws Exception;

    public LinkedHashMap<String, PartitionTable> ptables(int var1, int var2, boolean var3, MasterTable var4, String var5, String var6, LinkedHashMap<String, PartitionTable> var7, DataSet var8) throws Exception;

    public LinkedHashMap<String, PartitionTable> ptables(boolean var1, LinkedHashMap<String, PartitionTable> var2, DatabaseMetaData var3, String var4, String var5, MasterTable var6) throws Exception;

    public List<String> buildQueryColumnRunSQL(Table var1, boolean var2) throws Exception;

    public LinkedHashMap<String, Column> columns(int var1, boolean var2, Table var3, LinkedHashMap<String, Column> var4, DataSet var5) throws Exception;

    public LinkedHashMap<String, Column> columns(boolean var1, LinkedHashMap<String, Column> var2, Table var3, SqlRowSet var4) throws Exception;

    public LinkedHashMap<String, Column> columns(boolean var1, LinkedHashMap<String, Column> var2, DatabaseMetaData var3, Table var4, String var5) throws Exception;

    public Column column(Column var1, SqlRowSetMetaData var2, int var3);

    public Column column(Column var1, ResultSetMetaData var2, int var3);

    public Column column(Column var1, ResultSet var2);

    public List<String> buildQueryTagRunSQL(Table var1, boolean var2) throws Exception;

    public LinkedHashMap<String, Tag> tags(int var1, boolean var2, Table var3, LinkedHashMap<String, Tag> var4, DataSet var5) throws Exception;

    public LinkedHashMap<String, Tag> tags(boolean var1, Table var2, LinkedHashMap<String, Tag> var3, SqlRowSet var4) throws Exception;

    public LinkedHashMap<String, Tag> tags(boolean var1, LinkedHashMap<String, Tag> var2, DatabaseMetaData var3, Table var4, String var5) throws Exception;

    public List<String> buildQueryIndexRunSQL(Table var1, boolean var2) throws Exception;

    public LinkedHashMap<String, Index> indexs(int var1, boolean var2, Table var3, LinkedHashMap<String, Index> var4, DataSet var5) throws Exception;

    public LinkedHashMap<String, Index> indexs(boolean var1, Table var2, LinkedHashMap<String, Index> var3, SqlRowSet var4) throws Exception;

    public LinkedHashMap<String, Index> indexs(boolean var1, LinkedHashMap<String, Index> var2, DatabaseMetaData var3, Table var4, boolean var5, boolean var6) throws Exception;

    public List<String> buildQueryConstraintRunSQL(Table var1, boolean var2) throws Exception;

    public LinkedHashMap<String, Constraint> constraints(int var1, boolean var2, Table var3, LinkedHashMap<String, Constraint> var4, DataSet var5) throws Exception;

    public LinkedHashMap<String, Constraint> constraints(boolean var1, Table var2, LinkedHashMap<String, Constraint> var3, SqlRowSet var4) throws Exception;

    public LinkedHashMap<String, Constraint> constraints(boolean var1, Table var2, LinkedHashMap<String, Constraint> var3, ResultSet var4) throws Exception;

    public List<String> buildCreateRunSQL(Table var1) throws Exception;

    public String buildCreateCommentRunSQL(Table var1) throws Exception;

    public List<String> buildAlterRunSQL(Table var1) throws Exception;

    public String buildRenameRunSQL(Table var1) throws Exception;

    public String buildChangeCommentRunSQL(Table var1) throws Exception;

    public String buildDropRunSQL(Table var1) throws Exception;

    public StringBuilder checkTableExists(StringBuilder var1, boolean var2);

    public StringBuilder primary(StringBuilder var1, Table var2);

    public StringBuilder comment(StringBuilder var1, Table var2);

    public StringBuilder name(StringBuilder var1, Table var2);

    public List<String> buildCreateRunSQL(MasterTable var1) throws Exception;

    public String buildCreateCommentRunSQL(MasterTable var1) throws Exception;

    public List<String> buildAlterRunSQL(MasterTable var1) throws Exception;

    public String buildRenameRunSQL(MasterTable var1) throws Exception;

    public String buildChangeCommentRunSQL(MasterTable var1) throws Exception;

    public String buildDropRunSQL(MasterTable var1) throws Exception;

    public List<String> buildCreateRunSQL(PartitionTable var1) throws Exception;

    public String buildCreateCommentRunSQL(PartitionTable var1) throws Exception;

    public List<String> buildAlterRunSQL(PartitionTable var1) throws Exception;

    public String buildRenameRunSQL(PartitionTable var1) throws Exception;

    public String buildChangeCommentRunSQL(PartitionTable var1) throws Exception;

    public String buildDropRunSQL(PartitionTable var1) throws Exception;

    public String alterColumnKeyword();

    public String buildAddRunSQL(Column var1) throws Exception;

    public List<String> buildAlterRunSQL(Column var1) throws Exception;

    public String buildDropRunSQL(Column var1) throws Exception;

    public String buildRenameRunSQL(Column var1) throws Exception;

    public List<String> buildChangeTypeRunSQL(Column var1) throws Exception;

    public String buildChangeDefaultRunSQL(Column var1) throws Exception;

    public String buildChangeNullableRunSQL(Column var1) throws Exception;

    public String buildChangeCommentRunSQL(Column var1) throws Exception;

    public String buildCreateCommentRunSQL(Column var1) throws Exception;

    public StringBuilder define(StringBuilder var1, Column var2);

    public StringBuilder type(StringBuilder var1, Column var2);

    public StringBuilder nullable(StringBuilder var1, Column var2);

    public StringBuilder charset(StringBuilder var1, Column var2);

    public StringBuilder defaultValue(StringBuilder var1, Column var2);

    public StringBuilder increment(StringBuilder var1, Column var2);

    public StringBuilder onupdate(StringBuilder var1, Column var2);

    public StringBuilder position(StringBuilder var1, Column var2);

    public StringBuilder comment(StringBuilder var1, Column var2);

    public StringBuilder checkColumnExists(StringBuilder var1, boolean var2);

    public String buildAddRunSQL(Tag var1) throws Exception;

    public List<String> buildAlterRunSQL(Tag var1) throws Exception;

    public String buildDropRunSQL(Tag var1) throws Exception;

    public String buildRenameRunSQL(Tag var1) throws Exception;

    public String buildChangeDefaultRunSQL(Tag var1) throws Exception;

    public String buildChangeNullableRunSQL(Tag var1) throws Exception;

    public String buildChangeCommentRunSQL(Tag var1) throws Exception;

    public List<String> buildChangeTypeRunSQL(Tag var1) throws Exception;

    public StringBuilder checkTagExists(StringBuilder var1, boolean var2);

    public String buildAddRunSQL(Index var1) throws Exception;

    public List<String> buildAlterRunSQL(Index var1) throws Exception;

    public String buildDropRunSQL(Index var1) throws Exception;

    public String buildRenameRunSQL(Index var1) throws Exception;

    public String buildAddRunSQL(Constraint var1) throws Exception;

    public List<String> buildAlterRunSQL(Constraint var1) throws Exception;

    public String buildDropRunSQL(Constraint var1) throws Exception;

    public String buildRenameRunSQL(Constraint var1) throws Exception;

    public String getPrimaryKey(Object var1);

    public Object getPrimaryValue(Object var1);

    public boolean convert(String var1, String var2, String var3, RunValue var4);

    public boolean convert(Map<String, Column> var1, RunValue var2);

    public boolean convert(Column var1, RunValue var2);

    public void value(StringBuilder var1, Object var2, String var3);

    public void format(StringBuilder var1, Object var2);

    public String concat(String ... var1);

    public boolean isNumberColumn(Column var1);

    public boolean isBooleanColumn(Column var1);

    public boolean isCharColumn(Column var1);

    public String buildInValue(SQL_BUILD_IN_VALUE var1);

    public String type2type(String var1);

    public String type2class(String var1);

    public static enum DB_TYPE {
        Cassandra{

            @Override
            public String getCode() {
                return "DB_TYPE_CASSANDRA";
            }

            @Override
            public String getName() {
                return "Cassandra";
            }

            @Override
            public String getDriver() {
                return "";
            }
        }
        ,
        ClickHouse{

            @Override
            public String getCode() {
                return "DB_TYPE_CLICKHOUSE";
            }

            @Override
            public String getName() {
                return "ClickHouse";
            }

            @Override
            public String getDriver() {
                return "ru.yandex.clickhouse.ClickHouseDriver";
            }
        }
        ,
        CockroachDB{

            @Override
            public String getCode() {
                return "DB_TYPE_COCKROACHDB";
            }

            @Override
            public String getName() {
                return "CockroachDB";
            }

            @Override
            public String getDriver() {
                return "";
            }
        }
        ,
        DB2{

            @Override
            public String getCode() {
                return "DB_TYPE_DB2";
            }

            @Override
            public String getName() {
                return "db2";
            }

            @Override
            public String getDriver() {
                return "com.ibm.db2.jcc.DB2Driver";
            }
        }
        ,
        Derby{

            @Override
            public String getCode() {
                return "DB_TYPE_DERBY";
            }

            @Override
            public String getName() {
                return "Derby";
            }

            @Override
            public String getDriver() {
                return "org.apache.derby.jdbc.EmbeddedDriver";
            }
        }
        ,
        DM{

            @Override
            public String getCode() {
                return "DB_TYPE_DM";
            }

            @Override
            public String getName() {
                return "\u8fbe\u68a6";
            }

            @Override
            public String getDriver() {
                return "dm.jdbc.driver.DmDriver";
            }
        }
        ,
        GBase{

            @Override
            public String getCode() {
                return "DB_TYPE_GBASE";
            }

            @Override
            public String getName() {
                return "\u5357\u5927\u901a\u7528";
            }

            @Override
            public String getDriver() {
                return "com.gbase.jdbc.Driver";
            }
        }
        ,
        H2{

            @Override
            public String getCode() {
                return "DB_TYPE_H2";
            }

            @Override
            public String getName() {
                return "H2";
            }

            @Override
            public String getDriver() {
                return "org.h2.Driver";
            }
        }
        ,
        HighGo{

            @Override
            public String getCode() {
                return "DB_TYPE_HIGHGO";
            }

            @Override
            public String getName() {
                return "\u701a\u9ad8";
            }

            @Override
            public String getDriver() {
                return "com.highgo.jdbc.Driver";
            }
        }
        ,
        HSQLDB{

            @Override
            public String getCode() {
                return "DB_TYPE_HSQLDB";
            }

            @Override
            public String getName() {
                return "HSQLDB";
            }

            @Override
            public String getDriver() {
                return "org.hsqldb.jdbcDriver";
            }
        }
        ,
        InfluxDB{

            @Override
            public String getCode() {
                return "DB_TYPE_INFLUXDB";
            }

            @Override
            public String getName() {
                return "InfluxDB";
            }

            @Override
            public String getDriver() {
                return "";
            }
        }
        ,
        KingBase{

            @Override
            public String getCode() {
                return "DB_TYPE_KINGBASE";
            }

            @Override
            public String getName() {
                return "\u4eba\u5927\u91d1\u4ed3 Oracle";
            }

            @Override
            public String getDriver() {
                return "com.kingbase8.Driver";
            }
        }
        ,
        KingBase_PostgreSQL{

            @Override
            public String getCode() {
                return "DB_TYPE_KINGBASE_POSTGRESQL";
            }

            @Override
            public String getName() {
                return "\u4eba\u5927\u91d1\u4ed3 PostgreSQL";
            }

            @Override
            public String getDriver() {
                return "";
            }
        }
        ,
        MariaDB{

            @Override
            public String getCode() {
                return "DB_TYPE_MARIADB";
            }

            @Override
            public String getName() {
                return "MariaDB";
            }

            @Override
            public String getDriver() {
                return "org.mariadb.jdbc.Driver";
            }
        }
        ,
        MongoDB{

            @Override
            public String getCode() {
                return "DB_TYPE_MONGODB";
            }

            @Override
            public String getName() {
                return "MongoDB";
            }

            @Override
            public String getDriver() {
                return "";
            }
        }
        ,
        MSSQL{

            @Override
            public String getCode() {
                return "DB_TYPE_MSSQL";
            }

            @Override
            public String getName() {
                return "mssql";
            }

            @Override
            public String getDriver() {
                return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            }
        }
        ,
        MYSQL{

            @Override
            public String getCode() {
                return "DB_TYPE_MYSQL";
            }

            @Override
            public String getName() {
                return "mysql";
            }

            @Override
            public String getDriver() {
                return "com.mysql.cj.jdbc.Driver";
            }
        }
        ,
        Neo4j{

            @Override
            public String getCode() {
                return "DB_TYPE_NEO4J";
            }

            @Override
            public String getName() {
                return "Neo4j";
            }

            @Override
            public String getDriver() {
                return "org.neo4j.jdbc.Driver";
            }
        }
        ,
        OceanBase{

            @Override
            public String getCode() {
                return "DB_TYPE_OCEANBASE";
            }

            @Override
            public String getName() {
                return "OceanBase";
            }

            @Override
            public String getDriver() {
                return "com.oceanbase.jdbc.Driver";
            }
        }
        ,
        ORACLE{

            @Override
            public String getCode() {
                return "DB_TYPE_ORACLE";
            }

            @Override
            public String getName() {
                return "oracle";
            }

            @Override
            public String getDriver() {
                return "oracle.jdbc.OracleDriver";
            }
        }
        ,
        oscar{

            @Override
            public String getCode() {
                return "DB_TYPE_OSCAR";
            }

            @Override
            public String getName() {
                return "\u795e\u821f\u901a\u7528";
            }

            @Override
            public String getDriver() {
                return "com.oscar.Driver";
            }
        }
        ,
        PolarDB{

            @Override
            public String getCode() {
                return "DB_TYPE_POLARDB";
            }

            @Override
            public String getName() {
                return "PolarDB";
            }

            @Override
            public String getDriver() {
                return "com.aliyun.polardb.Driver";
            }
        }
        ,
        PostgreSQL{

            @Override
            public String getCode() {
                return "DB_TYPE_POSTGRESQL";
            }

            @Override
            public String getName() {
                return "PostgreSQL";
            }

            @Override
            public String getDriver() {
                return "org.postgresql.Driver";
            }
        }
        ,
        QuestDB{

            @Override
            public String getCode() {
                return "DB_TYPE_QUESTDB";
            }

            @Override
            public String getName() {
                return "QuestDB";
            }

            @Override
            public String getDriver() {
                return "org.postgresql.Driver";
            }
        }
        ,
        RethinkDB{

            @Override
            public String getCode() {
                return "DB_TYPE_RETHINKDB";
            }

            @Override
            public String getName() {
                return "RethinkDB";
            }

            @Override
            public String getDriver() {
                return "";
            }
        }
        ,
        SQLite{

            @Override
            public String getCode() {
                return "DB_TYPE_SQLITE";
            }

            @Override
            public String getName() {
                return "SQLite";
            }

            @Override
            public String getDriver() {
                return "org.sqlite.JDBC";
            }
        }
        ,
        TDengine{

            @Override
            public String getCode() {
                return "DB_TYPE_TDENGINE";
            }

            @Override
            public String getName() {
                return "TDengine";
            }

            @Override
            public String getDriver() {
                return "com.taosdata.jdbc.TSDBDriver";
            }
        }
        ,
        Timescale{

            @Override
            public String getCode() {
                return "DB_TYPE_TIMESCALE";
            }

            @Override
            public String getName() {
                return "Timescale";
            }

            @Override
            public String getDriver() {
                return "org.postgresql.Driver";
            }
        };


        public abstract String getCode();

        public abstract String getName();

        public abstract String getDriver();
    }

    public static enum SQL_BUILD_IN_VALUE {
        CURRENT_TIME{

            @Override
            public String getCode() {
                return "CURRENT_TIME";
            }

            @Override
            public String getName() {
                return "\u5f53\u524d\u65f6\u95f4";
            }
        };


        public abstract String getCode();

        public abstract String getName();
    }
}

